// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewRevokeAdminTokensParams creates a new RevokeAdminTokensParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRevokeAdminTokensParams() *RevokeAdminTokensParams {
	return &RevokeAdminTokensParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRevokeAdminTokensParamsWithTimeout creates a new RevokeAdminTokensParams object
// with the ability to set a timeout on a request.
func NewRevokeAdminTokensParamsWithTimeout(timeout time.Duration) *RevokeAdminTokensParams {
	return &RevokeAdminTokensParams{
		timeout: timeout,
	}
}

// NewRevokeAdminTokensParamsWithContext creates a new RevokeAdminTokensParams object
// with the ability to set a context for a request.
func NewRevokeAdminTokensParamsWithContext(ctx context.Context) *RevokeAdminTokensParams {
	return &RevokeAdminTokensParams{
		Context: ctx,
	}
}

// NewRevokeAdminTokensParamsWithHTTPClient creates a new RevokeAdminTokensParams object
// with the ability to set a custom HTTPClient for a request.
func NewRevokeAdminTokensParamsWithHTTPClient(client *http.Client) *RevokeAdminTokensParams {
	return &RevokeAdminTokensParams{
		HTTPClient: client,
	}
}

/*
RevokeAdminTokensParams contains all the parameters to send to the API endpoint

	for the revoke admin tokens operation.

	Typically these are written to a http.Request.
*/
type RevokeAdminTokensParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125RevokeAdminTokensRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the revoke admin tokens params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeAdminTokensParams) WithDefaults() *RevokeAdminTokensParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the revoke admin tokens params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeAdminTokensParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the revoke admin tokens params
func (o *RevokeAdminTokensParams) WithTimeout(timeout time.Duration) *RevokeAdminTokensParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the revoke admin tokens params
func (o *RevokeAdminTokensParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the revoke admin tokens params
func (o *RevokeAdminTokensParams) WithContext(ctx context.Context) *RevokeAdminTokensParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the revoke admin tokens params
func (o *RevokeAdminTokensParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the revoke admin tokens params
func (o *RevokeAdminTokensParams) WithHTTPClient(client *http.Client) *RevokeAdminTokensParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the revoke admin tokens params
func (o *RevokeAdminTokensParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the revoke admin tokens params
func (o *RevokeAdminTokensParams) WithBody(body *models.HashicorpCloudVault20201125RevokeAdminTokensRequest) *RevokeAdminTokensParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the revoke admin tokens params
func (o *RevokeAdminTokensParams) SetBody(body *models.HashicorpCloudVault20201125RevokeAdminTokensRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the revoke admin tokens params
func (o *RevokeAdminTokensParams) WithClusterID(clusterID string) *RevokeAdminTokensParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the revoke admin tokens params
func (o *RevokeAdminTokensParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the revoke admin tokens params
func (o *RevokeAdminTokensParams) WithLocationOrganizationID(locationOrganizationID string) *RevokeAdminTokensParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the revoke admin tokens params
func (o *RevokeAdminTokensParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the revoke admin tokens params
func (o *RevokeAdminTokensParams) WithLocationProjectID(locationProjectID string) *RevokeAdminTokensParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the revoke admin tokens params
func (o *RevokeAdminTokensParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *RevokeAdminTokensParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
