// Code generated by go-swagger; DO NOT EDIT.

package iam_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// IamServiceListUserPrincipalsByOrganizationReader is a Reader for the IamServiceListUserPrincipalsByOrganization structure.
type IamServiceListUserPrincipalsByOrganizationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IamServiceListUserPrincipalsByOrganizationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIamServiceListUserPrincipalsByOrganizationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIamServiceListUserPrincipalsByOrganizationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIamServiceListUserPrincipalsByOrganizationOK creates a IamServiceListUserPrincipalsByOrganizationOK with default headers values
func NewIamServiceListUserPrincipalsByOrganizationOK() *IamServiceListUserPrincipalsByOrganizationOK {
	return &IamServiceListUserPrincipalsByOrganizationOK{}
}

/*
IamServiceListUserPrincipalsByOrganizationOK describes a response with status code 200, with default header values.

A successful response.
*/
type IamServiceListUserPrincipalsByOrganizationOK struct {
	Payload *models.HashicorpCloudIamListUserPrincipalsByOrganizationResponse
}

// IsSuccess returns true when this iam service list user principals by organization o k response has a 2xx status code
func (o *IamServiceListUserPrincipalsByOrganizationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iam service list user principals by organization o k response has a 3xx status code
func (o *IamServiceListUserPrincipalsByOrganizationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iam service list user principals by organization o k response has a 4xx status code
func (o *IamServiceListUserPrincipalsByOrganizationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iam service list user principals by organization o k response has a 5xx status code
func (o *IamServiceListUserPrincipalsByOrganizationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iam service list user principals by organization o k response a status code equal to that given
func (o *IamServiceListUserPrincipalsByOrganizationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iam service list user principals by organization o k response
func (o *IamServiceListUserPrincipalsByOrganizationOK) Code() int {
	return 200
}

func (o *IamServiceListUserPrincipalsByOrganizationOK) Error() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/user-principals][%d] iamServiceListUserPrincipalsByOrganizationOK  %+v", 200, o.Payload)
}

func (o *IamServiceListUserPrincipalsByOrganizationOK) String() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/user-principals][%d] iamServiceListUserPrincipalsByOrganizationOK  %+v", 200, o.Payload)
}

func (o *IamServiceListUserPrincipalsByOrganizationOK) GetPayload() *models.HashicorpCloudIamListUserPrincipalsByOrganizationResponse {
	return o.Payload
}

func (o *IamServiceListUserPrincipalsByOrganizationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamListUserPrincipalsByOrganizationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIamServiceListUserPrincipalsByOrganizationDefault creates a IamServiceListUserPrincipalsByOrganizationDefault with default headers values
func NewIamServiceListUserPrincipalsByOrganizationDefault(code int) *IamServiceListUserPrincipalsByOrganizationDefault {
	return &IamServiceListUserPrincipalsByOrganizationDefault{
		_statusCode: code,
	}
}

/*
IamServiceListUserPrincipalsByOrganizationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IamServiceListUserPrincipalsByOrganizationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this iam service list user principals by organization default response has a 2xx status code
func (o *IamServiceListUserPrincipalsByOrganizationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iam service list user principals by organization default response has a 3xx status code
func (o *IamServiceListUserPrincipalsByOrganizationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iam service list user principals by organization default response has a 4xx status code
func (o *IamServiceListUserPrincipalsByOrganizationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iam service list user principals by organization default response has a 5xx status code
func (o *IamServiceListUserPrincipalsByOrganizationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iam service list user principals by organization default response a status code equal to that given
func (o *IamServiceListUserPrincipalsByOrganizationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iam service list user principals by organization default response
func (o *IamServiceListUserPrincipalsByOrganizationDefault) Code() int {
	return o._statusCode
}

func (o *IamServiceListUserPrincipalsByOrganizationDefault) Error() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/user-principals][%d] IamService_ListUserPrincipalsByOrganization default  %+v", o._statusCode, o.Payload)
}

func (o *IamServiceListUserPrincipalsByOrganizationDefault) String() string {
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/user-principals][%d] IamService_ListUserPrincipalsByOrganization default  %+v", o._statusCode, o.Payload)
}

func (o *IamServiceListUserPrincipalsByOrganizationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *IamServiceListUserPrincipalsByOrganizationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
