/*
# <<BEGIN-copyright>>
# <<END-copyright>>
*/

#if defined __cplusplus
    namespace GIDI {
#endif

#define e_Mass 5.4857990943e-4              /* electron mass in AMU */

#define Al26_Mass 25.986891692
#define Al26_e1Level_Mass 2.45095e-4        /* Al26 first nuclear level (228305 eV/c**2) in amu */

#define Cl34_Mass 33.973762819
#define Cl34_e1Level_Mass 1.57124e-4        /* Cl34 first nuclear level (146360 eV/c**2) in amu */

#define Co58_Mass 5.7935752814e+01
#define Co58_e1Level_Mass 2.67205e-05       /* Co58 first nuclear level (24890 eV/c**2) in amu */

#define Ag110_Mass 1.09906107231e+02
#define Ag110_e2Level_Mass 1.2624e-04       /* Ag110 second nuclear level (117590 eV/c**2) in amu */

#define Cd115_Mass 1.14905430969e+02
#define Cd115_e1Level_Mass 1.9431e-04       /* Cd155 first nuclear level (1.81e5 eV/c**2) in amu */

#define Te127_Mass 1.26905226336e+02
#define Te127_e2Level_Mass 9.4751e-05       /* Te127 second nuclear level (88260 eV/c**2) in amu */

#define Te129_Mass 1.28906598238e+02
#define Te129_e1Level_Mass 1.1302e-04       /* Te129 second nuclear level (105280 eV/c**2) in amu */

#define Pm148_Mass 1.47917474618e+02
#define Pm148_e2Level_Mass 1.4804e-04       /* Pm148 second nuclear level (137900 eV/c**2) in amu */

#define Ho166_Mass 1.65932284162e+02
#define Ho166_e1Level_Mass 6.4252e-06       /* Ho166first nuclear level (5985 eV/c**2) in amu */


#define Am242_Mass 2.42059549159e+02
#define Am242_e2Level_Mass 5.153e-05        /* Am242's second nuclear level (48000 eV/c**2) in amu */

#define Am244_Mass 2.44064284847e+02
#define Am244_e1Level_Mass 9.4472e-05       /* Am244's second nuclear level (87999.9 eV/c**2) in amu */

#define Es254_Mass 2.54088022021e+02
#define Es254_e2Level_Mass 9.0392e-05       /* Es254 second nuclear level (84200 eV/c**2) in amu */

#define Na24_Mass 23.990962782
#define Na24_e1Level_Mass 5.07024e-04       /* Na24 first nuclear level (472290 eV/c**2) in amu */

#define Sc46_Mass 45.95517189
#define Sc46_e1Level_Mass 1.52980e-04       /* Sc46 first nuclear level (142500 eV/c**2) in amu */

#define Mn52_Mass 51.945565464
#define Mn52_e1Level_Mass 4.05478e-04       /* Mn52 first nuclear level (377700 eV/c**2) in amu */

#define Pb187_Mass 186.98391837
#define Pb187_e1Level_Mass 8.69571e-05      /* Pb187 first nuclear level (8.1e4 eV/c**2/c**2) in amu */
#define Pb191_Mass 190.978265
#define Pb191_e1Level_Mass 1.48149e-04      /* Pb191 first nuclear level (1.38e5 eV/c**2/c**2) in amu */
#define Pb193_Mass 192.976173234
#define Pb193_e1Level_Mass 1.07354e-06      /* Pb193 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Pb195_Mass 194.97454205
#define Pb195_e2Level_Mass 2.17822e-04      /* Pb195 second nuclear level (202900 eV/c**2/c**2) in amu */
#define Pb197_Mass 196.973431124
#define Pb197_e2Level_Mass 3.42793e-04      /* Pb197 second nuclear level (319310 eV/c**2/c**2) in amu */
#define Pb199_Mass 198.97291665
#define Pb199_e1Level_Mass 1.07354e-06      /* Pb199 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Pb201_Mass 200.972884511
#define Pb201_e4Level_Mass 6.75366e-04      /* Pb201 fourth nuclear level (629100 eV/c**2/c**2) in amu */
#define Pb202_Mass 201.972159133
#define Pb202_e13Level_Mass 2.32938e-03      /* Pb202 13th nuclear level (2169800 eV/c**2/c**2) in amu */
#define Pb203_Mass 202.973390521
#define Pb203_e6Level_Mass 8.85888e-04      /* Pb203 sixth nuclear level (825200 eV/c**2/c**2) in amu */
#define Pb204_Mass 203.973043589
#define Pb204_e21Level_Mass 2.34654e-03      /* Pb204 21th nuclear level (2185790 eV/c**2/c**2) in amu */
#define Pb207_Mass 206.975896887
#define Pb207_e3Level_Mass 1.75353e-03      /* Pb207 third nuclear level (1633400 eV/c**2/c**2) in amu */

#define Tl186_Mass 185.978325
#define Tl186_e1Level_Mass 1.07354e-06      /* Tl186 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Tl187_Mass 186.975905897
#define Tl187_e2Level_Mass 3.59647e-04      /* Tl187 second nuclear level (335009 eV/c**2/c**2) in amu */
#define Tl188_Mass 187.976009782
#define Tl188_e1Level_Mass 1.07354e-06      /* Tl188 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Tl189_Mass 188.973588428
#define Tl189_e1Level_Mass 2.76545e-04      /* Tl189 first nuclear level (257600 eV/c**2/c**2) in amu */
#define Tl190_Mass 189.973877149
#define Tl190_e1Level_Mass 1.07354e-06      /* Tl190 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Tl191_Mass 190.971786154
#define Tl191_e1Level_Mass 1.07354e-06      /* Tl191 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Tl192_Mass 191.972225
#define Tl192_e1Level_Mass 1.67473e-04      /* Tl192 first nuclear level (1.56e5 eV/c**2/c**2) in amu */
#define Tl193_Mass 192.970672
#define Tl193_e1Level_Mass 1.07354e-06      /* Tl193 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Tl194_Mass 193.9712
#define Tl194_e1Level_Mass 1.07354e-06      /* Tl194 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Tl195_Mass 194.969774335
#define Tl195_e2Level_Mass 5.18124e-04      /* Tl195 second nuclear level (482630 eV/c**2/c**2) in amu */
#define Tl196_Mass 195.970481151
#define Tl196_e6Level_Mass 4.23191e-04      /* Tl196 sixth nuclear level (394200 eV/c**2/c**2) in amu */
#define Tl198_Mass 197.970483495
#define Tl198_e7Level_Mass 5.83471e-04      /* Tl198 seventh nuclear level (543500 eV/c**2/c**2) in amu */
#define Tl207_Mass 206.977419429
#define Tl207_e2Level_Mass 1.44724e-03      /* Tl207 second nuclear level (1348100 eV/c**2/c**2) in amu */

#define Hg185_Mass 184.971899086
#define Hg185_e4Level_Mass 1.06603e-04      /* Hg185 fourth nuclear level (99300 eV/c**2/c**2) in amu */
#define Hg187_Mass 186.969814236
#define Hg187_e1Level_Mass 1.07354e-06      /* Hg187 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Hg189_Mass 188.968190034
#define Hg189_e2Level_Mass 1.07354e-06      /* Hg189 second nuclear level (1e3 eV/c**2/c**2) in amu */
#define Hg191_Mass 190.967157105
#define Hg191_e1Level_Mass 1.07354e-06      /* Hg191 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Hg193_Mass 192.966665421
#define Hg193_e3Level_Mass 1.51112e-04      /* Hg193 third nuclear level (140760 eV/c**2/c**2) in amu */
#define Hg195_Mass 194.966720113
#define Hg195_e3Level_Mass 1.89019e-04      /* Hg195 third nuclear level (176070 eV/c**2/c**2) in amu */
#define Hg197_Mass 196.967212908
#define Hg197_e4Level_Mass 3.20914e-04      /* Hg197 fourth nuclear level (298930 eV/c**2/c**2) in amu */
#define Hg199_Mass 198.968279932
#define Hg199_e7Level_Mass 5.71641e-04      /* Hg199 seventh nuclear level (532480 eV/c**2/c**2) in amu */

#define Au185_Mass 184.965789411
#define Au185_e1Level_Mass 1.07354e-06      /* Au185 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Au187_Mass 186.964567541
#define Au187_e2Level_Mass 1.29373e-04      /* Au187 second nuclear level (120510 eV/c**2/c**2) in amu */
#define Au189_Mass 188.963948286
#define Au189_e3Level_Mass 2.65412e-04      /* Au189 thrid nuclear level (247230 eV/c**2/c**2) in amu */
#define Au193_Mass 192.964149715
#define Au193_e4Level_Mass 3.11532e-04      /* Au193 fourth nuclear level (290190 eV/c**2/c**2) in amu */
#define Au195_Mass 194.96503464
#define Au195_e4Level_Mass 3.42010e-04      /* Au195 fourth nuclear level (318580 eV/c**2/c**2) in amu */
#define Au196_Mass 195.966569813
#define Au196_e3Level_Mass 9.08819e-05      /* Au196 third nuclear level (84656 eV/c**2/c**2) in amu */
#define Au197_Mass 196.966568662
#define Au197_e4Level_Mass 4.39240e-04      /* Au197 fourth nuclear level (409150 eV/c**2/c**2) in amu */
#define Au200_Mass 199.970725647
#define Au200_e11Level_Mass 1.03275e-03      /* Au200 11th nuclear level (9.62e5 eV/c**2/c**2) in amu */

#define Pt183_Mass 182.961596703
#define Pt183_e1Level_Mass 3.70373e-05      /* Pt183 first nuclear level (34500 eV/c**2/c**2) in amu */
#define Pt185_Mass 184.960619
#define Pt185_e2Level_Mass 1.11015e-04      /* Pt185 second nuclear level (103410 eV/c**2/c**2) in amu */
#define Pt193_Mass 192.962987401
#define Pt193_e5Level_Mass 1.60795e-04      /* Pt193 fifth nuclear level (149780 eV/c**2/c**2) in amu */
#define Pt195_Mass 194.964791134
#define Pt195_e7Level_Mass 2.78370e-04      /* Pt195 seventh nuclear level (259300 eV/c**2/c**2) in amu */
#define Pt197_Mass 196.967340182
#define Pt197_e9Level_Mass 4.28977e-04      /* Pt197 nineth nuclear level (399590 eV/c**2/c**2) in amu */
#define Pt199_Mass 198.970593094
#define Pt199_e8Level_Mass 4.55183e-04      /* Pt199 eighth nuclear level (4.24e5 eV/c**2/c**2) in amu */

#define Os181_Mass 180.953244
#define Os181_e1Level_Mass 5.28184e-05      /* Os181 first nuclear level (49200 eV/c**2/c**2) in amu */
#define Os183_Mass 182.953126102
#define Os183_e2Level_Mass 1.83265e-04      /* Os183 second nuclear level (170710 eV/c**2/c**2) in amu */
#define Os189_Mass 188.95814747
#define Os189_e1Level_Mass 3.30780e-05      /* Os189 first nuclear level (30812 eV/c**2/c**2) in amu */
#define Os191_Mass 190.960929718
#define Os191_e1Level_Mass 7.98523e-05      /* Os191 first nuclear level (74382 eV/c**2/c**2) in amu */

#define Np236_Mass 236.0465696
#define Np236_e2Level_Mass 1.98606e-04      /* Np236 second nuclear level (1.85e5 eV/c**2/c**2) in amu */

/*
Special symbols for undefined elements.
     Z   Symbol
    -----------
    113  Uut
    114  Uuq    Now Fl
    115  Uup
    116  Uuh    Now Lv
    117  Uus
    118  Uuo
*/

struct PoPDatas {
    char const *name;
    enum PoPs_genre genre;
    int Z, N, nuclearLevel;
    double mass;
};

/* Most of the mass data from Ame2003 */


#define Zn69_Mass 68.926550281
#define Zn69_e1Level_Mass 4.68685e-04       /* Mn52 first nuclear level (436577 eV/c**2) in amu */

#define Y88_Mass 87.909501146
#define Y88_e2Level_Mass 4.20829e-04        /* Y88 second nuclear level (3.92e5 eV/c**2) in amu */
#define Y88_e3Level_Mass 7.24642e-04        /* Y88 third nuclear level (6.75e5 eV/c**2) in amu */
#define Y89_Mass 88.905848295
#define Y89_e1Level_Mass 9.75808e-04        /* Y89 first nuclear level (908960 eV/c**2) in amu */
#define Y90_Mass 89.907151886
#define Y90_e1Level_Mass 7.31803e-04        /* Y90 first nuclear level (681670 eV/c**2) in amu */

#define Rb86_Mass 85.911167419
#define Rb86_e1Level_Mass 5.96890e-04       /* Rb86 first nuclear level (5.56e5 eV/c**2) in amu */

#define Zr89_Mass 8.89088895e+01 
#define Zr89_e1Level_Mass 6.31244e-04       /* Zr89 first nuclear level (5.88e5 eV/c**2) in amu */

#define Sr87_Mass 86.908877124
#define Sr87_e1Level_Mass 4.17107e-04       /* Sr87 first nuclear level (388533 eV/c**2) in amu */

#define Rb90_Mass 89.914801694
#define Rb90_e1Level_Mass 1.14869e-04       /* Rb90 first nuclear level (1.07e5 eV/c**2) in amu */

#define Nb93_Mass 92.906378058
#define Nb93_e1Level_Mass 3.29900e-05       /* Nb93 first nuclear level (30730 eV/c**2) in amu */

#define In116_Mass 115.905259703
#define In116_e1Level_Mass 1.36630e-04      /* In116 first nuclear level (127269.7 eV/c**2) in amu */

#define Sb124_Mass 123.905935743
#define Sb124_e1Level_Mass 1.16619e-05      /* Sb124 first nuclear level (10863 eV/c**2/c**2) in amu */
#define Sb124_e2Level_Mass 3.95558e-05      /* Sb124 second nuclear level (36846 eV/c**2/c**2) in amu */

#define Ho163_Mass 162.928733903
#define Ho163_e1Level_Mass 3.19809e-04      /* Ho163 first nuclear level (297900 eV/c**2/c**2) in amu */
#define Ho164_Mass 163.930233507
#define Ho164_e1Level_Mass 1.50081e-04      /* Ho164 first nuclear level (139800 eV/c**2/c**2) in amu */
#define Er167_Mass 166.932048159
#define Er167_e1Level_Mass 2.23082e-04      /* Er167 first nuclear level (207800 eV/c**2/c**2) in amu */

#define Dy165_Mass 164.931703333
#define Dy165_e1Level_Mass 1.16157e-04      /* Dy165 first nuclear level (108200 eV/c**2/c**2) in amu */


#define Yb169_Mass 168.935189802
#define Yb169_e1Level_Mass 2.59798e-05      /* Yb169 first nuclear level (24200 eV/c**2/c**2) in amu */
#define Yb176_Mass 175.942571683
#define Yb176_e1Level_Mass 1.12722e-03      /* Yb176 first nuclear level (1.05e6 eV/c**2/c**2) in amu */
#define Yb177_Mass 176.945260822
#define Yb177_e1Level_Mass 3.55880e-04      /* Yb177 first nuclear level (331500 eV/c**2/c**2) in amu */

#define Lu169_Mass 168.937651439
#define Lu169_e1Level_Mass 3.11328e-05      /* Lu169 first nuclear level (2.9e4 eV/c**2/c**2) in amu */
#define Lu171_Mass 170.937913136
#define Lu171_e1Level_Mass 7.64363e-05      /* Lu171 first nuclear level (71200 eV/c**2/c**2) in amu */
#define Lu172_Mass 171.939085669
#define Lu172_e1Level_Mass 4.49815e-05      /* Lu172 first nuclear level (41900 eV/c**2/c**2) in amu */
#define Lu174_Mass 173.94033748
#define Lu174_e1Level_Mass 1.83361e-04      /* Lu174 first nuclear level (170800 eV/c**2/c**2) in amu */
#define Lu176_Mass 175.94268631
#define Lu176_e1Level_Mass 1.32046e-04      /* Lu176 first nuclear level (1.23e5 eV/c**2/c**2) in amu */
#define Lu177_Mass 176.943758055
#define Lu177_e1Level_Mass 1.04155e-03      /* Lu177 first nuclear level (970200 eV/c**2/c**2) in amu */
#define Lu178_Mass 177.945954559
#define Lu178_e1Level_Mass 1.28825e-04      /* Lu178 first nuclear level (1.2e5 eV/c**2/c**2) in amu */

#define Hf178_Mass 177.943698766
#define Hf178_e1Level_Mass 1.23178e-03      /* Hf178 first nuclear level (1147400 eV/c**2/c**2) in amu */
#define Hf179_Mass 178.945816145
#define Hf179_e1Level_Mass 4.02579e-04      /* Hf179 first nuclear level (3.75e5 eV/c**2/c**2) in amu */
#define Hf180_Mass 179.946549953
#define Hf180_e1Level_Mass 1.22545e-03      /* Hf180 first nuclear level (1141500 eV/c**2/c**2) in amu */
#define Hf182_Mass 181.950554096
#define Hf182_e1Level_Mass 1.25916e-03      /* Hf182 first nuclear level (1172900 eV/c**2/c**2) in amu */

#define Ta180_Mass 179.947464831
#define Ta180_e2Level_Mass 8.08379e-05      /* Ta180 second nuclear level (75300 eV/c**2/c**2) in amu */
#define Ta182_Mass 181.950151849
#define Ta182_e26Level_Mass 5.57781e-04      /* Ta182 26th nuclear level (519570 eV/c**2/c**2) in amu */

#define W179_Mass 178.947070447
#define W179_e1Level_Mass 2.38219e-04      /* W179 first nuclear level (221900 eV/c**2/c**2) in amu */
#define W183_Mass 182.950222951
#define W183_e1Level_Mass 3.32262e-04      /* W183 first nuclear level (309500 eV/c**2/c**2) in amu */
#define W185_Mass 184.953419264
#define W185_e1Level_Mass 2.11918e-04      /* W185 first nuclear level (197400 eV/c**2/c**2) in amu */

#define Tm176_Mass 175.946994685
#define Tm176_e1Level_Mass 1.12722e-03      /* Tm176 first nuclear level (1.05e6 eV/c**2/c**2) in amu */

#define Ir186_Mass 185.957946104
#define Ir186_e1Level_Mass 1.07354e-06      /* Ir186 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Ir190_Mass 189.960545968
#define Ir190_e1Level_Mass 2.79121e-05      /* Ir190 first nuclear level (2.6e4 eV/c**2/c**2) in amu */
#define Ir190_e2Level_Mass 3.88086e-05      /* Ir190 second nuclear level (36150 eV/c**2/c**2) in amu */
#define Ir190_e3Level_Mass 4.04082e-04      /* Ir190 third nuclear level (376400 eV/c**2/c**2) in amu */
#define Ir190_e37Level_Mass 4.04082e-04      /* Ir190 37th nuclear level (376400 eV/c**2/c**2) in amu */
#define Ir191_Mass 190.960594046
#define Ir191_e3Level_Mass 1.83834e-04      /* Ir191 third nuclear level (171240 eV/c**2/c**2) in amu */
#define Ir192_Mass 191.962605012
#define Ir192_e3Level_Mass 6.08914e-05      /* Ir192 third nuclear level (56720 eV/c**2/c**2) in amu */
#define Ir192_e7Level_Mass 1.80506e-04      /* Ir192 7th nuclear level (168140 eV/c**2/c**2) in amu */
#define Ir192_e16Level_Mass 1.80506e-04      /* Ir192 16th nuclear level (168140 eV/c**2/c**2) in amu */
#define Ir193_Mass 192.96292643
#define Ir193_e2Level_Mass 8.61197e-05      /* Ir193 second nuclear level (80220 eV/c**2/c**2) in amu */
#define Ir194_Mass 193.965078378
#define Ir194_e7Level_Mass 1.57888e-04      /* Ir194 seventh nuclear level (147072 eV/c**2/c**2) in amu */
#define Ir195_Mass 194.965979573
#define Ir195_e2Level_Mass 1.07354e-04      /* Ir195 second nuclear level (1e5 eV/c**2/c**2) in amu */
#define Ir196_Mass 195.968396542
#define Ir196_e4Level_Mass 4.40153e-04      /* Ir196 first nuclear level (4.1e5 eV/c**2/c**2) in amu */
#define Ir197_Mass 196.969653285
#define Ir197_e2Level_Mass 1.23458e-04      /* Ir197 first nuclear level (1.15e5 eV/c**2/c**2) in amu */

#define Re182_Mass 181.95121008
#define Re182_e1Level_Mass 1.07354e-06      /* Re182 first nuclear level (1e3 eV/c**2/c**2) in amu */
#define Re184_Mass 183.952520756
#define Re184_e5Level_Mass 2.01837e-04      /* Re184 fifth nuclear level (188010 eV/c**2/c**2) in amu */
#define Re186_Mass 185.954986084
#define Re186_e4Level_Mass 1.59958e-04      /* Re186 fourth nuclear level (1.49e5 eV/c**2/c**2) in amu */
#define Re188_Mass 187.958114438
#define Re188_e7Level_Mass 1.84724e-04      /* Re188 seventh nuclear level (172069 eV/c**2/c**2) in amu */
#define Re190_Mass 189.961817977
#define Re190_e3Level_Mass 2.25444e-04      /* Re190 third nuclear level (2.1e5 eV/c**2/c**2) in amu */

static struct PoPDatas PoPDatas[] = {
    { "c12",               PoPs_genre_nucleus,  6,   6, 0,  11.99671 },             /* Mass from Scott McKinley. */
/* Needed by ENDF/B-VII.1 W186 but not in Wadi, et al. */
    { "Tm180",             PoPs_genre_atom,    69, 111, 0,  179.95792495 },
    { "Pt203",             PoPs_genre_atom,    78, 125, 0,  202.976969588582 },
    { "Na24_e1",           PoPs_genre_atom,    11,  13, 1,  Na24_Mass + Na24_e1Level_Mass },
{ "Sc46_e1",        PoPs_genre_atom,   21,  25, 1,  Sc46_Mass + Sc46_e1Level_Mass },    
{ "Mn52_e1",        PoPs_genre_atom,   25,  27, 1,  Mn52_Mass + Mn52_e1Level_Mass },
{ "Zn69_e1",        PoPs_genre_atom,   30,  39, 1,  Zn69_Mass + Zn69_e1Level_Mass },
{ "Y88_e2",         PoPs_genre_atom,   39,  49, 2,  Y88_Mass + Y88_e2Level_Mass },   
{ "Y88_e3",         PoPs_genre_atom,   39,  49, 3,  Y88_Mass + Y88_e3Level_Mass },   
{ "Y89_e1",         PoPs_genre_atom,   39,  50, 1,  Y89_Mass + Y89_e1Level_Mass},   
{ "Y90_e1",         PoPs_genre_atom,   39,  51, 1,  Y90_Mass + Y90_e1Level_Mass },   
{ "Rb86_e1",        PoPs_genre_atom,   37,  49, 1,  Rb86_Mass + Rb86_e1Level_Mass },   
{ "Zr89_e1",        PoPs_genre_atom,   40,  49, 1,  Zr89_Mass + Zr89_e1Level_Mass },     
{ "Sr87_e1",        PoPs_genre_atom,   38,  49, 1,  Sr87_Mass + Sr87_e1Level_Mass },   
{ "Rb90_e1",        PoPs_genre_atom,   37,  53, 1,  Rb90_Mass + Rb90_e1Level_Mass },
{ "Nb93_e1",        PoPs_genre_atom,   41,  52, 1,  Nb93_Mass + Nb93_e1Level_Mass },   
{ "In116_e1",       PoPs_genre_atom,   49,  67, 1,  In116_Mass + In116_e1Level_Mass },  
{ "Sb124_e1",       PoPs_genre_atom,   51,  73, 1,  Sb124_Mass + Sb124_e1Level_Mass },
{ "Sb124_e2",       PoPs_genre_atom,   51,  73, 2,  Sb124_Mass + Sb124_e2Level_Mass },
{ "Ho163_e1",       PoPs_genre_atom,   67,  96, 1,  Ho163_Mass + Ho163_e1Level_Mass },  
{ "Ho164_e1",       PoPs_genre_atom,   67,  97, 1,  Ho164_Mass + Ho164_e1Level_Mass },  
{ "Er167_e1",       PoPs_genre_atom,   68,  99, 1,  Er167_Mass + Er167_e1Level_Mass },  
{ "Dy165_e1",       PoPs_genre_atom,   66,  99, 1,  Dy165_Mass + Dy165_e1Level_Mass },
{ "Hf178_e1",       PoPs_genre_atom,   72, 106, 1,  Hf178_Mass + Hf178_e1Level_Mass },  

{ "Hf179_e1",       PoPs_genre_atom,   72, 107, 1,  Hf179_Mass + Hf179_e1Level_Mass },
{ "Hf179_e5",       PoPs_genre_atom,   72, 107, 5,  Hf179_Mass + Hf179_e1Level_Mass },

{ "Hf180_e1",       PoPs_genre_atom,   72, 108, 1,  Hf180_Mass + Hf180_e1Level_Mass },
{ "Hf180_e7",       PoPs_genre_atom,   72, 108, 7,  Hf180_Mass + Hf180_e1Level_Mass },

{ "Hf182_e1",       PoPs_genre_atom,   72, 110, 7,  Hf182_Mass + Hf182_e1Level_Mass },

{ "Ta180_e1",       PoPs_genre_atom,   73, 107, 1,  Ta180_Mass + Ta180_e2Level_Mass },
{ "Ta180_e2",       PoPs_genre_atom,   73, 107, 2,  Ta180_Mass + Ta180_e2Level_Mass },

{ "Ta182_e26",      PoPs_genre_atom,   73, 109, 26,  Ta182_Mass + Ta182_e26Level_Mass },
{ "Ta182_e1",       PoPs_genre_atom,   73, 109, 1,  Ta182_Mass + Ta182_e26Level_Mass },

{ "W179_e1",        PoPs_genre_atom,   74, 105, 1,  W179_Mass + W179_e1Level_Mass },  
{ "W179_e2",        PoPs_genre_atom,   74, 105, 2,  W179_Mass + W179_e1Level_Mass },  

{ "W183_e1",        PoPs_genre_atom,   74, 105, 1,  W183_Mass + W183_e1Level_Mass },  
{ "W183_e7",        PoPs_genre_atom,   74, 105, 7,  W183_Mass + W183_e1Level_Mass },  

{ "W185_e1",        PoPs_genre_atom,   74, 105, 1,  W185_Mass + W185_e1Level_Mass },  
{ "W185_e6",        PoPs_genre_atom,   74, 105, 6,  W185_Mass + W185_e1Level_Mass },  

{ "Yb169_e1",       PoPs_genre_atom,   70,  99, 1, Yb169_Mass + Yb169_e1Level_Mass },
{ "Yb176_e1",       PoPs_genre_atom,   70,  99, 1, Yb176_Mass + Yb176_e1Level_Mass },
{ "Yb177_e1",       PoPs_genre_atom,   70,  99, 1, Yb177_Mass + Yb177_e1Level_Mass },
{ "Lu169_e1",       PoPs_genre_atom,   71,  98, 1,  Lu169_Mass + Lu169_e1Level_Mass },  
{ "Lu171_e1",       PoPs_genre_atom,   71, 100, 1,  Lu171_Mass + Lu171_e1Level_Mass },  
{ "Lu172_e1",       PoPs_genre_atom,   71, 101, 1,  Lu172_Mass + Lu172_e1Level_Mass },
{ "Lu174_e1",       PoPs_genre_atom,   71, 103, 1,  Lu174_Mass + Lu174_e1Level_Mass },   
{ "Lu176_e1",       PoPs_genre_atom,   71, 105, 1,  Lu176_Mass + Lu176_e1Level_Mass },
{ "Lu177_e1",       PoPs_genre_atom,   71, 106, 1,  Lu177_Mass + Lu177_e1Level_Mass },  
{ "Lu178_e1",       PoPs_genre_atom,   71, 107, 1,  Lu178_Mass + Lu178_e1Level_Mass },  
{ "Tm176_e1",       PoPs_genre_atom,    69, 107, 1, Tm176_Mass + Tm176_e1Level_Mass },
{ "Ir186_e1",       PoPs_genre_atom,   77, 109, 1,  Ir186_Mass + Ir186_e1Level_Mass },  
{ "Ir190_e1",       PoPs_genre_atom,   77, 113, 1,  Ir190_Mass + Ir190_e1Level_Mass },  
{ "Ir190_e2",       PoPs_genre_atom,   77, 113, 2,  Ir190_Mass + Ir190_e2Level_Mass },  
{ "Ir190_e3",       PoPs_genre_atom,   77, 113, 3,  Ir190_Mass + Ir190_e3Level_Mass },  
{ "Ir190_e37",      PoPs_genre_atom,   77, 113, 37,  Ir190_Mass + Ir190_e37Level_Mass },  
{ "Ir191_e3",       PoPs_genre_atom,   77, 114, 3,  Ir191_Mass + Ir191_e3Level_Mass },  
{ "Ir192_e3",       PoPs_genre_atom,   77, 115, 7,  Ir192_Mass + Ir192_e3Level_Mass },  
{ "Ir192_e7",       PoPs_genre_atom,   77, 115, 7,  Ir192_Mass + Ir192_e7Level_Mass },  
{ "Ir192_e16",      PoPs_genre_atom,   77, 115, 7,  Ir192_Mass + Ir192_e16Level_Mass },  
{ "Ir193_e2",       PoPs_genre_atom,   77, 116, 2,  Ir193_Mass + Ir193_e2Level_Mass },  
{ "Ir194_e7",       PoPs_genre_atom,   77, 117, 7,  Ir194_Mass + Ir194_e7Level_Mass },  
{ "Ir195_e2",       PoPs_genre_atom,   77, 118, 2,  Ir195_Mass + Ir195_e2Level_Mass },  
{ "Ir196_e4",       PoPs_genre_atom,   77, 119, 4,  Ir196_Mass + Ir196_e4Level_Mass },
{ "Ir197_e2",       PoPs_genre_atom,   77, 120, 2,  Ir197_Mass + Ir197_e2Level_Mass },  
{ "Pb187_e1",       PoPs_genre_atom,   82, 105, 1,  Pb187_Mass + Pb187_e1Level_Mass },
{ "Pb191_e1",       PoPs_genre_atom,   82, 109, 1,  Pb191_Mass + Pb191_e1Level_Mass },
{ "Pb193_e1",       PoPs_genre_atom,   82, 111, 1,  Pb193_Mass + Pb193_e1Level_Mass },
{ "Pb195_e2",       PoPs_genre_atom,   82, 113, 2,  Pb195_Mass + Pb195_e2Level_Mass },
{ "Pb197_e2",       PoPs_genre_atom,   82, 115, 2,  Pb197_Mass + Pb197_e2Level_Mass },
{ "Pb199_e1",       PoPs_genre_atom,   82, 117, 1,  Pb199_Mass + Pb199_e1Level_Mass },
{ "Pb201_e4",       PoPs_genre_atom,   82, 119, 4,  Pb201_Mass + Pb201_e4Level_Mass },
{ "Pb202_e13",      PoPs_genre_atom,   82, 120, 13,  Pb202_Mass + Pb202_e13Level_Mass },
{ "Pb203_e6",       PoPs_genre_atom,   82, 121, 6,  Pb203_Mass + Pb203_e6Level_Mass },
{ "Pb204_e21",      PoPs_genre_atom,   82, 122, 21,  Pb204_Mass + Pb204_e21Level_Mass },
{ "Pb207_e3",       PoPs_genre_atom,   82, 125, 3,  Pb207_Mass + Pb207_e3Level_Mass },  
{ "Tl186_e1",       PoPs_genre_atom,   81, 105, 1,  Tl186_Mass + Tl186_e1Level_Mass },
{ "Tl187_e2",       PoPs_genre_atom,   81, 106, 2,  Tl187_Mass + Tl187_e2Level_Mass },  
{ "Tl188_e1",       PoPs_genre_atom,   81, 107, 1,  Tl188_Mass + Tl188_e1Level_Mass },  
{ "Tl189_e1",       PoPs_genre_atom,   81, 108, 1,  Tl189_Mass + Tl189_e1Level_Mass },  
{ "Tl190_e1",       PoPs_genre_atom,   81, 109, 1,  Tl190_Mass + Tl190_e1Level_Mass },
{ "Tl191_e1",       PoPs_genre_atom,   81, 110, 1,  Tl191_Mass + Tl191_e1Level_Mass },  
{ "Tl192_e1",       PoPs_genre_atom,   81, 111, 1,  Tl192_Mass + Tl192_e1Level_Mass },     
{ "Tl193_e1",       PoPs_genre_atom,   81, 112, 1,  Tl193_Mass + Tl193_e1Level_Mass },     
{ "Tl194_e1",       PoPs_genre_atom,   81, 113, 1,  Tl194_Mass + Tl194_e1Level_Mass },
{ "Tl195_e2",       PoPs_genre_atom,   81, 114, 2,  Tl195_Mass + Tl195_e2Level_Mass },  
{ "Tl196_e6",       PoPs_genre_atom,   81, 115, 6,  Tl196_Mass + Tl196_e6Level_Mass },  
{ "Tl198_e7",       PoPs_genre_atom,   81, 117, 7,  Tl198_Mass + Tl198_e7Level_Mass },
{ "Tl207_e2",       PoPs_genre_atom,   81, 126, 2,  Tl207_Mass + Tl207_e2Level_Mass },  
{ "Re182_e1",       PoPs_genre_atom,   75, 107, 1,  Re182_Mass + Re182_e1Level_Mass },
{ "Re184_e5",       PoPs_genre_atom,   75, 109, 5,  Re184_Mass + Re184_e5Level_Mass },
{ "Re186_e4",       PoPs_genre_atom,   75, 111, 4,  Re186_Mass + Re186_e4Level_Mass },
{ "Re188_e7",       PoPs_genre_atom,   75, 113, 7,  Re188_Mass + Re188_e7Level_Mass },
{ "Re190_e3",       PoPs_genre_atom,   75, 115, 3, Re190_Mass + Re190_e3Level_Mass },  
{ "Hg185_e4",       PoPs_genre_atom,   80, 105, 4,  Hg185_Mass + Hg185_e4Level_Mass },  
{ "Hg187_e1",       PoPs_genre_atom,   80, 107, 1,  Hg187_Mass + Hg187_e1Level_Mass },  
{ "Hg189_e2",       PoPs_genre_atom,   80, 109, 2,  Hg189_Mass + Hg189_e2Level_Mass },  
{ "Hg191_e1",       PoPs_genre_atom,   80, 111, 1,  Hg191_Mass + Hg191_e1Level_Mass },  
{ "Hg193_e3",       PoPs_genre_atom,   80, 113, 3,  Hg193_Mass + Hg193_e3Level_Mass },  
{ "Hg195_e3",       PoPs_genre_atom,   80, 115, 3,  Hg195_Mass + Hg195_e3Level_Mass },  
{ "Hg197_e4",       PoPs_genre_atom,   80, 117, 4,  Hg197_Mass + Hg197_e4Level_Mass },  
{ "Hg199_e7",       PoPs_genre_atom,   80, 119, 7,  Hg199_Mass + Hg199_e7Level_Mass },  
{ "Au185_e1",       PoPs_genre_atom,   79, 106, 1,  Au185_Mass + Au185_e1Level_Mass},  
{ "Au187_e2",       PoPs_genre_atom,   79, 108, 2,  Au187_Mass + Au187_e2Level_Mass },  
{ "Au189_e3",       PoPs_genre_atom,   79, 110, 3,  Au189_Mass + Au189_e3Level_Mass },  
{ "Au193_e4",       PoPs_genre_atom,   79, 114, 4,  Au193_Mass + Au193_e4Level_Mass },  
{ "Au195_e4",       PoPs_genre_atom,   79, 116, 4,  Au195_Mass + Au195_e4Level_Mass },   
{ "Au196_e3",       PoPs_genre_atom,   79, 117, 3,  Au196_Mass + Au196_e3Level_Mass },  
{ "Au197_e4",       PoPs_genre_atom,   79, 118, 4,  Au197_Mass + Au197_e4Level_Mass },  
{ "Au200_e11",      PoPs_genre_atom,   79, 121, 11,  Au200_Mass + Au200_e11Level_Mass },  
{ "Pt183_e1",       PoPs_genre_atom,   78, 105, 1,  Pt183_Mass + Pt183_e1Level_Mass },  
{ "Pt185_e2",       PoPs_genre_atom,   78, 107, 2,  Pt185_Mass + Pt185_e2Level_Mass },
{ "Pt193_e5",       PoPs_genre_atom,   78, 115, 5,  Pt193_Mass + Pt193_e5Level_Mass },
{ "Pt195_e7",       PoPs_genre_atom,   78, 117, 7,  Pt195_Mass + Pt195_e7Level_Mass },  
{ "Pt197_e9",       PoPs_genre_atom,   78, 119, 9,  Pt197_Mass + Pt197_e9Level_Mass },
{ "Pt199_e8",       PoPs_genre_atom,   78, 121, 8,  Pt199_Mass + Pt199_e8Level_Mass },  
{ "Os181_e1",       PoPs_genre_atom,   76, 105, 1,  Os181_Mass + Os181_e1Level_Mass },     
{ "Os183_e2",       PoPs_genre_atom,   76, 107, 2,  Os183_Mass + Os183_e2Level_Mass },  
{ "Os189_e1",       PoPs_genre_atom,   76, 113, 1,  Os189_Mass + Os189_e1Level_Mass },   
{ "Os191_e1",       PoPs_genre_atom,   76, 115, 1,  Os191_Mass + Os191_e1Level_Mass },  
{ "Np236_e2",       PoPs_genre_atom,   93, 143, 2,  Np236_Mass + Np236_e2Level_Mass },

    { "Al26_e1",           PoPs_genre_atom,    27,  31, 1,  Al26_Mass + Al26_e1Level_Mass },
    { "Cl34_e1",           PoPs_genre_atom,    27,  31, 1,  Cl34_Mass + Cl34_e1Level_Mass },
    { "Co58_e1",           PoPs_genre_atom,    27,  31, 1,  Co58_Mass + Co58_e1Level_Mass },
    { "Ag110_e2",          PoPs_genre_atom,    47,  63, 2,  Ag110_Mass + Ag110_e2Level_Mass },
    { "Cd115_e1",          PoPs_genre_atom,    48,  67, 1,  Cd115_Mass + Cd115_e1Level_Mass },
    { "Te127_e2",          PoPs_genre_atom,    52,  75, 2,  Te127_Mass + Te127_e2Level_Mass },
    { "Te129_e1",          PoPs_genre_atom,    52,  77, 1,  Te129_Mass + Te129_e1Level_Mass },
    { "Pm148_e2",          PoPs_genre_atom,    61,  87, 2,  Pm148_Mass + Pm148_e2Level_Mass },
    { "Ho166_e1",          PoPs_genre_atom,    67,  99, 1,  Ho166_Mass + Ho166_e1Level_Mass },
    { "Am242_e2",          PoPs_genre_atom,    95, 147, 2,  Am242_Mass + Am242_e2Level_Mass },
    { "Am244_e1",          PoPs_genre_atom,    95, 149, 1,  Am244_Mass + Am244_e1Level_Mass },
    { "Es254_e2",          PoPs_genre_atom,    99, 155, 2,  Es254_Mass + Es254_e2Level_Mass },
/* Mass data from LLNL's bdfls file. */
    { "FissionProductENDL99120",     PoPs_genre_atom, 99, 21, 0, 117.5 },
    { "FissionProductENDL99121",     PoPs_genre_atom, 99, 22, 0, 116.546 },
    { "FissionProductENDL99122",     PoPs_genre_atom, 99, 23, 0, 118.544 },
    { "FissionProductENDL99125",     PoPs_genre_atom, 99, 26, 0, 117.5 },
/* Mass data from ?. */
    { "photon",             PoPs_genre_photon,  0,   0, 0,  0. },
    { "e-",                 PoPs_genre_lepton,  0,   0, 0,  e_Mass },
    { "e+",                 PoPs_genre_lepton,  0,   0, 0,  e_Mass },
/* The rest are mass data from Wadi, et al 2003. */
    { "n",                  PoPs_genre_baryon,  0,   1, 0,  1.00866491574e+00 },
    { "p",                  PoPs_genre_baryon,  1,   0, 0,  1.007276466812e+00 },
    { "h2",                 PoPs_genre_nucleus, 1,   1, 0,  2.01355321271e+00 },
    { "h3",                 PoPs_genre_nucleus, 1,   2, 0,  3.015500713e+00 }, 
    { "he3",                PoPs_genre_nucleus, 2,   1, 0,  3.01493223469e+00 },  
    { "he4",                PoPs_genre_nucleus, 2,   2, 0,  4.0015061747e+00 }, 
    { "H_natural",          PoPs_genre_atom,    1,  -1, 0,  1.0079e+00 },         
    { "H1",                 PoPs_genre_atom,    1,   0, 0,  1.00782503207e+00 },  
    { "H2",                 PoPs_genre_atom,    1,   1, 0,  2.01410177785e+00 },
    { "H3",                 PoPs_genre_atom,    1,   2, 0,  3.01604927767e+00 },  
    { "H4",                 PoPs_genre_atom,    1,   3, 0,  4.027806424e+00 },    
    { "H5",                 PoPs_genre_atom,    1,   4, 0,  5.035311488e+00 },    
    { "H6",                 PoPs_genre_atom,    1,   5, 0,  6.044942594e+00 },
    { "H7",                 PoPs_genre_atom,    1,   6, 0,  7.052749e+00 },       
    { "He_natural",         PoPs_genre_atom,    2,  -1, 0,  4.0026e+00 },         
    { "He3",                PoPs_genre_atom,    2,   1, 0,  3.01602931914e+00 },  
    { "He4",                PoPs_genre_atom,    2,   2, 0,  4.00260325415e+00 },
    { "He5",                PoPs_genre_atom,    2,   3, 0,  5.012223624e+00 },    
    { "He6",                PoPs_genre_atom,    2,   4, 0,  6.018889124e+00 },    
    { "He7",                PoPs_genre_atom,    2,   5, 0,  7.028020618e+00 },    
    { "He8",                PoPs_genre_atom,    2,   6, 0,  8.033921897e+00 },
    { "He9",                PoPs_genre_atom,    2,   7, 0,  9.043950286e+00 },    
    { "He10",               PoPs_genre_atom,    2,   8, 0,  1.0052398837e+01 },   
    { "Li_natural",         PoPs_genre_atom,    3,  -1, 0,  6.941e+00 },          
    { "Li3",                PoPs_genre_atom,    3,   0, 0,  3.030775e+00 },
    { "Li4",                PoPs_genre_atom,    3,   1, 0,  4.027185558e+00 },    
    { "Li5",                PoPs_genre_atom,    3,   2, 0,  5.0125378e+00 },      
    { "Li6",                PoPs_genre_atom,    3,   3, 0,  6.015122794e+00 },    
    { "Li7",                PoPs_genre_atom,    3,   4, 0,  7.016004548e+00 },
    { "Li8",                PoPs_genre_atom,    3,   5, 0,  8.022487362e+00 },    
    { "Li9",                PoPs_genre_atom,    3,   6, 0,  9.026789505e+00 },    
    { "Li10",               PoPs_genre_atom,    3,   7, 0,  1.0035481259e+01 },   
    { "Li11",               PoPs_genre_atom,    3,   8, 0,  1.1043797715e+01 },
    { "Li12",               PoPs_genre_atom,    3,   9, 0,  1.205378e+01 },       
    { "Be_natural",         PoPs_genre_atom,    4,  -1, 0,  9.01218e+00 },        
    { "Be5",                PoPs_genre_atom,    4,   1, 0,  5.04079e+00 },        
    { "Be6",                PoPs_genre_atom,    4,   2, 0,  6.019726317e+00 },
    { "Be7",                PoPs_genre_atom,    4,   3, 0,  7.016929828e+00 },    
    { "Be8",                PoPs_genre_atom,    4,   4, 0,  8.005305103e+00 },    
    { "Be9",                PoPs_genre_atom,    4,   5, 0,  9.012182201e+00 },    
    { "Be10",               PoPs_genre_atom,    4,   6, 0,  1.0013533818e+01 },
    { "Be11",               PoPs_genre_atom,    4,   7, 0,  1.1021657749e+01 },   
    { "Be12",               PoPs_genre_atom,    4,   8, 0,  1.2026920737e+01 },   
    { "Be13",               PoPs_genre_atom,    4,   9, 0,  1.3035693007e+01 },   
    { "Be14",               PoPs_genre_atom,    4,  10, 0,  1.404289292e+01 },
    { "Be15",               PoPs_genre_atom,    4,  11, 0,  1.505346e+01 },       
    { "Be16",               PoPs_genre_atom,    4,  12, 0,  1.606192e+01 },       
    { "B_natural",          PoPs_genre_atom,    5,  -1, 0,  1.081e+01 },          
    { "B6",                 PoPs_genre_atom,    5,   1, 0,  6.04681e+00 },
    { "B7",                 PoPs_genre_atom,    5,   2, 0,  7.029917901e+00 },    
    { "B8",                 PoPs_genre_atom,    5,   3, 0,  8.024607233e+00 },    
    { "B9",                 PoPs_genre_atom,    5,   4, 0,  9.013328782e+00 },    
    { "B10",                PoPs_genre_atom,    5,   5, 0,  1.0012936992e+01 },
    { "B11",                PoPs_genre_atom,    5,   6, 0,  1.1009305406e+01 },   
    { "B12",                PoPs_genre_atom,    5,   7, 0,  1.2014352104e+01 },   
    { "B13",                PoPs_genre_atom,    5,   8, 0,  1.3017780217e+01 },   
    { "B14",                PoPs_genre_atom,    5,   9, 0,  1.4025404009e+01 },
    { "B15",                PoPs_genre_atom,    5,  10, 0,  1.5031103021e+01 },   
    { "B16",                PoPs_genre_atom,    5,  11, 0,  1.6039808829e+01 },   
    { "B17",                PoPs_genre_atom,    5,  12, 0,  1.7046989906e+01 },   
    { "B18",                PoPs_genre_atom,    5,  13, 0,  1.805617e+01 },
    { "B19",                PoPs_genre_atom,    5,  14, 0,  1.906373e+01 },       
    { "C_natural",          PoPs_genre_atom,    6,  -1, 0,  1.2011e+01 },         
    { "C8",                 PoPs_genre_atom,    6,   2, 0,  8.037675025e+00 },    
    { "C9",                 PoPs_genre_atom,    6,   3, 0,  9.031036689e+00 },
    { "C10",                PoPs_genre_atom,    6,   4, 0,  1.0016853228e+01 },   
    { "C11",                PoPs_genre_atom,    6,   5, 0,  1.1011433613e+01 },   
    { "C12",                PoPs_genre_atom,    6,   6, 0,  1.2e+01 },            
    { "C13",                PoPs_genre_atom,    6,   7, 0,  1.300335483778e+01 },
    { "C14",                PoPs_genre_atom,    6,   8, 0,  1.40032419887e+01 },  
    { "C15",                PoPs_genre_atom,    6,   9, 0,  1.5010599256e+01 },   
    { "C16",                PoPs_genre_atom,    6,  10, 0,  1.6014701252e+01 },   
    { "C17",                PoPs_genre_atom,    6,  11, 0,  1.7022586116e+01 },
    { "C18",                PoPs_genre_atom,    6,  12, 0,  1.8026759354e+01 },   
    { "C19",                PoPs_genre_atom,    6,  13, 0,  1.9034805018e+01 },   
    { "C20",                PoPs_genre_atom,    6,  14, 0,  2.0040319754e+01 },   
    { "C21",                PoPs_genre_atom,    6,  15, 0,  2.104934e+01 },
    { "C23",                PoPs_genre_atom,    6,  17, 0,  2.20572e+01 },        
    { "N_natural",          PoPs_genre_atom,    7,  -1, 0,  1.40067e+01 },        
    { "N10",                PoPs_genre_atom,    7,   3, 0,  1.0041653674e+01 },   
    { "N11",                PoPs_genre_atom,    7,   4, 0,  1.1026090956e+01 },
    { "N12",                PoPs_genre_atom,    7,   5, 0,  1.2018613197e+01 },   
    { "N13",                PoPs_genre_atom,    7,   6, 0,  1.3005738609e+01 },   
    { "N14",                PoPs_genre_atom,    7,   7, 0,  1.400307400478e+01 }, 
    { "N15",                PoPs_genre_atom,    7,   8, 0,  1.500010889823e+01 },
    { "N16",                PoPs_genre_atom,    7,   9, 0,  1.6006101658e+01 },   
    { "N17",                PoPs_genre_atom,    7,  10, 0,  1.7008450261e+01 },   
    { "N18",                PoPs_genre_atom,    7,  11, 0,  1.8014078959e+01 },   
    { "N19",                PoPs_genre_atom,    7,  12, 0,  1.9017028697e+01 },
    { "N20",                PoPs_genre_atom,    7,  13, 0,  2.0023365807e+01 },   
    { "N21",                PoPs_genre_atom,    7,  14, 0,  2.102710824e+01 },    
    { "N22",                PoPs_genre_atom,    7,  15, 0,  2.2034394934e+01 },   
    { "N23",                PoPs_genre_atom,    7,  16, 0,  2.304122e+01 },
    { "N24",                PoPs_genre_atom,    7,  17, 0,  2.405104e+01 },       
    { "N25",                PoPs_genre_atom,    7,  18, 0,  2.506066e+01 },       
    { "O_natural",          PoPs_genre_atom,    8,  -1, 0,  1.59994e+01 },        
    { "O12",                PoPs_genre_atom,    8,   4, 0,  1.2034404895e+01 },
    { "O13",                PoPs_genre_atom,    8,   5, 0,  1.3024812213e+01 },   
    { "O14",                PoPs_genre_atom,    8,   6, 0,  1.400859625e+01 },    
    { "O15",                PoPs_genre_atom,    8,   7, 0,  1.5003065617e+01 },   
    { "O16",                PoPs_genre_atom,    8,   8, 0,  1.599491461956e+01 },
    { "O17",                PoPs_genre_atom,    8,   9, 0,  1.6999131703e+01 },   
    { "O18",                PoPs_genre_atom,    8,  10, 0,  1.7999161001e+01 },   
    { "O19",                PoPs_genre_atom,    8,  11, 0,  1.900358013e+01 },    
    { "O20",                PoPs_genre_atom,    8,  12, 0,  2.0004076742e+01 },
    { "O21",                PoPs_genre_atom,    8,  13, 0,  2.1008655886e+01 },   
    { "O22",                PoPs_genre_atom,    8,  14, 0,  2.2009966947e+01 },   
    { "O23",                PoPs_genre_atom,    8,  15, 0,  2.3015687659e+01 },   
    { "O24",                PoPs_genre_atom,    8,  16, 0,  2.4020472917e+01 },
    { "O25",                PoPs_genre_atom,    8,  17, 0,  2.502946e+01 },       
    { "O26",                PoPs_genre_atom,    8,  18, 0,  2.603834e+01 },       
    { "O27",                PoPs_genre_atom,    8,  19, 0,  2.704826e+01 },       
    { "O28",                PoPs_genre_atom,    8,  20, 0,  2.805781e+01 },
    { "F_natural",          PoPs_genre_atom,    9,  -1, 0,  1.8998403e+01 },      
    { "F14",                PoPs_genre_atom,    9,   5, 0,  1.403506e+01 },       
    { "F15",                PoPs_genre_atom,    9,   6, 0,  1.5018009103e+01 },   
    { "F16",                PoPs_genre_atom,    9,   7, 0,  1.6011465724e+01 },
    { "F17",                PoPs_genre_atom,    9,   8, 0,  1.7002095237e+01 },   
    { "F18",                PoPs_genre_atom,    9,   9, 0,  1.8000937956e+01 },   
    { "F19",                PoPs_genre_atom,    9,  10, 0,  1.8998403224e+01 },   
    { "F20",                PoPs_genre_atom,    9,  11, 0,  1.9999981315e+01 },
    { "F21",                PoPs_genre_atom,    9,  12, 0,  2.0999948951e+01 },   
    { "F22",                PoPs_genre_atom,    9,  13, 0,  2.2002998815e+01 },   
    { "F23",                PoPs_genre_atom,    9,  14, 0,  2.3003574631e+01 },   
    { "F24",                PoPs_genre_atom,    9,  15, 0,  2.4008115485e+01 },
    { "F25",                PoPs_genre_atom,    9,  16, 0,  2.5012101747e+01 },   
    { "F26",                PoPs_genre_atom,    9,  17, 0,  2.6019615555e+01 },   
    { "F27",                PoPs_genre_atom,    9,  18, 0,  2.7026760086e+01 },   
    { "F28",                PoPs_genre_atom,    9,  19, 0,  2.803567e+01 },
    { "F29",                PoPs_genre_atom,    9,  20, 0,  2.904326e+01 },       
    { "F30",                PoPs_genre_atom,    9,  21, 0,  3.00525e+01 },        
    { "F31",                PoPs_genre_atom,    9,  22, 0,  3.1060429e+01 },      
    { "Ne_natural",         PoPs_genre_atom,   10,  -1, 0,  2.0179e+01 },
    { "Ne16",               PoPs_genre_atom,   10,   6, 0,  1.6025761262e+01 },   
    { "Ne17",               PoPs_genre_atom,   10,   7, 0,  1.7017671504e+01 },   
    { "Ne18",               PoPs_genre_atom,   10,   8, 0,  1.8005708213e+01 },   
    { "Ne19",               PoPs_genre_atom,   10,   9, 0,  1.9001880248e+01 },
    { "Ne20",               PoPs_genre_atom,   10,  10, 0,  1.999244017542e+01 }, 
    { "Ne21",               PoPs_genre_atom,   10,  11, 0,  2.0993846684e+01 },   
    { "Ne22",               PoPs_genre_atom,   10,  12, 0,  2.1991385113e+01 },   
    { "Ne23",               PoPs_genre_atom,   10,  13, 0,  2.2994466904e+01 },
    { "Ne24",               PoPs_genre_atom,   10,  14, 0,  2.3993610779e+01 },   
    { "Ne25",               PoPs_genre_atom,   10,  15, 0,  2.4997736888e+01 },   
    { "Ne26",               PoPs_genre_atom,   10,  16, 0,  2.6000461206e+01 },   
    { "Ne27",               PoPs_genre_atom,   10,  17, 0,  2.7007589903e+01 },
    { "Ne28",               PoPs_genre_atom,   10,  18, 0,  2.8012071575e+01 },   
    { "Ne29",               PoPs_genre_atom,   10,  19, 0,  2.9019385933e+01 },   
    { "Ne30",               PoPs_genre_atom,   10,  20, 0,  3.0024801045e+01 },   
    { "Ne31",               PoPs_genre_atom,   10,  21, 0,  3.103311e+01 },
    { "Ne32",               PoPs_genre_atom,   10,  22, 0,  3.204002e+01 },       
    { "Ne33",               PoPs_genre_atom,   10,  23, 0,  3.304938e+01 },       
    { "Ne34",               PoPs_genre_atom,   10,  24, 0,  3.4057028e+01 },      
    { "Na_natural",         PoPs_genre_atom,   11,  -1, 0,  2.298977e+01 },
    { "Na18",               PoPs_genre_atom,   11,   7, 0,  1.8025969e+01 },      
    { "Na19",               PoPs_genre_atom,   11,   8, 0,  1.9013877499e+01 },   
    { "Na20",               PoPs_genre_atom,   11,   9, 0,  2.0007351328e+01 },   
    { "Na21",               PoPs_genre_atom,   11,  10, 0,  2.0997655206e+01 },
    { "Na22",               PoPs_genre_atom,   11,  11, 0,  2.1994436425e+01 },   
    { "Na23",               PoPs_genre_atom,   11,  12, 0,  2.298976928087e+01 }, 
    { "Na24",               PoPs_genre_atom,   11,  13, 0,  Na24_Mass },   
    { "Na25",               PoPs_genre_atom,   11,  14, 0,  2.4989953968e+01 },
    { "Na26",               PoPs_genre_atom,   11,  15, 0,  2.5992633e+01 },      
    { "Na27",               PoPs_genre_atom,   11,  16, 0,  2.6994076788e+01 },   
    { "Na28",               PoPs_genre_atom,   11,  17, 0,  2.7998938e+01 },      
    { "Na29",               PoPs_genre_atom,   11,  18, 0,  2.9002861e+01 },
    { "Na30",               PoPs_genre_atom,   11,  19, 0,  3.0008976e+01 },      
    { "Na31",               PoPs_genre_atom,   11,  20, 0,  3.1013585452e+01 },   
    { "Na32",               PoPs_genre_atom,   11,  21, 0,  3.202046656e+01 },    
    { "Na33",               PoPs_genre_atom,   11,  22, 0,  3.3026719756e+01 },
    { "Na34",               PoPs_genre_atom,   11,  23, 0,  3.403517e+01 },       
    { "Na35",               PoPs_genre_atom,   11,  24, 0,  3.5042493e+01 },      
    { "Na36",               PoPs_genre_atom,   11,  25, 0,  3.605148e+01 },       
    { "Na37",               PoPs_genre_atom,   11,  26, 0,  3.705934e+01 },
    { "Mg_natural",         PoPs_genre_atom,   12,  -1, 0,  2.4305e+01 },         
    { "Mg18",               PoPs_genre_atom,   12,   6, 0,  1.80470024124726e+01 },     /* From ENDF/B-VII.1 'gamma + Mg24'. */
    { "Mg19",               PoPs_genre_atom,   12,   7, 0,  1.903547e+01 },       
    { "Mg20",               PoPs_genre_atom,   12,   8, 0,  2.0018862545e+01 },   
    { "Mg21",               PoPs_genre_atom,   12,   9, 0,  2.101171291e+01 },
    { "Mg22",               PoPs_genre_atom,   12,  10, 0,  2.1999573843e+01 },   
    { "Mg23",               PoPs_genre_atom,   12,  11, 0,  2.2994123669e+01 },   
    { "Mg24",               PoPs_genre_atom,   12,  12, 0,  2.3985041699e+01 },   
    { "Mg25",               PoPs_genre_atom,   12,  13, 0,  2.4985836917e+01 },
    { "Mg26",               PoPs_genre_atom,   12,  14, 0,  2.5982592929e+01 },   
    { "Mg27",               PoPs_genre_atom,   12,  15, 0,  2.6984340585e+01 },   
    { "Mg28",               PoPs_genre_atom,   12,  16, 0,  2.7983876825e+01 },   
    { "Mg29",               PoPs_genre_atom,   12,  17, 0,  2.89886e+01 },
    { "Mg30",               PoPs_genre_atom,   12,  18, 0,  2.9990434e+01 },      
    { "Mg31",               PoPs_genre_atom,   12,  19, 0,  3.0996546e+01 },      
    { "Mg32",               PoPs_genre_atom,   12,  20, 0,  3.1998975e+01 },      
    { "Mg33",               PoPs_genre_atom,   12,  21, 0,  3.3005254e+01 },
    { "Mg34",               PoPs_genre_atom,   12,  22, 0,  3.4009456424e+01 },   
    { "Mg35",               PoPs_genre_atom,   12,  23, 0,  3.501734e+01 },       
    { "Mg36",               PoPs_genre_atom,   12,  24, 0,  3.6023e+01 },         
    { "Mg37",               PoPs_genre_atom,   12,  25, 0,  3.70314e+01 },
    { "Mg38",               PoPs_genre_atom,   12,  26, 0,  3.803757e+01 },       
    { "Mg39",               PoPs_genre_atom,   12,  27, 0,  3.9046772e+01 },      
    { "Mg40",               PoPs_genre_atom,   12,  28, 0,  4.005393e+01 },       
    { "Al_natural",         PoPs_genre_atom,   13,  -1, 0,  2.698154e+01 },
    { "Al21",               PoPs_genre_atom,   13,   8, 0,  2.102804e+01 },       
    { "Al22",               PoPs_genre_atom,   13,   9, 0,  2.201952e+01 },       
    { "Al23",               PoPs_genre_atom,   13,  10, 0,  2.3007267432e+01 },   
    { "Al24",               PoPs_genre_atom,   13,  11, 0,  2.3999938865e+01 },
    { "Al25",               PoPs_genre_atom,   13,  12, 0,  2.4990428095e+01 },   
    { "Al26",               PoPs_genre_atom,   13,  13, 0,  2.5986891692e+01 },   
    { "Al27",               PoPs_genre_atom,   13,  14, 0,  2.6981538627e+01 },   
    { "Al28",               PoPs_genre_atom,   13,  15, 0,  2.7981910306e+01 },
    { "Al29",               PoPs_genre_atom,   13,  16, 0,  2.8980445046e+01 },   
    { "Al30",               PoPs_genre_atom,   13,  17, 0,  2.9982960256e+01 },   
    { "Al31",               PoPs_genre_atom,   13,  18, 0,  3.0983946619e+01 },   
    { "Al32",               PoPs_genre_atom,   13,  19, 0,  3.1988124489e+01 },
    { "Al33",               PoPs_genre_atom,   13,  20, 0,  3.2990843336e+01 },   
    { "Al34",               PoPs_genre_atom,   13,  21, 0,  3.3996851837e+01 },   
    { "Al35",               PoPs_genre_atom,   13,  22, 0,  3.4999860235e+01 },   
    { "Al36",               PoPs_genre_atom,   13,  23, 0,  3.6006207204e+01 },
    { "Al37",               PoPs_genre_atom,   13,  24, 0,  3.701067782e+01 },    
    { "Al38",               PoPs_genre_atom,   13,  25, 0,  3.8017231021e+01 },   
    { "Al39",               PoPs_genre_atom,   13,  26, 0,  3.902297e+01 },       
    { "Al40",               PoPs_genre_atom,   13,  27, 0,  4.003145e+01 },
    { "Al41",               PoPs_genre_atom,   13,  28, 0,  4.103833e+01 },       
    { "Al42",               PoPs_genre_atom,   13,  29, 0,  4.204689e+01 },       
    { "Si_natural",         PoPs_genre_atom,   14,  -1, 0,  2.80855e+01 },        
    { "Si22",               PoPs_genre_atom,   14,   8, 0,  2.203453e+01 },
    { "Si23",               PoPs_genre_atom,   14,   9, 0,  2.302552e+01 },       
    { "Si24",               PoPs_genre_atom,   14,  10, 0,  2.4011545616e+01 },   
    { "Si25",               PoPs_genre_atom,   14,  11, 0,  2.5004105574e+01 },   
    { "Si26",               PoPs_genre_atom,   14,  12, 0,  2.5992329921e+01 },
    { "Si27",               PoPs_genre_atom,   14,  13, 0,  2.6986704905e+01 },   
    { "Si28",               PoPs_genre_atom,   14,  14, 0,  2.797692653246e+01 }, 
    { "Si29",               PoPs_genre_atom,   14,  15, 0,  2.89764947e+01 },     
    { "Si30",               PoPs_genre_atom,   14,  16, 0,  2.9973770171e+01 },
    { "Si31",               PoPs_genre_atom,   14,  17, 0,  3.0975363227e+01 },   
    { "Si32",               PoPs_genre_atom,   14,  18, 0,  3.1974148082e+01 },   
    { "Si33",               PoPs_genre_atom,   14,  19, 0,  3.297800022e+01 },    
    { "Si34",               PoPs_genre_atom,   14,  20, 0,  3.3978575524e+01 },
    { "Si35",               PoPs_genre_atom,   14,  21, 0,  3.4984583575e+01 },   
    { "Si36",               PoPs_genre_atom,   14,  22, 0,  3.5986599477e+01 },   
    { "Si37",               PoPs_genre_atom,   14,  23, 0,  3.699293608e+01 },    
    { "Si38",               PoPs_genre_atom,   14,  24, 0,  3.7995633601e+01 },
    { "Si39",               PoPs_genre_atom,   14,  25, 0,  3.9002070013e+01 },   
    { "Si40",               PoPs_genre_atom,   14,  26, 0,  4.0005869121e+01 },   
    { "Si41",               PoPs_genre_atom,   14,  27, 0,  4.101456e+01 },       
    { "Si42",               PoPs_genre_atom,   14,  28, 0,  4.201979e+01 },
    { "Si43",               PoPs_genre_atom,   14,  29, 0,  4.302866e+01 },       
    { "Si44",               PoPs_genre_atom,   14,  30, 0,  4.403526e+01 },       
    { "P_natural",          PoPs_genre_atom,   15,  -1, 0,  3.097376e+01 },       
    { "P24",                PoPs_genre_atom,   15,   9, 0,  2.403435e+01 },
    { "P25",                PoPs_genre_atom,   15,  10, 0,  2.502026e+01 },       
    { "P26",                PoPs_genre_atom,   15,  11, 0,  2.601178e+01 },       
    { "P27",                PoPs_genre_atom,   15,  12, 0,  2.6999230236e+01 },   
    { "P28",                PoPs_genre_atom,   15,  13, 0,  2.7992314761e+01 },
    { "P29",                PoPs_genre_atom,   15,  14, 0,  2.8981800606e+01 },   
    { "P30",                PoPs_genre_atom,   15,  15, 0,  2.9978313789e+01 },   
    { "P31",                PoPs_genre_atom,   15,  16, 0,  3.0973761629e+01 },   
    { "P32",                PoPs_genre_atom,   15,  17, 0,  3.1973907274e+01 },
    { "P33",                PoPs_genre_atom,   15,  18, 0,  3.2971725543e+01 },   
    { "P34",                PoPs_genre_atom,   15,  19, 0,  3.3973636257e+01 },   
    { "P35",                PoPs_genre_atom,   15,  20, 0,  3.4973314117e+01 },   
    { "P36",                PoPs_genre_atom,   15,  21, 0,  3.597825968e+01 },
    { "P37",                PoPs_genre_atom,   15,  22, 0,  3.6979608946e+01 },   
    { "P38",                PoPs_genre_atom,   15,  23, 0,  3.7984156827e+01 },   
    { "P39",                PoPs_genre_atom,   15,  24, 0,  3.8986179475e+01 },   
    { "P40",                PoPs_genre_atom,   15,  25, 0,  3.9991296951e+01 },
    { "P41",                PoPs_genre_atom,   15,  26, 0,  4.0994335435e+01 },   
    { "P42",                PoPs_genre_atom,   15,  27, 0,  4.2001007913e+01 },   
    { "P43",                PoPs_genre_atom,   15,  28, 0,  4.300619e+01 },       
    { "P44",                PoPs_genre_atom,   15,  29, 0,  4.401299e+01 },
    { "P45",                PoPs_genre_atom,   15,  30, 0,  4.501922e+01 },       
    { "P46",                PoPs_genre_atom,   15,  31, 0,  4.602738e+01 },       
    { "S_natural",          PoPs_genre_atom,   16,  -1, 0,  3.206e+01 },          
    { "S26",                PoPs_genre_atom,   16,  10, 0,  2.602788e+01 },
    { "S27",                PoPs_genre_atom,   16,  11, 0,  2.7018833e+01 },      
    { "S28",                PoPs_genre_atom,   16,  12, 0,  2.8004372763e+01 },   
    { "S29",                PoPs_genre_atom,   16,  13, 0,  2.8996608049e+01 },   
    { "S30",                PoPs_genre_atom,   16,  14, 0,  2.9984903249e+01 },
    { "S31",                PoPs_genre_atom,   16,  15, 0,  3.0979554728e+01 },   
    { "S32",                PoPs_genre_atom,   16,  16, 0,  3.1972070999e+01 },   
    { "S33",                PoPs_genre_atom,   16,  17, 0,  3.2971458759e+01 },   
    { "S34",                PoPs_genre_atom,   16,  18, 0,  3.3967866902e+01 },
    { "S35",                PoPs_genre_atom,   16,  19, 0,  3.4969032161e+01 },   
    { "S36",                PoPs_genre_atom,   16,  20, 0,  3.596708076e+01 },    
    { "S37",                PoPs_genre_atom,   16,  21, 0,  3.6971125567e+01 },   
    { "S38",                PoPs_genre_atom,   16,  22, 0,  3.7971163317e+01 },
    { "S39",                PoPs_genre_atom,   16,  23, 0,  3.8975134306e+01 },   
    { "S40",                PoPs_genre_atom,   16,  24, 0,  3.9975451728e+01 },   
    { "S41",                PoPs_genre_atom,   16,  25, 0,  4.0979582149e+01 },   
    { "S42",                PoPs_genre_atom,   16,  26, 0,  4.1981022419e+01 },
    { "S43",                PoPs_genre_atom,   16,  27, 0,  4.298715479e+01 },    
    { "S44",                PoPs_genre_atom,   16,  28, 0,  4.399021339e+01 },    
    { "S45",                PoPs_genre_atom,   16,  29, 0,  4.4996508112e+01 },   
    { "S46",                PoPs_genre_atom,   16,  30, 0,  4.600075e+01 },
    { "S47",                PoPs_genre_atom,   16,  31, 0,  4.700859e+01 },       
    { "S48",                PoPs_genre_atom,   16,  32, 0,  4.801417e+01 },       
    { "S49",                PoPs_genre_atom,   16,  33, 0,  4.9023619e+01 },      
    { "Cl_natural",         PoPs_genre_atom,   17,  -1, 0,  3.5453e+01 },
    { "Cl28",               PoPs_genre_atom,   17,  11, 0,  2.802851e+01 },       
    { "Cl29",               PoPs_genre_atom,   17,  12, 0,  2.901411e+01 },       
    { "Cl30",               PoPs_genre_atom,   17,  13, 0,  3.000477e+01 },       
    { "Cl31",               PoPs_genre_atom,   17,  14, 0,  3.0992413086e+01 },
    { "Cl32",               PoPs_genre_atom,   17,  15, 0,  3.1985689901e+01 },   
    { "Cl33",               PoPs_genre_atom,   17,  16, 0,  3.2977451887e+01 },   
    { "Cl34",               PoPs_genre_atom,   17,  17, 0,  Cl34_Mass },
    { "Cl35",               PoPs_genre_atom,   17,  18, 0,  3.4968852682e+01 },
    { "Cl36",               PoPs_genre_atom,   17,  19, 0,  3.5968306981e+01 },   
    { "Cl37",               PoPs_genre_atom,   17,  20, 0,  3.6965902591e+01 },   
    { "Cl38",               PoPs_genre_atom,   17,  21, 0,  3.7968010425e+01 },   
    { "Cl39",               PoPs_genre_atom,   17,  22, 0,  3.8968008164e+01 },
    { "Cl40",               PoPs_genre_atom,   17,  23, 0,  3.9970415472e+01 },   
    { "Cl41",               PoPs_genre_atom,   17,  24, 0,  4.0970684525e+01 },   
    { "Cl42",               PoPs_genre_atom,   17,  25, 0,  4.1973254804e+01 },   
    { "Cl43",               PoPs_genre_atom,   17,  26, 0,  4.2974054403e+01 },
    { "Cl44",               PoPs_genre_atom,   17,  27, 0,  4.3978281071e+01 },   
    { "Cl45",               PoPs_genre_atom,   17,  28, 0,  4.4980286886e+01 },   
    { "Cl46",               PoPs_genre_atom,   17,  29, 0,  4.598421004e+01 },    
    { "Cl47",               PoPs_genre_atom,   17,  30, 0,  4.698871e+01 },
    { "Cl48",               PoPs_genre_atom,   17,  31, 0,  4.799495e+01 },       
    { "Cl49",               PoPs_genre_atom,   17,  32, 0,  4.900032e+01 },       
    { "Cl50",               PoPs_genre_atom,   17,  33, 0,  5.000784e+01 },       
    { "Cl51",               PoPs_genre_atom,   17,  34, 0,  5.101449e+01 },
    { "Ar_natural",         PoPs_genre_atom,   18,  -1, 0,  3.9948e+01 },         
    { "Ar30",               PoPs_genre_atom,   18,  12, 0,  3.002156e+01 },       
    { "Ar31",               PoPs_genre_atom,   18,  13, 0,  3.1012123e+01 },      
    { "Ar32",               PoPs_genre_atom,   18,  14, 0,  3.1997637984e+01 },
    { "Ar33",               PoPs_genre_atom,   18,  15, 0,  3.2989925709e+01 },   
    { "Ar34",               PoPs_genre_atom,   18,  16, 0,  3.3980271244e+01 },   
    { "Ar35",               PoPs_genre_atom,   18,  17, 0,  3.4975257585e+01 },   
    { "Ar36",               PoPs_genre_atom,   18,  18, 0,  3.5967545105e+01 },
    { "Ar37",               PoPs_genre_atom,   18,  19, 0,  3.696677632e+01 },    
    { "Ar38",               PoPs_genre_atom,   18,  20, 0,  3.7962732394e+01 },   
    { "Ar39",               PoPs_genre_atom,   18,  21, 0,  3.8964313231e+01 },   
    { "Ar40",               PoPs_genre_atom,   18,  22, 0,  3.996238312251e+01 },
    { "Ar41",               PoPs_genre_atom,   18,  23, 0,  4.0964500611e+01 },   
    { "Ar42",               PoPs_genre_atom,   18,  24, 0,  4.1963045736e+01 },   
    { "Ar43",               PoPs_genre_atom,   18,  25, 0,  4.2965636056e+01 },   
    { "Ar44",               PoPs_genre_atom,   18,  26, 0,  4.3964924033e+01 },
    { "Ar45",               PoPs_genre_atom,   18,  27, 0,  4.4968039956e+01 },   
    { "Ar46",               PoPs_genre_atom,   18,  28, 0,  4.5968094129e+01 },   
    { "Ar47",               PoPs_genre_atom,   18,  29, 0,  4.6972186792e+01 },   
    { "Ar48",               PoPs_genre_atom,   18,  30, 0,  4.797454e+01 },
    { "Ar49",               PoPs_genre_atom,   18,  31, 0,  4.898052e+01 },       
    { "Ar50",               PoPs_genre_atom,   18,  32, 0,  4.998443e+01 },       
    { "Ar51",               PoPs_genre_atom,   18,  33, 0,  5.099163e+01 },       
    { "Ar52",               PoPs_genre_atom,   18,  34, 0,  5.199678e+01 },
    { "Ar53",               PoPs_genre_atom,   18,  35, 0,  5.300494e+01 },       
    { "K_natural",          PoPs_genre_atom,   19,  -1, 0,  3.90983e+01 },        
    { "K32",                PoPs_genre_atom,   19,  13, 0,  3.202192e+01 },       
    { "K33",                PoPs_genre_atom,   19,  14, 0,  3.300726e+01 },
    { "K34",                PoPs_genre_atom,   19,  15, 0,  3.399841e+01 },       
    { "K35",                PoPs_genre_atom,   19,  16, 0,  3.4988009692e+01 },   
    { "K36",                PoPs_genre_atom,   19,  17, 0,  3.5981292235e+01 },   
    { "K37",                PoPs_genre_atom,   19,  18, 0,  3.6973375889e+01 },
    { "K38",                PoPs_genre_atom,   19,  19, 0,  3.7969081184e+01 },   
    { "K39",                PoPs_genre_atom,   19,  20, 0,  3.8963706679e+01 },   
    { "K40",                PoPs_genre_atom,   19,  21, 0,  3.9963998475e+01 },   
    { "K41",                PoPs_genre_atom,   19,  22, 0,  4.0961825762e+01 },
    { "K42",                PoPs_genre_atom,   19,  23, 0,  4.196240281e+01 },    
    { "K43",                PoPs_genre_atom,   19,  24, 0,  4.296071554e+01 },    
    { "K44",                PoPs_genre_atom,   19,  25, 0,  4.3961556804e+01 },   
    { "K45",                PoPs_genre_atom,   19,  26, 0,  4.4960699493e+01 },
    { "K46",                PoPs_genre_atom,   19,  27, 0,  4.5961976864e+01 },   
    { "K47",                PoPs_genre_atom,   19,  28, 0,  4.6961678473e+01 },   
    { "K48",                PoPs_genre_atom,   19,  29, 0,  4.7965513535e+01 },   
    { "K49",                PoPs_genre_atom,   19,  30, 0,  4.8967450928e+01 },
    { "K50",                PoPs_genre_atom,   19,  31, 0,  4.9972783355e+01 },   
    { "K51",                PoPs_genre_atom,   19,  32, 0,  5.097638e+01 },       
    { "K52",                PoPs_genre_atom,   19,  33, 0,  5.198261e+01 },       
    { "K53",                PoPs_genre_atom,   19,  34, 0,  5.298712e+01 },
    { "K54",                PoPs_genre_atom,   19,  35, 0,  5.39942e+01 },        
    { "K55",                PoPs_genre_atom,   19,  36, 0,  5.499971e+01 },       
    { "Ca_natural",         PoPs_genre_atom,   20,  -1, 0,  4.008e+01 },          
    { "Ca34",               PoPs_genre_atom,   20,  14, 0,  3.401412e+01 },
    { "Ca35",               PoPs_genre_atom,   20,  15, 0,  3.500494e+01 },       
    { "Ca36",               PoPs_genre_atom,   20,  16, 0,  3.5993087063e+01 },   
    { "Ca37",               PoPs_genre_atom,   20,  17, 0,  3.6985870269e+01 },   
    { "Ca38",               PoPs_genre_atom,   20,  18, 0,  3.7976318452e+01 },
    { "Ca39",               PoPs_genre_atom,   20,  19, 0,  3.8970719725e+01 },   
    { "Ca40",               PoPs_genre_atom,   20,  20, 0,  3.9962590983e+01 },   
    { "Ca41",               PoPs_genre_atom,   20,  21, 0,  4.0962278062e+01 },   
    { "Ca42",               PoPs_genre_atom,   20,  22, 0,  4.1958618014e+01 },
    { "Ca43",               PoPs_genre_atom,   20,  23, 0,  4.2958766628e+01 },   
    { "Ca44",               PoPs_genre_atom,   20,  24, 0,  4.3955481754e+01 },   
    { "Ca45",               PoPs_genre_atom,   20,  25, 0,  4.4956186566e+01 },   
    { "Ca46",               PoPs_genre_atom,   20,  26, 0,  4.5953692587e+01 },
    { "Ca47",               PoPs_genre_atom,   20,  27, 0,  4.6954546006e+01 },   
    { "Ca48",               PoPs_genre_atom,   20,  28, 0,  4.7952534177e+01 },   
    { "Ca49",               PoPs_genre_atom,   20,  29, 0,  4.8955674148e+01 },   
    { "Ca50",               PoPs_genre_atom,   20,  30, 0,  4.9957518962e+01 },
    { "Ca51",               PoPs_genre_atom,   20,  31, 0,  5.0961499214e+01 },   
    { "Ca52",               PoPs_genre_atom,   20,  32, 0,  5.19651e+01 },        
    { "Ca53",               PoPs_genre_atom,   20,  33, 0,  5.297005e+01 },       
    { "Ca54",               PoPs_genre_atom,   20,  34, 0,  5.397435e+01 },
    { "Ca55",               PoPs_genre_atom,   20,  35, 0,  5.498055e+01 },       
    { "Ca56",               PoPs_genre_atom,   20,  36, 0,  5.598557e+01 },       
    { "Ca57",               PoPs_genre_atom,   20,  37, 0,  5.6992356e+01 },      
    { "Sc_natural",         PoPs_genre_atom,   21,  -1, 0,  4.49559e+01 },
    { "Sc36",               PoPs_genre_atom,   21,  15, 0,  3.601492e+01 },       
    { "Sc37",               PoPs_genre_atom,   21,  16, 0,  3.700305e+01 },       
    { "Sc38",               PoPs_genre_atom,   21,  17, 0,  3.79947e+01 },        
    { "Sc39",               PoPs_genre_atom,   21,  18, 0,  3.8984790002e+01 },
    { "Sc40",               PoPs_genre_atom,   21,  19, 0,  3.9977967407e+01 },   
    { "Sc41",               PoPs_genre_atom,   21,  20, 0,  4.0969251125e+01 },   
    { "Sc42",               PoPs_genre_atom,   21,  21, 0,  4.1965516429e+01 },   
    { "Sc43",               PoPs_genre_atom,   21,  22, 0,  4.2961150658e+01 },
    { "Sc44",               PoPs_genre_atom,   21,  23, 0,  4.3959402752e+01 },   
    { "Sc45",               PoPs_genre_atom,   21,  24, 0,  4.4955911909e+01 },   
    { "Sc46",               PoPs_genre_atom,   21,  25, 0,  Sc46_Mass },    
    { "Sc47",               PoPs_genre_atom,   21,  26, 0,  4.6952407508e+01 },
    { "Sc48",               PoPs_genre_atom,   21,  27, 0,  4.7952231468e+01 },   
    { "Sc49",               PoPs_genre_atom,   21,  28, 0,  4.8950023975e+01 },   
    { "Sc50",               PoPs_genre_atom,   21,  29, 0,  4.9952187685e+01 },   
    { "Sc51",               PoPs_genre_atom,   21,  30, 0,  5.0953603368e+01 },
    { "Sc52",               PoPs_genre_atom,   21,  31, 0,  5.1956675468e+01 },   
    { "Sc53",               PoPs_genre_atom,   21,  32, 0,  5.295961e+01 },       
    { "Sc54",               PoPs_genre_atom,   21,  33, 0,  5.3963264561e+01 },   
    { "Sc55",               PoPs_genre_atom,   21,  34, 0,  5.4968243949e+01 },
    { "Sc56",               PoPs_genre_atom,   21,  35, 0,  5.597287e+01 },       
    { "Sc57",               PoPs_genre_atom,   21,  36, 0,  5.697779e+01 },       
    { "Sc58",               PoPs_genre_atom,   21,  37, 0,  5.798371e+01 },       
    { "Sc59",               PoPs_genre_atom,   21,  38, 0,  5.898922e+01 },
    { "Sc60",               PoPs_genre_atom,   21,  39, 0,  5.999571e+01 },       
    { "Ti_natural",         PoPs_genre_atom,   22,  -1, 0,  4.79e+01 },           
    { "Ti38",               PoPs_genre_atom,   22,  16, 0,  3.800977e+01 },       
    { "Ti39",               PoPs_genre_atom,   22,  17, 0,  3.900161e+01 },
    { "Ti40",               PoPs_genre_atom,   22,  18, 0,  3.9990498838e+01 },   
    { "Ti41",               PoPs_genre_atom,   22,  19, 0,  4.0983145e+01 },      
    { "Ti42",               PoPs_genre_atom,   22,  20, 0,  4.1973030902e+01 },   
    { "Ti43",               PoPs_genre_atom,   22,  21, 0,  4.2968522499e+01 },
    { "Ti44",               PoPs_genre_atom,   22,  22, 0,  4.3959690069e+01 },   
    { "Ti45",               PoPs_genre_atom,   22,  23, 0,  4.4958125616e+01 },   
    { "Ti46",               PoPs_genre_atom,   22,  24, 0,  4.5952631555e+01 },   
    { "Ti47",               PoPs_genre_atom,   22,  25, 0,  4.6951763088e+01 },
    { "Ti48",               PoPs_genre_atom,   22,  26, 0,  4.7947946281e+01 },   
    { "Ti49",               PoPs_genre_atom,   22,  27, 0,  4.8947869982e+01 },   
    { "Ti50",               PoPs_genre_atom,   22,  28, 0,  4.9944791194e+01 },   
    { "Ti51",               PoPs_genre_atom,   22,  29, 0,  5.0946614955e+01 },
    { "Ti52",               PoPs_genre_atom,   22,  30, 0,  5.1946897311e+01 },   
    { "Ti53",               PoPs_genre_atom,   22,  31, 0,  5.2949727171e+01 },   
    { "Ti54",               PoPs_genre_atom,   22,  32, 0,  5.3951052401e+01 },   
    { "Ti55",               PoPs_genre_atom,   22,  33, 0,  5.4955265056e+01 },
    { "Ti56",               PoPs_genre_atom,   22,  34, 0,  5.5958199639e+01 },   
    { "Ti57",               PoPs_genre_atom,   22,  35, 0,  5.6963989137e+01 },   
    { "Ti58",               PoPs_genre_atom,   22,  36, 0,  5.796697e+01 },       
    { "Ti59",               PoPs_genre_atom,   22,  37, 0,  5.897293e+01 },
    { "Ti60",               PoPs_genre_atom,   22,  38, 0,  5.997676e+01 },       
    { "Ti61",               PoPs_genre_atom,   22,  39, 0,  6.09832e+01 },        
    { "Ti62",               PoPs_genre_atom,   22,  40, 0,  6.198749e+01 },       
    { "Ti63",               PoPs_genre_atom,   22,  41, 0,  6.299442e+01 },
    { "V_natural",          PoPs_genre_atom,   23,  -1, 0,  5.09415e+01 },        
    { "V40",                PoPs_genre_atom,   23,  17, 0,  4.001109e+01 },       
    { "V41",                PoPs_genre_atom,   23,  18, 0,  4.099978e+01 },       
    { "V42",                PoPs_genre_atom,   23,  19, 0,  4.199123e+01 },
    { "V43",                PoPs_genre_atom,   23,  20, 0,  4.298065e+01 },       
    { "V44",                PoPs_genre_atom,   23,  21, 0,  4.397411e+01 },       
    { "V45",                PoPs_genre_atom,   23,  22, 0,  4.4965775808e+01 },   
    { "V46",                PoPs_genre_atom,   23,  23, 0,  4.5960200481e+01 },
    { "V47",                PoPs_genre_atom,   23,  24, 0,  4.695490894e+01 },    
    { "V48",                PoPs_genre_atom,   23,  25, 0,  4.7952253707e+01 },   
    { "V49",                PoPs_genre_atom,   23,  26, 0,  4.8948516101e+01 },   
    { "V50",                PoPs_genre_atom,   23,  27, 0,  4.9947158485e+01 },
    { "V51",                PoPs_genre_atom,   23,  28, 0,  5.0943959507e+01 },   
    { "V52",                PoPs_genre_atom,   23,  29, 0,  5.1944775479e+01 },   
    { "V53",                PoPs_genre_atom,   23,  30, 0,  5.2944337979e+01 },   
    { "V54",                PoPs_genre_atom,   23,  31, 0,  5.3946439854e+01 },
    { "V55",                PoPs_genre_atom,   23,  32, 0,  5.4947233701e+01 },   
    { "V56",                PoPs_genre_atom,   23,  33, 0,  5.5950530966e+01 },   
    { "V57",                PoPs_genre_atom,   23,  34, 0,  5.6952561432e+01 },   
    { "V58",                PoPs_genre_atom,   23,  35, 0,  5.7956834136e+01 },
    { "V59",                PoPs_genre_atom,   23,  36, 0,  5.8960207407e+01 },   
    { "V60",                PoPs_genre_atom,   23,  37, 0,  5.9965026862e+01 },   
    { "V61",                PoPs_genre_atom,   23,  38, 0,  6.096848e+01 },       
    { "V62",                PoPs_genre_atom,   23,  39, 0,  6.197378e+01 },
    { "V63",                PoPs_genre_atom,   23,  40, 0,  6.297755e+01 },       
    { "V64",                PoPs_genre_atom,   23,  41, 0,  6.398347e+01 },       
    { "V65",                PoPs_genre_atom,   23,  42, 0,  6.498792e+01 },       
    { "Cr_natural",         PoPs_genre_atom,   24,  -1, 0,  5.1996e+01 },
    { "Cr42",               PoPs_genre_atom,   24,  18, 0,  4.200643e+01 },       
    { "Cr43",               PoPs_genre_atom,   24,  19, 0,  4.299771e+01 },       
    { "Cr44",               PoPs_genre_atom,   24,  20, 0,  4.3985549e+01 },      
    { "Cr45",               PoPs_genre_atom,   24,  21, 0,  4.497964e+01 },
    { "Cr46",               PoPs_genre_atom,   24,  22, 0,  4.5968358635e+01 },   
    { "Cr47",               PoPs_genre_atom,   24,  23, 0,  4.6962900046e+01 },   
    { "Cr48",               PoPs_genre_atom,   24,  24, 0,  4.7954031716e+01 },   
    { "Cr49",               PoPs_genre_atom,   24,  25, 0,  4.8951335721e+01 },
    { "Cr50",               PoPs_genre_atom,   24,  26, 0,  4.9946044205e+01 },   
    { "Cr51",               PoPs_genre_atom,   24,  27, 0,  5.0944767431e+01 },   
    { "Cr52",               PoPs_genre_atom,   24,  28, 0,  5.1940507472e+01 },   
    { "Cr53",               PoPs_genre_atom,   24,  29, 0,  5.2940649386e+01 },
    { "Cr54",               PoPs_genre_atom,   24,  30, 0,  5.3938880395e+01 },   
    { "Cr55",               PoPs_genre_atom,   24,  31, 0,  5.4940839672e+01 },   
    { "Cr56",               PoPs_genre_atom,   24,  32, 0,  5.5940653139e+01 },   
    { "Cr57",               PoPs_genre_atom,   24,  33, 0,  5.6943613013e+01 },
    { "Cr58",               PoPs_genre_atom,   24,  34, 0,  5.7944353129e+01 },   
    { "Cr59",               PoPs_genre_atom,   24,  35, 0,  5.8948586367e+01 },   
    { "Cr60",               PoPs_genre_atom,   24,  36, 0,  5.9950076033e+01 },   
    { "Cr61",               PoPs_genre_atom,   24,  37, 0,  6.0954717204e+01 },
    { "Cr62",               PoPs_genre_atom,   24,  38, 0,  6.195661319e+01 },    
    { "Cr63",               PoPs_genre_atom,   24,  39, 0,  6.296186e+01 },       
    { "Cr64",               PoPs_genre_atom,   24,  40, 0,  6.396441e+01 },       
    { "Cr65",               PoPs_genre_atom,   24,  41, 0,  6.497016e+01 },
    { "Cr66",               PoPs_genre_atom,   24,  42, 0,  6.597338e+01 },       
    { "Cr67",               PoPs_genre_atom,   24,  43, 0,  6.697955e+01 },       
    { "Mn_natural",         PoPs_genre_atom,   25,  -1, 0,  5.4938e+01 },         
    { "Mn44",               PoPs_genre_atom,   25,  19, 0,  4.400687e+01 },
    { "Mn45",               PoPs_genre_atom,   25,  20, 0,  4.499451e+01 },       
    { "Mn46",               PoPs_genre_atom,   25,  21, 0,  4.598672e+01 },       
    { "Mn47",               PoPs_genre_atom,   25,  22, 0,  4.69761e+01 },        
    { "Mn48",               PoPs_genre_atom,   25,  23, 0,  4.796852e+01 },
    { "Mn49",               PoPs_genre_atom,   25,  24, 0,  4.8959618005e+01 },   
    { "Mn50",               PoPs_genre_atom,   25,  25, 0,  4.995423823e+01 },    
    { "Mn51",               PoPs_genre_atom,   25,  26, 0,  5.0948210787e+01 },   
    { "Mn52",               PoPs_genre_atom,   25,  27, 0,  Mn52_Mass },
    { "Mn53",               PoPs_genre_atom,   25,  28, 0,  5.2941290117e+01 },   
    { "Mn54",               PoPs_genre_atom,   25,  29, 0,  5.3940358854e+01 },   
    { "Mn55",               PoPs_genre_atom,   25,  30, 0,  5.4938045141e+01 },   
    { "Mn56",               PoPs_genre_atom,   25,  31, 0,  5.593890491e+01 },
    { "Mn57",               PoPs_genre_atom,   25,  32, 0,  5.6938285378e+01 },   
    { "Mn58",               PoPs_genre_atom,   25,  33, 0,  5.7939981549e+01 },   
    { "Mn59",               PoPs_genre_atom,   25,  34, 0,  5.8940440237e+01 },   
    { "Mn60",               PoPs_genre_atom,   25,  35, 0,  5.9942911246e+01 },
    { "Mn61",               PoPs_genre_atom,   25,  36, 0,  6.0944652638e+01 },   
    { "Mn62",               PoPs_genre_atom,   25,  37, 0,  6.194842822e+01 },    
    { "Mn63",               PoPs_genre_atom,   25,  38, 0,  6.295023999e+01 },    
    { "Mn64",               PoPs_genre_atom,   25,  39, 0,  6.395424909e+01 },
    { "Mn65",               PoPs_genre_atom,   25,  40, 0,  6.4956336065e+01 },   
    { "Mn66",               PoPs_genre_atom,   25,  41, 0,  6.596108e+01 },       
    { "Mn67",               PoPs_genre_atom,   25,  42, 0,  6.696414e+01 },       
    { "Mn68",               PoPs_genre_atom,   25,  43, 0,  6.79693e+01 },
    { "Mn69",               PoPs_genre_atom,   25,  44, 0,  6.897284e+01 },       
    { "Fe_natural",         PoPs_genre_atom,   26,  -1, 0,  5.5847e+01 },         
    { "Fe45",               PoPs_genre_atom,   26,  19, 0,  4.5014578e+01 },      
    { "Fe46",               PoPs_genre_atom,   26,  20, 0,  4.600081e+01 },
    { "Fe47",               PoPs_genre_atom,   26,  21, 0,  4.699289e+01 },       
    { "Fe48",               PoPs_genre_atom,   26,  22, 0,  4.7980504e+01 },      
    { "Fe49",               PoPs_genre_atom,   26,  23, 0,  4.897361e+01 },       
    { "Fe50",               PoPs_genre_atom,   26,  24, 0,  4.9962988982e+01 },
    { "Fe51",               PoPs_genre_atom,   26,  25, 0,  5.0956819538e+01 },   
    { "Fe52",               PoPs_genre_atom,   26,  26, 0,  5.1948113875e+01 },   
    { "Fe53",               PoPs_genre_atom,   26,  27, 0,  5.2945307942e+01 },   
    { "Fe54",               PoPs_genre_atom,   26,  28, 0,  5.3939610501e+01 },
    { "Fe55",               PoPs_genre_atom,   26,  29, 0,  5.4938293357e+01 },   
    { "Fe56",               PoPs_genre_atom,   26,  30, 0,  5.5934937475e+01 },   
    { "Fe57",               PoPs_genre_atom,   26,  31, 0,  5.6935393969e+01 },   
    { "Fe58",               PoPs_genre_atom,   26,  32, 0,  5.7933275558e+01 },
    { "Fe59",               PoPs_genre_atom,   26,  33, 0,  5.8934875464e+01 },   
    { "Fe60",               PoPs_genre_atom,   26,  34, 0,  5.9934071683e+01 },   
    { "Fe61",               PoPs_genre_atom,   26,  35, 0,  6.0936745281e+01 },   
    { "Fe62",               PoPs_genre_atom,   26,  36, 0,  6.1936767442e+01 },
    { "Fe63",               PoPs_genre_atom,   26,  37, 0,  6.2940369091e+01 },   
    { "Fe64",               PoPs_genre_atom,   26,  38, 0,  6.3941201265e+01 },   
    { "Fe65",               PoPs_genre_atom,   26,  39, 0,  6.494538027e+01 },    
    { "Fe66",               PoPs_genre_atom,   26,  40, 0,  6.5946780638e+01 },
    { "Fe67",               PoPs_genre_atom,   26,  41, 0,  6.6950947244e+01 },   
    { "Fe68",               PoPs_genre_atom,   26,  42, 0,  6.79537e+01 },        
    { "Fe69",               PoPs_genre_atom,   26,  43, 0,  6.895878e+01 },       
    { "Fe70",               PoPs_genre_atom,   26,  44, 0,  6.996146e+01 },
    { "Fe71",               PoPs_genre_atom,   26,  45, 0,  7.096672e+01 },       
    { "Fe72",               PoPs_genre_atom,   26,  46, 0,  7.196962e+01 },       
    { "Co_natural",         PoPs_genre_atom,   27,  -1, 0,  5.89332e+01 },        
    { "Co47",               PoPs_genre_atom,   27,  20, 0,  4.701149e+01 },
    { "Co48",               PoPs_genre_atom,   27,  21, 0,  4.800176e+01 },       
    { "Co49",               PoPs_genre_atom,   27,  22, 0,  4.898972e+01 },       
    { "Co50",               PoPs_genre_atom,   27,  23, 0,  4.998154e+01 },       
    { "Co51",               PoPs_genre_atom,   27,  24, 0,  5.097072e+01 },
    { "Co52",               PoPs_genre_atom,   27,  25, 0,  5.196359e+01 },       
    { "Co53",               PoPs_genre_atom,   27,  26, 0,  5.2954218896e+01 },   
    { "Co54",               PoPs_genre_atom,   27,  27, 0,  5.3948459635e+01 },   
    { "Co55",               PoPs_genre_atom,   27,  28, 0,  5.4941999029e+01 },
    { "Co56",               PoPs_genre_atom,   27,  29, 0,  5.5939839278e+01 },   
    { "Co57",               PoPs_genre_atom,   27,  30, 0,  5.6936291373e+01 },   
    { "Co58",               PoPs_genre_atom,   27,  31, 0,  Co58_Mass        },   
    { "Co59",               PoPs_genre_atom,   27,  32, 0,  5.8933195048e+01 },
    { "Co60",               PoPs_genre_atom,   27,  33, 0,  5.9933817059e+01 },   
    { "Co61",               PoPs_genre_atom,   27,  34, 0,  6.0932475763e+01 },   
    { "Co62",               PoPs_genre_atom,   27,  35, 0,  6.1934050563e+01 },   
    { "Co63",               PoPs_genre_atom,   27,  36, 0,  6.2933611611e+01 },
    { "Co64",               PoPs_genre_atom,   27,  37, 0,  6.3935809908e+01 },   
    { "Co65",               PoPs_genre_atom,   27,  38, 0,  6.493647846e+01 },    
    { "Co66",               PoPs_genre_atom,   27,  39, 0,  6.5939762004e+01 },   
    { "Co67",               PoPs_genre_atom,   27,  40, 0,  6.6940889529e+01 },
    { "Co68",               PoPs_genre_atom,   27,  41, 0,  6.7944873058e+01 },   
    { "Co69",               PoPs_genre_atom,   27,  42, 0,  6.894632e+01 },       
    { "Co70",               PoPs_genre_atom,   27,  43, 0,  6.9951e+01 },         
    { "Co71",               PoPs_genre_atom,   27,  44, 0,  7.09529e+01 },
    { "Co72",               PoPs_genre_atom,   27,  45, 0,  7.195781e+01 },       
    { "Co73",               PoPs_genre_atom,   27,  46, 0,  7.296024e+01 },       
    { "Co74",               PoPs_genre_atom,   27,  47, 0,  7.396538e+01 },       
    { "Co75",               PoPs_genre_atom,   27,  48, 0,  7.496833e+01 },
    { "Ni_natural",         PoPs_genre_atom,   28,  -1, 0,  5.87e+01 },           
    { "Ni48",               PoPs_genre_atom,   28,  20, 0,  4.801975e+01 },       
    { "Ni49",               PoPs_genre_atom,   28,  21, 0,  4.900966e+01 },       
    { "Ni50",               PoPs_genre_atom,   28,  22, 0,  4.999593e+01 },
    { "Ni51",               PoPs_genre_atom,   28,  23, 0,  5.098772e+01 },       
    { "Ni52",               PoPs_genre_atom,   28,  24, 0,  5.197568e+01 },       
    { "Ni53",               PoPs_genre_atom,   28,  25, 0,  5.296847e+01 },       
    { "Ni54",               PoPs_genre_atom,   28,  26, 0,  5.3957905495e+01 },
    { "Ni55",               PoPs_genre_atom,   28,  27, 0,  5.4951330251e+01 },   
    { "Ni56",               PoPs_genre_atom,   28,  28, 0,  5.5942132022e+01 },   
    { "Ni57",               PoPs_genre_atom,   28,  29, 0,  5.6939793526e+01 },   
    { "Ni58",               PoPs_genre_atom,   28,  30, 0,  5.7935342907e+01 },
    { "Ni59",               PoPs_genre_atom,   28,  31, 0,  5.8934346705e+01 },   
    { "Ni60",               PoPs_genre_atom,   28,  32, 0,  5.9930786372e+01 },   
    { "Ni61",               PoPs_genre_atom,   28,  33, 0,  6.0931056033e+01 },   
    { "Ni62",               PoPs_genre_atom,   28,  34, 0,  6.1928345115e+01 },
    { "Ni63",               PoPs_genre_atom,   28,  35, 0,  6.2929669374e+01 },   
    { "Ni64",               PoPs_genre_atom,   28,  36, 0,  6.3927965959e+01 },   
    { "Ni65",               PoPs_genre_atom,   28,  37, 0,  6.4930084304e+01 },   
    { "Ni66",               PoPs_genre_atom,   28,  38, 0,  6.5929139334e+01 },
    { "Ni67",               PoPs_genre_atom,   28,  39, 0,  6.6931569414e+01 },   
    { "Ni68",               PoPs_genre_atom,   28,  40, 0,  6.7931868789e+01 },   
    { "Ni69",               PoPs_genre_atom,   28,  41, 0,  6.8935610269e+01 },   
    { "Ni70",               PoPs_genre_atom,   28,  42, 0,  6.99365e+01 },
    { "Ni71",               PoPs_genre_atom,   28,  43, 0,  7.0940736283e+01 },   
    { "Ni72",               PoPs_genre_atom,   28,  44, 0,  7.1942092682e+01 },   
    { "Ni73",               PoPs_genre_atom,   28,  45, 0,  7.294647e+01 },       
    { "Ni74",               PoPs_genre_atom,   28,  46, 0,  7.394807e+01 },
    { "Ni75",               PoPs_genre_atom,   28,  47, 0,  7.495287e+01 },       
    { "Ni76",               PoPs_genre_atom,   28,  48, 0,  7.595533e+01 },       
    { "Ni77",               PoPs_genre_atom,   28,  49, 0,  7.696055e+01 },       
    { "Ni78",               PoPs_genre_atom,   28,  50, 0,  7.796318e+01 },
    { "Cu_natural",         PoPs_genre_atom,   29,  -1, 0,  6.3546e+01 },         
    { "Cu52",               PoPs_genre_atom,   29,  23, 0,  5.199718e+01 },       
    { "Cu53",               PoPs_genre_atom,   29,  24, 0,  5.298555e+01 },       
    { "Cu54",               PoPs_genre_atom,   29,  25, 0,  5.397671e+01 },
    { "Cu55",               PoPs_genre_atom,   29,  26, 0,  5.496605e+01 },       
    { "Cu56",               PoPs_genre_atom,   29,  27, 0,  5.595856e+01 },       
    { "Cu57",               PoPs_genre_atom,   29,  28, 0,  5.6949211078e+01 },   
    { "Cu58",               PoPs_genre_atom,   29,  29, 0,  5.7944538499e+01 },
    { "Cu59",               PoPs_genre_atom,   29,  30, 0,  5.8939498028e+01 },   
    { "Cu60",               PoPs_genre_atom,   29,  31, 0,  5.993736503e+01 },    
    { "Cu61",               PoPs_genre_atom,   29,  32, 0,  6.0933457821e+01 },   
    { "Cu62",               PoPs_genre_atom,   29,  33, 0,  6.1932583745e+01 },
    { "Cu63",               PoPs_genre_atom,   29,  34, 0,  6.2929597474e+01 },   
    { "Cu64",               PoPs_genre_atom,   29,  35, 0,  6.3929764183e+01 },   
    { "Cu65",               PoPs_genre_atom,   29,  36, 0,  6.4927789485e+01 },   
    { "Cu66",               PoPs_genre_atom,   29,  37, 0,  6.592886881299999e+01 },
    { "Cu67",               PoPs_genre_atom,   29,  38, 0,  6.6927730314e+01 },   
    { "Cu68",               PoPs_genre_atom,   29,  39, 0,  6.7929610889e+01 },   
    { "Cu69",               PoPs_genre_atom,   29,  40, 0,  6.8929429269e+01 },   
    { "Cu70",               PoPs_genre_atom,   29,  41, 0,  6.9932392343e+01 },
    { "Cu71",               PoPs_genre_atom,   29,  42, 0,  7.0932676833e+01 },   
    { "Cu72",               PoPs_genre_atom,   29,  43, 0,  7.1935820307e+01 },   
    { "Cu73",               PoPs_genre_atom,   29,  44, 0,  7.2936675282e+01 },   
    { "Cu74",               PoPs_genre_atom,   29,  45, 0,  7.3939874862e+01 },
    { "Cu75",               PoPs_genre_atom,   29,  46, 0,  7.49419e+01 },        
    { "Cu76",               PoPs_genre_atom,   29,  47, 0,  7.5945275026e+01 },   
    { "Cu77",               PoPs_genre_atom,   29,  48, 0,  7.694785e+01 },       
    { "Cu78",               PoPs_genre_atom,   29,  49, 0,  7.795196e+01 },
    { "Cu79",               PoPs_genre_atom,   29,  50, 0,  7.895456e+01 },       
    { "Cu80",               PoPs_genre_atom,   29,  51, 0,  7.996087e+01 },       
    { "Zn_natural",         PoPs_genre_atom,   30,  -1, 0,  6.538e+01 },          
    { "Zn54",               PoPs_genre_atom,   30,  24, 0,  5.399295e+01 },
    { "Zn55",               PoPs_genre_atom,   30,  25, 0,  5.498398e+01 },       
    { "Zn56",               PoPs_genre_atom,   30,  26, 0,  5.597238e+01 },       
    { "Zn57",               PoPs_genre_atom,   30,  27, 0,  5.6964788e+01 },      
    { "Zn58",               PoPs_genre_atom,   30,  28, 0,  5.7954591555e+01 },
    { "Zn59",               PoPs_genre_atom,   30,  29, 0,  5.8949263764e+01 },   
    { "Zn60",               PoPs_genre_atom,   30,  30, 0,  5.9941827035e+01 },   
    { "Zn61",               PoPs_genre_atom,   30,  31, 0,  6.0939510635e+01 },   
    { "Zn62",               PoPs_genre_atom,   30,  32, 0,  6.1934329764e+01 },
    { "Zn63",               PoPs_genre_atom,   30,  33, 0,  6.2933211566e+01 },   
    { "Zn64",               PoPs_genre_atom,   30,  34, 0,  6.3929142222e+01 },   
    { "Zn65",               PoPs_genre_atom,   30,  35, 0,  6.4929240984e+01 },   
    { "Zn66",               PoPs_genre_atom,   30,  36, 0,  6.5926033419e+01 },
    { "Zn67",               PoPs_genre_atom,   30,  37, 0,  6.6927127345e+01 },   
    { "Zn68",               PoPs_genre_atom,   30,  38, 0,  6.7924844154e+01 },   
    { "Zn69",               PoPs_genre_atom,   30,  39, 0,  Zn69_Mass },   
    { "Zn70",               PoPs_genre_atom,   30,  40, 0,  6.9925319274e+01 },
    { "Zn71",               PoPs_genre_atom,   30,  41, 0,  7.0927721599e+01 },   
    { "Zn72",               PoPs_genre_atom,   30,  42, 0,  7.1926857951e+01 },   
    { "Zn73",               PoPs_genre_atom,   30,  43, 0,  7.2929779104e+01 },   
    { "Zn74",               PoPs_genre_atom,   30,  44, 0,  7.392945860899999e+01 },
    { "Zn75",               PoPs_genre_atom,   30,  45, 0,  7.4932936741e+01 },   
    { "Zn76",               PoPs_genre_atom,   30,  46, 0,  7.593329357e+01 },    
    { "Zn77",               PoPs_genre_atom,   30,  47, 0,  7.6936958967e+01 },   
    { "Zn78",               PoPs_genre_atom,   30,  48, 0,  7.7938440216e+01 },
    { "Zn79",               PoPs_genre_atom,   30,  49, 0,  7.8942652e+01 },      
    { "Zn80",               PoPs_genre_atom,   30,  50, 0,  7.9944342348e+01 },   
    { "Zn81",               PoPs_genre_atom,   30,  51, 0,  8.095048e+01 },       
    { "Zn82",               PoPs_genre_atom,   30,  52, 0,  8.195442e+01 },
    { "Zn83",               PoPs_genre_atom,   30,  53, 0,  8.296103e+01 },       
    { "Ga_natural",         PoPs_genre_atom,   31,  -1, 0,  6.972e+01 },          
    { "Ga56",               PoPs_genre_atom,   31,  25, 0,  5.599491e+01 },       
    { "Ga57",               PoPs_genre_atom,   31,  26, 0,  5.698293e+01 },
    { "Ga58",               PoPs_genre_atom,   31,  27, 0,  5.797425e+01 },       
    { "Ga59",               PoPs_genre_atom,   31,  28, 0,  5.896337e+01 },       
    { "Ga60",               PoPs_genre_atom,   31,  29, 0,  5.995706e+01 },       
    { "Ga61",               PoPs_genre_atom,   31,  30, 0,  6.0949446287e+01 },
    { "Ga62",               PoPs_genre_atom,   31,  31, 0,  6.1944175238e+01 },   
    { "Ga63",               PoPs_genre_atom,   31,  32, 0,  6.2939294196e+01 },   
    { "Ga64",               PoPs_genre_atom,   31,  33, 0,  6.3936838747e+01 },   
    { "Ga65",               PoPs_genre_atom,   31,  34, 0,  6.493273475399999e+01 },
    { "Ga66",               PoPs_genre_atom,   31,  35, 0,  6.593158901e+01 },    
    { "Ga67",               PoPs_genre_atom,   31,  36, 0,  6.6928201703e+01 },   
    { "Ga68",               PoPs_genre_atom,   31,  37, 0,  6.7927980084e+01 },   
    { "Ga69",               PoPs_genre_atom,   31,  38, 0,  6.8925573587e+01 },
    { "Ga70",               PoPs_genre_atom,   31,  39, 0,  6.9926021972e+01 },   
    { "Ga71",               PoPs_genre_atom,   31,  40, 0,  7.0924701349e+01 },   
    { "Ga72",               PoPs_genre_atom,   31,  41, 0,  7.1926366268e+01 },   
    { "Ga73",               PoPs_genre_atom,   31,  42, 0,  7.2925174682e+01 },
    { "Ga74",               PoPs_genre_atom,   31,  43, 0,  7.3926945762e+01 },   
    { "Ga75",               PoPs_genre_atom,   31,  44, 0,  7.4926500246e+01 },   
    { "Ga76",               PoPs_genre_atom,   31,  45, 0,  7.5928827626e+01 },   
    { "Ga77",               PoPs_genre_atom,   31,  46, 0,  7.69291543e+01 },
    { "Ga78",               PoPs_genre_atom,   31,  47, 0,  7.793160818e+01 },    
    { "Ga79",               PoPs_genre_atom,   31,  48, 0,  7.893289326e+01 },    
    { "Ga80",               PoPs_genre_atom,   31,  49, 0,  7.9936515781e+01 },   
    { "Ga81",               PoPs_genre_atom,   31,  50, 0,  8.0937752355e+01 },
    { "Ga82",               PoPs_genre_atom,   31,  51, 0,  8.194299e+01 },       
    { "Ga83",               PoPs_genre_atom,   31,  52, 0,  8.294698e+01 },       
    { "Ga84",               PoPs_genre_atom,   31,  53, 0,  8.395265e+01 },       
    { "Ga85",               PoPs_genre_atom,   31,  54, 0,  8.4957e+01 },
    { "Ga86",               PoPs_genre_atom,   31,  55, 0,  8.596312e+01 },       
    { "Ge_natural",         PoPs_genre_atom,   32,  -1, 0,  7.259e+01 },          
    { "Ge58",               PoPs_genre_atom,   32,  26, 0,  5.799101e+01 },       
    { "Ge59",               PoPs_genre_atom,   32,  27, 0,  5.898175e+01 },
    { "Ge60",               PoPs_genre_atom,   32,  28, 0,  5.997019e+01 },       
    { "Ge61",               PoPs_genre_atom,   32,  29, 0,  6.096379e+01 },       
    { "Ge62",               PoPs_genre_atom,   32,  30, 0,  6.195465e+01 },       
    { "Ge63",               PoPs_genre_atom,   32,  31, 0,  6.294964e+01 },
    { "Ge64",               PoPs_genre_atom,   32,  32, 0,  6.3941653e+01 },      
    { "Ge65",               PoPs_genre_atom,   32,  33, 0,  6.4939436406e+01 },   
    { "Ge66",               PoPs_genre_atom,   32,  34, 0,  6.5933843453e+01 },   
    { "Ge67",               PoPs_genre_atom,   32,  35, 0,  6.693273407e+01 },
    { "Ge68",               PoPs_genre_atom,   32,  36, 0,  6.792809424e+01 },    
    { "Ge69",               PoPs_genre_atom,   32,  37, 0,  6.8927964533e+01 },   
    { "Ge70",               PoPs_genre_atom,   32,  38, 0,  6.9924247381e+01 },   
    { "Ge71",               PoPs_genre_atom,   32,  39, 0,  7.0924950954e+01 },
    { "Ge72",               PoPs_genre_atom,   32,  40, 0,  7.1922075815e+01 },   
    { "Ge73",               PoPs_genre_atom,   32,  41, 0,  7.2923458945e+01 },   
    { "Ge74",               PoPs_genre_atom,   32,  42, 0,  7.3921177767e+01 },   
    { "Ge75",               PoPs_genre_atom,   32,  43, 0,  7.4922858948e+01 },
    { "Ge76",               PoPs_genre_atom,   32,  44, 0,  7.5921402557e+01 },   
    { "Ge77",               PoPs_genre_atom,   32,  45, 0,  7.6923548591e+01 },   
    { "Ge78",               PoPs_genre_atom,   32,  46, 0,  7.7922852739e+01 },   
    { "Ge79",               PoPs_genre_atom,   32,  47, 0,  7.8925400995e+01 },
    { "Ge80",               PoPs_genre_atom,   32,  48, 0,  7.9925372392e+01 },   
    { "Ge81",               PoPs_genre_atom,   32,  49, 0,  8.0928820467e+01 },   
    { "Ge82",               PoPs_genre_atom,   32,  50, 0,  8.1929549725e+01 },   
    { "Ge83",               PoPs_genre_atom,   32,  51, 0,  8.293462e+01 },
    { "Ge84",               PoPs_genre_atom,   32,  52, 0,  8.393747e+01 },       
    { "Ge85",               PoPs_genre_atom,   32,  53, 0,  8.494303e+01 },       
    { "Ge86",               PoPs_genre_atom,   32,  54, 0,  8.594649e+01 },       
    { "Ge87",               PoPs_genre_atom,   32,  55, 0,  8.695251e+01 },
    { "Ge88",               PoPs_genre_atom,   32,  56, 0,  8.795691e+01 },       
    { "Ge89",               PoPs_genre_atom,   32,  57, 0,  8.896383e+01 },       
    { "As_natural",         PoPs_genre_atom,   33,  -1, 0,  7.49216e+01 },        
    { "As60",               PoPs_genre_atom,   33,  27, 0,  5.999313e+01 },
    { "As61",               PoPs_genre_atom,   33,  28, 0,  6.098062e+01 },       
    { "As62",               PoPs_genre_atom,   33,  29, 0,  6.19732e+01 },        
    { "As63",               PoPs_genre_atom,   33,  30, 0,  6.296369e+01 },       
    { "As64",               PoPs_genre_atom,   33,  31, 0,  6.3957572e+01 },
    { "As65",               PoPs_genre_atom,   33,  32, 0,  6.4949564e+01 },      
    { "As66",               PoPs_genre_atom,   33,  33, 0,  6.594471e+01 },       
    { "As67",               PoPs_genre_atom,   33,  34, 0,  6.6939186071e+01 },   
    { "As68",               PoPs_genre_atom,   33,  35, 0,  6.793676906899999e+01 },
    { "As69",               PoPs_genre_atom,   33,  36, 0,  6.8932273675e+01 },   
    { "As70",               PoPs_genre_atom,   33,  37, 0,  6.9930924826e+01 },   
    { "As71",               PoPs_genre_atom,   33,  38, 0,  7.0927112428e+01 },   
    { "As72",               PoPs_genre_atom,   33,  39, 0,  7.1926752283e+01 },
    { "As73",               PoPs_genre_atom,   33,  40, 0,  7.2923824844e+01 },   
    { "As74",               PoPs_genre_atom,   33,  41, 0,  7.3923928692e+01 },   
    { "As75",               PoPs_genre_atom,   33,  42, 0,  7.4921596478e+01 },   
    { "As76",               PoPs_genre_atom,   33,  43, 0,  7.5922394021e+01 },
    { "As77",               PoPs_genre_atom,   33,  44, 0,  7.6920647286e+01 },   
    { "As78",               PoPs_genre_atom,   33,  45, 0,  7.7921827281e+01 },   
    { "As79",               PoPs_genre_atom,   33,  46, 0,  7.8920947934e+01 },   
    { "As80",               PoPs_genre_atom,   33,  47, 0,  7.9922533816e+01 },
    { "As81",               PoPs_genre_atom,   33,  48, 0,  8.0922132287e+01 },   
    { "As82",               PoPs_genre_atom,   33,  49, 0,  8.1924504067e+01 },   
    { "As83",               PoPs_genre_atom,   33,  50, 0,  8.2924980024e+01 },   
    { "As84",               PoPs_genre_atom,   33,  51, 0,  8.3929058e+01 },
    { "As85",               PoPs_genre_atom,   33,  52, 0,  8.493202e+01 },       
    { "As86",               PoPs_genre_atom,   33,  53, 0,  8.59365e+01 },        
    { "As87",               PoPs_genre_atom,   33,  54, 0,  8.69399e+01 },        
    { "As88",               PoPs_genre_atom,   33,  55, 0,  8.794494e+01 },
    { "As89",               PoPs_genre_atom,   33,  56, 0,  8.894939e+01 },       
    { "As90",               PoPs_genre_atom,   33,  57, 0,  8.99555e+01 },        
    { "As91",               PoPs_genre_atom,   33,  58, 0,  9.096043e+01 },       
    { "As92",               PoPs_genre_atom,   33,  59, 0,  9.19668e+01 },
    { "Se_natural",         PoPs_genre_atom,   34,  -1, 0,  7.896e+01 },          
    { "Se65",               PoPs_genre_atom,   34,  31, 0,  6.496466e+01 },       
    { "Se66",               PoPs_genre_atom,   34,  32, 0,  6.595521e+01 },       
    { "Se67",               PoPs_genre_atom,   34,  33, 0,  6.695009e+01 },
    { "Se68",               PoPs_genre_atom,   34,  34, 0,  6.7941798e+01 },      
    { "Se69",               PoPs_genre_atom,   34,  35, 0,  6.8939557817e+01 },   
    { "Se70",               PoPs_genre_atom,   34,  36, 0,  6.9933390644e+01 },   
    { "Se71",               PoPs_genre_atom,   34,  37, 0,  7.093224182199999e+01 },
    { "Se72",               PoPs_genre_atom,   34,  38, 0,  7.1927112352e+01 },   
    { "Se73",               PoPs_genre_atom,   34,  39, 0,  7.2926765345e+01 },   
    { "Se74",               PoPs_genre_atom,   34,  40, 0,  7.3922476436e+01 },   
    { "Se75",               PoPs_genre_atom,   34,  41, 0,  7.4922523368e+01 },
    { "Se76",               PoPs_genre_atom,   34,  42, 0,  7.5919213597e+01 },   
    { "Se77",               PoPs_genre_atom,   34,  43, 0,  7.6919914038e+01 },   
    { "Se78",               PoPs_genre_atom,   34,  44, 0,  7.791730909e+01 },    
    { "Se79",               PoPs_genre_atom,   34,  45, 0,  7.8918499098e+01 },
    { "Se80",               PoPs_genre_atom,   34,  46, 0,  7.9916521271e+01 },   
    { "Se81",               PoPs_genre_atom,   34,  47, 0,  8.0917992474e+01 },   
    { "Se82",               PoPs_genre_atom,   34,  48, 0,  8.1916699401e+01 },   
    { "Se83",               PoPs_genre_atom,   34,  49, 0,  8.2919118473e+01 },
    { "Se84",               PoPs_genre_atom,   34,  50, 0,  8.3918462354e+01 },   
    { "Se85",               PoPs_genre_atom,   34,  51, 0,  8.4922245053e+01 },   
    { "Se86",               PoPs_genre_atom,   34,  52, 0,  8.5924271579e+01 },   
    { "Se87",               PoPs_genre_atom,   34,  53, 0,  8.6928521358e+01 },
    { "Se88",               PoPs_genre_atom,   34,  54, 0,  8.7931423998e+01 },   
    { "Se89",               PoPs_genre_atom,   34,  55, 0,  8.893645e+01 },       
    { "Se90",               PoPs_genre_atom,   34,  56, 0,  8.993996e+01 },       
    { "Se91",               PoPs_genre_atom,   34,  57, 0,  9.094596e+01 },
    { "Se92",               PoPs_genre_atom,   34,  58, 0,  9.194992e+01 },       
    { "Se93",               PoPs_genre_atom,   34,  59, 0,  9.295629e+01 },       
    { "Se94",               PoPs_genre_atom,   34,  60, 0,  9.396049e+01 },       
    { "Br_natural",         PoPs_genre_atom,   35,  -1, 0,  7.9904e+01 },
    { "Br67",               PoPs_genre_atom,   35,  32, 0,  6.696479e+01 },       
    { "Br68",               PoPs_genre_atom,   35,  33, 0,  6.7958516e+01 },      
    { "Br69",               PoPs_genre_atom,   35,  34, 0,  6.8950106e+01 },      
    { "Br70",               PoPs_genre_atom,   35,  35, 0,  6.9944792e+01 },
    { "Br71",               PoPs_genre_atom,   35,  36, 0,  7.093874e+01 },       
    { "Br72",               PoPs_genre_atom,   35,  37, 0,  7.1936644572e+01 },   
    { "Br73",               PoPs_genre_atom,   35,  38, 0,  7.2931691524e+01 },   
    { "Br74",               PoPs_genre_atom,   35,  39, 0,  7.392989103399999e+01 },
    { "Br75",               PoPs_genre_atom,   35,  40, 0,  7.4925776207e+01 },   
    { "Br76",               PoPs_genre_atom,   35,  41, 0,  7.5924541469e+01 },   
    { "Br77",               PoPs_genre_atom,   35,  42, 0,  7.6921379082e+01 },   
    { "Br78",               PoPs_genre_atom,   35,  43, 0,  7.7921145706e+01 },
    { "Br79",               PoPs_genre_atom,   35,  44, 0,  7.8918337087e+01 },   
    { "Br80",               PoPs_genre_atom,   35,  45, 0,  7.9918529296e+01 },   
    { "Br81",               PoPs_genre_atom,   35,  46, 0,  8.0916290563e+01 },   
    { "Br82",               PoPs_genre_atom,   35,  47, 0,  8.1916804119e+01 },
    { "Br83",               PoPs_genre_atom,   35,  48, 0,  8.2915180421e+01 },   
    { "Br84",               PoPs_genre_atom,   35,  49, 0,  8.3916478974e+01 },   
    { "Br85",               PoPs_genre_atom,   35,  50, 0,  8.4915608403e+01 },   
    { "Br86",               PoPs_genre_atom,   35,  51, 0,  8.5918797577e+01 },
    { "Br87",               PoPs_genre_atom,   35,  52, 0,  8.6920711324e+01 },   
    { "Br88",               PoPs_genre_atom,   35,  53, 0,  8.7924065926e+01 },   
    { "Br89",               PoPs_genre_atom,   35,  54, 0,  8.8926385334e+01 },   
    { "Br90",               PoPs_genre_atom,   35,  55, 0,  8.993062773699999e+01 },
    { "Br91",               PoPs_genre_atom,   35,  56, 0,  9.0933968095e+01 },   
    { "Br92",               PoPs_genre_atom,   35,  57, 0,  9.1939258714e+01 },   
    { "Br93",               PoPs_genre_atom,   35,  58, 0,  9.294305e+01 },       
    { "Br94",               PoPs_genre_atom,   35,  59, 0,  9.394868e+01 },
    { "Br95",               PoPs_genre_atom,   35,  60, 0,  9.495287e+01 },       
    { "Br96",               PoPs_genre_atom,   35,  61, 0,  9.595853e+01 },       
    { "Br97",               PoPs_genre_atom,   35,  62, 0,  9.69628e+01 },        
    { "Kr_natural",         PoPs_genre_atom,   36,  -1, 0,  8.38e+01 },
    { "Kr69",               PoPs_genre_atom,   36,  33, 0,  6.896518e+01 },       
    { "Kr70",               PoPs_genre_atom,   36,  34, 0,  6.9955259e+01 },      
    { "Kr71",               PoPs_genre_atom,   36,  35, 0,  7.0949625738e+01 },   
    { "Kr72",               PoPs_genre_atom,   36,  36, 0,  7.1942092038e+01 },
    { "Kr73",               PoPs_genre_atom,   36,  37, 0,  7.2939289195e+01 },   
    { "Kr74",               PoPs_genre_atom,   36,  38, 0,  7.3933084369e+01 },   
    { "Kr75",               PoPs_genre_atom,   36,  39, 0,  7.4930945746e+01 },   
    { "Kr76",               PoPs_genre_atom,   36,  40, 0,  7.5925910078e+01 },
    { "Kr77",               PoPs_genre_atom,   36,  41, 0,  7.692467e+01 },       
    { "Kr78",               PoPs_genre_atom,   36,  42, 0,  7.7920364783e+01 },   
    { "Kr79",               PoPs_genre_atom,   36,  43, 0,  7.8920082431e+01 },   
    { "Kr80",               PoPs_genre_atom,   36,  44, 0,  7.9916378965e+01 },
    { "Kr81",               PoPs_genre_atom,   36,  45, 0,  8.0916592015e+01 },   
    { "Kr82",               PoPs_genre_atom,   36,  46, 0,  8.19134836e+01 },     
    { "Kr83",               PoPs_genre_atom,   36,  47, 0,  8.2914136099e+01 },   
    { "Kr84",               PoPs_genre_atom,   36,  48, 0,  8.3911506687e+01 },
    { "Kr85",               PoPs_genre_atom,   36,  49, 0,  8.4912527331e+01 },   
    { "Kr86",               PoPs_genre_atom,   36,  50, 0,  8.5910610729e+01 },   
    { "Kr87",               PoPs_genre_atom,   36,  51, 0,  8.6913354862e+01 },   
    { "Kr88",               PoPs_genre_atom,   36,  52, 0,  8.7914446969e+01 },
    { "Kr89",               PoPs_genre_atom,   36,  53, 0,  8.8917630581e+01 },   
    { "Kr90",               PoPs_genre_atom,   36,  54, 0,  8.9919516555e+01 },   
    { "Kr91",               PoPs_genre_atom,   36,  55, 0,  9.0923445215e+01 },   
    { "Kr92",               PoPs_genre_atom,   36,  56, 0,  9.192615621e+01 },
    { "Kr93",               PoPs_genre_atom,   36,  57, 0,  9.2931274357e+01 },   
    { "Kr94",               PoPs_genre_atom,   36,  58, 0,  9.393436e+01 },       
    { "Kr95",               PoPs_genre_atom,   36,  59, 0,  9.493984e+01 },       
    { "Kr96",               PoPs_genre_atom,   36,  60, 0,  9.594307e+01 },
    { "Kr97",               PoPs_genre_atom,   36,  61, 0,  9.694856e+01 },       
    { "Kr98",               PoPs_genre_atom,   36,  62, 0,  9.795191e+01 },       
    { "Kr99",               PoPs_genre_atom,   36,  63, 0,  9.89576e+01 },        
    { "Kr100",              PoPs_genre_atom,   36,  64, 0,  9.996114e+01 },
    { "Rb_natural",         PoPs_genre_atom,   37,  -1, 0,  8.54678e+01 },        
    { "Rb71",               PoPs_genre_atom,   37,  34, 0,  7.096532e+01 },       
    { "Rb72",               PoPs_genre_atom,   37,  35, 0,  7.195908e+01 },       
    { "Rb73",               PoPs_genre_atom,   37,  36, 0,  7.2950561e+01 },
    { "Rb74",               PoPs_genre_atom,   37,  37, 0,  7.3944264751e+01 },   
    { "Rb75",               PoPs_genre_atom,   37,  38, 0,  7.493857e+01 },       
    { "Rb76",               PoPs_genre_atom,   37,  39, 0,  7.5935072226e+01 },   
    { "Rb77",               PoPs_genre_atom,   37,  40, 0,  7.6930408e+01 },
    { "Rb78",               PoPs_genre_atom,   37,  41, 0,  7.7928141e+01 },      
    { "Rb79",               PoPs_genre_atom,   37,  42, 0,  7.892398946e+01 },    
    { "Rb80",               PoPs_genre_atom,   37,  43, 0,  7.992251925e+01 },    
    { "Rb81",               PoPs_genre_atom,   37,  44, 0,  8.0918995913e+01 },
    { "Rb82",               PoPs_genre_atom,   37,  45, 0,  8.1918208598e+01 },   
    { "Rb83",               PoPs_genre_atom,   37,  46, 0,  8.2915109701e+01 },   
    { "Rb84",               PoPs_genre_atom,   37,  47, 0,  8.3914384821e+01 },   
    { "Rb85",               PoPs_genre_atom,   37,  48, 0,  8.4911789737e+01 },
    { "Rb86",               PoPs_genre_atom,   37,  49, 0,  Rb86_Mass },   
    { "Rb87",               PoPs_genre_atom,   37,  50, 0,  8.6909180526e+01 },   
    { "Rb88",               PoPs_genre_atom,   37,  51, 0,  8.7911315588e+01 },   
    { "Rb89",               PoPs_genre_atom,   37,  52, 0,  8.8912278016e+01 },
    { "Rb90",               PoPs_genre_atom,   37,  53, 0,  Rb90_Mass },   
    { "Rb91",               PoPs_genre_atom,   37,  54, 0,  9.0916536958e+01 },   
    { "Rb92",               PoPs_genre_atom,   37,  55, 0,  9.19197289e+01 },     
    { "Rb93",               PoPs_genre_atom,   37,  56, 0,  9.292204187599999e+01 },
    { "Rb94",               PoPs_genre_atom,   37,  57, 0,  9.3926404946e+01 },   
    { "Rb95",               PoPs_genre_atom,   37,  58, 0,  9.4929302889e+01 },   
    { "Rb96",               PoPs_genre_atom,   37,  59, 0,  9.5934272637e+01 },   
    { "Rb97",               PoPs_genre_atom,   37,  60, 0,  9.6937351916e+01 },
    { "Rb98",               PoPs_genre_atom,   37,  61, 0,  9.7941790668e+01 },   
    { "Rb99",               PoPs_genre_atom,   37,  62, 0,  9.8945379283e+01 },   
    { "Rb100",              PoPs_genre_atom,   37,  63, 0,  9.994987e+01 },       
    { "Rb101",              PoPs_genre_atom,   37,  64, 0,  1.00953196445e+02 },
    { "Rb102",              PoPs_genre_atom,   37,  65, 0,  1.0195887e+02 },      
    { "Sr_natural",         PoPs_genre_atom,   38,  -1, 0,  8.762e+01 },          
    { "Sr73",               PoPs_genre_atom,   38,  35, 0,  7.296597e+01 },       
    { "Sr74",               PoPs_genre_atom,   38,  36, 0,  7.395631e+01 },
    { "Sr75",               PoPs_genre_atom,   38,  37, 0,  7.4949949568e+01 },   
    { "Sr76",               PoPs_genre_atom,   38,  38, 0,  7.5941766782e+01 },   
    { "Sr77",               PoPs_genre_atom,   38,  39, 0,  7.6937944782e+01 },   
    { "Sr78",               PoPs_genre_atom,   38,  40, 0,  7.793218e+01 },
    { "Sr79",               PoPs_genre_atom,   38,  41, 0,  7.8929708e+01 },      
    { "Sr80",               PoPs_genre_atom,   38,  42, 0,  7.9924521013e+01 },   
    { "Sr81",               PoPs_genre_atom,   38,  43, 0,  8.0923211846e+01 },   
    { "Sr82",               PoPs_genre_atom,   38,  44, 0,  8.1918401639e+01 },
    { "Sr83",               PoPs_genre_atom,   38,  45, 0,  8.2917556701e+01 },   
    { "Sr84",               PoPs_genre_atom,   38,  46, 0,  8.3913425275e+01 },   
    { "Sr85",               PoPs_genre_atom,   38,  47, 0,  8.4912932803e+01 },   
    { "Sr86",               PoPs_genre_atom,   38,  48, 0,  8.5909260204e+01 },
    { "Sr87",               PoPs_genre_atom,   38,  49, 0,  Sr87_Mass },   
    { "Sr88",               PoPs_genre_atom,   38,  50, 0,  8.7905612124e+01 },   
    { "Sr89",               PoPs_genre_atom,   38,  51, 0,  8.8907450675e+01 },   
    { "Sr90",               PoPs_genre_atom,   38,  52, 0,  8.9907737888e+01 },
    { "Sr91",               PoPs_genre_atom,   38,  53, 0,  9.0910203095e+01 },   
    { "Sr92",               PoPs_genre_atom,   38,  54, 0,  9.1911037858e+01 },   
    { "Sr93",               PoPs_genre_atom,   38,  55, 0,  9.2914025634e+01 },   
    { "Sr94",               PoPs_genre_atom,   38,  56, 0,  9.3915361312e+01 },
    { "Sr95",               PoPs_genre_atom,   38,  57, 0,  9.4919358766e+01 },   
    { "Sr96",               PoPs_genre_atom,   38,  58, 0,  9.5921696802e+01 },   
    { "Sr97",               PoPs_genre_atom,   38,  59, 0,  9.6926152923e+01 },   
    { "Sr98",               PoPs_genre_atom,   38,  60, 0,  9.7928452934e+01 },
    { "Sr99",               PoPs_genre_atom,   38,  61, 0,  9.8933240926e+01 },   
    { "Sr100",              PoPs_genre_atom,   38,  62, 0,  9.9935351911e+01 },   
    { "Sr101",              PoPs_genre_atom,   38,  63, 0,  1.00940517888e+02 },  
    { "Sr102",              PoPs_genre_atom,   38,  64, 0,  1.01943018987e+02 },
    { "Sr103",              PoPs_genre_atom,   38,  65, 0,  1.0294895e+02 },      
    { "Sr104",              PoPs_genre_atom,   38,  66, 0,  1.0395233e+02 },      
    { "Sr105",              PoPs_genre_atom,   38,  67, 0,  1.0495858e+02 },      
    { "Y_natural",          PoPs_genre_atom,   39,  -1, 0,  8.89059e+01 },
    { "Y76",                PoPs_genre_atom,   39,  37, 0,  7.595845e+01 },       
    { "Y77",                PoPs_genre_atom,   39,  38, 0,  7.6949645e+01 },      
    { "Y78",                PoPs_genre_atom,   39,  39, 0,  7.794361e+01 },       
    { "Y79",                PoPs_genre_atom,   39,  40, 0,  7.8937351634e+01 },
    { "Y80",                PoPs_genre_atom,   39,  41, 0,  7.993428e+01 },       
    { "Y81",                PoPs_genre_atom,   39,  42, 0,  8.0929127468e+01 },   
    { "Y82",                PoPs_genre_atom,   39,  43, 0,  8.1926792451e+01 },   
    { "Y83",                PoPs_genre_atom,   39,  44, 0,  8.2922354243e+01 },
    { "Y84",                PoPs_genre_atom,   39,  45, 0,  8.3920388264e+01 },   
    { "Y85",                PoPs_genre_atom,   39,  46, 0,  8.4916433039e+01 },   
    { "Y86",                PoPs_genre_atom,   39,  47, 0,  8.5914885576e+01 },   
    { "Y87",                PoPs_genre_atom,   39,  48, 0,  8.691087573e+01 },
    { "Y88",                PoPs_genre_atom,   39,  49, 0,  Y88_Mass },   
    { "Y89",                PoPs_genre_atom,   39,  50, 0,  Y89_Mass },   
    { "Y90",                PoPs_genre_atom,   39,  51, 0,  Y90_Mass },   
    { "Y91",                PoPs_genre_atom,   39,  52, 0,  9.0907304791e+01 },
    { "Y92",                PoPs_genre_atom,   39,  53, 0,  9.1908949143e+01 },   
    { "Y93",                PoPs_genre_atom,   39,  54, 0,  9.2909582713e+01 },   
    { "Y94",                PoPs_genre_atom,   39,  55, 0,  9.3911595245e+01 },   
    { "Y95",                PoPs_genre_atom,   39,  56, 0,  9.491282062099999e+01 },
    { "Y96",                PoPs_genre_atom,   39,  57, 0,  9.5915891343e+01 },   
    { "Y97",                PoPs_genre_atom,   39,  58, 0,  9.6918133995e+01 },   
    { "Y98",                PoPs_genre_atom,   39,  59, 0,  9.792220302e+01 },    
    { "Y99",                PoPs_genre_atom,   39,  60, 0,  9.8924636204e+01 },
    { "Y100",               PoPs_genre_atom,   39,  61, 0,  9.9927756586e+01 },   
    { "Y101",               PoPs_genre_atom,   39,  62, 0,  1.0093031385e+02 },   
    { "Y102",               PoPs_genre_atom,   39,  63, 0,  1.01933555695e+02 },  
    { "Y103",               PoPs_genre_atom,   39,  64, 0,  1.0293673e+02 },
    { "Y104",               PoPs_genre_atom,   39,  65, 0,  1.0394105e+02 },      
    { "Y105",               PoPs_genre_atom,   39,  66, 0,  1.0494487e+02 },      
    { "Y106",               PoPs_genre_atom,   39,  67, 0,  1.0594979e+02 },      
    { "Y107",               PoPs_genre_atom,   39,  68, 0,  1.0695414e+02 },
    { "Y108",               PoPs_genre_atom,   39,  69, 0,  1.0795948e+02 },      
    { "Zr_natural",         PoPs_genre_atom,   40,  -1, 0,  9.122e+01 },          
    { "Zr78",               PoPs_genre_atom,   40,  38, 0,  7.795523e+01 },       
    { "Zr79",               PoPs_genre_atom,   40,  39, 0,  7.894916e+01 },
    { "Zr80",               PoPs_genre_atom,   40,  40, 0,  7.99404e+01 },        
    { "Zr81",               PoPs_genre_atom,   40,  41, 0,  8.0937210026e+01 },   
    { "Zr82",               PoPs_genre_atom,   40,  42, 0,  8.1931087e+01 },      
    { "Zr83",               PoPs_genre_atom,   40,  43, 0,  8.2928653801e+01 },
    { "Zr84",               PoPs_genre_atom,   40,  44, 0,  8.392325e+01 },       
    { "Zr85",               PoPs_genre_atom,   40,  45, 0,  8.4921471182e+01 },   
    { "Zr86",               PoPs_genre_atom,   40,  46, 0,  8.5916473591e+01 },   
    { "Zr87",               PoPs_genre_atom,   40,  47, 0,  8.691481625199999e+01 },
    { "Zr88",               PoPs_genre_atom,   40,  48, 0,  8.7910226904e+01 },   
    { "Zr89",               PoPs_genre_atom,   40,  49, 0,  8.89088895e+01 },     
    { "Zr90",               PoPs_genre_atom,   40,  50, 0,  8.9904704416e+01 },   
    { "Zr91",               PoPs_genre_atom,   40,  51, 0,  9.0905645767e+01 },
    { "Zr92",               PoPs_genre_atom,   40,  52, 0,  9.1905040847e+01 },   
    { "Zr93",               PoPs_genre_atom,   40,  53, 0,  9.2906476006e+01 },   
    { "Zr94",               PoPs_genre_atom,   40,  54, 0,  9.3906315192e+01 },   
    { "Zr95",               PoPs_genre_atom,   40,  55, 0,  9.49080426e+01 },
    { "Zr96",               PoPs_genre_atom,   40,  56, 0,  9.5908273386e+01 },   
    { "Zr97",               PoPs_genre_atom,   40,  57, 0,  9.6910953109e+01 },   
    { "Zr98",               PoPs_genre_atom,   40,  58, 0,  9.7912734892e+01 },   
    { "Zr99",               PoPs_genre_atom,   40,  59, 0,  9.8916512106e+01 },
    { "Zr100",              PoPs_genre_atom,   40,  60, 0,  9.9917761889e+01 },   
    { "Zr101",              PoPs_genre_atom,   40,  61, 0,  1.00921140415e+02 },  
    { "Zr102",              PoPs_genre_atom,   40,  62, 0,  1.01922981285e+02 },  
    { "Zr103",              PoPs_genre_atom,   40,  63, 0,  1.02926599606e+02 },
    { "Zr104",              PoPs_genre_atom,   40,  64, 0,  1.0392878e+02 },      
    { "Zr105",              PoPs_genre_atom,   40,  65, 0,  1.0493305e+02 },      
    { "Zr106",              PoPs_genre_atom,   40,  66, 0,  1.0593591e+02 },      
    { "Zr107",              PoPs_genre_atom,   40,  67, 0,  1.0694075e+02 },
    { "Zr108",              PoPs_genre_atom,   40,  68, 0,  1.0794396e+02 },      
    { "Zr109",              PoPs_genre_atom,   40,  69, 0,  1.0894924e+02 },      
    { "Zr110",              PoPs_genre_atom,   40,  70, 0,  1.0995287e+02 },      
    { "Nb_natural",         PoPs_genre_atom,   41,  -1, 0,  9.29064e+01 },
    { "Nb81",               PoPs_genre_atom,   41,  40, 0,  8.094903e+01 },       
    { "Nb82",               PoPs_genre_atom,   41,  41, 0,  8.194313e+01 },       
    { "Nb83",               PoPs_genre_atom,   41,  42, 0,  8.2936705382e+01 },   
    { "Nb84",               PoPs_genre_atom,   41,  43, 0,  8.393357e+01 },
    { "Nb85",               PoPs_genre_atom,   41,  44, 0,  8.4927912447e+01 },   
    { "Nb86",               PoPs_genre_atom,   41,  45, 0,  8.5925038326e+01 },   
    { "Nb87",               PoPs_genre_atom,   41,  46, 0,  8.6920361108e+01 },   
    { "Nb88",               PoPs_genre_atom,   41,  47, 0,  8.7918332163e+01 },
    { "Nb89",               PoPs_genre_atom,   41,  48, 0,  8.8913418245e+01 },   
    { "Nb90",               PoPs_genre_atom,   41,  49, 0,  8.9911264845e+01 },   
    { "Nb91",               PoPs_genre_atom,   41,  50, 0,  9.0906996243e+01 },   
    { "Nb92",               PoPs_genre_atom,   41,  51, 0,  9.190719388799999e+01 },
    { "Nb93",               PoPs_genre_atom,   41,  52, 0,  Nb93_Mass },   
    { "Nb94",               PoPs_genre_atom,   41,  53, 0,  9.3907283888e+01 },   
    { "Nb95",               PoPs_genre_atom,   41,  54, 0,  9.4906835792e+01 },   
    { "Nb96",               PoPs_genre_atom,   41,  55, 0,  9.5908100647e+01 },
    { "Nb97",               PoPs_genre_atom,   41,  56, 0,  9.6908098556e+01 },   
    { "Nb98",               PoPs_genre_atom,   41,  57, 0,  9.7910328412e+01 },   
    { "Nb99",               PoPs_genre_atom,   41,  58, 0,  9.8911618375e+01 },   
    { "Nb100",              PoPs_genre_atom,   41,  59, 0,  9.9914181619e+01 },
    { "Nb101",              PoPs_genre_atom,   41,  60, 0,  1.00915252025e+02 },  
    { "Nb102",              PoPs_genre_atom,   41,  61, 0,  1.01918037614e+02 },  
    { "Nb103",              PoPs_genre_atom,   41,  62, 0,  1.02919143842e+02 },  
    { "Nb104",              PoPs_genre_atom,   41,  63, 0,  1.03922464701e+02 },
    { "Nb105",              PoPs_genre_atom,   41,  64, 0,  1.04923936545e+02 },  
    { "Nb106",              PoPs_genre_atom,   41,  65, 0,  1.0592797e+02 },      
    { "Nb107",              PoPs_genre_atom,   41,  66, 0,  1.0693031e+02 },      
    { "Nb108",              PoPs_genre_atom,   41,  67, 0,  1.0793484e+02 },
    { "Nb109",              PoPs_genre_atom,   41,  68, 0,  1.0893763e+02 },      
    { "Nb110",              PoPs_genre_atom,   41,  69, 0,  1.0994244e+02 },      
    { "Nb111",              PoPs_genre_atom,   41,  70, 0,  1.1094565e+02 },      
    { "Nb112",              PoPs_genre_atom,   41,  71, 0,  1.1195083e+02 },
    { "Nb113",              PoPs_genre_atom,   41,  72, 0,  1.129547e+02 },       
    { "Mo_natural",         PoPs_genre_atom,   42,  -1, 0,  9.594e+01 },          
    { "Mo83",               PoPs_genre_atom,   42,  41, 0,  8.294874e+01 },       
    { "Mo84",               PoPs_genre_atom,   42,  42, 0,  8.394009e+01 },
    { "Mo85",               PoPs_genre_atom,   42,  43, 0,  8.493655e+01 },       
    { "Mo86",               PoPs_genre_atom,   42,  44, 0,  8.5930695904e+01 },   
    { "Mo87",               PoPs_genre_atom,   42,  45, 0,  8.6927326502e+01 },   
    { "Mo88",               PoPs_genre_atom,   42,  46, 0,  8.7921953241e+01 },
    { "Mo89",               PoPs_genre_atom,   42,  47, 0,  8.8919480009e+01 },   
    { "Mo90",               PoPs_genre_atom,   42,  48, 0,  8.9913936896e+01 },   
    { "Mo91",               PoPs_genre_atom,   42,  49, 0,  9.0911750194e+01 },   
    { "Mo92",               PoPs_genre_atom,   42,  50, 0,  9.1906810991e+01 },
    { "Mo93",               PoPs_genre_atom,   42,  51, 0,  9.290681261e+01 },    
    { "Mo94",               PoPs_genre_atom,   42,  52, 0,  9.3905088269e+01 },   
    { "Mo95",               PoPs_genre_atom,   42,  53, 0,  9.4905842129e+01 },   
    { "Mo96",               PoPs_genre_atom,   42,  54, 0,  9.5904679477e+01 },
    { "Mo97",               PoPs_genre_atom,   42,  55, 0,  9.6906021465e+01 },   
    { "Mo98",               PoPs_genre_atom,   42,  56, 0,  9.7905408169e+01 },   
    { "Mo99",               PoPs_genre_atom,   42,  57, 0,  9.890771187e+01 },    
    { "Mo100",              PoPs_genre_atom,   42,  58, 0,  9.9907477336e+01 },
    { "Mo101",              PoPs_genre_atom,   42,  59, 0,  1.00910347001e+02 },  
    { "Mo102",              PoPs_genre_atom,   42,  60, 0,  1.0191029736e+02 },   
    { "Mo103",              PoPs_genre_atom,   42,  61, 0,  1.02913207142e+02 },  
    { "Mo104",              PoPs_genre_atom,   42,  62, 0,  1.03913763625e+02 },
    { "Mo105",              PoPs_genre_atom,   42,  63, 0,  1.0491697461e+02 },   
    { "Mo106",              PoPs_genre_atom,   42,  64, 0,  1.05918136802e+02 },  
    { "Mo107",              PoPs_genre_atom,   42,  65, 0,  1.06921692604e+02 },  
    { "Mo108",              PoPs_genre_atom,   42,  66, 0,  1.07923453e+02 },
    { "Mo109",              PoPs_genre_atom,   42,  67, 0,  1.0892781e+02 },      
    { "Mo110",              PoPs_genre_atom,   42,  68, 0,  1.0992973e+02 },      
    { "Mo111",              PoPs_genre_atom,   42,  69, 0,  1.1093441e+02 },      
    { "Mo112",              PoPs_genre_atom,   42,  70, 0,  1.1193684e+02 },
    { "Mo113",              PoPs_genre_atom,   42,  71, 0,  1.1294188e+02 },      
    { "Mo114",              PoPs_genre_atom,   42,  72, 0,  1.1394492e+02 },      
    { "Mo115",              PoPs_genre_atom,   42,  73, 0,  1.1495029e+02 },      
    { "Tc_natural",         PoPs_genre_atom,   43,  -1, 0,  9.8e+01 },
    { "Tc85",               PoPs_genre_atom,   43,  42, 0,  8.494883e+01 },       
    { "Tc86",               PoPs_genre_atom,   43,  43, 0,  8.594288e+01 },       
    { "Tc87",               PoPs_genre_atom,   43,  44, 0,  8.693653e+01 },       
    { "Tc88",               PoPs_genre_atom,   43,  45, 0,  8.7932678e+01 },
    { "Tc89",               PoPs_genre_atom,   43,  46, 0,  8.8927167e+01 },      
    { "Tc90",               PoPs_genre_atom,   43,  47, 0,  8.9923556564e+01 },   
    { "Tc91",               PoPs_genre_atom,   43,  48, 0,  9.0918427639e+01 },   
    { "Tc92",               PoPs_genre_atom,   43,  49, 0,  9.1915260166e+01 },
    { "Tc93",               PoPs_genre_atom,   43,  50, 0,  9.2910248984e+01 },   
    { "Tc94",               PoPs_genre_atom,   43,  51, 0,  9.3909657002e+01 },   
    { "Tc95",               PoPs_genre_atom,   43,  52, 0,  9.4907657084e+01 },   
    { "Tc96",               PoPs_genre_atom,   43,  53, 0,  9.5907871383e+01 },
    { "Tc97",               PoPs_genre_atom,   43,  54, 0,  9.6906365358e+01 },   
    { "Tc98",               PoPs_genre_atom,   43,  55, 0,  9.7907215966e+01 },   
    { "Tc99",               PoPs_genre_atom,   43,  56, 0,  9.8906254747e+01 },   
    { "Tc100",              PoPs_genre_atom,   43,  57, 0,  9.990765778e+01 },
    { "Tc101",              PoPs_genre_atom,   43,  58, 0,  1.00907314659e+02 },  
    { "Tc102",              PoPs_genre_atom,   43,  59, 0,  1.01909215019e+02 },  
    { "Tc103",              PoPs_genre_atom,   43,  60, 0,  1.02909181351e+02 },  
    { "Tc104",              PoPs_genre_atom,   43,  61, 0,  1.03911447454e+02 },
    { "Tc105",              PoPs_genre_atom,   43,  62, 0,  1.04911660566e+02 },  
    { "Tc106",              PoPs_genre_atom,   43,  63, 0,  1.05914357927e+02 },  
    { "Tc107",              PoPs_genre_atom,   43,  64, 0,  1.06915079572e+02 },  
    { "Tc108",              PoPs_genre_atom,   43,  65, 0,  1.07918461226e+02 },
    { "Tc109",              PoPs_genre_atom,   43,  66, 0,  1.08919982665e+02 },  
    { "Tc110",              PoPs_genre_atom,   43,  67, 0,  1.09923820483e+02 },  
    { "Tc111",              PoPs_genre_atom,   43,  68, 0,  1.1092569283e+02 },   
    { "Tc112",              PoPs_genre_atom,   43,  69, 0,  1.11929146493e+02 },
    { "Tc113",              PoPs_genre_atom,   43,  70, 0,  1.1293159e+02 },      
    { "Tc114",              PoPs_genre_atom,   43,  71, 0,  1.1393588e+02 },      
    { "Tc115",              PoPs_genre_atom,   43,  72, 0,  1.1493869e+02 },      
    { "Tc116",              PoPs_genre_atom,   43,  73, 0,  1.1594337e+02 },
    { "Tc117",              PoPs_genre_atom,   43,  74, 0,  1.1694648e+02 },      
    { "Tc118",              PoPs_genre_atom,   43,  75, 0,  1.1795148e+02 },      
    { "Ru_natural",         PoPs_genre_atom,   44,  -1, 0,  1.0107e+02 },         
    { "Ru87",               PoPs_genre_atom,   44,  43, 0,  8.694918e+01 },
    { "Ru88",               PoPs_genre_atom,   44,  44, 0,  8.794026e+01 },       
    { "Ru89",               PoPs_genre_atom,   44,  45, 0,  8.893611e+01 },       
    { "Ru90",               PoPs_genre_atom,   44,  46, 0,  8.992989e+01 },       
    { "Ru91",               PoPs_genre_atom,   44,  47, 0,  9.0926292e+01 },
    { "Ru92",               PoPs_genre_atom,   44,  48, 0,  9.192012e+01 },       
    { "Ru93",               PoPs_genre_atom,   44,  49, 0,  9.2917052034e+01 },   
    { "Ru94",               PoPs_genre_atom,   44,  50, 0,  9.3911359711e+01 },   
    { "Ru95",               PoPs_genre_atom,   44,  51, 0,  9.4910412929e+01 },
    { "Ru96",               PoPs_genre_atom,   44,  52, 0,  9.5907597835e+01 },   
    { "Ru97",               PoPs_genre_atom,   44,  53, 0,  9.69075547e+01 },     
    { "Ru98",               PoPs_genre_atom,   44,  54, 0,  9.7905287132e+01 },   
    { "Ru99",               PoPs_genre_atom,   44,  55, 0,  9.890593930199999e+01 },
    { "Ru100",              PoPs_genre_atom,   44,  56, 0,  9.9904219476e+01 },   
    { "Ru101",              PoPs_genre_atom,   44,  57, 0,  1.00905582087e+02 },  
    { "Ru102",              PoPs_genre_atom,   44,  58, 0,  1.01904349312e+02 },  
    { "Ru103",              PoPs_genre_atom,   44,  59, 0,  1.02906323847e+02 },
    { "Ru104",              PoPs_genre_atom,   44,  60, 0,  1.03905432701e+02 },  
    { "Ru105",              PoPs_genre_atom,   44,  61, 0,  1.04907752866e+02 },  
    { "Ru106",              PoPs_genre_atom,   44,  62, 0,  1.05907329433e+02 },  
    { "Ru107",              PoPs_genre_atom,   44,  63, 0,  1.06909905089e+02 },
    { "Ru108",              PoPs_genre_atom,   44,  64, 0,  1.07910173465e+02 },  
    { "Ru109",              PoPs_genre_atom,   44,  65, 0,  1.08913203233e+02 },  
    { "Ru110",              PoPs_genre_atom,   44,  66, 0,  1.09914136041e+02 },  
    { "Ru111",              PoPs_genre_atom,   44,  67, 0,  1.10917696e+02 },
    { "Ru112",              PoPs_genre_atom,   44,  68, 0,  1.11918965e+02 },     
    { "Ru113",              PoPs_genre_atom,   44,  69, 0,  1.12922487194e+02 },  
    { "Ru114",              PoPs_genre_atom,   44,  70, 0,  1.13924281e+02 },     
    { "Ru115",              PoPs_genre_atom,   44,  71, 0,  1.14928686173e+02 },
    { "Ru116",              PoPs_genre_atom,   44,  72, 0,  1.1593081e+02 },      
    { "Ru117",              PoPs_genre_atom,   44,  73, 0,  1.1693558e+02 },      
    { "Ru118",              PoPs_genre_atom,   44,  74, 0,  1.1793782e+02 },      
    { "Ru119",              PoPs_genre_atom,   44,  75, 0,  1.1894284e+02 },
    { "Ru120",              PoPs_genre_atom,   44,  76, 0,  1.1994531e+02 },      
    { "Rh_natural",         PoPs_genre_atom,   45,  -1, 0,  1.029055e+02 },       
    { "Rh89",               PoPs_genre_atom,   45,  44, 0,  8.8948837e+01 },      
    { "Rh90",               PoPs_genre_atom,   45,  45, 0,  8.994287e+01 },
    { "Rh91",               PoPs_genre_atom,   45,  46, 0,  9.093655e+01 },       
    { "Rh92",               PoPs_genre_atom,   45,  47, 0,  9.193198e+01 },       
    { "Rh93",               PoPs_genre_atom,   45,  48, 0,  9.292574e+01 },       
    { "Rh94",               PoPs_genre_atom,   45,  49, 0,  9.3921698e+01 },
    { "Rh95",               PoPs_genre_atom,   45,  50, 0,  9.491589874e+01 },    
    { "Rh96",               PoPs_genre_atom,   45,  51, 0,  9.5914460631e+01 },   
    { "Rh97",               PoPs_genre_atom,   45,  52, 0,  9.6911336797e+01 },   
    { "Rh98",               PoPs_genre_atom,   45,  53, 0,  9.7910708158e+01 },
    { "Rh99",               PoPs_genre_atom,   45,  54, 0,  9.8908132104e+01 },   
    { "Rh100",              PoPs_genre_atom,   45,  55, 0,  9.990812155e+01 },    
    { "Rh101",              PoPs_genre_atom,   45,  56, 0,  1.00906163625e+02 },  
    { "Rh102",              PoPs_genre_atom,   45,  57, 0,  1.01906843196e+02 },
    { "Rh103",              PoPs_genre_atom,   45,  58, 0,  1.02905504292e+02 },  
    { "Rh104",              PoPs_genre_atom,   45,  59, 0,  1.03906655518e+02 },  
    { "Rh105",              PoPs_genre_atom,   45,  60, 0,  1.04905693821e+02 },  
    { "Rh106",              PoPs_genre_atom,   45,  61, 0,  1.05907287135e+02 },
    { "Rh107",              PoPs_genre_atom,   45,  62, 0,  1.06906748423e+02 },  
    { "Rh108",              PoPs_genre_atom,   45,  63, 0,  1.07908728018e+02 },  
    { "Rh109",              PoPs_genre_atom,   45,  64, 0,  1.08908737289e+02 },  
    { "Rh110",              PoPs_genre_atom,   45,  65, 0,  1.09911136411e+02 },
    { "Rh111",              PoPs_genre_atom,   45,  66, 0,  1.10911585913e+02 },  
    { "Rh112",              PoPs_genre_atom,   45,  67, 0,  1.11914394159e+02 },  
    { "Rh113",              PoPs_genre_atom,   45,  68, 0,  1.12915530627e+02 },  
    { "Rh114",              PoPs_genre_atom,   45,  69, 0,  1.13918806e+02 },
    { "Rh115",              PoPs_genre_atom,   45,  70, 0,  1.14920334e+02 },     
    { "Rh116",              PoPs_genre_atom,   45,  71, 0,  1.15924062e+02 },     
    { "Rh117",              PoPs_genre_atom,   45,  72, 0,  1.1692598e+02 },      
    { "Rh118",              PoPs_genre_atom,   45,  73, 0,  1.1793007e+02 },
    { "Rh119",              PoPs_genre_atom,   45,  74, 0,  1.1893211e+02 },      
    { "Rh120",              PoPs_genre_atom,   45,  75, 0,  1.1993641e+02 },      
    { "Rh121",              PoPs_genre_atom,   45,  76, 0,  1.2093872e+02 },      
    { "Rh122",              PoPs_genre_atom,   45,  77, 0,  1.2194321e+02 },
    { "Pd_natural",         PoPs_genre_atom,   46,  -1, 0,  1.064e+02 },          
    { "Pd91",               PoPs_genre_atom,   46,  45, 0,  9.094911e+01 },       
    { "Pd92",               PoPs_genre_atom,   46,  46, 0,  9.194042e+01 },       
    { "Pd93",               PoPs_genre_atom,   46,  47, 0,  9.293591e+01 },
    { "Pd94",               PoPs_genre_atom,   46,  48, 0,  9.392877e+01 },       
    { "Pd95",               PoPs_genre_atom,   46,  49, 0,  9.492469e+01 },       
    { "Pd96",               PoPs_genre_atom,   46,  50, 0,  9.5918164359e+01 },   
    { "Pd97",               PoPs_genre_atom,   46,  51, 0,  9.6916479073e+01 },
    { "Pd98",               PoPs_genre_atom,   46,  52, 0,  9.7912720902e+01 },   
    { "Pd99",               PoPs_genre_atom,   46,  53, 0,  9.8911767833e+01 },   
    { "Pd100",              PoPs_genre_atom,   46,  54, 0,  9.9908505886e+01 },   
    { "Pd101",              PoPs_genre_atom,   46,  55, 0,  1.00908289242e+02 },
    { "Pd102",              PoPs_genre_atom,   46,  56, 0,  1.01905608544e+02 },  
    { "Pd103",              PoPs_genre_atom,   46,  57, 0,  1.02906087307e+02 },  
    { "Pd104",              PoPs_genre_atom,   46,  58, 0,  1.03904035834e+02 },  
    { "Pd105",              PoPs_genre_atom,   46,  59, 0,  1.0490508492e+02 },
    { "Pd106",              PoPs_genre_atom,   46,  60, 0,  1.05903485715e+02 },  
    { "Pd107",              PoPs_genre_atom,   46,  61, 0,  1.06905133481e+02 },  
    { "Pd108",              PoPs_genre_atom,   46,  62, 0,  1.07903891701e+02 },  
    { "Pd109",              PoPs_genre_atom,   46,  63, 0,  1.08905950451e+02 },
    { "Pd110",              PoPs_genre_atom,   46,  64, 0,  1.09905153254e+02 },  
    { "Pd111",              PoPs_genre_atom,   46,  65, 0,  1.10907670734e+02 },  
    { "Pd112",              PoPs_genre_atom,   46,  66, 0,  1.11907314058e+02 },  
    { "Pd113",              PoPs_genre_atom,   46,  67, 0,  1.12910152908e+02 },
    { "Pd114",              PoPs_genre_atom,   46,  68, 0,  1.13910362638e+02 },  
    { "Pd115",              PoPs_genre_atom,   46,  69, 0,  1.14913683824e+02 },  
    { "Pd116",              PoPs_genre_atom,   46,  70, 0,  1.15914158662e+02 },  
    { "Pd117",              PoPs_genre_atom,   46,  71, 0,  1.16917841338e+02 },
    { "Pd118",              PoPs_genre_atom,   46,  72, 0,  1.179189843e+02 },    
    { "Pd119",              PoPs_genre_atom,   46,  73, 0,  1.1892311e+02 },      
    { "Pd120",              PoPs_genre_atom,   46,  74, 0,  1.19924691878e+02 },  
    { "Pd121",              PoPs_genre_atom,   46,  75, 0,  1.2092887e+02 },
    { "Pd122",              PoPs_genre_atom,   46,  76, 0,  1.2193055e+02 },      
    { "Pd123",              PoPs_genre_atom,   46,  77, 0,  1.2293493e+02 },      
    { "Pd124",              PoPs_genre_atom,   46,  78, 0,  1.2393688e+02 },      
    { "Ag_natural",         PoPs_genre_atom,   47,  -1, 0,  1.07868e+02 },
    { "Ag93",               PoPs_genre_atom,   47,  46, 0,  9.294978e+01 },       
    { "Ag94",               PoPs_genre_atom,   47,  47, 0,  9.394278e+01 },       
    { "Ag95",               PoPs_genre_atom,   47,  48, 0,  9.493548e+01 },       
    { "Ag96",               PoPs_genre_atom,   47,  49, 0,  9.593068e+01 },
    { "Ag97",               PoPs_genre_atom,   47,  50, 0,  9.6923972412e+01 },   
    { "Ag98",               PoPs_genre_atom,   47,  51, 0,  9.7921566201e+01 },   
    { "Ag99",               PoPs_genre_atom,   47,  52, 0,  9.8917597178e+01 },   
    { "Ag100",              PoPs_genre_atom,   47,  53, 0,  9.991610425499999e+01 },
    { "Ag101",              PoPs_genre_atom,   47,  54, 0,  1.00912802233e+02 },  
    { "Ag102",              PoPs_genre_atom,   47,  55, 0,  1.01911685e+02 },     
    { "Ag103",              PoPs_genre_atom,   47,  56, 0,  1.0290897272e+02 },   
    { "Ag104",              PoPs_genre_atom,   47,  57, 0,  1.03908629157e+02 },
    { "Ag105",              PoPs_genre_atom,   47,  58, 0,  1.04906528661e+02 },  
    { "Ag106",              PoPs_genre_atom,   47,  59, 0,  1.05906668921e+02 },  
    { "Ag107",              PoPs_genre_atom,   47,  60, 0,  1.0690509682e+02 },   
    { "Ag108",              PoPs_genre_atom,   47,  61, 0,  1.07905955556e+02 },
    { "Ag109",              PoPs_genre_atom,   47,  62, 0,  1.08904752292e+02 },  
    { "Ag110",              PoPs_genre_atom,   47,  63, 0,  Ag110_Mass },         
    { "Ag111",              PoPs_genre_atom,   47,  64, 0,  1.10905291157e+02 },  
    { "Ag112",              PoPs_genre_atom,   47,  65, 0,  1.11907004814e+02 },
    { "Ag113",              PoPs_genre_atom,   47,  66, 0,  1.12906566579e+02 },  
    { "Ag114",              PoPs_genre_atom,   47,  67, 0,  1.13908803704e+02 },  
    { "Ag115",              PoPs_genre_atom,   47,  68, 0,  1.14908762698e+02 },  
    { "Ag116",              PoPs_genre_atom,   47,  69, 0,  1.15911359933e+02 },
    { "Ag117",              PoPs_genre_atom,   47,  70, 0,  1.16911684562e+02 },  
    { "Ag118",              PoPs_genre_atom,   47,  71, 0,  1.17914582768e+02 },  
    { "Ag119",              PoPs_genre_atom,   47,  72, 0,  1.18915665059e+02 },  
    { "Ag120",              PoPs_genre_atom,   47,  73, 0,  1.19918787384e+02 },
    { "Ag121",              PoPs_genre_atom,   47,  74, 0,  1.20919848046e+02 },  
    { "Ag122",              PoPs_genre_atom,   47,  75, 0,  1.2192353e+02 },      
    { "Ag123",              PoPs_genre_atom,   47,  76, 0,  1.229249e+02 },       
    { "Ag124",              PoPs_genre_atom,   47,  77, 0,  1.2392864e+02 },
    { "Ag125",              PoPs_genre_atom,   47,  78, 0,  1.2493043e+02 },      
    { "Ag126",              PoPs_genre_atom,   47,  79, 0,  1.259345e+02 },       
    { "Ag127",              PoPs_genre_atom,   47,  80, 0,  1.2693677e+02 },      
    { "Ag128",              PoPs_genre_atom,   47,  81, 0,  1.2794117e+02 },
    { "Ag129",              PoPs_genre_atom,   47,  82, 0,  1.2894369e+02 },      
    { "Ag130",              PoPs_genre_atom,   47,  83, 0,  1.29950448e+02 },     
    { "Cd_natural",         PoPs_genre_atom,   48,  -1, 0,  1.1241e+02 },         
    { "Cd95",               PoPs_genre_atom,   48,  47, 0,  9.494987e+01 },
    { "Cd96",               PoPs_genre_atom,   48,  48, 0,  9.593977e+01 },       
    { "Cd97",               PoPs_genre_atom,   48,  49, 0,  9.693494e+01 },       
    { "Cd98",               PoPs_genre_atom,   48,  50, 0,  9.7927395546e+01 },   
    { "Cd99",               PoPs_genre_atom,   48,  51, 0,  9.892501e+01 },
    { "Cd100",              PoPs_genre_atom,   48,  52, 0,  9.9920289525e+01 },   
    { "Cd101",              PoPs_genre_atom,   48,  53, 0,  1.00918681538e+02 },  
    { "Cd102",              PoPs_genre_atom,   48,  54, 0,  1.01914462258e+02 },  
    { "Cd103",              PoPs_genre_atom,   48,  55, 0,  1.02913419246e+02 },
    { "Cd104",              PoPs_genre_atom,   48,  56, 0,  1.03909849475e+02 },  
    { "Cd105",              PoPs_genre_atom,   48,  57, 0,  1.04909467905e+02 },  
    { "Cd106",              PoPs_genre_atom,   48,  58, 0,  1.0590645941e+02 },   
    { "Cd107",              PoPs_genre_atom,   48,  59, 0,  1.06906617928e+02 },
    { "Cd108",              PoPs_genre_atom,   48,  60, 0,  1.07904183683e+02 },  
    { "Cd109",              PoPs_genre_atom,   48,  61, 0,  1.08904982293e+02 },  
    { "Cd110",              PoPs_genre_atom,   48,  62, 0,  1.0990300207e+02 },   
    { "Cd111",              PoPs_genre_atom,   48,  63, 0,  1.10904178107e+02 },
    { "Cd112",              PoPs_genre_atom,   48,  64, 0,  1.11902757809e+02 },  
    { "Cd113",              PoPs_genre_atom,   48,  65, 0,  1.12904401662e+02 },  
    { "Cd114",              PoPs_genre_atom,   48,  66, 0,  1.1390335854e+02 },   
    { "Cd115",              PoPs_genre_atom,   48,  67, 0,  Cd115_Mass },
    { "Cd116",              PoPs_genre_atom,   48,  68, 0,  1.15904755809e+02 },  
    { "Cd117",              PoPs_genre_atom,   48,  69, 0,  1.16907218618e+02 },  
    { "Cd118",              PoPs_genre_atom,   48,  70, 0,  1.1790691453e+02 },   
    { "Cd119",              PoPs_genre_atom,   48,  71, 0,  1.18909921597e+02 },
    { "Cd120",              PoPs_genre_atom,   48,  72, 0,  1.19909850129e+02 },  
    { "Cd121",              PoPs_genre_atom,   48,  73, 0,  1.20912977363e+02 },  
    { "Cd122",              PoPs_genre_atom,   48,  74, 0,  1.21913332432e+02 },  
    { "Cd123",              PoPs_genre_atom,   48,  75, 0,  1.22917002999e+02 },
    { "Cd124",              PoPs_genre_atom,   48,  76, 0,  1.23917647616e+02 },  
    { "Cd125",              PoPs_genre_atom,   48,  77, 0,  1.2492124637e+02 },   
    { "Cd126",              PoPs_genre_atom,   48,  78, 0,  1.25922353321e+02 },  
    { "Cd127",              PoPs_genre_atom,   48,  79, 0,  1.26926443864e+02 },
    { "Cd128",              PoPs_genre_atom,   48,  80, 0,  1.27927762285e+02 },  
    { "Cd129",              PoPs_genre_atom,   48,  81, 0,  1.2893215e+02 },      
    { "Cd130",              PoPs_genre_atom,   48,  82, 0,  1.29933901937e+02 },  
    { "Cd131",              PoPs_genre_atom,   48,  83, 0,  1.3094067e+02 },
    { "Cd132",              PoPs_genre_atom,   48,  84, 0,  1.3194555e+02 },      
    { "In_natural",         PoPs_genre_atom,   49,  -1, 0,  1.1482e+02 },         
    { "In97",               PoPs_genre_atom,   49,  48, 0,  9.694954e+01 },       
    { "In98",               PoPs_genre_atom,   49,  49, 0,  9.794214e+01 },
    { "In99",               PoPs_genre_atom,   49,  50, 0,  9.893422e+01 },       
    { "In100",              PoPs_genre_atom,   49,  51, 0,  9.9931110851e+01 },   
    { "In101",              PoPs_genre_atom,   49,  52, 0,  1.0092634e+02 },      
    { "In102",              PoPs_genre_atom,   49,  53, 0,  1.01924090238e+02 },
    { "In103",              PoPs_genre_atom,   49,  54, 0,  1.02919914188e+02 },  
    { "In104",              PoPs_genre_atom,   49,  55, 0,  1.03918296171e+02 },  
    { "In105",              PoPs_genre_atom,   49,  56, 0,  1.0491467354e+02 },   
    { "In106",              PoPs_genre_atom,   49,  57, 0,  1.05913465411e+02 },
    { "In107",              PoPs_genre_atom,   49,  58, 0,  1.069102951e+02 },    
    { "In108",              PoPs_genre_atom,   49,  59, 0,  1.0790969818e+02 },   
    { "In109",              PoPs_genre_atom,   49,  60, 0,  1.08907150507e+02 },  
    { "In110",              PoPs_genre_atom,   49,  61, 0,  1.09907165274e+02 },
    { "In111",              PoPs_genre_atom,   49,  62, 0,  1.10905103278e+02 },  
    { "In112",              PoPs_genre_atom,   49,  63, 0,  1.11905532331e+02 },  
    { "In113",              PoPs_genre_atom,   49,  64, 0,  1.12904057761e+02 },  
    { "In114",              PoPs_genre_atom,   49,  65, 0,  1.13904913876e+02 },
    { "In115",              PoPs_genre_atom,   49,  66, 0,  1.14903878484e+02 },  
    { "In116",              PoPs_genre_atom,   49,  67, 0,  In116_Mass },  
    { "In117",              PoPs_genre_atom,   49,  68, 0,  1.16904513564e+02 },  
    { "In118",              PoPs_genre_atom,   49,  69, 0,  1.17906354367e+02 },
    { "In119",              PoPs_genre_atom,   49,  70, 0,  1.1890584535e+02 },   
    { "In120",              PoPs_genre_atom,   49,  71, 0,  1.19907959608e+02 },  
    { "In121",              PoPs_genre_atom,   49,  72, 0,  1.20907845822e+02 },  
    { "In122",              PoPs_genre_atom,   49,  73, 0,  1.2191027601e+02 },
    { "In123",              PoPs_genre_atom,   49,  74, 0,  1.22910438276e+02 },  
    { "In124",              PoPs_genre_atom,   49,  75, 0,  1.23913175231e+02 },  
    { "In125",              PoPs_genre_atom,   49,  76, 0,  1.24913600588e+02 },  
    { "In126",              PoPs_genre_atom,   49,  77, 0,  1.25916463857e+02 },
    { "In127",              PoPs_genre_atom,   49,  78, 0,  1.26917353091e+02 },  
    { "In128",              PoPs_genre_atom,   49,  79, 0,  1.27920172328e+02 },  
    { "In129",              PoPs_genre_atom,   49,  80, 0,  1.2892169698e+02 },   
    { "In130",              PoPs_genre_atom,   49,  81, 0,  1.29924970049e+02 },
    { "In131",              PoPs_genre_atom,   49,  82, 0,  1.30926851767e+02 },  
    { "In132",              PoPs_genre_atom,   49,  83, 0,  1.3193299026e+02 },   
    { "In133",              PoPs_genre_atom,   49,  84, 0,  1.3293781e+02 },      
    { "In134",              PoPs_genre_atom,   49,  85, 0,  1.3394415e+02 },
    { "In135",              PoPs_genre_atom,   49,  86, 0,  1.3494933e+02 },      
    { "Sn_natural",         PoPs_genre_atom,   50,  -1, 0,  1.1869e+02 },         
    { "Sn99",               PoPs_genre_atom,   50,  49, 0,  9.894933e+01 },       
    { "Sn100",              PoPs_genre_atom,   50,  50, 0,  9.9939044343e+01 },
    { "Sn101",              PoPs_genre_atom,   50,  51, 0,  1.0093606e+02 },      
    { "Sn102",              PoPs_genre_atom,   50,  52, 0,  1.01930295324e+02 },  
    { "Sn103",              PoPs_genre_atom,   50,  53, 0,  1.029281e+02 },       
    { "Sn104",              PoPs_genre_atom,   50,  54, 0,  1.03923143223e+02 },
    { "Sn105",              PoPs_genre_atom,   50,  55, 0,  1.04921349437e+02 },  
    { "Sn106",              PoPs_genre_atom,   50,  56, 0,  1.0591688062e+02 },   
    { "Sn107",              PoPs_genre_atom,   50,  57, 0,  1.06915644329e+02 },  
    { "Sn108",              PoPs_genre_atom,   50,  58, 0,  1.07911925378e+02 },
    { "Sn109",              PoPs_genre_atom,   50,  59, 0,  1.08911283214e+02 },  
    { "Sn110",              PoPs_genre_atom,   50,  60, 0,  1.09907842791e+02 },  
    { "Sn111",              PoPs_genre_atom,   50,  61, 0,  1.1090773446e+02 },   
    { "Sn112",              PoPs_genre_atom,   50,  62, 0,  1.11904818207e+02 },
    { "Sn113",              PoPs_genre_atom,   50,  63, 0,  1.12905170577e+02 },  
    { "Sn114",              PoPs_genre_atom,   50,  64, 0,  1.13902778869e+02 },  
    { "Sn115",              PoPs_genre_atom,   50,  65, 0,  1.14903342397e+02 },  
    { "Sn116",              PoPs_genre_atom,   50,  66, 0,  1.1590174053e+02 },
    { "Sn117",              PoPs_genre_atom,   50,  67, 0,  1.16902951656e+02 },  
    { "Sn118",              PoPs_genre_atom,   50,  68, 0,  1.17901603167e+02 },  
    { "Sn119",              PoPs_genre_atom,   50,  69, 0,  1.1890330763e+02 },   
    { "Sn120",              PoPs_genre_atom,   50,  70, 0,  1.19902194676e+02 },
    { "Sn121",              PoPs_genre_atom,   50,  71, 0,  1.2090423548e+02 },   
    { "Sn122",              PoPs_genre_atom,   50,  72, 0,  1.21903439046e+02 },  
    { "Sn123",              PoPs_genre_atom,   50,  73, 0,  1.22905720838e+02 },  
    { "Sn124",              PoPs_genre_atom,   50,  74, 0,  1.23905273946e+02 },
    { "Sn125",              PoPs_genre_atom,   50,  75, 0,  1.24907784125e+02 },  
    { "Sn126",              PoPs_genre_atom,   50,  76, 0,  1.2590765328e+02 },   
    { "Sn127",              PoPs_genre_atom,   50,  77, 0,  1.26910360024e+02 },  
    { "Sn128",              PoPs_genre_atom,   50,  78, 0,  1.27910536624e+02 },
    { "Sn129",              PoPs_genre_atom,   50,  79, 0,  1.28913479e+02 },     
    { "Sn130",              PoPs_genre_atom,   50,  80, 0,  1.29913967295e+02 },  
    { "Sn131",              PoPs_genre_atom,   50,  81, 0,  1.30916999769e+02 },  
    { "Sn132",              PoPs_genre_atom,   50,  82, 0,  1.31917815713e+02 },
    { "Sn133",              PoPs_genre_atom,   50,  83, 0,  1.32923829249e+02 },  
    { "Sn134",              PoPs_genre_atom,   50,  84, 0,  1.33928291765e+02 },  
    { "Sn135",              PoPs_genre_atom,   50,  85, 0,  1.3493473e+02 },      
    { "Sn136",              PoPs_genre_atom,   50,  86, 0,  1.3593934e+02 },
    { "Sn137",              PoPs_genre_atom,   50,  87, 0,  1.3694599e+02 },      
    { "Sb_natural",         PoPs_genre_atom,   51,  -1, 0,  1.2175e+02 },         
    { "Sb103",              PoPs_genre_atom,   51,  52, 0,  1.0293969e+02 },      
    { "Sb104",              PoPs_genre_atom,   51,  53, 0,  1.03936472e+02 },
    { "Sb105",              PoPs_genre_atom,   51,  54, 0,  1.04931486348e+02 },  
    { "Sb106",              PoPs_genre_atom,   51,  55, 0,  1.05928791e+02 },     
    { "Sb107",              PoPs_genre_atom,   51,  56, 0,  1.0692415e+02 },      
    { "Sb108",              PoPs_genre_atom,   51,  57, 0,  1.0792216e+02 },
    { "Sb109",              PoPs_genre_atom,   51,  58, 0,  1.08918132426e+02 },  
    { "Sb110",              PoPs_genre_atom,   51,  59, 0,  1.09916753e+02 },     
    { "Sb111",              PoPs_genre_atom,   51,  60, 0,  1.10913163e+02 },     
    { "Sb112",              PoPs_genre_atom,   51,  61, 0,  1.11912398009e+02 },
    { "Sb113",              PoPs_genre_atom,   51,  62, 0,  1.12909371672e+02 },  
    { "Sb114",              PoPs_genre_atom,   51,  63, 0,  1.13909269e+02 },     
    { "Sb115",              PoPs_genre_atom,   51,  64, 0,  1.14906598e+02 },     
    { "Sb116",              PoPs_genre_atom,   51,  65, 0,  1.15906793629e+02 },
    { "Sb117",              PoPs_genre_atom,   51,  66, 0,  1.16904835941e+02 },  
    { "Sb118",              PoPs_genre_atom,   51,  67, 0,  1.17905528731e+02 },  
    { "Sb119",              PoPs_genre_atom,   51,  68, 0,  1.18903942009e+02 },  
    { "Sb120",              PoPs_genre_atom,   51,  69, 0,  1.19905072427e+02 },
    { "Sb121",              PoPs_genre_atom,   51,  70, 0,  1.20903815686e+02 },  
    { "Sb122",              PoPs_genre_atom,   51,  71, 0,  1.21905173651e+02 },  
    { "Sb123",              PoPs_genre_atom,   51,  72, 0,  1.2290421397e+02 },   
    { "Sb124",              PoPs_genre_atom,   51,  73, 0,  Sb124_Mass },
    { "Sb125",              PoPs_genre_atom,   51,  74, 0,  1.24905253818e+02 },  
    { "Sb126",              PoPs_genre_atom,   51,  75, 0,  1.2590724748e+02 },   
    { "Sb127",              PoPs_genre_atom,   51,  76, 0,  1.26906923609e+02 },  
    { "Sb128",              PoPs_genre_atom,   51,  77, 0,  1.27909169001e+02 },
    { "Sb129",              PoPs_genre_atom,   51,  78, 0,  1.28909148442e+02 },  
    { "Sb130",              PoPs_genre_atom,   51,  79, 0,  1.29911656324e+02 },  
    { "Sb131",              PoPs_genre_atom,   51,  80, 0,  1.30911982275e+02 },  
    { "Sb132",              PoPs_genre_atom,   51,  81, 0,  1.31914466896e+02 },
    { "Sb133",              PoPs_genre_atom,   51,  82, 0,  1.3291525163e+02 },   
    { "Sb134",              PoPs_genre_atom,   51,  83, 0,  1.33920379744e+02 },  
    { "Sb135",              PoPs_genre_atom,   51,  84, 0,  1.34925165771e+02 },  
    { "Sb136",              PoPs_genre_atom,   51,  85, 0,  1.3593035e+02 },
    { "Sb137",              PoPs_genre_atom,   51,  86, 0,  1.3693531e+02 },      
    { "Sb138",              PoPs_genre_atom,   51,  87, 0,  1.3794079e+02 },      
    { "Sb139",              PoPs_genre_atom,   51,  88, 0,  1.3894598e+02 },      
    { "Te_natural",         PoPs_genre_atom,   52,  -1, 0,  1.276e+02 },
    { "Te105",              PoPs_genre_atom,   52,  53, 0,  1.0494364e+02 },      
    { "Te106",              PoPs_genre_atom,   52,  54, 0,  1.05937504237e+02 },  
    { "Te107",              PoPs_genre_atom,   52,  55, 0,  1.06935006e+02 },     
    { "Te108",              PoPs_genre_atom,   52,  56, 0,  1.07929444597e+02 },
    { "Te109",              PoPs_genre_atom,   52,  57, 0,  1.08927415515e+02 },  
    { "Te110",              PoPs_genre_atom,   52,  58, 0,  1.09922407316e+02 },  
    { "Te111",              PoPs_genre_atom,   52,  59, 0,  1.10921110692e+02 },  
    { "Te112",              PoPs_genre_atom,   52,  60, 0,  1.11917013672e+02 },
    { "Te113",              PoPs_genre_atom,   52,  61, 0,  1.12915891e+02 },     
    { "Te114",              PoPs_genre_atom,   52,  62, 0,  1.13912089e+02 },     
    { "Te115",              PoPs_genre_atom,   52,  63, 0,  1.14911902e+02 },     
    { "Te116",              PoPs_genre_atom,   52,  64, 0,  1.1590846e+02 },
    { "Te117",              PoPs_genre_atom,   52,  65, 0,  1.16908644719e+02 },  
    { "Te118",              PoPs_genre_atom,   52,  66, 0,  1.17905827581e+02 },  
    { "Te119",              PoPs_genre_atom,   52,  67, 0,  1.18906403645e+02 },  
    { "Te120",              PoPs_genre_atom,   52,  68, 0,  1.19904020222e+02 },
    { "Te121",              PoPs_genre_atom,   52,  69, 0,  1.20904936424e+02 },  
    { "Te122",              PoPs_genre_atom,   52,  70, 0,  1.21903043898e+02 },  
    { "Te123",              PoPs_genre_atom,   52,  71, 0,  1.22904270029e+02 },  
    { "Te124",              PoPs_genre_atom,   52,  72, 0,  1.23902817896e+02 },
    { "Te125",              PoPs_genre_atom,   52,  73, 0,  1.24904430731e+02 },  
    { "Te126",              PoPs_genre_atom,   52,  74, 0,  1.25903311696e+02 },  
    { "Te127",              PoPs_genre_atom,   52,  75, 0,  Te127_Mass },         
    { "Te128",              PoPs_genre_atom,   52,  76, 0,  1.27904463056e+02 },
    { "Te129",              PoPs_genre_atom,   52,  77, 0,  Te129_Mass },         
    { "Te130",              PoPs_genre_atom,   52,  78, 0,  1.29906224399e+02 },  
    { "Te131",              PoPs_genre_atom,   52,  79, 0,  1.30908523864e+02 },  
    { "Te132",              PoPs_genre_atom,   52,  80, 0,  1.3190855316e+02 },
    { "Te133",              PoPs_genre_atom,   52,  81, 0,  1.32910955306e+02 },  
    { "Te134",              PoPs_genre_atom,   52,  82, 0,  1.33911368737e+02 },  
    { "Te135",              PoPs_genre_atom,   52,  83, 0,  1.34916448592e+02 },  
    { "Te136",              PoPs_genre_atom,   52,  84, 0,  1.35920101246e+02 },
    { "Te137",              PoPs_genre_atom,   52,  85, 0,  1.36925322954e+02 },  
    { "Te138",              PoPs_genre_atom,   52,  86, 0,  1.3792922e+02 },      
    { "Te139",              PoPs_genre_atom,   52,  87, 0,  1.3893473e+02 },      
    { "Te140",              PoPs_genre_atom,   52,  88, 0,  1.3993885e+02 },
    { "Te141",              PoPs_genre_atom,   52,  89, 0,  1.4094465e+02 },      
    { "Te142",              PoPs_genre_atom,   52,  90, 0,  1.4194908e+02 },      
    { "I_natural",          PoPs_genre_atom,   53,  -1, 0,  1.269045e+02 },       
    { "I108",               PoPs_genre_atom,   53,  55, 0,  1.07943475e+02 },
    { "I109",               PoPs_genre_atom,   53,  56, 0,  1.08938149417e+02 },  
    { "I110",               PoPs_genre_atom,   53,  57, 0,  1.09935242e+02 },     
    { "I111",               PoPs_genre_atom,   53,  58, 0,  1.10930276e+02 },     
    { "I112",               PoPs_genre_atom,   53,  59, 0,  1.1192797e+02 },
    { "I113",               PoPs_genre_atom,   53,  60, 0,  1.12923640583e+02 },  
    { "I114",               PoPs_genre_atom,   53,  61, 0,  1.1392185e+02 },      
    { "I115",               PoPs_genre_atom,   53,  62, 0,  1.14918048e+02 },     
    { "I116",               PoPs_genre_atom,   53,  63, 0,  1.15916808633e+02 },
    { "I117",               PoPs_genre_atom,   53,  64, 0,  1.1691365e+02 },      
    { "I118",               PoPs_genre_atom,   53,  65, 0,  1.17913074e+02 },     
    { "I119",               PoPs_genre_atom,   53,  66, 0,  1.18910074e+02 },     
    { "I120",               PoPs_genre_atom,   53,  67, 0,  1.19910048173e+02 },
    { "I121",               PoPs_genre_atom,   53,  68, 0,  1.20907366811e+02 },  
    { "I122",               PoPs_genre_atom,   53,  69, 0,  1.21907589284e+02 },  
    { "I123",               PoPs_genre_atom,   53,  70, 0,  1.22905588965e+02 },  
    { "I124",               PoPs_genre_atom,   53,  71, 0,  1.23906209852e+02 },
    { "I125",               PoPs_genre_atom,   53,  72, 0,  1.24904630164e+02 },  
    { "I126",               PoPs_genre_atom,   53,  73, 0,  1.25905624153e+02 },  
    { "I127",               PoPs_genre_atom,   53,  74, 0,  1.26904472681e+02 },  
    { "I128",               PoPs_genre_atom,   53,  75, 0,  1.27905809443e+02 },
    { "I129",               PoPs_genre_atom,   53,  76, 0,  1.28904987722e+02 },  
    { "I130",               PoPs_genre_atom,   53,  77, 0,  1.29906674247e+02 },  
    { "I131",               PoPs_genre_atom,   53,  78, 0,  1.30906124609e+02 },  
    { "I132",               PoPs_genre_atom,   53,  79, 0,  1.31907997381e+02 },
    { "I133",               PoPs_genre_atom,   53,  80, 0,  1.32907796939e+02 },  
    { "I134",               PoPs_genre_atom,   53,  81, 0,  1.33909744465e+02 },  
    { "I135",               PoPs_genre_atom,   53,  82, 0,  1.34910048121e+02 },  
    { "I136",               PoPs_genre_atom,   53,  83, 0,  1.35914653993e+02 },
    { "I137",               PoPs_genre_atom,   53,  84, 0,  1.3691787084e+02 },   
    { "I138",               PoPs_genre_atom,   53,  85, 0,  1.37922349591e+02 },  
    { "I139",               PoPs_genre_atom,   53,  86, 0,  1.38926099478e+02 },  
    { "I140",               PoPs_genre_atom,   53,  87, 0,  1.39931e+02 },
    { "I141",               PoPs_genre_atom,   53,  88, 0,  1.4093503e+02 },      
    { "I142",               PoPs_genre_atom,   53,  89, 0,  1.4194018e+02 },      
    { "I143",               PoPs_genre_atom,   53,  90, 0,  1.4294456e+02 },      
    { "I144",               PoPs_genre_atom,   53,  91, 0,  1.4394999e+02 },
    { "Xe_natural",         PoPs_genre_atom,   54,  -1, 0,  1.313e+02 },          
    { "Xe110",              PoPs_genre_atom,   54,  56, 0,  1.09944278068e+02 },  
    { "Xe111",              PoPs_genre_atom,   54,  57, 0,  1.10941602e+02 },     
    { "Xe112",              PoPs_genre_atom,   54,  58, 0,  1.11935623112e+02 },
    { "Xe113",              PoPs_genre_atom,   54,  59, 0,  1.12933341174e+02 },  
    { "Xe114",              PoPs_genre_atom,   54,  60, 0,  1.13927980306e+02 },  
    { "Xe115",              PoPs_genre_atom,   54,  61, 0,  1.1492629392e+02 },   
    { "Xe116",              PoPs_genre_atom,   54,  62, 0,  1.15921581087e+02 },
    { "Xe117",              PoPs_genre_atom,   54,  63, 0,  1.16920358735e+02 },  
    { "Xe118",              PoPs_genre_atom,   54,  64, 0,  1.17916178655e+02 },  
    { "Xe119",              PoPs_genre_atom,   54,  65, 0,  1.18915410688e+02 },  
    { "Xe120",              PoPs_genre_atom,   54,  66, 0,  1.19911784244e+02 },
    { "Xe121",              PoPs_genre_atom,   54,  67, 0,  1.20911461829e+02 },  
    { "Xe122",              PoPs_genre_atom,   54,  68, 0,  1.21908367632e+02 },  
    { "Xe123",              PoPs_genre_atom,   54,  69, 0,  1.2290848191e+02 },   
    { "Xe124",              PoPs_genre_atom,   54,  70, 0,  1.23905893003e+02 },
    { "Xe125",              PoPs_genre_atom,   54,  71, 0,  1.24906395464e+02 },  
    { "Xe126",              PoPs_genre_atom,   54,  72, 0,  1.25904273634e+02 },  
    { "Xe127",              PoPs_genre_atom,   54,  73, 0,  1.26905183723e+02 },  
    { "Xe128",              PoPs_genre_atom,   54,  74, 0,  1.27903531275e+02 },
    { "Xe129",              PoPs_genre_atom,   54,  75, 0,  1.28904779435e+02 },  
    { "Xe130",              PoPs_genre_atom,   54,  76, 0,  1.29903508007e+02 },  
    { "Xe131",              PoPs_genre_atom,   54,  77, 0,  1.30905082362e+02 },  
    { "Xe132",              PoPs_genre_atom,   54,  78, 0,  1.31904153457e+02 },
    { "Xe133",              PoPs_genre_atom,   54,  79, 0,  1.32905910722e+02 },  
    { "Xe134",              PoPs_genre_atom,   54,  80, 0,  1.33905394464e+02 },  
    { "Xe135",              PoPs_genre_atom,   54,  81, 0,  1.34907227495e+02 },  
    { "Xe136",              PoPs_genre_atom,   54,  82, 0,  1.35907218794e+02 },
    { "Xe137",              PoPs_genre_atom,   54,  83, 0,  1.36911562125e+02 },  
    { "Xe138",              PoPs_genre_atom,   54,  84, 0,  1.37913954475e+02 },  
    { "Xe139",              PoPs_genre_atom,   54,  85, 0,  1.38918792936e+02 },  
    { "Xe140",              PoPs_genre_atom,   54,  86, 0,  1.39921640943e+02 },
    { "Xe141",              PoPs_genre_atom,   54,  87, 0,  1.40926648049e+02 },  
    { "Xe142",              PoPs_genre_atom,   54,  88, 0,  1.4192970959e+02 },   
    { "Xe143",              PoPs_genre_atom,   54,  89, 0,  1.4293511e+02 },      
    { "Xe144",              PoPs_genre_atom,   54,  90, 0,  1.4393851e+02 },
    { "Xe145",              PoPs_genre_atom,   54,  91, 0,  1.4494407e+02 },      
    { "Xe146",              PoPs_genre_atom,   54,  92, 0,  1.4594775e+02 },      
    { "Xe147",              PoPs_genre_atom,   54,  93, 0,  1.4695356e+02 },      
    { "Cs_natural",         PoPs_genre_atom,   55,  -1, 0,  1.329054e+02 },
    { "Cs112",              PoPs_genre_atom,   55,  57, 0,  1.11950301e+02 },     
    { "Cs113",              PoPs_genre_atom,   55,  58, 0,  1.12944493274e+02 },  
    { "Cs114",              PoPs_genre_atom,   55,  59, 0,  1.1394145e+02 },      
    { "Cs115",              PoPs_genre_atom,   55,  60, 0,  1.1493591e+02 },
    { "Cs116",              PoPs_genre_atom,   55,  61, 0,  1.15933367e+02 },     
    { "Cs117",              PoPs_genre_atom,   55,  62, 0,  1.16928670701e+02 },  
    { "Cs118",              PoPs_genre_atom,   55,  63, 0,  1.17926559494e+02 },  
    { "Cs119",              PoPs_genre_atom,   55,  64, 0,  1.18922377304e+02 },
    { "Cs120",              PoPs_genre_atom,   55,  65, 0,  1.19920677253e+02 },  
    { "Cs121",              PoPs_genre_atom,   55,  66, 0,  1.20917229209e+02 },  
    { "Cs122",              PoPs_genre_atom,   55,  67, 0,  1.21916113434e+02 },  
    { "Cs123",              PoPs_genre_atom,   55,  68, 0,  1.22912996036e+02 },
    { "Cs124",              PoPs_genre_atom,   55,  69, 0,  1.23912257798e+02 },  
    { "Cs125",              PoPs_genre_atom,   55,  70, 0,  1.2490972827e+02 },   
    { "Cs126",              PoPs_genre_atom,   55,  71, 0,  1.25909451977e+02 },  
    { "Cs127",              PoPs_genre_atom,   55,  72, 0,  1.26907417525e+02 },
    { "Cs128",              PoPs_genre_atom,   55,  73, 0,  1.27907748866e+02 },  
    { "Cs129",              PoPs_genre_atom,   55,  74, 0,  1.28906064426e+02 },  
    { "Cs130",              PoPs_genre_atom,   55,  75, 0,  1.29906708552e+02 },  
    { "Cs131",              PoPs_genre_atom,   55,  76, 0,  1.30905463926e+02 },
    { "Cs132",              PoPs_genre_atom,   55,  77, 0,  1.3190643426e+02 },   
    { "Cs133",              PoPs_genre_atom,   55,  78, 0,  1.32905451932e+02 },  
    { "Cs134",              PoPs_genre_atom,   55,  79, 0,  1.33906718475e+02 },  
    { "Cs135",              PoPs_genre_atom,   55,  80, 0,  1.34905977008e+02 },
    { "Cs136",              PoPs_genre_atom,   55,  81, 0,  1.35907311576e+02 },  
    { "Cs137",              PoPs_genre_atom,   55,  82, 0,  1.36907089473e+02 },  
    { "Cs138",              PoPs_genre_atom,   55,  83, 0,  1.37911016704e+02 },  
    { "Cs139",              PoPs_genre_atom,   55,  84, 0,  1.38913363999e+02 },
    { "Cs140",              PoPs_genre_atom,   55,  85, 0,  1.39917282354e+02 },  
    { "Cs141",              PoPs_genre_atom,   55,  86, 0,  1.40920045752e+02 },  
    { "Cs142",              PoPs_genre_atom,   55,  87, 0,  1.41924298927e+02 },  
    { "Cs143",              PoPs_genre_atom,   55,  88, 0,  1.4292735175e+02 },
    { "Cs144",              PoPs_genre_atom,   55,  89, 0,  1.43932076914e+02 },  
    { "Cs145",              PoPs_genre_atom,   55,  90, 0,  1.4493552617e+02 },   
    { "Cs146",              PoPs_genre_atom,   55,  91, 0,  1.45940289423e+02 },  
    { "Cs147",              PoPs_genre_atom,   55,  92, 0,  1.46944155008e+02 },
    { "Cs148",              PoPs_genre_atom,   55,  93, 0,  1.47949218153e+02 },  
    { "Cs149",              PoPs_genre_atom,   55,  94, 0,  1.4895293e+02 },      
    { "Cs150",              PoPs_genre_atom,   55,  95, 0,  1.4995817e+02 },      
    { "Cs151",              PoPs_genre_atom,   55,  96, 0,  1.5096219e+02 },
    { "Ba_natural",         PoPs_genre_atom,   56,  -1, 0,  1.3733e+02 },         
    { "Ba114",              PoPs_genre_atom,   56,  58, 0,  1.13950675405e+02 },  
    { "Ba115",              PoPs_genre_atom,   56,  59, 0,  1.1494737e+02 },      
    { "Ba116",              PoPs_genre_atom,   56,  60, 0,  1.1594138e+02 },
    { "Ba117",              PoPs_genre_atom,   56,  61, 0,  1.16938499e+02 },     
    { "Ba118",              PoPs_genre_atom,   56,  62, 0,  1.1793304e+02 },      
    { "Ba119",              PoPs_genre_atom,   56,  63, 0,  1.18930659661e+02 },  
    { "Ba120",              PoPs_genre_atom,   56,  64, 0,  1.19926044974e+02 },
    { "Ba121",              PoPs_genre_atom,   56,  65, 0,  1.20924054499e+02 },  
    { "Ba122",              PoPs_genre_atom,   56,  66, 0,  1.21919904e+02 },     
    { "Ba123",              PoPs_genre_atom,   56,  67, 0,  1.22918781036e+02 },  
    { "Ba124",              PoPs_genre_atom,   56,  68, 0,  1.23915093603e+02 },
    { "Ba125",              PoPs_genre_atom,   56,  69, 0,  1.24914472912e+02 },  
    { "Ba126",              PoPs_genre_atom,   56,  70, 0,  1.25911250177e+02 },  
    { "Ba127",              PoPs_genre_atom,   56,  71, 0,  1.26911093797e+02 },  
    { "Ba128",              PoPs_genre_atom,   56,  72, 0,  1.27908317698e+02 },
    { "Ba129",              PoPs_genre_atom,   56,  73, 0,  1.28908679439e+02 },  
    { "Ba130",              PoPs_genre_atom,   56,  74, 0,  1.29906320811e+02 },  
    { "Ba131",              PoPs_genre_atom,   56,  75, 0,  1.30906941118e+02 },  
    { "Ba132",              PoPs_genre_atom,   56,  76, 0,  1.31905061288e+02 },
    { "Ba133",              PoPs_genre_atom,   56,  77, 0,  1.3290600749e+02 },   
    { "Ba134",              PoPs_genre_atom,   56,  78, 0,  1.33904508383e+02 },  
    { "Ba135",              PoPs_genre_atom,   56,  79, 0,  1.34905688591e+02 },  
    { "Ba136",              PoPs_genre_atom,   56,  80, 0,  1.35904575945e+02 },
    { "Ba137",              PoPs_genre_atom,   56,  81, 0,  1.36905827384e+02 },  
    { "Ba138",              PoPs_genre_atom,   56,  82, 0,  1.37905247237e+02 },  
    { "Ba139",              PoPs_genre_atom,   56,  83, 0,  1.38908841341e+02 },  
    { "Ba140",              PoPs_genre_atom,   56,  84, 0,  1.39910604505e+02 },
    { "Ba141",              PoPs_genre_atom,   56,  85, 0,  1.40914411009e+02 },  
    { "Ba142",              PoPs_genre_atom,   56,  86, 0,  1.4191645341e+02 },   
    { "Ba143",              PoPs_genre_atom,   56,  87, 0,  1.42920626719e+02 },  
    { "Ba144",              PoPs_genre_atom,   56,  88, 0,  1.43922952853e+02 },
    { "Ba145",              PoPs_genre_atom,   56,  89, 0,  1.44927627032e+02 },  
    { "Ba146",              PoPs_genre_atom,   56,  90, 0,  1.45930219572e+02 },  
    { "Ba147",              PoPs_genre_atom,   56,  91, 0,  1.46934945e+02 },     
    { "Ba148",              PoPs_genre_atom,   56,  92, 0,  1.47937720047e+02 },
    { "Ba149",              PoPs_genre_atom,   56,  93, 0,  1.4894258e+02 },      
    { "Ba150",              PoPs_genre_atom,   56,  94, 0,  1.4994568e+02 },      
    { "Ba151",              PoPs_genre_atom,   56,  95, 0,  1.5095081e+02 },      
    { "Ba152",              PoPs_genre_atom,   56,  96, 0,  1.5195427e+02 },
    { "Ba153",              PoPs_genre_atom,   56,  97, 0,  1.5295961e+02 },      
    { "La_natural",         PoPs_genre_atom,   57,  -1, 0,  1.389055e+02 },       
    { "La117",              PoPs_genre_atom,   57,  60, 0,  1.16950068e+02 },     
    { "La118",              PoPs_genre_atom,   57,  61, 0,  1.1794673e+02 },
    { "La119",              PoPs_genre_atom,   57,  62, 0,  1.1894099e+02 },      
    { "La120",              PoPs_genre_atom,   57,  63, 0,  1.1993807e+02 },      
    { "La121",              PoPs_genre_atom,   57,  64, 0,  1.2093301e+02 },      
    { "La122",              PoPs_genre_atom,   57,  65, 0,  1.2193071e+02 },
    { "La123",              PoPs_genre_atom,   57,  66, 0,  1.2292624e+02 },      
    { "La124",              PoPs_genre_atom,   57,  67, 0,  1.23924574275e+02 },  
    { "La125",              PoPs_genre_atom,   57,  68, 0,  1.24920816034e+02 },  
    { "La126",              PoPs_genre_atom,   57,  69, 0,  1.25919512667e+02 },
    { "La127",              PoPs_genre_atom,   57,  70, 0,  1.26916375448e+02 },  
    { "La128",              PoPs_genre_atom,   57,  71, 0,  1.27915585177e+02 },  
    { "La129",              PoPs_genre_atom,   57,  72, 0,  1.28912692815e+02 },  
    { "La130",              PoPs_genre_atom,   57,  73, 0,  1.29912368724e+02 },
    { "La131",              PoPs_genre_atom,   57,  74, 0,  1.3091007e+02 },      
    { "La132",              PoPs_genre_atom,   57,  75, 0,  1.31910101145e+02 },  
    { "La133",              PoPs_genre_atom,   57,  76, 0,  1.32908218e+02 },     
    { "La134",              PoPs_genre_atom,   57,  77, 0,  1.33908514011e+02 },
    { "La135",              PoPs_genre_atom,   57,  78, 0,  1.34906976844e+02 },  
    { "La136",              PoPs_genre_atom,   57,  79, 0,  1.35907635536e+02 },  
    { "La137",              PoPs_genre_atom,   57,  80, 0,  1.36906493598e+02 },  
    { "La138",              PoPs_genre_atom,   57,  81, 0,  1.3790711193e+02 },
    { "La139",              PoPs_genre_atom,   57,  82, 0,  1.38906353267e+02 },  
    { "La140",              PoPs_genre_atom,   57,  83, 0,  1.39909477645e+02 },  
    { "La141",              PoPs_genre_atom,   57,  84, 0,  1.40910962152e+02 },  
    { "La142",              PoPs_genre_atom,   57,  85, 0,  1.4191407913e+02 },
    { "La143",              PoPs_genre_atom,   57,  86, 0,  1.4291606272e+02 },   
    { "La144",              PoPs_genre_atom,   57,  87, 0,  1.43919599647e+02 },  
    { "La145",              PoPs_genre_atom,   57,  88, 0,  1.44921645401e+02 },  
    { "La146",              PoPs_genre_atom,   57,  89, 0,  1.4592579346e+02 },
    { "La147",              PoPs_genre_atom,   57,  90, 0,  1.46928235284e+02 },  
    { "La148",              PoPs_genre_atom,   57,  91, 0,  1.47932228868e+02 },  
    { "La149",              PoPs_genre_atom,   57,  92, 0,  1.48934734e+02 },     
    { "La150",              PoPs_genre_atom,   57,  93, 0,  1.4993877e+02 },
    { "La151",              PoPs_genre_atom,   57,  94, 0,  1.5094172e+02 },      
    { "La152",              PoPs_genre_atom,   57,  95, 0,  1.5194625e+02 },      
    { "La153",              PoPs_genre_atom,   57,  96, 0,  1.5294962e+02 },      
    { "La154",              PoPs_genre_atom,   57,  97, 0,  1.539545e+02 },
    { "La155",              PoPs_genre_atom,   57,  98, 0,  1.5495835e+02 },      
    { "Ce_natural",         PoPs_genre_atom,   58,  -1, 0,  1.4012e+02 },         
    { "Ce119",              PoPs_genre_atom,   58,  61, 0,  1.1895276e+02 },      
    { "Ce120",              PoPs_genre_atom,   58,  62, 0,  1.1994664e+02 },
    { "Ce121",              PoPs_genre_atom,   58,  63, 0,  1.2094342e+02 },      
    { "Ce122",              PoPs_genre_atom,   58,  64, 0,  1.2193791e+02 },      
    { "Ce123",              PoPs_genre_atom,   58,  65, 0,  1.229354e+02 },       
    { "Ce124",              PoPs_genre_atom,   58,  66, 0,  1.2393041e+02 },
    { "Ce125",              PoPs_genre_atom,   58,  67, 0,  1.2492844e+02 },      
    { "Ce126",              PoPs_genre_atom,   58,  68, 0,  1.25923971e+02 },     
    { "Ce127",              PoPs_genre_atom,   58,  69, 0,  1.26922731e+02 },     
    { "Ce128",              PoPs_genre_atom,   58,  70, 0,  1.27918911e+02 },
    { "Ce129",              PoPs_genre_atom,   58,  71, 0,  1.28918102e+02 },     
    { "Ce130",              PoPs_genre_atom,   58,  72, 0,  1.29914736e+02 },     
    { "Ce131",              PoPs_genre_atom,   58,  73, 0,  1.30914422e+02 },     
    { "Ce132",              PoPs_genre_atom,   58,  74, 0,  1.31911460487e+02 },
    { "Ce133",              PoPs_genre_atom,   58,  75, 0,  1.3291151502e+02 },   
    { "Ce134",              PoPs_genre_atom,   58,  76, 0,  1.33908924821e+02 },  
    { "Ce135",              PoPs_genre_atom,   58,  77, 0,  1.34909151396e+02 },  
    { "Ce136",              PoPs_genre_atom,   58,  78, 0,  1.35907172422e+02 },
    { "Ce137",              PoPs_genre_atom,   58,  79, 0,  1.36907805577e+02 },  
    { "Ce138",              PoPs_genre_atom,   58,  80, 0,  1.37905991321e+02 },  
    { "Ce139",              PoPs_genre_atom,   58,  81, 0,  1.38906652651e+02 },  
    { "Ce140",              PoPs_genre_atom,   58,  82, 0,  1.39905438706e+02 },
    { "Ce141",              PoPs_genre_atom,   58,  83, 0,  1.4090827627e+02 },   
    { "Ce142",              PoPs_genre_atom,   58,  84, 0,  1.41909244205e+02 },  
    { "Ce143",              PoPs_genre_atom,   58,  85, 0,  1.4291238591e+02 },   
    { "Ce144",              PoPs_genre_atom,   58,  86, 0,  1.43913647336e+02 },
    { "Ce145",              PoPs_genre_atom,   58,  87, 0,  1.44917233135e+02 },  
    { "Ce146",              PoPs_genre_atom,   58,  88, 0,  1.45918759009e+02 },  
    { "Ce147",              PoPs_genre_atom,   58,  89, 0,  1.46922673954e+02 },  
    { "Ce148",              PoPs_genre_atom,   58,  90, 0,  1.4792443241e+02 },
    { "Ce149",              PoPs_genre_atom,   58,  91, 0,  1.48928399883e+02 },  
    { "Ce150",              PoPs_genre_atom,   58,  92, 0,  1.49930408931e+02 },  
    { "Ce151",              PoPs_genre_atom,   58,  93, 0,  1.50933976196e+02 },  
    { "Ce152",              PoPs_genre_atom,   58,  94, 0,  1.5193654e+02 },
    { "Ce153",              PoPs_genre_atom,   58,  95, 0,  1.5294058e+02 },      
    { "Ce154",              PoPs_genre_atom,   58,  96, 0,  1.5394342e+02 },      
    { "Ce155",              PoPs_genre_atom,   58,  97, 0,  1.5494804e+02 },      
    { "Ce156",              PoPs_genre_atom,   58,  98, 0,  1.5595126e+02 },
    { "Ce157",              PoPs_genre_atom,   58,  99, 0,  1.5695634e+02 },      
    { "Pr_natural",         PoPs_genre_atom,   59,  -1, 0,  1.409077e+02 },       
    { "Pr121",              PoPs_genre_atom,   59,  62, 0,  1.20955364e+02 },     
    { "Pr122",              PoPs_genre_atom,   59,  63, 0,  1.2195181e+02 },
    { "Pr123",              PoPs_genre_atom,   59,  64, 0,  1.2294596e+02 },      
    { "Pr124",              PoPs_genre_atom,   59,  65, 0,  1.2394296e+02 },      
    { "Pr125",              PoPs_genre_atom,   59,  66, 0,  1.2493783e+02 },      
    { "Pr126",              PoPs_genre_atom,   59,  67, 0,  1.2593531e+02 },
    { "Pr127",              PoPs_genre_atom,   59,  68, 0,  1.2693083e+02 },      
    { "Pr128",              PoPs_genre_atom,   59,  69, 0,  1.27928791e+02 },     
    { "Pr129",              PoPs_genre_atom,   59,  70, 0,  1.28925095e+02 },     
    { "Pr130",              PoPs_genre_atom,   59,  71, 0,  1.2992359e+02 },
    { "Pr131",              PoPs_genre_atom,   59,  72, 0,  1.30920259e+02 },     
    { "Pr132",              PoPs_genre_atom,   59,  73, 0,  1.31919255e+02 },     
    { "Pr133",              PoPs_genre_atom,   59,  74, 0,  1.32916330532e+02 },  
    { "Pr134",              PoPs_genre_atom,   59,  75, 0,  1.33915711737e+02 },
    { "Pr135",              PoPs_genre_atom,   59,  76, 0,  1.34913111745e+02 },  
    { "Pr136",              PoPs_genre_atom,   59,  77, 0,  1.35912691611e+02 },  
    { "Pr137",              PoPs_genre_atom,   59,  78, 0,  1.36910705455e+02 },  
    { "Pr138",              PoPs_genre_atom,   59,  79, 0,  1.37910754636e+02 },
    { "Pr139",              PoPs_genre_atom,   59,  80, 0,  1.38908938399e+02 },  
    { "Pr140",              PoPs_genre_atom,   59,  81, 0,  1.39909075874e+02 },  
    { "Pr141",              PoPs_genre_atom,   59,  82, 0,  1.40907652769e+02 },  
    { "Pr142",              PoPs_genre_atom,   59,  83, 0,  1.41910044806e+02 },
    { "Pr143",              PoPs_genre_atom,   59,  84, 0,  1.42910816926e+02 },  
    { "Pr144",              PoPs_genre_atom,   59,  85, 0,  1.43913305245e+02 },  
    { "Pr145",              PoPs_genre_atom,   59,  86, 0,  1.449145117e+02 },    
    { "Pr146",              PoPs_genre_atom,   59,  87, 0,  1.45917644336e+02 },
    { "Pr147",              PoPs_genre_atom,   59,  88, 0,  1.46918995992e+02 },  
    { "Pr148",              PoPs_genre_atom,   59,  89, 0,  1.47922135026e+02 },  
    { "Pr149",              PoPs_genre_atom,   59,  90, 0,  1.48923717651e+02 },  
    { "Pr150",              PoPs_genre_atom,   59,  91, 0,  1.49926672997e+02 },
    { "Pr151",              PoPs_genre_atom,   59,  92, 0,  1.50928318618e+02 },  
    { "Pr152",              PoPs_genre_atom,   59,  93, 0,  1.51931499225e+02 },  
    { "Pr153",              PoPs_genre_atom,   59,  94, 0,  1.52933838905e+02 },  
    { "Pr154",              PoPs_genre_atom,   59,  95, 0,  1.53937518153e+02 },
    { "Pr155",              PoPs_genre_atom,   59,  96, 0,  1.5494012e+02 },      
    { "Pr156",              PoPs_genre_atom,   59,  97, 0,  1.5594427e+02 },      
    { "Pr157",              PoPs_genre_atom,   59,  98, 0,  1.5694743e+02 },      
    { "Pr158",              PoPs_genre_atom,   59,  99, 0,  1.5795198e+02 },
    { "Pr159",              PoPs_genre_atom,   59, 100, 0,  1.589555e+02 },       
    { "Nd_natural",         PoPs_genre_atom,   60,  -1, 0,  1.4424e+02 },         
    { "Nd124",              PoPs_genre_atom,   60,  64, 0,  1.2395223e+02 },      
    { "Nd125",              PoPs_genre_atom,   60,  65, 0,  1.2494888e+02 },
    { "Nd126",              PoPs_genre_atom,   60,  66, 0,  1.2594322e+02 },      
    { "Nd127",              PoPs_genre_atom,   60,  67, 0,  1.269405e+02 },       
    { "Nd128",              PoPs_genre_atom,   60,  68, 0,  1.2793539e+02 },      
    { "Nd129",              PoPs_genre_atom,   60,  69, 0,  1.28933188e+02 },
    { "Nd130",              PoPs_genre_atom,   60,  70, 0,  1.29928506e+02 },     
    { "Nd131",              PoPs_genre_atom,   60,  71, 0,  1.30927247e+02 },     
    { "Nd132",              PoPs_genre_atom,   60,  72, 0,  1.31923321237e+02 },  
    { "Nd133",              PoPs_genre_atom,   60,  73, 0,  1.32922348e+02 },
    { "Nd134",              PoPs_genre_atom,   60,  74, 0,  1.33918790181e+02 },  
    { "Nd135",              PoPs_genre_atom,   60,  75, 0,  1.3491818116e+02 },   
    { "Nd136",              PoPs_genre_atom,   60,  76, 0,  1.35914976035e+02 },  
    { "Nd137",              PoPs_genre_atom,   60,  77, 0,  1.36914567137e+02 },
    { "Nd138",              PoPs_genre_atom,   60,  78, 0,  1.37911949961e+02 },  
    { "Nd139",              PoPs_genre_atom,   60,  79, 0,  1.38911978288e+02 },  
    { "Nd140",              PoPs_genre_atom,   60,  80, 0,  1.39909552e+02 },     
    { "Nd141",              PoPs_genre_atom,   60,  81, 0,  1.40909609854e+02 },
    { "Nd142",              PoPs_genre_atom,   60,  82, 0,  1.41907723297e+02 },  
    { "Nd143",              PoPs_genre_atom,   60,  83, 0,  1.4290981429e+02 },   
    { "Nd144",              PoPs_genre_atom,   60,  84, 0,  1.43910087274e+02 },  
    { "Nd145",              PoPs_genre_atom,   60,  85, 0,  1.44912573636e+02 },
    { "Nd146",              PoPs_genre_atom,   60,  86, 0,  1.45913116939e+02 },  
    { "Nd147",              PoPs_genre_atom,   60,  87, 0,  1.46916100441e+02 },  
    { "Nd148",              PoPs_genre_atom,   60,  88, 0,  1.47916893288e+02 },  
    { "Nd149",              PoPs_genre_atom,   60,  89, 0,  1.48920148842e+02 },
    { "Nd150",              PoPs_genre_atom,   60,  90, 0,  1.49920890888e+02 },  
    { "Nd151",              PoPs_genre_atom,   60,  91, 0,  1.50923828929e+02 },  
    { "Nd152",              PoPs_genre_atom,   60,  92, 0,  1.51924682219e+02 },  
    { "Nd153",              PoPs_genre_atom,   60,  93, 0,  1.52927698232e+02 },
    { "Nd154",              PoPs_genre_atom,   60,  94, 0,  1.53929477307e+02 },  
    { "Nd155",              PoPs_genre_atom,   60,  95, 0,  1.54932932e+02 },     
    { "Nd156",              PoPs_genre_atom,   60,  96, 0,  1.55935018114e+02 },  
    { "Nd157",              PoPs_genre_atom,   60,  97, 0,  1.5693903e+02 },
    { "Nd158",              PoPs_genre_atom,   60,  98, 0,  1.579416e+02 },       
    { "Nd159",              PoPs_genre_atom,   60,  99, 0,  1.5894609e+02 },      
    { "Nd160",              PoPs_genre_atom,   60, 100, 0,  1.5994909e+02 },      
    { "Nd161",              PoPs_genre_atom,   60, 101, 0,  1.6095388e+02 },
    { "Pm_natural",         PoPs_genre_atom,   61,  -1, 0,  1.45e+02 },           
    { "Pm126",              PoPs_genre_atom,   61,  65, 0,  1.2595752e+02 },      
    { "Pm127",              PoPs_genre_atom,   61,  66, 0,  1.2695163e+02 },      
    { "Pm128",              PoPs_genre_atom,   61,  67, 0,  1.2794842e+02 },
    { "Pm129",              PoPs_genre_atom,   61,  68, 0,  1.2894316e+02 },      
    { "Pm130",              PoPs_genre_atom,   61,  69, 0,  1.2994045e+02 },      
    { "Pm131",              PoPs_genre_atom,   61,  70, 0,  1.3093587e+02 },      
    { "Pm132",              PoPs_genre_atom,   61,  71, 0,  1.3193375e+02 },
    { "Pm133",              PoPs_genre_atom,   61,  72, 0,  1.32929782e+02 },     
    { "Pm134",              PoPs_genre_atom,   61,  73, 0,  1.33928353e+02 },     
    { "Pm135",              PoPs_genre_atom,   61,  74, 0,  1.34924876e+02 },     
    { "Pm136",              PoPs_genre_atom,   61,  75, 0,  1.35923565829e+02 },
    { "Pm137",              PoPs_genre_atom,   61,  76, 0,  1.36920479493e+02 },  
    { "Pm138",              PoPs_genre_atom,   61,  77, 0,  1.37919548281e+02 },  
    { "Pm139",              PoPs_genre_atom,   61,  78, 0,  1.38916804082e+02 },  
    { "Pm140",              PoPs_genre_atom,   61,  79, 0,  1.39916041789e+02 },
    { "Pm141",              PoPs_genre_atom,   61,  80, 0,  1.40913555054e+02 },  
    { "Pm142",              PoPs_genre_atom,   61,  81, 0,  1.41912874471e+02 },  
    { "Pm143",              PoPs_genre_atom,   61,  82, 0,  1.42910932616e+02 },  
    { "Pm144",              PoPs_genre_atom,   61,  83, 0,  1.43912590843e+02 },
    { "Pm145",              PoPs_genre_atom,   61,  84, 0,  1.44912749023e+02 },  
    { "Pm146",              PoPs_genre_atom,   61,  85, 0,  1.45914696305e+02 },  
    { "Pm147",              PoPs_genre_atom,   61,  86, 0,  1.46915138545e+02 },  
    { "Pm148",              PoPs_genre_atom,   61,  87, 0,  Pm148_Mass },
    { "Pm149",              PoPs_genre_atom,   61,  88, 0,  1.48918334155e+02 },  
    { "Pm150",              PoPs_genre_atom,   61,  89, 0,  1.49920983561e+02 },  
    { "Pm151",              PoPs_genre_atom,   61,  90, 0,  1.50921206973e+02 },  
    { "Pm152",              PoPs_genre_atom,   61,  91, 0,  1.51923496795e+02 },
    { "Pm153",              PoPs_genre_atom,   61,  92, 0,  1.52924116889e+02 },  
    { "Pm154",              PoPs_genre_atom,   61,  93, 0,  1.53926463943e+02 },  
    { "Pm155",              PoPs_genre_atom,   61,  94, 0,  1.54928101267e+02 },  
    { "Pm156",              PoPs_genre_atom,   61,  95, 0,  1.55931056736e+02 },
    { "Pm157",              PoPs_genre_atom,   61,  96, 0,  1.56933039369e+02 },  
    { "Pm158",              PoPs_genre_atom,   61,  97, 0,  1.57936561407e+02 },  
    { "Pm159",              PoPs_genre_atom,   61,  98, 0,  1.5893897e+02 },      
    { "Pm160",              PoPs_genre_atom,   61,  99, 0,  1.5994299e+02 },
    { "Pm161",              PoPs_genre_atom,   61, 100, 0,  1.6094586e+02 },      
    { "Pm162",              PoPs_genre_atom,   61, 101, 0,  1.6195029e+02 },      
    { "Pm163",              PoPs_genre_atom,   61, 102, 0,  1.6295368e+02 },      
    { "Sm_natural",         PoPs_genre_atom,   62,  -1, 0,  1.504e+02 },
    { "Sm128",              PoPs_genre_atom,   62,  66, 0,  1.2795808e+02 },      
    { "Sm129",              PoPs_genre_atom,   62,  67, 0,  1.2895464e+02 },      
    { "Sm130",              PoPs_genre_atom,   62,  68, 0,  1.2994892e+02 },      
    { "Sm131",              PoPs_genre_atom,   62,  69, 0,  1.3094611e+02 },
    { "Sm132",              PoPs_genre_atom,   62,  70, 0,  1.3194069e+02 },      
    { "Sm133",              PoPs_genre_atom,   62,  71, 0,  1.3293867e+02 },      
    { "Sm134",              PoPs_genre_atom,   62,  72, 0,  1.3393397e+02 },      
    { "Sm135",              PoPs_genre_atom,   62,  73, 0,  1.3493252e+02 },
    { "Sm136",              PoPs_genre_atom,   62,  74, 0,  1.35928275527e+02 },  
    { "Sm137",              PoPs_genre_atom,   62,  75, 0,  1.36926971746e+02 },  
    { "Sm138",              PoPs_genre_atom,   62,  76, 0,  1.37923243961e+02 },  
    { "Sm139",              PoPs_genre_atom,   62,  77, 0,  1.38922296605e+02 },
    { "Sm140",              PoPs_genre_atom,   62,  78, 0,  1.39918994687e+02 },  
    { "Sm141",              PoPs_genre_atom,   62,  79, 0,  1.40918476488e+02 },  
    { "Sm142",              PoPs_genre_atom,   62,  80, 0,  1.41915197641e+02 },  
    { "Sm143",              PoPs_genre_atom,   62,  81, 0,  1.42914628338e+02 },
    { "Sm144",              PoPs_genre_atom,   62,  82, 0,  1.43911999478e+02 },  
    { "Sm145",              PoPs_genre_atom,   62,  83, 0,  1.44913410353e+02 },  
    { "Sm146",              PoPs_genre_atom,   62,  84, 0,  1.459130409e+02 },    
    { "Sm147",              PoPs_genre_atom,   62,  85, 0,  1.46914897923e+02 },
    { "Sm148",              PoPs_genre_atom,   62,  86, 0,  1.47914822674e+02 },  
    { "Sm149",              PoPs_genre_atom,   62,  87, 0,  1.48917184735e+02 },  
    { "Sm150",              PoPs_genre_atom,   62,  88, 0,  1.49917275539e+02 },  
    { "Sm151",              PoPs_genre_atom,   62,  89, 0,  1.50919932409e+02 },
    { "Sm152",              PoPs_genre_atom,   62,  90, 0,  1.51919732425e+02 },  
    { "Sm153",              PoPs_genre_atom,   62,  91, 0,  1.52922097356e+02 },  
    { "Sm154",              PoPs_genre_atom,   62,  92, 0,  1.53922209273e+02 },  
    { "Sm155",              PoPs_genre_atom,   62,  93, 0,  1.54924640161e+02 },
    { "Sm156",              PoPs_genre_atom,   62,  94, 0,  1.55925527887e+02 },  
    { "Sm157",              PoPs_genre_atom,   62,  95, 0,  1.56928358717e+02 },  
    { "Sm158",              PoPs_genre_atom,   62,  96, 0,  1.57929991317e+02 },  
    { "Sm159",              PoPs_genre_atom,   62,  97, 0,  1.58933211271e+02 },
    { "Sm160",              PoPs_genre_atom,   62,  98, 0,  1.5993514e+02 },      
    { "Sm161",              PoPs_genre_atom,   62,  99, 0,  1.6093883e+02 },      
    { "Sm162",              PoPs_genre_atom,   62, 100, 0,  1.6194122e+02 },      
    { "Sm163",              PoPs_genre_atom,   62, 101, 0,  1.6294536e+02 },
    { "Sm164",              PoPs_genre_atom,   62, 102, 0,  1.6394828e+02 },      
    { "Sm165",              PoPs_genre_atom,   62, 103, 0,  1.6495298e+02 },      
    { "Eu_natural",         PoPs_genre_atom,   63,  -1, 0,  1.5196e+02 },         
    { "Eu130",              PoPs_genre_atom,   63,  67, 0,  1.29963569e+02 },
    { "Eu131",              PoPs_genre_atom,   63,  68, 0,  1.30957753e+02 },     
    { "Eu132",              PoPs_genre_atom,   63,  69, 0,  1.3195437e+02 },      
    { "Eu133",              PoPs_genre_atom,   63,  70, 0,  1.3294924e+02 },      
    { "Eu134",              PoPs_genre_atom,   63,  71, 0,  1.3394651e+02 },
    { "Eu135",              PoPs_genre_atom,   63,  72, 0,  1.3494182e+02 },      
    { "Eu136",              PoPs_genre_atom,   63,  73, 0,  1.359396e+02 },       
    { "Eu137",              PoPs_genre_atom,   63,  74, 0,  1.3693557e+02 },      
    { "Eu138",              PoPs_genre_atom,   63,  75, 0,  1.37933709e+02 },
    { "Eu139",              PoPs_genre_atom,   63,  76, 0,  1.3892979228e+02 },   
    { "Eu140",              PoPs_genre_atom,   63,  77, 0,  1.39928087607e+02 },  
    { "Eu141",              PoPs_genre_atom,   63,  78, 0,  1.4092493072e+02 },   
    { "Eu142",              PoPs_genre_atom,   63,  79, 0,  1.41923434945e+02 },
    { "Eu143",              PoPs_genre_atom,   63,  80, 0,  1.42920297509e+02 },  
    { "Eu144",              PoPs_genre_atom,   63,  81, 0,  1.43918816823e+02 },  
    { "Eu145",              PoPs_genre_atom,   63,  82, 0,  1.44916265237e+02 },  
    { "Eu146",              PoPs_genre_atom,   63,  83, 0,  1.45917205817e+02 },
    { "Eu147",              PoPs_genre_atom,   63,  84, 0,  1.46916746111e+02 },  
    { "Eu148",              PoPs_genre_atom,   63,  85, 0,  1.47918085895e+02 },  
    { "Eu149",              PoPs_genre_atom,   63,  86, 0,  1.48917931238e+02 },  
    { "Eu150",              PoPs_genre_atom,   63,  87, 0,  1.49919701819e+02 },
    { "Eu151",              PoPs_genre_atom,   63,  88, 0,  1.50919850161e+02 },  
    { "Eu152",              PoPs_genre_atom,   63,  89, 0,  1.51921744534e+02 },  
    { "Eu153",              PoPs_genre_atom,   63,  90, 0,  1.52921230339e+02 },  
    { "Eu154",              PoPs_genre_atom,   63,  91, 0,  1.53922979237e+02 },
    { "Eu155",              PoPs_genre_atom,   63,  92, 0,  1.5492289326e+02 },   
    { "Eu156",              PoPs_genre_atom,   63,  93, 0,  1.55924752249e+02 },  
    { "Eu157",              PoPs_genre_atom,   63,  94, 0,  1.56925423647e+02 },  
    { "Eu158",              PoPs_genre_atom,   63,  95, 0,  1.57927845302e+02 },
    { "Eu159",              PoPs_genre_atom,   63,  96, 0,  1.58929088861e+02 },  
    { "Eu160",              PoPs_genre_atom,   63,  97, 0,  1.59931971e+02 },     
    { "Eu161",              PoPs_genre_atom,   63,  98, 0,  1.6093368e+02 },      
    { "Eu162",              PoPs_genre_atom,   63,  99, 0,  1.6193704e+02 },
    { "Eu163",              PoPs_genre_atom,   63, 100, 0,  1.6293921e+02 },      
    { "Eu164",              PoPs_genre_atom,   63, 101, 0,  1.6394299e+02 },      
    { "Eu165",              PoPs_genre_atom,   63, 102, 0,  1.6494572e+02 },      
    { "Eu166",              PoPs_genre_atom,   63, 103, 0,  1.6594997e+02 },
    { "Eu167",              PoPs_genre_atom,   63, 104, 0,  1.6695321e+02 },      
    { "Gd_natural",         PoPs_genre_atom,   64,  -1, 0,  1.5725e+02 },         
    { "Gd134",              PoPs_genre_atom,   64,  70, 0,  1.3395537e+02 },      
    { "Gd135",              PoPs_genre_atom,   64,  71, 0,  1.3495257e+02 },
    { "Gd136",              PoPs_genre_atom,   64,  72, 0,  1.3594734e+02 },      
    { "Gd137",              PoPs_genre_atom,   64,  73, 0,  1.3694502e+02 },      
    { "Gd138",              PoPs_genre_atom,   64,  74, 0,  1.3794012e+02 },      
    { "Gd139",              PoPs_genre_atom,   64,  75, 0,  1.3893824e+02 },
    { "Gd140",              PoPs_genre_atom,   64,  76, 0,  1.39933674e+02 },     
    { "Gd141",              PoPs_genre_atom,   64,  77, 0,  1.40932126e+02 },     
    { "Gd142",              PoPs_genre_atom,   64,  78, 0,  1.41928116e+02 },     
    { "Gd143",              PoPs_genre_atom,   64,  79, 0,  1.4292674951e+02 },
    { "Gd144",              PoPs_genre_atom,   64,  80, 0,  1.43922963e+02 },     
    { "Gd145",              PoPs_genre_atom,   64,  81, 0,  1.44921709252e+02 },  
    { "Gd146",              PoPs_genre_atom,   64,  82, 0,  1.45918310608e+02 },  
    { "Gd147",              PoPs_genre_atom,   64,  83, 0,  1.4691909442e+02 },
    { "Gd148",              PoPs_genre_atom,   64,  84, 0,  1.47918114524e+02 },  
    { "Gd149",              PoPs_genre_atom,   64,  85, 0,  1.48919340915e+02 },  
    { "Gd150",              PoPs_genre_atom,   64,  86, 0,  1.49918658876e+02 },  
    { "Gd151",              PoPs_genre_atom,   64,  87, 0,  1.50920348482e+02 },
    { "Gd152",              PoPs_genre_atom,   64,  88, 0,  1.51919790996e+02 },  
    { "Gd153",              PoPs_genre_atom,   64,  89, 0,  1.52921749543e+02 },  
    { "Gd154",              PoPs_genre_atom,   64,  90, 0,  1.53920865598e+02 },  
    { "Gd155",              PoPs_genre_atom,   64,  91, 0,  1.54922622022e+02 },
    { "Gd156",              PoPs_genre_atom,   64,  92, 0,  1.55922122743e+02 },  
    { "Gd157",              PoPs_genre_atom,   64,  93, 0,  1.56923960135e+02 },  
    { "Gd158",              PoPs_genre_atom,   64,  94, 0,  1.57924103912e+02 },  
    { "Gd159",              PoPs_genre_atom,   64,  95, 0,  1.58926388658e+02 },
    { "Gd160",              PoPs_genre_atom,   64,  96, 0,  1.59927054146e+02 },  
    { "Gd161",              PoPs_genre_atom,   64,  97, 0,  1.60929669211e+02 },  
    { "Gd162",              PoPs_genre_atom,   64,  98, 0,  1.61930984751e+02 },  
    { "Gd163",              PoPs_genre_atom,   64,  99, 0,  1.6293399e+02 },
    { "Gd164",              PoPs_genre_atom,   64, 100, 0,  1.6393586e+02 },      
    { "Gd165",              PoPs_genre_atom,   64, 101, 0,  1.6493938e+02 },      
    { "Gd166",              PoPs_genre_atom,   64, 102, 0,  1.659416e+02 },       
    { "Gd167",              PoPs_genre_atom,   64, 103, 0,  1.6694557e+02 },
    { "Gd168",              PoPs_genre_atom,   64, 104, 0,  1.6794836e+02 },      
    { "Gd169",              PoPs_genre_atom,   64, 105, 0,  1.6895287e+02 },      
    { "Tb_natural",         PoPs_genre_atom,   65,  -1, 0,  1.589254e+02 },       
    { "Tb136",              PoPs_genre_atom,   65,  71, 0,  1.3596138e+02 },
    { "Tb137",              PoPs_genre_atom,   65,  72, 0,  1.3695598e+02 },      
    { "Tb138",              PoPs_genre_atom,   65,  73, 0,  1.3795316e+02 },      
    { "Tb139",              PoPs_genre_atom,   65,  74, 0,  1.3894829e+02 },      
    { "Tb140",              PoPs_genre_atom,   65,  75, 0,  1.39945805049e+02 },
    { "Tb141",              PoPs_genre_atom,   65,  76, 0,  1.40941448e+02 },     
    { "Tb142",              PoPs_genre_atom,   65,  77, 0,  1.41938744e+02 },     
    { "Tb143",              PoPs_genre_atom,   65,  78, 0,  1.42935121e+02 },     
    { "Tb144",              PoPs_genre_atom,   65,  79, 0,  1.43933045e+02 },
    { "Tb145",              PoPs_genre_atom,   65,  80, 0,  1.44929274e+02 },     
    { "Tb146",              PoPs_genre_atom,   65,  81, 0,  1.45927246584e+02 },  
    { "Tb147",              PoPs_genre_atom,   65,  82, 0,  1.46924044585e+02 },  
    { "Tb148",              PoPs_genre_atom,   65,  83, 0,  1.47924271701e+02 },
    { "Tb149",              PoPs_genre_atom,   65,  84, 0,  1.48923245909e+02 },  
    { "Tb150",              PoPs_genre_atom,   65,  85, 0,  1.49923659686e+02 },  
    { "Tb151",              PoPs_genre_atom,   65,  86, 0,  1.50923102543e+02 },  
    { "Tb152",              PoPs_genre_atom,   65,  87, 0,  1.51924074438e+02 },
    { "Tb153",              PoPs_genre_atom,   65,  88, 0,  1.52923434588e+02 },  
    { "Tb154",              PoPs_genre_atom,   65,  89, 0,  1.53924678019e+02 },  
    { "Tb155",              PoPs_genre_atom,   65,  90, 0,  1.54923505236e+02 },  
    { "Tb156",              PoPs_genre_atom,   65,  91, 0,  1.55924747213e+02 },
    { "Tb157",              PoPs_genre_atom,   65,  92, 0,  1.56924024604e+02 },  
    { "Tb158",              PoPs_genre_atom,   65,  93, 0,  1.57925413137e+02 },  
    { "Tb159",              PoPs_genre_atom,   65,  94, 0,  1.58925346757e+02 },  
    { "Tb160",              PoPs_genre_atom,   65,  95, 0,  1.59927167606e+02 },
    { "Tb161",              PoPs_genre_atom,   65,  96, 0,  1.60927569919e+02 },  
    { "Tb162",              PoPs_genre_atom,   65,  97, 0,  1.61929488234e+02 },  
    { "Tb163",              PoPs_genre_atom,   65,  98, 0,  1.62930647536e+02 },  
    { "Tb164",              PoPs_genre_atom,   65,  99, 0,  1.63933350838e+02 },
    { "Tb165",              PoPs_genre_atom,   65, 100, 0,  1.6493488e+02 },      
    { "Tb166",              PoPs_genre_atom,   65, 101, 0,  1.65937991959e+02 },  
    { "Tb167",              PoPs_genre_atom,   65, 102, 0,  1.6694005e+02 },      
    { "Tb168",              PoPs_genre_atom,   65, 103, 0,  1.6794364e+02 },
    { "Tb169",              PoPs_genre_atom,   65, 104, 0,  1.6894622e+02 },      
    { "Tb170",              PoPs_genre_atom,   65, 105, 0,  1.6995025e+02 },      
    { "Tb171",              PoPs_genre_atom,   65, 106, 0,  1.709533e+02 },       
    { "Dy_natural",         PoPs_genre_atom,   66,  -1, 0,  1.625e+02 },
    { "Dy138",              PoPs_genre_atom,   66,  72, 0,  1.3796249e+02 },      
    { "Dy139",              PoPs_genre_atom,   66,  73, 0,  1.3895954e+02 },      
    { "Dy140",              PoPs_genre_atom,   66,  74, 0,  1.3995401e+02 },      
    { "Dy141",              PoPs_genre_atom,   66,  75, 0,  1.4095135e+02 },
    { "Dy142",              PoPs_genre_atom,   66,  76, 0,  1.41946366e+02 },     
    { "Dy143",              PoPs_genre_atom,   66,  77, 0,  1.4294383e+02 },      
    { "Dy144",              PoPs_genre_atom,   66,  78, 0,  1.43939254e+02 },     
    { "Dy145",              PoPs_genre_atom,   66,  79, 0,  1.44937425e+02 },
    { "Dy146",              PoPs_genre_atom,   66,  80, 0,  1.45932845369e+02 },  
    { "Dy147",              PoPs_genre_atom,   66,  81, 0,  1.469310915e+02 },    
    { "Dy148",              PoPs_genre_atom,   66,  82, 0,  1.47927149831e+02 },  
    { "Dy149",              PoPs_genre_atom,   66,  83, 0,  1.48927304787e+02 },
    { "Dy150",              PoPs_genre_atom,   66,  84, 0,  1.49925585184e+02 },  
    { "Dy151",              PoPs_genre_atom,   66,  85, 0,  1.50926184601e+02 },  
    { "Dy152",              PoPs_genre_atom,   66,  86, 0,  1.519247183e+02 },    
    { "Dy153",              PoPs_genre_atom,   66,  87, 0,  1.5292576467e+02 },
    { "Dy154",              PoPs_genre_atom,   66,  88, 0,  1.53924424457e+02 },  
    { "Dy155",              PoPs_genre_atom,   66,  89, 0,  1.54925753775e+02 },  
    { "Dy156",              PoPs_genre_atom,   66,  90, 0,  1.5592428311e+02 },   
    { "Dy157",              PoPs_genre_atom,   66,  91, 0,  1.56925466095e+02 },
    { "Dy158",              PoPs_genre_atom,   66,  92, 0,  1.57924409487e+02 },  
    { "Dy159",              PoPs_genre_atom,   66,  93, 0,  1.58925739214e+02 },  
    { "Dy160",              PoPs_genre_atom,   66,  94, 0,  1.59925197517e+02 },  
    { "Dy161",              PoPs_genre_atom,   66,  95, 0,  1.60926933364e+02 },
    { "Dy162",              PoPs_genre_atom,   66,  96, 0,  1.61926798447e+02 },  
    { "Dy163",              PoPs_genre_atom,   66,  97, 0,  1.62928731159e+02 },  
    { "Dy164",              PoPs_genre_atom,   66,  98, 0,  1.63929174751e+02 },  
    { "Dy165",              PoPs_genre_atom,   66,  99, 0,  Dy165_Mass },
    { "Dy166",              PoPs_genre_atom,   66, 100, 0,  1.65932806741e+02 },  
    { "Dy167",              PoPs_genre_atom,   66, 101, 0,  1.66935655462e+02 },  
    { "Dy168",              PoPs_genre_atom,   66, 102, 0,  1.67937128769e+02 },  
    { "Dy169",              PoPs_genre_atom,   66, 103, 0,  1.68940307614e+02 },
    { "Dy170",              PoPs_genre_atom,   66, 104, 0,  1.6994239e+02 },      
    { "Dy171",              PoPs_genre_atom,   66, 105, 0,  1.709462e+02 },       
    { "Dy172",              PoPs_genre_atom,   66, 106, 0,  1.7194876e+02 },      
    { "Dy173",              PoPs_genre_atom,   66, 107, 0,  1.72953e+02 },
    { "Ho_natural",         PoPs_genre_atom,   67,  -1, 0,  1.649304e+02 },       
    { "Ho140",              PoPs_genre_atom,   67,  73, 0,  1.39968539e+02 },     
    { "Ho141",              PoPs_genre_atom,   67,  74, 0,  1.40963098e+02 },     
    { "Ho142",              PoPs_genre_atom,   67,  75, 0,  1.4195977e+02 },
    { "Ho143",              PoPs_genre_atom,   67,  76, 0,  1.4295461e+02 },      
    { "Ho144",              PoPs_genre_atom,   67,  77, 0,  1.4395148e+02 },      
    { "Ho145",              PoPs_genre_atom,   67,  78, 0,  1.449472e+02 },       
    { "Ho146",              PoPs_genre_atom,   67,  79, 0,  1.4594464e+02 },
    { "Ho147",              PoPs_genre_atom,   67,  80, 0,  1.46940056e+02 },     
    { "Ho148",              PoPs_genre_atom,   67,  81, 0,  1.47937718e+02 },     
    { "Ho149",              PoPs_genre_atom,   67,  82, 0,  1.48933774771e+02 },  
    { "Ho150",              PoPs_genre_atom,   67,  83, 0,  1.49933496182e+02 },
    { "Ho151",              PoPs_genre_atom,   67,  84, 0,  1.50931688142e+02 },  
    { "Ho152",              PoPs_genre_atom,   67,  85, 0,  1.51931713714e+02 },  
    { "Ho153",              PoPs_genre_atom,   67,  86, 0,  1.52930198789e+02 },  
    { "Ho154",              PoPs_genre_atom,   67,  87, 0,  1.53930601579e+02 },
    { "Ho155",              PoPs_genre_atom,   67,  88, 0,  1.54929103491e+02 },  
    { "Ho156",              PoPs_genre_atom,   67,  89, 0,  1.55929839e+02 },     
    { "Ho157",              PoPs_genre_atom,   67,  90, 0,  1.56928256188e+02 },  
    { "Ho158",              PoPs_genre_atom,   67,  91, 0,  1.57928941007e+02 },
    { "Ho159",              PoPs_genre_atom,   67,  92, 0,  1.58927711959e+02 },  
    { "Ho160",              PoPs_genre_atom,   67,  93, 0,  1.59928729478e+02 },  
    { "Ho161",              PoPs_genre_atom,   67,  94, 0,  1.60927854776e+02 },  
    { "Ho162",              PoPs_genre_atom,   67,  95, 0,  1.61929095504e+02 },
    { "Ho163",              PoPs_genre_atom,   67,  96, 0,  Ho163_Mass },  
    { "Ho164",              PoPs_genre_atom,   67,  97, 0,  Ho164_Mass },  
    { "Ho165",              PoPs_genre_atom,   67,  98, 0,  1.6493032207e+02 },   
    { "Ho166",              PoPs_genre_atom,   67,  99, 0,  Ho166_Mass },
    { "Ho167",              PoPs_genre_atom,   67, 100, 0,  1.66933132633e+02 },  
    { "Ho168",              PoPs_genre_atom,   67, 101, 0,  1.67935515708e+02 },  
    { "Ho169",              PoPs_genre_atom,   67, 102, 0,  1.68936872273e+02 },  
    { "Ho170",              PoPs_genre_atom,   67, 103, 0,  1.69939618929e+02 },
    { "Ho171",              PoPs_genre_atom,   67, 104, 0,  1.7094146515e+02 },   
    { "Ho172",              PoPs_genre_atom,   67, 105, 0,  1.7194482e+02 },      
    { "Ho173",              PoPs_genre_atom,   67, 106, 0,  1.7294729e+02 },      
    { "Ho174",              PoPs_genre_atom,   67, 107, 0,  1.7395115e+02 },
    { "Ho175",              PoPs_genre_atom,   67, 108, 0,  1.7495405e+02 },      
    { "Er_natural",         PoPs_genre_atom,   68,  -1, 0,  1.6726e+02 },         
    { "Er143",              PoPs_genre_atom,   68,  75, 0,  1.4296634e+02 },      
    { "Er144",              PoPs_genre_atom,   68,  76, 0,  1.4396038e+02 },
    { "Er145",              PoPs_genre_atom,   68,  77, 0,  1.4495739e+02 },      
    { "Er146",              PoPs_genre_atom,   68,  78, 0,  1.45952e+02 },        
    { "Er147",              PoPs_genre_atom,   68,  79, 0,  1.4694949e+02 },      
    { "Er148",              PoPs_genre_atom,   68,  80, 0,  1.4794455e+02 },
    { "Er149",              PoPs_genre_atom,   68,  81, 0,  1.48942306e+02 },     
    { "Er150",              PoPs_genre_atom,   68,  82, 0,  1.49937913839e+02 },  
    { "Er151",              PoPs_genre_atom,   68,  83, 0,  1.50937448903e+02 },  
    { "Er152",              PoPs_genre_atom,   68,  84, 0,  1.51935050389e+02 },
    { "Er153",              PoPs_genre_atom,   68,  85, 0,  1.52935063492e+02 },  
    { "Er154",              PoPs_genre_atom,   68,  86, 0,  1.53932783081e+02 },  
    { "Er155",              PoPs_genre_atom,   68,  87, 0,  1.54933208949e+02 },  
    { "Er156",              PoPs_genre_atom,   68,  88, 0,  1.55931064698e+02 },
    { "Er157",              PoPs_genre_atom,   68,  89, 0,  1.56931916e+02 },     
    { "Er158",              PoPs_genre_atom,   68,  90, 0,  1.57929893474e+02 },  
    { "Er159",              PoPs_genre_atom,   68,  91, 0,  1.58930684066e+02 },  
    { "Er160",              PoPs_genre_atom,   68,  92, 0,  1.59929083292e+02 },
    { "Er161",              PoPs_genre_atom,   68,  93, 0,  1.60929995309e+02 },  
    { "Er162",              PoPs_genre_atom,   68,  94, 0,  1.61928778264e+02 },  
    { "Er163",              PoPs_genre_atom,   68,  95, 0,  1.62930032749e+02 },  
    { "Er164",              PoPs_genre_atom,   68,  96, 0,  1.63929200229e+02 },
    { "Er165",              PoPs_genre_atom,   68,  97, 0,  1.64930726003e+02 },  
    { "Er166",              PoPs_genre_atom,   68,  98, 0,  1.65930293061e+02 },  
    { "Er167",              PoPs_genre_atom,   68,  99, 0,  Er167_Mass },  
    { "Er168",              PoPs_genre_atom,   68, 100, 0,  1.67932370224e+02 },
    { "Er169",              PoPs_genre_atom,   68, 101, 0,  1.68934590364e+02 },  
    { "Er170",              PoPs_genre_atom,   68, 102, 0,  1.69935464312e+02 },  
    { "Er171",              PoPs_genre_atom,   68, 103, 0,  1.70938029808e+02 },  
    { "Er172",              PoPs_genre_atom,   68, 104, 0,  1.71939356113e+02 },
    { "Er173",              PoPs_genre_atom,   68, 105, 0,  1.729424e+02 },       
    { "Er174",              PoPs_genre_atom,   68, 106, 0,  1.7394423e+02 },      
    { "Er175",              PoPs_genre_atom,   68, 107, 0,  1.7494777e+02 },      
    { "Er176",              PoPs_genre_atom,   68, 108, 0,  1.7595008e+02 },
    { "Er177",              PoPs_genre_atom,   68, 109, 0,  1.7695405e+02 },      
    { "Tm_natural",         PoPs_genre_atom,   69,  -1, 0,  1.689342e+02 },       
    { "Tm145",              PoPs_genre_atom,   69,  76, 0,  1.44970073e+02 },     
    { "Tm146",              PoPs_genre_atom,   69,  77, 0,  1.45966425e+02 },
    { "Tm147",              PoPs_genre_atom,   69,  78, 0,  1.46960961e+02 },     
    { "Tm148",              PoPs_genre_atom,   69,  79, 0,  1.4795784e+02 },      
    { "Tm149",              PoPs_genre_atom,   69,  80, 0,  1.4895272e+02 },      
    { "Tm150",              PoPs_genre_atom,   69,  81, 0,  1.4994996e+02 },
    { "Tm151",              PoPs_genre_atom,   69,  82, 0,  1.5094548349e+02 },   
    { "Tm152",              PoPs_genre_atom,   69,  83, 0,  1.51944422e+02 },     
    { "Tm153",              PoPs_genre_atom,   69,  84, 0,  1.52942012112e+02 },  
    { "Tm154",              PoPs_genre_atom,   69,  85, 0,  1.53941567808e+02 },
    { "Tm155",              PoPs_genre_atom,   69,  86, 0,  1.54939199459e+02 },  
    { "Tm156",              PoPs_genre_atom,   69,  87, 0,  1.55938979933e+02 },  
    { "Tm157",              PoPs_genre_atom,   69,  88, 0,  1.56936973e+02 },     
    { "Tm158",              PoPs_genre_atom,   69,  89, 0,  1.57936979525e+02 },
    { "Tm159",              PoPs_genre_atom,   69,  90, 0,  1.58934975e+02 },     
    { "Tm160",              PoPs_genre_atom,   69,  91, 0,  1.59935262801e+02 },  
    { "Tm161",              PoPs_genre_atom,   69,  92, 0,  1.60933549e+02 },     
    { "Tm162",              PoPs_genre_atom,   69,  93, 0,  1.61933994682e+02 },
    { "Tm163",              PoPs_genre_atom,   69,  94, 0,  1.62932651124e+02 },  
    { "Tm164",              PoPs_genre_atom,   69,  95, 0,  1.6393356e+02 },      
    { "Tm165",              PoPs_genre_atom,   69,  96, 0,  1.64932435492e+02 },  
    { "Tm166",              PoPs_genre_atom,   69,  97, 0,  1.65933554131e+02 },
    { "Tm167",              PoPs_genre_atom,   69,  98, 0,  1.66932851622e+02 },  
    { "Tm168",              PoPs_genre_atom,   69,  99, 0,  1.67934172776e+02 },  
    { "Tm169",              PoPs_genre_atom,   69, 100, 0,  1.6893421325e+02 },   
    { "Tm170",              PoPs_genre_atom,   69, 101, 0,  1.69935801397e+02 },
    { "Tm171",              PoPs_genre_atom,   69, 102, 0,  1.7093642944e+02 },   
    { "Tm172",              PoPs_genre_atom,   69, 103, 0,  1.71938400044e+02 },  
    { "Tm173",              PoPs_genre_atom,   69, 104, 0,  1.72939603607e+02 },  
    { "Tm174",              PoPs_genre_atom,   69, 105, 0,  1.73942168605e+02 },
    { "Tm175",              PoPs_genre_atom,   69, 106, 0,  1.74943836853e+02 },  
    { "Tm176",              PoPs_genre_atom,   69, 107, 0,  Tm176_Mass },  
    { "Tm177",              PoPs_genre_atom,   69, 108, 0,  1.7694904e+02 },      
    { "Tm178",              PoPs_genre_atom,   69, 109, 0,  1.7795264e+02 },
    { "Tm179",              PoPs_genre_atom,   69, 110, 0,  1.7895534e+02 },      
    { "Yb_natural",         PoPs_genre_atom,   70,  -1, 0,  1.7304e+02 },         
    { "Yb148",              PoPs_genre_atom,   70,  78, 0,  1.4796742e+02 },      
    { "Yb149",              PoPs_genre_atom,   70,  79, 0,  1.4896404e+02 },
    { "Yb150",              PoPs_genre_atom,   70,  80, 0,  1.4995842e+02 },      
    { "Yb151",              PoPs_genre_atom,   70,  81, 0,  1.50955400769e+02 },  
    { "Yb152",              PoPs_genre_atom,   70,  82, 0,  1.51950288919e+02 },  
    { "Yb153",              PoPs_genre_atom,   70,  83, 0,  1.5294948e+02 },
    { "Yb154",              PoPs_genre_atom,   70,  84, 0,  1.53946393928e+02 },  
    { "Yb155",              PoPs_genre_atom,   70,  85, 0,  1.54945782332e+02 },  
    { "Yb156",              PoPs_genre_atom,   70,  86, 0,  1.55942818215e+02 },  
    { "Yb157",              PoPs_genre_atom,   70,  87, 0,  1.56942627848e+02 },
    { "Yb158",              PoPs_genre_atom,   70,  88, 0,  1.57939865617e+02 },  
    { "Yb159",              PoPs_genre_atom,   70,  89, 0,  1.58940050099e+02 },  
    { "Yb160",              PoPs_genre_atom,   70,  90, 0,  1.59937552344e+02 },  
    { "Yb161",              PoPs_genre_atom,   70,  91, 0,  1.60937901678e+02 },
    { "Yb162",              PoPs_genre_atom,   70,  92, 0,  1.6193576821e+02 },   
    { "Yb163",              PoPs_genre_atom,   70,  93, 0,  1.62936334305e+02 },  
    { "Yb164",              PoPs_genre_atom,   70,  94, 0,  1.63934489416e+02 },  
    { "Yb165",              PoPs_genre_atom,   70,  95, 0,  1.64935279e+02 },
    { "Yb166",              PoPs_genre_atom,   70,  96, 0,  1.65933882042e+02 },  
    { "Yb167",              PoPs_genre_atom,   70,  97, 0,  1.66934949605e+02 },  
    { "Yb168",              PoPs_genre_atom,   70,  98, 0,  1.67933896895e+02 },  
    { "Yb169",              PoPs_genre_atom,   70,  99, 0,  Yb169_Mass },
    { "Yb170",              PoPs_genre_atom,   70, 100, 0,  1.69934761837e+02 },  
    { "Yb171",              PoPs_genre_atom,   70, 101, 0,  1.70936325799e+02 },  
    { "Yb172",              PoPs_genre_atom,   70, 102, 0,  1.71936381469e+02 },  
    { "Yb173",              PoPs_genre_atom,   70, 103, 0,  1.72938210787e+02 },
    { "Yb174",              PoPs_genre_atom,   70, 104, 0,  1.73938862089e+02 },  
    { "Yb175",              PoPs_genre_atom,   70, 105, 0,  1.7494127645e+02 },   
    { "Yb176",              PoPs_genre_atom,   70, 106, 0,  Yb176_Mass },  
    { "Yb177",              PoPs_genre_atom,   70, 107, 0,  Yb177_Mass },
    { "Yb178",              PoPs_genre_atom,   70, 108, 0,  1.7794664668e+02 },   
    { "Yb179",              PoPs_genre_atom,   70, 109, 0,  1.7895017e+02 },      
    { "Yb180",              PoPs_genre_atom,   70, 110, 0,  1.7995233e+02 },      
    { "Yb181",              PoPs_genre_atom,   70, 111, 0,  1.8095615e+02 },
    { "Lu_natural",         PoPs_genre_atom,   71,  -1, 0,  1.74967e+02 },        
    { "Lu150",              PoPs_genre_atom,   71,  79, 0,  1.49973228e+02 },     
    { "Lu151",              PoPs_genre_atom,   71,  80, 0,  1.50967577e+02 },     
    { "Lu152",              PoPs_genre_atom,   71,  81, 0,  1.5196412e+02 },
    { "Lu153",              PoPs_genre_atom,   71,  82, 0,  1.52958767331e+02 },  
    { "Lu154",              PoPs_genre_atom,   71,  83, 0,  1.53957522e+02 },     
    { "Lu155",              PoPs_genre_atom,   71,  84, 0,  1.54954316216e+02 },  
    { "Lu156",              PoPs_genre_atom,   71,  85, 0,  1.55953032523e+02 },
    { "Lu157",              PoPs_genre_atom,   71,  86, 0,  1.569500983e+02 },    
    { "Lu158",              PoPs_genre_atom,   71,  87, 0,  1.57949313283e+02 },  
    { "Lu159",              PoPs_genre_atom,   71,  88, 0,  1.58946628776e+02 },  
    { "Lu160",              PoPs_genre_atom,   71,  89, 0,  1.59946033e+02 },
    { "Lu161",              PoPs_genre_atom,   71,  90, 0,  1.60943572e+02 },     
    { "Lu162",              PoPs_genre_atom,   71,  91, 0,  1.61943277288e+02 },  
    { "Lu163",              PoPs_genre_atom,   71,  92, 0,  1.62941179e+02 },     
    { "Lu164",              PoPs_genre_atom,   71,  93, 0,  1.63941339e+02 },
    { "Lu165",              PoPs_genre_atom,   71,  94, 0,  1.64939406724e+02 },  
    { "Lu166",              PoPs_genre_atom,   71,  95, 0,  1.65939859e+02 },     
    { "Lu167",              PoPs_genre_atom,   71,  96, 0,  1.6693827e+02 },      
    { "Lu168",              PoPs_genre_atom,   71,  97, 0,  1.67938739111e+02 },
    { "Lu169",              PoPs_genre_atom,   71,  98, 0,  Lu169_Mass },  
    { "Lu170",              PoPs_genre_atom,   71,  99, 0,  1.69938474968e+02 },  
    { "Lu171",              PoPs_genre_atom,   71, 100, 0,  Lu171_Mass },  
    { "Lu172",              PoPs_genre_atom,   71, 101, 0,  Lu172_Mass },
    { "Lu173",              PoPs_genre_atom,   71, 102, 0,  1.72938930602e+02 },  
    { "Lu174",              PoPs_genre_atom,   71, 103, 0,  Lu174_Mass },   
    { "Lu175",              PoPs_genre_atom,   71, 104, 0,  1.74940771819e+02 },  
    { "Lu176",              PoPs_genre_atom,   71, 105, 0,  Lu176_Mass },
    { "Lu177",              PoPs_genre_atom,   71, 106, 0,  Lu177_Mass },  
    { "Lu178",              PoPs_genre_atom,   71, 107, 0,  Lu178_Mass },  
    { "Lu179",              PoPs_genre_atom,   71, 108, 0,  1.78947327443e+02 },  
    { "Lu180",              PoPs_genre_atom,   71, 109, 0,  1.7994988116e+02 },
    { "Lu181",              PoPs_genre_atom,   71, 110, 0,  1.8095197e+02 },      
    { "Lu182",              PoPs_genre_atom,   71, 111, 0,  1.8195504e+02 },      
    { "Lu183",              PoPs_genre_atom,   71, 112, 0,  1.8295757e+02 },      
    { "Lu184",              PoPs_genre_atom,   71, 113, 0,  1.8396091e+02 },
    { "Hf_natural",         PoPs_genre_atom,   72,  -1, 0,  1.7849e+02 },         
    { "Hf153",              PoPs_genre_atom,   72,  81, 0,  1.5297069e+02 },      
    { "Hf154",              PoPs_genre_atom,   72,  82, 0,  1.5396486e+02 },      
    { "Hf155",              PoPs_genre_atom,   72,  83, 0,  1.5496339e+02 },
    { "Hf156",              PoPs_genre_atom,   72,  84, 0,  1.55959364025e+02 },  
    { "Hf157",              PoPs_genre_atom,   72,  85, 0,  1.56958396e+02 },     
    { "Hf158",              PoPs_genre_atom,   72,  86, 0,  1.57954799366e+02 },  
    { "Hf159",              PoPs_genre_atom,   72,  87, 0,  1.5895399487e+02 },
    { "Hf160",              PoPs_genre_atom,   72,  88, 0,  1.59950684379e+02 },  
    { "Hf161",              PoPs_genre_atom,   72,  89, 0,  1.60950274844e+02 },  
    { "Hf162",              PoPs_genre_atom,   72,  90, 0,  1.61947210498e+02 },  
    { "Hf163",              PoPs_genre_atom,   72,  91, 0,  1.62947089e+02 },
    { "Hf164",              PoPs_genre_atom,   72,  92, 0,  1.63944367284e+02 },  
    { "Hf165",              PoPs_genre_atom,   72,  93, 0,  1.64944567e+02 },     
    { "Hf166",              PoPs_genre_atom,   72,  94, 0,  1.6594218e+02 },      
    { "Hf167",              PoPs_genre_atom,   72,  95, 0,  1.669426e+02 },
    { "Hf168",              PoPs_genre_atom,   72,  96, 0,  1.67940568e+02 },     
    { "Hf169",              PoPs_genre_atom,   72,  97, 0,  1.68941259e+02 },     
    { "Hf170",              PoPs_genre_atom,   72,  98, 0,  1.69939609e+02 },     
    { "Hf171",              PoPs_genre_atom,   72,  99, 0,  1.70940492e+02 },
    { "Hf172",              PoPs_genre_atom,   72, 100, 0,  1.71939448301e+02 },  
    { "Hf173",              PoPs_genre_atom,   72, 101, 0,  1.72940513e+02 },     
    { "Hf174",              PoPs_genre_atom,   72, 102, 0,  1.73940046178e+02 },  
    { "Hf175",              PoPs_genre_atom,   72, 103, 0,  1.74941509181e+02 },
    { "Hf176",              PoPs_genre_atom,   72, 104, 0,  1.75941408631e+02 },  
    { "Hf177",              PoPs_genre_atom,   72, 105, 0,  1.76943220651e+02 },  
    { "Hf178",              PoPs_genre_atom,   72, 106, 0,  Hf178_Mass },  
    { "Hf179",              PoPs_genre_atom,   72, 107, 0,  Hf179_Mass },
    { "Hf180",              PoPs_genre_atom,   72, 108, 0,  Hf180_Mass },  
    { "Hf181",              PoPs_genre_atom,   72, 109, 0,  1.80949101246e+02 },  
    { "Hf182",              PoPs_genre_atom,   72, 110, 0,  1.81950554096e+02 },  
    { "Hf183",              PoPs_genre_atom,   72, 111, 0,  1.82953530439e+02 },
    { "Hf184",              PoPs_genre_atom,   72, 112, 0,  1.83955446515e+02 },  
    { "Hf185",              PoPs_genre_atom,   72, 113, 0,  1.8495882e+02 },      
    { "Hf186",              PoPs_genre_atom,   72, 114, 0,  1.8596089e+02 },      
    { "Hf187",              PoPs_genre_atom,   72, 115, 0,  1.8696459e+02 },
    { "Hf188",              PoPs_genre_atom,   72, 116, 0,  1.8796685e+02 },      
    { "Ta_natural",         PoPs_genre_atom,   73,  -1, 0,  1.809479e+02 },       
    { "Ta155",              PoPs_genre_atom,   73,  82, 0,  1.54974592e+02 },     
    { "Ta156",              PoPs_genre_atom,   73,  83, 0,  1.55972303e+02 },
    { "Ta157",              PoPs_genre_atom,   73,  84, 0,  1.56968192445e+02 },  
    { "Ta158",              PoPs_genre_atom,   73,  85, 0,  1.57966699e+02 },     
    { "Ta159",              PoPs_genre_atom,   73,  86, 0,  1.58963018173e+02 },  
    { "Ta160",              PoPs_genre_atom,   73,  87, 0,  1.59961486056e+02 },
    { "Ta161",              PoPs_genre_atom,   73,  88, 0,  1.60958417e+02 },     
    { "Ta162",              PoPs_genre_atom,   73,  89, 0,  1.61957291859e+02 },  
    { "Ta163",              PoPs_genre_atom,   73,  90, 0,  1.62954330271e+02 },  
    { "Ta164",              PoPs_genre_atom,   73,  91, 0,  1.63953534e+02 },
    { "Ta165",              PoPs_genre_atom,   73,  92, 0,  1.64950772514e+02 },  
    { "Ta166",              PoPs_genre_atom,   73,  93, 0,  1.65950512e+02 },     
    { "Ta167",              PoPs_genre_atom,   73,  94, 0,  1.66948093e+02 },     
    { "Ta168",              PoPs_genre_atom,   73,  95, 0,  1.67948047e+02 },
    { "Ta169",              PoPs_genre_atom,   73,  96, 0,  1.68946011e+02 },     
    { "Ta170",              PoPs_genre_atom,   73,  97, 0,  1.69946175e+02 },     
    { "Ta171",              PoPs_genre_atom,   73,  98, 0,  1.70944476e+02 },     
    { "Ta172",              PoPs_genre_atom,   73,  99, 0,  1.71944895e+02 },
    { "Ta173",              PoPs_genre_atom,   73, 100, 0,  1.7294375e+02 },      
    { "Ta174",              PoPs_genre_atom,   73, 101, 0,  1.73944454e+02 },     
    { "Ta175",              PoPs_genre_atom,   73, 102, 0,  1.74943737e+02 },     
    { "Ta176",              PoPs_genre_atom,   73, 103, 0,  1.75944857e+02 },
    { "Ta177",              PoPs_genre_atom,   73, 104, 0,  1.76944472403e+02 },  
    { "Ta178",              PoPs_genre_atom,   73, 105, 0,  1.77945778221e+02 },  
    { "Ta179",              PoPs_genre_atom,   73, 106, 0,  1.78945929535e+02 },  
    { "Ta180",              PoPs_genre_atom,   73, 107, 0,  Ta180_Mass },
    { "Ta181",              PoPs_genre_atom,   73, 108, 0,  1.80947995763e+02 },  
    { "Ta182",              PoPs_genre_atom,   73, 109, 0,  Ta182_Mass },  
    { "Ta183",              PoPs_genre_atom,   73, 110, 0,  1.82951372616e+02 },  
    { "Ta184",              PoPs_genre_atom,   73, 111, 0,  1.83954007966e+02 },
    { "Ta185",              PoPs_genre_atom,   73, 112, 0,  1.84955559375e+02 },  
    { "Ta186",              PoPs_genre_atom,   73, 113, 0,  1.85958552023e+02 },  
    { "Ta187",              PoPs_genre_atom,   73, 114, 0,  1.8696053e+02 },      
    { "Ta188",              PoPs_genre_atom,   73, 115, 0,  1.879637e+02 },
    { "Ta189",              PoPs_genre_atom,   73, 116, 0,  1.8896583e+02 },      
    { "Ta190",              PoPs_genre_atom,   73, 117, 0,  1.8996923e+02 },      
    { "W_natural",          PoPs_genre_atom,   74,  -1, 0,  1.8385e+02 },         
    { "W158",               PoPs_genre_atom,   74,  84, 0,  1.57974562e+02 },
    { "W159",               PoPs_genre_atom,   74,  85, 0,  1.58972918e+02 },     
    { "W160",               PoPs_genre_atom,   74,  86, 0,  1.59968478805e+02 },  
    { "W161",               PoPs_genre_atom,   74,  87, 0,  1.60967357e+02 },     
    { "W162",               PoPs_genre_atom,   74,  88, 0,  1.61963497417e+02 },
    { "W163",               PoPs_genre_atom,   74,  89, 0,  1.62962523542e+02 },  
    { "W164",               PoPs_genre_atom,   74,  90, 0,  1.63958954382e+02 },  
    { "W165",               PoPs_genre_atom,   74,  91, 0,  1.64958279949e+02 },  
    { "W166",               PoPs_genre_atom,   74,  92, 0,  1.65955027253e+02 },
    { "W167",               PoPs_genre_atom,   74,  93, 0,  1.66954816014e+02 },  
    { "W168",               PoPs_genre_atom,   74,  94, 0,  1.67951808394e+02 },  
    { "W169",               PoPs_genre_atom,   74,  95, 0,  1.6895177879e+02 },   
    { "W170",               PoPs_genre_atom,   74,  96, 0,  1.69949228482e+02 },
    { "W171",               PoPs_genre_atom,   74,  97, 0,  1.70949451e+02 },     
    { "W172",               PoPs_genre_atom,   74,  98, 0,  1.71947292e+02 },     
    { "W173",               PoPs_genre_atom,   74,  99, 0,  1.72947689e+02 },     
    { "W174",               PoPs_genre_atom,   74, 100, 0,  1.73946079e+02 },
    { "W175",               PoPs_genre_atom,   74, 101, 0,  1.74946717e+02 },     
    { "W176",               PoPs_genre_atom,   74, 102, 0,  1.75945634e+02 },     
    { "W177",               PoPs_genre_atom,   74, 103, 0,  1.76946643e+02 },     
    { "W178",               PoPs_genre_atom,   74, 104, 0,  1.77945876236e+02 },
    { "W179",               PoPs_genre_atom,   74, 105, 0,  W179_Mass },  
    { "W180",               PoPs_genre_atom,   74, 106, 0,  1.79946704459e+02 },  
    { "W181",               PoPs_genre_atom,   74, 107, 0,  1.80948197248e+02 },  
    { "W182",               PoPs_genre_atom,   74, 108, 0,  1.81948204156e+02 },
    { "W183",               PoPs_genre_atom,   74, 109, 0,  W183_Mass },  
    { "W184",               PoPs_genre_atom,   74, 110, 0,  1.83950931188e+02 },  
    { "W185",               PoPs_genre_atom,   74, 111, 0,  W185_Mass },  
    { "W186",               PoPs_genre_atom,   74, 112, 0,  1.85954364127e+02 },
    { "W187",               PoPs_genre_atom,   74, 113, 0,  1.86957160466e+02 },  
    { "W188",               PoPs_genre_atom,   74, 114, 0,  1.87958489105e+02 },  
    { "W189",               PoPs_genre_atom,   74, 115, 0,  1.88961912868e+02 },  
    { "W190",               PoPs_genre_atom,   74, 116, 0,  1.89963181378e+02 },
    { "W191",               PoPs_genre_atom,   74, 117, 0,  1.909666e+02 },       
    { "W192",               PoPs_genre_atom,   74, 118, 0,  1.9196817e+02 },      
    { "Re_natural",         PoPs_genre_atom,   75,  -1, 0,  1.86207e+02 },        
    { "Re160",              PoPs_genre_atom,   75,  85, 0,  1.59982115e+02 },
    { "Re161",              PoPs_genre_atom,   75,  86, 0,  1.60977589119e+02 },  
    { "Re162",              PoPs_genre_atom,   75,  87, 0,  1.61976002e+02 },     
    { "Re163",              PoPs_genre_atom,   75,  88, 0,  1.62972080535e+02 },  
    { "Re164",              PoPs_genre_atom,   75,  89, 0,  1.63970323e+02 },
    { "Re165",              PoPs_genre_atom,   75,  90, 0,  1.64967088557e+02 },  
    { "Re166",              PoPs_genre_atom,   75,  91, 0,  1.65965808e+02 },     
    { "Re167",              PoPs_genre_atom,   75,  92, 0,  1.66962601e+02 },     
    { "Re168",              PoPs_genre_atom,   75,  93, 0,  1.67961572608e+02 },
    { "Re169",              PoPs_genre_atom,   75,  94, 0,  1.68958791096e+02 },  
    { "Re170",              PoPs_genre_atom,   75,  95, 0,  1.69958220071e+02 },  
    { "Re171",              PoPs_genre_atom,   75,  96, 0,  1.70955716e+02 },     
    { "Re172",              PoPs_genre_atom,   75,  97, 0,  1.71955422961e+02 },
    { "Re173",              PoPs_genre_atom,   75,  98, 0,  1.72953243e+02 },     
    { "Re174",              PoPs_genre_atom,   75,  99, 0,  1.73953115e+02 },     
    { "Re175",              PoPs_genre_atom,   75, 100, 0,  1.74951381e+02 },     
    { "Re176",              PoPs_genre_atom,   75, 101, 0,  1.75951623e+02 },
    { "Re177",              PoPs_genre_atom,   75, 102, 0,  1.76950328e+02 },     
    { "Re178",              PoPs_genre_atom,   75, 103, 0,  1.77950989e+02 },     
    { "Re179",              PoPs_genre_atom,   75, 104, 0,  1.78949987641e+02 },  
    { "Re180",              PoPs_genre_atom,   75, 105, 0,  1.79950789084e+02 },
    { "Re181",              PoPs_genre_atom,   75, 106, 0,  1.80950067916e+02 },  
    { "Re182",              PoPs_genre_atom,   75, 107, 0,  Re182_Mass },   
    { "Re183",              PoPs_genre_atom,   75, 108, 0,  1.82950819841e+02 },  
    { "Re184",              PoPs_genre_atom,   75, 109, 0,  Re184_Mass },
    { "Re185",              PoPs_genre_atom,   75, 110, 0,  1.84952954982e+02 },  
    { "Re186",              PoPs_genre_atom,   75, 111, 0,  Re186_Mass },  
    { "Re187",              PoPs_genre_atom,   75, 112, 0,  1.86955753109e+02 },  
    { "Re188",              PoPs_genre_atom,   75, 113, 0,  Re188_Mass },
    { "Re189",              PoPs_genre_atom,   75, 114, 0,  1.88959229007e+02 },  
    { "Re190",              PoPs_genre_atom,   75, 115, 0,  Re190_Mass },  
    { "Re191",              PoPs_genre_atom,   75, 116, 0,  1.90963125242e+02 },  
    { "Re192",              PoPs_genre_atom,   75, 117, 0,  1.9196596e+02 },
    { "Re193",              PoPs_genre_atom,   75, 118, 0,  1.9296747e+02 },      
    { "Re194",              PoPs_genre_atom,   75, 119, 0,  1.9397042e+02 },      
    { "Os_natural",         PoPs_genre_atom,   76,  -1, 0,  1.902e+02 },          
    { "Os162",              PoPs_genre_atom,   76,  86, 0,  1.61984431e+02 },
    { "Os163",              PoPs_genre_atom,   76,  87, 0,  1.6298269e+02 },      
    { "Os164",              PoPs_genre_atom,   76,  88, 0,  1.63978035649e+02 },  
    { "Os165",              PoPs_genre_atom,   76,  89, 0,  1.64976762e+02 },     
    { "Os166",              PoPs_genre_atom,   76,  90, 0,  1.65972690753e+02 },
    { "Os167",              PoPs_genre_atom,   76,  91, 0,  1.66971547969e+02 },  
    { "Os168",              PoPs_genre_atom,   76,  92, 0,  1.67967803678e+02 },  
    { "Os169",              PoPs_genre_atom,   76,  93, 0,  1.6896701927e+02 },   
    { "Os170",              PoPs_genre_atom,   76,  94, 0,  1.69963577028e+02 },
    { "Os171",              PoPs_genre_atom,   76,  95, 0,  1.70963184819e+02 },  
    { "Os172",              PoPs_genre_atom,   76,  96, 0,  1.71960023303e+02 },  
    { "Os173",              PoPs_genre_atom,   76,  97, 0,  1.72959808409e+02 },  
    { "Os174",              PoPs_genre_atom,   76,  98, 0,  1.73957062202e+02 },
    { "Os175",              PoPs_genre_atom,   76,  99, 0,  1.74956945835e+02 },  
    { "Os176",              PoPs_genre_atom,   76, 100, 0,  1.75954806e+02 },     
    { "Os177",              PoPs_genre_atom,   76, 101, 0,  1.76954965324e+02 },  
    { "Os178",              PoPs_genre_atom,   76, 102, 0,  1.77953251241e+02 },
    { "Os179",              PoPs_genre_atom,   76, 103, 0,  1.78953816017e+02 },  
    { "Os180",              PoPs_genre_atom,   76, 104, 0,  1.79952378803e+02 },  
    { "Os181",              PoPs_genre_atom,   76, 105, 0,  Os181_Mass },     
    { "Os182",              PoPs_genre_atom,   76, 106, 0,  1.81952110186e+02 },
    { "Os183",              PoPs_genre_atom,   76, 107, 0,  Os183_Mass },  
    { "Os184",              PoPs_genre_atom,   76, 108, 0,  1.83952489071e+02 },  
    { "Os185",              PoPs_genre_atom,   76, 109, 0,  1.84954042265e+02 },  
    { "Os186",              PoPs_genre_atom,   76, 110, 0,  1.85953838158e+02 },
    { "Os187",              PoPs_genre_atom,   76, 111, 0,  1.86955750458e+02 },  
    { "Os188",              PoPs_genre_atom,   76, 112, 0,  1.87955838228e+02 },  
    { "Os189",              PoPs_genre_atom,   76, 113, 0,  Os189_Mass },   
    { "Os190",              PoPs_genre_atom,   76, 114, 0,  1.89958447048e+02 },
    { "Os191",              PoPs_genre_atom,   76, 115, 0,  Os191_Mass },  
    { "Os192",              PoPs_genre_atom,   76, 116, 0,  1.9196148069e+02 },   
    { "Os193",              PoPs_genre_atom,   76, 117, 0,  1.92964151563e+02 },  
    { "Os194",              PoPs_genre_atom,   76, 118, 0,  1.93965182083e+02 },
    { "Os195",              PoPs_genre_atom,   76, 119, 0,  1.94968126661e+02 },  
    { "Os196",              PoPs_genre_atom,   76, 120, 0,  1.95969639333e+02 },  
    { "Ir_natural",         PoPs_genre_atom,   77,  -1, 0,  1.9222e+02 },         
    { "Ir164",              PoPs_genre_atom,   77,  87, 0,  1.63992201e+02 },
    { "Ir165",              PoPs_genre_atom,   77,  88, 0,  1.6498752e+02 },      
    { "Ir166",              PoPs_genre_atom,   77,  89, 0,  1.65985824e+02 },     
    { "Ir167",              PoPs_genre_atom,   77,  90, 0,  1.66981665156e+02 },  
    { "Ir168",              PoPs_genre_atom,   77,  91, 0,  1.67979881e+02 },
    { "Ir169",              PoPs_genre_atom,   77,  92, 0,  1.68976294942e+02 },  
    { "Ir170",              PoPs_genre_atom,   77,  93, 0,  1.69974965e+02 },     
    { "Ir171",              PoPs_genre_atom,   77,  94, 0,  1.70971626042e+02 },  
    { "Ir172",              PoPs_genre_atom,   77,  95, 0,  1.71970456e+02 },
    { "Ir173",              PoPs_genre_atom,   77,  96, 0,  1.72967501739e+02 },  
    { "Ir174",              PoPs_genre_atom,   77,  97, 0,  1.73966861045e+02 },  
    { "Ir175",              PoPs_genre_atom,   77,  98, 0,  1.74964112895e+02 },  
    { "Ir176",              PoPs_genre_atom,   77,  99, 0,  1.75963648688e+02 },
    { "Ir177",              PoPs_genre_atom,   77, 100, 0,  1.769613015e+02 },    
    { "Ir178",              PoPs_genre_atom,   77, 101, 0,  1.77961082e+02 },     
    { "Ir179",              PoPs_genre_atom,   77, 102, 0,  1.78959122266e+02 },  
    { "Ir180",              PoPs_genre_atom,   77, 103, 0,  1.79959229446e+02 },
    { "Ir181",              PoPs_genre_atom,   77, 104, 0,  1.80957625297e+02 },  
    { "Ir182",              PoPs_genre_atom,   77, 105, 0,  1.81958076296e+02 },  
    { "Ir183",              PoPs_genre_atom,   77, 106, 0,  1.82956846458e+02 },  
    { "Ir184",              PoPs_genre_atom,   77, 107, 0,  1.83957476e+02 },
    { "Ir185",              PoPs_genre_atom,   77, 108, 0,  1.84956698e+02 },     
    { "Ir186",              PoPs_genre_atom,   77, 109, 0,  Ir186_Mass },  
    { "Ir187",              PoPs_genre_atom,   77, 110, 0,  1.86957363361e+02 },  
    { "Ir188",              PoPs_genre_atom,   77, 111, 0,  1.87958853121e+02 },
    { "Ir189",              PoPs_genre_atom,   77, 112, 0,  1.88958718935e+02 },  
    { "Ir190",              PoPs_genre_atom,   77, 113, 0,  Ir190_Mass },  
    { "Ir191",              PoPs_genre_atom,   77, 114, 0,  Ir191_Mass },  
    { "Ir192",              PoPs_genre_atom,   77, 115, 0,  Ir192_Mass },
    { "Ir193",              PoPs_genre_atom,   77, 116, 0,  Ir193_Mass },   
    { "Ir194",              PoPs_genre_atom,   77, 117, 0,  Ir194_Mass },  
    { "Ir195",              PoPs_genre_atom,   77, 118, 0,  Ir195_Mass },  
    { "Ir196",              PoPs_genre_atom,   77, 119, 0,  Ir196_Mass },
    { "Ir197",              PoPs_genre_atom,   77, 120, 0,  Ir197_Mass },  
    { "Ir198",              PoPs_genre_atom,   77, 121, 0,  1.9797228e+02 },      
    { "Ir199",              PoPs_genre_atom,   77, 122, 0,  1.98973804583e+02 },  
    { "Pt_natural",         PoPs_genre_atom,   78,  -1, 0,  1.9509e+02 },
    { "Pt166",              PoPs_genre_atom,   78,  88, 0,  1.65994855e+02 },     
    { "Pt167",              PoPs_genre_atom,   78,  89, 0,  1.66992979e+02 },     
    { "Pt168",              PoPs_genre_atom,   78,  90, 0,  1.67988150742e+02 },  
    { "Pt169",              PoPs_genre_atom,   78,  91, 0,  1.68986715e+02 },
    { "Pt170",              PoPs_genre_atom,   78,  92, 0,  1.69982495289e+02 },  
    { "Pt171",              PoPs_genre_atom,   78,  93, 0,  1.70981244542e+02 },  
    { "Pt172",              PoPs_genre_atom,   78,  94, 0,  1.71977347128e+02 },  
    { "Pt173",              PoPs_genre_atom,   78,  95, 0,  1.72976444754e+02 },
    { "Pt174",              PoPs_genre_atom,   78,  96, 0,  1.73972818767e+02 },  
    { "Pt175",              PoPs_genre_atom,   78,  97, 0,  1.74972420552e+02 },  
    { "Pt176",              PoPs_genre_atom,   78,  98, 0,  1.75968944622e+02 },  
    { "Pt177",              PoPs_genre_atom,   78,  99, 0,  1.76968469481e+02 },
    { "Pt178",              PoPs_genre_atom,   78, 100, 0,  1.77965648724e+02 },  
    { "Pt179",              PoPs_genre_atom,   78, 101, 0,  1.78965363404e+02 },  
    { "Pt180",              PoPs_genre_atom,   78, 102, 0,  1.79963031477e+02 },  
    { "Pt181",              PoPs_genre_atom,   78, 103, 0,  1.80963097285e+02 },
    { "Pt182",              PoPs_genre_atom,   78, 104, 0,  1.81961170656e+02 },  
    { "Pt183",              PoPs_genre_atom,   78, 105, 0,  Pt183_Mass },  
    { "Pt184",              PoPs_genre_atom,   78, 106, 0,  1.83959922251e+02 },  
    { "Pt185",              PoPs_genre_atom,   78, 107, 0,  Pt185_Mass },
    { "Pt186",              PoPs_genre_atom,   78, 108, 0,  1.85959350813e+02 },  
    { "Pt187",              PoPs_genre_atom,   78, 109, 0,  1.86960587e+02 },     
    { "Pt188",              PoPs_genre_atom,   78, 110, 0,  1.87959395391e+02 },  
    { "Pt189",              PoPs_genre_atom,   78, 111, 0,  1.88960833686e+02 },
    { "Pt190",              PoPs_genre_atom,   78, 112, 0,  1.89959931655e+02 },  
    { "Pt191",              PoPs_genre_atom,   78, 113, 0,  1.90961676661e+02 },  
    { "Pt192",              PoPs_genre_atom,   78, 114, 0,  1.91961038005e+02 },  
    { "Pt193",              PoPs_genre_atom,   78, 115, 0,  Pt193_Mass },
    { "Pt194",              PoPs_genre_atom,   78, 116, 0,  1.93962680253e+02 },  
    { "Pt195",              PoPs_genre_atom,   78, 117, 0,  Pt195_Mass },  
    { "Pt196",              PoPs_genre_atom,   78, 118, 0,  1.95964951521e+02 },  
    { "Pt197",              PoPs_genre_atom,   78, 119, 0,  Pt197_Mass },
    { "Pt198",              PoPs_genre_atom,   78, 120, 0,  1.9796789279e+02 },   
    { "Pt199",              PoPs_genre_atom,   78, 121, 0,  Pt199_Mass },  
    { "Pt200",              PoPs_genre_atom,   78, 122, 0,  1.99971440677e+02 },  
    { "Pt201",              PoPs_genre_atom,   78, 123, 0,  2.00974512868e+02 },
    { "Pt202",              PoPs_genre_atom,   78, 124, 0,  2.0197574e+02 },      
    { "Au_natural",         PoPs_genre_atom,   79,  -1, 0,  1.969665e+02 },       
    { "Au169",              PoPs_genre_atom,   79,  90, 0,  1.6899808e+02 },      
    { "Au170",              PoPs_genre_atom,   79,  91, 0,  1.69996122e+02 },
    { "Au171",              PoPs_genre_atom,   79,  92, 0,  1.70991878881e+02 },  
    { "Au172",              PoPs_genre_atom,   79,  93, 0,  1.71990035e+02 },     
    { "Au173",              PoPs_genre_atom,   79,  94, 0,  1.7298623738e+02 },   
    { "Au174",              PoPs_genre_atom,   79,  95, 0,  1.73984761e+02 },
    { "Au175",              PoPs_genre_atom,   79,  96, 0,  1.74981274107e+02 },  
    { "Au176",              PoPs_genre_atom,   79,  97, 0,  1.75980099e+02 },     
    { "Au177",              PoPs_genre_atom,   79,  98, 0,  1.76976864908e+02 },  
    { "Au178",              PoPs_genre_atom,   79,  99, 0,  1.7797603192e+02 },
    { "Au179",              PoPs_genre_atom,   79, 100, 0,  1.78973212812e+02 },  
    { "Au180",              PoPs_genre_atom,   79, 101, 0,  1.79972521124e+02 },  
    { "Au181",              PoPs_genre_atom,   79, 102, 0,  1.80970079048e+02 },  
    { "Au182",              PoPs_genre_atom,   79, 103, 0,  1.81969617874e+02 },
    { "Au183",              PoPs_genre_atom,   79, 104, 0,  1.82967593034e+02 },  
    { "Au184",              PoPs_genre_atom,   79, 105, 0,  1.83967451524e+02 },  
    { "Au185",              PoPs_genre_atom,   79, 106, 0,  Au185_Mass },  
    { "Au186",              PoPs_genre_atom,   79, 107, 0,  1.85965952703e+02 },
    { "Au187",              PoPs_genre_atom,   79, 108, 0,  Au187_Mass },  
    { "Au188",              PoPs_genre_atom,   79, 109, 0,  1.87965323661e+02 },  
    { "Au189",              PoPs_genre_atom,   79, 110, 0,  Au189_Mass },  
    { "Au190",              PoPs_genre_atom,   79, 111, 0,  1.89964700339e+02 },
    { "Au191",              PoPs_genre_atom,   79, 112, 0,  1.90963704225e+02 },  
    { "Au192",              PoPs_genre_atom,   79, 113, 0,  1.91964812953e+02 },  
    { "Au193",              PoPs_genre_atom,   79, 114, 0,  Au193_Mass },  
    { "Au194",              PoPs_genre_atom,   79, 115, 0,  1.9396536525e+02 },
    { "Au195",              PoPs_genre_atom,   79, 116, 0,  Au195_Mass },   
    { "Au196",              PoPs_genre_atom,   79, 117, 0,  Au196_Mass },  
    { "Au197",              PoPs_genre_atom,   79, 118, 0,  Au197_Mass },  
    { "Au198",              PoPs_genre_atom,   79, 119, 0,  1.97968242303e+02 },
    { "Au199",              PoPs_genre_atom,   79, 120, 0,  1.98968765193e+02 },  
    { "Au200",              PoPs_genre_atom,   79, 121, 0,  Au200_Mass },  
    { "Au201",              PoPs_genre_atom,   79, 122, 0,  2.0097165724e+02 },   
    { "Au202",              PoPs_genre_atom,   79, 123, 0,  2.01973805838e+02 },
    { "Au203",              PoPs_genre_atom,   79, 124, 0,  2.02975154542e+02 },  
    { "Au204",              PoPs_genre_atom,   79, 125, 0,  2.03977724e+02 },     
    { "Au205",              PoPs_genre_atom,   79, 126, 0,  2.0497987e+02 },      
    { "Hg_natural",         PoPs_genre_atom,   80,  -1, 0,  2.0059e+02 },
    { "Hg171",              PoPs_genre_atom,   80,  91, 0,  1.7100376e+02 },      
    { "Hg172",              PoPs_genre_atom,   80,  92, 0,  1.71998832686e+02 },  
    { "Hg173",              PoPs_genre_atom,   80,  93, 0,  1.72997242e+02 },     
    { "Hg174",              PoPs_genre_atom,   80,  94, 0,  1.73992863695e+02 },
    { "Hg175",              PoPs_genre_atom,   80,  95, 0,  1.7499142327e+02 },   
    { "Hg176",              PoPs_genre_atom,   80,  96, 0,  1.7598735458e+02 },   
    { "Hg177",              PoPs_genre_atom,   80,  97, 0,  1.76986279158e+02 },  
    { "Hg178",              PoPs_genre_atom,   80,  98, 0,  1.77982483143e+02 },
    { "Hg179",              PoPs_genre_atom,   80,  99, 0,  1.78981833861e+02 },  
    { "Hg180",              PoPs_genre_atom,   80, 100, 0,  1.79978266394e+02 },  
    { "Hg181",              PoPs_genre_atom,   80, 101, 0,  1.80977819311e+02 },  
    { "Hg182",              PoPs_genre_atom,   80, 102, 0,  1.81974689964e+02 },
    { "Hg183",              PoPs_genre_atom,   80, 103, 0,  1.82974449841e+02 },  
    { "Hg184",              PoPs_genre_atom,   80, 104, 0,  1.83971713051e+02 },  
    { "Hg185",              PoPs_genre_atom,   80, 105, 0,  Hg185_Mass },  
    { "Hg186",              PoPs_genre_atom,   80, 106, 0,  1.8596936179e+02 },
    { "Hg187",              PoPs_genre_atom,   80, 107, 0,  Hg187_Mass },  
    { "Hg188",              PoPs_genre_atom,   80, 108, 0,  1.87967577049e+02 },  
    { "Hg189",              PoPs_genre_atom,   80, 109, 0,  Hg189_Mass },  
    { "Hg190",              PoPs_genre_atom,   80, 110, 0,  1.89966322449e+02 },
    { "Hg191",              PoPs_genre_atom,   80, 111, 0,  Hg191_Mass },  
    { "Hg192",              PoPs_genre_atom,   80, 112, 0,  1.91965634327e+02 },  
    { "Hg193",              PoPs_genre_atom,   80, 113, 0,  Hg193_Mass },  
    { "Hg194",              PoPs_genre_atom,   80, 114, 0,  1.93965439409e+02 },
    { "Hg195",              PoPs_genre_atom,   80, 115, 0,  Hg195_Mass },  
    { "Hg196",              PoPs_genre_atom,   80, 116, 0,  1.95965832649e+02 },  
    { "Hg197",              PoPs_genre_atom,   80, 117, 0,  Hg197_Mass },  
    { "Hg198",              PoPs_genre_atom,   80, 118, 0,  1.97966769032e+02 },
    { "Hg199",              PoPs_genre_atom,   80, 119, 0,  Hg199_Mass },  
    { "Hg200",              PoPs_genre_atom,   80, 120, 0,  1.99968326004e+02 },  
    { "Hg201",              PoPs_genre_atom,   80, 121, 0,  2.00970302268e+02 },  
    { "Hg202",              PoPs_genre_atom,   80, 122, 0,  2.01970643011e+02 },
    { "Hg203",              PoPs_genre_atom,   80, 123, 0,  2.02972872484e+02 },  
    { "Hg204",              PoPs_genre_atom,   80, 124, 0,  2.03973493933e+02 },  
    { "Hg205",              PoPs_genre_atom,   80, 125, 0,  2.04976073386e+02 },  
    { "Hg206",              PoPs_genre_atom,   80, 126, 0,  2.05977514066e+02 },
    { "Hg207",              PoPs_genre_atom,   80, 127, 0,  2.06982588545e+02 },  
    { "Hg208",              PoPs_genre_atom,   80, 128, 0,  2.0798594e+02 },      
    { "Hg209",              PoPs_genre_atom,   80, 129, 0,  2.0899104e+02 },      
    { "Hg210",              PoPs_genre_atom,   80, 130, 0,  2.0999451e+02 },
    { "Tl_natural",         PoPs_genre_atom,   81,  -1, 0,  2.0437e+02 },         
    { "Tl176",              PoPs_genre_atom,   81,  95, 0,  1.7600059e+02 },      
    { "Tl177",              PoPs_genre_atom,   81,  96, 0,  1.76996427286e+02 },  
    { "Tl178",              PoPs_genre_atom,   81,  97, 0,  1.77994897e+02 },
    { "Tl179",              PoPs_genre_atom,   81,  98, 0,  1.78991089082e+02 },  
    { "Tl180",              PoPs_genre_atom,   81,  99, 0,  1.79989906e+02 },     
    { "Tl181",              PoPs_genre_atom,   81, 100, 0,  1.80986257447e+02 },  
    { "Tl182",              PoPs_genre_atom,   81, 101, 0,  1.81985667104e+02 },
    { "Tl183",              PoPs_genre_atom,   81, 102, 0,  1.82982192802e+02 },  
    { "Tl184",              PoPs_genre_atom,   81, 103, 0,  1.83981873122e+02 },  
    { "Tl185",              PoPs_genre_atom,   81, 104, 0,  1.84978791305e+02 },  
    { "Tl186",              PoPs_genre_atom,   81, 105, 0,  Tl186_Mass },
    { "Tl187",              PoPs_genre_atom,   81, 106, 0,  Tl187_Mass },  
    { "Tl188",              PoPs_genre_atom,   81, 107, 0,  Tl188_Mass },  
    { "Tl189",              PoPs_genre_atom,   81, 108, 0,  Tl189_Mass },  
    { "Tl190",              PoPs_genre_atom,   81, 109, 0,  Tl190_Mass },
    { "Tl191",              PoPs_genre_atom,   81, 110, 0,  Tl191_Mass },  
    { "Tl192",              PoPs_genre_atom,   81, 111, 0,  Tl192_Mass },     
    { "Tl193",              PoPs_genre_atom,   81, 112, 0,  Tl193_Mass },     
    { "Tl194",              PoPs_genre_atom,   81, 113, 0,  Tl194_Mass },
    { "Tl195",              PoPs_genre_atom,   81, 114, 0,  Tl195_Mass },  
    { "Tl196",              PoPs_genre_atom,   81, 115, 0,  Tl196_Mass },  
    { "Tl197",              PoPs_genre_atom,   81, 116, 0,  1.96969574511e+02 },  
    { "Tl198",              PoPs_genre_atom,   81, 117, 0,  Tl198_Mass },
    { "Tl199",              PoPs_genre_atom,   81, 118, 0,  1.98969877e+02 },     
    { "Tl200",              PoPs_genre_atom,   81, 119, 0,  1.99970962672e+02 },  
    { "Tl201",              PoPs_genre_atom,   81, 120, 0,  2.00970818891e+02 },  
    { "Tl202",              PoPs_genre_atom,   81, 121, 0,  2.01972105808e+02 },
    { "Tl203",              PoPs_genre_atom,   81, 122, 0,  2.0297234422e+02 },   
    { "Tl204",              PoPs_genre_atom,   81, 123, 0,  2.03973863522e+02 },  
    { "Tl205",              PoPs_genre_atom,   81, 124, 0,  2.04974427541e+02 },  
    { "Tl206",              PoPs_genre_atom,   81, 125, 0,  2.0597611032e+02 },
    { "Tl207",              PoPs_genre_atom,   81, 126, 0,  Tl207_Mass },  
    { "Tl208",              PoPs_genre_atom,   81, 127, 0,  2.079820187e+02 },    
    { "Tl209",              PoPs_genre_atom,   81, 128, 0,  2.08985358952e+02 },  
    { "Tl210",              PoPs_genre_atom,   81, 129, 0,  2.09990073689e+02 },
    { "Tl211",              PoPs_genre_atom,   81, 130, 0,  2.10993477e+02 },     
    { "Tl212",              PoPs_genre_atom,   81, 131, 0,  2.11998228e+02 },     
    { "Pb_natural",         PoPs_genre_atom,   82,  -1, 0,  2.072e+02 },          
    { "Pb178",              PoPs_genre_atom,   82,  96, 0,  1.78003830191e+02 },
    { "Pb179",              PoPs_genre_atom,   82,  97, 0,  1.7900215e+02 },      
    { "Pb180",              PoPs_genre_atom,   82,  98, 0,  1.79997918173e+02 },  
    { "Pb181",              PoPs_genre_atom,   82,  99, 0,  1.80996623958e+02 },  
    { "Pb182",              PoPs_genre_atom,   82, 100, 0,  1.81992671842e+02 },
    { "Pb183",              PoPs_genre_atom,   82, 101, 0,  1.82991874629e+02 },  
    { "Pb184",              PoPs_genre_atom,   82, 102, 0,  1.83988142339e+02 },  
    { "Pb185",              PoPs_genre_atom,   82, 103, 0,  1.84987609944e+02 },  
    { "Pb186",              PoPs_genre_atom,   82, 104, 0,  1.85984238945e+02 },
    { "Pb187",              PoPs_genre_atom,   82, 105, 0,  Pb187_Mass },   
    { "Pb188",              PoPs_genre_atom,   82, 106, 0,  1.87980874338e+02 },  
    { "Pb189",              PoPs_genre_atom,   82, 107, 0,  1.88980807e+02 },     
    { "Pb190",              PoPs_genre_atom,   82, 108, 0,  1.89978081517e+02 },
    { "Pb191",              PoPs_genre_atom,   82, 109, 0,  Pb191_Mass },     
    { "Pb192",              PoPs_genre_atom,   82, 110, 0,  1.91975785171e+02 },  
    { "Pb193",              PoPs_genre_atom,   82, 111, 0,  Pb193_Mass },  
    { "Pb194",              PoPs_genre_atom,   82, 112, 0,  1.9397401207e+02 },
    { "Pb195",              PoPs_genre_atom,   82, 113, 0,  Pb195_Mass },   
    { "Pb196",              PoPs_genre_atom,   82, 114, 0,  1.95972774109e+02 },  
    { "Pb197",              PoPs_genre_atom,   82, 115, 0,  Pb197_Mass },  
    { "Pb198",              PoPs_genre_atom,   82, 116, 0,  1.97972033959e+02 },
    { "Pb199",              PoPs_genre_atom,   82, 117, 0,  Pb199_Mass },   
    { "Pb200",              PoPs_genre_atom,   82, 118, 0,  1.99971826675e+02 },  
    { "Pb201",              PoPs_genre_atom,   82, 119, 0,  Pb201_Mass },  
    { "Pb202",              PoPs_genre_atom,   82, 120, 0,  Pb202_Mass },
    { "Pb203",              PoPs_genre_atom,   82, 121, 0,  Pb203_Mass },  
    { "Pb204",              PoPs_genre_atom,   82, 122, 0,  Pb204_Mass },  
    { "Pb205",              PoPs_genre_atom,   82, 123, 0,  2.04974481755e+02 },  
    { "Pb206",              PoPs_genre_atom,   82, 124, 0,  2.05974465278e+02 },
    { "Pb207",              PoPs_genre_atom,   82, 125, 0,  Pb207_Mass },  
    { "Pb208",              PoPs_genre_atom,   82, 126, 0,  2.07976652071e+02 },  
    { "Pb209",              PoPs_genre_atom,   82, 127, 0,  2.0898109012e+02 },   
    { "Pb210",              PoPs_genre_atom,   82, 128, 0,  2.09984188527e+02 },
    { "Pb211",              PoPs_genre_atom,   82, 129, 0,  2.10988736964e+02 },  
    { "Pb212",              PoPs_genre_atom,   82, 130, 0,  2.11991897543e+02 },  
    { "Pb213",              PoPs_genre_atom,   82, 131, 0,  2.12996581499e+02 },  
    { "Pb214",              PoPs_genre_atom,   82, 132, 0,  2.13999805408e+02 },
    { "Pb215",              PoPs_genre_atom,   82, 133, 0,  2.15004807e+02 },     
    { "Bi_natural",         PoPs_genre_atom,   83,  -1, 0,  2.089804e+02 },       
    { "Bi184",              PoPs_genre_atom,   83, 101, 0,  1.84001124e+02 },     
    { "Bi185",              PoPs_genre_atom,   83, 102, 0,  1.84997625e+02 },
    { "Bi186",              PoPs_genre_atom,   83, 103, 0,  1.85996597625e+02 },  
    { "Bi187",              PoPs_genre_atom,   83, 104, 0,  1.86993157835e+02 },  
    { "Bi188",              PoPs_genre_atom,   83, 105, 0,  1.87992265154e+02 },  
    { "Bi189",              PoPs_genre_atom,   83, 106, 0,  1.88989199012e+02 },
    { "Bi190",              PoPs_genre_atom,   83, 107, 0,  1.89988295129e+02 },  
    { "Bi191",              PoPs_genre_atom,   83, 108, 0,  1.90985786119e+02 },  
    { "Bi192",              PoPs_genre_atom,   83, 109, 0,  1.91985457954e+02 },  
    { "Bi193",              PoPs_genre_atom,   83, 110, 0,  1.92982959771e+02 },
    { "Bi194",              PoPs_genre_atom,   83, 111, 0,  1.9398283396e+02 },   
    { "Bi195",              PoPs_genre_atom,   83, 112, 0,  1.94980650737e+02 },  
    { "Bi196",              PoPs_genre_atom,   83, 113, 0,  1.95980666509e+02 },  
    { "Bi197",              PoPs_genre_atom,   83, 114, 0,  1.96978864454e+02 },
    { "Bi198",              PoPs_genre_atom,   83, 115, 0,  1.97979206e+02 },     
    { "Bi199",              PoPs_genre_atom,   83, 116, 0,  1.98977671961e+02 },  
    { "Bi200",              PoPs_genre_atom,   83, 117, 0,  1.99978131829e+02 },  
    { "Bi201",              PoPs_genre_atom,   83, 118, 0,  2.00977009036e+02 },
    { "Bi202",              PoPs_genre_atom,   83, 119, 0,  2.01977742324e+02 },  
    { "Bi203",              PoPs_genre_atom,   83, 120, 0,  2.02976876001e+02 },  
    { "Bi204",              PoPs_genre_atom,   83, 121, 0,  2.03977812736e+02 },  
    { "Bi205",              PoPs_genre_atom,   83, 122, 0,  2.04977389366e+02 },
    { "Bi206",              PoPs_genre_atom,   83, 123, 0,  2.0597849913e+02 },   
    { "Bi207",              PoPs_genre_atom,   83, 124, 0,  2.06978470679e+02 },  
    { "Bi208",              PoPs_genre_atom,   83, 125, 0,  2.07979742196e+02 },  
    { "Bi209",              PoPs_genre_atom,   83, 126, 0,  2.08980398734e+02 },
    { "Bi210",              PoPs_genre_atom,   83, 127, 0,  2.09984120371e+02 },  
    { "Bi211",              PoPs_genre_atom,   83, 128, 0,  2.1098726946e+02 },   
    { "Bi212",              PoPs_genre_atom,   83, 129, 0,  2.11991285724e+02 },  
    { "Bi213",              PoPs_genre_atom,   83, 130, 0,  2.12994384666e+02 },
    { "Bi214",              PoPs_genre_atom,   83, 131, 0,  2.13998711539e+02 },  
    { "Bi215",              PoPs_genre_atom,   83, 132, 0,  2.15001769776e+02 },  
    { "Bi216",              PoPs_genre_atom,   83, 133, 0,  2.16006305943e+02 },  
    { "Bi217",              PoPs_genre_atom,   83, 134, 0,  2.1700947e+02 },
    { "Bi218",              PoPs_genre_atom,   83, 135, 0,  2.18014316e+02 },     
    { "Po_natural",         PoPs_genre_atom,   84,  -1, 0,  2.09e+02 },           
    { "Po188",              PoPs_genre_atom,   84, 104, 0,  1.87999422048e+02 },  
    { "Po189",              PoPs_genre_atom,   84, 105, 0,  1.88998480562e+02 },
    { "Po190",              PoPs_genre_atom,   84, 106, 0,  1.89995101185e+02 },  
    { "Po191",              PoPs_genre_atom,   84, 107, 0,  1.90994574485e+02 },  
    { "Po192",              PoPs_genre_atom,   84, 108, 0,  1.91991335149e+02 },  
    { "Po193",              PoPs_genre_atom,   84, 109, 0,  1.92991025275e+02 },
    { "Po194",              PoPs_genre_atom,   84, 110, 0,  1.93988185606e+02 },  
    { "Po195",              PoPs_genre_atom,   84, 111, 0,  1.94988110728e+02 },  
    { "Po196",              PoPs_genre_atom,   84, 112, 0,  1.9598553458e+02 },   
    { "Po197",              PoPs_genre_atom,   84, 113, 0,  1.9698565963e+02 },
    { "Po198",              PoPs_genre_atom,   84, 114, 0,  1.97983388616e+02 },  
    { "Po199",              PoPs_genre_atom,   84, 115, 0,  1.98983666063e+02 },  
    { "Po200",              PoPs_genre_atom,   84, 116, 0,  1.99981798604e+02 },  
    { "Po201",              PoPs_genre_atom,   84, 117, 0,  2.00982259764e+02 },
    { "Po202",              PoPs_genre_atom,   84, 118, 0,  2.01980757541e+02 },  
    { "Po203",              PoPs_genre_atom,   84, 119, 0,  2.02981420103e+02 },  
    { "Po204",              PoPs_genre_atom,   84, 120, 0,  2.03980318121e+02 },  
    { "Po205",              PoPs_genre_atom,   84, 121, 0,  2.04981203322e+02 },
    { "Po206",              PoPs_genre_atom,   84, 122, 0,  2.05980481099e+02 },  
    { "Po207",              PoPs_genre_atom,   84, 123, 0,  2.06981593173e+02 },  
    { "Po208",              PoPs_genre_atom,   84, 124, 0,  2.07981245702e+02 },  
    { "Po209",              PoPs_genre_atom,   84, 125, 0,  2.08982430435e+02 },
    { "Po210",              PoPs_genre_atom,   84, 126, 0,  2.09982873673e+02 },  
    { "Po211",              PoPs_genre_atom,   84, 127, 0,  2.10986653154e+02 },  
    { "Po212",              PoPs_genre_atom,   84, 128, 0,  2.11988867969e+02 },  
    { "Po213",              PoPs_genre_atom,   84, 129, 0,  2.1299285728e+02 },
    { "Po214",              PoPs_genre_atom,   84, 130, 0,  2.1399520135e+02 },   
    { "Po215",              PoPs_genre_atom,   84, 131, 0,  2.14999419988e+02 },  
    { "Po216",              PoPs_genre_atom,   84, 132, 0,  2.16001915035e+02 },  
    { "Po217",              PoPs_genre_atom,   84, 133, 0,  2.17006334796e+02 },
    { "Po218",              PoPs_genre_atom,   84, 134, 0,  2.18008973037e+02 },  
    { "Po219",              PoPs_genre_atom,   84, 135, 0,  2.19013744e+02 },     
    { "Po220",              PoPs_genre_atom,   84, 136, 0,  2.20016602e+02 },     
    { "At_natural",         PoPs_genre_atom,   85,  -1, 0,  2.1e+02 },
    { "At193",              PoPs_genre_atom,   85, 108, 0,  1.92999843112e+02 },  
    { "At194",              PoPs_genre_atom,   85, 109, 0,  1.93998725085e+02 },  
    { "At195",              PoPs_genre_atom,   85, 110, 0,  1.94996268098e+02 },  
    { "At196",              PoPs_genre_atom,   85, 111, 0,  1.95995788077e+02 },
    { "At197",              PoPs_genre_atom,   85, 112, 0,  1.96993189215e+02 },  
    { "At198",              PoPs_genre_atom,   85, 113, 0,  1.97992837202e+02 },  
    { "At199",              PoPs_genre_atom,   85, 114, 0,  1.98990532254e+02 },  
    { "At200",              PoPs_genre_atom,   85, 115, 0,  1.99990351264e+02 },
    { "At201",              PoPs_genre_atom,   85, 116, 0,  2.00988416999e+02 },  
    { "At202",              PoPs_genre_atom,   85, 117, 0,  2.01988630236e+02 },  
    { "At203",              PoPs_genre_atom,   85, 118, 0,  2.02986941984e+02 },  
    { "At204",              PoPs_genre_atom,   85, 119, 0,  2.03987251326e+02 },
    { "At205",              PoPs_genre_atom,   85, 120, 0,  2.04986074483e+02 },  
    { "At206",              PoPs_genre_atom,   85, 121, 0,  2.05986667036e+02 },  
    { "At207",              PoPs_genre_atom,   85, 122, 0,  2.06985783502e+02 },  
    { "At208",              PoPs_genre_atom,   85, 123, 0,  2.07986589977e+02 },
    { "At209",              PoPs_genre_atom,   85, 124, 0,  2.08986173143e+02 },  
    { "At210",              PoPs_genre_atom,   85, 125, 0,  2.0998714771e+02 },   
    { "At211",              PoPs_genre_atom,   85, 126, 0,  2.10987496271e+02 },  
    { "At212",              PoPs_genre_atom,   85, 127, 0,  2.11990744771e+02 },
    { "At213",              PoPs_genre_atom,   85, 128, 0,  2.12992936646e+02 },  
    { "At214",              PoPs_genre_atom,   85, 129, 0,  2.13996371733e+02 },  
    { "At215",              PoPs_genre_atom,   85, 130, 0,  2.1499865257e+02 },   
    { "At216",              PoPs_genre_atom,   85, 131, 0,  2.16002423257e+02 },
    { "At217",              PoPs_genre_atom,   85, 132, 0,  2.17004718822e+02 },  
    { "At218",              PoPs_genre_atom,   85, 133, 0,  2.18008694336e+02 },  
    { "At219",              PoPs_genre_atom,   85, 134, 0,  2.19011161691e+02 },  
    { "At220",              PoPs_genre_atom,   85, 135, 0,  2.20015407682e+02 },
    { "At221",              PoPs_genre_atom,   85, 136, 0,  2.2101805e+02 },      
    { "At222",              PoPs_genre_atom,   85, 137, 0,  2.2202233e+02 },      
    { "At223",              PoPs_genre_atom,   85, 138, 0,  2.2302519e+02 },      
    { "Rn_natural",         PoPs_genre_atom,   86,  -1, 0,  2.22e+02 },
    { "Rn195",              PoPs_genre_atom,   86, 109, 0,  1.95005437696e+02 },  
    { "Rn196",              PoPs_genre_atom,   86, 110, 0,  1.96002115223e+02 },  
    { "Rn197",              PoPs_genre_atom,   86, 111, 0,  1.97001584351e+02 },  
    { "Rn198",              PoPs_genre_atom,   86, 112, 0,  1.97998678663e+02 },
    { "Rn199",              PoPs_genre_atom,   86, 113, 0,  1.98998370297e+02 },  
    { "Rn200",              PoPs_genre_atom,   86, 114, 0,  1.999956993e+02 },    
    { "Rn201",              PoPs_genre_atom,   86, 115, 0,  2.00995628335e+02 },  
    { "Rn202",              PoPs_genre_atom,   86, 116, 0,  2.01993263492e+02 },
    { "Rn203",              PoPs_genre_atom,   86, 117, 0,  2.02993386687e+02 },  
    { "Rn204",              PoPs_genre_atom,   86, 118, 0,  2.0399142874e+02 },   
    { "Rn205",              PoPs_genre_atom,   86, 119, 0,  2.04991718799e+02 },  
    { "Rn206",              PoPs_genre_atom,   86, 120, 0,  2.05990214104e+02 },
    { "Rn207",              PoPs_genre_atom,   86, 121, 0,  2.06990734225e+02 },  
    { "Rn208",              PoPs_genre_atom,   86, 122, 0,  2.0798964247e+02 },   
    { "Rn209",              PoPs_genre_atom,   86, 123, 0,  2.08990414742e+02 },  
    { "Rn210",              PoPs_genre_atom,   86, 124, 0,  2.09989696216e+02 },
    { "Rn211",              PoPs_genre_atom,   86, 125, 0,  2.10990600523e+02 },  
    { "Rn212",              PoPs_genre_atom,   86, 126, 0,  2.11990703529e+02 },  
    { "Rn213",              PoPs_genre_atom,   86, 127, 0,  2.12993882668e+02 },  
    { "Rn214",              PoPs_genre_atom,   86, 128, 0,  2.13995362554e+02 },
    { "Rn215",              PoPs_genre_atom,   86, 129, 0,  2.14998745483e+02 },  
    { "Rn216",              PoPs_genre_atom,   86, 130, 0,  2.1600027437e+02 },   
    { "Rn217",              PoPs_genre_atom,   86, 131, 0,  2.17003927675e+02 },  
    { "Rn218",              PoPs_genre_atom,   86, 132, 0,  2.18005601256e+02 },
    { "Rn219",              PoPs_genre_atom,   86, 133, 0,  2.19009480204e+02 },  
    { "Rn220",              PoPs_genre_atom,   86, 134, 0,  2.20011393981e+02 },  
    { "Rn221",              PoPs_genre_atom,   86, 135, 0,  2.21015536782e+02 },  
    { "Rn222",              PoPs_genre_atom,   86, 136, 0,  2.22017577738e+02 },
    { "Rn223",              PoPs_genre_atom,   86, 137, 0,  2.2302179e+02 },      
    { "Rn224",              PoPs_genre_atom,   86, 138, 0,  2.2402409e+02 },      
    { "Rn225",              PoPs_genre_atom,   86, 139, 0,  2.2502844e+02 },      
    { "Rn226",              PoPs_genre_atom,   86, 140, 0,  2.2603089e+02 },
    { "Rn227",              PoPs_genre_atom,   86, 141, 0,  2.27035407e+02 },     
    { "Rn228",              PoPs_genre_atom,   86, 142, 0,  2.28037986e+02 },     
    { "Fr_natural",         PoPs_genre_atom,   87,  -1, 0,  2.23e+02 },           
    { "Fr199",              PoPs_genre_atom,   87, 112, 0,  1.99007258147e+02 },
    { "Fr200",              PoPs_genre_atom,   87, 113, 0,  2.0000657249e+02 },   
    { "Fr201",              PoPs_genre_atom,   87, 114, 0,  2.01003860867e+02 },  
    { "Fr202",              PoPs_genre_atom,   87, 115, 0,  2.02003372847e+02 },  
    { "Fr203",              PoPs_genre_atom,   87, 116, 0,  2.03000924647e+02 },
    { "Fr204",              PoPs_genre_atom,   87, 117, 0,  2.04000653204e+02 },  
    { "Fr205",              PoPs_genre_atom,   87, 118, 0,  2.0499859396e+02 },   
    { "Fr206",              PoPs_genre_atom,   87, 119, 0,  2.05998666066e+02 },  
    { "Fr207",              PoPs_genre_atom,   87, 120, 0,  2.06996949414e+02 },
    { "Fr208",              PoPs_genre_atom,   87, 121, 0,  2.07997138783e+02 },  
    { "Fr209",              PoPs_genre_atom,   87, 122, 0,  2.08995953555e+02 },  
    { "Fr210",              PoPs_genre_atom,   87, 123, 0,  2.09996407738e+02 },  
    { "Fr211",              PoPs_genre_atom,   87, 124, 0,  2.10995536544e+02 },
    { "Fr212",              PoPs_genre_atom,   87, 125, 0,  2.11996202244e+02 },  
    { "Fr213",              PoPs_genre_atom,   87, 126, 0,  2.12996189081e+02 },  
    { "Fr214",              PoPs_genre_atom,   87, 127, 0,  2.13998971145e+02 },  
    { "Fr215",              PoPs_genre_atom,   87, 128, 0,  2.15000341497e+02 },
    { "Fr216",              PoPs_genre_atom,   87, 129, 0,  2.1600319799e+02 },   
    { "Fr217",              PoPs_genre_atom,   87, 130, 0,  2.17004631951e+02 },  
    { "Fr218",              PoPs_genre_atom,   87, 131, 0,  2.18007578322e+02 },  
    { "Fr219",              PoPs_genre_atom,   87, 132, 0,  2.19009252149e+02 },
    { "Fr220",              PoPs_genre_atom,   87, 133, 0,  2.20012327405e+02 },  
    { "Fr221",              PoPs_genre_atom,   87, 134, 0,  2.21014254762e+02 },  
    { "Fr222",              PoPs_genre_atom,   87, 135, 0,  2.2201755173e+02 },   
    { "Fr223",              PoPs_genre_atom,   87, 136, 0,  2.23019735857e+02 },
    { "Fr224",              PoPs_genre_atom,   87, 137, 0,  2.24023249951e+02 },  
    { "Fr225",              PoPs_genre_atom,   87, 138, 0,  2.25025565414e+02 },  
    { "Fr226",              PoPs_genre_atom,   87, 139, 0,  2.26029386231e+02 },  
    { "Fr227",              PoPs_genre_atom,   87, 140, 0,  2.27031835938e+02 },
    { "Fr228",              PoPs_genre_atom,   87, 141, 0,  2.28035729e+02 },     
    { "Fr229",              PoPs_genre_atom,   87, 142, 0,  2.29038450228e+02 },  
    { "Fr230",              PoPs_genre_atom,   87, 143, 0,  2.3004251e+02 },      
    { "Fr231",              PoPs_genre_atom,   87, 144, 0,  2.3104544e+02 },
    { "Fr232",              PoPs_genre_atom,   87, 145, 0,  2.32049772e+02 },     
    { "Ra_natural",         PoPs_genre_atom,   88,  -1, 0,  2.26e+02 },           
    { "Ra202",              PoPs_genre_atom,   88, 114, 0,  2.02009890686e+02 },  
    { "Ra203",              PoPs_genre_atom,   88, 115, 0,  2.03009271619e+02 },
    { "Ra204",              PoPs_genre_atom,   88, 116, 0,  2.04006499668e+02 },  
    { "Ra205",              PoPs_genre_atom,   88, 117, 0,  2.0500626857e+02 },   
    { "Ra206",              PoPs_genre_atom,   88, 118, 0,  2.0600382727e+02 },   
    { "Ra207",              PoPs_genre_atom,   88, 119, 0,  2.07003798105e+02 },
    { "Ra208",              PoPs_genre_atom,   88, 120, 0,  2.0800183994e+02 },   
    { "Ra209",              PoPs_genre_atom,   88, 121, 0,  2.09001991373e+02 },  
    { "Ra210",              PoPs_genre_atom,   88, 122, 0,  2.10000494978e+02 },  
    { "Ra211",              PoPs_genre_atom,   88, 123, 0,  2.11000897987e+02 },
    { "Ra212",              PoPs_genre_atom,   88, 124, 0,  2.11999794499e+02 },  
    { "Ra213",              PoPs_genre_atom,   88, 125, 0,  2.13000383959e+02 },  
    { "Ra214",              PoPs_genre_atom,   88, 126, 0,  2.14000107894e+02 },  
    { "Ra215",              PoPs_genre_atom,   88, 127, 0,  2.15002719834e+02 },
    { "Ra216",              PoPs_genre_atom,   88, 128, 0,  2.16003533035e+02 },  
    { "Ra217",              PoPs_genre_atom,   88, 129, 0,  2.17006320327e+02 },  
    { "Ra218",              PoPs_genre_atom,   88, 130, 0,  2.1800714023e+02 },   
    { "Ra219",              PoPs_genre_atom,   88, 131, 0,  2.19010085078e+02 },
    { "Ra220",              PoPs_genre_atom,   88, 132, 0,  2.20011028384e+02 },  
    { "Ra221",              PoPs_genre_atom,   88, 133, 0,  2.21013917338e+02 },  
    { "Ra222",              PoPs_genre_atom,   88, 134, 0,  2.2201537453e+02 },   
    { "Ra223",              PoPs_genre_atom,   88, 135, 0,  2.23018502171e+02 },
    { "Ra224",              PoPs_genre_atom,   88, 136, 0,  2.24020211821e+02 },  
    { "Ra225",              PoPs_genre_atom,   88, 137, 0,  2.25023611564e+02 },  
    { "Ra226",              PoPs_genre_atom,   88, 138, 0,  2.26025409823e+02 },  
    { "Ra227",              PoPs_genre_atom,   88, 139, 0,  2.27029177842e+02 },
    { "Ra228",              PoPs_genre_atom,   88, 140, 0,  2.28031070292e+02 },  
    { "Ra229",              PoPs_genre_atom,   88, 141, 0,  2.29034957577e+02 },  
    { "Ra230",              PoPs_genre_atom,   88, 142, 0,  2.30037056394e+02 },  
    { "Ra231",              PoPs_genre_atom,   88, 143, 0,  2.3104122e+02 },
    { "Ra232",              PoPs_genre_atom,   88, 144, 0,  2.32043638e+02 },     
    { "Ra233",              PoPs_genre_atom,   88, 145, 0,  2.3304806e+02 },      
    { "Ra234",              PoPs_genre_atom,   88, 146, 0,  2.34050704e+02 },     
    { "Ac_natural",         PoPs_genre_atom,   89,  -1, 0,  2.27e+02 },
    { "Ac206",              PoPs_genre_atom,   89, 117, 0,  2.0601450498e+02 },   
    { "Ac207",              PoPs_genre_atom,   89, 118, 0,  2.07011949748e+02 },  
    { "Ac208",              PoPs_genre_atom,   89, 119, 0,  2.08011551551e+02 },  
    { "Ac209",              PoPs_genre_atom,   89, 120, 0,  2.09009494863e+02 },
    { "Ac210",              PoPs_genre_atom,   89, 121, 0,  2.10009435986e+02 },  
    { "Ac211",              PoPs_genre_atom,   89, 122, 0,  2.11007734835e+02 },  
    { "Ac212",              PoPs_genre_atom,   89, 123, 0,  2.12007813822e+02 },  
    { "Ac213",              PoPs_genre_atom,   89, 124, 0,  2.13006607643e+02 },
    { "Ac214",              PoPs_genre_atom,   89, 125, 0,  2.14006901798e+02 },  
    { "Ac215",              PoPs_genre_atom,   89, 126, 0,  2.15006453625e+02 },  
    { "Ac216",              PoPs_genre_atom,   89, 127, 0,  2.16008720075e+02 },  
    { "Ac217",              PoPs_genre_atom,   89, 128, 0,  2.17009346914e+02 },
    { "Ac218",              PoPs_genre_atom,   89, 129, 0,  2.18011641453e+02 },  
    { "Ac219",              PoPs_genre_atom,   89, 130, 0,  2.19012420389e+02 },  
    { "Ac220",              PoPs_genre_atom,   89, 131, 0,  2.20014762979e+02 },  
    { "Ac221",              PoPs_genre_atom,   89, 132, 0,  2.21015591248e+02 },
    { "Ac222",              PoPs_genre_atom,   89, 133, 0,  2.22017843851e+02 },  
    { "Ac223",              PoPs_genre_atom,   89, 134, 0,  2.23019137468e+02 },  
    { "Ac224",              PoPs_genre_atom,   89, 135, 0,  2.24021722866e+02 },  
    { "Ac225",              PoPs_genre_atom,   89, 136, 0,  2.25023229585e+02 },
    { "Ac226",              PoPs_genre_atom,   89, 137, 0,  2.26026098089e+02 },  
    { "Ac227",              PoPs_genre_atom,   89, 138, 0,  2.27027752127e+02 },  
    { "Ac228",              PoPs_genre_atom,   89, 139, 0,  2.28031021112e+02 },  
    { "Ac229",              PoPs_genre_atom,   89, 140, 0,  2.29033015243e+02 },
    { "Ac230",              PoPs_genre_atom,   89, 141, 0,  2.30036294178e+02 },  
    { "Ac231",              PoPs_genre_atom,   89, 142, 0,  2.31038558786e+02 },  
    { "Ac232",              PoPs_genre_atom,   89, 143, 0,  2.32042027438e+02 },  
    { "Ac233",              PoPs_genre_atom,   89, 144, 0,  2.3304455e+02 },
    { "Ac234",              PoPs_genre_atom,   89, 145, 0,  2.3404842e+02 },      
    { "Ac235",              PoPs_genre_atom,   89, 146, 0,  2.35051232e+02 },     
    { "Ac236",              PoPs_genre_atom,   89, 147, 0,  2.36055296e+02 },     
    { "Th_natural",         PoPs_genre_atom,   90,  -1, 0,  2.320381e+02 },
    { "Th209",              PoPs_genre_atom,   90, 119, 0,  2.09017715682e+02 },  
    { "Th210",              PoPs_genre_atom,   90, 120, 0,  2.10015075342e+02 },  
    { "Th211",              PoPs_genre_atom,   90, 121, 0,  2.11014928413e+02 },  
    { "Th212",              PoPs_genre_atom,   90, 122, 0,  2.12012980288e+02 },
    { "Th213",              PoPs_genre_atom,   90, 123, 0,  2.1301301014e+02 },   
    { "Th214",              PoPs_genre_atom,   90, 124, 0,  2.1401149977e+02 },   
    { "Th215",              PoPs_genre_atom,   90, 125, 0,  2.1501173033e+02 },   
    { "Th216",              PoPs_genre_atom,   90, 126, 0,  2.16011062115e+02 },
    { "Th217",              PoPs_genre_atom,   90, 127, 0,  2.17013114328e+02 },  
    { "Th218",              PoPs_genre_atom,   90, 128, 0,  2.18013284499e+02 },  
    { "Th219",              PoPs_genre_atom,   90, 129, 0,  2.19015536895e+02 },  
    { "Th220",              PoPs_genre_atom,   90, 130, 0,  2.20015747762e+02 },
    { "Th221",              PoPs_genre_atom,   90, 131, 0,  2.21018183674e+02 },  
    { "Th222",              PoPs_genre_atom,   90, 132, 0,  2.22018468121e+02 },  
    { "Th223",              PoPs_genre_atom,   90, 133, 0,  2.23020811448e+02 },  
    { "Th224",              PoPs_genre_atom,   90, 134, 0,  2.24021466895e+02 },
    { "Th225",              PoPs_genre_atom,   90, 135, 0,  2.25023951021e+02 },  
    { "Th226",              PoPs_genre_atom,   90, 136, 0,  2.26024903069e+02 },  
    { "Th227",              PoPs_genre_atom,   90, 137, 0,  2.2702770407e+02 },   
    { "Th228",              PoPs_genre_atom,   90, 138, 0,  2.28028741127e+02 },
    { "Th229",              PoPs_genre_atom,   90, 139, 0,  2.2903176243e+02 },   
    { "Th230",              PoPs_genre_atom,   90, 140, 0,  2.30033133843e+02 },  
    { "Th231",              PoPs_genre_atom,   90, 141, 0,  2.31036304343e+02 },  
    { "Th232",              PoPs_genre_atom,   90, 142, 0,  2.32038055325e+02 },
    { "Th233",              PoPs_genre_atom,   90, 143, 0,  2.33041581843e+02 },  
    { "Th234",              PoPs_genre_atom,   90, 144, 0,  2.3404360123e+02 },   
    { "Th235",              PoPs_genre_atom,   90, 145, 0,  2.35047510074e+02 },  
    { "Th236",              PoPs_genre_atom,   90, 146, 0,  2.3604987e+02 },
    { "Th237",              PoPs_genre_atom,   90, 147, 0,  2.37053894e+02 },     
    { "Th238",              PoPs_genre_atom,   90, 148, 0,  2.38056496e+02 },     
    { "Pa_natural",         PoPs_genre_atom,   91,  -1, 0,  2.31e+02 },           
    { "Pa212",              PoPs_genre_atom,   91, 121, 0,  2.12023204138e+02 },
    { "Pa213",              PoPs_genre_atom,   91, 122, 0,  2.1302110934e+02 },   
    { "Pa214",              PoPs_genre_atom,   91, 123, 0,  2.14020918417e+02 },  
    { "Pa215",              PoPs_genre_atom,   91, 124, 0,  2.15019185865e+02 },  
    { "Pa216",              PoPs_genre_atom,   91, 125, 0,  2.16019109564e+02 },
    { "Pa217",              PoPs_genre_atom,   91, 126, 0,  2.17018323986e+02 },  
    { "Pa218",              PoPs_genre_atom,   91, 127, 0,  2.18020041889e+02 },  
    { "Pa219",              PoPs_genre_atom,   91, 128, 0,  2.19019883143e+02 },  
    { "Pa220",              PoPs_genre_atom,   91, 129, 0,  2.20021875303e+02 },
    { "Pa221",              PoPs_genre_atom,   91, 130, 0,  2.21021877983e+02 },  
    { "Pa222",              PoPs_genre_atom,   91, 131, 0,  2.22023742e+02 },     
    { "Pa223",              PoPs_genre_atom,   91, 132, 0,  2.23023962273e+02 },  
    { "Pa224",              PoPs_genre_atom,   91, 133, 0,  2.24025625738e+02 },
    { "Pa225",              PoPs_genre_atom,   91, 134, 0,  2.25026130678e+02 },  
    { "Pa226",              PoPs_genre_atom,   91, 135, 0,  2.26027947753e+02 },  
    { "Pa227",              PoPs_genre_atom,   91, 136, 0,  2.27028805072e+02 },  
    { "Pa228",              PoPs_genre_atom,   91, 137, 0,  2.28031051376e+02 },
    { "Pa229",              PoPs_genre_atom,   91, 138, 0,  2.29032096793e+02 },  
    { "Pa230",              PoPs_genre_atom,   91, 139, 0,  2.30034540754e+02 },  
    { "Pa231",              PoPs_genre_atom,   91, 140, 0,  2.3103588399e+02 },   
    { "Pa232",              PoPs_genre_atom,   91, 141, 0,  2.32038591592e+02 },
    { "Pa233",              PoPs_genre_atom,   91, 142, 0,  2.33040247277e+02 },  
    { "Pa234",              PoPs_genre_atom,   91, 143, 0,  2.34043308058e+02 },  
    { "Pa235",              PoPs_genre_atom,   91, 144, 0,  2.35045443615e+02 },  
    { "Pa236",              PoPs_genre_atom,   91, 145, 0,  2.36048681284e+02 },
    { "Pa237",              PoPs_genre_atom,   91, 146, 0,  2.37051145659e+02 },  
    { "Pa238",              PoPs_genre_atom,   91, 147, 0,  2.3805450271e+02 },   
    { "Pa239",              PoPs_genre_atom,   91, 148, 0,  2.3905726e+02 },      
    { "Pa240",              PoPs_genre_atom,   91, 149, 0,  2.4006098e+02 },
    { "U_natural",          PoPs_genre_atom,   92,  -1, 0,  2.38029e+02 },        
    { "U217",               PoPs_genre_atom,   92, 125, 0,  2.17024368791e+02 },  
    { "U218",               PoPs_genre_atom,   92, 126, 0,  2.18023535671e+02 },  
    { "U219",               PoPs_genre_atom,   92, 127, 0,  2.1902491916e+02 },
    { "U220",               PoPs_genre_atom,   92, 128, 0,  2.20024723e+02 },     
    { "U221",               PoPs_genre_atom,   92, 129, 0,  2.21026399e+02 },     
    { "U222",               PoPs_genre_atom,   92, 130, 0,  2.22026086e+02 },     
    { "U223",               PoPs_genre_atom,   92, 131, 0,  2.230277386e+02 },
    { "U224",               PoPs_genre_atom,   92, 132, 0,  2.24027604778e+02 },  
    { "U225",               PoPs_genre_atom,   92, 133, 0,  2.25029390717e+02 },  
    { "U226",               PoPs_genre_atom,   92, 134, 0,  2.26029338702e+02 },  
    { "U227",               PoPs_genre_atom,   92, 135, 0,  2.27031156367e+02 },
    { "U228",               PoPs_genre_atom,   92, 136, 0,  2.28031374006e+02 },  
    { "U229",               PoPs_genre_atom,   92, 137, 0,  2.29033505939e+02 },  
    { "U230",               PoPs_genre_atom,   92, 138, 0,  2.30033939784e+02 },  
    { "U231",               PoPs_genre_atom,   92, 139, 0,  2.31036293704e+02 },
    { "U232",               PoPs_genre_atom,   92, 140, 0,  2.32037156152e+02 },  
    { "U233",               PoPs_genre_atom,   92, 141, 0,  2.33039635207e+02 },  
    { "U234",               PoPs_genre_atom,   92, 142, 0,  2.34040952088e+02 },  
    { "U235",               PoPs_genre_atom,   92, 143, 0,  2.35043929918e+02 },
    { "U236",               PoPs_genre_atom,   92, 144, 0,  2.36045568006e+02 },  
    { "U237",               PoPs_genre_atom,   92, 145, 0,  2.37048730184e+02 },  
    { "U238",               PoPs_genre_atom,   92, 146, 0,  2.38050788247e+02 },  
    { "U239",               PoPs_genre_atom,   92, 147, 0,  2.39054293299e+02 },
    { "U240",               PoPs_genre_atom,   92, 148, 0,  2.40056591988e+02 },  
    { "U241",               PoPs_genre_atom,   92, 149, 0,  2.4106033e+02 },      
    { "U242",               PoPs_genre_atom,   92, 150, 0,  2.42062931e+02 },     
    { "Np_natural",         PoPs_genre_atom,   93,  -1, 0,  2.37e+02 },
    { "Np225",              PoPs_genre_atom,   93, 132, 0,  2.25033913933e+02 },  
    { "Np226",              PoPs_genre_atom,   93, 133, 0,  2.26035145e+02 },     
    { "Np227",              PoPs_genre_atom,   93, 134, 0,  2.27034956789e+02 },  
    { "Np228",              PoPs_genre_atom,   93, 135, 0,  2.2803618e+02 },
    { "Np229",              PoPs_genre_atom,   93, 136, 0,  2.29036263808e+02 },  
    { "Np230",              PoPs_genre_atom,   93, 137, 0,  2.30037827597e+02 },  
    { "Np231",              PoPs_genre_atom,   93, 138, 0,  2.31038245085e+02 },  
    { "Np232",              PoPs_genre_atom,   93, 139, 0,  2.32040108e+02 },
    { "Np233",              PoPs_genre_atom,   93, 140, 0,  2.33040740546e+02 },  
    { "Np234",              PoPs_genre_atom,   93, 141, 0,  2.34042895038e+02 },  
    { "Np235",              PoPs_genre_atom,   93, 142, 0,  2.35044063267e+02 },  
    { "Np236",              PoPs_genre_atom,   93, 143, 0,  Np236_Mass },
    { "Np237",              PoPs_genre_atom,   93, 144, 0,  2.37048173444e+02 },  
    { "Np238",              PoPs_genre_atom,   93, 145, 0,  2.38050946405e+02 },  
    { "Np239",              PoPs_genre_atom,   93, 146, 0,  2.39052939025e+02 },  
    { "Np240",              PoPs_genre_atom,   93, 147, 0,  2.40056162182e+02 },
    { "Np241",              PoPs_genre_atom,   93, 148, 0,  2.41058252431e+02 },  
    { "Np242",              PoPs_genre_atom,   93, 149, 0,  2.4206164118e+02 },   
    { "Np243",              PoPs_genre_atom,   93, 150, 0,  2.43064279e+02 },     
    { "Np244",              PoPs_genre_atom,   93, 151, 0,  2.4406785e+02 },
    { "Pu_natural",         PoPs_genre_atom,   94,  -1, 0,  2.44e+02 },           
    { "Pu228",              PoPs_genre_atom,   94, 134, 0,  2.28038742328e+02 },  
    { "Pu229",              PoPs_genre_atom,   94, 135, 0,  2.29040150212e+02 },  
    { "Pu230",              PoPs_genre_atom,   94, 136, 0,  2.30039649886e+02 },
    { "Pu231",              PoPs_genre_atom,   94, 137, 0,  2.31041101107e+02 },  
    { "Pu232",              PoPs_genre_atom,   94, 138, 0,  2.32041187097e+02 },  
    { "Pu233",              PoPs_genre_atom,   94, 139, 0,  2.33042997375e+02 },  
    { "Pu234",              PoPs_genre_atom,   94, 140, 0,  2.34043317076e+02 },
    { "Pu235",              PoPs_genre_atom,   94, 141, 0,  2.3504528605e+02 },   
    { "Pu236",              PoPs_genre_atom,   94, 142, 0,  2.36046057964e+02 },  
    { "Pu237",              PoPs_genre_atom,   94, 143, 0,  2.37048409658e+02 },  
    { "Pu238",              PoPs_genre_atom,   94, 144, 0,  2.38049559894e+02 },
    { "Pu239",              PoPs_genre_atom,   94, 145, 0,  2.39052163381e+02 },  
    { "Pu240",              PoPs_genre_atom,   94, 146, 0,  2.40053813545e+02 },  
    { "Pu241",              PoPs_genre_atom,   94, 147, 0,  2.41056851456e+02 },  
    { "Pu242",              PoPs_genre_atom,   94, 148, 0,  2.42058742611e+02 },
    { "Pu243",              PoPs_genre_atom,   94, 149, 0,  2.43062003092e+02 },  
    { "Pu244",              PoPs_genre_atom,   94, 150, 0,  2.44064203907e+02 },  
    { "Pu245",              PoPs_genre_atom,   94, 151, 0,  2.45067747154e+02 },  
    { "Pu246",              PoPs_genre_atom,   94, 152, 0,  2.46070204627e+02 },
    { "Pu247",              PoPs_genre_atom,   94, 153, 0,  2.4707407e+02 },      
    { "Am_natural",         PoPs_genre_atom,   95,  -1, 0,  2.43e+02 },           
    { "Am231",              PoPs_genre_atom,   95, 136, 0,  2.3104556e+02 },      
    { "Am232",              PoPs_genre_atom,   95, 137, 0,  2.3204659e+02 },
    { "Am233",              PoPs_genre_atom,   95, 138, 0,  2.33046348e+02 },     
    { "Am234",              PoPs_genre_atom,   95, 139, 0,  2.34047809e+02 },     
    { "Am235",              PoPs_genre_atom,   95, 140, 0,  2.35047946e+02 },     
    { "Am236",              PoPs_genre_atom,   95, 141, 0,  2.36049579e+02 },
    { "Am237",              PoPs_genre_atom,   95, 142, 0,  2.37049996e+02 },     
    { "Am238",              PoPs_genre_atom,   95, 143, 0,  2.38051984324e+02 },  
    { "Am239",              PoPs_genre_atom,   95, 144, 0,  2.39053024479e+02 },  
    { "Am240",              PoPs_genre_atom,   95, 145, 0,  2.40055300179e+02 },
    { "Am241",              PoPs_genre_atom,   95, 146, 0,  2.41056829144e+02 },  
    { "Am242",              PoPs_genre_atom,   95, 147, 0,  Am242_Mass },         
    { "Am243",              PoPs_genre_atom,   95, 148, 0,  2.4306138108e+02 },   
    { "Am244",              PoPs_genre_atom,   95, 149, 0,  Am244_Mass },
    { "Am245",              PoPs_genre_atom,   95, 150, 0,  2.45066452114e+02 },  
    { "Am246",              PoPs_genre_atom,   95, 151, 0,  2.46069774619e+02 },  
    { "Am247",              PoPs_genre_atom,   95, 152, 0,  2.47072093e+02 },     
    { "Am248",              PoPs_genre_atom,   95, 153, 0,  2.48075752e+02 },
    { "Am249",              PoPs_genre_atom,   95, 154, 0,  2.4907848e+02 },      
    { "Cm_natural",         PoPs_genre_atom,   96,  -1, 0,  2.47e+02 },           
    { "Cm233",              PoPs_genre_atom,   96, 137, 0,  2.33050771232e+02 },  
    { "Cm234",              PoPs_genre_atom,   96, 138, 0,  2.34050159841e+02 },
    { "Cm235",              PoPs_genre_atom,   96, 139, 0,  2.35051434e+02 },     
    { "Cm236",              PoPs_genre_atom,   96, 140, 0,  2.36051413e+02 },     
    { "Cm237",              PoPs_genre_atom,   96, 141, 0,  2.37052901e+02 },     
    { "Cm238",              PoPs_genre_atom,   96, 142, 0,  2.38053028697e+02 },
    { "Cm239",              PoPs_genre_atom,   96, 143, 0,  2.39054957e+02 },     
    { "Cm240",              PoPs_genre_atom,   96, 144, 0,  2.40055529539e+02 },  
    { "Cm241",              PoPs_genre_atom,   96, 145, 0,  2.41057653001e+02 },  
    { "Cm242",              PoPs_genre_atom,   96, 146, 0,  2.42058835824e+02 },
    { "Cm243",              PoPs_genre_atom,   96, 147, 0,  2.43061389114e+02 },  
    { "Cm244",              PoPs_genre_atom,   96, 148, 0,  2.44062752578e+02 },  
    { "Cm245",              PoPs_genre_atom,   96, 149, 0,  2.45065491249e+02 },  
    { "Cm246",              PoPs_genre_atom,   96, 150, 0,  2.46067223662e+02 },
    { "Cm247",              PoPs_genre_atom,   96, 151, 0,  2.4707035354e+02 },   
    { "Cm248",              PoPs_genre_atom,   96, 152, 0,  2.48072348508e+02 },  
    { "Cm249",              PoPs_genre_atom,   96, 153, 0,  2.49075953413e+02 },  
    { "Cm250",              PoPs_genre_atom,   96, 154, 0,  2.50078356959e+02 },
    { "Cm251",              PoPs_genre_atom,   96, 155, 0,  2.51082284605e+02 },  
    { "Cm252",              PoPs_genre_atom,   96, 156, 0,  2.5208487e+02 },      
    { "Bk_natural",         PoPs_genre_atom,   97,  -1, 0,  2.47e+02 },           
    { "Bk235",              PoPs_genre_atom,   97, 138, 0,  2.3505658e+02 },
    { "Bk236",              PoPs_genre_atom,   97, 139, 0,  2.3605733e+02 },      
    { "Bk237",              PoPs_genre_atom,   97, 140, 0,  2.37057003e+02 },     
    { "Bk238",              PoPs_genre_atom,   97, 141, 0,  2.38058281e+02 },     
    { "Bk239",              PoPs_genre_atom,   97, 142, 0,  2.39058279e+02 },
    { "Bk240",              PoPs_genre_atom,   97, 143, 0,  2.40059759e+02 },     
    { "Bk241",              PoPs_genre_atom,   97, 144, 0,  2.4106023e+02 },      
    { "Bk242",              PoPs_genre_atom,   97, 145, 0,  2.42061981e+02 },     
    { "Bk243",              PoPs_genre_atom,   97, 146, 0,  2.43063007572e+02 },
    { "Bk244",              PoPs_genre_atom,   97, 147, 0,  2.44065180774e+02 },  
    { "Bk245",              PoPs_genre_atom,   97, 148, 0,  2.45066361616e+02 },  
    { "Bk246",              PoPs_genre_atom,   97, 149, 0,  2.46068672947e+02 },  
    { "Bk247",              PoPs_genre_atom,   97, 150, 0,  2.4707030708e+02 },
    { "Bk248",              PoPs_genre_atom,   97, 151, 0,  2.48073086e+02 },     
    { "Bk249",              PoPs_genre_atom,   97, 152, 0,  2.49074986657e+02 },  
    { "Bk250",              PoPs_genre_atom,   97, 153, 0,  2.5007831652e+02 },   
    { "Bk251",              PoPs_genre_atom,   97, 154, 0,  2.51080760172e+02 },
    { "Bk252",              PoPs_genre_atom,   97, 155, 0,  2.5208431e+02 },      
    { "Bk253",              PoPs_genre_atom,   97, 156, 0,  2.5308688e+02 },      
    { "Bk254",              PoPs_genre_atom,   97, 157, 0,  2.540906e+02 },       
    { "Cf_natural",         PoPs_genre_atom,   98,  -1, 0,  2.51e+02 },
    { "Cf237",              PoPs_genre_atom,   98, 139, 0,  2.3706207e+02 },      
    { "Cf238",              PoPs_genre_atom,   98, 140, 0,  2.3806141e+02 },      
    { "Cf239",              PoPs_genre_atom,   98, 141, 0,  2.39062422e+02 },     
    { "Cf240",              PoPs_genre_atom,   98, 142, 0,  2.40062302e+02 },
    { "Cf241",              PoPs_genre_atom,   98, 143, 0,  2.41063726e+02 },     
    { "Cf242",              PoPs_genre_atom,   98, 144, 0,  2.42063701552e+02 },  
    { "Cf243",              PoPs_genre_atom,   98, 145, 0,  2.43065427e+02 },     
    { "Cf244",              PoPs_genre_atom,   98, 146, 0,  2.44066000689e+02 },
    { "Cf245",              PoPs_genre_atom,   98, 147, 0,  2.45068048612e+02 },  
    { "Cf246",              PoPs_genre_atom,   98, 148, 0,  2.46068805309e+02 },  
    { "Cf247",              PoPs_genre_atom,   98, 149, 0,  2.47071000589e+02 },  
    { "Cf248",              PoPs_genre_atom,   98, 150, 0,  2.48072184861e+02 },
    { "Cf249",              PoPs_genre_atom,   98, 151, 0,  2.49074853537e+02 },  
    { "Cf250",              PoPs_genre_atom,   98, 152, 0,  2.50076406066e+02 },  
    { "Cf251",              PoPs_genre_atom,   98, 153, 0,  2.51079586788e+02 },  
    { "Cf252",              PoPs_genre_atom,   98, 154, 0,  2.52081625846e+02 },
    { "Cf253",              PoPs_genre_atom,   98, 155, 0,  2.53085133145e+02 },  
    { "Cf254",              PoPs_genre_atom,   98, 156, 0,  2.54087322909e+02 },  
    { "Cf255",              PoPs_genre_atom,   98, 157, 0,  2.55091046e+02 },     
    { "Cf256",              PoPs_genre_atom,   98, 158, 0,  2.5609344e+02 },
    { "Es_natural",         PoPs_genre_atom,   99,  -1, 0,  2.52e+02 },           
    { "Es120",              PoPs_genre_atom,   99,  21, 0,  1.175e+02 },          
    { "Es121",              PoPs_genre_atom,   99,  22, 0,  1.16546e+02 },        
    { "Es122",              PoPs_genre_atom,   99,  23, 0,  1.18544e+02 },
    { "Es125",              PoPs_genre_atom,   99,  26, 0,  1.175e+02 },          
    { "Es240",              PoPs_genre_atom,   99, 141, 0,  2.4006892e+02 },      
    { "Es241",              PoPs_genre_atom,   99, 142, 0,  2.41068538e+02 },     
    { "Es242",              PoPs_genre_atom,   99, 143, 0,  2.42069745e+02 },
    { "Es243",              PoPs_genre_atom,   99, 144, 0,  2.43069548e+02 },     
    { "Es244",              PoPs_genre_atom,   99, 145, 0,  2.44070883e+02 },     
    { "Es245",              PoPs_genre_atom,   99, 146, 0,  2.45071324e+02 },     
    { "Es246",              PoPs_genre_atom,   99, 147, 0,  2.46072896e+02 },
    { "Es247",              PoPs_genre_atom,   99, 148, 0,  2.47073656e+02 },     
    { "Es248",              PoPs_genre_atom,   99, 149, 0,  2.48075471e+02 },     
    { "Es249",              PoPs_genre_atom,   99, 150, 0,  2.49076411e+02 },     
    { "Es250",              PoPs_genre_atom,   99, 151, 0,  2.50078612e+02 },
    { "Es251",              PoPs_genre_atom,   99, 152, 0,  2.51079992142e+02 },  
    { "Es252",              PoPs_genre_atom,   99, 153, 0,  2.52082978512e+02 },  
    { "Es253",              PoPs_genre_atom,   99, 154, 0,  2.53084824697e+02 },  
    { "Es254",              PoPs_genre_atom,   99, 155, 0,  Es254_Mass },
    { "Es255",              PoPs_genre_atom,   99, 156, 0,  2.55090273122e+02 },  
    { "Es256",              PoPs_genre_atom,   99, 157, 0,  2.56093598e+02 },     
    { "Es257",              PoPs_genre_atom,   99, 158, 0,  2.57095979e+02 },     
    { "Es258",              PoPs_genre_atom,   99, 159, 0,  2.5809952e+02 },
    { "Fm_natural",         PoPs_genre_atom,  100,  -1, 0,  2.57e+02 },           
    { "Fm242",              PoPs_genre_atom,  100, 142, 0,  2.4207343e+02 },      
    { "Fm243",              PoPs_genre_atom,  100, 143, 0,  2.43074353e+02 },     
    { "Fm244",              PoPs_genre_atom,  100, 144, 0,  2.44074084e+02 },
    { "Fm245",              PoPs_genre_atom,  100, 145, 0,  2.45075385e+02 },     
    { "Fm246",              PoPs_genre_atom,  100, 146, 0,  2.46075299023e+02 },  
    { "Fm247",              PoPs_genre_atom,  100, 147, 0,  2.47076847e+02 },     
    { "Fm248",              PoPs_genre_atom,  100, 148, 0,  2.48077194714e+02 },
    { "Fm249",              PoPs_genre_atom,  100, 149, 0,  2.49079034e+02 },     
    { "Fm250",              PoPs_genre_atom,  100, 150, 0,  2.50079521264e+02 },  
    { "Fm251",              PoPs_genre_atom,  100, 151, 0,  2.51081575017e+02 },  
    { "Fm252",              PoPs_genre_atom,  100, 152, 0,  2.52082466855e+02 },
    { "Fm253",              PoPs_genre_atom,  100, 153, 0,  2.53085185236e+02 },  
    { "Fm254",              PoPs_genre_atom,  100, 154, 0,  2.5408685422e+02 },   
    { "Fm255",              PoPs_genre_atom,  100, 155, 0,  2.55089962202e+02 },  
    { "Fm256",              PoPs_genre_atom,  100, 156, 0,  2.56091773117e+02 },
    { "Fm257",              PoPs_genre_atom,  100, 157, 0,  2.57095104724e+02 },  
    { "Fm258",              PoPs_genre_atom,  100, 158, 0,  2.58097076e+02 },     
    { "Fm259",              PoPs_genre_atom,  100, 159, 0,  2.59100595e+02 },     
    { "Fm260",              PoPs_genre_atom,  100, 160, 0,  2.60102678e+02 },
    { "Md_natural",         PoPs_genre_atom,  101,  -1, 0,  2.58e+02 },           
    { "Md245",              PoPs_genre_atom,  101, 144, 0,  2.45080829e+02 },     
    { "Md246",              PoPs_genre_atom,  101, 145, 0,  2.46081886e+02 },     
    { "Md247",              PoPs_genre_atom,  101, 146, 0,  2.47081635e+02 },
    { "Md248",              PoPs_genre_atom,  101, 147, 0,  2.48082823e+02 },     
    { "Md249",              PoPs_genre_atom,  101, 148, 0,  2.49083013e+02 },     
    { "Md250",              PoPs_genre_atom,  101, 149, 0,  2.5008442e+02 },      
    { "Md251",              PoPs_genre_atom,  101, 150, 0,  2.51084839e+02 },
    { "Md252",              PoPs_genre_atom,  101, 151, 0,  2.5208656e+02 },      
    { "Md253",              PoPs_genre_atom,  101, 152, 0,  2.5308728e+02 },      
    { "Md254",              PoPs_genre_atom,  101, 153, 0,  2.54089656e+02 },     
    { "Md255",              PoPs_genre_atom,  101, 154, 0,  2.55091082705e+02 },
    { "Md256",              PoPs_genre_atom,  101, 155, 0,  2.56094059025e+02 },  
    { "Md257",              PoPs_genre_atom,  101, 156, 0,  2.57095541368e+02 },  
    { "Md258",              PoPs_genre_atom,  101, 157, 0,  2.58098431319e+02 },  
    { "Md259",              PoPs_genre_atom,  101, 158, 0,  2.59100509e+02 },
    { "Md260",              PoPs_genre_atom,  101, 159, 0,  2.60103652e+02 },     
    { "Md261",              PoPs_genre_atom,  101, 160, 0,  2.61105721e+02 },     
    { "Md262",              PoPs_genre_atom,  101, 161, 0,  2.62108865e+02 },     
    { "No_natural",         PoPs_genre_atom,  102,  -1, 0,  2.59e+02 },
    { "No248",              PoPs_genre_atom,  102, 146, 0,  2.48086596e+02 },     
    { "No249",              PoPs_genre_atom,  102, 147, 0,  2.49087833e+02 },     
    { "No250",              PoPs_genre_atom,  102, 148, 0,  2.5008751e+02 },      
    { "No251",              PoPs_genre_atom,  102, 149, 0,  2.51089012e+02 },
    { "No252",              PoPs_genre_atom,  102, 150, 0,  2.52088976521e+02 },  
    { "No253",              PoPs_genre_atom,  102, 151, 0,  2.53090678e+02 },     
    { "No254",              PoPs_genre_atom,  102, 152, 0,  2.54090955253e+02 },  
    { "No255",              PoPs_genre_atom,  102, 153, 0,  2.55093241131e+02 },
    { "No256",              PoPs_genre_atom,  102, 154, 0,  2.56094282666e+02 },  
    { "No257",              PoPs_genre_atom,  102, 155, 0,  2.5709687719e+02 },   
    { "No258",              PoPs_genre_atom,  102, 156, 0,  2.58098207e+02 },     
    { "No259",              PoPs_genre_atom,  102, 157, 0,  2.59101031e+02 },
    { "No260",              PoPs_genre_atom,  102, 158, 0,  2.60102643e+02 },     
    { "No261",              PoPs_genre_atom,  102, 159, 0,  2.61105749e+02 },     
    { "No262",              PoPs_genre_atom,  102, 160, 0,  2.62107301e+02 },     
    { "No263",              PoPs_genre_atom,  102, 161, 0,  2.63110552e+02 },
    { "No264",              PoPs_genre_atom,  102, 162, 0,  2.64112345e+02 },     
    { "Lr_natural",         PoPs_genre_atom,  103,  -1, 0,  2.6e+02 },            
    { "Lr251",              PoPs_genre_atom,  103, 148, 0,  2.5109436e+02 },      
    { "Lr252",              PoPs_genre_atom,  103, 149, 0,  2.52095371e+02 },
    { "Lr253",              PoPs_genre_atom,  103, 150, 0,  2.5309521e+02 },      
    { "Lr254",              PoPs_genre_atom,  103, 151, 0,  2.54096454e+02 },     
    { "Lr255",              PoPs_genre_atom,  103, 152, 0,  2.55096681e+02 },     
    { "Lr256",              PoPs_genre_atom,  103, 153, 0,  2.56098629e+02 },
    { "Lr257",              PoPs_genre_atom,  103, 154, 0,  2.57099555e+02 },     
    { "Lr258",              PoPs_genre_atom,  103, 155, 0,  2.58101814e+02 },     
    { "Lr259",              PoPs_genre_atom,  103, 156, 0,  2.59102901e+02 },     
    { "Lr260",              PoPs_genre_atom,  103, 157, 0,  2.60105504e+02 },
    { "Lr261",              PoPs_genre_atom,  103, 158, 0,  2.61106883e+02 },     
    { "Lr262",              PoPs_genre_atom,  103, 159, 0,  2.62109634e+02 },     
    { "Lr263",              PoPs_genre_atom,  103, 160, 0,  2.63111293e+02 },     
    { "Lr264",              PoPs_genre_atom,  103, 161, 0,  2.64114038e+02 },
    { "Lr265",              PoPs_genre_atom,  103, 162, 0,  2.65115839e+02 },     
    { "Lr266",              PoPs_genre_atom,  103, 163, 0,  2.66119305e+02 },     
    { "Rf_natural",         PoPs_genre_atom,  104,  -1, 0,  2.61e+02 },           
    { "Rf253",              PoPs_genre_atom,  104, 149, 0,  2.53100689e+02 },
    { "Rf254",              PoPs_genre_atom,  104, 150, 0,  2.54100184e+02 },     
    { "Rf255",              PoPs_genre_atom,  104, 151, 0,  2.5510134e+02 },      
    { "Rf256",              PoPs_genre_atom,  104, 152, 0,  2.56101166194e+02 },  
    { "Rf257",              PoPs_genre_atom,  104, 153, 0,  2.5710299e+02 },
    { "Rf258",              PoPs_genre_atom,  104, 154, 0,  2.58103489e+02 },     
    { "Rf259",              PoPs_genre_atom,  104, 155, 0,  2.59105637e+02 },     
    { "Rf260",              PoPs_genre_atom,  104, 156, 0,  2.6010644e+02 },      
    { "Rf261",              PoPs_genre_atom,  104, 157, 0,  2.61108766556e+02 },
    { "Rf262",              PoPs_genre_atom,  104, 158, 0,  2.62109925e+02 },     
    { "Rf263",              PoPs_genre_atom,  104, 159, 0,  2.63112547e+02 },     
    { "Rf264",              PoPs_genre_atom,  104, 160, 0,  2.64113985e+02 },     
    { "Rf265",              PoPs_genre_atom,  104, 161, 0,  2.65116704e+02 },
    { "Rf266",              PoPs_genre_atom,  104, 162, 0,  2.66117956e+02 },     
    { "Rf267",              PoPs_genre_atom,  104, 163, 0,  2.67121529e+02 },     
    { "Rf268",              PoPs_genre_atom,  104, 164, 0,  2.68123644e+02 },     
    { "Db_natural",         PoPs_genre_atom,  105,  -1, 0,  2.62e+02 },
    { "Db255",              PoPs_genre_atom,  105, 150, 0,  2.55107398e+02 },     
    { "Db256",              PoPs_genre_atom,  105, 151, 0,  2.56108127e+02 },     
    { "Db257",              PoPs_genre_atom,  105, 152, 0,  2.57107722e+02 },     
    { "Db258",              PoPs_genre_atom,  105, 153, 0,  2.58109231e+02 },
    { "Db259",              PoPs_genre_atom,  105, 154, 0,  2.5910961e+02 },      
    { "Db260",              PoPs_genre_atom,  105, 155, 0,  2.601113e+02 },       
    { "Db261",              PoPs_genre_atom,  105, 156, 0,  2.61112056e+02 },     
    { "Db262",              PoPs_genre_atom,  105, 157, 0,  2.62114084e+02 },
    { "Db263",              PoPs_genre_atom,  105, 158, 0,  2.63114988e+02 },     
    { "Db264",              PoPs_genre_atom,  105, 159, 0,  2.64117404e+02 },     
    { "Db265",              PoPs_genre_atom,  105, 160, 0,  2.65118601e+02 },     
    { "Db266",              PoPs_genre_atom,  105, 161, 0,  2.66121029e+02 },
    { "Db267",              PoPs_genre_atom,  105, 162, 0,  2.67122377e+02 },     
    { "Db268",              PoPs_genre_atom,  105, 163, 0,  2.68125445e+02 },     
    { "Db269",              PoPs_genre_atom,  105, 164, 0,  2.6912746e+02 },      
    { "Db270",              PoPs_genre_atom,  105, 165, 0,  2.70130712e+02 },
    { "Sg_natural",         PoPs_genre_atom,  106,  -1, 0,  2.63e+02 },           
    { "Sg258",              PoPs_genre_atom,  106, 152, 0,  2.58113168e+02 },     
    { "Sg259",              PoPs_genre_atom,  106, 153, 0,  2.591145e+02 },       
    { "Sg260",              PoPs_genre_atom,  106, 154, 0,  2.60114422071e+02 },
    { "Sg261",              PoPs_genre_atom,  106, 155, 0,  2.61116117e+02 },     
    { "Sg262",              PoPs_genre_atom,  106, 156, 0,  2.62116398e+02 },     
    { "Sg263",              PoPs_genre_atom,  106, 157, 0,  2.63118322e+02 },     
    { "Sg264",              PoPs_genre_atom,  106, 158, 0,  2.64118931e+02 },
    { "Sg265",              PoPs_genre_atom,  106, 159, 0,  2.65121114693e+02 },  
    { "Sg266",              PoPs_genre_atom,  106, 160, 0,  2.66122065e+02 },     
    { "Sg267",              PoPs_genre_atom,  106, 161, 0,  2.67124425e+02 },     
    { "Sg268",              PoPs_genre_atom,  106, 162, 0,  2.68125606e+02 },
    { "Sg269",              PoPs_genre_atom,  106, 163, 0,  2.69128755e+02 },     
    { "Sg270",              PoPs_genre_atom,  106, 164, 0,  2.70130329e+02 },     
    { "Sg271",              PoPs_genre_atom,  106, 165, 0,  2.71133472e+02 },     
    { "Sg272",              PoPs_genre_atom,  106, 166, 0,  2.72135158e+02 },
    { "Sg273",              PoPs_genre_atom,  106, 167, 0,  2.7313822e+02 },      
    { "Bh260",              PoPs_genre_atom,  107, 153, 0,  2.6012197e+02 },      
    { "Bh261",              PoPs_genre_atom,  107, 154, 0,  2.61121664e+02 },     
    { "Bh262",              PoPs_genre_atom,  107, 155, 0,  2.62122892e+02 },
    { "Bh263",              PoPs_genre_atom,  107, 156, 0,  2.63123035e+02 },     
    { "Bh264",              PoPs_genre_atom,  107, 157, 0,  2.64124604e+02 },     
    { "Bh265",              PoPs_genre_atom,  107, 158, 0,  2.65125147e+02 },     
    { "Bh266",              PoPs_genre_atom,  107, 159, 0,  2.66126942e+02 },
    { "Bh267",              PoPs_genre_atom,  107, 160, 0,  2.6712765e+02 },      
    { "Bh268",              PoPs_genre_atom,  107, 161, 0,  2.68129755e+02 },     
    { "Bh269",              PoPs_genre_atom,  107, 162, 0,  2.69130694e+02 },     
    { "Bh270",              PoPs_genre_atom,  107, 163, 0,  2.70133616e+02 },
    { "Bh271",              PoPs_genre_atom,  107, 164, 0,  2.71135179e+02 },     
    { "Bh272",              PoPs_genre_atom,  107, 165, 0,  2.72138032e+02 },     
    { "Bh273",              PoPs_genre_atom,  107, 166, 0,  2.73139618e+02 },     
    { "Bh274",              PoPs_genre_atom,  107, 167, 0,  2.7414244e+02 },
    { "Bh275",              PoPs_genre_atom,  107, 168, 0,  2.7514425e+02 },      
    { "Hs263",              PoPs_genre_atom,  108, 155, 0,  2.63128558e+02 },     
    { "Hs264",              PoPs_genre_atom,  108, 156, 0,  2.64128394885e+02 },  
    { "Hs265",              PoPs_genre_atom,  108, 157, 0,  2.65130085e+02 },
    { "Hs266",              PoPs_genre_atom,  108, 158, 0,  2.66130097e+02 },     
    { "Hs267",              PoPs_genre_atom,  108, 159, 0,  2.67131789e+02 },     
    { "Hs268",              PoPs_genre_atom,  108, 160, 0,  2.68132162e+02 },     
    { "Hs269",              PoPs_genre_atom,  108, 161, 0,  2.69134056e+02 },
    { "Hs270",              PoPs_genre_atom,  108, 162, 0,  2.7013465e+02 },      
    { "Hs271",              PoPs_genre_atom,  108, 163, 0,  2.71137657e+02 },     
    { "Hs272",              PoPs_genre_atom,  108, 164, 0,  2.72139052e+02 },     
    { "Hs273",              PoPs_genre_atom,  108, 165, 0,  2.73141986e+02 },
    { "Hs274",              PoPs_genre_atom,  108, 166, 0,  2.74143131e+02 },     
    { "Hs275",              PoPs_genre_atom,  108, 167, 0,  2.75145952e+02 },     
    { "Hs276",              PoPs_genre_atom,  108, 168, 0,  2.76147208e+02 },     
    { "Hs277",              PoPs_genre_atom,  108, 169, 0,  2.77149841e+02 },
    { "Mt265",              PoPs_genre_atom,  109, 156, 0,  2.65136151e+02 },     
    { "Mt266",              PoPs_genre_atom,  109, 157, 0,  2.66137299e+02 },     
    { "Mt267",              PoPs_genre_atom,  109, 158, 0,  2.67137307e+02 },     
    { "Mt268",              PoPs_genre_atom,  109, 159, 0,  2.68138728e+02 },
    { "Mt269",              PoPs_genre_atom,  109, 160, 0,  2.69139055e+02 },     
    { "Mt270",              PoPs_genre_atom,  109, 161, 0,  2.70140657e+02 },     
    { "Mt271",              PoPs_genre_atom,  109, 162, 0,  2.71141139e+02 },     
    { "Mt272",              PoPs_genre_atom,  109, 163, 0,  2.72143738e+02 },
    { "Mt273",              PoPs_genre_atom,  109, 164, 0,  2.73144913e+02 },     
    { "Mt274",              PoPs_genre_atom,  109, 165, 0,  2.74147492e+02 },     
    { "Mt275",              PoPs_genre_atom,  109, 166, 0,  2.75148647e+02 },     
    { "Mt276",              PoPs_genre_atom,  109, 167, 0,  2.76151156e+02 },
    { "Mt277",              PoPs_genre_atom,  109, 168, 0,  2.7715242e+02 },      
    { "Mt278",              PoPs_genre_atom,  109, 169, 0,  2.78154812e+02 },     
    { "Mt279",              PoPs_genre_atom,  109, 170, 0,  2.79156193e+02 },     
    { "Ds267",              PoPs_genre_atom,  110, 157, 0,  2.67144341e+02 },
    { "Ds268",              PoPs_genre_atom,  110, 158, 0,  2.68143795e+02 },     
    { "Ds269",              PoPs_genre_atom,  110, 159, 0,  2.69145124e+02 },     
    { "Ds270",              PoPs_genre_atom,  110, 160, 0,  2.7014472e+02 },      
    { "Ds271",              PoPs_genre_atom,  110, 161, 0,  2.71146062e+02 },
    { "Ds272",              PoPs_genre_atom,  110, 162, 0,  2.72146317e+02 },     
    { "Ds273",              PoPs_genre_atom,  110, 163, 0,  2.73148863e+02 },     
    { "Ds274",              PoPs_genre_atom,  110, 164, 0,  2.74149492e+02 },     
    { "Ds275",              PoPs_genre_atom,  110, 165, 0,  2.75152176e+02 },
    { "Ds276",              PoPs_genre_atom,  110, 166, 0,  2.76153034e+02 },     
    { "Ds277",              PoPs_genre_atom,  110, 167, 0,  2.77155647e+02 },     
    { "Ds278",              PoPs_genre_atom,  110, 168, 0,  2.78156469e+02 },     
    { "Ds279",              PoPs_genre_atom,  110, 169, 0,  2.79158861e+02 },
    { "Ds280",              PoPs_genre_atom,  110, 170, 0,  2.80159795e+02 },     
    { "Ds281",              PoPs_genre_atom,  110, 171, 0,  2.81162061e+02 },     
    { "Rg272",              PoPs_genre_atom,  111, 161, 0,  2.72153615e+02 },     
    { "Rg273",              PoPs_genre_atom,  111, 162, 0,  2.73153682e+02 },
    { "Rg274",              PoPs_genre_atom,  111, 163, 0,  2.74155713e+02 },     
    { "Rg275",              PoPs_genre_atom,  111, 164, 0,  2.75156142e+02 },     
    { "Rg276",              PoPs_genre_atom,  111, 165, 0,  2.76158493e+02 },     
    { "Rg277",              PoPs_genre_atom,  111, 166, 0,  2.77159519e+02 },
    { "Rg278",              PoPs_genre_atom,  111, 167, 0,  2.78161604e+02 },     
    { "Rg279",              PoPs_genre_atom,  111, 168, 0,  2.79162468e+02 },     
    { "Rg280",              PoPs_genre_atom,  111, 169, 0,  2.80164473e+02 },     
    { "Rg281",              PoPs_genre_atom,  111, 170, 0,  2.81165372e+02 },
    { "Rg282",              PoPs_genre_atom,  111, 171, 0,  2.82167486e+02 },     
    { "Rg283",              PoPs_genre_atom,  111, 172, 0,  2.83168415e+02 },     
    { "Cn277",              PoPs_genre_atom,  112, 165, 0,  2.77163943e+02 },     
    { "Cn278",              PoPs_genre_atom,  112, 166, 0,  2.78164312e+02 },
    { "Cn279",              PoPs_genre_atom,  112, 167, 0,  2.79166546e+02 },     
    { "Cn280",              PoPs_genre_atom,  112, 168, 0,  2.80167039e+02 },     
    { "Cn281",              PoPs_genre_atom,  112, 169, 0,  2.81169286e+02 },     
    { "Cn282",              PoPs_genre_atom,  112, 170, 0,  2.82169765e+02 },
    { "Cn283",              PoPs_genre_atom,  112, 171, 0,  2.83171792e+02 },     
    { "Cn284",              PoPs_genre_atom,  112, 172, 0,  2.84172384e+02 },     
    { "Cn285",              PoPs_genre_atom,  112, 173, 0,  2.85174105e+02 },     
    { "Uut283",             PoPs_genre_atom,  113, 170, 0,  2.83176451e+02 },
    { "Uut284",             PoPs_genre_atom,  113, 171, 0,  2.8417808e+02 },      
    { "Uut285",             PoPs_genre_atom,  113, 172, 0,  2.85178732e+02 },     
    { "Uut286",             PoPs_genre_atom,  113, 173, 0,  2.86180481e+02 },     
    { "Uut287",             PoPs_genre_atom,  113, 174, 0,  2.87181045e+02 },
    { "Fl285",              PoPs_genre_atom,  114, 171, 0,  2.85183698e+02 },     
    { "Fl286",              PoPs_genre_atom,  114, 172, 0,  2.86183855e+02 },     
    { "Fl287",              PoPs_genre_atom,  114, 173, 0,  2.87185599e+02 },     
    { "Fl288",              PoPs_genre_atom,  114, 174, 0,  2.88185689e+02 },
    { "Fl289",              PoPs_genre_atom,  114, 175, 0,  2.89187279e+02 },     
    { "Uup287",             PoPs_genre_atom,  115, 172, 0,  2.87191186e+02 },     
    { "Uup288",             PoPs_genre_atom,  115, 173, 0,  2.88192492e+02 },     
    { "Uup289",             PoPs_genre_atom,  115, 174, 0,  2.89192715e+02 },
    { "Uup290",             PoPs_genre_atom,  115, 175, 0,  2.90194141e+02 },     
    { "Uup291",             PoPs_genre_atom,  115, 176, 0,  2.91194384e+02 },     
    { "Lv289",              PoPs_genre_atom,  116, 173, 0,  2.89198862e+02 },     
    { "Lv290",              PoPs_genre_atom,  116, 174, 0,  2.9019859e+02 },
    { "Lv291",              PoPs_genre_atom,  116, 175, 0,  2.91200011e+02 },     
    { "Lv292",              PoPs_genre_atom,  116, 176, 0,  2.92199786e+02 },     
    { "Uus291",             PoPs_genre_atom,  117, 174, 0,  2.91206564e+02 },     
    { "Uus292",             PoPs_genre_atom,  117, 175, 0,  2.92207549e+02 },
    { "Uuo293",             PoPs_genre_atom,  118, 175, 0,  2.9321467e+02 } };

#if defined __cplusplus
}
#endif

