#include "opname.h"

#include <stdio.h>

#define NARG 0
#define BARG 1
#define SARG 2
#define DARG 3

#define NHL 0
#define SHL 1
#define THL 2
#define IHL 3

struct op {
  const char *fmt;
  int argtype;
  int hltype;
  int shl0;
  int shl1;
};

static struct op tab_norm[] = {
  {"NOP"              , NARG, NHL, 0, 0},
  {"LD BC,%04xH"      , DARG, NHL, 0, 0},
  {"LD (BC),A"        , NARG, NHL, 0, 0},
  {"INC BC"           , NARG, NHL, 0, 0},
  {"INC B"            , NARG, NHL, 0, 0},
  {"DEC B"            , NARG, NHL, 0, 0},
  {"LD B,%02xH"       , BARG, NHL, 0, 0},
  {"RLCA"             , NARG, NHL, 0, 0},
  {"EX AF,AF'"        , NARG, NHL, 0, 0},
  {"ADD %s,BC"        , NARG, THL, 0, 0},
  {"LD A,(BC)"        , NARG, NHL, 0, 0},
  {"DEC BC"           , NARG, NHL, 0, 0},
  {"INC C"            , NARG, NHL, 0, 0},
  {"DEC C"            , NARG, NHL, 0, 0},
  {"LD C,%02xH"       , BARG, NHL, 0, 0},
  {"RRCA"             , NARG, NHL, 0, 0},
  {"DJNZ %+d"         , SARG, NHL, 0, 0},
  {"LD DE,%04xH"      , DARG, NHL, 0, 0},
  {"LD (DE),A"        , NARG, NHL, 0, 0},
  {"INC DE"           , NARG, NHL, 0, 0},
  {"INC D"            , NARG, NHL, 0, 0},
  {"DEC D"            , NARG, NHL, 0, 0},
  {"LD D,%02xH"       , BARG, NHL, 0, 0},
  {"RLA"              , NARG, NHL, 0, 0},
  {"JR %+d"           , SARG, NHL, 0, 0},
  {"ADD %s,DE"        , NARG, THL, 0, 0},
  {"LD A,(DE)"        , NARG, NHL, 0, 0},
  {"DEC DE"           , NARG, NHL, 0, 0},
  {"INC E"            , NARG, NHL, 0, 0},
  {"DEC E"            , NARG, NHL, 0, 0},
  {"LD E,%02xH"       , BARG, NHL, 0, 0},
  {"RRA"              , NARG, NHL, 0, 0},
  {"JR NZ,%+d"        , SARG, NHL, 0, 0},
  {"LD %s,%04xH"      , DARG, THL, 0, 0},
  {"LD (%04xH),%s"    , DARG, THL, 1, 0},
  {"INC %s"           , NARG, THL, 0, 0},
  {"INC %s"           , NARG, SHL, 1, 0},
  {"DEC %s"           , NARG, SHL, 1, 0},
  {"LD %s,%02xH"      , BARG, SHL, 1, 0},
  {"DAA"              , NARG, NHL, 0, 0},
  {"JR Z,%+d"         , SARG, NHL, 0, 0},
  {"ADD %s,%s"        , NARG, THL, 2, 0},
  {"LD %s,(%04xH)"    , DARG, THL, 0, 0},
  {"DEC %s"           , NARG, THL, 0, 0},
  {"INC %s"           , NARG, SHL, 2, 0},
  {"DEC %s"           , NARG, SHL, 2, 0},
  {"LD %s,%02xH"      , BARG, SHL, 2, 0},
  {"CPL"              , NARG, NHL, 0, 0},
  {"JR NC,%+d"        , SARG, NHL, 0, 0},
  {"LD SP,%04xH"      , DARG, NHL, 0, 0},
  {"LD (%04xH),A"     , DARG, NHL, 0, 0},
  {"INC SP"           , NARG, NHL, 0, 0},
  {"INC (%s)"         , NARG, IHL, 0, 0},
  {"DEC (%s)"         , NARG, IHL, 0, 0},
  {"LD (%s),%02xH"    , BARG, IHL, 0, 0},
  {"SCF"              , NARG, NHL, 0, 0},
  {"JR C,%+d"         , SARG, NHL, 0, 0},
  {"ADD %s,SP"        , NARG, THL, 0, 0},
  {"LD A,(%04xH)"     , DARG, NHL, 0, 0},
  {"DEC SP"           , NARG, NHL, 0, 0},
  {"INC A"            , NARG, NHL, 0, 0},
  {"DEC A"            , NARG, NHL, 0, 0},
  {"LD A,%02xH"       , BARG, NHL, 0, 0},
  {"CCF"              , NARG, NHL, 0, 0},
  {"LD B,B"           , NARG, NHL, 0, 0},
  {"LD B,C"           , NARG, NHL, 0, 0},
  {"LD B,D"           , NARG, NHL, 0, 0},
  {"LD B,E"           , NARG, NHL, 0, 0},
  {"LD B,%s"          , NARG, SHL, 1, 0},
  {"LD B,%s"          , NARG, SHL, 2, 0},
  {"LD B,(%s)"        , NARG, IHL, 0, 0},
  {"LD B,A"           , NARG, NHL, 0, 0},
  {"LD C,B"           , NARG, NHL, 0, 0},
  {"LD C,C"           , NARG, NHL, 0, 0},
  {"LD C,D"           , NARG, NHL, 0, 0},
  {"LD C,E"           , NARG, NHL, 0, 0},
  {"LD C,%s"          , NARG, SHL, 1, 0},
  {"LD C,%s"          , NARG, SHL, 2, 0},
  {"LD C,(%s)"        , NARG, IHL, 0, 0},
  {"LD C,A"           , NARG, NHL, 0, 0},
  {"LD D,B"           , NARG, NHL, 0, 0},
  {"LD D,C"           , NARG, NHL, 0, 0},
  {"LD D,D"           , NARG, NHL, 0, 0},
  {"LD D,E"           , NARG, NHL, 0, 0},
  {"LD D,%s"          , NARG, SHL, 1, 0},
  {"LD D,%s"          , NARG, SHL, 2, 0},
  {"LD D,(%s)"        , NARG, IHL, 0, 0},
  {"LD D,A"           , NARG, NHL, 0, 0},
  {"LD E,B"           , NARG, NHL, 0, 0},
  {"LD E,C"           , NARG, NHL, 0, 0},
  {"LD E,D"           , NARG, NHL, 0, 0},
  {"LD E,E"           , NARG, NHL, 0, 0},
  {"LD E,%s"          , NARG, SHL, 1, 0},
  {"LD E,%s"          , NARG, SHL, 2, 0},
  {"LD E,(%s)"        , NARG, IHL, 0, 0},
  {"LD E,A"           , NARG, NHL, 0, 0},
  {"LD %s,B"          , NARG, SHL, 1, 0},
  {"LD %s,C"          , NARG, SHL, 1, 0},
  {"LD %s,D"          , NARG, SHL, 1, 0},
  {"LD %s,E"          , NARG, SHL, 1, 0},
  {"LD %s,%s"         , NARG, SHL, 1, 1},
  {"LD %s,%s"         , NARG, SHL, 1, 2},
  {"LD H,(%s)"        , NARG, IHL, 0, 0},
  {"LD %s,A"          , NARG, SHL, 1, 0},
  {"LD %s,B"          , NARG, SHL, 2, 0},
  {"LD %s,C"          , NARG, SHL, 2, 0},
  {"LD %s,D"          , NARG, SHL, 2, 0},
  {"LD %s,E"          , NARG, SHL, 2, 0},
  {"LD %s,%s"         , NARG, SHL, 2, 1},
  {"LD %s,%s"         , NARG, SHL, 2, 2},
  {"LD L,(%s)"        , NARG, IHL, 0, 0},
  {"LD %s,A"          , NARG, SHL, 2, 0},
  {"LD (%s),B"        , NARG, IHL, 0, 0},
  {"LD (%s),C"        , NARG, IHL, 0, 0},
  {"LD (%s),D"        , NARG, IHL, 0, 0},
  {"LD (%s),E"        , NARG, IHL, 0, 0},
  {"LD (%s),H"        , NARG, IHL, 0, 0},
  {"LD (%s),L"        , NARG, IHL, 0, 0},
  {"HALT"             , NARG, NHL, 0, 0},
  {"LD (%s),A"        , NARG, IHL, 0, 0},
  {"LD A,B"           , NARG, NHL, 0, 0},
  {"LD A,C"           , NARG, NHL, 0, 0},
  {"LD A,D"           , NARG, NHL, 0, 0},
  {"LD A,E"           , NARG, NHL, 0, 0},
  {"LD A,%s"          , NARG, SHL, 1, 0},
  {"LD A,%s"          , NARG, SHL, 2, 0},
  {"LD A,(%s)"        , NARG, IHL, 0, 0},
  {"LD A,A"           , NARG, NHL, 0, 0},
  {"ADD A,B"          , NARG, NHL, 0, 0},
  {"ADD A,C"          , NARG, NHL, 0, 0},
  {"ADD A,D"          , NARG, NHL, 0, 0},
  {"ADD A,E"          , NARG, NHL, 0, 0},
  {"ADD A,%s"         , NARG, SHL, 1, 0},
  {"ADD A,%s"         , NARG, SHL, 2, 0},
  {"ADD A,(%s)"       , NARG, IHL, 0, 0},
  {"ADD A,A"          , NARG, NHL, 0, 0},
  {"ADC A,B"          , NARG, NHL, 0, 0},
  {"ADC A,C"          , NARG, NHL, 0, 0},
  {"ADC A,D"          , NARG, NHL, 0, 0},
  {"ADC A,E"          , NARG, NHL, 0, 0},
  {"ADC A,%s"         , NARG, SHL, 1, 0},
  {"ADC A,%s"         , NARG, SHL, 2, 0},
  {"ADC A,(%s)"       , NARG, IHL, 0, 0},
  {"ADC A,A"          , NARG, NHL, 0, 0},
  {"SUB B"            , NARG, NHL, 0, 0},
  {"SUB C"            , NARG, NHL, 0, 0},
  {"SUB D"            , NARG, NHL, 0, 0},
  {"SUB E"            , NARG, NHL, 0, 0},
  {"SUB %s"           , NARG, SHL, 1, 0},
  {"SUB %s"           , NARG, SHL, 2, 0},
  {"SUB (%s)"         , NARG, IHL, 0, 0},
  {"SUB A"            , NARG, NHL, 0, 0},
  {"SBC A,B"          , NARG, NHL, 0, 0},
  {"SBC A,C"          , NARG, NHL, 0, 0},
  {"SBC A,D"          , NARG, NHL, 0, 0},
  {"SBC A,E"          , NARG, NHL, 0, 0},
  {"SBC A,%s"         , NARG, SHL, 1, 0},
  {"SBC A,%s"         , NARG, SHL, 2, 0},
  {"SBC A,(%s)"       , NARG, IHL, 0, 0},
  {"SBC A,A"          , NARG, NHL, 0, 0},
  {"AND B"            , NARG, NHL, 0, 0},
  {"AND C"            , NARG, NHL, 0, 0},
  {"AND D"            , NARG, NHL, 0, 0},
  {"AND E"            , NARG, NHL, 0, 0},
  {"AND %s"           , NARG, SHL, 1, 0},
  {"AND %s"           , NARG, SHL, 2, 0},
  {"AND (%s)"         , NARG, IHL, 0, 0},
  {"AND A"            , NARG, NHL, 0, 0},
  {"XOR B"            , NARG, NHL, 0, 0},
  {"XOR C"            , NARG, NHL, 0, 0},
  {"XOR D"            , NARG, NHL, 0, 0},
  {"XOR E"            , NARG, NHL, 0, 0},
  {"XOR %s"           , NARG, SHL, 1, 0},
  {"XOR %s"           , NARG, SHL, 2, 0},
  {"XOR (%s)"         , NARG, IHL, 0, 0},
  {"XOR A"            , NARG, NHL, 0, 0},
  {"OR B"             , NARG, NHL, 0, 0},
  {"OR C"             , NARG, NHL, 0, 0},
  {"OR D"             , NARG, NHL, 0, 0},
  {"OR E"             , NARG, NHL, 0, 0},
  {"OR %s"            , NARG, SHL, 1, 0},
  {"OR %s"            , NARG, SHL, 2, 0},
  {"OR (%s)"          , NARG, IHL, 0, 0},
  {"OR A"             , NARG, NHL, 0, 0},
  {"CP B"             , NARG, NHL, 0, 0},
  {"CP C"             , NARG, NHL, 0, 0},
  {"CP D"             , NARG, NHL, 0, 0},
  {"CP E"             , NARG, NHL, 0, 0},
  {"CP %s"            , NARG, SHL, 1, 0},
  {"CP %s"            , NARG, SHL, 2, 0},
  {"CP (%s)"          , NARG, IHL, 0, 0},
  {"CP A"             , NARG, NHL, 0, 0},
  {"RET NZ"           , NARG, NHL, 0, 0},
  {"POP BC"           , NARG, NHL, 0, 0},
  {"JP NZ,%04xH"      , DARG, NHL, 0, 0},
  {"JP %04xH"         , DARG, NHL, 0, 0},
  {"CALL NZ,%04xH"    , DARG, NHL, 0, 0},
  {"PUSH BC"          , NARG, NHL, 0, 0},
  {"ADD A,%02xH"      , BARG, NHL, 0, 0},
  {"RST 00"           , NARG, NHL, 0, 0},
  {"RET Z"            , NARG, NHL, 0, 0},
  {"RET"              , NARG, NHL, 0, 0},
  {"JP Z,%04xH"       , DARG, NHL, 0, 0},
  {"SPECIAL CB"       , NARG, NHL, 0, 0},
  {"CALL Z,%04xH"     , DARG, NHL, 0, 0},
  {"CALL %04xH"       , DARG, NHL, 0, 0},
  {"ADC A,%02xH"      , BARG, NHL, 0, 0},
  {"RST 08"           , NARG, NHL, 0, 0},
  {"RET NC"           , NARG, NHL, 0, 0},
  {"POP DE"           , NARG, NHL, 0, 0},
  {"JP NC,%04xH"      , DARG, NHL, 0, 0},
  {"OUT (%02xH),A"    , BARG, NHL, 0, 0},
  {"CALL NC,%04xH"    , DARG, NHL, 0, 0},
  {"PUSH DE"          , NARG, NHL, 0, 0},
  {"SUB %02xH"        , BARG, NHL, 0, 0},
  {"RST 10"           , NARG, NHL, 0, 0},
  {"RET C"            , NARG, NHL, 0, 0},
  {"EXX"              , NARG, NHL, 0, 0},
  {"JP C,%04xH"       , DARG, NHL, 0, 0},
  {"IN A,(%02xH)"     , BARG, NHL, 0, 0},
  {"CALL C,%04xH"     , DARG, NHL, 0, 0},
  {"SPECIAL DD"       , NARG, NHL, 0, 0},
  {"SBC A,%02xH"      , BARG, NHL, 0, 0},
  {"RST 18"           , NARG, NHL, 0, 0},
  {"RET PO"           , NARG, NHL, 0, 0},
  {"POP %s"           , NARG, THL, 0, 0},
  {"JP PO,%04xH"      , DARG, NHL, 0, 0},
  {"EX (SP),%s"       , NARG, THL, 1, 0},
  {"CALL PO,%04xH"    , DARG, NHL, 0, 0},
  {"PUSH %s"          , NARG, THL, 0, 0},
  {"AND %02xH"        , BARG, NHL, 0, 0},
  {"RST 20"           , NARG, NHL, 0, 0},
  {"RET PE"           , NARG, NHL, 0, 0},
  {"JP %s"            , NARG, THL, 0, 0},
  {"JP PE,%04xH"      , DARG, NHL, 0, 0},
  {"EX DE,HL"         , NARG, NHL, 0, 0},
  {"CALL PE,%04xH"    , DARG, NHL, 0, 0},
  {"SPECIAL ED"       , NARG, NHL, 0, 0},
  {"XOR %02xH"        , BARG, NHL, 0, 0},
  {"RST 28"           , NARG, NHL, 0, 0},
  {"RET P"            , NARG, NHL, 0, 0},
  {"POP AF"           , NARG, NHL, 0, 0},
  {"JP P,%04xH"       , DARG, NHL, 0, 0},
  {"DI"               , NARG, NHL, 0, 0},
  {"CALL P,%04xH"     , DARG, NHL, 0, 0},
  {"PUSH AF"          , NARG, NHL, 0, 0},
  {"OR %02xH"         , BARG, NHL, 0, 0},
  {"RST 30"           , NARG, NHL, 0, 0},
  {"RET M"            , NARG, NHL, 0, 0},
  {"LD SP,%s"         , NARG, THL, 1, 0},
  {"JP M,%04xH"       , DARG, NHL, 0, 0},
  {"EI"               , NARG, NHL, 0, 0},
  {"CALL M,%04xH"     , DARG, NHL, 0, 0},
  {"SPECIAL FD"       , NARG, NHL, 0, 0},
  {"CP %02xH"         , BARG, NHL, 0, 0},
  {"RST 38"           , NARG, NHL, 0, 0}
};

static struct op tab_ed[] = {
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"IN B,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),B"        , NARG, NHL, 0, 0},
  {"SBC HL,BC"        , NARG, NHL, 0, 0},
  {"LD (%04xH),BC"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETN"             , NARG, NHL, 0, 0},
  {"IM 0"             , NARG, NHL, 0, 0},
  {"LD I,A"           , NARG, NHL, 0, 0},
  {"IN C,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),C"        , NARG, NHL, 0, 0},
  {"ADC HL,BC"        , NARG, NHL, 0, 0},
  {"LD BC,(%04xH)"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETI"             , NARG, NHL, 0, 0},
  {"IM 0"             , NARG, NHL, 0, 0},
  {"LD R,A"           , NARG, NHL, 0, 0},
  {"IN D,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),D"        , NARG, NHL, 0, 0},
  {"SBC HL,DE"        , NARG, NHL, 0, 0},
  {"LD (%04xH),DE"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETN"             , NARG, NHL, 0, 0},
  {"IM 1"             , NARG, NHL, 0, 0},
  {"LD A,I"           , NARG, NHL, 0, 0},
  {"IN E,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),E"        , NARG, NHL, 0, 0},
  {"ADC HL,DE"        , NARG, NHL, 0, 0},
  {"LD DE,(%04xH)"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETN"             , NARG, NHL, 0, 0},
  {"IM 2"             , NARG, NHL, 0, 0},
  {"LD A,R"           , NARG, NHL, 0, 0},
  {"IN H,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),H"        , NARG, NHL, 0, 0},
  {"SBC HL,HL"        , NARG, NHL, 0, 0},
  {"LD (%04xH),HL"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETN"             , NARG, NHL, 0, 0},
  {"IM 0"             , NARG, NHL, 0, 0},
  {"RRD"              , NARG, NHL, 0, 0},
  {"IN L,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),L"        , NARG, NHL, 0, 0},
  {"ADC HL,HL"        , NARG, NHL, 0, 0},
  {"LD HL,(%04xH)"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETN"             , NARG, NHL, 0, 0},
  {"IM 0"             , NARG, NHL, 0, 0},
  {"RLD"              , NARG, NHL, 0, 0},
  {"IN F,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),F"        , NARG, NHL, 0, 0},
  {"SBC HL,SP"        , NARG, NHL, 0, 0},
  {"LD (%04xH),SP"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETN"             , NARG, NHL, 0, 0},
  {"IM 1"             , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"IN A,(C)"         , NARG, NHL, 0, 0},
  {"OUT (C),A"        , NARG, NHL, 0, 0},
  {"ADC HL,SP"        , NARG, NHL, 0, 0},
  {"LD SP,(%04xH)"    , DARG, NHL, 0, 0},
  {"NEG"              , NARG, NHL, 0, 0},
  {"RETN"             , NARG, NHL, 0, 0},
  {"IM 2"             , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"LDI"              , NARG, NHL, 0, 0},
  {"CPI"              , NARG, NHL, 0, 0},
  {"INI"              , NARG, NHL, 0, 0},
  {"OUTI"             , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"LDD"              , NARG, NHL, 0, 0},
  {"CPD"              , NARG, NHL, 0, 0},
  {"IND"              , NARG, NHL, 0, 0},
  {"OUTD"             , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"LDIR"             , NARG, NHL, 0, 0},
  {"CPIR"             , NARG, NHL, 0, 0},
  {"INIR"             , NARG, NHL, 0, 0},
  {"OTIR"             , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"LDDR"             , NARG, NHL, 0, 0},
  {"CPDR"             , NARG, NHL, 0, 0},
  {"INDR"             , NARG, NHL, 0, 0},
  {"OTDR"             , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0},
  {"ILL ED"           , NARG, NHL, 0, 0}
};

static struct op tab_cb[] = {
  {"RLC B"            , NARG, NHL, 0, 0},
  {"RLC C"            , NARG, NHL, 0, 0},
  {"RLC D"            , NARG, NHL, 0, 0},
  {"RLC E"            , NARG, NHL, 0, 0},
  {"RLC H"            , NARG, NHL, 0, 0},
  {"RLC L"            , NARG, NHL, 0, 0},
  {"RLC (%s)"         , NARG, IHL, 0, 0},
  {"RLC A"            , NARG, NHL, 0, 0},
  {"RRC B"            , NARG, NHL, 0, 0},
  {"RRC C"            , NARG, NHL, 0, 0},
  {"RRC D"            , NARG, NHL, 0, 0},
  {"RRC E"            , NARG, NHL, 0, 0},
  {"RRC H"            , NARG, NHL, 0, 0},
  {"RRC L"            , NARG, NHL, 0, 0},
  {"RRC (%s)"         , NARG, IHL, 0, 0},
  {"RRC A"            , NARG, NHL, 0, 0},
  {"RL B"             , NARG, NHL, 0, 0},
  {"RL C"             , NARG, NHL, 0, 0},
  {"RL D"             , NARG, NHL, 0, 0},
  {"RL E"             , NARG, NHL, 0, 0},
  {"RL H"             , NARG, NHL, 0, 0},
  {"RL L"             , NARG, NHL, 0, 0},
  {"RL (%s)"          , NARG, IHL, 0, 0},
  {"RL A"             , NARG, NHL, 0, 0},
  {"RR B"             , NARG, NHL, 0, 0},
  {"RR C"             , NARG, NHL, 0, 0},
  {"RR D"             , NARG, NHL, 0, 0},
  {"RR E"             , NARG, NHL, 0, 0},
  {"RR H"             , NARG, NHL, 0, 0},
  {"RR L"             , NARG, NHL, 0, 0},
  {"RR (%s)"          , NARG, IHL, 0, 0},
  {"RR A"             , NARG, NHL, 0, 0},
  {"SLA B"            , NARG, NHL, 0, 0},
  {"SLA C"            , NARG, NHL, 0, 0},
  {"SLA D"            , NARG, NHL, 0, 0},
  {"SLA E"            , NARG, NHL, 0, 0},
  {"SLA H"            , NARG, NHL, 0, 0},
  {"SLA L"            , NARG, NHL, 0, 0},
  {"SLA (%s)"         , NARG, IHL, 0, 0},
  {"SLA A"            , NARG, NHL, 0, 0},
  {"SRA B"            , NARG, NHL, 0, 0},
  {"SRA C"            , NARG, NHL, 0, 0},
  {"SRA D"            , NARG, NHL, 0, 0},
  {"SRA E"            , NARG, NHL, 0, 0},
  {"SRA H"            , NARG, NHL, 0, 0},
  {"SRA L"            , NARG, NHL, 0, 0},
  {"SRA (%s)"         , NARG, IHL, 0, 0},
  {"SRA A"            , NARG, NHL, 0, 0},
  {"SLL B"            , NARG, NHL, 0, 0},
  {"SLL C"            , NARG, NHL, 0, 0},
  {"SLL D"            , NARG, NHL, 0, 0},
  {"SLL E"            , NARG, NHL, 0, 0},
  {"SLL H"            , NARG, NHL, 0, 0},
  {"SLL L"            , NARG, NHL, 0, 0},
  {"SLL (%s)"         , NARG, IHL, 0, 0},
  {"SLL A"            , NARG, NHL, 0, 0},
  {"SRL B"            , NARG, NHL, 0, 0},
  {"SRL C"            , NARG, NHL, 0, 0},
  {"SRL D"            , NARG, NHL, 0, 0},
  {"SRL E"            , NARG, NHL, 0, 0},
  {"SRL H"            , NARG, NHL, 0, 0},
  {"SRL L"            , NARG, NHL, 0, 0},
  {"SRL (%s)"         , NARG, IHL, 0, 0},
  {"SRL A"            , NARG, NHL, 0, 0},
  {"BIT 0,B"          , NARG, NHL, 0, 0},
  {"BIT 0,C"          , NARG, NHL, 0, 0},
  {"BIT 0,D"          , NARG, NHL, 0, 0},
  {"BIT 0,E"          , NARG, NHL, 0, 0},
  {"BIT 0,H"          , NARG, NHL, 0, 0},
  {"BIT 0,L"          , NARG, NHL, 0, 0},
  {"BIT 0,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 0,A"          , NARG, NHL, 0, 0},
  {"BIT 1,B"          , NARG, NHL, 0, 0},
  {"BIT 1,C"          , NARG, NHL, 0, 0},
  {"BIT 1,D"          , NARG, NHL, 0, 0},
  {"BIT 1,E"          , NARG, NHL, 0, 0},
  {"BIT 1,H"          , NARG, NHL, 0, 0},
  {"BIT 1,L"          , NARG, NHL, 0, 0},
  {"BIT 1,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 1,A"          , NARG, NHL, 0, 0},
  {"BIT 2,B"          , NARG, NHL, 0, 0},
  {"BIT 2,C"          , NARG, NHL, 0, 0},
  {"BIT 2,D"          , NARG, NHL, 0, 0},
  {"BIT 2,E"          , NARG, NHL, 0, 0},
  {"BIT 2,H"          , NARG, NHL, 0, 0},
  {"BIT 2,L"          , NARG, NHL, 0, 0},
  {"BIT 2,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 2,A"          , NARG, NHL, 0, 0},
  {"BIT 3,B"          , NARG, NHL, 0, 0},
  {"BIT 3,C"          , NARG, NHL, 0, 0},
  {"BIT 3,D"          , NARG, NHL, 0, 0},
  {"BIT 3,E"          , NARG, NHL, 0, 0},
  {"BIT 3,H"          , NARG, NHL, 0, 0},
  {"BIT 3,L"          , NARG, NHL, 0, 0},
  {"BIT 3,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 3,A"          , NARG, NHL, 0, 0},
  {"BIT 4,B"          , NARG, NHL, 0, 0},
  {"BIT 4,C"          , NARG, NHL, 0, 0},
  {"BIT 4,D"          , NARG, NHL, 0, 0},
  {"BIT 4,E"          , NARG, NHL, 0, 0},
  {"BIT 4,H"          , NARG, NHL, 0, 0},
  {"BIT 4,L"          , NARG, NHL, 0, 0},
  {"BIT 4,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 4,A"          , NARG, NHL, 0, 0},
  {"BIT 5,B"          , NARG, NHL, 0, 0},
  {"BIT 5,C"          , NARG, NHL, 0, 0},
  {"BIT 5,D"          , NARG, NHL, 0, 0},
  {"BIT 5,E"          , NARG, NHL, 0, 0},
  {"BIT 5,H"          , NARG, NHL, 0, 0},
  {"BIT 5,L"          , NARG, NHL, 0, 0},
  {"BIT 5,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 5,A"          , NARG, NHL, 0, 0},
  {"BIT 6,B"          , NARG, NHL, 0, 0},
  {"BIT 6,C"          , NARG, NHL, 0, 0},
  {"BIT 6,D"          , NARG, NHL, 0, 0},
  {"BIT 6,E"          , NARG, NHL, 0, 0},
  {"BIT 6,H"          , NARG, NHL, 0, 0},
  {"BIT 6,L"          , NARG, NHL, 0, 0},
  {"BIT 6,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 6,A"          , NARG, NHL, 0, 0},
  {"BIT 7,B"          , NARG, NHL, 0, 0},
  {"BIT 7,C"          , NARG, NHL, 0, 0},
  {"BIT 7,D"          , NARG, NHL, 0, 0},
  {"BIT 7,E"          , NARG, NHL, 0, 0},
  {"BIT 7,H"          , NARG, NHL, 0, 0},
  {"BIT 7,L"          , NARG, NHL, 0, 0},
  {"BIT 7,(%s)"       , NARG, IHL, 0, 0},
  {"BIT 7,A"          , NARG, NHL, 0, 0},
  {"RES 0,B"          , NARG, NHL, 0, 0},
  {"RES 0,C"          , NARG, NHL, 0, 0},
  {"RES 0,D"          , NARG, NHL, 0, 0},
  {"RES 0,E"          , NARG, NHL, 0, 0},
  {"RES 0,H"          , NARG, NHL, 0, 0},
  {"RES 0,L"          , NARG, NHL, 0, 0},
  {"RES 0,(%s)"       , NARG, IHL, 0, 0},
  {"RES 0,A"          , NARG, NHL, 0, 0},
  {"RES 1,B"          , NARG, NHL, 0, 0},
  {"RES 1,C"          , NARG, NHL, 0, 0},
  {"RES 1,D"          , NARG, NHL, 0, 0},
  {"RES 1,E"          , NARG, NHL, 0, 0},
  {"RES 1,H"          , NARG, NHL, 0, 0},
  {"RES 1,L"          , NARG, NHL, 0, 0},
  {"RES 1,(%s)"       , NARG, IHL, 0, 0},
  {"RES 1,A"          , NARG, NHL, 0, 0},
  {"RES 2,B"          , NARG, NHL, 0, 0},
  {"RES 2,C"          , NARG, NHL, 0, 0},
  {"RES 2,D"          , NARG, NHL, 0, 0},
  {"RES 2,E"          , NARG, NHL, 0, 0},
  {"RES 2,H"          , NARG, NHL, 0, 0},
  {"RES 2,L"          , NARG, NHL, 0, 0},
  {"RES 2,(%s)"       , NARG, IHL, 0, 0},
  {"RES 2,A"          , NARG, NHL, 0, 0},
  {"RES 3,B"          , NARG, NHL, 0, 0},
  {"RES 3,C"          , NARG, NHL, 0, 0},
  {"RES 3,D"          , NARG, NHL, 0, 0},
  {"RES 3,E"          , NARG, NHL, 0, 0},
  {"RES 3,H"          , NARG, NHL, 0, 0},
  {"RES 3,L"          , NARG, NHL, 0, 0},
  {"RES 3,(%s)"       , NARG, IHL, 0, 0},
  {"RES 3,A"          , NARG, NHL, 0, 0},
  {"RES 4,B"          , NARG, NHL, 0, 0},
  {"RES 4,C"          , NARG, NHL, 0, 0},
  {"RES 4,D"          , NARG, NHL, 0, 0},
  {"RES 4,E"          , NARG, NHL, 0, 0},
  {"RES 4,H"          , NARG, NHL, 0, 0},
  {"RES 4,L"          , NARG, NHL, 0, 0},
  {"RES 4,(%s)"       , NARG, IHL, 0, 0},
  {"RES 4,A"          , NARG, NHL, 0, 0},
  {"RES 5,B"          , NARG, NHL, 0, 0},
  {"RES 5,C"          , NARG, NHL, 0, 0},
  {"RES 5,D"          , NARG, NHL, 0, 0},
  {"RES 5,E"          , NARG, NHL, 0, 0},
  {"RES 5,H"          , NARG, NHL, 0, 0},
  {"RES 5,L"          , NARG, NHL, 0, 0},
  {"RES 5,(%s)"       , NARG, IHL, 0, 0},
  {"RES 5,A"          , NARG, NHL, 0, 0},
  {"RES 6,B"          , NARG, NHL, 0, 0},
  {"RES 6,C"          , NARG, NHL, 0, 0},
  {"RES 6,D"          , NARG, NHL, 0, 0},
  {"RES 6,E"          , NARG, NHL, 0, 0},
  {"RES 6,H"          , NARG, NHL, 0, 0},
  {"RES 6,L"          , NARG, NHL, 0, 0},
  {"RES 6,(%s)"       , NARG, IHL, 0, 0},
  {"RES 6,A"          , NARG, NHL, 0, 0},
  {"RES 7,B"          , NARG, NHL, 0, 0},
  {"RES 7,C"          , NARG, NHL, 0, 0},
  {"RES 7,D"          , NARG, NHL, 0, 0},
  {"RES 7,E"          , NARG, NHL, 0, 0},
  {"RES 7,H"          , NARG, NHL, 0, 0},
  {"RES 7,L"          , NARG, NHL, 0, 0},
  {"RES 7,(%s)"       , NARG, IHL, 0, 0},
  {"RES 7,A"          , NARG, NHL, 0, 0},
  {"SET 0,B"          , NARG, NHL, 0, 0},
  {"SET 0,C"          , NARG, NHL, 0, 0},
  {"SET 0,D"          , NARG, NHL, 0, 0},
  {"SET 0,E"          , NARG, NHL, 0, 0},
  {"SET 0,H"          , NARG, NHL, 0, 0},
  {"SET 0,L"          , NARG, NHL, 0, 0},
  {"SET 0,(%s)"       , NARG, IHL, 0, 0},
  {"SET 0,A"          , NARG, NHL, 0, 0},
  {"SET 1,B"          , NARG, NHL, 0, 0},
  {"SET 1,C"          , NARG, NHL, 0, 0},
  {"SET 1,D"          , NARG, NHL, 0, 0},
  {"SET 1,E"          , NARG, NHL, 0, 0},
  {"SET 1,H"          , NARG, NHL, 0, 0},
  {"SET 1,L"          , NARG, NHL, 0, 0},
  {"SET 1,(%s)"       , NARG, IHL, 0, 0},
  {"SET 1,A"          , NARG, NHL, 0, 0},
  {"SET 2,B"          , NARG, NHL, 0, 0},
  {"SET 2,C"          , NARG, NHL, 0, 0},
  {"SET 2,D"          , NARG, NHL, 0, 0},
  {"SET 2,E"          , NARG, NHL, 0, 0},
  {"SET 2,H"          , NARG, NHL, 0, 0},
  {"SET 2,L"          , NARG, NHL, 0, 0},
  {"SET 2,(%s)"       , NARG, IHL, 0, 0},
  {"SET 2,A"          , NARG, NHL, 0, 0},
  {"SET 3,B"          , NARG, NHL, 0, 0},
  {"SET 3,C"          , NARG, NHL, 0, 0},
  {"SET 3,D"          , NARG, NHL, 0, 0},
  {"SET 3,E"          , NARG, NHL, 0, 0},
  {"SET 3,H"          , NARG, NHL, 0, 0},
  {"SET 3,L"          , NARG, NHL, 0, 0},
  {"SET 3,(%s)"       , NARG, IHL, 0, 0},
  {"SET 3,A"          , NARG, NHL, 0, 0},
  {"SET 4,B"          , NARG, NHL, 0, 0},
  {"SET 4,C"          , NARG, NHL, 0, 0},
  {"SET 4,D"          , NARG, NHL, 0, 0},
  {"SET 4,E"          , NARG, NHL, 0, 0},
  {"SET 4,H"          , NARG, NHL, 0, 0},
  {"SET 4,L"          , NARG, NHL, 0, 0},
  {"SET 4,(%s)"       , NARG, IHL, 0, 0},
  {"SET 4,A"          , NARG, NHL, 0, 0},
  {"SET 5,B"          , NARG, NHL, 0, 0},
  {"SET 5,C"          , NARG, NHL, 0, 0},
  {"SET 5,D"          , NARG, NHL, 0, 0},
  {"SET 5,E"          , NARG, NHL, 0, 0},
  {"SET 5,H"          , NARG, NHL, 0, 0},
  {"SET 5,L"          , NARG, NHL, 0, 0},
  {"SET 5,(%s)"       , NARG, IHL, 0, 0},
  {"SET 5,A"          , NARG, NHL, 0, 0},
  {"SET 6,B"          , NARG, NHL, 0, 0},
  {"SET 6,C"          , NARG, NHL, 0, 0},
  {"SET 6,D"          , NARG, NHL, 0, 0},
  {"SET 6,E"          , NARG, NHL, 0, 0},
  {"SET 6,H"          , NARG, NHL, 0, 0},
  {"SET 6,L"          , NARG, NHL, 0, 0},
  {"SET 6,(%s)"       , NARG, IHL, 0, 0},
  {"SET 6,A"          , NARG, NHL, 0, 0},
  {"SET 7,B"          , NARG, NHL, 0, 0},
  {"SET 7,C"          , NARG, NHL, 0, 0},
  {"SET 7,D"          , NARG, NHL, 0, 0},
  {"SET 7,E"          , NARG, NHL, 0, 0},
  {"SET 7,H"          , NARG, NHL, 0, 0},
  {"SET 7,L"          , NARG, NHL, 0, 0},
  {"SET 7,(%s)"       , NARG, IHL, 0, 0},
  {"SET 7,A"          , NARG, NHL, 0, 0}
};

#define MAXLEN 256

static const char *hlnam[3][3] = {
  {"_", "H", "L"},
  {"_", "XH", "XL"},
  {"_", "YH", "YL"}
};

static const char *thlnam[3] = {
  "HL",
  "IX",
  "IY"
};

static char *ixd(int ixtype, sbyte offs)
{
  static char ixdnam[16];

  sprintf(ixdnam, "%s%+d", thlnam[ixtype], offs);
  return ixdnam;
}

#define DIPC (mem[pc] | (mem[pc+1] << 8))

char *opname(byte *mem, dbyte pc, dbyte *endop)
{
  static char opnam[MAXLEN];

  byte code;
  int ixtype;
  sbyte offs = 0;
  
  struct op *ct;
  struct op *ce;
  
  
  ixtype = 0;
  ct = tab_norm;

  code = mem[pc++];
  switch(code) {
  case 0xDD:
    ixtype = 1;
    break;
  case 0xFD:
    ixtype = 2;
    break;
  case 0xED:
    ct = tab_ed;
    code = mem[pc++];
    break;
  case 0xCB:
    ct = tab_cb;
    code = mem[pc++];
    break;
  }
  
  if(ixtype && mem[pc] != 0xDD && mem[pc] != 0xFD) {
    code = mem[pc++];
    if(code == 0xED) {
      ixtype = 0;
      ct = tab_ed;
      code = mem[pc++];
    }
    else if(code == 0xCB) {
      ct = tab_cb;
      offs = mem[pc++];
      code = mem[pc++];
    }
  }
  
  ce = ct + code;

  if(ct == tab_norm && ixtype && ce->hltype == IHL) offs = mem[pc++];


  switch(ce->argtype) {
  case NARG:
    switch(ce->hltype) {
    case NHL:
      sprintf(opnam, ce->fmt);
      break;
    case SHL:
      sprintf(opnam, ce->fmt,
	      hlnam[ixtype][ce->shl0], hlnam[ixtype][ce->shl1]);
      break;
    case THL:
      sprintf(opnam, ce->fmt, thlnam[ixtype], thlnam[ixtype]);
      break;
    case IHL:
      sprintf(opnam, ce->fmt, ixtype ? ixd(ixtype, offs) : "HL");
      break;
    }
    break;

  case BARG:
    switch(ce->hltype) {
    case NHL:
      sprintf(opnam, ce->fmt, mem[pc++]);
      break;
    case SHL:
      sprintf(opnam, ce->fmt, hlnam[ixtype][ce->shl0], mem[pc++]);
      break;
    case IHL:
      sprintf(opnam, ce->fmt, ixtype ? ixd(ixtype, offs) : "HL", mem[pc++]);
      break;
    }
    break;

  case SARG:
    sprintf(opnam, ce->fmt, (sbyte) mem[pc++]);
    break;

  case DARG:
    switch(ce->hltype) {
    case NHL:
      sprintf(opnam, ce->fmt, DIPC), pc+=2;
      break;
    case THL:
      if(ce->shl0) sprintf(opnam, ce->fmt, DIPC, thlnam[ixtype]), pc+=2;
      else         sprintf(opnam, ce->fmt, thlnam[ixtype], DIPC), pc+=2;
      break;
    }
    break;
  }
  
  *endop = pc;
  return opnam;
}
