/*
* This file is part of the OpenSupaplex distribution (https://github.com/sergiou87/open-supaplex).
* Copyright (c) 2020 Sergio Padrino
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, version 3.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include "animations.h"

const MurphyAnimationDescriptor kMurphyAnimationDescriptors[50] = { // someBinaryData_5110E
    { // 0
        0x06ac, // -> dfe
        0xff0c, // -> e00
        0x0002, // -> e02
        0x0012, // -> e04
        0, // 0x111e, // -> e06
        0x0000, // -> e08
        0xfffe, // -> e0a
        0x0000, // -> e0c
    }, { // 1
        0x06ac, // -> e0e
        0xff0c, // -> e10
        0x0002, // -> e12
        0x0012, // -> e14
        1, // 0x1130, // -> e16
        0x0000, // -> e18
        0xfffe, // -> e1a
        0x0000, // -> e1c
    }, { // 2
        0x0000, // -> e1e
        0x0000, // -> e20
        0x0004, // -> e22
        0x0010, // -> e24
        4, // 0x1166, // -> e26
        0xfffe, // -> e28
        0x0000, // -> e2a
        0x0000, // -> e2c
    }, { // 3
        0xf860, // -> e2e
        0x00f4, // -> e30
        0x0002, // -> e32
        0x0012, // -> e34
        2, // 0x1142, // -> e36
        0x0000, // -> e38
        0x0002, // -> e3a
        0x0000, // -> e3c
    }, { // 4
        0xf860, // -> e3e
        0x00f4, // -> e40
        0x0002, // -> e42
        0x0012, // -> e44
        3, // 0x1154 // -> e46
        0x0000, // -> e48
        0x0002, // -> e4a
        0x0000, // -> e4c
    }, { // 5
        0xfffe, // -> e4e
        0x0000, // -> e50
        0x0004, // -> e52
        0x0010, // -> e54
        5, // 0x1178, // -> e56
        0x0002, // -> e58
        0x0000, // -> e5a
        0x0000, // -> e5c
    }, { // 6
        0x0000, // -> e5e
        0x0000, // -> e60
        0x0002, // -> e62
        0x0010, // -> e64
        6, // 0x118a, // -> e66
        0x0000, // -> e68
        0x0000, // -> e6a
        0x0000, // -> e6c
    }, { // 7
        0x06ac, // -> e6e
        0xff0c, // -> e70
        0x0002, // -> e72
        0x0012, // -> e74
        0, // 0x111e, // -> e76
        0x0000, // -> e78
        0xfffe, // -> e7a
        0x0000, // -> e7c
    }, { // 8
        0x06ac, // -> e7e
        0xff0c, // -> e80
        0x0002, // -> e82
        0x0012, // -> e84
        1, // 0x1130, // -> e86
        0x0000, // -> e88
        0xfffe, // -> e8a
        0x0000, // -> e8c
    }, { // 9
        0x0000, // -> e8e
        0x0000, // -> e90
        0x0004, // -> e92
        0x0010, // -> e94
        7, // 0x11dc, // -> e96
        0xfffe, // -> e98
        0x0000, // -> e9a
        0x0000, // -> e9c
    }, { // 10
        0xf860, // -> e9e
        0x00f4, // -> ea0
        0x0002, // -> ea2
        0x0012, // -> ea4
        2, // 0x1142, // -> ea6
        0x0000, // -> ea8
        0x0002, // -> eaa
        0x0000, // -> eac
    }, { // 11
        0xf860, // -> eae
        0x00f4, // -> eb0
        0x0002, // -> eb2
        0x0012, // -> eb4
        3, // 0x1154 // -> eb6
        0x0000, // -> eb8
        0x0002, // -> eba
        0x0000, // -> ebc
    }, { // 12
        0xfffe, // -> ebe
        0x0000, // -> ec0
        0x0004, // -> ec2
        0x0010, // -> ec4
        8, // 0x11ee, // -> ec6
        0x0002, // -> ec8
        0x0000, // -> eca
        0x0000, // -> ecc
    }, { // 13
        0xf860, // -> ece
        0x0000, // -> ed0
        0x0002, // -> ed2
        0x0010, // -> ed4
        9, // 0x1200, // -> ed6
        0x0000, // -> ed8
        0x0000, // -> eda
        0x0000, // -> edc
    }, { // 14
        0xfffe, // -> ede
        0x0000, // -> ee0
        0x0002, // -> ee2
        0x0010, // -> ee4
        9, // 0x1200, // -> ee6
        0x0000, // -> ee8
        0x0000, // -> eea
        0x0000, // -> eec
    }, { // 15
        0x07a0, // -> eee
        0x0000, // -> ef0
        0x0002, // -> ef2
        0x0010, // -> ef4
        9, // 0x1200, // -> ef6
        0x0000, // -> ef8
        0x0000, // -> efa
        0x0000, // -> efc
    }, { // 16
        0x0002, // -> efe
        0x0000, // -> f00
        0x0002, // -> f02
        0x0010, // -> f04
        9, // 0x1200, // -> f06
        0x0000, // -> f08
        0x0000, // -> f0a
        0x0000, // -> f0c
    }, { // 17
        0x06ac, // -> f0e
        0xff0c, // -> f10
        0x0002, // -> f12
        0x0012, // -> f14
        0, // 0x111e, // -> f16
        0x0000, // -> f18
        0xfffe, // -> f1a
        0x0000, // -> f1c
    }, { // 18
        0x06ac, // -> f1e
        0xff0c, // -> f20
        0x0002, // -> f22
        0x0012, // -> f24
        1, // 0x1130, // -> f26
        0x0000, // -> f28
        0xfffe, // -> f2a
        0x0000, // -> f2c
    }, { // 19
        0x0000, // -> f2e
        0x0000, // -> f30
        0x0004, // -> f32
        0x0010, // -> f34
        10, // 0x1212, // -> f36
        0xfffe, // -> f38
        0x0000, // -> f3a
        0x0000, // -> f3c
    }, { // 20
        0xf860, // -> f3e
        0x00f4, // -> f40
        0x0002, // -> f42
        0x0012, // -> f44
        2, // 0x1142, // -> f46
        0x0000, // -> f48
        0x0002, // -> f4a
        0x0000, // -> f4c
    }, { // 21
        0xf860, // -> f4e
        0x00f4, // -> f50
        0x0002, // -> f52
        0x0012, // -> f54
        3, // 0x1154 // -> f56
        0x0000, // -> f58
        0x0002, // -> f5a
        0x0000, // -> f5c
    }, { // 22
        0xfffe, // -> f5e
        0x0000, // -> f60
        0x0004, // -> f62
        0x0010, // -> f64
        11, // 0x1224, // -> f66
        0x0002, // -> f68
        0x0000, // -> f6a
        0x0000, // -> f6c
    }, { // 23
        0xf860, // -> f6e
        0x0000, // -> f70
        0x0002, // -> f72
        0x0010, // -> f74
        12, // 0x1236, // -> f76
        0x0000, // -> f78
        0x0000, // -> f7a
        0x0000, // -> f7c
    }, { // 24
        0xfffe, // -> f7e
        0x0000, // -> f80
        0x0002, // -> f82
        0x0010, // -> f84
        12, // 0x1236, // -> f86
        0x0000, // -> f88
        0x0000, // -> f8a
        0x0000, // -> f8c
    }, { // 25
        0x07a0, // -> f8e
        0x0000, // -> f90
        0x0002, // -> f92
        0x0010, // -> f94
        12, // 0x1236, // -> f96
        0x0000, // -> f98
        0x0000, // -> f9a
        0x0000, // -> f9c
    }, { // 26
        0x0002, // -> f9e
        0x0000, // -> fa0
        0x0002, // -> fa2
        0x0010, // -> fa4
        12, // 0x1236, // -> fa6
        0x0000, // -> fa8
        0x0000, // -> faa
        0x0000, // -> fac
    }, { // 27
        0xfffc, // -> fae
        0x0000, // -> fb0
        0x0006, // -> fb2
        0x0010, // -> fb4
        13, // 0x1246, // -> fb6
        0xfffe, // -> fb8
        0x0000, // -> fba
        0x0000, // -> fbc
    }, { // 28
        0x0000, // -> fbe
        0x0000, // -> fc0
        0x0006, // -> fc2
        0x0010, // -> fc4
        14, // 0x1258, // -> fc6
        0x0002, // -> fc8
        0x0000, // -> fca
        0x0000, // -> fcc
    }, { // 29
        0x0000, // -> fce
        0xf0c0, // -> fd0
        0x0002, // -> fd2
        0x0010, // -> fd4
        19, // 0x1340, // -> fd6
        0x0000, // -> fd8
        0xfffc, // -> fda
        0x0000, // -> fdc
    }, { // 30
        0x0000, // -> fde
        0xfffc, // -> fe0
        0x0002, // -> fe2
        0x0010, // -> fe4
        15, // 0x12f8, // -> fe6
        0xfffc, // -> fe8
        0x0000, // -> fea
        0x0000, // -> fec
    }, { // 31
        0x0000, // -> fee
        0x0f40, // -> ff0
        0x0002, // -> ff2
        0x0010, // -> ff4
        21, // 0x1364, // -> ff6
        0x0000, // -> ff8
        0x0004, // -> ffa
        0x0000, // -> ffc
    }, { // 32
        0x0000, // -> ffe
        0x0004, // -> 1000
        0x0002, // -> 1002
        0x0010, // -> 1004
        17, // 0x131c, // -> 1006
        0x0004, // -> 1008
        0x0000, // -> 100a
        0x0000, // -> 100c
    }, { // 33
        0xff0c, // -> 100e
        0xff0c, // -> 1010
        0x0002, // -> 1012
        0x0012, // -> 1014
        0, // 0x111e, // -> 1016
        0x0000, // -> 1018
        0xfffe, // -> 101a
        0x0000, // -> 101c
    }, { // 34
        0xff0c, // -> 101e
        0xff0c, // -> 1020
        0x0002, // -> 1022
        0x0012, // -> 1024
        1, // 0x1130, // -> 1026
        0x0000, // -> 1028
        0xfffe, // -> 102a
        0x0000, // -> 102c
    }, { // 35
        0x0000, // -> 102e
        0x0000, // -> 1030
        0x0004, // -> 1032
        0x0010, // -> 1034
        23, // 0x1448, // -> 1036
        0xfffe, // -> 1038
        0x0000, // -> 103a
        0x0000, // -> 103c
    }, { // 36
        0x0000, // -> 103e
        0x00f4, // -> 1040
        0x0002, // -> 1042
        0x0012, // -> 1044
        2, // 0x1142, // -> 1046
        0x0000, // -> 1048
        0x0002, // -> 104a
        0x0000, // -> 104c
    }, { // 37
        0x0000, // -> 104e
        0x00f4, // -> 1050
        0x0002, // -> 1052
        0x0012, // -> 1054
        3, // 0x1154 // -> 1056
        0x0000, // -> 1058
        0x0002, // -> 105a
        0x0000, // -> 105c
    }, { // 38
        0xfffe, // -> 105e
        0x0000, // -> 1060
        0x0004, // -> 1062
        0x0010, // -> 1064
        24, // 0x145a, // -> 1066
        0x0002, // -> 1068
        0x0000, // -> 106a
        0x0000, // -> 106c
    }, { // 39
        0xf860, // -> 106e
        0x0000, // -> 1070
        0x0002, // -> 1072
        0x0010, // -> 1074
        25, // 0x146e, // -> 1076
        0x0000, // -> 1078
        0x0000, // -> 107a
        0x0000, // -> 107c
    }, { // 40
        0xfffe, // -> 107e
        0x0000, // -> 1080
        0x0002, // -> 1082
        0x0010, // -> 1084
        25, // 0x146e, // -> 1086
        0x0000, // -> 1088
        0x0000, // -> 108a
        0x0000, // -> 108c
    }, { // 41
        0x07a0, // -> 108e
        0x0000, // -> 1090
        0x0002, // -> 1092
        0x0010, // -> 1094
        25, // 0x146e, // -> 1096
        0x0000, // -> 1098
        0x0000, // -> 109a
        0x0000, // -> 109c
    }, { // 42
        0x0002, // -> 109e
        0x0000, // -> 10a0
        0x0002, // -> 10a2
        0x0010, // -> 10a4
        25, // 0x146e, // -> 10a6
        0x0000, // -> 10a8
        0x0000, // -> 10aa
        0x0000, // -> 10ac
    }, { // 43
        0xf76c, // -> 10ae
        0xff0c, // -> 10b0
        0x0002, // -> 10b2
        0x0022, // -> 10b4
        28, // 0x1488, // -> 10b6
        0x0000, // -> 10b8
        0xfffe, // -> 10ba
        0x0000, // -> 10bc
    }, { // 44
        0xfffc, // -> 10be
        0x0000, // -> 10c0
        0x0006, // -> 10c2
        0x0010, // -> 10c4
        29, // 0x149a, // -> 10c6
        0xfffe, // -> 10c8
        0x0000, // -> 10ca
        0x0000, // -> 10cc
    }, { // 45
        0x0000, // -> 10ce
        0x00f4, // -> 10d0
        0x0002, // -> 10d2
        0x0022, // -> 10d4
        30, // 0x14ac, // -> 10d6
        0x0000, // -> 10d8
        0x0002, // -> 10da
        0x0000, // -> 10dc
    }, { // 46
        0x0000, // -> 10de
        0x0000, // -> 10e0
        0x0006, // -> 10e2
        0x0010, // -> 10e4
        31, // 0x14be, // -> 10e6
        0x0002, // -> 10e8
        0x0000, // -> 10ea
        0x0000, // -> 10ec
    }, { // 47
        0xfffc, // -> 10ee
        0x0000, // -> 10f0
        0x0006, // -> 10f2
        0x0010, // -> 10f4
        32, // 0x14d0, // -> 10f6
        0xfffe, // -> 10f8
        0x0000, // -> 10fa
        0x0000, // -> 10fc
    }, { // 48
        0x0000, // -> 10fe
        0x0000, // -> 1100
        0x0006, // -> 1102
        0x0010, // -> 1104
        33, // 0x14e2, // -> 1106
        0x0002, // -> 1108
        0x0000, // -> 110a
        0x0000, // -> 110c
    }, { // 49
        0x0000, // -> 110e
        0x0000, // -> 1110
        0x0002, // -> 1112
        0x0010, // -> 1114
        27, // 0x1484, // -> 1116
        0x0000, // -> 1118
        0x0000, // -> 111a
        0x0000, // -> 111c
    }
};

const AnimationFrameCoordinates kMurphyAnimationFrameCoordinates[37] = {
    { // 0
        {
            { 0, 66 }, // -> 0x2ae6 -> 111e
            { 0, 66 }, // -> 0x2ae6 -> 1120
            { 16, 66 }, // -> 0x2ae8 -> 1122
            { 16, 66 }, // -> 0x2ae8 -> 1124
            { 32, 66 }, // -> 0x2aea -> 1126
            { 32, 66 }, // -> 0x2aea -> 1128
            { 16, 66 }, // -> 0x2ae8 -> 112a
            { 16, 66 }, // -> 0x2ae8 -> 112c
        },
        8
    },
    { // 1
        {
            { 48, 66 }, // -> 0x2aec -> 1130
            { 48, 66 }, // -> 0x2aec -> 1132
            { 64, 66 }, // -> 0x2aee -> 1134
            { 64, 66 }, // -> 0x2aee -> 1136
            { 80, 66 }, // -> 0x2af0 -> 1138
            { 80, 66 }, // -> 0x2af0 -> 113a
            { 64, 66 }, // -> 0x2aee -> 113c
            { 64, 66 }, // -> 0x2aee -> 113e
        },
        8
    },
    { // 2
        {
            { 0, 64 }, // -> 0x29f2 -> 1142
            { 0, 64 }, // -> 0x29f2 -> 1144
            { 16, 64 }, // -> 0x29f4 -> 1146
            { 16, 64 }, // -> 0x29f4 -> 1148
            { 32, 64 }, // -> 0x29f6 -> 114a
            { 32, 64 }, // -> 0x29f6 -> 114c
            { 16, 64 }, // -> 0x29f4 -> 114e
            { 16, 64 }, // -> 0x29f4 -> 1150
        },
        8
    },
    { // 3
        {
            { 48, 64 }, // -> 0x29f8 -> 1154
            { 48, 64 }, // -> 0x29f8 -> 1156
            { 64, 64 }, // -> 0x29fa -> 1158
            { 64, 64 }, // -> 0x29fa -> 115a
            { 80, 64 }, // -> 0x29fc -> 115c
            { 80, 64 }, // -> 0x29fc -> 115e
            { 64, 64 }, // -> 0x29fa -> 1160
            { 64, 64 }, // -> 0x29fa -> 1162
        },
        8
    },
    { // 4
        {
            { 32, 32 }, // -> 0x1ab6 -> 1166
            { 64, 32 }, // -> 0x1aba -> 1168
            { 96, 32 }, // -> 0x1abe -> 116a
            { 128, 32 }, // -> 0x1ac2 -> 116c
            { 160, 32 }, // -> 0x1ac6 -> 116e
            { 192, 32 }, // -> 0x1aca -> 1170
            { 224, 32 }, // -> 0x1ace -> 1172
            { 256, 32 }, // -> 0x1ad2 -> 1174
        },
        8
    },
    { // 5
        {
            { 288, 32 }, // -> 0x1ad6 -> 1178
            { 0, 48 }, // -> 0x2252 -> 117a
            { 32, 48 }, // -> 0x2256 -> 117c
            { 64, 48 }, // -> 0x225a -> 117e
            { 96, 48 }, // -> 0x225e -> 1180
            { 128, 48 }, // -> 0x2262 -> 1182
            { 160, 48 }, // -> 0x2266 -> 1184
            { 192, 48 }, // -> 0x226a -> 1186
        },
        8
    },
    { // 6
        {
            { 160, 64 }, // -> 0x2a06 -> 118a
            { 160, 64 }, // -> 0x2a06 -> 118c
            { 160, 64 }, // -> 0x2a06 -> 118e
            { 160, 64 }, // -> 0x2a06 -> 1190
            { 176, 64 }, // -> 0x2a08 -> 1192
            { 176, 64 }, // -> 0x2a08 -> 1194
            { 176, 64 }, // -> 0x2a08 -> 1196
            { 176, 64 }, // -> 0x2a08 -> 1198
            { 192, 64 }, // -> 0x2a0a -> 119a
            { 192, 64 }, // -> 0x2a0a -> 119c
            { 192, 64 }, // -> 0x2a0a -> 119e
            { 192, 64 }, // -> 0x2a0a -> 11a0
            { 208, 64 }, // -> 0x2a0c -> 11a2
            { 208, 64 }, // -> 0x2a0c -> 11a4
            { 208, 64 }, // -> 0x2a0c -> 11a6
            { 208, 64 }, // -> 0x2a0c -> 11a8
            { 224, 64 }, // -> 0x2a0e -> 11aa
            { 224, 64 }, // -> 0x2a0e -> 11ac
            { 224, 64 }, // -> 0x2a0e -> 11ae
            { 224, 64 }, // -> 0x2a0e -> 11b0
            { 240, 64 }, // -> 0x2a10 -> 11b2
            { 240, 64 }, // -> 0x2a10 -> 11b4
            { 240, 64 }, // -> 0x2a10 -> 11b6
            { 240, 64 }, // -> 0x2a10 -> 11b8
            { 256, 64 }, // -> 0x2a12 -> 11ba
            { 256, 64 }, // -> 0x2a12 -> 11bc
            { 256, 64 }, // -> 0x2a12 -> 11be
            { 256, 64 }, // -> 0x2a12 -> 11c0
            { 272, 64 }, // -> 0x2a14 -> 11c2
            { 272, 64 }, // -> 0x2a14 -> 11c4
            { 272, 64 }, // -> 0x2a14 -> 11c6
            { 272, 64 }, // -> 0x2a14 -> 11c8
            { 288, 64 }, // -> 0x2a16 -> 11ca
            { 288, 64 }, // -> 0x2a16 -> 11cc
            { 288, 64 }, // -> 0x2a16 -> 11ce
            { 288, 64 }, // -> 0x2a16 -> 11d0
            { 240, 0 }, // -> 0x0b90 -> 11d2
            { 240, 0 }, // -> 0x0b90 -> 11d4
            { 240, 0 }, // -> 0x0b90 -> 11d6
            { 240, 0 }, // -> 0x0b90 -> 11d8
        },
        40
    },
    { // 7
        {
            { 0, 0 }, // -> 0x0b72 -> 11dc
            { 32, 0 }, // -> 0x0b76 -> 11de
            { 64, 0 }, // -> 0x0b7a -> 11e0
            { 96, 0 }, // -> 0x0b7e -> 11e2
            { 128, 0 }, // -> 0x0b82 -> 11e4
            { 160, 0 }, // -> 0x0b86 -> 11e6
            { 192, 0 }, // -> 0x0b8a -> 11e8
            { 224, 0 }, // -> 0x0b8e -> 11ea
        },
        8
    },
    { // 8
        {
            { 256, 0 }, // -> 0x0b92 -> 11ee
            { 288, 0 }, // -> 0x0b96 -> 11f0
            { 0, 16 }, // -> 0x1312 -> 11f2
            { 32, 16 }, // -> 0x1316 -> 11f4
            { 64, 16 }, // -> 0x131a -> 11f6
            { 96, 16 }, // -> 0x131e -> 11f8
            { 128, 16 }, // -> 0x1322 -> 11fa
            { 160, 16 }, // -> 0x1326 -> 11fc
        },
        8
    },
    { // 9
        {
            { 256, 84 }, // -> 0x339a -> 1200
            { 272, 84 }, // -> 0x339c -> 1202
            { 288, 84 }, // -> 0x339e -> 1204
            { 304, 84 }, // -> 0x33a0 -> 1206
            { 256, 100 }, // -> 0x3b3a -> 1208
            { 272, 100 }, // -> 0x3b3c -> 120a
            { 288, 100 }, // -> 0x3b3e -> 120c
            { 304, 148 }, // -> 0x0514 -> 120e
        },
        8
    },
    { // 10
        {
            { 0, 212 }, // -> 0x236e -> 1212
            { 32, 212 }, // -> 0x2372 -> 1214
            { 64, 212 }, // -> 0x2376 -> 1216
            { 96, 212 }, // -> 0x237a -> 1218
            { 128, 212 }, // -> 0x237e -> 121a
            { 160, 212 }, // -> 0x2382 -> 121c
            { 192, 212 }, // -> 0x2386 -> 121e
            { 224, 212 }, // -> 0x238a -> 1220
        },
        8
    },
    { // 11
        {
            { 256, 212 }, // -> 0x238e -> 1224
            { 288, 212 }, // -> 0x2392 -> 1226
            { 0, 228 }, // -> 0x2b0e -> 1228
            { 32, 228 }, // -> 0x2b12 -> 122a
            { 64, 228 }, // -> 0x2b16 -> 122c
            { 96, 228 }, // -> 0x2b1a -> 122e
            { 128, 228 }, // -> 0x2b1e -> 1230
            { 160, 228 }, // -> 0x2b22 -> 1232
        },
        8
    },
    { // 12
        {
            { 192, 148 }, // -> 0x0506 -> 1236
            { 208, 148 }, // -> 0x0508 -> 1238
            { 224, 148 }, // -> 0x050a -> 123a
            { 256, 148 }, // -> 0x050e -> 123c
            { 272, 148 }, // -> 0x0510 -> 123e
            { 288, 148 }, // -> 0x0512 -> 1240
            { 304, 148 }, // -> 0x0514 -> 1242
        },
        7
    },
    { // 13
        {
            { 0, 116 }, // -> 0x42ba -> 1246
            { 48, 116 }, // -> 0x42c0 -> 1248
            { 96, 116 }, // -> 0x42c6 -> 124a
            { 144, 116 }, // -> 0x42cc -> 124c
            { 192, 116 }, // -> 0x42d2 -> 124e
            { 240, 116 }, // -> 0x42d8 -> 1250
            { 0, 132 }, // -> 0x4a5a -> 1252
            { 48, 132 }, // -> 0x4a60 -> 1254
        },
        8
    },
    { // 14
        {
            { 96, 132 }, // -> 0x4a66 -> 1258
            { 144, 132 }, // -> 0x4a6c -> 125a
            { 192, 132 }, // -> 0x4a72 -> 125c
            { 240, 132 }, // -> 0x4a78 -> 125e
            { 0, 148 }, // -> 0x04ee -> 1260
            { 48, 148 }, // -> 0x04f4 -> 1262
            { 96, 148 }, // -> 0x04fa -> 1264
            { 144, 148 }, // -> 0x0500 -> 1266
        },
        8
    },
//AnimationFrameCoordinates frameCoordinates_515C6[8] = {
    { // 15
        {
            { 48, 32 }, // -> 0x1ab8 -> 12f8
            { 80, 32 }, // -> 0x1abc -> 12fa
            { 112, 32 }, // -> 0x1ac0 -> 12fc
            { 144, 32 }, // -> 0x1ac4 -> 12fe
            { 176, 32 }, // -> 0x1ac8 -> 1300
            { 208, 32 }, // -> 0x1acc -> 1302
            { 240, 32 }, // -> 0x1ad0 -> 1304
            { 272, 32 }, // -> 0x1ad4 -> 1306
        },
        8
    },
    { // 16
        {
            { 32, 32 }, // -> 0x1ab6 -> 130a
            { 64, 32 }, // -> 0x1aba -> 130c
            { 96, 32 }, // -> 0x1abe -> 130e
            { 128, 32 }, // -> 0x1ac2 -> 1310
            { 160, 32 }, // -> 0x1ac6 -> 1312
            { 192, 32 }, // -> 0x1aca -> 1314
            { 224, 32 }, // -> 0x1ace -> 1316
            { 256, 32 }, // -> 0x1ad2 -> 1318
        },
        8
    },
    { // 17
        {
            { 288, 32 }, // -> 0x1ad6 -> 131c
            { 0, 48 }, // -> 0x2252 -> 131e
            { 32, 48 }, // -> 0x2256 -> 1320
            { 64, 48 }, // -> 0x225a -> 1322
            { 96, 48 }, // -> 0x225e -> 1324
            { 128, 48 }, // -> 0x2262 -> 1326
            { 160, 48 }, // -> 0x2266 -> 1328
            { 192, 48 }, // -> 0x226a -> 132a
        },
        8
    },
    { // 18
        {
            { 304, 32 }, // -> 0x1ad8 -> 132e
            { 16, 48 }, // -> 0x2254 -> 1330
            { 48, 48 }, // -> 0x2258 -> 1332
            { 80, 48 }, // -> 0x225c -> 1334
            { 112, 48 }, // -> 0x2260 -> 1336
            { 144, 48 }, // -> 0x2264 -> 1338
            { 176, 48 }, // -> 0x2268 -> 133a
            { 208, 48 }, // -> 0x226c -> 133c
        },
        8
    },
    { // 19
        {
            { 304, 134 }, // -> 0x4b74 -> 1340
            { 304, 136 }, // -> 0x4c68 -> 1342
            { 304, 138 }, // -> 0x0050 -> 1344
            { 304, 140 }, // -> 0x0144 -> 1346
            { 304, 142 }, // -> 0x0238 -> 1348
            { 304, 144 }, // -> 0x032c -> 134a
            { 304, 146 }, // -> 0x0420 -> 134c
            { 304, 148 }, // -> 0x0514 -> 134e
        },
        8
    },
    { // 20
        {
            { 304, 118 }, // -> 0x43d4 -> 1352
            { 304, 120 }, // -> 0x44c8 -> 1354
            { 304, 122 }, // -> 0x45bc -> 1356
            { 304, 124 }, // -> 0x46b0 -> 1358
            { 304, 126 }, // -> 0x47a4 -> 135a
            { 304, 128 }, // -> 0x4898 -> 135c
            { 304, 130 }, // -> 0x498c -> 135e
            { 304, 132 }, // -> 0x4a80 -> 1360
        },
        8
    },
    { // 21
        {
            { 304, 130 }, // -> 0x498c -> 1364
            { 304, 128 }, // -> 0x4898 -> 1366
            { 304, 126 }, // -> 0x47a4 -> 1368
            { 304, 124 }, // -> 0x46b0 -> 136a
            { 304, 122 }, // -> 0x45bc -> 136c
            { 304, 120 }, // -> 0x44c8 -> 136e
            { 304, 118 }, // -> 0x43d4 -> 1370
            { 304, 116 }, // -> 0x42e0 -> 1372
        },
        8
    },
    { // 22
        {
            { 304, 146 }, // -> 0x0420 -> 1376
            { 304, 144 }, // -> 0x032c -> 1378
            { 304, 142 }, // -> 0x0238 -> 137a
            { 304, 140 }, // -> 0x0144 -> 137c
            { 304, 138 }, // -> 0x0050 -> 137e
            { 304, 136 }, // -> 0x4c68 -> 1380
            { 304, 134 }, // -> 0x4b74 -> 1382
            { 304, 132 }, // -> 0x4a80 -> 1384
        },
        8
    },
//AnimationFrameCoordinates frameCoordinates_51714[2] = {
    { // 23
        {
            // Murphy eating red disk left
            { 128, 260 }, // -> 0x3a5e -> 1448
            { 160, 260 }, // -> 0x3a62 -> 144a
            { 192, 260 }, // -> 0x3a66 -> 144c
            { 224, 260 }, // -> 0x3a6a -> 144e
            { 256, 260 }, // -> 0x3a6e -> 1450
            { 288, 260 }, // -> 0x3a72 -> 1452
            { 288, 276 }, // -> 0x4212 -> 1454
            { 288, 292 }, // -> 0x49b2 -> 1456
        },
        8
    },
    { // 24
        {
            // Murphy eating red disk right
            { 192, 308 }, // -> 0x043a -> 145a
            { 224, 308 }, // -> 0x043e -> 145c
            { 256, 308 }, // -> 0x0442 -> 145e
            { 288, 308 }, // -> 0x0446 -> 1460
            { 288, 308 }, // -> 0x0446 -> 1462 // this is probably duplicated by mistake
            { 288, 324 }, // -> 0x0be6 -> 1464
            { 288, 340 }, // -> 0x1386 -> 1466
            { 192, 356 }, // -> 0x1b1a -> 1468
            { 224, 356 }, // -> 0x1b1e -> 146a
        },
        9 // this should be 8 or the animation takes too long, but fixing this bug will make some demos break. Preserve old behavior or fix bug?
    },
    { // 25
        {
            { 256, 164 }, // 0x0CAE -> 146e
            { 272, 164 }, // 0x0CB0 -> 1470
            { 288, 164 }, // 0x0CB2 -> 1472
            { 304, 164 }, // 0x0CB4 -> 1474
            { 256, 180 }, // 0x144E -> 1476
            { 272, 180 }, // 0x1450 -> 1478
            { 288, 180 }, // 0x1452 -> 147A
            { 304, 180 }, // 0x1454 -> 147C
        },
        8
    },
    { // 26
        {
            { 288, 132 }, // 0x4A7E -> 1480
        },
        1
    },
    { // 27
        {
            { 256, 164 }, // 0x0CAE -> 1484
        },
        1
    },
    { // 28
        {
            { 304, 406 }, // 0x32FC -> 1488
            { 304, 406 }, // 0x32FC -> 148A
            { 304, 406 }, // 0x32FC -> 148C
            { 304, 406 }, // 0x32FC -> 148E
            { 304, 406 }, // 0x32FC -> 1490
            { 304, 406 }, // 0x32FC -> 1492
            { 304, 406 }, // 0x32FC -> 1494
            { 304, 406 }, // 0x32FC -> 1496
        },
        8
    },
    { // 29
        {
            { 0, 324 }, // 0x0BC2 -> 149A
            { 48, 324 }, // 0x0BC8 -> 149C
            { 96, 324 }, // 0x0BCE -> 149E
            { 144, 324 }, // 0x0BD4 -> 14A0
            { 192, 324 }, // 0x0BDA -> 14A2
            { 240, 324 }, // 0x0BE0 -> 14A4
            { 0, 340 }, // 0x1362 -> 14A6
            { 48, 340 }, // 0x1368 -> 14A8
        },
        8
    },
    { // 30
        {
            { 288, 406 }, // 0x32FA -> 14AC
            { 288, 406 }, // 0x32FA -> 14AE
            { 288, 406 }, // 0x32FA -> 14B0
            { 288, 406 }, // 0x32FA -> 14B2
            { 288, 406 }, // 0x32FA -> 14B4
            { 288, 406 }, // 0x32FA -> 14B6
            { 288, 406 }, // 0x32FA -> 14B8
            { 288, 406 }, // 0x32FA -> 14BA
        },
        8
    },
    { // 31
        {
            { 96, 340 }, // 0x136E -> 14BE
            { 144, 340 }, // 0x1374 -> 14C0
            { 192, 340 }, // 0x137A -> 14C2
            { 240, 340 }, // 0x1380 -> 14C4
            { 0, 356 }, // 0x1B02 -> 14C6
            { 48, 356 }, // 0x1B08 -> 14C8
            { 96, 356 }, // 0x1B0E -> 14CA
            { 144, 356 }, // 0x1B14 -> 14CC
        },
        8
    },
    { // 32
        {
            { 0, 276 }, // 0x41EE -> 14D0
            { 48, 276 }, // 0x41F4 -> 14D2
            { 96, 276 }, // 0x41FA -> 14D4
            { 144, 276 }, // 0x4200 -> 14D6
            { 192, 276 }, // 0x4206 -> 14D8
            { 240, 276 }, // 0x420C -> 14DA
            { 0, 292 }, // 0x498E -> 14DC
            { 48, 292 }, // 0x4994 -> 14DE
        },
        8
    },
    { // 33
        {
            { 96, 292 }, // 0x499A -> 14E2
            { 144, 292 }, // 0x49A0 -> 14E4
            { 192, 292 }, // 0x49A6 -> 14E6
            { 240, 292 }, // 0x49AC -> 14E8
            { 0, 308 }, // 0x0422 -> 14EA
            { 48, 308 }, // 0x0428 -> 14EC
            { 96, 308 }, // 0x042E -> 14EE
            { 144, 308 }, // 0x0434 -> 14F0
        },
        8
    },
    { // 34
        {
            { 32, 446 }, // 0x45EA -> 14F4
            { 48, 446 }, // 0x45EC -> 14F6
            { 64, 446 }, // 0x45EE -> 14F8
            { 80, 446 }, // 0x45F0 -> 14FA
            { 96, 446 }, // 0x45F2 -> 14FC
            { 112, 446 }, // 0x45F4 -> 14FE
            { 128, 446 }, // 0x45F6 -> 1500
            { 144, 446 }, // 0x45F8 -> 1502
            { 160, 446 }, // 0x45FA -> 1504
            { 176, 446 }, // 0x45FC -> 1506
            { 192, 446 }, // 0x45FE -> 1508
            { 208, 446 }, // 0x4600 -> 150A
        },
        12
    },
    { // 35
        {
            { 304, 446 }, // 0x460C -> 150E
            { 288, 446 }, // 0x460A -> 1510
            { 272, 446 }, // 0x4608 -> 1512
        },
        3
    },
    { // 36
        {
            { 224, 446 }, // 0x4602 -> 1516
            { 240, 446 }, // 0x4604 -> 1518
            { 256, 446 }, // 0x4606 -> 151A
        },
        3
    },
};

const Point kBugFrameCoordinates[16] = { // binaryData_51582
    { 304, 100 }, // 0x3B40 -> 0x1272
    { 256, 196 }, // 0x1BEE -> 0x1274
    { 272, 196 }, // 0x1BF0 -> 0x1276
    { 288, 196 }, // 0x1BF2 -> 0x1278
    { 304, 196 }, // 0x1BF4 -> 0x127A
    { 288, 196 }, // 0x1BF2 -> 0x127C
    { 272, 196 }, // 0x1BF0 -> 0x127E
    { 288, 196 }, // 0x1BF2 -> 0x1280
    { 304, 196 }, // 0x1BF4 -> 0x1282
    { 288, 196 }, // 0x1BF2 -> 0x1284
    { 272, 196 }, // 0x1BF0 -> 0x1286
    { 256, 196 }, // 0x1BEE -> 0x1288
    { 304, 100 }, // 0x3B40 -> 0x128A
    { 304, 64 }, // 0x2A18 -> 0x128C
    { 304, 64 }, // 0x2A18 -> 0x128E -> this one probably doesn't belong to this array (there are only 14 bug frames according to updateBugTiles)
    { 224, 84 }, // 0x3396 -> 0x1290 -> this is a zonk, probably doesn't belong to this array
};

// Zonk frame coordinates
Point kZonkSlideLeftAnimationFrameCoordinates[8] = { // binaryData_515A4
    { 0, 84 }, // 0x337A -> 0x1294
    { 32, 84 }, // 0x337E -> 0x1296
    { 64, 84 }, // 0x3382 -> 0x1298
    { 96, 84 }, // 0x3386 -> 0x129A
    { 128, 84 }, // 0x338A -> 0x129C
    { 160, 84 }, // 0x338E -> 0x129E
    { 192, 84 }, // 0x3392 -> 0x12A0
    { 224, 84 }, // 0x3396 -> 0x12A2
};

const Point kZonkSlideRightAnimationFrameCoordinates[8] = { // binaryData_515B4
    { 0, 100 }, // 0x3B1A -> 0x12A4
    { 32, 100 }, // 0x3B1E -> 0x12A6
    { 64, 100 }, // 0x3B22 -> 0x12A8
    { 96, 100 }, // 0x3B26 -> 0x12AA
    { 128, 100 }, // 0x3B2A -> 0x12AC
    { 160, 100 }, // 0x3B2E -> 0x12AE
    { 192, 100 }, // 0x3B32 -> 0x12B0
    { 224, 100 }, // 0x3B36 -> 0x12B2
};

const Point kInfotronSlideLeftAnimationFrameCoordinates[8] = {
    { 0, 164 }, // -> 0x0c8e -> 12b6
    { 32, 164 }, // -> 0x0c92 -> 12b8
    { 64, 164 }, // -> 0x0c96 -> 12ba
    { 96, 164 }, // -> 0x0c9a -> 12bc
    { 8, 164 }, // -> 0x0c8f -> 12be
    { 160, 164 }, // -> 0x0ca2 -> 12c0
    { 192, 164 }, // -> 0x0ca6 -> 12c2
    { 224, 164 }, // -> 0x0caa -> 12c4
};

const Point kInfotronSlideRightAnimationFrameCoordinates[8] = {
    { 0, 180 }, // -> 0x142e -> 12c6
    { 32, 180 }, // -> 0x1432 -> 12c8
    { 64, 180 }, // -> 0x1436 -> 12ca
    { 96, 180 }, // -> 0x143a -> 12cc
    { 128, 180 }, // -> 0x143e -> 12ce
    { 160, 180 }, // -> 0x1442 -> 12d0
    { 192, 180 }, // -> 0x1446 -> 12d2
    { 224, 180 }, // -> 0x144a -> 12d4
};

const Point kRegularExplosionAnimationFrameCoordinates[8] = {
    { 0, 196 }, // -> 0x1bce -> 12d6
    { 16, 196 }, // -> 0x1bd0 -> 12d8
    { 32, 196 }, // -> 0x1bd2 -> 12da
    { 48, 196 }, // -> 0x1bd4 -> 12dc
    { 64, 196 }, // -> 0x1bd6 -> 12de
    { 80, 196 }, // -> 0x1bd8 -> 12e0
    { 96, 196 }, // -> 0x1bda -> 12e2
    { 112, 196 }, // -> 0x1bdc -> 12e4
};

const Point kInfotronExplosionAnimationFrameCoordinates[8] = {
    { 128, 196 }, // -> 0x1bde -> 12e6
    { 144, 196 }, // -> 0x1be0 -> 12e8
    { 160, 196 }, // -> 0x1be2 -> 12ea
    { 176, 196 }, // -> 0x1be4 -> 12ec
    { 192, 196 }, // -> 0x1be6 -> 12ee
    { 208, 196 }, // -> 0x1be8 -> 12f0
    { 224, 196 }, // -> 0x1bea -> 12f2
    { 240, 196 }, // -> 0x1bec -> 12f4
};

// Snik snak animations
const Point kSnikSnakAnimationFrameCoordinates[48] = {
    { 192, 388 }, // -> 0x2a5a -> 1388
    { 64, 260 }, // -> 0x3a56 -> 138a
    { 96, 244 }, // -> 0x32ba -> 138c
    { 80, 260 }, // -> 0x3a58 -> 138e
    { 208, 388 }, // -> 0x2a5c -> 1390
    { 96, 260 }, // -> 0x3a5a -> 1392
    { 48, 260 }, // -> 0x3a54 -> 1394
    { 112, 260 }, // -> 0x3a5c -> 1396
    { 192, 388 }, // -> 0x2a5a -> 1398
    { 112, 260 }, // -> 0x3a5c -> 139a
    { 48, 260 }, // -> 0x3a54 -> 139c
    { 96, 260 }, // -> 0x3a5a -> 139e
    { 208, 388 }, // -> 0x2a5c -> 13a0
    { 80, 260 }, // -> 0x3a58 -> 13a2
    { 96, 244 }, // -> 0x32ba -> 13a4
    { 64, 260 }, // -> 0x3a56 -> 13a6
    { 0, 424 }, // -> 0x3b6a -> 13a8
    { 16, 424 }, // -> 0x3b6c -> 13aa
    { 32, 424 }, // -> 0x3b6e -> 13ac
    { 48, 424 }, // -> 0x3b70 -> 13ae
    { 64, 424 }, // -> 0x3b72 -> 13b0
    { 80, 424 }, // -> 0x3b74 -> 13b2
    { 96, 424 }, // -> 0x3b76 -> 13b4
    { 112, 424 }, // -> 0x3b78 -> 13b6
    { 192, 228 }, // -> 0x2b26 -> 13b8
    { 224, 228 }, // -> 0x2b2a -> 13ba
    { 256, 228 }, // -> 0x2b2e -> 13bc
    { 288, 228 }, // -> 0x2b32 -> 13be
    { 0, 244 }, // -> 0x32ae -> 13c0
    { 32, 244 }, // -> 0x32b2 -> 13c2
    { 64, 244 }, // -> 0x32b6 -> 13c4
    { 96, 244 }, // -> 0x32ba -> 13c6
    { 144, 422 }, // -> 0x3a88 -> 13c8
    { 160, 422 }, // -> 0x3a8a -> 13ca
    { 176, 422 }, // -> 0x3a8c -> 13cc
    { 192, 422 }, // -> 0x3a8e -> 13ce
    { 208, 422 }, // -> 0x3a90 -> 13d0
    { 224, 422 }, // -> 0x3a92 -> 13d2
    { 240, 422 }, // -> 0x3a94 -> 13d4
    { 256, 422 }, // -> 0x3a96 -> 13d6
    { 128, 244 }, // -> 0x32be -> 13d8
    { 160, 244 }, // -> 0x32c2 -> 13da
    { 192, 244 }, // -> 0x32c6 -> 13dc
    { 224, 244 }, // -> 0x32ca -> 13de
    { 256, 244 }, // -> 0x32ce -> 13e0
    { 288, 244 }, // -> 0x32d2 -> 13e2
    { 0, 260 }, // -> 0x3a4e -> 13e4
    { 32, 260 }, // -> 0x3a52 -> 13e6
};

// Electron animations
const Point kElectronAnimationFrameCoordinates[48] = {
    { 0, 404 }, // -> 0x31e2 -> 13e8
    { 16, 404 }, // -> 0x31e4 -> 13ea
    { 32, 404 }, // -> 0x31e6 -> 13ec
    { 48, 404 }, // -> 0x31e8 -> 13ee
    { 64, 404 }, // -> 0x31ea -> 13f0
    { 80, 404 }, // -> 0x31ec -> 13f2
    { 96, 404 }, // -> 0x31ee -> 13f4
    { 112, 404 }, // -> 0x31f0 -> 13f6
    { 0, 404 }, // -> 0x31e2 -> 13f8
    { 112, 404 }, // -> 0x31f0 -> 13fa
    { 96, 404 }, // -> 0x31ee -> 13fc
    { 80, 404 }, // -> 0x31ec -> 13fe
    { 64, 404 }, // -> 0x31ea -> 1400
    { 48, 404 }, // -> 0x31e8 -> 1402
    { 32, 404 }, // -> 0x31e6 -> 1404
    { 16, 404 }, // -> 0x31e4 -> 1406
    { 144, 404 }, // -> 0x31f4 -> 1408
    { 160, 404 }, // -> 0x31f6 -> 140a
    { 176, 404 }, // -> 0x31f8 -> 140c
    { 192, 404 }, // -> 0x31fa -> 140e
    { 208, 404 }, // -> 0x31fc -> 1410
    { 224, 404 }, // -> 0x31fe -> 1412
    { 240, 404 }, // -> 0x3200 -> 1414
    { 256, 404 }, // -> 0x3202 -> 1416
    { 0, 372 }, // -> 0x22a2 -> 1418
    { 32, 372 }, // -> 0x22a6 -> 141a
    { 64, 372 }, // -> 0x22aa -> 141c
    { 96, 372 }, // -> 0x22ae -> 141e
    { 128, 372 }, // -> 0x22b2 -> 1420
    { 160, 372 }, // -> 0x22b6 -> 1422
    { 192, 372 }, // -> 0x22ba -> 1424
    { 224, 372 }, // -> 0x22be -> 1426
    { 0, 402 }, // -> 0x30ee -> 1428
    { 16, 402 }, // -> 0x30f0 -> 142a
    { 32, 402 }, // -> 0x30f2 -> 142c
    { 48, 402 }, // -> 0x30f4 -> 142e
    { 64, 402 }, // -> 0x30f6 -> 1430
    { 80, 403 }, // -> 0x3172 -> 1432
    { 96, 403 }, // -> 0x3174 -> 1434
    { 112, 402 }, // -> 0x30fc -> 1436
    { 256, 372 }, // -> 0x22c2 -> 1438
    { 288, 372 }, // -> 0x22c6 -> 143a
    { 0, 388 }, // -> 0x2a42 -> 143c
    { 32, 388 }, // -> 0x2a46 -> 143e
    { 64, 388 }, // -> 0x2a4a -> 1440
    { 96, 388 }, // -> 0x2a4e -> 1442
    { 128, 388 }, // -> 0x2a52 -> 1444
    { 160, 388 }, // -> 0x2a56 -> 1446
};
