/************************************************************/
/*                                                          */
/* Module ID  - hcptest.                                    */
/*                                                          */
/* Function   - Execute a CP command and display message    */
/*              using a small buffer to test file pointer   */
/*              logic in the device driver.                 */
/*                                                          */
/* Called By  - N/A.                                        */
/*                                                          */
/* Calling To - N/A.                                        */
/*                                                          */
/* Parameters - (1) Command.                                */
/*              DESCRIPTION: Command to be executed.        */
/*                                                          */
/* Notes      - (1) Uses /dev/cpcmdx to communicate with CP */
/*                                                          */
/*              (2) ....................................... */
/*                                                          */
/*                                                          */
/* Name       - Neale Ferguson.                             */
/*                                                          */
/* Date       - August, 2005.                               */
/*                                                          */
/*                                                          */
/* Associated    - (1) Refer To ........................... */
/* Documentation                                            */
/*                 (2) Refer To ........................... */
/*                                                          */
/************************************************************/

/************************************************************/
/*                                                          */
/*                     DEFINES                              */
/*                     -------                              */
/*                                                          */
/************************************************************/

#define CPDEV 		"/dev/cpcmd"
#define RSPSIZE 	8192
#define CMDSIZE		512

/*=============== End of Defines ===========================*/

/************************************************************/
/*                                                          */
/*              INCLUDE STATEMENTS                          */
/*              ------------------                          */
/*                                                          */
/************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <linux/ioctl.h>

/*================== End of Include Statements =============*/

/************************************************************/
/*                                                          */
/*              TYPE DEFINITIONS                            */
/*              ----------------                            */
/*                                                          */
/************************************************************/

/* Use 'k' as magic number */
#define CPCMD_IOC_MAGIC  'k'

#define CPCMD_IOCRESET    _IO(CPCMD_IOC_MAGIC, 0)
#define CPIOCRC           _IOR(CPCMD_IOC_MAGIC, 1, int)

/*================== End of Type Definitions ===============*/

/************************************************************/
/*                                                          */
/*             FUNCTION PROTOTYPES                          */
/*             -------------------                          */
/*                                                          */
/************************************************************/

/*================== End of Prototypes =====================*/

/************************************************************/
/*                                                          */
/*           GLOBAL VARIABLE DECLARATIONS                   */
/*           ----------------------------                   */
/*                                                          */
/************************************************************/

static const char xTable[256] =
    { 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x0a, 0x20, 0x20, 0x0d, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
	0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
	0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
	0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
	0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
	0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
	0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
	0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
	0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
	0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
	0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
	0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
	0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
	0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
	0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
	0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
	0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF
};

/*============== End of Variable Declarations ==============*/

/************************************************************/
/*                                                          */
/* Name       - main.                                       */
/*                                                          */
/* Function   - Open the CP command device.                 */
/*                                                          */
/* Parameters - inode -                                     */
/*              filp  -                                     */
/*                                                          */
/************************************************************/

int
main(int argc, char **argv)
{
	int fd, rc, l_command, i_arg, exitRc = 0;
	char *response, *command;

	if (argc < 2) {
		exitRc = -1;
		fprintf(stderr, "Correct form: hcp <command>\n");
	} else {
		response = malloc(RSPSIZE);
		command = malloc(CMDSIZE);
		command[0] = 0;
		for (i_arg = 1;
		     strlen((const char *) command) < CMDSIZE && i_arg < argc;
		     i_arg++) {
			l_command = CMDSIZE - strlen(command) - 2;
			strncat(command, argv[i_arg], l_command);
			l_command += 2;
			strncat(command, " ", l_command);
		}
		fd = open(CPDEV, O_RDWR);
		if (fd >= 0) {
			rc = write(fd, command, strlen(command));
			if (rc >= 0) {
				rc = read(fd, response, 10);
				while (rc > 0) {
		/*--------------------------------------------------*/
					/* Translate non-printable characters               */
		/*--------------------------------------------------*/
#ifdef __s390x__
				      __asm__("   lg	  1,%1\n" "   lghi 0,0\n" "   la   2,%0\n" "   lgr  4,2\n" "   lgfr 3,%2\n" "0: troo 2,4\n" "   jnz  0b\n":"+m"(response
					     [0])
				      :	"m"(xTable),
						"r"
						(rc)
				      :	"cc", "0", "1", "2", "3",
						"4");
#else
					int i_c;

					for (i_c = 0; i_c < rc; i_c++)
						response[i_c] =
						    xTable[response[i_c]];
# if 0
				      __asm__("   l 	  1,%1\n" "   lhi  0,0\n" "   la   2,%0\n" "   lr   4,2\n" "   lr   3,%2\n" "0: troo 2,4\n" "   jnz  0b\n":"+m"(response
					     [0])
				      :	"m"(xTable),
						"r"
						(rc)
				      :	"cc", "0", "1", "2", "3",
						"4");
# endif
#endif

					response[rc] = 0;
					printf("%s", response);
					rc = read(fd, response, 10);
				}
				if (rc < 0) {
					exitRc = errno;
					fprintf(stderr, "Read: %s\n",
						strerror(errno));
				}
				rc = ioctl(fd, CPIOCRC, &exitRc);
				if (rc != 0) {
					exitRc = errno;
					fprintf(stderr, "Ioctl: %s\n",
						strerror(errno));
				}
			} else {
				exitRc = errno;
				fprintf(stderr, "Write: %s\n", strerror(errno));
			}
		} else {
			exitRc = errno;
			fprintf(stderr, "Open: %s\n", strerror(errno));
		}
		close(fd);
		free(command);
		free(response);
	}
	exit(exitRc);
}

/*===================== End of Function ====================*/
