/*
 * cpcmd.h -- definitions for the char module
 *
 *********/

#include <linux/ioctl.h>

/*
 * Macros to help debugging
 */

#undef PDEBUG			/* undef it, just in case */
#ifdef CPCMD_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "cpcmd: " fmt, ## args)
#  else
     /* This one for user space */
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...)	/* not debugging: nothing */
#endif

#undef PDEBUGG
#define PDEBUGG(fmt, args...)	/* nothing: it's a placeholder */

#ifndef CPRESP
# define CPRESP 8192		/* Default length of CP response */
#endif

#ifndef CPRSPLIM
# define CPRSPLIM 65536		/* Maximum response length       */
#endif

typedef struct CPCmd_Dev {
	char cmd[240];		/* The CP command                 */
	char *data;		/* CP command response buffer     */
	CPInt_Dev *dev;		/* Pointer to the base device     */
	unsigned long count;	/* Length of the command          */
	unsigned long size;	/* Length of the response         */
	int rc;			/* Return code from CP command    */
	int flag;		/* Options flag                   */
#define UPCASE 0x80		/* Only command is uppercased     */
} CPCmd_Dev;

#ifndef min
#  define min(a,b) ((a)<(b) ? (a) : (b))
#endif

/*
 * Ioctl definitions
 */

/* Use 'k' as magic number */
#define CPCMD_IOC_MAGIC  'k'

#define CPCMD_IOCRESET    _IO(CPCMD_IOC_MAGIC, 0)
#define CPIOCRC		  _IOR(CPCMD_IOC_MAGIC, 1, int)
#define CPIOUPC		  _IO(CPCMD_IOC_MAGIC, 0)

/*
 * S means "Set" through a ptr,
 * T means "Tell" directly with the argument value
 * G means "Get": reply by setting through a pointer
 * Q means "Query": response is on the return value
 * X means "eXchange": G and S atomically
 * H means "sHift": T and Q atomically
 */

/* ... more to come */

#define CPCMD_IOCHARDRESET _IO(CPCMD_IOC_MAGIC, 1)	/* debugging tool */

#define CPCMD_IOC_MAXNR 1
