/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;

/**
 * CloseAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class CloseAction extends AbstractAction {

  private static final long serialVersionUID = 3062727121744152842L;

  public CloseAction() {
    super(Messages.getString("CloseAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/Hide.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    int result = JOptionPane.OK_OPTION;
    // check parkspace
    if (ChannelEditor.application.getChannelParkingPanel().getListSize() > 0) {
      result = JOptionPane
          .showConfirmDialog(
                             ChannelEditor.application,
                             Messages.getString("CloseAction.2"), //$NON-NLS-1$
                             Messages.getString("CloseAction.3"), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE); //$NON-NLS-1$
      if (result == JOptionPane.NO_OPTION) { return; }
    }
    // check if dokument saved
    if (ChannelEditor.application.isModified()) {
      // dialogbox to warn unsaved data
      result = JOptionPane.showConfirmDialog(ChannelEditor.application,
                                             Messages.getString("CloseAction.4"), Messages.getString("CloseAction.5"), //$NON-NLS-1$ //$NON-NLS-2$
                                             JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
      if (result == JOptionPane.NO_OPTION) { return; }
    }
    System.exit(0);
  }

}
