/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor;

import javax.swing.JPanel;

import javax.swing.JLabel;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.swing.JTextField;

/**
 * TestPanel
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class TestPanel extends JPanel {

  private static final long serialVersionUID = -811157591331944973L;
  private JLabel jLabel = null;
  private JTextField jTextField = null;
  private JLabel jLabel1 = null;

  /**
   * This is the default constructor
   */
  public TestPanel() {
    super();
    initialize();
  }

  /**
   * This method initializes this
   * 
   * @return void
   */
  private void initialize() {
    jLabel1 = new JLabel();
    jLabel = new JLabel();
    GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
    GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
    GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
    this.setLayout(new GridBagLayout());
    this.setSize(388, 200);
    jLabel.setText("JLabel"); //$NON-NLS-1$
    jLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel.setComponentOrientation(java.awt.ComponentOrientation.LEFT_TO_RIGHT);
    gridBagConstraints2.gridx = 0;
    gridBagConstraints2.gridy = 0;
    gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints2.insets = new java.awt.Insets(10, 10, 0, 5);
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 0;
    gridBagConstraints3.weightx = 1.0;
    gridBagConstraints3.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints3.insets = new java.awt.Insets(10, 0, 0, 10);
    gridBagConstraints4.gridx = 0;
    gridBagConstraints4.gridy = 7;
    gridBagConstraints4.insets = new java.awt.Insets(0, 0, 10, 0);
    gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
    jLabel1.setText("x"); //$NON-NLS-1$
    this.add(jLabel, gridBagConstraints2);
    this.add(jLabel1, gridBagConstraints4);
    gridBagConstraints3.gridwidth = 5;
    this.add(getJTextField(), gridBagConstraints3);
  }

  /**
   * This method initializes jTextField
   * 
   * @return javax.swing.JTextField
   */
  private JTextField getJTextField() {
    if (jTextField == null) {
      jTextField = new JTextField();
      jTextField.setPreferredSize(new java.awt.Dimension(400, 20));
    }
    return jTextField;
  }
} // @jve:decl-index=0:visual-constraint="30,13"
