/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import de.renier.vdr.channel.editor.util.Utils;

/**
 * ChannelSearchInputDialog
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ChannelSearchInputDialog extends JDialog {

  private static final long serialVersionUID = -3517415886906951759L;
  public final static int RESULT_SEARCH = 1;
  public final static int RESULT_CANCEL = 0;

  private javax.swing.JPanel jContentPane = null;
  private JPanel jPanel = null;
  private JPanel jPanel1 = null;
  private JButton searchButton = null;
  private JButton cancelButton = null;
  private JLabel jLabel = null;
  private JLabel jLabel1 = null;
  private JLabel jLabel2 = null;
  private JLabel jLabel3 = null;
  private JLabel jLabel4 = null;
  private JLabel jLabel5 = null;
  private JLabel jLabel6 = null;
  private JTextField searchTextField = null;
  private JCheckBox frequenzCheckBox = null;
  private JCheckBox parameterCheckBox = null;
  private JCheckBox sourceCheckBox = null;
  private JCheckBox symbolrateCheckBox = null;
  private JLabel jLabel7 = null;
  private JCheckBox pidfieldsCheckBox = null;
  private int result = 0;
  private SearchFilter searchFilter = null;

  private JLabel jLabel8 = null;
  private JCheckBox nameCheckBox = null;
  private JLabel jLabel9 = null;
  private JCheckBox bouqetCheckBox = null;

  /**
   * This is the default constructor
   */
  public ChannelSearchInputDialog(Frame frame) {
    super(frame, true);
    initialize();
    // center dialog
    if (frame != null) {
      Point p = frame.getLocation();
      Dimension frameDim = frame.getSize();
      Dimension ownDim = this.getSize();
      this.setLocation((int) p.getX() + ((int) (frameDim.getWidth() - ownDim.getWidth()) / 2), (int) p.getY()
          + ((int) (frameDim.getHeight() - ownDim.getHeight()) / 2));
    }
  }

  /**
   * This method initializes this
   * 
   * @return void
   */
  private void initialize() {
    this.setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    this.setTitle(Messages.getString("ChannelSearchInputDialog.0")); //$NON-NLS-1$
    this.setSize(400, 282);
    this.setContentPane(getJContentPane());
  }

  /**
   * This method initializes jContentPane
   * 
   * @return javax.swing.JPanel
   */
  private javax.swing.JPanel getJContentPane() {
    if (jContentPane == null) {
      jContentPane = new javax.swing.JPanel();
      jContentPane.setLayout(new java.awt.BorderLayout());
      jContentPane.add(getJPanel(), java.awt.BorderLayout.SOUTH);
      jContentPane.add(getJPanel1(), java.awt.BorderLayout.CENTER);
    }
    return jContentPane;
  }

  /**
   * This method initializes jPanel
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJPanel() {
    if (jPanel == null) {
      jPanel = new JPanel();
      jPanel.add(getSearchButton(), null);
      jPanel.add(getCancelButton(), null);
    }
    return jPanel;
  }

  /**
   * This method initializes jPanel1
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJPanel1() {
    if (jPanel1 == null) {
      jLabel9 = new JLabel();
      GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
      jLabel8 = new JLabel();
      jLabel7 = new JLabel();
      jLabel6 = new JLabel();
      jLabel5 = new JLabel();
      jLabel4 = new JLabel();
      jLabel3 = new JLabel();
      jLabel2 = new JLabel();
      jLabel1 = new JLabel();
      jLabel = new JLabel();
      GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
      GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
      jPanel1 = new JPanel();
      jPanel1.setLayout(new GridBagLayout());
      gridBagConstraints1.gridx = 0;
      gridBagConstraints1.gridy = 0;
      gridBagConstraints1.gridwidth = 6;
      gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jLabel
          .setText(Messages.getString("ChannelSearchInputDialog.1")); //$NON-NLS-1$
      jLabel.setForeground(java.awt.Color.gray);
      gridBagConstraints2.gridx = 0;
      gridBagConstraints2.gridy = 1;
      gridBagConstraints2.insets = new java.awt.Insets(0, 10, 0, 5);
      jLabel1.setText(Messages.getString("ChannelSearchInputDialog.2")); //$NON-NLS-1$
      gridBagConstraints3.gridx = 0;
      gridBagConstraints3.gridy = 2;
      gridBagConstraints3.gridwidth = 6;
      gridBagConstraints3.insets = new java.awt.Insets(10, 5, 5, 5);
      gridBagConstraints3.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jLabel2.setText(Messages.getString("ChannelSearchInputDialog.3")); //$NON-NLS-1$
      jLabel2.setForeground(java.awt.Color.gray);
      jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
      gridBagConstraints4.gridx = 4;
      gridBagConstraints4.gridy = 3;
      gridBagConstraints4.insets = new java.awt.Insets(0, 0, 0, 5);
      gridBagConstraints4.anchor = java.awt.GridBagConstraints.EAST;
      jLabel3.setText(Messages.getString("ChannelSearchInputDialog.4")); //$NON-NLS-1$
      gridBagConstraints5.gridx = 2;
      gridBagConstraints5.gridy = 5;
      gridBagConstraints5.insets = new java.awt.Insets(0, 0, 0, 5);
      gridBagConstraints5.anchor = java.awt.GridBagConstraints.EAST;
      jLabel4.setText(Messages.getString("ChannelSearchInputDialog.5")); //$NON-NLS-1$
      gridBagConstraints6.gridx = 0;
      gridBagConstraints6.gridy = 5;
      gridBagConstraints6.insets = new java.awt.Insets(0, 0, 0, 5);
      gridBagConstraints6.anchor = java.awt.GridBagConstraints.EAST;
      jLabel5.setText(Messages.getString("ChannelSearchInputDialog.6")); //$NON-NLS-1$
      gridBagConstraints7.gridx = 4;
      gridBagConstraints7.gridy = 5;
      gridBagConstraints7.insets = new java.awt.Insets(0, 0, 0, 5);
      gridBagConstraints7.anchor = java.awt.GridBagConstraints.EAST;
      jLabel6.setText(Messages.getString("ChannelSearchInputDialog.7")); //$NON-NLS-1$
      gridBagConstraints8.gridx = 1;
      gridBagConstraints8.gridy = 1;
      gridBagConstraints8.weightx = 1.0;
      gridBagConstraints8.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints8.insets = new java.awt.Insets(0, 0, 0, 10);
      gridBagConstraints8.gridwidth = 5;
      gridBagConstraints10.gridx = 5;
      gridBagConstraints10.gridy = 3;
      gridBagConstraints10.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints10.insets = new java.awt.Insets(0, 0, 0, 10);
      gridBagConstraints11.gridx = 3;
      gridBagConstraints11.gridy = 5;
      gridBagConstraints11.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints11.insets = new java.awt.Insets(0, 0, 0, 10);
      gridBagConstraints12.gridx = 1;
      gridBagConstraints12.gridy = 5;
      gridBagConstraints12.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints12.insets = new java.awt.Insets(0, 0, 0, 10);
      gridBagConstraints13.gridx = 5;
      gridBagConstraints13.gridy = 5;
      gridBagConstraints13.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints13.insets = new java.awt.Insets(0, 0, 0, 10);
      gridBagConstraints14.gridx = 0;
      gridBagConstraints14.gridy = 6;
      gridBagConstraints14.insets = new java.awt.Insets(0, 0, 0, 5);
      gridBagConstraints14.anchor = java.awt.GridBagConstraints.EAST;
      jLabel7.setText(Messages.getString("ChannelSearchInputDialog.8")); //$NON-NLS-1$
      gridBagConstraints15.gridx = 1;
      gridBagConstraints15.gridy = 6;
      gridBagConstraints15.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints15.insets = new java.awt.Insets(0, 0, 0, 10);
      jPanel1.setBorder(javax.swing.BorderFactory
          .createTitledBorder(null, Messages.getString("ChannelSearchInputDialog.9"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, //$NON-NLS-1$
                              javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
      gridBagConstraints16.gridx = 0;
      gridBagConstraints16.gridy = 3;
      gridBagConstraints16.insets = new java.awt.Insets(0, 0, 0, 5);
      gridBagConstraints16.anchor = java.awt.GridBagConstraints.EAST;
      jLabel8.setText(Messages.getString("ChannelSearchInputDialog.10")); //$NON-NLS-1$
      gridBagConstraints17.gridx = 1;
      gridBagConstraints17.gridy = 3;
      gridBagConstraints17.insets = new java.awt.Insets(0, 0, 0, 10);
      gridBagConstraints17.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints18.gridx = 2;
      gridBagConstraints18.gridy = 3;
      gridBagConstraints18.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints18.insets = new java.awt.Insets(0, 0, 0, 5);
      jLabel9.setText(Messages.getString("ChannelSearchInputDialog.11")); //$NON-NLS-1$
      gridBagConstraints21.gridx = 3;
      gridBagConstraints21.gridy = 3;
      gridBagConstraints21.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints21.insets = new java.awt.Insets(0, 0, 0, 10);
      jPanel1.add(jLabel, gridBagConstraints1);
      jPanel1.add(jLabel1, gridBagConstraints2);
      jPanel1.add(jLabel2, gridBagConstraints3);
      jPanel1.add(jLabel3, gridBagConstraints4);
      jPanel1.add(jLabel4, gridBagConstraints5);
      jPanel1.add(jLabel5, gridBagConstraints6);
      jPanel1.add(jLabel6, gridBagConstraints7);
      jPanel1.add(getSearchTextField(), gridBagConstraints8);
      jPanel1.add(getFrequenzCheckBox(), gridBagConstraints10);
      jPanel1.add(getParameterCheckBox(), gridBagConstraints11);
      jPanel1.add(getSourceCheckBox(), gridBagConstraints12);
      jPanel1.add(getSymbolrateCheckBox(), gridBagConstraints13);
      jPanel1.add(jLabel7, gridBagConstraints14);
      jPanel1.add(getPidfieldsCheckBox(), gridBagConstraints15);
      jPanel1.add(jLabel8, gridBagConstraints16);
      jPanel1.add(getNameCheckBox(), gridBagConstraints17);
      jPanel1.add(jLabel9, gridBagConstraints18);
      jPanel1.add(getBouqetCheckBox(), gridBagConstraints21);
    }
    return jPanel1;
  }

  /**
   * This method initializes jButton
   * 
   * @return javax.swing.JButton
   */
  private JButton getSearchButton() {
    if (searchButton == null) {
      searchButton = new JButton();
      searchButton.setText(Messages.getString("ChannelSearchInputDialog.12")); //$NON-NLS-1$
      searchButton.setIcon(new ImageIcon(getClass().getResource("/org/javalobby/icons/20x20/DocumentMag.gif"))); //$NON-NLS-1$
      searchButton.addActionListener(new java.awt.event.ActionListener() {

        public void actionPerformed(java.awt.event.ActionEvent e) {
          // check empty search field
          if (Utils.isEmpty(searchTextField.getText())) {
            JOptionPane.showMessageDialog(ChannelSearchInputDialog.this, Messages.getString("ChannelSearchInputDialog.14")); //$NON-NLS-1$
            return;
          }
          // check empty checkboxes
          if (!nameCheckBox.isSelected() && !bouqetCheckBox.isSelected() && !frequenzCheckBox.isSelected()
              && !parameterCheckBox.isSelected() && !sourceCheckBox.isSelected() && !symbolrateCheckBox.isSelected()
              && !pidfieldsCheckBox.isSelected()) {
            JOptionPane.showMessageDialog(ChannelSearchInputDialog.this,
                                          Messages.getString("ChannelSearchInputDialog.15")); //$NON-NLS-1$
            return;
          }
          // set results
          result = RESULT_SEARCH;
          // set searchfilter
          searchFilter = new SearchFilter();
          searchFilter.setSearchText(searchTextField.getText());
          searchFilter.setName(nameCheckBox.isSelected());
          searchFilter.setBouqet(bouqetCheckBox.isSelected());
          searchFilter.setFrequenz(frequenzCheckBox.isSelected());
          searchFilter.setParameter(parameterCheckBox.isSelected());
          searchFilter.setSource(sourceCheckBox.isSelected());
          searchFilter.setSymbolrate(symbolrateCheckBox.isSelected());
          searchFilter.setPidfields(pidfieldsCheckBox.isSelected());
          setVisible(false);
          dispose();
        }
      });
    }
    return searchButton;
  }

  /**
   * This method initializes jButton1
   * 
   * @return javax.swing.JButton
   */
  private JButton getCancelButton() {
    if (cancelButton == null) {
      cancelButton = new JButton();
      cancelButton.setText(Messages.getString("ChannelSearchInputDialog.16")); //$NON-NLS-1$
      cancelButton.setIcon(new ImageIcon(getClass().getResource("/org/javalobby/icons/20x20/Stop.gif"))); //$NON-NLS-1$
      cancelButton.addActionListener(new java.awt.event.ActionListener() {

        public void actionPerformed(java.awt.event.ActionEvent e) {
          result = RESULT_CANCEL;
          setVisible(false);
          dispose();
        }
      });
    }
    return cancelButton;
  }

  /**
   * This method initializes jTextField
   * 
   * @return javax.swing.JTextField
   */
  private JTextField getSearchTextField() {
    if (searchTextField == null) {
      searchTextField = new JTextField();
    }
    return searchTextField;
  }

  /**
   * This method initializes jCheckBox
   * 
   * @return javax.swing.JCheckBox
   */
  private JCheckBox getFrequenzCheckBox() {
    if (frequenzCheckBox == null) {
      frequenzCheckBox = new JCheckBox();
    }
    return frequenzCheckBox;
  }

  /**
   * This method initializes jCheckBox1
   * 
   * @return javax.swing.JCheckBox
   */
  private JCheckBox getParameterCheckBox() {
    if (parameterCheckBox == null) {
      parameterCheckBox = new JCheckBox();
    }
    return parameterCheckBox;
  }

  /**
   * This method initializes jCheckBox2
   * 
   * @return javax.swing.JCheckBox
   */
  private JCheckBox getSourceCheckBox() {
    if (sourceCheckBox == null) {
      sourceCheckBox = new JCheckBox();
    }
    return sourceCheckBox;
  }

  /**
   * This method initializes jCheckBox3
   * 
   * @return javax.swing.JCheckBox
   */
  private JCheckBox getSymbolrateCheckBox() {
    if (symbolrateCheckBox == null) {
      symbolrateCheckBox = new JCheckBox();
    }
    return symbolrateCheckBox;
  }

  /**
   * This method initializes jCheckBox4
   * 
   * @return javax.swing.JCheckBox
   */
  private JCheckBox getPidfieldsCheckBox() {
    if (pidfieldsCheckBox == null) {
      pidfieldsCheckBox = new JCheckBox();
    }
    return pidfieldsCheckBox;
  }

  /**
   * showSearchDialog
   * 
   * @return
   */
  public int showSearchDialog(String lastText) {
    if (lastText != null) {
      searchTextField.setText(lastText);
    }
    setVisible(true);
    return result;
  }

  public SearchFilter getSearchFilter() {
    return this.searchFilter;
  }

  /**
   * This method initializes jCheckBox
   * 
   * @return javax.swing.JCheckBox
   */
  private JCheckBox getNameCheckBox() {
    if (nameCheckBox == null) {
      nameCheckBox = new JCheckBox();
      nameCheckBox.setSelected(true);
    }
    return nameCheckBox;
  }

  /**
   * This method initializes jCheckBox
   * 
   * @return javax.swing.JCheckBox
   */
  private JCheckBox getBouqetCheckBox() {
    if (bouqetCheckBox == null) {
      bouqetCheckBox = new JCheckBox();
    }
    return bouqetCheckBox;
  }
} // @jve:decl-index=0:visual-constraint="10,10"
