/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import org.jmock.expectation.AbstractExpectation;
import org.jmock.expectation.Null;

public class ExpectationValue
extends AbstractExpectation {
    private Object myExpectedValue;
    private Object myActualValue;

    public ExpectationValue(String name) {
        super(name);
        this.clearActual();
    }

    public void clearActual() {
        this.myActualValue = new Null("Nothing");
    }

    public void setActual(int aValue) {
        this.setActual(new Integer(aValue));
    }

    public void setActual(long aValue) {
        this.setActual(new Long(aValue));
    }

    public void setActual(double aValue) {
        this.setActual(new Double(aValue));
    }

    public void setActual(Object aValue) {
        this.myActualValue = aValue;
        if (this.shouldCheckImmediately()) {
            this.verify();
        }
    }

    public void setActual(boolean aValue) {
        this.setActual(new Boolean(aValue));
    }

    public void setExpected(int aValue) {
        this.setExpected(new Integer(aValue));
    }

    public void setExpected(long aValue) {
        this.setExpected(new Long(aValue));
    }

    public void setExpected(double aValue) {
        this.setExpected(new Double(aValue));
    }

    public void setExpected(Object aValue) {
        this.myExpectedValue = aValue;
        this.setHasExpectations();
    }

    public void setExpected(boolean aValue) {
        this.setExpected(new Boolean(aValue));
    }

    public void setExpectNothing() {
        this.setExpected(new Null("Nothing"));
        this.myActualValue = this.myExpectedValue;
    }

    public void verify() {
        this.assertEquals("did not receive the expected Value.", this.myExpectedValue, this.myActualValue);
    }
}

