// Copyright 2022 The Prometheus Authors
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import { isPrometheusClient } from './index';
import { HTTPPrometheusClient } from '../client/prometheus';

describe('type of remoteConfig', () => {
  it('should be a prometheusClient', () => {
    const client = new HTTPPrometheusClient({});
    expect(isPrometheusClient(client)).toBe(true);
  });

  it('should be a remote config', () => {
    const remote = { url: 'https://prometheus.io' };
    expect(isPrometheusClient(remote)).toBe(false);
  });
});
