/*  job_verifysameterms.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_VERIFYTERMS_H_
#define JOB_VERIFYTERMS_H_

#include "job.h"

namespace Reduze {

/// Job to verify two files contain the same terms
class VerifySameTerms: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("verify_same_terms");
		s.set_short_description("Verifies two files contain the same terms.");
		s.set_long_description(""//
					"Job to verify two files contain the same linear combinations"
					" or equations. It ignores name mismatches for linear"
					" combinations and different normalizations for equations."
					" Will abort on mismatch.");
		s.add_option("input_file1", true, "string", "Name of first input file.");
		s.add_option("input_file2", true, "string",
				"Name of second input file.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	VerifySameTerms() {
		add_auto_options();
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_file1", input_filename1_);
		add_auto_io("input_file2", input_filename2_);
	}
	virtual void init();
private:
	std::string input_filename1_, input_filename2_;
};

}

#endif /* JOB_VERIFYTERMS_H_ */
