/*  job_sumterms.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "job_sumterms.h"
#include "functions.h"
#include "equation.h"
#include "files.h"
#include "filedata.h"

using namespace std;

namespace Reduze {

// register job types at JobFactory
namespace {
JobProxy<SumTerms> dummy;
}

bool SumTerms::find_dependencies(const set<string>& outothers,//
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	//find_dependencies_all_sectormappings(outothers, in, auxjobs);
	in.push_back(input_file_);
	out.push_back(output_file_);
	return true;
}

std::string SumTerms::get_description() const {
	return string("sum terms in ") + short_filename(input_file_);
}

void SumTerms::run_serial() {
	Timer timer_all;

	OutFileLinearCombinations out(output_file_.c_str());

	LOG("Reading file " << input_file_);
	bool have_eqs = InFileEquations::check_filetype(input_file_);
	InFileLinearCombinations in(input_file_.c_str());
	LinearCombination sum, l;
	while (in.get(l)) {
		bool normalize = false;
		for (LinearCombination::const_iterator t = l.begin(); t != l.end(); ++t)
			sum.insert(t->first, t->second, normalize);
	}
	if (have_eqs) {
		Identity eq;
		eq.swap_terms(sum);
		eq.solve();
		eq.swap_terms(sum);
	} else {
		sum.set_name("SUM" + to_safe_variable_name(input_file_));
	}
	in.close();

	LOG("Writing result to '" + output_file_ + "'");
	out << sum;
	out.finalize();

	LOG("Time to process amplitudes: " << timer_all.get_wall_time() << " s");
}

void SumTerms::init() {
	if (input_file_.empty() || output_file_.empty())
		throw runtime_error("no valid input or output file defined");
}

}
