/*  job_printreductioninfo.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_PRINTREDUCTIONINFO_H_
#define JOB_PRINTREDUCTIONINFO_H_

#include "job.h"
#include "sector.h"
#include <map>

namespace Reduze {

class RSPoint;
class RSFiniteGenericSelection;
class INT;

/// Job to analyze a file with reductions
class PrintReductionInfoFile: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("print_reduction_info_file");
		s.set_short_description("Analyzes reductions in a file.");
		s.set_long_description(""//
					"Job to analyze reductions contained in a file.");
		s.add_option("input_file", true, "string", ""//
					"Input file name."
					" File must contain identities in Reduze format.");
		s.add_option("check_for_masters", false, ""//
					"sequence of rs_finite_generic_selection", ""//
					"r-s regions to focus on for counting number of master integral"
					" candidates.");
		s.add_option("masters_file", false, "string", ""//
					"Output file name. If check_for_masters is true, all"//
					" right hand side integrals in considered range are"//
					" written to this file.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	PrintReductionInfoFile() {
		add_auto_options();
	}
	virtual ~PrintReductionInfoFile() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_file);
		add_auto_io("check_for_masters", check_for_masters);
		add_auto_io("masters_file", masters_file);
	}
	virtual void init();
public:
	//friend class PrintReductionInfoSectors;
	void search_masters(
			const Sector& sector,//
			const std::map<RSPoint, int>& num_unreduced,
			const std::set<INT>& rhsints) const;
	std::string input_file, masters_file;
	std::list<RSFiniteGenericSelection> check_for_masters;
};

/// Job to analyze reductions for a sector
class PrintReductionInfoSectors: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("print_reduction_info_sectors");
		s.set_short_description("Analyzes reductions available for sectors.");
		s.set_long_description(""//
					"Job to analyze reductions available for given sectors.");
		s.add_option("sector_selection", true, "sector_selection", ""//
					"Selection of sectors to analyze.");
		s.add_option("check_for_masters", false, ""//
					"sequence of rs_finite_generic_selection", ""//
					"r-s regions to focus on for counting number of master integral"
					" candidates.");
		s.add_option("masters_file_prefix", false, "string", ""//
					"A prefix for the path of files where right-hand side"//
					" integrals are written to. This option options will work"//
					" only if check_for_masters is specified.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	PrintReductionInfoSectors() {
		add_auto_options();
	}
	virtual ~PrintReductionInfoSectors() {
	}
	virtual void run_serial() {
	}
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
		add_auto_io("sector_selection", sector_selection);
		add_auto_io("check_for_masters", check_for_masters);
		add_auto_io("masters_file_prefix", masters_file_prefix);
	}
private:
	SectorSelection sector_selection;
	std::list<RSFiniteGenericSelection> check_for_masters;
	std::string masters_file_prefix;
};

}

#endif /* JOB_PRINTREDUCTIONINFO_H_ */
