/*  job_printintegralinfo.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "job_printintegralinfo.h"
#include <sstream>
#include "functions.h"
#include "int.h"
#include "sector.h"
#include "filedata.h"
#include "files.h"
#include "../yaml/include/yaml.h"
#include "topology.h"
#include "graph.h"
#include "kinematics.h"

using namespace std;

namespace Reduze {

namespace {
JobProxy<PrintIntegralInfo> dummy;
}

bool PrintIntegralInfo::find_dependencies(const set<string>& outothers,//
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	return true;
}

void PrintIntegralInfo::init() {
}

std::string PrintIntegralInfo::get_description() const {
	return "print integral info";
}

void PrintIntegralInfo::run_serial() {
	using namespace YAML;
	using namespace GiNaC;
	InFileINTs intfile(input_file_);
	LOG("generating loopedia file '" << loopedia_file_ << "'");
	ofstream loopedia(loopedia_file_.c_str());
	if (!loopedia)
		ERROR("can't open output file `" << loopedia_file_ << "'");
	list<INT> ints;
	intfile.get_all(ints);
	intfile.close();
	map<Sector, int> nints;
	for (list<INT>::const_iterator i = ints.begin(); i != ints.end(); ++i) {
//		if (i->get_sector().get_uncrossed() != i->get_sector()) {
//			cout << "ignoring crossed sector " << i->get_sector() << endl;
//			continue;
//		}
		++nints[i->get_sector()];
	}
	LOG("found " << ints.size() << " integrals from " << nints.size()
			<< " sectors in file '" << input_file_ << "'");
	//for (set<INT>::const_iterator i = ints.begin(); i != ints.end(); ++i) {
	map<string, list<Sector> > equiv;
	map<Sector, string> entry;
	for (map<Sector, int>::const_iterator ni = nints.begin(); ni != nints.end(); ++ni) {
		const Sector& sector = ni->first;
		LOG("sector " << sector);
		//INT i(sector);

		SectorGraph graph;
		bool det_non_zero;
		if (!sector.find_graph(graph, det_non_zero, false))
			ERROR("can't construct graph for " << sector);
		//comment out since new convention in Loopedia: keep products
		//LOG("  analyzing biconnected components of vacuum topology");
		//Topology vacuum = graph;
		//vacuum.remove_external_legs();
		//if (vacuum.biconnected_components().size() != 1) {
		//	LOG("  is factorizable, skip it");
		//	continue;
		//}

		//LOG("  merging multiple legs entering same vertex");
		graph.merge_external_legs();
		//graph.print_dot("bla/" + safe_filename(ss.str())+"merged.dot");

		//LOG("  generating YAML output");
		//ye << Key << "name" << DoubleQuoted << Value << ss.str();

		list<Edge> eedges = graph.external_edges();
		list<Edge> iedges = graph.internal_edges();
		list<Edge> aedges;
		list<Edge>::iterator e;
		for (e = iedges.begin(); e != iedges.end() ; ++e) {
			if (e->to < e->from)  e->reverse();
			aedges.push_back(*e);
		}
		for (e = eedges.begin(); e != eedges.end() ; ++e) {
			if (e->to < e->from)  e->reverse();
			aedges.push_back(*e);
		}
		//ye << Key << "num_loops" << Value << graph.find_cycles().size();
		//ye << Key << "num_edges" << Value << graph.external_edges().size();

		map<GiNaC::ex, int, GiNaC::ex_is_less> m2i; // relabel different mass squares to 1,2,..
		map<GiNaC::ex, int, GiNaC::ex_is_less> multiplicity;
		m2i[0] = 0;
		for (e = aedges.begin(); e != aedges.end() ; ++e) {
			GiNaC::ex m2 = graph.get_squaredmass(e->id).expand();
			int nextindex = m2i.size();
			if (m2i.find(m2) == m2i.end())
				m2i[m2] = nextindex;
			++multiplicity[m2];
			//todo: multiplciities belwo, rename to p if multiplicity =1 (or 0 if 0)

		}

		stringstream ss;
		ss << "(";
		for (e = aedges.begin(); e != aedges.end() ; ++e) {
			if (e != aedges.begin())  ss << " ";
			GiNaC::ex m2 = graph.get_squaredmass(e->id).expand();
			if (e->from < 0) {
				ss << "(e," << e->to << ",";
				if (m2i[m2] != 0 && multiplicity[m2] == 1)
					ss << "p";
				else
					ss << m2i[m2];
				ss << ")";
			} else {
				ss << "(" << e->from << "," << e->to << "," << m2i[m2] << ")";
			}
		}
		ss << ")";
		string graphstr = ss.str();
		map<string, list<Sector> >::const_iterator eq = equiv.find(graphstr);
		if (eq != equiv.end()) { // we had this graph before
			VERIFY(!eq->second.empty() && nints[sector] == nints[eq->second.front()]);
		} else {
			entry[sector] = graphstr;
		}
		equiv[graphstr].push_back(sector);
	}
	for (map<Sector, string>::const_iterator g = entry.begin(); g != entry.end(); ++g) {
		loopedia << g->second << " nmasters=" << nints[g->first] << " #";
		const list<Sector>& multi = equiv[g->second];
		for (list<Sector>::const_iterator m = multi.begin(); m != multi.end(); ++m)
			loopedia << " " << *m;
		loopedia << endl;
	}
	loopedia.close();
}

}
