/*  job_insertreductions.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_INSERTREDUCTIONS_H_
#define JOB_INSERTREDUCTIONS_H_

#include "job.h"

namespace Reduze {

/// Job to insert reductions in expressions
class InsertReductions: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("insert_reductions");
		s.set_short_description("Inserts reductions in expressions.");
		s.set_long_description(""//
					"Job to insert reductions in linear combinations or equations.");
		s.add_option("input_file", true, "string",
				"Input file with linear combinations or equations.");
		s.add_option("reductions_file", true, "string",
				"Input file with reductions.");
		s.add_option("preferred_masters_file", false, "string",
				"Input file with preferred master integrals.");
		s.add_option("output_file", true, "string", "Output file name.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}

	InsertReductions() {
		add_auto_options();
	}
	virtual ~InsertReductions() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_filename_);
		add_auto_io("reductions_file", reductions_filename_);
		add_auto_io("preferred_masters_file", preferred_masters_filename_);
		add_auto_io("output_file", output_filename_);
	}
	virtual void init();
private:
	std::string input_filename_; // input
	std::string reductions_filename_; // input
	std::string preferred_masters_filename_; // input
	std::string output_filename_; // ouput
};

}

#endif /* JOB_INSERTREDUCTIONS_H_ */
