/*  job_extractdatabasecontents.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifdef HAVE_DATABASE

#include "job_extractdatabasecontents.h"
#include "functions.h"
#include "files.h"
#include "reduzer.h"

using namespace std;

namespace Reduze {

// register job types at JobFactory
namespace {
JobProxy<ExtractDatabaseContents> dummy;
}

bool ExtractDatabaseContents::find_dependencies(const set<string>& outothers,//
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	in.push_back(database_file_);
	if (!output_file_identities_.empty())
		out.push_back(output_file_identities_);
	if (!output_file_substitutions_.empty())
		out.push_back(output_file_substitutions_);
	return true;
}

void ExtractDatabaseContents::init() {
	if (database_file_.empty())
		throw runtime_error("no database file specified");
}

std::string ExtractDatabaseContents::get_description() const {
	return string("extract database contents of ")
			+ short_filename(database_file_);
}

void ExtractDatabaseContents::run_serial() {
	using namespace GiNaC;
	LOG("Extracting contents of " << database_file_);

	ReduzerOptions opts;
	opts.compress_coefficients = compress_coefficients_;
	opts.use_transactions = use_transactions_;
	opts.cache_size = cache_size_;
	ReduzerDb r(opts);
	r.open(get_directory_of_filename(database_file_),
			get_filename_without_directory(database_file_));
	if (!output_file_identities_.empty())
		r.write_result(output_file_identities_, output_file_external_);
	if (!output_file_substitutions_.empty())
		r.write_substitutions(output_file_substitutions_);
}

}

#endif // HAVE_DATABASE
