/*  job_applycrossing.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_APPLYCROSSING_H_
#define JOB_APPLYCROSSING_H_

#include "job.h"
#include "yamlconfigurable.h"
#include "crossing.h"

namespace Reduze {

/// Job to apply crossings to reduction results
class ApplyCrossing: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("apply_crossings");
		s.set_short_description(
				"Generates reduction results for crossed sectors.");
		s.set_long_description(""//
					"Generates reduction results for crossed sectors");

		s.add_option("input_file", true, "string", ""//
					"Name of the input file with equations.");
		s.add_option("output_file", true, "string", ""//
					"Name of the output file.");
		s.add_option("crossing", true, "crossing", ""//
					"Crossing to be applied to the equations in the input file.");
		//s.add_option("replace_symbol_by_one", false, "boolean", ""//
		//			"Whether to replace the symbol defined in kinematics by one.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}

	ApplyCrossing() :
		crossing_(0)
	//: replace_symbol_by_one_(true)
	{
		add_auto_options();
	}
	ApplyCrossing(const std::string& in, const std::string& out,
			const Crossing& c) :
		input_filename_(in), output_filename_(out), crossing_(c)
	//, replace_symbol_by_one_(true)
	{
		add_auto_options();
	}

	virtual ~ApplyCrossing() {
	}

	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_filename_);
		add_auto_io("output_file", output_filename_);
		//		add_auto_io("replace_symbol_by_one", replace_symbol_by_one_);
	}

	virtual void init();
	virtual void print_manual_options(YAML::Emitter& os) const;
	virtual void read_manual_options(const YAML::Node&);

private:
	std::string input_filename_, output_filename_;
	Crossing crossing_;
	//	bool replace_symbol_by_one_;
};

}

#endif /* JOB_APPLYCROSSING_H_ */
