/* Internal libc stuff for floating point environment routines.
   Copyright (C) 2007-2014 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library.  If not, see
   <http://www.gnu.org/licenses/>.  */

#ifndef _FENV_LIBC_H
#define _FENV_LIBC_H	1

/* fenv_libc.h is used in libm implementations of ldbl-128ibm.  So we
   need this version in the soft-fp to at minimum include fenv.h to
   get the fegetround definition.  */

#include <fenv.h>

/* ldbl-128ibm code uses __fegetround.  */
#define __fegetround()	fegetround ()

#endif /* fenv_libc.h */
