// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/ec2query"
)

const opAcceptAddressTransfer = "AcceptAddressTransfer"

// AcceptAddressTransferRequest generates a "aws/request.Request" representing the
// client's request for the AcceptAddressTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptAddressTransfer for more information on using the AcceptAddressTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptAddressTransferRequest method.
//	req, resp := client.AcceptAddressTransferRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer
func (c *EC2) AcceptAddressTransferRequest(input *AcceptAddressTransferInput) (req *request.Request, output *AcceptAddressTransferOutput) {
	op := &request.Operation{
		Name:       opAcceptAddressTransfer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptAddressTransferInput{}
	}

	output = &AcceptAddressTransferOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptAddressTransfer API operation for Amazon Elastic Compute Cloud.
//
// Accepts an Elastic IP address transfer. For more information, see Accept
// a transferred Elastic IP address (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptAddressTransfer for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer
func (c *EC2) AcceptAddressTransfer(input *AcceptAddressTransferInput) (*AcceptAddressTransferOutput, error) {
	req, out := c.AcceptAddressTransferRequest(input)
	return out, req.Send()
}

// AcceptAddressTransferWithContext is the same as AcceptAddressTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptAddressTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptAddressTransferWithContext(ctx aws.Context, input *AcceptAddressTransferInput, opts ...request.Option) (*AcceptAddressTransferOutput, error) {
	req, out := c.AcceptAddressTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptReservedInstancesExchangeQuote = "AcceptReservedInstancesExchangeQuote"

// AcceptReservedInstancesExchangeQuoteRequest generates a "aws/request.Request" representing the
// client's request for the AcceptReservedInstancesExchangeQuote operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptReservedInstancesExchangeQuote for more information on using the AcceptReservedInstancesExchangeQuote
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptReservedInstancesExchangeQuoteRequest method.
//	req, resp := client.AcceptReservedInstancesExchangeQuoteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote
func (c *EC2) AcceptReservedInstancesExchangeQuoteRequest(input *AcceptReservedInstancesExchangeQuoteInput) (req *request.Request, output *AcceptReservedInstancesExchangeQuoteOutput) {
	op := &request.Operation{
		Name:       opAcceptReservedInstancesExchangeQuote,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptReservedInstancesExchangeQuoteInput{}
	}

	output = &AcceptReservedInstancesExchangeQuoteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptReservedInstancesExchangeQuote API operation for Amazon Elastic Compute Cloud.
//
// Accepts the Convertible Reserved Instance exchange quote described in the
// GetReservedInstancesExchangeQuote call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptReservedInstancesExchangeQuote for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote
func (c *EC2) AcceptReservedInstancesExchangeQuote(input *AcceptReservedInstancesExchangeQuoteInput) (*AcceptReservedInstancesExchangeQuoteOutput, error) {
	req, out := c.AcceptReservedInstancesExchangeQuoteRequest(input)
	return out, req.Send()
}

// AcceptReservedInstancesExchangeQuoteWithContext is the same as AcceptReservedInstancesExchangeQuote with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptReservedInstancesExchangeQuote for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptReservedInstancesExchangeQuoteWithContext(ctx aws.Context, input *AcceptReservedInstancesExchangeQuoteInput, opts ...request.Option) (*AcceptReservedInstancesExchangeQuoteOutput, error) {
	req, out := c.AcceptReservedInstancesExchangeQuoteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptTransitGatewayMulticastDomainAssociations = "AcceptTransitGatewayMulticastDomainAssociations"

// AcceptTransitGatewayMulticastDomainAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the AcceptTransitGatewayMulticastDomainAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptTransitGatewayMulticastDomainAssociations for more information on using the AcceptTransitGatewayMulticastDomainAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptTransitGatewayMulticastDomainAssociationsRequest method.
//	req, resp := client.AcceptTransitGatewayMulticastDomainAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations
func (c *EC2) AcceptTransitGatewayMulticastDomainAssociationsRequest(input *AcceptTransitGatewayMulticastDomainAssociationsInput) (req *request.Request, output *AcceptTransitGatewayMulticastDomainAssociationsOutput) {
	op := &request.Operation{
		Name:       opAcceptTransitGatewayMulticastDomainAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptTransitGatewayMulticastDomainAssociationsInput{}
	}

	output = &AcceptTransitGatewayMulticastDomainAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptTransitGatewayMulticastDomainAssociations API operation for Amazon Elastic Compute Cloud.
//
// Accepts a request to associate subnets with a transit gateway multicast domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptTransitGatewayMulticastDomainAssociations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations
func (c *EC2) AcceptTransitGatewayMulticastDomainAssociations(input *AcceptTransitGatewayMulticastDomainAssociationsInput) (*AcceptTransitGatewayMulticastDomainAssociationsOutput, error) {
	req, out := c.AcceptTransitGatewayMulticastDomainAssociationsRequest(input)
	return out, req.Send()
}

// AcceptTransitGatewayMulticastDomainAssociationsWithContext is the same as AcceptTransitGatewayMulticastDomainAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptTransitGatewayMulticastDomainAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptTransitGatewayMulticastDomainAssociationsWithContext(ctx aws.Context, input *AcceptTransitGatewayMulticastDomainAssociationsInput, opts ...request.Option) (*AcceptTransitGatewayMulticastDomainAssociationsOutput, error) {
	req, out := c.AcceptTransitGatewayMulticastDomainAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptTransitGatewayPeeringAttachment = "AcceptTransitGatewayPeeringAttachment"

// AcceptTransitGatewayPeeringAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the AcceptTransitGatewayPeeringAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptTransitGatewayPeeringAttachment for more information on using the AcceptTransitGatewayPeeringAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptTransitGatewayPeeringAttachmentRequest method.
//	req, resp := client.AcceptTransitGatewayPeeringAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment
func (c *EC2) AcceptTransitGatewayPeeringAttachmentRequest(input *AcceptTransitGatewayPeeringAttachmentInput) (req *request.Request, output *AcceptTransitGatewayPeeringAttachmentOutput) {
	op := &request.Operation{
		Name:       opAcceptTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptTransitGatewayPeeringAttachmentInput{}
	}

	output = &AcceptTransitGatewayPeeringAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptTransitGatewayPeeringAttachment API operation for Amazon Elastic Compute Cloud.
//
// Accepts a transit gateway peering attachment request. The peering attachment
// must be in the pendingAcceptance state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptTransitGatewayPeeringAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment
func (c *EC2) AcceptTransitGatewayPeeringAttachment(input *AcceptTransitGatewayPeeringAttachmentInput) (*AcceptTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayPeeringAttachmentRequest(input)
	return out, req.Send()
}

// AcceptTransitGatewayPeeringAttachmentWithContext is the same as AcceptTransitGatewayPeeringAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptTransitGatewayPeeringAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptTransitGatewayPeeringAttachmentWithContext(ctx aws.Context, input *AcceptTransitGatewayPeeringAttachmentInput, opts ...request.Option) (*AcceptTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayPeeringAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptTransitGatewayVpcAttachment = "AcceptTransitGatewayVpcAttachment"

// AcceptTransitGatewayVpcAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the AcceptTransitGatewayVpcAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptTransitGatewayVpcAttachment for more information on using the AcceptTransitGatewayVpcAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptTransitGatewayVpcAttachmentRequest method.
//	req, resp := client.AcceptTransitGatewayVpcAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment
func (c *EC2) AcceptTransitGatewayVpcAttachmentRequest(input *AcceptTransitGatewayVpcAttachmentInput) (req *request.Request, output *AcceptTransitGatewayVpcAttachmentOutput) {
	op := &request.Operation{
		Name:       opAcceptTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptTransitGatewayVpcAttachmentInput{}
	}

	output = &AcceptTransitGatewayVpcAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptTransitGatewayVpcAttachment API operation for Amazon Elastic Compute Cloud.
//
// Accepts a request to attach a VPC to a transit gateway.
//
// The VPC attachment must be in the pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments
// to view your pending VPC attachment requests. Use RejectTransitGatewayVpcAttachment
// to reject a VPC attachment request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptTransitGatewayVpcAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment
func (c *EC2) AcceptTransitGatewayVpcAttachment(input *AcceptTransitGatewayVpcAttachmentInput) (*AcceptTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayVpcAttachmentRequest(input)
	return out, req.Send()
}

// AcceptTransitGatewayVpcAttachmentWithContext is the same as AcceptTransitGatewayVpcAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptTransitGatewayVpcAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptTransitGatewayVpcAttachmentWithContext(ctx aws.Context, input *AcceptTransitGatewayVpcAttachmentInput, opts ...request.Option) (*AcceptTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.AcceptTransitGatewayVpcAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptVpcEndpointConnections = "AcceptVpcEndpointConnections"

// AcceptVpcEndpointConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the AcceptVpcEndpointConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptVpcEndpointConnections for more information on using the AcceptVpcEndpointConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptVpcEndpointConnectionsRequest method.
//	req, resp := client.AcceptVpcEndpointConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections
func (c *EC2) AcceptVpcEndpointConnectionsRequest(input *AcceptVpcEndpointConnectionsInput) (req *request.Request, output *AcceptVpcEndpointConnectionsOutput) {
	op := &request.Operation{
		Name:       opAcceptVpcEndpointConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptVpcEndpointConnectionsInput{}
	}

	output = &AcceptVpcEndpointConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptVpcEndpointConnections API operation for Amazon Elastic Compute Cloud.
//
// Accepts connection requests to your VPC endpoint service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptVpcEndpointConnections for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections
func (c *EC2) AcceptVpcEndpointConnections(input *AcceptVpcEndpointConnectionsInput) (*AcceptVpcEndpointConnectionsOutput, error) {
	req, out := c.AcceptVpcEndpointConnectionsRequest(input)
	return out, req.Send()
}

// AcceptVpcEndpointConnectionsWithContext is the same as AcceptVpcEndpointConnections with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptVpcEndpointConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptVpcEndpointConnectionsWithContext(ctx aws.Context, input *AcceptVpcEndpointConnectionsInput, opts ...request.Option) (*AcceptVpcEndpointConnectionsOutput, error) {
	req, out := c.AcceptVpcEndpointConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptVpcPeeringConnection = "AcceptVpcPeeringConnection"

// AcceptVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AcceptVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptVpcPeeringConnection for more information on using the AcceptVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptVpcPeeringConnectionRequest method.
//	req, resp := client.AcceptVpcPeeringConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection
func (c *EC2) AcceptVpcPeeringConnectionRequest(input *AcceptVpcPeeringConnectionInput) (req *request.Request, output *AcceptVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptVpcPeeringConnectionInput{}
	}

	output = &AcceptVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Accept a VPC peering connection request. To accept a request, the VPC peering
// connection must be in the pending-acceptance state, and you must be the owner
// of the peer VPC. Use DescribeVpcPeeringConnections to view your outstanding
// VPC peering connection requests.
//
// For an inter-Region VPC peering connection request, you must accept the VPC
// peering connection in the Region of the accepter VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AcceptVpcPeeringConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection
func (c *EC2) AcceptVpcPeeringConnection(input *AcceptVpcPeeringConnectionInput) (*AcceptVpcPeeringConnectionOutput, error) {
	req, out := c.AcceptVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// AcceptVpcPeeringConnectionWithContext is the same as AcceptVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AcceptVpcPeeringConnectionWithContext(ctx aws.Context, input *AcceptVpcPeeringConnectionInput, opts ...request.Option) (*AcceptVpcPeeringConnectionOutput, error) {
	req, out := c.AcceptVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAdvertiseByoipCidr = "AdvertiseByoipCidr"

// AdvertiseByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the AdvertiseByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AdvertiseByoipCidr for more information on using the AdvertiseByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AdvertiseByoipCidrRequest method.
//	req, resp := client.AdvertiseByoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr
func (c *EC2) AdvertiseByoipCidrRequest(input *AdvertiseByoipCidrInput) (req *request.Request, output *AdvertiseByoipCidrOutput) {
	op := &request.Operation{
		Name:       opAdvertiseByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdvertiseByoipCidrInput{}
	}

	output = &AdvertiseByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AdvertiseByoipCidr API operation for Amazon Elastic Compute Cloud.
//
// Advertises an IPv4 or IPv6 address range that is provisioned for use with
// your Amazon Web Services resources through bring your own IP addresses (BYOIP).
//
// You can perform this operation at most once every 10 seconds, even if you
// specify different address ranges each time.
//
// We recommend that you stop advertising the BYOIP CIDR from other locations
// when you advertise it from Amazon Web Services. To minimize down time, you
// can configure your Amazon Web Services resources to use an address from a
// BYOIP CIDR before it is advertised, and then simultaneously stop advertising
// it from the current location and start advertising it through Amazon Web
// Services.
//
// It can take a few minutes before traffic to the specified addresses starts
// routing to Amazon Web Services because of BGP propagation delays.
//
// To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AdvertiseByoipCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr
func (c *EC2) AdvertiseByoipCidr(input *AdvertiseByoipCidrInput) (*AdvertiseByoipCidrOutput, error) {
	req, out := c.AdvertiseByoipCidrRequest(input)
	return out, req.Send()
}

// AdvertiseByoipCidrWithContext is the same as AdvertiseByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See AdvertiseByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AdvertiseByoipCidrWithContext(ctx aws.Context, input *AdvertiseByoipCidrInput, opts ...request.Option) (*AdvertiseByoipCidrOutput, error) {
	req, out := c.AdvertiseByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateAddress = "AllocateAddress"

// AllocateAddressRequest generates a "aws/request.Request" representing the
// client's request for the AllocateAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateAddress for more information on using the AllocateAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AllocateAddressRequest method.
//	req, resp := client.AllocateAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress
func (c *EC2) AllocateAddressRequest(input *AllocateAddressInput) (req *request.Request, output *AllocateAddressOutput) {
	op := &request.Operation{
		Name:       opAllocateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateAddressInput{}
	}

	output = &AllocateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateAddress API operation for Amazon Elastic Compute Cloud.
//
// Allocates an Elastic IP address to your Amazon Web Services account. After
// you allocate the Elastic IP address you can associate it with an instance
// or network interface. After you release an Elastic IP address, it is released
// to the IP address pool and can be allocated to a different Amazon Web Services
// account.
//
// You can allocate an Elastic IP address from an address pool owned by Amazon
// Web Services or from an address pool created from a public IPv4 address range
// that you have brought to Amazon Web Services for use with your Amazon Web
// Services resources using bring your own IP addresses (BYOIP). For more information,
// see Bring Your Own IP Addresses (BYOIP) (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// If you release an Elastic IP address, you might be able to recover it. You
// cannot recover an Elastic IP address that you released after it is allocated
// to another Amazon Web Services account. To attempt to recover an Elastic
// IP address that you released, specify it in this operation.
//
// For more information, see Elastic IP Addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You can allocate a carrier IP address which is a public IP address from a
// telecommunication carrier, to a network interface which resides in a subnet
// in a Wavelength Zone (for example an EC2 instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AllocateAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress
func (c *EC2) AllocateAddress(input *AllocateAddressInput) (*AllocateAddressOutput, error) {
	req, out := c.AllocateAddressRequest(input)
	return out, req.Send()
}

// AllocateAddressWithContext is the same as AllocateAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AllocateAddressWithContext(ctx aws.Context, input *AllocateAddressInput, opts ...request.Option) (*AllocateAddressOutput, error) {
	req, out := c.AllocateAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateHosts = "AllocateHosts"

// AllocateHostsRequest generates a "aws/request.Request" representing the
// client's request for the AllocateHosts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateHosts for more information on using the AllocateHosts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AllocateHostsRequest method.
//	req, resp := client.AllocateHostsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts
func (c *EC2) AllocateHostsRequest(input *AllocateHostsInput) (req *request.Request, output *AllocateHostsOutput) {
	op := &request.Operation{
		Name:       opAllocateHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateHostsInput{}
	}

	output = &AllocateHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateHosts API operation for Amazon Elastic Compute Cloud.
//
// Allocates a Dedicated Host to your account. At a minimum, specify the supported
// instance type or instance family, the Availability Zone in which to allocate
// the host, and the number of hosts to allocate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AllocateHosts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts
func (c *EC2) AllocateHosts(input *AllocateHostsInput) (*AllocateHostsOutput, error) {
	req, out := c.AllocateHostsRequest(input)
	return out, req.Send()
}

// AllocateHostsWithContext is the same as AllocateHosts with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateHosts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AllocateHostsWithContext(ctx aws.Context, input *AllocateHostsInput, opts ...request.Option) (*AllocateHostsOutput, error) {
	req, out := c.AllocateHostsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateIpamPoolCidr = "AllocateIpamPoolCidr"

// AllocateIpamPoolCidrRequest generates a "aws/request.Request" representing the
// client's request for the AllocateIpamPoolCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateIpamPoolCidr for more information on using the AllocateIpamPoolCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AllocateIpamPoolCidrRequest method.
//	req, resp := client.AllocateIpamPoolCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr
func (c *EC2) AllocateIpamPoolCidrRequest(input *AllocateIpamPoolCidrInput) (req *request.Request, output *AllocateIpamPoolCidrOutput) {
	op := &request.Operation{
		Name:       opAllocateIpamPoolCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateIpamPoolCidrInput{}
	}

	output = &AllocateIpamPoolCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateIpamPoolCidr API operation for Amazon Elastic Compute Cloud.
//
// Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM
// pool locale. The locale is the Amazon Web Services Region where this IPAM
// pool is available for allocations.
//
// In IPAM, an allocation is a CIDR assignment from an IPAM pool to another
// IPAM pool or to a resource. For more information, see Allocate CIDRs (https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// This action creates an allocation with strong consistency. The returned CIDR
// will not overlap with any other allocations from the same pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AllocateIpamPoolCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr
func (c *EC2) AllocateIpamPoolCidr(input *AllocateIpamPoolCidrInput) (*AllocateIpamPoolCidrOutput, error) {
	req, out := c.AllocateIpamPoolCidrRequest(input)
	return out, req.Send()
}

// AllocateIpamPoolCidrWithContext is the same as AllocateIpamPoolCidr with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateIpamPoolCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AllocateIpamPoolCidrWithContext(ctx aws.Context, input *AllocateIpamPoolCidrInput, opts ...request.Option) (*AllocateIpamPoolCidrOutput, error) {
	req, out := c.AllocateIpamPoolCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplySecurityGroupsToClientVpnTargetNetwork = "ApplySecurityGroupsToClientVpnTargetNetwork"

// ApplySecurityGroupsToClientVpnTargetNetworkRequest generates a "aws/request.Request" representing the
// client's request for the ApplySecurityGroupsToClientVpnTargetNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplySecurityGroupsToClientVpnTargetNetwork for more information on using the ApplySecurityGroupsToClientVpnTargetNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ApplySecurityGroupsToClientVpnTargetNetworkRequest method.
//	req, resp := client.ApplySecurityGroupsToClientVpnTargetNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork
func (c *EC2) ApplySecurityGroupsToClientVpnTargetNetworkRequest(input *ApplySecurityGroupsToClientVpnTargetNetworkInput) (req *request.Request, output *ApplySecurityGroupsToClientVpnTargetNetworkOutput) {
	op := &request.Operation{
		Name:       opApplySecurityGroupsToClientVpnTargetNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplySecurityGroupsToClientVpnTargetNetworkInput{}
	}

	output = &ApplySecurityGroupsToClientVpnTargetNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplySecurityGroupsToClientVpnTargetNetwork API operation for Amazon Elastic Compute Cloud.
//
// Applies a security group to the association between the target network and
// the Client VPN endpoint. This action replaces the existing security groups
// with the specified security groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ApplySecurityGroupsToClientVpnTargetNetwork for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork
func (c *EC2) ApplySecurityGroupsToClientVpnTargetNetwork(input *ApplySecurityGroupsToClientVpnTargetNetworkInput) (*ApplySecurityGroupsToClientVpnTargetNetworkOutput, error) {
	req, out := c.ApplySecurityGroupsToClientVpnTargetNetworkRequest(input)
	return out, req.Send()
}

// ApplySecurityGroupsToClientVpnTargetNetworkWithContext is the same as ApplySecurityGroupsToClientVpnTargetNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See ApplySecurityGroupsToClientVpnTargetNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) ApplySecurityGroupsToClientVpnTargetNetworkWithContext(ctx aws.Context, input *ApplySecurityGroupsToClientVpnTargetNetworkInput, opts ...request.Option) (*ApplySecurityGroupsToClientVpnTargetNetworkOutput, error) {
	req, out := c.ApplySecurityGroupsToClientVpnTargetNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignIpv6Addresses = "AssignIpv6Addresses"

// AssignIpv6AddressesRequest generates a "aws/request.Request" representing the
// client's request for the AssignIpv6Addresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignIpv6Addresses for more information on using the AssignIpv6Addresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssignIpv6AddressesRequest method.
//	req, resp := client.AssignIpv6AddressesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses
func (c *EC2) AssignIpv6AddressesRequest(input *AssignIpv6AddressesInput) (req *request.Request, output *AssignIpv6AddressesOutput) {
	op := &request.Operation{
		Name:       opAssignIpv6Addresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignIpv6AddressesInput{}
	}

	output = &AssignIpv6AddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssignIpv6Addresses API operation for Amazon Elastic Compute Cloud.
//
// Assigns one or more IPv6 addresses to the specified network interface. You
// can specify one or more specific IPv6 addresses, or you can specify the number
// of IPv6 addresses to be automatically assigned from within the subnet's IPv6
// CIDR block range. You can assign as many IPv6 addresses to a network interface
// as you can assign private IPv4 addresses, and the limit varies per instance
// type. For information, see IP Addresses Per Network Interface Per Instance
// Type (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
// in the Amazon Elastic Compute Cloud User Guide.
//
// You must specify either the IPv6 addresses or the IPv6 address count in the
// request.
//
// You can optionally use Prefix Delegation on the network interface. You must
// specify either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix Delegation
// count. For information, see Assigning prefixes to Amazon EC2 network interfaces
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssignIpv6Addresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses
func (c *EC2) AssignIpv6Addresses(input *AssignIpv6AddressesInput) (*AssignIpv6AddressesOutput, error) {
	req, out := c.AssignIpv6AddressesRequest(input)
	return out, req.Send()
}

// AssignIpv6AddressesWithContext is the same as AssignIpv6Addresses with the addition of
// the ability to pass a context and additional request options.
//
// See AssignIpv6Addresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssignIpv6AddressesWithContext(ctx aws.Context, input *AssignIpv6AddressesInput, opts ...request.Option) (*AssignIpv6AddressesOutput, error) {
	req, out := c.AssignIpv6AddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignPrivateIpAddresses = "AssignPrivateIpAddresses"

// AssignPrivateIpAddressesRequest generates a "aws/request.Request" representing the
// client's request for the AssignPrivateIpAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignPrivateIpAddresses for more information on using the AssignPrivateIpAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssignPrivateIpAddressesRequest method.
//	req, resp := client.AssignPrivateIpAddressesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses
func (c *EC2) AssignPrivateIpAddressesRequest(input *AssignPrivateIpAddressesInput) (req *request.Request, output *AssignPrivateIpAddressesOutput) {
	op := &request.Operation{
		Name:       opAssignPrivateIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignPrivateIpAddressesInput{}
	}

	output = &AssignPrivateIpAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssignPrivateIpAddresses API operation for Amazon Elastic Compute Cloud.
//
// Assigns one or more secondary private IP addresses to the specified network
// interface.
//
// You can specify one or more specific secondary IP addresses, or you can specify
// the number of secondary IP addresses to be automatically assigned within
// the subnet's CIDR block range. The number of secondary IP addresses that
// you can assign to an instance varies by instance type. For information about
// instance types, see Instance Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// Elastic IP addresses, see Elastic IP Addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// When you move a secondary private IP address to another network interface,
// any Elastic IP address that is associated with the IP address is also moved.
//
// Remapping an IP address is an asynchronous operation. When you move an IP
// address from one network interface to another, check network/interfaces/macs/mac/local-ipv4s
// in the instance metadata to confirm that the remapping is complete.
//
// You must specify either the IP addresses or the IP address count in the request.
//
// You can optionally use Prefix Delegation on the network interface. You must
// specify either the IPv4 Prefix Delegation prefixes, or the IPv4 Prefix Delegation
// count. For information, see Assigning prefixes to Amazon EC2 network interfaces
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssignPrivateIpAddresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses
func (c *EC2) AssignPrivateIpAddresses(input *AssignPrivateIpAddressesInput) (*AssignPrivateIpAddressesOutput, error) {
	req, out := c.AssignPrivateIpAddressesRequest(input)
	return out, req.Send()
}

// AssignPrivateIpAddressesWithContext is the same as AssignPrivateIpAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See AssignPrivateIpAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssignPrivateIpAddressesWithContext(ctx aws.Context, input *AssignPrivateIpAddressesInput, opts ...request.Option) (*AssignPrivateIpAddressesOutput, error) {
	req, out := c.AssignPrivateIpAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignPrivateNatGatewayAddress = "AssignPrivateNatGatewayAddress"

// AssignPrivateNatGatewayAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssignPrivateNatGatewayAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignPrivateNatGatewayAddress for more information on using the AssignPrivateNatGatewayAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssignPrivateNatGatewayAddressRequest method.
//	req, resp := client.AssignPrivateNatGatewayAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress
func (c *EC2) AssignPrivateNatGatewayAddressRequest(input *AssignPrivateNatGatewayAddressInput) (req *request.Request, output *AssignPrivateNatGatewayAddressOutput) {
	op := &request.Operation{
		Name:       opAssignPrivateNatGatewayAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignPrivateNatGatewayAddressInput{}
	}

	output = &AssignPrivateNatGatewayAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssignPrivateNatGatewayAddress API operation for Amazon Elastic Compute Cloud.
//
// Assigns one or more private IPv4 addresses to a private NAT gateway. For
// more information, see Work with NAT gateways (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssignPrivateNatGatewayAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress
func (c *EC2) AssignPrivateNatGatewayAddress(input *AssignPrivateNatGatewayAddressInput) (*AssignPrivateNatGatewayAddressOutput, error) {
	req, out := c.AssignPrivateNatGatewayAddressRequest(input)
	return out, req.Send()
}

// AssignPrivateNatGatewayAddressWithContext is the same as AssignPrivateNatGatewayAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AssignPrivateNatGatewayAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssignPrivateNatGatewayAddressWithContext(ctx aws.Context, input *AssignPrivateNatGatewayAddressInput, opts ...request.Option) (*AssignPrivateNatGatewayAddressOutput, error) {
	req, out := c.AssignPrivateNatGatewayAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateAddress = "AssociateAddress"

// AssociateAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAddress for more information on using the AssociateAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateAddressRequest method.
//	req, resp := client.AssociateAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress
func (c *EC2) AssociateAddressRequest(input *AssociateAddressInput) (req *request.Request, output *AssociateAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateAddressInput{}
	}

	output = &AssociateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAddress API operation for Amazon Elastic Compute Cloud.
//
// Associates an Elastic IP address, or carrier IP address (for instances that
// are in subnets in Wavelength Zones) with an instance or a network interface.
// Before you can use an Elastic IP address, you must allocate it to your account.
//
// If the Elastic IP address is already associated with a different instance,
// it is disassociated from that instance and associated with the specified
// instance. If you associate an Elastic IP address with an instance that has
// an existing Elastic IP address, the existing address is disassociated from
// the instance, but remains allocated to your account.
//
// [Subnets in Wavelength Zones] You can associate an IP address from the telecommunication
// carrier to the instance or network interface.
//
// You cannot associate an Elastic IP address with an interface in a different
// network border group.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error, and you may be charged for each time
// the Elastic IP address is remapped to the same instance. For more information,
// see the Elastic IP Addresses section of Amazon EC2 Pricing (http://aws.amazon.com/ec2/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress
func (c *EC2) AssociateAddress(input *AssociateAddressInput) (*AssociateAddressOutput, error) {
	req, out := c.AssociateAddressRequest(input)
	return out, req.Send()
}

// AssociateAddressWithContext is the same as AssociateAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateAddressWithContext(ctx aws.Context, input *AssociateAddressInput, opts ...request.Option) (*AssociateAddressOutput, error) {
	req, out := c.AssociateAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateClientVpnTargetNetwork = "AssociateClientVpnTargetNetwork"

// AssociateClientVpnTargetNetworkRequest generates a "aws/request.Request" representing the
// client's request for the AssociateClientVpnTargetNetwork operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateClientVpnTargetNetwork for more information on using the AssociateClientVpnTargetNetwork
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateClientVpnTargetNetworkRequest method.
//	req, resp := client.AssociateClientVpnTargetNetworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork
func (c *EC2) AssociateClientVpnTargetNetworkRequest(input *AssociateClientVpnTargetNetworkInput) (req *request.Request, output *AssociateClientVpnTargetNetworkOutput) {
	op := &request.Operation{
		Name:       opAssociateClientVpnTargetNetwork,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateClientVpnTargetNetworkInput{}
	}

	output = &AssociateClientVpnTargetNetworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateClientVpnTargetNetwork API operation for Amazon Elastic Compute Cloud.
//
// Associates a target network with a Client VPN endpoint. A target network
// is a subnet in a VPC. You can associate multiple subnets from the same VPC
// with a Client VPN endpoint. You can associate only one subnet in each Availability
// Zone. We recommend that you associate at least two subnets to provide Availability
// Zone redundancy.
//
// If you specified a VPC when you created the Client VPN endpoint or if you
// have previous subnet associations, the specified subnet must be in the same
// VPC. To specify a subnet that's in a different VPC, you must first modify
// the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's
// associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateClientVpnTargetNetwork for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork
func (c *EC2) AssociateClientVpnTargetNetwork(input *AssociateClientVpnTargetNetworkInput) (*AssociateClientVpnTargetNetworkOutput, error) {
	req, out := c.AssociateClientVpnTargetNetworkRequest(input)
	return out, req.Send()
}

// AssociateClientVpnTargetNetworkWithContext is the same as AssociateClientVpnTargetNetwork with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateClientVpnTargetNetwork for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateClientVpnTargetNetworkWithContext(ctx aws.Context, input *AssociateClientVpnTargetNetworkInput, opts ...request.Option) (*AssociateClientVpnTargetNetworkOutput, error) {
	req, out := c.AssociateClientVpnTargetNetworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateDhcpOptions = "AssociateDhcpOptions"

// AssociateDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDhcpOptions for more information on using the AssociateDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateDhcpOptionsRequest method.
//	req, resp := client.AssociateDhcpOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions
func (c *EC2) AssociateDhcpOptionsRequest(input *AssociateDhcpOptionsInput) (req *request.Request, output *AssociateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opAssociateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDhcpOptionsInput{}
	}

	output = &AssociateDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Associates a set of DHCP options (that you've previously created) with the
// specified VPC, or associates no DHCP options with the VPC.
//
// After you associate the options with the VPC, any existing instances and
// all new instances that you launch in that VPC use the options. You don't
// need to restart or relaunch the instances. They automatically pick up the
// changes within a few hours, depending on how frequently the instance renews
// its DHCP lease. You can explicitly renew the lease using the operating system
// on the instance.
//
// For more information, see DHCP options sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions
func (c *EC2) AssociateDhcpOptions(input *AssociateDhcpOptionsInput) (*AssociateDhcpOptionsOutput, error) {
	req, out := c.AssociateDhcpOptionsRequest(input)
	return out, req.Send()
}

// AssociateDhcpOptionsWithContext is the same as AssociateDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateDhcpOptionsWithContext(ctx aws.Context, input *AssociateDhcpOptionsInput, opts ...request.Option) (*AssociateDhcpOptionsOutput, error) {
	req, out := c.AssociateDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateEnclaveCertificateIamRole = "AssociateEnclaveCertificateIamRole"

// AssociateEnclaveCertificateIamRoleRequest generates a "aws/request.Request" representing the
// client's request for the AssociateEnclaveCertificateIamRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateEnclaveCertificateIamRole for more information on using the AssociateEnclaveCertificateIamRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateEnclaveCertificateIamRoleRequest method.
//	req, resp := client.AssociateEnclaveCertificateIamRoleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole
func (c *EC2) AssociateEnclaveCertificateIamRoleRequest(input *AssociateEnclaveCertificateIamRoleInput) (req *request.Request, output *AssociateEnclaveCertificateIamRoleOutput) {
	op := &request.Operation{
		Name:       opAssociateEnclaveCertificateIamRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateEnclaveCertificateIamRoleInput{}
	}

	output = &AssociateEnclaveCertificateIamRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateEnclaveCertificateIamRole API operation for Amazon Elastic Compute Cloud.
//
// Associates an Identity and Access Management (IAM) role with an Certificate
// Manager (ACM) certificate. This enables the certificate to be used by the
// ACM for Nitro Enclaves application inside an enclave. For more information,
// see Certificate Manager for Nitro Enclaves (https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html)
// in the Amazon Web Services Nitro Enclaves User Guide.
//
// When the IAM role is associated with the ACM certificate, the certificate,
// certificate chain, and encrypted private key are placed in an Amazon S3 location
// that only the associated IAM role can access. The private key of the certificate
// is encrypted with an Amazon Web Services managed key that has an attached
// attestation-based key policy.
//
// To enable the IAM role to access the Amazon S3 object, you must grant it
// permission to call s3:GetObject on the Amazon S3 bucket returned by the command.
// To enable the IAM role to access the KMS key, you must grant it permission
// to call kms:Decrypt on the KMS key returned by the command. For more information,
// see Grant the role permission to access the certificate and encryption key
// (https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy)
// in the Amazon Web Services Nitro Enclaves User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateEnclaveCertificateIamRole for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole
func (c *EC2) AssociateEnclaveCertificateIamRole(input *AssociateEnclaveCertificateIamRoleInput) (*AssociateEnclaveCertificateIamRoleOutput, error) {
	req, out := c.AssociateEnclaveCertificateIamRoleRequest(input)
	return out, req.Send()
}

// AssociateEnclaveCertificateIamRoleWithContext is the same as AssociateEnclaveCertificateIamRole with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateEnclaveCertificateIamRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateEnclaveCertificateIamRoleWithContext(ctx aws.Context, input *AssociateEnclaveCertificateIamRoleInput, opts ...request.Option) (*AssociateEnclaveCertificateIamRoleOutput, error) {
	req, out := c.AssociateEnclaveCertificateIamRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIamInstanceProfile = "AssociateIamInstanceProfile"

// AssociateIamInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIamInstanceProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIamInstanceProfile for more information on using the AssociateIamInstanceProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateIamInstanceProfileRequest method.
//	req, resp := client.AssociateIamInstanceProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile
func (c *EC2) AssociateIamInstanceProfileRequest(input *AssociateIamInstanceProfileInput) (req *request.Request, output *AssociateIamInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opAssociateIamInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIamInstanceProfileInput{}
	}

	output = &AssociateIamInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIamInstanceProfile API operation for Amazon Elastic Compute Cloud.
//
// Associates an IAM instance profile with a running or stopped instance. You
// cannot associate more than one IAM instance profile with an instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateIamInstanceProfile for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile
func (c *EC2) AssociateIamInstanceProfile(input *AssociateIamInstanceProfileInput) (*AssociateIamInstanceProfileOutput, error) {
	req, out := c.AssociateIamInstanceProfileRequest(input)
	return out, req.Send()
}

// AssociateIamInstanceProfileWithContext is the same as AssociateIamInstanceProfile with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIamInstanceProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateIamInstanceProfileWithContext(ctx aws.Context, input *AssociateIamInstanceProfileInput, opts ...request.Option) (*AssociateIamInstanceProfileOutput, error) {
	req, out := c.AssociateIamInstanceProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateInstanceEventWindow = "AssociateInstanceEventWindow"

// AssociateInstanceEventWindowRequest generates a "aws/request.Request" representing the
// client's request for the AssociateInstanceEventWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateInstanceEventWindow for more information on using the AssociateInstanceEventWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateInstanceEventWindowRequest method.
//	req, resp := client.AssociateInstanceEventWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow
func (c *EC2) AssociateInstanceEventWindowRequest(input *AssociateInstanceEventWindowInput) (req *request.Request, output *AssociateInstanceEventWindowOutput) {
	op := &request.Operation{
		Name:       opAssociateInstanceEventWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateInstanceEventWindowInput{}
	}

	output = &AssociateInstanceEventWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateInstanceEventWindow API operation for Amazon Elastic Compute Cloud.
//
// Associates one or more targets with an event window. Only one type of target
// (instance IDs, Dedicated Host IDs, or tags) can be specified with an event
// window.
//
// For more information, see Define event windows for scheduled events (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateInstanceEventWindow for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow
func (c *EC2) AssociateInstanceEventWindow(input *AssociateInstanceEventWindowInput) (*AssociateInstanceEventWindowOutput, error) {
	req, out := c.AssociateInstanceEventWindowRequest(input)
	return out, req.Send()
}

// AssociateInstanceEventWindowWithContext is the same as AssociateInstanceEventWindow with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateInstanceEventWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateInstanceEventWindowWithContext(ctx aws.Context, input *AssociateInstanceEventWindowInput, opts ...request.Option) (*AssociateInstanceEventWindowOutput, error) {
	req, out := c.AssociateInstanceEventWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIpamByoasn = "AssociateIpamByoasn"

// AssociateIpamByoasnRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIpamByoasn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIpamByoasn for more information on using the AssociateIpamByoasn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateIpamByoasnRequest method.
//	req, resp := client.AssociateIpamByoasnRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn
func (c *EC2) AssociateIpamByoasnRequest(input *AssociateIpamByoasnInput) (req *request.Request, output *AssociateIpamByoasnOutput) {
	op := &request.Operation{
		Name:       opAssociateIpamByoasn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIpamByoasnInput{}
	}

	output = &AssociateIpamByoasnOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIpamByoasn API operation for Amazon Elastic Compute Cloud.
//
// Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you
// own in the same Amazon Web Services Region. For more information, see Tutorial:
// Bring your ASN to IPAM (https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html)
// in the Amazon VPC IPAM guide.
//
// After the association succeeds, the ASN is eligible for advertisement. You
// can view the association with DescribeByoipCidrs (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html).
// You can advertise the CIDR with AdvertiseByoipCidr (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateIpamByoasn for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn
func (c *EC2) AssociateIpamByoasn(input *AssociateIpamByoasnInput) (*AssociateIpamByoasnOutput, error) {
	req, out := c.AssociateIpamByoasnRequest(input)
	return out, req.Send()
}

// AssociateIpamByoasnWithContext is the same as AssociateIpamByoasn with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIpamByoasn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateIpamByoasnWithContext(ctx aws.Context, input *AssociateIpamByoasnInput, opts ...request.Option) (*AssociateIpamByoasnOutput, error) {
	req, out := c.AssociateIpamByoasnRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIpamResourceDiscovery = "AssociateIpamResourceDiscovery"

// AssociateIpamResourceDiscoveryRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIpamResourceDiscovery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIpamResourceDiscovery for more information on using the AssociateIpamResourceDiscovery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateIpamResourceDiscoveryRequest method.
//	req, resp := client.AssociateIpamResourceDiscoveryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery
func (c *EC2) AssociateIpamResourceDiscoveryRequest(input *AssociateIpamResourceDiscoveryInput) (req *request.Request, output *AssociateIpamResourceDiscoveryOutput) {
	op := &request.Operation{
		Name:       opAssociateIpamResourceDiscovery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIpamResourceDiscoveryInput{}
	}

	output = &AssociateIpamResourceDiscoveryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIpamResourceDiscovery API operation for Amazon Elastic Compute Cloud.
//
// Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource
// discovery is an IPAM component that enables IPAM to manage and monitor resources
// that belong to the owning account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateIpamResourceDiscovery for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery
func (c *EC2) AssociateIpamResourceDiscovery(input *AssociateIpamResourceDiscoveryInput) (*AssociateIpamResourceDiscoveryOutput, error) {
	req, out := c.AssociateIpamResourceDiscoveryRequest(input)
	return out, req.Send()
}

// AssociateIpamResourceDiscoveryWithContext is the same as AssociateIpamResourceDiscovery with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIpamResourceDiscovery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateIpamResourceDiscoveryWithContext(ctx aws.Context, input *AssociateIpamResourceDiscoveryInput, opts ...request.Option) (*AssociateIpamResourceDiscoveryOutput, error) {
	req, out := c.AssociateIpamResourceDiscoveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateNatGatewayAddress = "AssociateNatGatewayAddress"

// AssociateNatGatewayAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssociateNatGatewayAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateNatGatewayAddress for more information on using the AssociateNatGatewayAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateNatGatewayAddressRequest method.
//	req, resp := client.AssociateNatGatewayAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress
func (c *EC2) AssociateNatGatewayAddressRequest(input *AssociateNatGatewayAddressInput) (req *request.Request, output *AssociateNatGatewayAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateNatGatewayAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateNatGatewayAddressInput{}
	}

	output = &AssociateNatGatewayAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateNatGatewayAddress API operation for Amazon Elastic Compute Cloud.
//
// Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a
// public NAT gateway. For more information, see Work with NAT gateways (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-working-with)
// in the Amazon VPC User Guide.
//
// By default, you can associate up to 2 Elastic IP addresses per public NAT
// gateway. You can increase the limit by requesting a quota adjustment. For
// more information, see Elastic IP address quotas (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips)
// in the Amazon VPC User Guide.
//
// When you associate an EIP or secondary EIPs with a public NAT gateway, the
// network border group of the EIPs must match the network border group of the
// Availability Zone (AZ) that the public NAT gateway is in. If it's not the
// same, the EIP will fail to associate. You can see the network border group
// for the subnet's AZ by viewing the details of the subnet. Similarly, you
// can view the network border group of an EIP by viewing the details of the
// EIP address. For more information about network border groups and EIPs, see
// Allocate an Elastic IP address (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateNatGatewayAddress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress
func (c *EC2) AssociateNatGatewayAddress(input *AssociateNatGatewayAddressInput) (*AssociateNatGatewayAddressOutput, error) {
	req, out := c.AssociateNatGatewayAddressRequest(input)
	return out, req.Send()
}

// AssociateNatGatewayAddressWithContext is the same as AssociateNatGatewayAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateNatGatewayAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateNatGatewayAddressWithContext(ctx aws.Context, input *AssociateNatGatewayAddressInput, opts ...request.Option) (*AssociateNatGatewayAddressOutput, error) {
	req, out := c.AssociateNatGatewayAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateRouteTable = "AssociateRouteTable"

// AssociateRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateRouteTable for more information on using the AssociateRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateRouteTableRequest method.
//	req, resp := client.AssociateRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable
func (c *EC2) AssociateRouteTableRequest(input *AssociateRouteTableInput) (req *request.Request, output *AssociateRouteTableOutput) {
	op := &request.Operation{
		Name:       opAssociateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateRouteTableInput{}
	}

	output = &AssociateRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Associates a subnet in your VPC or an internet gateway or virtual private
// gateway attached to your VPC with a route table in your VPC. This association
// causes traffic from the subnet or gateway to be routed according to the routes
// in the route table. The action returns an association ID, which you need
// in order to disassociate the route table later. A route table can be associated
// with multiple subnets.
//
// For more information, see Route tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable
func (c *EC2) AssociateRouteTable(input *AssociateRouteTableInput) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	return out, req.Send()
}

// AssociateRouteTableWithContext is the same as AssociateRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateRouteTableWithContext(ctx aws.Context, input *AssociateRouteTableInput, opts ...request.Option) (*AssociateRouteTableOutput, error) {
	req, out := c.AssociateRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSubnetCidrBlock = "AssociateSubnetCidrBlock"

// AssociateSubnetCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSubnetCidrBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSubnetCidrBlock for more information on using the AssociateSubnetCidrBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateSubnetCidrBlockRequest method.
//	req, resp := client.AssociateSubnetCidrBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock
func (c *EC2) AssociateSubnetCidrBlockRequest(input *AssociateSubnetCidrBlockInput) (req *request.Request, output *AssociateSubnetCidrBlockOutput) {
	op := &request.Operation{
		Name:       opAssociateSubnetCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSubnetCidrBlockInput{}
	}

	output = &AssociateSubnetCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSubnetCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Associates a CIDR block with your subnet. You can only associate a single
// IPv6 CIDR block with your subnet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateSubnetCidrBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock
func (c *EC2) AssociateSubnetCidrBlock(input *AssociateSubnetCidrBlockInput) (*AssociateSubnetCidrBlockOutput, error) {
	req, out := c.AssociateSubnetCidrBlockRequest(input)
	return out, req.Send()
}

// AssociateSubnetCidrBlockWithContext is the same as AssociateSubnetCidrBlock with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSubnetCidrBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateSubnetCidrBlockWithContext(ctx aws.Context, input *AssociateSubnetCidrBlockInput, opts ...request.Option) (*AssociateSubnetCidrBlockOutput, error) {
	req, out := c.AssociateSubnetCidrBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTransitGatewayMulticastDomain = "AssociateTransitGatewayMulticastDomain"

// AssociateTransitGatewayMulticastDomainRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTransitGatewayMulticastDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTransitGatewayMulticastDomain for more information on using the AssociateTransitGatewayMulticastDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateTransitGatewayMulticastDomainRequest method.
//	req, resp := client.AssociateTransitGatewayMulticastDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain
func (c *EC2) AssociateTransitGatewayMulticastDomainRequest(input *AssociateTransitGatewayMulticastDomainInput) (req *request.Request, output *AssociateTransitGatewayMulticastDomainOutput) {
	op := &request.Operation{
		Name:       opAssociateTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTransitGatewayMulticastDomainInput{}
	}

	output = &AssociateTransitGatewayMulticastDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTransitGatewayMulticastDomain API operation for Amazon Elastic Compute Cloud.
//
// Associates the specified subnets and transit gateway attachments with the
// specified transit gateway multicast domain.
//
// The transit gateway attachment must be in the available state before you
// can add a resource. Use DescribeTransitGatewayAttachments (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html)
// to see the state of the attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateTransitGatewayMulticastDomain for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain
func (c *EC2) AssociateTransitGatewayMulticastDomain(input *AssociateTransitGatewayMulticastDomainInput) (*AssociateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.AssociateTransitGatewayMulticastDomainRequest(input)
	return out, req.Send()
}

// AssociateTransitGatewayMulticastDomainWithContext is the same as AssociateTransitGatewayMulticastDomain with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTransitGatewayMulticastDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateTransitGatewayMulticastDomainWithContext(ctx aws.Context, input *AssociateTransitGatewayMulticastDomainInput, opts ...request.Option) (*AssociateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.AssociateTransitGatewayMulticastDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTransitGatewayPolicyTable = "AssociateTransitGatewayPolicyTable"

// AssociateTransitGatewayPolicyTableRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTransitGatewayPolicyTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTransitGatewayPolicyTable for more information on using the AssociateTransitGatewayPolicyTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateTransitGatewayPolicyTableRequest method.
//	req, resp := client.AssociateTransitGatewayPolicyTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable
func (c *EC2) AssociateTransitGatewayPolicyTableRequest(input *AssociateTransitGatewayPolicyTableInput) (req *request.Request, output *AssociateTransitGatewayPolicyTableOutput) {
	op := &request.Operation{
		Name:       opAssociateTransitGatewayPolicyTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTransitGatewayPolicyTableInput{}
	}

	output = &AssociateTransitGatewayPolicyTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTransitGatewayPolicyTable API operation for Amazon Elastic Compute Cloud.
//
// Associates the specified transit gateway attachment with a transit gateway
// policy table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateTransitGatewayPolicyTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable
func (c *EC2) AssociateTransitGatewayPolicyTable(input *AssociateTransitGatewayPolicyTableInput) (*AssociateTransitGatewayPolicyTableOutput, error) {
	req, out := c.AssociateTransitGatewayPolicyTableRequest(input)
	return out, req.Send()
}

// AssociateTransitGatewayPolicyTableWithContext is the same as AssociateTransitGatewayPolicyTable with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTransitGatewayPolicyTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateTransitGatewayPolicyTableWithContext(ctx aws.Context, input *AssociateTransitGatewayPolicyTableInput, opts ...request.Option) (*AssociateTransitGatewayPolicyTableOutput, error) {
	req, out := c.AssociateTransitGatewayPolicyTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTransitGatewayRouteTable = "AssociateTransitGatewayRouteTable"

// AssociateTransitGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTransitGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTransitGatewayRouteTable for more information on using the AssociateTransitGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateTransitGatewayRouteTableRequest method.
//	req, resp := client.AssociateTransitGatewayRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable
func (c *EC2) AssociateTransitGatewayRouteTableRequest(input *AssociateTransitGatewayRouteTableInput) (req *request.Request, output *AssociateTransitGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opAssociateTransitGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTransitGatewayRouteTableInput{}
	}

	output = &AssociateTransitGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTransitGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Associates the specified attachment with the specified transit gateway route
// table. You can associate only one route table with an attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateTransitGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable
func (c *EC2) AssociateTransitGatewayRouteTable(input *AssociateTransitGatewayRouteTableInput) (*AssociateTransitGatewayRouteTableOutput, error) {
	req, out := c.AssociateTransitGatewayRouteTableRequest(input)
	return out, req.Send()
}

// AssociateTransitGatewayRouteTableWithContext is the same as AssociateTransitGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTransitGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateTransitGatewayRouteTableWithContext(ctx aws.Context, input *AssociateTransitGatewayRouteTableInput, opts ...request.Option) (*AssociateTransitGatewayRouteTableOutput, error) {
	req, out := c.AssociateTransitGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateTrunkInterface = "AssociateTrunkInterface"

// AssociateTrunkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTrunkInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTrunkInterface for more information on using the AssociateTrunkInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateTrunkInterfaceRequest method.
//	req, resp := client.AssociateTrunkInterfaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface
func (c *EC2) AssociateTrunkInterfaceRequest(input *AssociateTrunkInterfaceInput) (req *request.Request, output *AssociateTrunkInterfaceOutput) {
	op := &request.Operation{
		Name:       opAssociateTrunkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTrunkInterfaceInput{}
	}

	output = &AssociateTrunkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTrunkInterface API operation for Amazon Elastic Compute Cloud.
//
// Associates a branch network interface with a trunk network interface.
//
// Before you create the association, run the create-network-interface (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)
// command and set --interface-type to trunk. You must also create a network
// interface for each branch network interface that you want to associate with
// the trunk network interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateTrunkInterface for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface
func (c *EC2) AssociateTrunkInterface(input *AssociateTrunkInterfaceInput) (*AssociateTrunkInterfaceOutput, error) {
	req, out := c.AssociateTrunkInterfaceRequest(input)
	return out, req.Send()
}

// AssociateTrunkInterfaceWithContext is the same as AssociateTrunkInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTrunkInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateTrunkInterfaceWithContext(ctx aws.Context, input *AssociateTrunkInterfaceInput, opts ...request.Option) (*AssociateTrunkInterfaceOutput, error) {
	req, out := c.AssociateTrunkInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateVpcCidrBlock = "AssociateVpcCidrBlock"

// AssociateVpcCidrBlockRequest generates a "aws/request.Request" representing the
// client's request for the AssociateVpcCidrBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateVpcCidrBlock for more information on using the AssociateVpcCidrBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateVpcCidrBlockRequest method.
//	req, resp := client.AssociateVpcCidrBlockRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock
func (c *EC2) AssociateVpcCidrBlockRequest(input *AssociateVpcCidrBlockInput) (req *request.Request, output *AssociateVpcCidrBlockOutput) {
	op := &request.Operation{
		Name:       opAssociateVpcCidrBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateVpcCidrBlockInput{}
	}

	output = &AssociateVpcCidrBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateVpcCidrBlock API operation for Amazon Elastic Compute Cloud.
//
// Associates a CIDR block with your VPC. You can associate a secondary IPv4
// CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from
// an IPv6 address pool that you provisioned through bring your own IP addresses
// (BYOIP (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)).
//
// You must specify one of the following in the request: an IPv4 CIDR block,
// an IPv6 pool, or an Amazon-provided IPv6 CIDR block.
//
// For more information about associating CIDR blocks with your VPC and applicable
// restrictions, see IP addressing for your VPCs and subnets (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AssociateVpcCidrBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock
func (c *EC2) AssociateVpcCidrBlock(input *AssociateVpcCidrBlockInput) (*AssociateVpcCidrBlockOutput, error) {
	req, out := c.AssociateVpcCidrBlockRequest(input)
	return out, req.Send()
}

// AssociateVpcCidrBlockWithContext is the same as AssociateVpcCidrBlock with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateVpcCidrBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AssociateVpcCidrBlockWithContext(ctx aws.Context, input *AssociateVpcCidrBlockInput, opts ...request.Option) (*AssociateVpcCidrBlockOutput, error) {
	req, out := c.AssociateVpcCidrBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachClassicLinkVpc = "AttachClassicLinkVpc"

// AttachClassicLinkVpcRequest generates a "aws/request.Request" representing the
// client's request for the AttachClassicLinkVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachClassicLinkVpc for more information on using the AttachClassicLinkVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachClassicLinkVpcRequest method.
//	req, resp := client.AttachClassicLinkVpcRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc
func (c *EC2) AttachClassicLinkVpcRequest(input *AttachClassicLinkVpcInput) (req *request.Request, output *AttachClassicLinkVpcOutput) {
	op := &request.Operation{
		Name:       opAttachClassicLinkVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachClassicLinkVpcInput{}
	}

	output = &AttachClassicLinkVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachClassicLinkVpc API operation for Amazon Elastic Compute Cloud.
//
// This action is deprecated.
//
// Links an EC2-Classic instance to a ClassicLink-enabled VPC through one or
// more of the VPC security groups. You cannot link an EC2-Classic instance
// to more than one VPC at a time. You can only link an instance that's in the
// running state. An instance is automatically unlinked from a VPC when it's
// stopped - you can link it to the VPC again when you restart it.
//
// After you've linked an instance, you cannot change the VPC security groups
// that are associated with it. To change the security groups, you must first
// unlink the instance, and then link it again.
//
// Linking your instance to a VPC is sometimes referred to as attaching your
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachClassicLinkVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc
func (c *EC2) AttachClassicLinkVpc(input *AttachClassicLinkVpcInput) (*AttachClassicLinkVpcOutput, error) {
	req, out := c.AttachClassicLinkVpcRequest(input)
	return out, req.Send()
}

// AttachClassicLinkVpcWithContext is the same as AttachClassicLinkVpc with the addition of
// the ability to pass a context and additional request options.
//
// See AttachClassicLinkVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachClassicLinkVpcWithContext(ctx aws.Context, input *AttachClassicLinkVpcInput, opts ...request.Option) (*AttachClassicLinkVpcOutput, error) {
	req, out := c.AttachClassicLinkVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachInternetGateway = "AttachInternetGateway"

// AttachInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the AttachInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachInternetGateway for more information on using the AttachInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachInternetGatewayRequest method.
//	req, resp := client.AttachInternetGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway
func (c *EC2) AttachInternetGatewayRequest(input *AttachInternetGatewayInput) (req *request.Request, output *AttachInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInternetGatewayInput{}
	}

	output = &AttachInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Attaches an internet gateway or a virtual private gateway to a VPC, enabling
// connectivity between the internet and the VPC. For more information, see
// Internet gateways (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway
func (c *EC2) AttachInternetGateway(input *AttachInternetGatewayInput) (*AttachInternetGatewayOutput, error) {
	req, out := c.AttachInternetGatewayRequest(input)
	return out, req.Send()
}

// AttachInternetGatewayWithContext is the same as AttachInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See AttachInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachInternetGatewayWithContext(ctx aws.Context, input *AttachInternetGatewayInput, opts ...request.Option) (*AttachInternetGatewayOutput, error) {
	req, out := c.AttachInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachNetworkInterface = "AttachNetworkInterface"

// AttachNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AttachNetworkInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachNetworkInterface for more information on using the AttachNetworkInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachNetworkInterfaceRequest method.
//	req, resp := client.AttachNetworkInterfaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface
func (c *EC2) AttachNetworkInterfaceRequest(input *AttachNetworkInterfaceInput) (req *request.Request, output *AttachNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opAttachNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachNetworkInterfaceInput{}
	}

	output = &AttachNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Attaches a network interface to an instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachNetworkInterface for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface
func (c *EC2) AttachNetworkInterface(input *AttachNetworkInterfaceInput) (*AttachNetworkInterfaceOutput, error) {
	req, out := c.AttachNetworkInterfaceRequest(input)
	return out, req.Send()
}

// AttachNetworkInterfaceWithContext is the same as AttachNetworkInterface with the addition of
// the ability to pass a context and additional request options.
//
// See AttachNetworkInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachNetworkInterfaceWithContext(ctx aws.Context, input *AttachNetworkInterfaceInput, opts ...request.Option) (*AttachNetworkInterfaceOutput, error) {
	req, out := c.AttachNetworkInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachVerifiedAccessTrustProvider = "AttachVerifiedAccessTrustProvider"

// AttachVerifiedAccessTrustProviderRequest generates a "aws/request.Request" representing the
// client's request for the AttachVerifiedAccessTrustProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachVerifiedAccessTrustProvider for more information on using the AttachVerifiedAccessTrustProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachVerifiedAccessTrustProviderRequest method.
//	req, resp := client.AttachVerifiedAccessTrustProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider
func (c *EC2) AttachVerifiedAccessTrustProviderRequest(input *AttachVerifiedAccessTrustProviderInput) (req *request.Request, output *AttachVerifiedAccessTrustProviderOutput) {
	op := &request.Operation{
		Name:       opAttachVerifiedAccessTrustProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVerifiedAccessTrustProviderInput{}
	}

	output = &AttachVerifiedAccessTrustProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVerifiedAccessTrustProvider API operation for Amazon Elastic Compute Cloud.
//
// Attaches the specified Amazon Web Services Verified Access trust provider
// to the specified Amazon Web Services Verified Access instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachVerifiedAccessTrustProvider for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider
func (c *EC2) AttachVerifiedAccessTrustProvider(input *AttachVerifiedAccessTrustProviderInput) (*AttachVerifiedAccessTrustProviderOutput, error) {
	req, out := c.AttachVerifiedAccessTrustProviderRequest(input)
	return out, req.Send()
}

// AttachVerifiedAccessTrustProviderWithContext is the same as AttachVerifiedAccessTrustProvider with the addition of
// the ability to pass a context and additional request options.
//
// See AttachVerifiedAccessTrustProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachVerifiedAccessTrustProviderWithContext(ctx aws.Context, input *AttachVerifiedAccessTrustProviderInput, opts ...request.Option) (*AttachVerifiedAccessTrustProviderOutput, error) {
	req, out := c.AttachVerifiedAccessTrustProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachVolume = "AttachVolume"

// AttachVolumeRequest generates a "aws/request.Request" representing the
// client's request for the AttachVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachVolume for more information on using the AttachVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachVolumeRequest method.
//	req, resp := client.AttachVolumeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume
func (c *EC2) AttachVolumeRequest(input *AttachVolumeInput) (req *request.Request, output *VolumeAttachment) {
	op := &request.Operation{
		Name:       opAttachVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVolumeInput{}
	}

	output = &VolumeAttachment{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVolume API operation for Amazon Elastic Compute Cloud.
//
// Attaches an EBS volume to a running or stopped instance and exposes it to
// the instance with the specified device name.
//
// Encrypted EBS volumes must be attached to instances that support Amazon EBS
// encryption. For more information, see Amazon EBS encryption (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html)
// in the Amazon EBS User Guide.
//
// After you attach an EBS volume, you must make it available. For more information,
// see Make an EBS volume available for use (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html).
//
// If a volume has an Amazon Web Services Marketplace product code:
//
//   - The volume can be attached only to a stopped instance.
//
//   - Amazon Web Services Marketplace product codes are copied from the volume
//     to the instance.
//
//   - You must be subscribed to the product.
//
//   - The instance type and operating system of the instance must support
//     the product. For example, you can't detach a volume from a Windows instance
//     and attach it to a Linux instance.
//
// For more information, see Attach an Amazon EBS volume to an instance (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html)
// in the Amazon EBS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachVolume for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume
func (c *EC2) AttachVolume(input *AttachVolumeInput) (*VolumeAttachment, error) {
	req, out := c.AttachVolumeRequest(input)
	return out, req.Send()
}

// AttachVolumeWithContext is the same as AttachVolume with the addition of
// the ability to pass a context and additional request options.
//
// See AttachVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachVolumeWithContext(ctx aws.Context, input *AttachVolumeInput, opts ...request.Option) (*VolumeAttachment, error) {
	req, out := c.AttachVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachVpnGateway = "AttachVpnGateway"

// AttachVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the AttachVpnGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachVpnGateway for more information on using the AttachVpnGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachVpnGatewayRequest method.
//	req, resp := client.AttachVpnGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway
func (c *EC2) AttachVpnGatewayRequest(input *AttachVpnGatewayInput) (req *request.Request, output *AttachVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opAttachVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachVpnGatewayInput{}
	}

	output = &AttachVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Attaches a virtual private gateway to a VPC. You can attach one virtual private
// gateway to one VPC at a time.
//
// For more information, see Amazon Web Services Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the Amazon Web Services Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AttachVpnGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway
func (c *EC2) AttachVpnGateway(input *AttachVpnGatewayInput) (*AttachVpnGatewayOutput, error) {
	req, out := c.AttachVpnGatewayRequest(input)
	return out, req.Send()
}

// AttachVpnGatewayWithContext is the same as AttachVpnGateway with the addition of
// the ability to pass a context and additional request options.
//
// See AttachVpnGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AttachVpnGatewayWithContext(ctx aws.Context, input *AttachVpnGatewayInput, opts ...request.Option) (*AttachVpnGatewayOutput, error) {
	req, out := c.AttachVpnGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeClientVpnIngress = "AuthorizeClientVpnIngress"

// AuthorizeClientVpnIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeClientVpnIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeClientVpnIngress for more information on using the AuthorizeClientVpnIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AuthorizeClientVpnIngressRequest method.
//	req, resp := client.AuthorizeClientVpnIngressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress
func (c *EC2) AuthorizeClientVpnIngressRequest(input *AuthorizeClientVpnIngressInput) (req *request.Request, output *AuthorizeClientVpnIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeClientVpnIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeClientVpnIngressInput{}
	}

	output = &AuthorizeClientVpnIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeClientVpnIngress API operation for Amazon Elastic Compute Cloud.
//
// Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization
// rules act as firewall rules that grant access to networks. You must configure
// ingress authorization rules to enable clients to access resources in Amazon
// Web Services or on-premises networks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeClientVpnIngress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress
func (c *EC2) AuthorizeClientVpnIngress(input *AuthorizeClientVpnIngressInput) (*AuthorizeClientVpnIngressOutput, error) {
	req, out := c.AuthorizeClientVpnIngressRequest(input)
	return out, req.Send()
}

// AuthorizeClientVpnIngressWithContext is the same as AuthorizeClientVpnIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeClientVpnIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AuthorizeClientVpnIngressWithContext(ctx aws.Context, input *AuthorizeClientVpnIngressInput, opts ...request.Option) (*AuthorizeClientVpnIngressOutput, error) {
	req, out := c.AuthorizeClientVpnIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeSecurityGroupEgress = "AuthorizeSecurityGroupEgress"

// AuthorizeSecurityGroupEgressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSecurityGroupEgress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeSecurityGroupEgress for more information on using the AuthorizeSecurityGroupEgress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AuthorizeSecurityGroupEgressRequest method.
//	req, resp := client.AuthorizeSecurityGroupEgressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress
func (c *EC2) AuthorizeSecurityGroupEgressRequest(input *AuthorizeSecurityGroupEgressInput) (req *request.Request, output *AuthorizeSecurityGroupEgressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupEgress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupEgressInput{}
	}

	output = &AuthorizeSecurityGroupEgressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeSecurityGroupEgress API operation for Amazon Elastic Compute Cloud.
//
// Adds the specified outbound (egress) rules to a security group.
//
// An outbound rule permits instances to send traffic to the specified IPv4
// or IPv6 address ranges, the IP address ranges specified by a prefix list,
// or the instances that are associated with a source security group. For more
// information, see Security group rules (https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html).
//
// You must specify exactly one of the following destinations: an IPv4 or IPv6
// address range, a prefix list, or a security group. You must specify a protocol
// for each rule (for example, TCP). If the protocol is TCP or UDP, you must
// also specify a port or port range. If the protocol is ICMP or ICMPv6, you
// must also specify the ICMP type and code.
//
// Rule changes are propagated to instances associated with the security group
// as quickly as possible. However, a small delay might occur.
//
// For examples of rules that you can add to security groups for specific access
// scenarios, see Security group rules for different use cases (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html)
// in the Amazon EC2 User Guide.
//
// For information about security group quotas, see Amazon VPC quotas (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeSecurityGroupEgress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress
func (c *EC2) AuthorizeSecurityGroupEgress(input *AuthorizeSecurityGroupEgressInput) (*AuthorizeSecurityGroupEgressOutput, error) {
	req, out := c.AuthorizeSecurityGroupEgressRequest(input)
	return out, req.Send()
}

// AuthorizeSecurityGroupEgressWithContext is the same as AuthorizeSecurityGroupEgress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeSecurityGroupEgress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AuthorizeSecurityGroupEgressWithContext(ctx aws.Context, input *AuthorizeSecurityGroupEgressInput, opts ...request.Option) (*AuthorizeSecurityGroupEgressOutput, error) {
	req, out := c.AuthorizeSecurityGroupEgressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeSecurityGroupIngress = "AuthorizeSecurityGroupIngress"

// AuthorizeSecurityGroupIngressRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeSecurityGroupIngress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeSecurityGroupIngress for more information on using the AuthorizeSecurityGroupIngress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AuthorizeSecurityGroupIngressRequest method.
//	req, resp := client.AuthorizeSecurityGroupIngressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress
func (c *EC2) AuthorizeSecurityGroupIngressRequest(input *AuthorizeSecurityGroupIngressInput) (req *request.Request, output *AuthorizeSecurityGroupIngressOutput) {
	op := &request.Operation{
		Name:       opAuthorizeSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeSecurityGroupIngressInput{}
	}

	output = &AuthorizeSecurityGroupIngressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AuthorizeSecurityGroupIngress API operation for Amazon Elastic Compute Cloud.
//
// Adds the specified inbound (ingress) rules to a security group.
//
// An inbound rule permits instances to receive traffic from the specified IPv4
// or IPv6 address range, the IP address ranges that are specified by a prefix
// list, or the instances that are associated with a destination security group.
// For more information, see Security group rules (https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html).
//
// You must specify exactly one of the following sources: an IPv4 or IPv6 address
// range, a prefix list, or a security group. You must specify a protocol for
// each rule (for example, TCP). If the protocol is TCP or UDP, you must also
// specify a port or port range. If the protocol is ICMP or ICMPv6, you must
// also specify the ICMP/ICMPv6 type and code.
//
// Rule changes are propagated to instances associated with the security group
// as quickly as possible. However, a small delay might occur.
//
// For examples of rules that you can add to security groups for specific access
// scenarios, see Security group rules for different use cases (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html)
// in the Amazon EC2 User Guide.
//
// For more information about security group quotas, see Amazon VPC quotas (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation AuthorizeSecurityGroupIngress for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress
func (c *EC2) AuthorizeSecurityGroupIngress(input *AuthorizeSecurityGroupIngressInput) (*AuthorizeSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeSecurityGroupIngressRequest(input)
	return out, req.Send()
}

// AuthorizeSecurityGroupIngressWithContext is the same as AuthorizeSecurityGroupIngress with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeSecurityGroupIngress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) AuthorizeSecurityGroupIngressWithContext(ctx aws.Context, input *AuthorizeSecurityGroupIngressInput, opts ...request.Option) (*AuthorizeSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeSecurityGroupIngressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBundleInstance = "BundleInstance"

// BundleInstanceRequest generates a "aws/request.Request" representing the
// client's request for the BundleInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BundleInstance for more information on using the BundleInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BundleInstanceRequest method.
//	req, resp := client.BundleInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance
func (c *EC2) BundleInstanceRequest(input *BundleInstanceInput) (req *request.Request, output *BundleInstanceOutput) {
	op := &request.Operation{
		Name:       opBundleInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BundleInstanceInput{}
	}

	output = &BundleInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BundleInstance API operation for Amazon Elastic Compute Cloud.
//
// Bundles an Amazon instance store-backed Windows instance.
//
// During bundling, only the root device volume (C:\) is bundled. Data on other
// instance store volumes is not preserved.
//
// This action is not applicable for Linux/Unix instances or Windows instances
// that are backed by Amazon EBS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation BundleInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance
func (c *EC2) BundleInstance(input *BundleInstanceInput) (*BundleInstanceOutput, error) {
	req, out := c.BundleInstanceRequest(input)
	return out, req.Send()
}

// BundleInstanceWithContext is the same as BundleInstance with the addition of
// the ability to pass a context and additional request options.
//
// See BundleInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) BundleInstanceWithContext(ctx aws.Context, input *BundleInstanceInput, opts ...request.Option) (*BundleInstanceOutput, error) {
	req, out := c.BundleInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelBundleTask = "CancelBundleTask"

// CancelBundleTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelBundleTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelBundleTask for more information on using the CancelBundleTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelBundleTaskRequest method.
//	req, resp := client.CancelBundleTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask
func (c *EC2) CancelBundleTaskRequest(input *CancelBundleTaskInput) (req *request.Request, output *CancelBundleTaskOutput) {
	op := &request.Operation{
		Name:       opCancelBundleTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelBundleTaskInput{}
	}

	output = &CancelBundleTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelBundleTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels a bundling operation for an instance store-backed Windows instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelBundleTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask
func (c *EC2) CancelBundleTask(input *CancelBundleTaskInput) (*CancelBundleTaskOutput, error) {
	req, out := c.CancelBundleTaskRequest(input)
	return out, req.Send()
}

// CancelBundleTaskWithContext is the same as CancelBundleTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelBundleTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelBundleTaskWithContext(ctx aws.Context, input *CancelBundleTaskInput, opts ...request.Option) (*CancelBundleTaskOutput, error) {
	req, out := c.CancelBundleTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCapacityReservation = "CancelCapacityReservation"

// CancelCapacityReservationRequest generates a "aws/request.Request" representing the
// client's request for the CancelCapacityReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCapacityReservation for more information on using the CancelCapacityReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelCapacityReservationRequest method.
//	req, resp := client.CancelCapacityReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation
func (c *EC2) CancelCapacityReservationRequest(input *CancelCapacityReservationInput) (req *request.Request, output *CancelCapacityReservationOutput) {
	op := &request.Operation{
		Name:       opCancelCapacityReservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCapacityReservationInput{}
	}

	output = &CancelCapacityReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelCapacityReservation API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Capacity Reservation, releases the reserved capacity,
// and changes the Capacity Reservation's state to cancelled.
//
// Instances running in the reserved capacity continue running until you stop
// them. Stopped instances that target the Capacity Reservation can no longer
// launch. Modify these instances to either target a different Capacity Reservation,
// launch On-Demand Instance capacity, or run in any open Capacity Reservation
// that has matching attributes and sufficient capacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelCapacityReservation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation
func (c *EC2) CancelCapacityReservation(input *CancelCapacityReservationInput) (*CancelCapacityReservationOutput, error) {
	req, out := c.CancelCapacityReservationRequest(input)
	return out, req.Send()
}

// CancelCapacityReservationWithContext is the same as CancelCapacityReservation with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCapacityReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelCapacityReservationWithContext(ctx aws.Context, input *CancelCapacityReservationInput, opts ...request.Option) (*CancelCapacityReservationOutput, error) {
	req, out := c.CancelCapacityReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCapacityReservationFleets = "CancelCapacityReservationFleets"

// CancelCapacityReservationFleetsRequest generates a "aws/request.Request" representing the
// client's request for the CancelCapacityReservationFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCapacityReservationFleets for more information on using the CancelCapacityReservationFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelCapacityReservationFleetsRequest method.
//	req, resp := client.CancelCapacityReservationFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets
func (c *EC2) CancelCapacityReservationFleetsRequest(input *CancelCapacityReservationFleetsInput) (req *request.Request, output *CancelCapacityReservationFleetsOutput) {
	op := &request.Operation{
		Name:       opCancelCapacityReservationFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCapacityReservationFleetsInput{}
	}

	output = &CancelCapacityReservationFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelCapacityReservationFleets API operation for Amazon Elastic Compute Cloud.
//
// Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity
// Reservation Fleet, the following happens:
//
//   - The Capacity Reservation Fleet's status changes to cancelled.
//
//   - The individual Capacity Reservations in the Fleet are cancelled. Instances
//     running in the Capacity Reservations at the time of cancelling the Fleet
//     continue to run in shared capacity.
//
//   - The Fleet stops creating new Capacity Reservations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelCapacityReservationFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets
func (c *EC2) CancelCapacityReservationFleets(input *CancelCapacityReservationFleetsInput) (*CancelCapacityReservationFleetsOutput, error) {
	req, out := c.CancelCapacityReservationFleetsRequest(input)
	return out, req.Send()
}

// CancelCapacityReservationFleetsWithContext is the same as CancelCapacityReservationFleets with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCapacityReservationFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelCapacityReservationFleetsWithContext(ctx aws.Context, input *CancelCapacityReservationFleetsInput, opts ...request.Option) (*CancelCapacityReservationFleetsOutput, error) {
	req, out := c.CancelCapacityReservationFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelConversionTask = "CancelConversionTask"

// CancelConversionTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelConversionTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelConversionTask for more information on using the CancelConversionTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelConversionTaskRequest method.
//	req, resp := client.CancelConversionTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask
func (c *EC2) CancelConversionTaskRequest(input *CancelConversionTaskInput) (req *request.Request, output *CancelConversionTaskOutput) {
	op := &request.Operation{
		Name:       opCancelConversionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelConversionTaskInput{}
	}

	output = &CancelConversionTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelConversionTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an active conversion task. The task can be the import of an instance
// or volume. The action removes all artifacts of the conversion, including
// a partially uploaded volume or instance. If the conversion is complete or
// is in the process of transferring the final disk image, the command fails
// and returns an exception.
//
// For more information, see Importing a Virtual Machine Using the Amazon EC2
// CLI (https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelConversionTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask
func (c *EC2) CancelConversionTask(input *CancelConversionTaskInput) (*CancelConversionTaskOutput, error) {
	req, out := c.CancelConversionTaskRequest(input)
	return out, req.Send()
}

// CancelConversionTaskWithContext is the same as CancelConversionTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelConversionTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelConversionTaskWithContext(ctx aws.Context, input *CancelConversionTaskInput, opts ...request.Option) (*CancelConversionTaskOutput, error) {
	req, out := c.CancelConversionTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelExportTask = "CancelExportTask"

// CancelExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelExportTask for more information on using the CancelExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelExportTaskRequest method.
//	req, resp := client.CancelExportTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask
func (c *EC2) CancelExportTaskRequest(input *CancelExportTaskInput) (req *request.Request, output *CancelExportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelExportTaskInput{}
	}

	output = &CancelExportTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelExportTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an active export task. The request removes all artifacts of the export,
// including any partially-created Amazon S3 objects. If the export task is
// complete or is in the process of transferring the final disk image, the command
// fails and returns an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelExportTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask
func (c *EC2) CancelExportTask(input *CancelExportTaskInput) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	return out, req.Send()
}

// CancelExportTaskWithContext is the same as CancelExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelExportTaskWithContext(ctx aws.Context, input *CancelExportTaskInput, opts ...request.Option) (*CancelExportTaskOutput, error) {
	req, out := c.CancelExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelImageLaunchPermission = "CancelImageLaunchPermission"

// CancelImageLaunchPermissionRequest generates a "aws/request.Request" representing the
// client's request for the CancelImageLaunchPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelImageLaunchPermission for more information on using the CancelImageLaunchPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelImageLaunchPermissionRequest method.
//	req, resp := client.CancelImageLaunchPermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission
func (c *EC2) CancelImageLaunchPermissionRequest(input *CancelImageLaunchPermissionInput) (req *request.Request, output *CancelImageLaunchPermissionOutput) {
	op := &request.Operation{
		Name:       opCancelImageLaunchPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelImageLaunchPermissionInput{}
	}

	output = &CancelImageLaunchPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelImageLaunchPermission API operation for Amazon Elastic Compute Cloud.
//
// Removes your Amazon Web Services account from the launch permissions for
// the specified AMI. For more information, see Cancel having an AMI shared
// with your Amazon Web Services account (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelImageLaunchPermission for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission
func (c *EC2) CancelImageLaunchPermission(input *CancelImageLaunchPermissionInput) (*CancelImageLaunchPermissionOutput, error) {
	req, out := c.CancelImageLaunchPermissionRequest(input)
	return out, req.Send()
}

// CancelImageLaunchPermissionWithContext is the same as CancelImageLaunchPermission with the addition of
// the ability to pass a context and additional request options.
//
// See CancelImageLaunchPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelImageLaunchPermissionWithContext(ctx aws.Context, input *CancelImageLaunchPermissionInput, opts ...request.Option) (*CancelImageLaunchPermissionOutput, error) {
	req, out := c.CancelImageLaunchPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelImportTask = "CancelImportTask"

// CancelImportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CancelImportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelImportTask for more information on using the CancelImportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelImportTaskRequest method.
//	req, resp := client.CancelImportTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask
func (c *EC2) CancelImportTaskRequest(input *CancelImportTaskInput) (req *request.Request, output *CancelImportTaskOutput) {
	op := &request.Operation{
		Name:       opCancelImportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelImportTaskInput{}
	}

	output = &CancelImportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelImportTask API operation for Amazon Elastic Compute Cloud.
//
// Cancels an in-process import virtual machine or import snapshot task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelImportTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask
func (c *EC2) CancelImportTask(input *CancelImportTaskInput) (*CancelImportTaskOutput, error) {
	req, out := c.CancelImportTaskRequest(input)
	return out, req.Send()
}

// CancelImportTaskWithContext is the same as CancelImportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CancelImportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelImportTaskWithContext(ctx aws.Context, input *CancelImportTaskInput, opts ...request.Option) (*CancelImportTaskOutput, error) {
	req, out := c.CancelImportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelReservedInstancesListing = "CancelReservedInstancesListing"

// CancelReservedInstancesListingRequest generates a "aws/request.Request" representing the
// client's request for the CancelReservedInstancesListing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelReservedInstancesListing for more information on using the CancelReservedInstancesListing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelReservedInstancesListingRequest method.
//	req, resp := client.CancelReservedInstancesListingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing
func (c *EC2) CancelReservedInstancesListingRequest(input *CancelReservedInstancesListingInput) (req *request.Request, output *CancelReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCancelReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelReservedInstancesListingInput{}
	}

	output = &CancelReservedInstancesListingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelReservedInstancesListing API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Reserved Instance listing in the Reserved Instance
// Marketplace.
//
// For more information, see Reserved Instance Marketplace (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelReservedInstancesListing for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing
func (c *EC2) CancelReservedInstancesListing(input *CancelReservedInstancesListingInput) (*CancelReservedInstancesListingOutput, error) {
	req, out := c.CancelReservedInstancesListingRequest(input)
	return out, req.Send()
}

// CancelReservedInstancesListingWithContext is the same as CancelReservedInstancesListing with the addition of
// the ability to pass a context and additional request options.
//
// See CancelReservedInstancesListing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelReservedInstancesListingWithContext(ctx aws.Context, input *CancelReservedInstancesListingInput, opts ...request.Option) (*CancelReservedInstancesListingOutput, error) {
	req, out := c.CancelReservedInstancesListingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSpotFleetRequests = "CancelSpotFleetRequests"

// CancelSpotFleetRequestsRequest generates a "aws/request.Request" representing the
// client's request for the CancelSpotFleetRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSpotFleetRequests for more information on using the CancelSpotFleetRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelSpotFleetRequestsRequest method.
//	req, resp := client.CancelSpotFleetRequestsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests
func (c *EC2) CancelSpotFleetRequestsRequest(input *CancelSpotFleetRequestsInput) (req *request.Request, output *CancelSpotFleetRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotFleetRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotFleetRequestsInput{}
	}

	output = &CancelSpotFleetRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSpotFleetRequests API operation for Amazon Elastic Compute Cloud.
//
// Cancels the specified Spot Fleet requests.
//
// After you cancel a Spot Fleet request, the Spot Fleet launches no new instances.
//
// You must also specify whether a canceled Spot Fleet request should terminate
// its instances. If you choose to terminate the instances, the Spot Fleet request
// enters the cancelled_terminating state. Otherwise, the Spot Fleet request
// enters the cancelled_running state and the instances continue to run until
// they are interrupted or you terminate them manually.
//
// Restrictions
//
//   - You can delete up to 100 fleets in a single request. If you exceed the
//     specified number, no fleets are deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelSpotFleetRequests for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests
func (c *EC2) CancelSpotFleetRequests(input *CancelSpotFleetRequestsInput) (*CancelSpotFleetRequestsOutput, error) {
	req, out := c.CancelSpotFleetRequestsRequest(input)
	return out, req.Send()
}

// CancelSpotFleetRequestsWithContext is the same as CancelSpotFleetRequests with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSpotFleetRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelSpotFleetRequestsWithContext(ctx aws.Context, input *CancelSpotFleetRequestsInput, opts ...request.Option) (*CancelSpotFleetRequestsOutput, error) {
	req, out := c.CancelSpotFleetRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSpotInstanceRequests = "CancelSpotInstanceRequests"

// CancelSpotInstanceRequestsRequest generates a "aws/request.Request" representing the
// client's request for the CancelSpotInstanceRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSpotInstanceRequests for more information on using the CancelSpotInstanceRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelSpotInstanceRequestsRequest method.
//	req, resp := client.CancelSpotInstanceRequestsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests
func (c *EC2) CancelSpotInstanceRequestsRequest(input *CancelSpotInstanceRequestsInput) (req *request.Request, output *CancelSpotInstanceRequestsOutput) {
	op := &request.Operation{
		Name:       opCancelSpotInstanceRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSpotInstanceRequestsInput{}
	}

	output = &CancelSpotInstanceRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSpotInstanceRequests API operation for Amazon Elastic Compute Cloud.
//
// Cancels one or more Spot Instance requests.
//
// Canceling a Spot Instance request does not terminate running Spot Instances
// associated with the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CancelSpotInstanceRequests for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests
func (c *EC2) CancelSpotInstanceRequests(input *CancelSpotInstanceRequestsInput) (*CancelSpotInstanceRequestsOutput, error) {
	req, out := c.CancelSpotInstanceRequestsRequest(input)
	return out, req.Send()
}

// CancelSpotInstanceRequestsWithContext is the same as CancelSpotInstanceRequests with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSpotInstanceRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CancelSpotInstanceRequestsWithContext(ctx aws.Context, input *CancelSpotInstanceRequestsInput, opts ...request.Option) (*CancelSpotInstanceRequestsOutput, error) {
	req, out := c.CancelSpotInstanceRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConfirmProductInstance = "ConfirmProductInstance"

// ConfirmProductInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmProductInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConfirmProductInstance for more information on using the ConfirmProductInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ConfirmProductInstanceRequest method.
//	req, resp := client.ConfirmProductInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance
func (c *EC2) ConfirmProductInstanceRequest(input *ConfirmProductInstanceInput) (req *request.Request, output *ConfirmProductInstanceOutput) {
	op := &request.Operation{
		Name:       opConfirmProductInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmProductInstanceInput{}
	}

	output = &ConfirmProductInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmProductInstance API operation for Amazon Elastic Compute Cloud.
//
// Determines whether a product code is associated with an instance. This action
// can only be used by the owner of the product code. It is useful when a product
// code owner must verify whether another user's instance is eligible for support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation ConfirmProductInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance
func (c *EC2) ConfirmProductInstance(input *ConfirmProductInstanceInput) (*ConfirmProductInstanceOutput, error) {
	req, out := c.ConfirmProductInstanceRequest(input)
	return out, req.Send()
}

// ConfirmProductInstanceWithContext is the same as ConfirmProductInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ConfirmProductInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) ConfirmProductInstanceWithContext(ctx aws.Context, input *ConfirmProductInstanceInput, opts ...request.Option) (*ConfirmProductInstanceOutput, error) {
	req, out := c.ConfirmProductInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyFpgaImage = "CopyFpgaImage"

// CopyFpgaImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyFpgaImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyFpgaImage for more information on using the CopyFpgaImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyFpgaImageRequest method.
//	req, resp := client.CopyFpgaImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage
func (c *EC2) CopyFpgaImageRequest(input *CopyFpgaImageInput) (req *request.Request, output *CopyFpgaImageOutput) {
	op := &request.Operation{
		Name:       opCopyFpgaImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyFpgaImageInput{}
	}

	output = &CopyFpgaImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyFpgaImage API operation for Amazon Elastic Compute Cloud.
//
// Copies the specified Amazon FPGA Image (AFI) to the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopyFpgaImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage
func (c *EC2) CopyFpgaImage(input *CopyFpgaImageInput) (*CopyFpgaImageOutput, error) {
	req, out := c.CopyFpgaImageRequest(input)
	return out, req.Send()
}

// CopyFpgaImageWithContext is the same as CopyFpgaImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyFpgaImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CopyFpgaImageWithContext(ctx aws.Context, input *CopyFpgaImageInput, opts ...request.Option) (*CopyFpgaImageOutput, error) {
	req, out := c.CopyFpgaImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyImage = "CopyImage"

// CopyImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyImage for more information on using the CopyImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyImageRequest method.
//	req, resp := client.CopyImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage
func (c *EC2) CopyImageRequest(input *CopyImageInput) (req *request.Request, output *CopyImageOutput) {
	op := &request.Operation{
		Name:       opCopyImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyImageInput{}
	}

	output = &CopyImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyImage API operation for Amazon Elastic Compute Cloud.
//
// Initiates the copy of an AMI. You can copy an AMI from one Region to another,
// or from a Region to an Outpost. You can't copy an AMI from an Outpost to
// a Region, from one Outpost to another, or within the same Outpost. To copy
// an AMI to another partition, see CreateStoreImageTask (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html).
//
// To copy an AMI from one Region to another, specify the source Region using
// the SourceRegion parameter, and specify the destination Region using its
// endpoint. Copies of encrypted backing snapshots for the AMI are encrypted.
// Copies of unencrypted backing snapshots remain unencrypted, unless you set
// Encrypted during the copy operation. You cannot create an unencrypted copy
// of an encrypted backing snapshot.
//
// To copy an AMI from a Region to an Outpost, specify the source Region using
// the SourceRegion parameter, and specify the ARN of the destination Outpost
// using DestinationOutpostArn. Backing snapshots copied to an Outpost are encrypted
// by default using the default encryption key for the Region, or a different
// key that you specify in the request using KmsKeyId. Outposts do not support
// unencrypted snapshots. For more information, Amazon EBS local snapshots on
// Outposts (https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami)
// in the Amazon EBS User Guide.
//
// For more information about the prerequisites and limits when copying an AMI,
// see Copy an AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopyImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage
func (c *EC2) CopyImage(input *CopyImageInput) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	return out, req.Send()
}

// CopyImageWithContext is the same as CopyImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CopyImageWithContext(ctx aws.Context, input *CopyImageInput, opts ...request.Option) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopySnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopySnapshot for more information on using the CopySnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopySnapshotRequest method.
//	req, resp := client.CopySnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot
func (c *EC2) CopySnapshotRequest(input *CopySnapshotInput) (req *request.Request, output *CopySnapshotOutput) {
	op := &request.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	output = &CopySnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopySnapshot API operation for Amazon Elastic Compute Cloud.
//
// Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
// S3. You can copy a snapshot within the same Region, from one Region to another,
// or from a Region to an Outpost. You can't copy a snapshot from an Outpost
// to a Region, from one Outpost to another, or within the same Outpost.
//
// You can use the snapshot to create EBS volumes or Amazon Machine Images (AMIs).
//
// When copying snapshots to a Region, copies of encrypted EBS snapshots remain
// encrypted. Copies of unencrypted snapshots remain unencrypted, unless you
// enable encryption for the snapshot copy operation. By default, encrypted
// snapshot copies use the default Key Management Service (KMS) KMS key; however,
// you can specify a different KMS key. To copy an encrypted snapshot that has
// been shared from another account, you must have permissions for the KMS key
// used to encrypt the snapshot.
//
// Snapshots copied to an Outpost are encrypted by default using the default
// encryption key for the Region, or a different key that you specify in the
// request using KmsKeyId. Outposts do not support unencrypted snapshots. For
// more information, Amazon EBS local snapshots on Outposts (https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami)
// in the Amazon EBS User Guide.
//
// Snapshots created by copying another snapshot have an arbitrary volume ID
// that should not be used for any purpose.
//
// For more information, see Copy an Amazon EBS snapshot (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html)
// in the Amazon EBS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CopySnapshot for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot
func (c *EC2) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	return out, req.Send()
}

// CopySnapshotWithContext is the same as CopySnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopySnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CopySnapshotWithContext(ctx aws.Context, input *CopySnapshotInput, opts ...request.Option) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCapacityReservation = "CreateCapacityReservation"

// CreateCapacityReservationRequest generates a "aws/request.Request" representing the
// client's request for the CreateCapacityReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCapacityReservation for more information on using the CreateCapacityReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCapacityReservationRequest method.
//	req, resp := client.CreateCapacityReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation
func (c *EC2) CreateCapacityReservationRequest(input *CreateCapacityReservationInput) (req *request.Request, output *CreateCapacityReservationOutput) {
	op := &request.Operation{
		Name:       opCreateCapacityReservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCapacityReservationInput{}
	}

	output = &CreateCapacityReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCapacityReservation API operation for Amazon Elastic Compute Cloud.
//
// Creates a new Capacity Reservation with the specified attributes.
//
// Capacity Reservations enable you to reserve capacity for your Amazon EC2
// instances in a specific Availability Zone for any duration. This gives you
// the flexibility to selectively add capacity reservations and still get the
// Regional RI discounts for that usage. By creating Capacity Reservations,
// you ensure that you always have access to Amazon EC2 capacity when you need
// it, for as long as you need it. For more information, see Capacity Reservations
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html)
// in the Amazon EC2 User Guide.
//
// Your request to create a Capacity Reservation could fail if Amazon EC2 does
// not have sufficient capacity to fulfill the request. If your request fails
// due to Amazon EC2 capacity constraints, either try again at a later time,
// try in a different Availability Zone, or request a smaller capacity reservation.
// If your application is flexible across instance types and sizes, try to create
// a Capacity Reservation with different instance attributes.
//
// Your request could also fail if the requested quantity exceeds your On-Demand
// Instance limit for the selected instance type. If your request fails due
// to limit constraints, increase your On-Demand Instance limit for the required
// instance type and try again. For more information about increasing your instance
// limits, see Amazon EC2 Service Quotas (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCapacityReservation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation
func (c *EC2) CreateCapacityReservation(input *CreateCapacityReservationInput) (*CreateCapacityReservationOutput, error) {
	req, out := c.CreateCapacityReservationRequest(input)
	return out, req.Send()
}

// CreateCapacityReservationWithContext is the same as CreateCapacityReservation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCapacityReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCapacityReservationWithContext(ctx aws.Context, input *CreateCapacityReservationInput, opts ...request.Option) (*CreateCapacityReservationOutput, error) {
	req, out := c.CreateCapacityReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCapacityReservationFleet = "CreateCapacityReservationFleet"

// CreateCapacityReservationFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateCapacityReservationFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCapacityReservationFleet for more information on using the CreateCapacityReservationFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCapacityReservationFleetRequest method.
//	req, resp := client.CreateCapacityReservationFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet
func (c *EC2) CreateCapacityReservationFleetRequest(input *CreateCapacityReservationFleetInput) (req *request.Request, output *CreateCapacityReservationFleetOutput) {
	op := &request.Operation{
		Name:       opCreateCapacityReservationFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCapacityReservationFleetInput{}
	}

	output = &CreateCapacityReservationFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCapacityReservationFleet API operation for Amazon Elastic Compute Cloud.
//
// Creates a Capacity Reservation Fleet. For more information, see Create a
// Capacity Reservation Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCapacityReservationFleet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet
func (c *EC2) CreateCapacityReservationFleet(input *CreateCapacityReservationFleetInput) (*CreateCapacityReservationFleetOutput, error) {
	req, out := c.CreateCapacityReservationFleetRequest(input)
	return out, req.Send()
}

// CreateCapacityReservationFleetWithContext is the same as CreateCapacityReservationFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCapacityReservationFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCapacityReservationFleetWithContext(ctx aws.Context, input *CreateCapacityReservationFleetInput, opts ...request.Option) (*CreateCapacityReservationFleetOutput, error) {
	req, out := c.CreateCapacityReservationFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCarrierGateway = "CreateCarrierGateway"

// CreateCarrierGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateCarrierGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCarrierGateway for more information on using the CreateCarrierGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCarrierGatewayRequest method.
//	req, resp := client.CreateCarrierGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway
func (c *EC2) CreateCarrierGatewayRequest(input *CreateCarrierGatewayInput) (req *request.Request, output *CreateCarrierGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateCarrierGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCarrierGatewayInput{}
	}

	output = &CreateCarrierGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCarrierGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a carrier gateway. For more information about carrier gateways, see
// Carrier gateways (https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway)
// in the Amazon Web Services Wavelength Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCarrierGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway
func (c *EC2) CreateCarrierGateway(input *CreateCarrierGatewayInput) (*CreateCarrierGatewayOutput, error) {
	req, out := c.CreateCarrierGatewayRequest(input)
	return out, req.Send()
}

// CreateCarrierGatewayWithContext is the same as CreateCarrierGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCarrierGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCarrierGatewayWithContext(ctx aws.Context, input *CreateCarrierGatewayInput, opts ...request.Option) (*CreateCarrierGatewayOutput, error) {
	req, out := c.CreateCarrierGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClientVpnEndpoint = "CreateClientVpnEndpoint"

// CreateClientVpnEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateClientVpnEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClientVpnEndpoint for more information on using the CreateClientVpnEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClientVpnEndpointRequest method.
//	req, resp := client.CreateClientVpnEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint
func (c *EC2) CreateClientVpnEndpointRequest(input *CreateClientVpnEndpointInput) (req *request.Request, output *CreateClientVpnEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateClientVpnEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClientVpnEndpointInput{}
	}

	output = &CreateClientVpnEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClientVpnEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Creates a Client VPN endpoint. A Client VPN endpoint is the resource you
// create and configure to enable and manage client VPN sessions. It is the
// destination endpoint at which all client VPN sessions are terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateClientVpnEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint
func (c *EC2) CreateClientVpnEndpoint(input *CreateClientVpnEndpointInput) (*CreateClientVpnEndpointOutput, error) {
	req, out := c.CreateClientVpnEndpointRequest(input)
	return out, req.Send()
}

// CreateClientVpnEndpointWithContext is the same as CreateClientVpnEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClientVpnEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateClientVpnEndpointWithContext(ctx aws.Context, input *CreateClientVpnEndpointInput, opts ...request.Option) (*CreateClientVpnEndpointOutput, error) {
	req, out := c.CreateClientVpnEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClientVpnRoute = "CreateClientVpnRoute"

// CreateClientVpnRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateClientVpnRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClientVpnRoute for more information on using the CreateClientVpnRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClientVpnRouteRequest method.
//	req, resp := client.CreateClientVpnRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute
func (c *EC2) CreateClientVpnRouteRequest(input *CreateClientVpnRouteInput) (req *request.Request, output *CreateClientVpnRouteOutput) {
	op := &request.Operation{
		Name:       opCreateClientVpnRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClientVpnRouteInput{}
	}

	output = &CreateClientVpnRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClientVpnRoute API operation for Amazon Elastic Compute Cloud.
//
// Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint
// has a route table that describes the available destination network routes.
// Each route in the route table specifies the path for traﬃc to speciﬁc
// resources or networks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateClientVpnRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute
func (c *EC2) CreateClientVpnRoute(input *CreateClientVpnRouteInput) (*CreateClientVpnRouteOutput, error) {
	req, out := c.CreateClientVpnRouteRequest(input)
	return out, req.Send()
}

// CreateClientVpnRouteWithContext is the same as CreateClientVpnRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClientVpnRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateClientVpnRouteWithContext(ctx aws.Context, input *CreateClientVpnRouteInput, opts ...request.Option) (*CreateClientVpnRouteOutput, error) {
	req, out := c.CreateClientVpnRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCoipCidr = "CreateCoipCidr"

// CreateCoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the CreateCoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCoipCidr for more information on using the CreateCoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCoipCidrRequest method.
//	req, resp := client.CreateCoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr
func (c *EC2) CreateCoipCidrRequest(input *CreateCoipCidrInput) (req *request.Request, output *CreateCoipCidrOutput) {
	op := &request.Operation{
		Name:       opCreateCoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCoipCidrInput{}
	}

	output = &CreateCoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCoipCidr API operation for Amazon Elastic Compute Cloud.
//
// Creates a range of customer-owned IP addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCoipCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr
func (c *EC2) CreateCoipCidr(input *CreateCoipCidrInput) (*CreateCoipCidrOutput, error) {
	req, out := c.CreateCoipCidrRequest(input)
	return out, req.Send()
}

// CreateCoipCidrWithContext is the same as CreateCoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCoipCidrWithContext(ctx aws.Context, input *CreateCoipCidrInput, opts ...request.Option) (*CreateCoipCidrOutput, error) {
	req, out := c.CreateCoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCoipPool = "CreateCoipPool"

// CreateCoipPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateCoipPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCoipPool for more information on using the CreateCoipPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCoipPoolRequest method.
//	req, resp := client.CreateCoipPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool
func (c *EC2) CreateCoipPoolRequest(input *CreateCoipPoolInput) (req *request.Request, output *CreateCoipPoolOutput) {
	op := &request.Operation{
		Name:       opCreateCoipPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCoipPoolInput{}
	}

	output = &CreateCoipPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCoipPool API operation for Amazon Elastic Compute Cloud.
//
// Creates a pool of customer-owned IP (CoIP) addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCoipPool for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool
func (c *EC2) CreateCoipPool(input *CreateCoipPoolInput) (*CreateCoipPoolOutput, error) {
	req, out := c.CreateCoipPoolRequest(input)
	return out, req.Send()
}

// CreateCoipPoolWithContext is the same as CreateCoipPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCoipPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCoipPoolWithContext(ctx aws.Context, input *CreateCoipPoolInput, opts ...request.Option) (*CreateCoipPoolOutput, error) {
	req, out := c.CreateCoipPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomerGateway = "CreateCustomerGateway"

// CreateCustomerGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomerGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomerGateway for more information on using the CreateCustomerGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomerGatewayRequest method.
//	req, resp := client.CreateCustomerGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway
func (c *EC2) CreateCustomerGatewayRequest(input *CreateCustomerGatewayInput) (req *request.Request, output *CreateCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomerGatewayInput{}
	}

	output = &CreateCustomerGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomerGateway API operation for Amazon Elastic Compute Cloud.
//
// Provides information to Amazon Web Services about your customer gateway device.
// The customer gateway device is the appliance at your end of the VPN connection.
// You must provide the IP address of the customer gateway device’s external
// interface. The IP address must be static and can be behind a device performing
// network address translation (NAT).
//
// For devices that use Border Gateway Protocol (BGP), you can also provide
// the device's BGP Autonomous System Number (ASN). You can use an existing
// ASN assigned to your network. If you don't have an ASN already, you can use
// a private ASN. For more information, see Customer gateway options for your
// Site-to-Site VPN connection (https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html)
// in the Amazon Web Services Site-to-Site VPN User Guide.
//
// To create more than one customer gateway with the same VPN type, IP address,
// and BGP ASN, specify a unique device name for each customer gateway. An identical
// request returns information about the existing customer gateway; it doesn't
// create a new customer gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateCustomerGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway
func (c *EC2) CreateCustomerGateway(input *CreateCustomerGatewayInput) (*CreateCustomerGatewayOutput, error) {
	req, out := c.CreateCustomerGatewayRequest(input)
	return out, req.Send()
}

// CreateCustomerGatewayWithContext is the same as CreateCustomerGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomerGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateCustomerGatewayWithContext(ctx aws.Context, input *CreateCustomerGatewayInput, opts ...request.Option) (*CreateCustomerGatewayOutput, error) {
	req, out := c.CreateCustomerGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDefaultSubnet = "CreateDefaultSubnet"

// CreateDefaultSubnetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDefaultSubnet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDefaultSubnet for more information on using the CreateDefaultSubnet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDefaultSubnetRequest method.
//	req, resp := client.CreateDefaultSubnetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet
func (c *EC2) CreateDefaultSubnetRequest(input *CreateDefaultSubnetInput) (req *request.Request, output *CreateDefaultSubnetOutput) {
	op := &request.Operation{
		Name:       opCreateDefaultSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDefaultSubnetInput{}
	}

	output = &CreateDefaultSubnetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDefaultSubnet API operation for Amazon Elastic Compute Cloud.
//
// Creates a default subnet with a size /20 IPv4 CIDR block in the specified
// Availability Zone in your default VPC. You can have only one default subnet
// per Availability Zone. For more information, see Create a default subnet
// (https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateDefaultSubnet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet
func (c *EC2) CreateDefaultSubnet(input *CreateDefaultSubnetInput) (*CreateDefaultSubnetOutput, error) {
	req, out := c.CreateDefaultSubnetRequest(input)
	return out, req.Send()
}

// CreateDefaultSubnetWithContext is the same as CreateDefaultSubnet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultSubnet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateDefaultSubnetWithContext(ctx aws.Context, input *CreateDefaultSubnetInput, opts ...request.Option) (*CreateDefaultSubnetOutput, error) {
	req, out := c.CreateDefaultSubnetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDefaultVpc = "CreateDefaultVpc"

// CreateDefaultVpcRequest generates a "aws/request.Request" representing the
// client's request for the CreateDefaultVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDefaultVpc for more information on using the CreateDefaultVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDefaultVpcRequest method.
//	req, resp := client.CreateDefaultVpcRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc
func (c *EC2) CreateDefaultVpcRequest(input *CreateDefaultVpcInput) (req *request.Request, output *CreateDefaultVpcOutput) {
	op := &request.Operation{
		Name:       opCreateDefaultVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDefaultVpcInput{}
	}

	output = &CreateDefaultVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDefaultVpc API operation for Amazon Elastic Compute Cloud.
//
// Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet
// in each Availability Zone. For more information about the components of a
// default VPC, see Default VPCs (https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html)
// in the Amazon VPC User Guide. You cannot specify the components of the default
// VPC yourself.
//
// If you deleted your previous default VPC, you can create a default VPC. You
// cannot have more than one default VPC per Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateDefaultVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc
func (c *EC2) CreateDefaultVpc(input *CreateDefaultVpcInput) (*CreateDefaultVpcOutput, error) {
	req, out := c.CreateDefaultVpcRequest(input)
	return out, req.Send()
}

// CreateDefaultVpcWithContext is the same as CreateDefaultVpc with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDefaultVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateDefaultVpcWithContext(ctx aws.Context, input *CreateDefaultVpcInput, opts ...request.Option) (*CreateDefaultVpcOutput, error) {
	req, out := c.CreateDefaultVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDhcpOptions = "CreateDhcpOptions"

// CreateDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the CreateDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDhcpOptions for more information on using the CreateDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDhcpOptionsRequest method.
//	req, resp := client.CreateDhcpOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions
func (c *EC2) CreateDhcpOptionsRequest(input *CreateDhcpOptionsInput) (req *request.Request, output *CreateDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opCreateDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDhcpOptionsInput{}
	}

	output = &CreateDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Creates a custom set of DHCP options. After you create a DHCP option set,
// you associate it with a VPC. After you associate a DHCP option set with a
// VPC, all existing and newly launched instances in the VPC use this set of
// DHCP options.
//
// The following are the individual DHCP options you can specify. For more information,
// see DHCP options sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon VPC User Guide.
//
//   - domain-name - If you're using AmazonProvidedDNS in us-east-1, specify
//     ec2.internal. If you're using AmazonProvidedDNS in any other Region, specify
//     region.compute.internal. Otherwise, specify a custom domain name. This
//     value is used to complete unqualified DNS hostnames. Some Linux operating
//     systems accept multiple domain names separated by spaces. However, Windows
//     and other Linux operating systems treat the value as a single domain,
//     which results in unexpected behavior. If your DHCP option set is associated
//     with a VPC that has instances running operating systems that treat the
//     value as a single domain, specify only one domain name.
//
//   - domain-name-servers - The IP addresses of up to four DNS servers, or
//     AmazonProvidedDNS. To specify multiple domain name servers in a single
//     parameter, separate the IP addresses using commas. To have your instances
//     receive custom DNS hostnames as specified in domain-name, you must specify
//     a custom DNS server.
//
//   - ntp-servers - The IP addresses of up to eight Network Time Protocol
//     (NTP) servers (four IPv4 addresses and four IPv6 addresses).
//
//   - netbios-name-servers - The IP addresses of up to four NetBIOS name servers.
//
//   - netbios-node-type - The NetBIOS node type (1, 2, 4, or 8). We recommend
//     that you specify 2. Broadcast and multicast are not supported. For more
//     information about NetBIOS node types, see RFC 2132 (http://www.ietf.org/rfc/rfc2132.txt).
//
//   - ipv6-address-preferred-lease-time - A value (in seconds, minutes, hours,
//     or years) for how frequently a running instance with an IPv6 assigned
//     to it goes through DHCPv6 lease renewal. Acceptable values are between
//     140 and 2147483647 seconds (approximately 68 years). If no value is entered,
//     the default lease time is 140 seconds. If you use long-term addressing
//     for EC2 instances, you can increase the lease time and avoid frequent
//     lease renewal requests. Lease renewal typically occurs when half of the
//     lease time has elapsed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions
func (c *EC2) CreateDhcpOptions(input *CreateDhcpOptionsInput) (*CreateDhcpOptionsOutput, error) {
	req, out := c.CreateDhcpOptionsRequest(input)
	return out, req.Send()
}

// CreateDhcpOptionsWithContext is the same as CreateDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateDhcpOptionsWithContext(ctx aws.Context, input *CreateDhcpOptionsInput, opts ...request.Option) (*CreateDhcpOptionsOutput, error) {
	req, out := c.CreateDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEgressOnlyInternetGateway = "CreateEgressOnlyInternetGateway"

// CreateEgressOnlyInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateEgressOnlyInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEgressOnlyInternetGateway for more information on using the CreateEgressOnlyInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEgressOnlyInternetGatewayRequest method.
//	req, resp := client.CreateEgressOnlyInternetGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway
func (c *EC2) CreateEgressOnlyInternetGatewayRequest(input *CreateEgressOnlyInternetGatewayInput) (req *request.Request, output *CreateEgressOnlyInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateEgressOnlyInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEgressOnlyInternetGatewayInput{}
	}

	output = &CreateEgressOnlyInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEgressOnlyInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// [IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only
// internet gateway is used to enable outbound communication over IPv6 from
// instances in your VPC to the internet, and prevents hosts outside of your
// VPC from initiating an IPv6 connection with your instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateEgressOnlyInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway
func (c *EC2) CreateEgressOnlyInternetGateway(input *CreateEgressOnlyInternetGatewayInput) (*CreateEgressOnlyInternetGatewayOutput, error) {
	req, out := c.CreateEgressOnlyInternetGatewayRequest(input)
	return out, req.Send()
}

// CreateEgressOnlyInternetGatewayWithContext is the same as CreateEgressOnlyInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEgressOnlyInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateEgressOnlyInternetGatewayWithContext(ctx aws.Context, input *CreateEgressOnlyInternetGatewayInput, opts ...request.Option) (*CreateEgressOnlyInternetGatewayOutput, error) {
	req, out := c.CreateEgressOnlyInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFleetRequest method.
//	req, resp := client.CreateFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet
func (c *EC2) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon Elastic Compute Cloud.
//
// Creates an EC2 Fleet that contains the configuration information for On-Demand
// Instances and Spot Instances. Instances are launched immediately if there
// is available capacity.
//
// A single EC2 Fleet can include multiple launch specifications that vary by
// instance type, AMI, Availability Zone, or subnet.
//
// For more information, see EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateFleet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet
func (c *EC2) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlowLogs = "CreateFlowLogs"

// CreateFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlowLogs for more information on using the CreateFlowLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFlowLogsRequest method.
//	req, resp := client.CreateFlowLogsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs
func (c *EC2) CreateFlowLogsRequest(input *CreateFlowLogsInput) (req *request.Request, output *CreateFlowLogsOutput) {
	op := &request.Operation{
		Name:       opCreateFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowLogsInput{}
	}

	output = &CreateFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Creates one or more flow logs to capture information about IP traffic for
// a specific network interface, subnet, or VPC.
//
// Flow log data for a monitored network interface is recorded as flow log records,
// which are log events consisting of fields that describe the traffic flow.
// For more information, see Flow log records (https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records)
// in the Amazon Virtual Private Cloud User Guide.
//
// When publishing to CloudWatch Logs, flow log records are published to a log
// group, and each network interface has a unique log stream in the log group.
// When publishing to Amazon S3, flow log records for all of the monitored network
// interfaces are published to a single log file object that is stored in the
// specified bucket.
//
// For more information, see VPC Flow Logs (https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateFlowLogs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs
func (c *EC2) CreateFlowLogs(input *CreateFlowLogsInput) (*CreateFlowLogsOutput, error) {
	req, out := c.CreateFlowLogsRequest(input)
	return out, req.Send()
}

// CreateFlowLogsWithContext is the same as CreateFlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateFlowLogsWithContext(ctx aws.Context, input *CreateFlowLogsInput, opts ...request.Option) (*CreateFlowLogsOutput, error) {
	req, out := c.CreateFlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFpgaImage = "CreateFpgaImage"

// CreateFpgaImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateFpgaImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFpgaImage for more information on using the CreateFpgaImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFpgaImageRequest method.
//	req, resp := client.CreateFpgaImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage
func (c *EC2) CreateFpgaImageRequest(input *CreateFpgaImageInput) (req *request.Request, output *CreateFpgaImageOutput) {
	op := &request.Operation{
		Name:       opCreateFpgaImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFpgaImageInput{}
	}

	output = &CreateFpgaImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFpgaImage API operation for Amazon Elastic Compute Cloud.
//
// Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP).
//
// The create operation is asynchronous. To verify that the AFI is ready for
// use, check the output logs.
//
// An AFI contains the FPGA bitstream that is ready to download to an FPGA.
// You can securely deploy an AFI on multiple FPGA-accelerated instances. For
// more information, see the Amazon Web Services FPGA Hardware Development Kit
// (https://github.com/aws/aws-fpga/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateFpgaImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage
func (c *EC2) CreateFpgaImage(input *CreateFpgaImageInput) (*CreateFpgaImageOutput, error) {
	req, out := c.CreateFpgaImageRequest(input)
	return out, req.Send()
}

// CreateFpgaImageWithContext is the same as CreateFpgaImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFpgaImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateFpgaImageWithContext(ctx aws.Context, input *CreateFpgaImageInput, opts ...request.Option) (*CreateFpgaImageOutput, error) {
	req, out := c.CreateFpgaImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImage = "CreateImage"

// CreateImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImage for more information on using the CreateImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateImageRequest method.
//	req, resp := client.CreateImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage
func (c *EC2) CreateImageRequest(input *CreateImageInput) (req *request.Request, output *CreateImageOutput) {
	op := &request.Operation{
		Name:       opCreateImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageInput{}
	}

	output = &CreateImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImage API operation for Amazon Elastic Compute Cloud.
//
// Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
// is either running or stopped.
//
// If you customized your instance with instance store volumes or Amazon EBS
// volumes in addition to the root device volume, the new AMI contains block
// device mapping information for those volumes. When you launch an instance
// from this new AMI, the instance automatically launches with those additional
// volumes.
//
// For more information, see Create an Amazon EBS-backed Linux AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage
func (c *EC2) CreateImage(input *CreateImageInput) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	return out, req.Send()
}

// CreateImageWithContext is the same as CreateImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateImageWithContext(ctx aws.Context, input *CreateImageInput, opts ...request.Option) (*CreateImageOutput, error) {
	req, out := c.CreateImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceConnectEndpoint = "CreateInstanceConnectEndpoint"

// CreateInstanceConnectEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceConnectEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceConnectEndpoint for more information on using the CreateInstanceConnectEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceConnectEndpointRequest method.
//	req, resp := client.CreateInstanceConnectEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint
func (c *EC2) CreateInstanceConnectEndpointRequest(input *CreateInstanceConnectEndpointInput) (req *request.Request, output *CreateInstanceConnectEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceConnectEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceConnectEndpointInput{}
	}

	output = &CreateInstanceConnectEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceConnectEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Creates an EC2 Instance Connect Endpoint.
//
// An EC2 Instance Connect Endpoint allows you to connect to an instance, without
// requiring the instance to have a public IPv4 address. For more information,
// see Connect to your instances without requiring a public IPv4 address using
// EC2 Instance Connect Endpoint (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInstanceConnectEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint
func (c *EC2) CreateInstanceConnectEndpoint(input *CreateInstanceConnectEndpointInput) (*CreateInstanceConnectEndpointOutput, error) {
	req, out := c.CreateInstanceConnectEndpointRequest(input)
	return out, req.Send()
}

// CreateInstanceConnectEndpointWithContext is the same as CreateInstanceConnectEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceConnectEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateInstanceConnectEndpointWithContext(ctx aws.Context, input *CreateInstanceConnectEndpointInput, opts ...request.Option) (*CreateInstanceConnectEndpointOutput, error) {
	req, out := c.CreateInstanceConnectEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceEventWindow = "CreateInstanceEventWindow"

// CreateInstanceEventWindowRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceEventWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceEventWindow for more information on using the CreateInstanceEventWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceEventWindowRequest method.
//	req, resp := client.CreateInstanceEventWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow
func (c *EC2) CreateInstanceEventWindowRequest(input *CreateInstanceEventWindowInput) (req *request.Request, output *CreateInstanceEventWindowOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceEventWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceEventWindowInput{}
	}

	output = &CreateInstanceEventWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceEventWindow API operation for Amazon Elastic Compute Cloud.
//
// Creates an event window in which scheduled events for the associated Amazon
// EC2 instances can run.
//
// You can define either a set of time ranges or a cron expression when creating
// the event window, but not both. All event window times are in UTC.
//
// You can create up to 200 event windows per Amazon Web Services Region.
//
// When you create the event window, targets (instance IDs, Dedicated Host IDs,
// or tags) are not yet associated with it. To ensure that the event window
// can be used, you must associate one or more targets with it by using the
// AssociateInstanceEventWindow API.
//
// Event windows are applicable only for scheduled events that stop, reboot,
// or terminate instances.
//
// Event windows are not applicable for:
//
//   - Expedited scheduled events and network maintenance events.
//
//   - Unscheduled maintenance such as AutoRecovery and unplanned reboots.
//
// For more information, see Define event windows for scheduled events (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInstanceEventWindow for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow
func (c *EC2) CreateInstanceEventWindow(input *CreateInstanceEventWindowInput) (*CreateInstanceEventWindowOutput, error) {
	req, out := c.CreateInstanceEventWindowRequest(input)
	return out, req.Send()
}

// CreateInstanceEventWindowWithContext is the same as CreateInstanceEventWindow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceEventWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateInstanceEventWindowWithContext(ctx aws.Context, input *CreateInstanceEventWindowInput, opts ...request.Option) (*CreateInstanceEventWindowOutput, error) {
	req, out := c.CreateInstanceEventWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceExportTask = "CreateInstanceExportTask"

// CreateInstanceExportTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceExportTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceExportTask for more information on using the CreateInstanceExportTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceExportTaskRequest method.
//	req, resp := client.CreateInstanceExportTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask
func (c *EC2) CreateInstanceExportTaskRequest(input *CreateInstanceExportTaskInput) (req *request.Request, output *CreateInstanceExportTaskOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceExportTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceExportTaskInput{}
	}

	output = &CreateInstanceExportTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceExportTask API operation for Amazon Elastic Compute Cloud.
//
// Exports a running or stopped instance to an Amazon S3 bucket.
//
// For information about the prerequisites for your Amazon S3 bucket, supported
// operating systems, image formats, and known limitations for the types of
// instances you can export, see Exporting an instance as a VM Using VM Import/Export
// (https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html) in
// the VM Import/Export User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInstanceExportTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask
func (c *EC2) CreateInstanceExportTask(input *CreateInstanceExportTaskInput) (*CreateInstanceExportTaskOutput, error) {
	req, out := c.CreateInstanceExportTaskRequest(input)
	return out, req.Send()
}

// CreateInstanceExportTaskWithContext is the same as CreateInstanceExportTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceExportTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateInstanceExportTaskWithContext(ctx aws.Context, input *CreateInstanceExportTaskInput, opts ...request.Option) (*CreateInstanceExportTaskOutput, error) {
	req, out := c.CreateInstanceExportTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInternetGateway = "CreateInternetGateway"

// CreateInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInternetGateway for more information on using the CreateInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInternetGatewayRequest method.
//	req, resp := client.CreateInternetGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway
func (c *EC2) CreateInternetGatewayRequest(input *CreateInternetGatewayInput) (req *request.Request, output *CreateInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInternetGatewayInput{}
	}

	output = &CreateInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates an internet gateway for use with a VPC. After creating the internet
// gateway, you attach it to a VPC using AttachInternetGateway.
//
// For more information, see Internet gateways (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway
func (c *EC2) CreateInternetGateway(input *CreateInternetGatewayInput) (*CreateInternetGatewayOutput, error) {
	req, out := c.CreateInternetGatewayRequest(input)
	return out, req.Send()
}

// CreateInternetGatewayWithContext is the same as CreateInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateInternetGatewayWithContext(ctx aws.Context, input *CreateInternetGatewayInput, opts ...request.Option) (*CreateInternetGatewayOutput, error) {
	req, out := c.CreateInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpam = "CreateIpam"

// CreateIpamRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpam for more information on using the CreateIpam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIpamRequest method.
//	req, resp := client.CreateIpamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam
func (c *EC2) CreateIpamRequest(input *CreateIpamInput) (req *request.Request, output *CreateIpamOutput) {
	op := &request.Operation{
		Name:       opCreateIpam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpamInput{}
	}

	output = &CreateIpamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpam API operation for Amazon Elastic Compute Cloud.
//
// Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that
// you can use to automate your IP address management workflows including assigning,
// tracking, troubleshooting, and auditing IP addresses across Amazon Web Services
// Regions and accounts throughout your Amazon Web Services Organization.
//
// For more information, see Create an IPAM (https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateIpam for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam
func (c *EC2) CreateIpam(input *CreateIpamInput) (*CreateIpamOutput, error) {
	req, out := c.CreateIpamRequest(input)
	return out, req.Send()
}

// CreateIpamWithContext is the same as CreateIpam with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateIpamWithContext(ctx aws.Context, input *CreateIpamInput, opts ...request.Option) (*CreateIpamOutput, error) {
	req, out := c.CreateIpamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpamPool = "CreateIpamPool"

// CreateIpamPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpamPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpamPool for more information on using the CreateIpamPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIpamPoolRequest method.
//	req, resp := client.CreateIpamPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool
func (c *EC2) CreateIpamPoolRequest(input *CreateIpamPoolInput) (req *request.Request, output *CreateIpamPoolOutput) {
	op := &request.Operation{
		Name:       opCreateIpamPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpamPoolInput{}
	}

	output = &CreateIpamPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpamPool API operation for Amazon Elastic Compute Cloud.
//
// Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM,
// a pool is a collection of contiguous IP addresses CIDRs. Pools enable you
// to organize your IP addresses according to your routing and security needs.
// For example, if you have separate routing and security needs for development
// and production applications, you can create a pool for each.
//
// For more information, see Create a top-level pool (https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateIpamPool for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool
func (c *EC2) CreateIpamPool(input *CreateIpamPoolInput) (*CreateIpamPoolOutput, error) {
	req, out := c.CreateIpamPoolRequest(input)
	return out, req.Send()
}

// CreateIpamPoolWithContext is the same as CreateIpamPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpamPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateIpamPoolWithContext(ctx aws.Context, input *CreateIpamPoolInput, opts ...request.Option) (*CreateIpamPoolOutput, error) {
	req, out := c.CreateIpamPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpamResourceDiscovery = "CreateIpamResourceDiscovery"

// CreateIpamResourceDiscoveryRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpamResourceDiscovery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpamResourceDiscovery for more information on using the CreateIpamResourceDiscovery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIpamResourceDiscoveryRequest method.
//	req, resp := client.CreateIpamResourceDiscoveryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery
func (c *EC2) CreateIpamResourceDiscoveryRequest(input *CreateIpamResourceDiscoveryInput) (req *request.Request, output *CreateIpamResourceDiscoveryOutput) {
	op := &request.Operation{
		Name:       opCreateIpamResourceDiscovery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpamResourceDiscoveryInput{}
	}

	output = &CreateIpamResourceDiscoveryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpamResourceDiscovery API operation for Amazon Elastic Compute Cloud.
//
// Creates an IPAM resource discovery. A resource discovery is an IPAM component
// that enables IPAM to manage and monitor resources that belong to the owning
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateIpamResourceDiscovery for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery
func (c *EC2) CreateIpamResourceDiscovery(input *CreateIpamResourceDiscoveryInput) (*CreateIpamResourceDiscoveryOutput, error) {
	req, out := c.CreateIpamResourceDiscoveryRequest(input)
	return out, req.Send()
}

// CreateIpamResourceDiscoveryWithContext is the same as CreateIpamResourceDiscovery with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpamResourceDiscovery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateIpamResourceDiscoveryWithContext(ctx aws.Context, input *CreateIpamResourceDiscoveryInput, opts ...request.Option) (*CreateIpamResourceDiscoveryOutput, error) {
	req, out := c.CreateIpamResourceDiscoveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpamScope = "CreateIpamScope"

// CreateIpamScopeRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpamScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpamScope for more information on using the CreateIpamScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIpamScopeRequest method.
//	req, resp := client.CreateIpamScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope
func (c *EC2) CreateIpamScopeRequest(input *CreateIpamScopeInput) (req *request.Request, output *CreateIpamScopeOutput) {
	op := &request.Operation{
		Name:       opCreateIpamScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpamScopeInput{}
	}

	output = &CreateIpamScopeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpamScope API operation for Amazon Elastic Compute Cloud.
//
// Create an IPAM scope. In IPAM, a scope is the highest-level container within
// IPAM. An IPAM contains two default scopes. Each scope represents the IP space
// for a single network. The private scope is intended for all private IP address
// space. The public scope is intended for all public IP address space. Scopes
// enable you to reuse IP addresses across multiple unconnected networks without
// causing IP address overlap or conflict.
//
// For more information, see Add a scope (https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateIpamScope for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope
func (c *EC2) CreateIpamScope(input *CreateIpamScopeInput) (*CreateIpamScopeOutput, error) {
	req, out := c.CreateIpamScopeRequest(input)
	return out, req.Send()
}

// CreateIpamScopeWithContext is the same as CreateIpamScope with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpamScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateIpamScopeWithContext(ctx aws.Context, input *CreateIpamScopeInput, opts ...request.Option) (*CreateIpamScopeOutput, error) {
	req, out := c.CreateIpamScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeyPair for more information on using the CreateKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKeyPairRequest method.
//	req, resp := client.CreateKeyPairRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair
func (c *EC2) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	output = &CreateKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyPair API operation for Amazon Elastic Compute Cloud.
//
// Creates an ED25519 or 2048-bit RSA key pair with the specified name and in
// the specified PEM or PPK format. Amazon EC2 stores the public key and displays
// the private key for you to save to a file. The private key is returned as
// an unencrypted PEM encoded PKCS#1 private key or an unencrypted PPK formatted
// private key for use with PuTTY. If a key with the specified name already
// exists, Amazon EC2 returns an error.
//
// The key pair returned to you is available only in the Amazon Web Services
// Region in which you create it. If you prefer, you can create your own key
// pair using a third-party tool and upload it to any Region using ImportKeyPair.
//
// You can have up to 5,000 key pairs per Amazon Web Services Region.
//
// For more information, see Amazon EC2 key pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateKeyPair for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair
func (c *EC2) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	return out, req.Send()
}

// CreateKeyPairWithContext is the same as CreateKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateKeyPairWithContext(ctx aws.Context, input *CreateKeyPairInput, opts ...request.Option) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunchTemplate = "CreateLaunchTemplate"

// CreateLaunchTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunchTemplate for more information on using the CreateLaunchTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLaunchTemplateRequest method.
//	req, resp := client.CreateLaunchTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate
func (c *EC2) CreateLaunchTemplateRequest(input *CreateLaunchTemplateInput) (req *request.Request, output *CreateLaunchTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLaunchTemplateInput{}
	}

	output = &CreateLaunchTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLaunchTemplate API operation for Amazon Elastic Compute Cloud.
//
// Creates a launch template.
//
// A launch template contains the parameters to launch an instance. When you
// launch an instance using RunInstances, you can specify a launch template
// instead of providing the launch parameters in the request. For more information,
// see Launch an instance from a launch template (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// To clone an existing launch template as the basis for a new launch template,
// use the Amazon EC2 console. The API, SDKs, and CLI do not support cloning
// a template. For more information, see Create a launch template from an existing
// launch template (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template-from-existing-launch-template)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLaunchTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate
func (c *EC2) CreateLaunchTemplate(input *CreateLaunchTemplateInput) (*CreateLaunchTemplateOutput, error) {
	req, out := c.CreateLaunchTemplateRequest(input)
	return out, req.Send()
}

// CreateLaunchTemplateWithContext is the same as CreateLaunchTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunchTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLaunchTemplateWithContext(ctx aws.Context, input *CreateLaunchTemplateInput, opts ...request.Option) (*CreateLaunchTemplateOutput, error) {
	req, out := c.CreateLaunchTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLaunchTemplateVersion = "CreateLaunchTemplateVersion"

// CreateLaunchTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLaunchTemplateVersion for more information on using the CreateLaunchTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLaunchTemplateVersionRequest method.
//	req, resp := client.CreateLaunchTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion
func (c *EC2) CreateLaunchTemplateVersionRequest(input *CreateLaunchTemplateVersionInput) (req *request.Request, output *CreateLaunchTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLaunchTemplateVersionInput{}
	}

	output = &CreateLaunchTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLaunchTemplateVersion API operation for Amazon Elastic Compute Cloud.
//
// Creates a new version of a launch template. You must specify an existing
// launch template, either by name or ID. You can determine whether the new
// version inherits parameters from a source version, and add or overwrite parameters
// as needed.
//
// Launch template versions are numbered in the order in which they are created.
// You can't specify, change, or replace the numbering of launch template versions.
//
// Launch templates are immutable; after you create a launch template, you can't
// modify it. Instead, you can create a new version of the launch template that
// includes the changes that you require.
//
// For more information, see Modify a launch template (manage launch template
// versions) (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLaunchTemplateVersion for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion
func (c *EC2) CreateLaunchTemplateVersion(input *CreateLaunchTemplateVersionInput) (*CreateLaunchTemplateVersionOutput, error) {
	req, out := c.CreateLaunchTemplateVersionRequest(input)
	return out, req.Send()
}

// CreateLaunchTemplateVersionWithContext is the same as CreateLaunchTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLaunchTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLaunchTemplateVersionWithContext(ctx aws.Context, input *CreateLaunchTemplateVersionInput, opts ...request.Option) (*CreateLaunchTemplateVersionOutput, error) {
	req, out := c.CreateLaunchTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocalGatewayRoute = "CreateLocalGatewayRoute"

// CreateLocalGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocalGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocalGatewayRoute for more information on using the CreateLocalGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocalGatewayRouteRequest method.
//	req, resp := client.CreateLocalGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute
func (c *EC2) CreateLocalGatewayRouteRequest(input *CreateLocalGatewayRouteInput) (req *request.Request, output *CreateLocalGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opCreateLocalGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocalGatewayRouteInput{}
	}

	output = &CreateLocalGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocalGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a static route for the specified local gateway route table. You must
// specify one of the following targets:
//
//   - LocalGatewayVirtualInterfaceGroupId
//
//   - NetworkInterfaceId
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLocalGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute
func (c *EC2) CreateLocalGatewayRoute(input *CreateLocalGatewayRouteInput) (*CreateLocalGatewayRouteOutput, error) {
	req, out := c.CreateLocalGatewayRouteRequest(input)
	return out, req.Send()
}

// CreateLocalGatewayRouteWithContext is the same as CreateLocalGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocalGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLocalGatewayRouteWithContext(ctx aws.Context, input *CreateLocalGatewayRouteInput, opts ...request.Option) (*CreateLocalGatewayRouteOutput, error) {
	req, out := c.CreateLocalGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocalGatewayRouteTable = "CreateLocalGatewayRouteTable"

// CreateLocalGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocalGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocalGatewayRouteTable for more information on using the CreateLocalGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocalGatewayRouteTableRequest method.
//	req, resp := client.CreateLocalGatewayRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable
func (c *EC2) CreateLocalGatewayRouteTableRequest(input *CreateLocalGatewayRouteTableInput) (req *request.Request, output *CreateLocalGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateLocalGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocalGatewayRouteTableInput{}
	}

	output = &CreateLocalGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocalGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Creates a local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLocalGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable
func (c *EC2) CreateLocalGatewayRouteTable(input *CreateLocalGatewayRouteTableInput) (*CreateLocalGatewayRouteTableOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableRequest(input)
	return out, req.Send()
}

// CreateLocalGatewayRouteTableWithContext is the same as CreateLocalGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocalGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLocalGatewayRouteTableWithContext(ctx aws.Context, input *CreateLocalGatewayRouteTableInput, opts ...request.Option) (*CreateLocalGatewayRouteTableOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation = "CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation"

// CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation for more information on using the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest method.
//	req, resp := client.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
func (c *EC2) CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input *CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput) (req *request.Request, output *CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput{}
	}

	output = &CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation API operation for Amazon Elastic Compute Cloud.
//
// Creates a local gateway route table virtual interface group association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation
func (c *EC2) CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation(input *CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput) (*CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input)
	return out, req.Send()
}

// CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationWithContext is the same as CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationWithContext(ctx aws.Context, input *CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput, opts ...request.Option) (*CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocalGatewayRouteTableVpcAssociation = "CreateLocalGatewayRouteTableVpcAssociation"

// CreateLocalGatewayRouteTableVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocalGatewayRouteTableVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocalGatewayRouteTableVpcAssociation for more information on using the CreateLocalGatewayRouteTableVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocalGatewayRouteTableVpcAssociationRequest method.
//	req, resp := client.CreateLocalGatewayRouteTableVpcAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation
func (c *EC2) CreateLocalGatewayRouteTableVpcAssociationRequest(input *CreateLocalGatewayRouteTableVpcAssociationInput) (req *request.Request, output *CreateLocalGatewayRouteTableVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateLocalGatewayRouteTableVpcAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocalGatewayRouteTableVpcAssociationInput{}
	}

	output = &CreateLocalGatewayRouteTableVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocalGatewayRouteTableVpcAssociation API operation for Amazon Elastic Compute Cloud.
//
// Associates the specified VPC with the specified local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateLocalGatewayRouteTableVpcAssociation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation
func (c *EC2) CreateLocalGatewayRouteTableVpcAssociation(input *CreateLocalGatewayRouteTableVpcAssociationInput) (*CreateLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableVpcAssociationRequest(input)
	return out, req.Send()
}

// CreateLocalGatewayRouteTableVpcAssociationWithContext is the same as CreateLocalGatewayRouteTableVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocalGatewayRouteTableVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateLocalGatewayRouteTableVpcAssociationWithContext(ctx aws.Context, input *CreateLocalGatewayRouteTableVpcAssociationInput, opts ...request.Option) (*CreateLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.CreateLocalGatewayRouteTableVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateManagedPrefixList = "CreateManagedPrefixList"

// CreateManagedPrefixListRequest generates a "aws/request.Request" representing the
// client's request for the CreateManagedPrefixList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateManagedPrefixList for more information on using the CreateManagedPrefixList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateManagedPrefixListRequest method.
//	req, resp := client.CreateManagedPrefixListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList
func (c *EC2) CreateManagedPrefixListRequest(input *CreateManagedPrefixListInput) (req *request.Request, output *CreateManagedPrefixListOutput) {
	op := &request.Operation{
		Name:       opCreateManagedPrefixList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateManagedPrefixListInput{}
	}

	output = &CreateManagedPrefixListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateManagedPrefixList API operation for Amazon Elastic Compute Cloud.
//
// Creates a managed prefix list. You can specify one or more entries for the
// prefix list. Each entry consists of a CIDR block and an optional description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateManagedPrefixList for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList
func (c *EC2) CreateManagedPrefixList(input *CreateManagedPrefixListInput) (*CreateManagedPrefixListOutput, error) {
	req, out := c.CreateManagedPrefixListRequest(input)
	return out, req.Send()
}

// CreateManagedPrefixListWithContext is the same as CreateManagedPrefixList with the addition of
// the ability to pass a context and additional request options.
//
// See CreateManagedPrefixList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateManagedPrefixListWithContext(ctx aws.Context, input *CreateManagedPrefixListInput, opts ...request.Option) (*CreateManagedPrefixListOutput, error) {
	req, out := c.CreateManagedPrefixListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNatGateway = "CreateNatGateway"

// CreateNatGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateNatGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNatGateway for more information on using the CreateNatGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNatGatewayRequest method.
//	req, resp := client.CreateNatGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway
func (c *EC2) CreateNatGatewayRequest(input *CreateNatGatewayInput) (req *request.Request, output *CreateNatGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNatGatewayInput{}
	}

	output = &CreateNatGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNatGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a NAT gateway in the specified subnet. This action creates a network
// interface in the specified subnet with a private IP address from the IP address
// range of the subnet. You can create either a public NAT gateway or a private
// NAT gateway.
//
// With a public NAT gateway, internet-bound traffic from a private subnet can
// be routed to the NAT gateway, so that instances in a private subnet can connect
// to the internet.
//
// With a private NAT gateway, private communication is routed across VPCs and
// on-premises networks through a transit gateway or virtual private gateway.
// Common use cases include running large workloads behind a small pool of allowlisted
// IPv4 addresses, preserving private IPv4 addresses, and communicating between
// overlapping networks.
//
// For more information, see NAT gateways (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html)
// in the Amazon VPC User Guide.
//
// When you create a public NAT gateway and assign it an EIP or secondary EIPs,
// the network border group of the EIPs must match the network border group
// of the Availability Zone (AZ) that the public NAT gateway is in. If it's
// not the same, the NAT gateway will fail to launch. You can see the network
// border group for the subnet's AZ by viewing the details of the subnet. Similarly,
// you can view the network border group of an EIP by viewing the details of
// the EIP address. For more information about network border groups and EIPs,
// see Allocate an Elastic IP address (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#allocate-eip)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNatGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway
func (c *EC2) CreateNatGateway(input *CreateNatGatewayInput) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	return out, req.Send()
}

// CreateNatGatewayWithContext is the same as CreateNatGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNatGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNatGatewayWithContext(ctx aws.Context, input *CreateNatGatewayInput, opts ...request.Option) (*CreateNatGatewayOutput, error) {
	req, out := c.CreateNatGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkAcl = "CreateNetworkAcl"

// CreateNetworkAclRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkAcl for more information on using the CreateNetworkAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkAclRequest method.
//	req, resp := client.CreateNetworkAclRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl
func (c *EC2) CreateNetworkAclRequest(input *CreateNetworkAclInput) (req *request.Request, output *CreateNetworkAclOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclInput{}
	}

	output = &CreateNetworkAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkAcl API operation for Amazon Elastic Compute Cloud.
//
// Creates a network ACL in a VPC. Network ACLs provide an optional layer of
// security (in addition to security groups) for the instances in your VPC.
//
// For more information, see Network ACLs (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl
func (c *EC2) CreateNetworkAcl(input *CreateNetworkAclInput) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	return out, req.Send()
}

// CreateNetworkAclWithContext is the same as CreateNetworkAcl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkAclWithContext(ctx aws.Context, input *CreateNetworkAclInput, opts ...request.Option) (*CreateNetworkAclOutput, error) {
	req, out := c.CreateNetworkAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkAclEntry = "CreateNetworkAclEntry"

// CreateNetworkAclEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkAclEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkAclEntry for more information on using the CreateNetworkAclEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkAclEntryRequest method.
//	req, resp := client.CreateNetworkAclEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry
func (c *EC2) CreateNetworkAclEntryRequest(input *CreateNetworkAclEntryInput) (req *request.Request, output *CreateNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkAclEntryInput{}
	}

	output = &CreateNetworkAclEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateNetworkAclEntry API operation for Amazon Elastic Compute Cloud.
//
// Creates an entry (a rule) in a network ACL with the specified rule number.
// Each network ACL has a set of numbered ingress rules and a separate set of
// numbered egress rules. When determining whether a packet should be allowed
// in or out of a subnet associated with the ACL, we process the entries in
// the ACL according to the rule numbers, in ascending order. Each network ACL
// has a set of ingress rules and a separate set of egress rules.
//
// We recommend that you leave room between the rule numbers (for example, 100,
// 110, 120, ...), and not number them one right after the other (for example,
// 101, 102, 103, ...). This makes it easier to add a rule between existing
// ones without having to renumber the rules.
//
// After you add an entry, you can't modify it; you must either replace it,
// or create an entry and delete the old one.
//
// For more information about network ACLs, see Network ACLs (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkAclEntry for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry
func (c *EC2) CreateNetworkAclEntry(input *CreateNetworkAclEntryInput) (*CreateNetworkAclEntryOutput, error) {
	req, out := c.CreateNetworkAclEntryRequest(input)
	return out, req.Send()
}

// CreateNetworkAclEntryWithContext is the same as CreateNetworkAclEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkAclEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkAclEntryWithContext(ctx aws.Context, input *CreateNetworkAclEntryInput, opts ...request.Option) (*CreateNetworkAclEntryOutput, error) {
	req, out := c.CreateNetworkAclEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkInsightsAccessScope = "CreateNetworkInsightsAccessScope"

// CreateNetworkInsightsAccessScopeRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInsightsAccessScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkInsightsAccessScope for more information on using the CreateNetworkInsightsAccessScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkInsightsAccessScopeRequest method.
//	req, resp := client.CreateNetworkInsightsAccessScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope
func (c *EC2) CreateNetworkInsightsAccessScopeRequest(input *CreateNetworkInsightsAccessScopeInput) (req *request.Request, output *CreateNetworkInsightsAccessScopeOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInsightsAccessScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInsightsAccessScopeInput{}
	}

	output = &CreateNetworkInsightsAccessScopeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInsightsAccessScope API operation for Amazon Elastic Compute Cloud.
//
// Creates a Network Access Scope.
//
// Amazon Web Services Network Access Analyzer enables cloud networking and
// cloud operations teams to verify that their networks on Amazon Web Services
// conform to their network security and governance objectives. For more information,
// see the Amazon Web Services Network Access Analyzer Guide (https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInsightsAccessScope for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope
func (c *EC2) CreateNetworkInsightsAccessScope(input *CreateNetworkInsightsAccessScopeInput) (*CreateNetworkInsightsAccessScopeOutput, error) {
	req, out := c.CreateNetworkInsightsAccessScopeRequest(input)
	return out, req.Send()
}

// CreateNetworkInsightsAccessScopeWithContext is the same as CreateNetworkInsightsAccessScope with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkInsightsAccessScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkInsightsAccessScopeWithContext(ctx aws.Context, input *CreateNetworkInsightsAccessScopeInput, opts ...request.Option) (*CreateNetworkInsightsAccessScopeOutput, error) {
	req, out := c.CreateNetworkInsightsAccessScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkInsightsPath = "CreateNetworkInsightsPath"

// CreateNetworkInsightsPathRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInsightsPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkInsightsPath for more information on using the CreateNetworkInsightsPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkInsightsPathRequest method.
//	req, resp := client.CreateNetworkInsightsPathRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath
func (c *EC2) CreateNetworkInsightsPathRequest(input *CreateNetworkInsightsPathInput) (req *request.Request, output *CreateNetworkInsightsPathOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInsightsPath,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInsightsPathInput{}
	}

	output = &CreateNetworkInsightsPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInsightsPath API operation for Amazon Elastic Compute Cloud.
//
// Creates a path to analyze for reachability.
//
// Reachability Analyzer enables you to analyze and debug network reachability
// between two resources in your virtual private cloud (VPC). For more information,
// see the Reachability Analyzer Guide (https://docs.aws.amazon.com/vpc/latest/reachability/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInsightsPath for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath
func (c *EC2) CreateNetworkInsightsPath(input *CreateNetworkInsightsPathInput) (*CreateNetworkInsightsPathOutput, error) {
	req, out := c.CreateNetworkInsightsPathRequest(input)
	return out, req.Send()
}

// CreateNetworkInsightsPathWithContext is the same as CreateNetworkInsightsPath with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkInsightsPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkInsightsPathWithContext(ctx aws.Context, input *CreateNetworkInsightsPathInput, opts ...request.Option) (*CreateNetworkInsightsPathOutput, error) {
	req, out := c.CreateNetworkInsightsPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkInterface = "CreateNetworkInterface"

// CreateNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkInterface for more information on using the CreateNetworkInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkInterfaceRequest method.
//	req, resp := client.CreateNetworkInterfaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface
func (c *EC2) CreateNetworkInterfaceRequest(input *CreateNetworkInterfaceInput) (req *request.Request, output *CreateNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInterfaceInput{}
	}

	output = &CreateNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Creates a network interface in the specified subnet.
//
// The number of IP addresses you can assign to a network interface varies by
// instance type. For more information, see IP Addresses Per ENI Per Instance
// Type (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
// in the Amazon Virtual Private Cloud User Guide.
//
// For more information about network interfaces, see Elastic network interfaces
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html) in the
// Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInterface for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface
func (c *EC2) CreateNetworkInterface(input *CreateNetworkInterfaceInput) (*CreateNetworkInterfaceOutput, error) {
	req, out := c.CreateNetworkInterfaceRequest(input)
	return out, req.Send()
}

// CreateNetworkInterfaceWithContext is the same as CreateNetworkInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkInterfaceWithContext(ctx aws.Context, input *CreateNetworkInterfaceInput, opts ...request.Option) (*CreateNetworkInterfaceOutput, error) {
	req, out := c.CreateNetworkInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkInterfacePermission = "CreateNetworkInterfacePermission"

// CreateNetworkInterfacePermissionRequest generates a "aws/request.Request" representing the
// client's request for the CreateNetworkInterfacePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNetworkInterfacePermission for more information on using the CreateNetworkInterfacePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNetworkInterfacePermissionRequest method.
//	req, resp := client.CreateNetworkInterfacePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission
func (c *EC2) CreateNetworkInterfacePermissionRequest(input *CreateNetworkInterfacePermissionInput) (req *request.Request, output *CreateNetworkInterfacePermissionOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkInterfacePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkInterfacePermissionInput{}
	}

	output = &CreateNetworkInterfacePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNetworkInterfacePermission API operation for Amazon Elastic Compute Cloud.
//
// Grants an Amazon Web Services-authorized account permission to attach the
// specified network interface to an instance in their account.
//
// You can grant permission to a single Amazon Web Services account only, and
// only one account at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateNetworkInterfacePermission for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission
func (c *EC2) CreateNetworkInterfacePermission(input *CreateNetworkInterfacePermissionInput) (*CreateNetworkInterfacePermissionOutput, error) {
	req, out := c.CreateNetworkInterfacePermissionRequest(input)
	return out, req.Send()
}

// CreateNetworkInterfacePermissionWithContext is the same as CreateNetworkInterfacePermission with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkInterfacePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateNetworkInterfacePermissionWithContext(ctx aws.Context, input *CreateNetworkInterfacePermissionInput, opts ...request.Option) (*CreateNetworkInterfacePermissionOutput, error) {
	req, out := c.CreateNetworkInterfacePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlacementGroup = "CreatePlacementGroup"

// CreatePlacementGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlacementGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlacementGroup for more information on using the CreatePlacementGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePlacementGroupRequest method.
//	req, resp := client.CreatePlacementGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup
func (c *EC2) CreatePlacementGroupRequest(input *CreatePlacementGroupInput) (req *request.Request, output *CreatePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opCreatePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlacementGroupInput{}
	}

	output = &CreatePlacementGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlacementGroup API operation for Amazon Elastic Compute Cloud.
//
// Creates a placement group in which to launch instances. The strategy of the
// placement group determines how the instances are organized within the group.
//
// A cluster placement group is a logical grouping of instances within a single
// Availability Zone that benefit from low network latency, high network throughput.
// A spread placement group places instances on distinct hardware. A partition
// placement group places groups of instances in different partitions, where
// instances in one partition do not share the same hardware with instances
// in another partition.
//
// For more information, see Placement groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreatePlacementGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup
func (c *EC2) CreatePlacementGroup(input *CreatePlacementGroupInput) (*CreatePlacementGroupOutput, error) {
	req, out := c.CreatePlacementGroupRequest(input)
	return out, req.Send()
}

// CreatePlacementGroupWithContext is the same as CreatePlacementGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlacementGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreatePlacementGroupWithContext(ctx aws.Context, input *CreatePlacementGroupInput, opts ...request.Option) (*CreatePlacementGroupOutput, error) {
	req, out := c.CreatePlacementGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublicIpv4Pool = "CreatePublicIpv4Pool"

// CreatePublicIpv4PoolRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicIpv4Pool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublicIpv4Pool for more information on using the CreatePublicIpv4Pool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePublicIpv4PoolRequest method.
//	req, resp := client.CreatePublicIpv4PoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool
func (c *EC2) CreatePublicIpv4PoolRequest(input *CreatePublicIpv4PoolInput) (req *request.Request, output *CreatePublicIpv4PoolOutput) {
	op := &request.Operation{
		Name:       opCreatePublicIpv4Pool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicIpv4PoolInput{}
	}

	output = &CreatePublicIpv4PoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicIpv4Pool API operation for Amazon Elastic Compute Cloud.
//
// Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address
// pool required for the public IPv4 CIDRs that you own and bring to Amazon
// Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
// Services, however, use IPAM pools only. To monitor the status of pool creation,
// use DescribePublicIpv4Pools (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreatePublicIpv4Pool for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool
func (c *EC2) CreatePublicIpv4Pool(input *CreatePublicIpv4PoolInput) (*CreatePublicIpv4PoolOutput, error) {
	req, out := c.CreatePublicIpv4PoolRequest(input)
	return out, req.Send()
}

// CreatePublicIpv4PoolWithContext is the same as CreatePublicIpv4Pool with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublicIpv4Pool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreatePublicIpv4PoolWithContext(ctx aws.Context, input *CreatePublicIpv4PoolInput, opts ...request.Option) (*CreatePublicIpv4PoolOutput, error) {
	req, out := c.CreatePublicIpv4PoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplaceRootVolumeTask = "CreateReplaceRootVolumeTask"

// CreateReplaceRootVolumeTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplaceRootVolumeTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplaceRootVolumeTask for more information on using the CreateReplaceRootVolumeTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplaceRootVolumeTaskRequest method.
//	req, resp := client.CreateReplaceRootVolumeTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask
func (c *EC2) CreateReplaceRootVolumeTaskRequest(input *CreateReplaceRootVolumeTaskInput) (req *request.Request, output *CreateReplaceRootVolumeTaskOutput) {
	op := &request.Operation{
		Name:       opCreateReplaceRootVolumeTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplaceRootVolumeTaskInput{}
	}

	output = &CreateReplaceRootVolumeTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplaceRootVolumeTask API operation for Amazon Elastic Compute Cloud.
//
// Replaces the EBS-backed root volume for a running instance with a new volume
// that is restored to the original root volume's launch state, that is restored
// to a specific snapshot taken from the original root volume, or that is restored
// from an AMI that has the same key characteristics as that of the instance.
//
// For more information, see Replace a root volume (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateReplaceRootVolumeTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask
func (c *EC2) CreateReplaceRootVolumeTask(input *CreateReplaceRootVolumeTaskInput) (*CreateReplaceRootVolumeTaskOutput, error) {
	req, out := c.CreateReplaceRootVolumeTaskRequest(input)
	return out, req.Send()
}

// CreateReplaceRootVolumeTaskWithContext is the same as CreateReplaceRootVolumeTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplaceRootVolumeTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateReplaceRootVolumeTaskWithContext(ctx aws.Context, input *CreateReplaceRootVolumeTaskInput, opts ...request.Option) (*CreateReplaceRootVolumeTaskOutput, error) {
	req, out := c.CreateReplaceRootVolumeTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReservedInstancesListing = "CreateReservedInstancesListing"

// CreateReservedInstancesListingRequest generates a "aws/request.Request" representing the
// client's request for the CreateReservedInstancesListing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReservedInstancesListing for more information on using the CreateReservedInstancesListing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReservedInstancesListingRequest method.
//	req, resp := client.CreateReservedInstancesListingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing
func (c *EC2) CreateReservedInstancesListingRequest(input *CreateReservedInstancesListingInput) (req *request.Request, output *CreateReservedInstancesListingOutput) {
	op := &request.Operation{
		Name:       opCreateReservedInstancesListing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReservedInstancesListingInput{}
	}

	output = &CreateReservedInstancesListingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReservedInstancesListing API operation for Amazon Elastic Compute Cloud.
//
// Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in
// the Reserved Instance Marketplace. You can submit one Standard Reserved Instance
// listing at a time. To get a list of your Standard Reserved Instances, you
// can use the DescribeReservedInstances operation.
//
// Only Standard Reserved Instances can be sold in the Reserved Instance Marketplace.
// Convertible Reserved Instances cannot be sold.
//
// The Reserved Instance Marketplace matches sellers who want to resell Standard
// Reserved Instance capacity that they no longer need with buyers who want
// to purchase additional capacity. Reserved Instances bought and sold through
// the Reserved Instance Marketplace work like any other Reserved Instances.
//
// To sell your Standard Reserved Instances, you must first register as a seller
// in the Reserved Instance Marketplace. After completing the registration process,
// you can create a Reserved Instance Marketplace listing of some or all of
// your Standard Reserved Instances, and specify the upfront price to receive
// for them. Your Standard Reserved Instance listings then become available
// for purchase. To view the details of your Standard Reserved Instance listing,
// you can use the DescribeReservedInstancesListings operation.
//
// For more information, see Reserved Instance Marketplace (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateReservedInstancesListing for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing
func (c *EC2) CreateReservedInstancesListing(input *CreateReservedInstancesListingInput) (*CreateReservedInstancesListingOutput, error) {
	req, out := c.CreateReservedInstancesListingRequest(input)
	return out, req.Send()
}

// CreateReservedInstancesListingWithContext is the same as CreateReservedInstancesListing with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReservedInstancesListing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateReservedInstancesListingWithContext(ctx aws.Context, input *CreateReservedInstancesListingInput, opts ...request.Option) (*CreateReservedInstancesListingOutput, error) {
	req, out := c.CreateReservedInstancesListingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRestoreImageTask = "CreateRestoreImageTask"

// CreateRestoreImageTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateRestoreImageTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRestoreImageTask for more information on using the CreateRestoreImageTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRestoreImageTaskRequest method.
//	req, resp := client.CreateRestoreImageTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask
func (c *EC2) CreateRestoreImageTaskRequest(input *CreateRestoreImageTaskInput) (req *request.Request, output *CreateRestoreImageTaskOutput) {
	op := &request.Operation{
		Name:       opCreateRestoreImageTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRestoreImageTaskInput{}
	}

	output = &CreateRestoreImageTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRestoreImageTask API operation for Amazon Elastic Compute Cloud.
//
// Starts a task that restores an AMI from an Amazon S3 object that was previously
// created by using CreateStoreImageTask (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html).
//
// To use this API, you must have the required permissions. For more information,
// see Permissions for storing and restoring AMIs using Amazon S3 (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions)
// in the Amazon EC2 User Guide.
//
// For more information, see Store and restore an AMI using Amazon S3 (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateRestoreImageTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask
func (c *EC2) CreateRestoreImageTask(input *CreateRestoreImageTaskInput) (*CreateRestoreImageTaskOutput, error) {
	req, out := c.CreateRestoreImageTaskRequest(input)
	return out, req.Send()
}

// CreateRestoreImageTaskWithContext is the same as CreateRestoreImageTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRestoreImageTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateRestoreImageTaskWithContext(ctx aws.Context, input *CreateRestoreImageTaskInput, opts ...request.Option) (*CreateRestoreImageTaskOutput, error) {
	req, out := c.CreateRestoreImageTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoute for more information on using the CreateRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRouteRequest method.
//	req, resp := client.CreateRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute
func (c *EC2) CreateRouteRequest(input *CreateRouteInput) (req *request.Request, output *CreateRouteOutput) {
	op := &request.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	output = &CreateRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a route in a route table within a VPC.
//
// You must specify either a destination CIDR block or a prefix list ID. You
// must also specify exactly one of the resources from the parameter list.
//
// When determining how to route traffic, we use the route with the most specific
// match. For example, traffic is destined for the IPv4 address 192.0.2.3, and
// the route table includes the following two IPv4 routes:
//
//   - 192.0.2.0/24 (goes to some target A)
//
//   - 192.0.2.0/28 (goes to some target B)
//
// Both routes apply to the traffic destined for 192.0.2.3. However, the second
// route in the list covers a smaller number of IP addresses and is therefore
// more specific, so we use that route to determine where to target the traffic.
//
// For more information about route tables, see Route tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute
func (c *EC2) CreateRoute(input *CreateRouteInput) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	return out, req.Send()
}

// CreateRouteWithContext is the same as CreateRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateRouteWithContext(ctx aws.Context, input *CreateRouteInput, opts ...request.Option) (*CreateRouteOutput, error) {
	req, out := c.CreateRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRouteTable = "CreateRouteTable"

// CreateRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRouteTable for more information on using the CreateRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRouteTableRequest method.
//	req, resp := client.CreateRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable
func (c *EC2) CreateRouteTableRequest(input *CreateRouteTableInput) (req *request.Request, output *CreateRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteTableInput{}
	}

	output = &CreateRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Creates a route table for the specified VPC. After you create a route table,
// you can add routes and associate the table with a subnet.
//
// For more information, see Route tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable
func (c *EC2) CreateRouteTable(input *CreateRouteTableInput) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	return out, req.Send()
}

// CreateRouteTableWithContext is the same as CreateRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateRouteTableWithContext(ctx aws.Context, input *CreateRouteTableInput, opts ...request.Option) (*CreateRouteTableOutput, error) {
	req, out := c.CreateRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityGroup = "CreateSecurityGroup"

// CreateSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityGroup for more information on using the CreateSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSecurityGroupRequest method.
//	req, resp := client.CreateSecurityGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup
func (c *EC2) CreateSecurityGroupRequest(input *CreateSecurityGroupInput) (req *request.Request, output *CreateSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityGroupInput{}
	}

	output = &CreateSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityGroup API operation for Amazon Elastic Compute Cloud.
//
// Creates a security group.
//
// A security group acts as a virtual firewall for your instance to control
// inbound and outbound traffic. For more information, see Amazon EC2 security
// groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
// in the Amazon Elastic Compute Cloud User Guide and Security groups for your
// VPC (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
// in the Amazon Virtual Private Cloud User Guide.
//
// When you create a security group, you specify a friendly name of your choice.
// You can't have two security groups for the same VPC with the same name.
//
// You have a default security group for use in your VPC. If you don't specify
// a security group when you launch an instance, the instance is launched into
// the appropriate default security group. A default security group includes
// a default rule that grants instances unrestricted network access to each
// other.
//
// You can add or remove rules from your security groups using AuthorizeSecurityGroupIngress,
// AuthorizeSecurityGroupEgress, RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
//
// For more information about VPC security group limits, see Amazon VPC Limits
// (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSecurityGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup
func (c *EC2) CreateSecurityGroup(input *CreateSecurityGroupInput) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateSecurityGroupWithContext is the same as CreateSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSecurityGroupWithContext(ctx aws.Context, input *CreateSecurityGroupInput, opts ...request.Option) (*CreateSecurityGroupOutput, error) {
	req, out := c.CreateSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSnapshotRequest method.
//	req, resp := client.CreateSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot
func (c *EC2) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *Snapshot) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &Snapshot{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for Amazon Elastic Compute Cloud.
//
// Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use
// snapshots for backups, to make copies of EBS volumes, and to save data before
// shutting down an instance.
//
// You can create snapshots of volumes in a Region and volumes on an Outpost.
// If you create a snapshot of a volume in a Region, the snapshot must be stored
// in the same Region as the volume. If you create a snapshot of a volume on
// an Outpost, the snapshot can be stored on the same Outpost as the volume,
// or in the Region for that Outpost.
//
// When a snapshot is created, any Amazon Web Services Marketplace product codes
// that are associated with the source volume are propagated to the snapshot.
//
// You can take a snapshot of an attached volume that is in use. However, snapshots
// only capture data that has been written to your Amazon EBS volume at the
// time the snapshot command is issued; this might exclude any data that has
// been cached by any applications or the operating system. If you can pause
// any file systems on the volume long enough to take a snapshot, your snapshot
// should be complete. However, if you cannot pause all file writes to the volume,
// you should unmount the volume from within the instance, issue the snapshot
// command, and then remount the volume to ensure a consistent and complete
// snapshot. You may remount and use your volume while the snapshot status is
// pending.
//
// When you create a snapshot for an EBS volume that serves as a root device,
// we recommend that you stop the instance before taking the snapshot.
//
// Snapshots that are taken from encrypted volumes are automatically encrypted.
// Volumes that are created from encrypted snapshots are also automatically
// encrypted. Your encrypted volumes and any associated snapshots always remain
// protected.
//
// You can tag your snapshots during creation. For more information, see Tag
// your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information, see Amazon Elastic Block Store (https://docs.aws.amazon.com/ebs/latest/userguide/what-is-ebs.html)
// and Amazon EBS encryption (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html)
// in the Amazon EBS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSnapshot for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot
func (c *EC2) CreateSnapshot(input *CreateSnapshotInput) (*Snapshot, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*Snapshot, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshots = "CreateSnapshots"

// CreateSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshots for more information on using the CreateSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSnapshotsRequest method.
//	req, resp := client.CreateSnapshotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots
func (c *EC2) CreateSnapshotsRequest(input *CreateSnapshotsInput) (req *request.Request, output *CreateSnapshotsOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotsInput{}
	}

	output = &CreateSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshots API operation for Amazon Elastic Compute Cloud.
//
// Creates crash-consistent snapshots of multiple EBS volumes and stores the
// data in S3. Volumes are chosen by specifying an instance. Any attached volumes
// will produce one snapshot each that is crash-consistent across the instance.
//
// You can include all of the volumes currently attached to the instance, or
// you can exclude the root volume or specific data (non-root) volumes from
// the multi-volume snapshot set.
//
// You can create multi-volume snapshots of instances in a Region and instances
// on an Outpost. If you create snapshots from an instance in a Region, the
// snapshots must be stored in the same Region as the instance. If you create
// snapshots from an instance on an Outpost, the snapshots can be stored on
// the same Outpost as the instance, or in the Region for that Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSnapshots for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots
func (c *EC2) CreateSnapshots(input *CreateSnapshotsInput) (*CreateSnapshotsOutput, error) {
	req, out := c.CreateSnapshotsRequest(input)
	return out, req.Send()
}

// CreateSnapshotsWithContext is the same as CreateSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSnapshotsWithContext(ctx aws.Context, input *CreateSnapshotsInput, opts ...request.Option) (*CreateSnapshotsOutput, error) {
	req, out := c.CreateSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSpotDatafeedSubscription = "CreateSpotDatafeedSubscription"

// CreateSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSpotDatafeedSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSpotDatafeedSubscription for more information on using the CreateSpotDatafeedSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSpotDatafeedSubscriptionRequest method.
//	req, resp := client.CreateSpotDatafeedSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription
func (c *EC2) CreateSpotDatafeedSubscriptionRequest(input *CreateSpotDatafeedSubscriptionInput) (req *request.Request, output *CreateSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSpotDatafeedSubscriptionInput{}
	}

	output = &CreateSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Creates a data feed for Spot Instances, enabling you to view Spot Instance
// usage logs. You can create one data feed per Amazon Web Services account.
// For more information, see Spot Instance data feed (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
// in the Amazon EC2 User Guide for Linux Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSpotDatafeedSubscription for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription
func (c *EC2) CreateSpotDatafeedSubscription(input *CreateSpotDatafeedSubscriptionInput) (*CreateSpotDatafeedSubscriptionOutput, error) {
	req, out := c.CreateSpotDatafeedSubscriptionRequest(input)
	return out, req.Send()
}

// CreateSpotDatafeedSubscriptionWithContext is the same as CreateSpotDatafeedSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSpotDatafeedSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSpotDatafeedSubscriptionWithContext(ctx aws.Context, input *CreateSpotDatafeedSubscriptionInput, opts ...request.Option) (*CreateSpotDatafeedSubscriptionOutput, error) {
	req, out := c.CreateSpotDatafeedSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStoreImageTask = "CreateStoreImageTask"

// CreateStoreImageTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateStoreImageTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStoreImageTask for more information on using the CreateStoreImageTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStoreImageTaskRequest method.
//	req, resp := client.CreateStoreImageTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask
func (c *EC2) CreateStoreImageTaskRequest(input *CreateStoreImageTaskInput) (req *request.Request, output *CreateStoreImageTaskOutput) {
	op := &request.Operation{
		Name:       opCreateStoreImageTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStoreImageTaskInput{}
	}

	output = &CreateStoreImageTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStoreImageTask API operation for Amazon Elastic Compute Cloud.
//
// Stores an AMI as a single object in an Amazon S3 bucket.
//
// To use this API, you must have the required permissions. For more information,
// see Permissions for storing and restoring AMIs using Amazon S3 (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions)
// in the Amazon EC2 User Guide.
//
// For more information, see Store and restore an AMI using Amazon S3 (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateStoreImageTask for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask
func (c *EC2) CreateStoreImageTask(input *CreateStoreImageTaskInput) (*CreateStoreImageTaskOutput, error) {
	req, out := c.CreateStoreImageTaskRequest(input)
	return out, req.Send()
}

// CreateStoreImageTaskWithContext is the same as CreateStoreImageTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStoreImageTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateStoreImageTaskWithContext(ctx aws.Context, input *CreateStoreImageTaskInput, opts ...request.Option) (*CreateStoreImageTaskOutput, error) {
	req, out := c.CreateStoreImageTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubnet = "CreateSubnet"

// CreateSubnetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubnet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubnet for more information on using the CreateSubnet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubnetRequest method.
//	req, resp := client.CreateSubnetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet
func (c *EC2) CreateSubnetRequest(input *CreateSubnetInput) (req *request.Request, output *CreateSubnetOutput) {
	op := &request.Operation{
		Name:       opCreateSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetInput{}
	}

	output = &CreateSubnetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubnet API operation for Amazon Elastic Compute Cloud.
//
// Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an
// IPv4 CIDR block. If the VPC has an IPv6 CIDR block, you can create an IPv6
// only subnet or a dual stack subnet instead. For an IPv6 only subnet, specify
// an IPv6 CIDR block. For a dual stack subnet, specify both an IPv4 CIDR block
// and an IPv6 CIDR block.
//
// A subnet CIDR block must not overlap the CIDR block of an existing subnet
// in the VPC. After you create a subnet, you can't change its CIDR block.
//
// The allowed size for an IPv4 subnet is between a /28 netmask (16 IP addresses)
// and a /16 netmask (65,536 IP addresses). Amazon Web Services reserves both
// the first four and the last IPv4 address in each subnet's CIDR block. They're
// not available for your use.
//
// If you've associated an IPv6 CIDR block with your VPC, you can associate
// an IPv6 CIDR block with a subnet when you create it.
//
// If you add more than one subnet to a VPC, they're set up in a star topology
// with a logical router in the middle.
//
// When you stop an instance in a subnet, it retains its private IPv4 address.
// It's therefore possible to have a subnet with no running instances (they're
// all stopped), but no remaining IP addresses available.
//
// For more information, see Subnets (https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSubnet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet
func (c *EC2) CreateSubnet(input *CreateSubnetInput) (*CreateSubnetOutput, error) {
	req, out := c.CreateSubnetRequest(input)
	return out, req.Send()
}

// CreateSubnetWithContext is the same as CreateSubnet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubnet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSubnetWithContext(ctx aws.Context, input *CreateSubnetInput, opts ...request.Option) (*CreateSubnetOutput, error) {
	req, out := c.CreateSubnetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubnetCidrReservation = "CreateSubnetCidrReservation"

// CreateSubnetCidrReservationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubnetCidrReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubnetCidrReservation for more information on using the CreateSubnetCidrReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubnetCidrReservationRequest method.
//	req, resp := client.CreateSubnetCidrReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation
func (c *EC2) CreateSubnetCidrReservationRequest(input *CreateSubnetCidrReservationInput) (req *request.Request, output *CreateSubnetCidrReservationOutput) {
	op := &request.Operation{
		Name:       opCreateSubnetCidrReservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetCidrReservationInput{}
	}

	output = &CreateSubnetCidrReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubnetCidrReservation API operation for Amazon Elastic Compute Cloud.
//
// Creates a subnet CIDR reservation. For more information, see Subnet CIDR
// reservations (https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html)
// in the Amazon Virtual Private Cloud User Guide and Assign prefixes to network
// interfaces (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateSubnetCidrReservation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation
func (c *EC2) CreateSubnetCidrReservation(input *CreateSubnetCidrReservationInput) (*CreateSubnetCidrReservationOutput, error) {
	req, out := c.CreateSubnetCidrReservationRequest(input)
	return out, req.Send()
}

// CreateSubnetCidrReservationWithContext is the same as CreateSubnetCidrReservation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubnetCidrReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateSubnetCidrReservationWithContext(ctx aws.Context, input *CreateSubnetCidrReservationInput, opts ...request.Option) (*CreateSubnetCidrReservationOutput, error) {
	req, out := c.CreateSubnetCidrReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTagsRequest method.
//	req, resp := client.CreateTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags
func (c *EC2) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon Elastic Compute Cloud.
//
// Adds or overwrites only the specified tags for the specified Amazon EC2 resource
// or resources. When you specify an existing tag key, the value is overwritten
// with the new value. Each resource can have a maximum of 50 tags. Each tag
// consists of a key and optional value. Tag keys must be unique per resource.
//
// For more information about tags, see Tag your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide. For more information about
// creating IAM policies that control users' access to resources based on tags,
// see Supported resource-level permissions for Amazon EC2 API actions (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags
func (c *EC2) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorFilter = "CreateTrafficMirrorFilter"

// CreateTrafficMirrorFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorFilter for more information on using the CreateTrafficMirrorFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrafficMirrorFilterRequest method.
//	req, resp := client.CreateTrafficMirrorFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter
func (c *EC2) CreateTrafficMirrorFilterRequest(input *CreateTrafficMirrorFilterInput) (req *request.Request, output *CreateTrafficMirrorFilterOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorFilterInput{}
	}

	output = &CreateTrafficMirrorFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorFilter API operation for Amazon Elastic Compute Cloud.
//
// Creates a Traffic Mirror filter.
//
// A Traffic Mirror filter is a set of rules that defines the traffic to mirror.
//
// By default, no traffic is mirrored. To mirror traffic, use CreateTrafficMirrorFilterRule
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm)
// to add Traffic Mirror rules to the filter. The rules you add define what
// traffic gets mirrored. You can also use ModifyTrafficMirrorFilterNetworkServices
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html)
// to mirror supported network services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorFilter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter
func (c *EC2) CreateTrafficMirrorFilter(input *CreateTrafficMirrorFilterInput) (*CreateTrafficMirrorFilterOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorFilterWithContext is the same as CreateTrafficMirrorFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorFilterWithContext(ctx aws.Context, input *CreateTrafficMirrorFilterInput, opts ...request.Option) (*CreateTrafficMirrorFilterOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorFilterRule = "CreateTrafficMirrorFilterRule"

// CreateTrafficMirrorFilterRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorFilterRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorFilterRule for more information on using the CreateTrafficMirrorFilterRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrafficMirrorFilterRuleRequest method.
//	req, resp := client.CreateTrafficMirrorFilterRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule
func (c *EC2) CreateTrafficMirrorFilterRuleRequest(input *CreateTrafficMirrorFilterRuleInput) (req *request.Request, output *CreateTrafficMirrorFilterRuleOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorFilterRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorFilterRuleInput{}
	}

	output = &CreateTrafficMirrorFilterRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorFilterRule API operation for Amazon Elastic Compute Cloud.
//
// Creates a Traffic Mirror filter rule.
//
// A Traffic Mirror rule defines the Traffic Mirror source traffic to mirror.
//
// You need the Traffic Mirror filter ID when you create the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorFilterRule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule
func (c *EC2) CreateTrafficMirrorFilterRule(input *CreateTrafficMirrorFilterRuleInput) (*CreateTrafficMirrorFilterRuleOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRuleRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorFilterRuleWithContext is the same as CreateTrafficMirrorFilterRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorFilterRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorFilterRuleWithContext(ctx aws.Context, input *CreateTrafficMirrorFilterRuleInput, opts ...request.Option) (*CreateTrafficMirrorFilterRuleOutput, error) {
	req, out := c.CreateTrafficMirrorFilterRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorSession = "CreateTrafficMirrorSession"

// CreateTrafficMirrorSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorSession for more information on using the CreateTrafficMirrorSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrafficMirrorSessionRequest method.
//	req, resp := client.CreateTrafficMirrorSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession
func (c *EC2) CreateTrafficMirrorSessionRequest(input *CreateTrafficMirrorSessionInput) (req *request.Request, output *CreateTrafficMirrorSessionOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorSessionInput{}
	}

	output = &CreateTrafficMirrorSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorSession API operation for Amazon Elastic Compute Cloud.
//
// Creates a Traffic Mirror session.
//
// A Traffic Mirror session actively copies packets from a Traffic Mirror source
// to a Traffic Mirror target. Create a filter, and then assign it to the session
// to define a subset of the traffic to mirror, for example all TCP traffic.
//
// The Traffic Mirror source and the Traffic Mirror target (monitoring appliances)
// can be in the same VPC, or in a different VPC connected via VPC peering or
// a transit gateway.
//
// By default, no traffic is mirrored. Use CreateTrafficMirrorFilter (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm)
// to create filter rules that specify the traffic to mirror.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorSession for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession
func (c *EC2) CreateTrafficMirrorSession(input *CreateTrafficMirrorSessionInput) (*CreateTrafficMirrorSessionOutput, error) {
	req, out := c.CreateTrafficMirrorSessionRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorSessionWithContext is the same as CreateTrafficMirrorSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorSessionWithContext(ctx aws.Context, input *CreateTrafficMirrorSessionInput, opts ...request.Option) (*CreateTrafficMirrorSessionOutput, error) {
	req, out := c.CreateTrafficMirrorSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficMirrorTarget = "CreateTrafficMirrorTarget"

// CreateTrafficMirrorTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficMirrorTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficMirrorTarget for more information on using the CreateTrafficMirrorTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrafficMirrorTargetRequest method.
//	req, resp := client.CreateTrafficMirrorTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget
func (c *EC2) CreateTrafficMirrorTargetRequest(input *CreateTrafficMirrorTargetInput) (req *request.Request, output *CreateTrafficMirrorTargetOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficMirrorTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrafficMirrorTargetInput{}
	}

	output = &CreateTrafficMirrorTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficMirrorTarget API operation for Amazon Elastic Compute Cloud.
//
// Creates a target for your Traffic Mirror session.
//
// A Traffic Mirror target is the destination for mirrored traffic. The Traffic
// Mirror source and the Traffic Mirror target (monitoring appliances) can be
// in the same VPC, or in different VPCs connected via VPC peering or a transit
// gateway.
//
// A Traffic Mirror target can be a network interface, a Network Load Balancer,
// or a Gateway Load Balancer endpoint.
//
// To use the target in a Traffic Mirror session, use CreateTrafficMirrorSession
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTrafficMirrorTarget for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget
func (c *EC2) CreateTrafficMirrorTarget(input *CreateTrafficMirrorTargetInput) (*CreateTrafficMirrorTargetOutput, error) {
	req, out := c.CreateTrafficMirrorTargetRequest(input)
	return out, req.Send()
}

// CreateTrafficMirrorTargetWithContext is the same as CreateTrafficMirrorTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficMirrorTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTrafficMirrorTargetWithContext(ctx aws.Context, input *CreateTrafficMirrorTargetInput, opts ...request.Option) (*CreateTrafficMirrorTargetOutput, error) {
	req, out := c.CreateTrafficMirrorTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGateway = "CreateTransitGateway"

// CreateTransitGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGateway for more information on using the CreateTransitGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayRequest method.
//	req, resp := client.CreateTransitGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway
func (c *EC2) CreateTransitGatewayRequest(input *CreateTransitGatewayInput) (req *request.Request, output *CreateTransitGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayInput{}
	}

	output = &CreateTransitGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a transit gateway.
//
// You can use a transit gateway to interconnect your virtual private clouds
// (VPC) and on-premises networks. After the transit gateway enters the available
// state, you can attach your VPCs and VPN connections to the transit gateway.
//
// To attach your VPCs, use CreateTransitGatewayVpcAttachment.
//
// To attach a VPN connection, use CreateCustomerGateway to create a customer
// gateway and specify the ID of the customer gateway and the ID of the transit
// gateway in a call to CreateVpnConnection.
//
// When you create a transit gateway, we create a default transit gateway route
// table and use it as the default association route table and the default propagation
// route table. You can use CreateTransitGatewayRouteTable to create additional
// transit gateway route tables. If you disable automatic route propagation,
// we do not create a default transit gateway route table. You can use EnableTransitGatewayRouteTablePropagation
// to propagate routes from a resource attachment to a transit gateway route
// table. If you disable automatic associations, you can use AssociateTransitGatewayRouteTable
// to associate a resource attachment with a transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway
func (c *EC2) CreateTransitGateway(input *CreateTransitGatewayInput) (*CreateTransitGatewayOutput, error) {
	req, out := c.CreateTransitGatewayRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayWithContext is the same as CreateTransitGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayWithContext(ctx aws.Context, input *CreateTransitGatewayInput, opts ...request.Option) (*CreateTransitGatewayOutput, error) {
	req, out := c.CreateTransitGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayConnect = "CreateTransitGatewayConnect"

// CreateTransitGatewayConnectRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayConnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayConnect for more information on using the CreateTransitGatewayConnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayConnectRequest method.
//	req, resp := client.CreateTransitGatewayConnectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect
func (c *EC2) CreateTransitGatewayConnectRequest(input *CreateTransitGatewayConnectInput) (req *request.Request, output *CreateTransitGatewayConnectOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayConnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayConnectInput{}
	}

	output = &CreateTransitGatewayConnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayConnect API operation for Amazon Elastic Compute Cloud.
//
// Creates a Connect attachment from a specified transit gateway attachment.
// A Connect attachment is a GRE-based tunnel attachment that you can use to
// establish a connection between a transit gateway and an appliance.
//
// A Connect attachment uses an existing VPC or Amazon Web Services Direct Connect
// attachment as the underlying transport mechanism.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayConnect for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect
func (c *EC2) CreateTransitGatewayConnect(input *CreateTransitGatewayConnectInput) (*CreateTransitGatewayConnectOutput, error) {
	req, out := c.CreateTransitGatewayConnectRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayConnectWithContext is the same as CreateTransitGatewayConnect with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayConnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayConnectWithContext(ctx aws.Context, input *CreateTransitGatewayConnectInput, opts ...request.Option) (*CreateTransitGatewayConnectOutput, error) {
	req, out := c.CreateTransitGatewayConnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayConnectPeer = "CreateTransitGatewayConnectPeer"

// CreateTransitGatewayConnectPeerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayConnectPeer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayConnectPeer for more information on using the CreateTransitGatewayConnectPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayConnectPeerRequest method.
//	req, resp := client.CreateTransitGatewayConnectPeerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer
func (c *EC2) CreateTransitGatewayConnectPeerRequest(input *CreateTransitGatewayConnectPeerInput) (req *request.Request, output *CreateTransitGatewayConnectPeerOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayConnectPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayConnectPeerInput{}
	}

	output = &CreateTransitGatewayConnectPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayConnectPeer API operation for Amazon Elastic Compute Cloud.
//
// Creates a Connect peer for a specified transit gateway Connect attachment
// between a transit gateway and an appliance.
//
// The peer address and transit gateway address must be the same IP address
// family (IPv4 or IPv6).
//
// For more information, see Connect peers (https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer)
// in the Transit Gateways Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayConnectPeer for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer
func (c *EC2) CreateTransitGatewayConnectPeer(input *CreateTransitGatewayConnectPeerInput) (*CreateTransitGatewayConnectPeerOutput, error) {
	req, out := c.CreateTransitGatewayConnectPeerRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayConnectPeerWithContext is the same as CreateTransitGatewayConnectPeer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayConnectPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayConnectPeerWithContext(ctx aws.Context, input *CreateTransitGatewayConnectPeerInput, opts ...request.Option) (*CreateTransitGatewayConnectPeerOutput, error) {
	req, out := c.CreateTransitGatewayConnectPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayMulticastDomain = "CreateTransitGatewayMulticastDomain"

// CreateTransitGatewayMulticastDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayMulticastDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayMulticastDomain for more information on using the CreateTransitGatewayMulticastDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayMulticastDomainRequest method.
//	req, resp := client.CreateTransitGatewayMulticastDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain
func (c *EC2) CreateTransitGatewayMulticastDomainRequest(input *CreateTransitGatewayMulticastDomainInput) (req *request.Request, output *CreateTransitGatewayMulticastDomainOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayMulticastDomainInput{}
	}

	output = &CreateTransitGatewayMulticastDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayMulticastDomain API operation for Amazon Elastic Compute Cloud.
//
// Creates a multicast domain using the specified transit gateway.
//
// The transit gateway must be in the available state before you create a domain.
// Use DescribeTransitGateways (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html)
// to see the state of transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayMulticastDomain for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain
func (c *EC2) CreateTransitGatewayMulticastDomain(input *CreateTransitGatewayMulticastDomainInput) (*CreateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.CreateTransitGatewayMulticastDomainRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayMulticastDomainWithContext is the same as CreateTransitGatewayMulticastDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayMulticastDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayMulticastDomainWithContext(ctx aws.Context, input *CreateTransitGatewayMulticastDomainInput, opts ...request.Option) (*CreateTransitGatewayMulticastDomainOutput, error) {
	req, out := c.CreateTransitGatewayMulticastDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayPeeringAttachment = "CreateTransitGatewayPeeringAttachment"

// CreateTransitGatewayPeeringAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayPeeringAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayPeeringAttachment for more information on using the CreateTransitGatewayPeeringAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayPeeringAttachmentRequest method.
//	req, resp := client.CreateTransitGatewayPeeringAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment
func (c *EC2) CreateTransitGatewayPeeringAttachmentRequest(input *CreateTransitGatewayPeeringAttachmentInput) (req *request.Request, output *CreateTransitGatewayPeeringAttachmentOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayPeeringAttachmentInput{}
	}

	output = &CreateTransitGatewayPeeringAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayPeeringAttachment API operation for Amazon Elastic Compute Cloud.
//
// Requests a transit gateway peering attachment between the specified transit
// gateway (requester) and a peer transit gateway (accepter). The peer transit
// gateway can be in your account or a different Amazon Web Services account.
//
// After you create the peering attachment, the owner of the accepter transit
// gateway must accept the attachment request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayPeeringAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment
func (c *EC2) CreateTransitGatewayPeeringAttachment(input *CreateTransitGatewayPeeringAttachmentInput) (*CreateTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayPeeringAttachmentRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayPeeringAttachmentWithContext is the same as CreateTransitGatewayPeeringAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayPeeringAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayPeeringAttachmentWithContext(ctx aws.Context, input *CreateTransitGatewayPeeringAttachmentInput, opts ...request.Option) (*CreateTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayPeeringAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayPolicyTable = "CreateTransitGatewayPolicyTable"

// CreateTransitGatewayPolicyTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayPolicyTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayPolicyTable for more information on using the CreateTransitGatewayPolicyTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayPolicyTableRequest method.
//	req, resp := client.CreateTransitGatewayPolicyTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable
func (c *EC2) CreateTransitGatewayPolicyTableRequest(input *CreateTransitGatewayPolicyTableInput) (req *request.Request, output *CreateTransitGatewayPolicyTableOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayPolicyTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayPolicyTableInput{}
	}

	output = &CreateTransitGatewayPolicyTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayPolicyTable API operation for Amazon Elastic Compute Cloud.
//
// Creates a transit gateway policy table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayPolicyTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable
func (c *EC2) CreateTransitGatewayPolicyTable(input *CreateTransitGatewayPolicyTableInput) (*CreateTransitGatewayPolicyTableOutput, error) {
	req, out := c.CreateTransitGatewayPolicyTableRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayPolicyTableWithContext is the same as CreateTransitGatewayPolicyTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayPolicyTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayPolicyTableWithContext(ctx aws.Context, input *CreateTransitGatewayPolicyTableInput, opts ...request.Option) (*CreateTransitGatewayPolicyTableOutput, error) {
	req, out := c.CreateTransitGatewayPolicyTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayPrefixListReference = "CreateTransitGatewayPrefixListReference"

// CreateTransitGatewayPrefixListReferenceRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayPrefixListReference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayPrefixListReference for more information on using the CreateTransitGatewayPrefixListReference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayPrefixListReferenceRequest method.
//	req, resp := client.CreateTransitGatewayPrefixListReferenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference
func (c *EC2) CreateTransitGatewayPrefixListReferenceRequest(input *CreateTransitGatewayPrefixListReferenceInput) (req *request.Request, output *CreateTransitGatewayPrefixListReferenceOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayPrefixListReference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayPrefixListReferenceInput{}
	}

	output = &CreateTransitGatewayPrefixListReferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayPrefixListReference API operation for Amazon Elastic Compute Cloud.
//
// Creates a reference (route) to a prefix list in a specified transit gateway
// route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayPrefixListReference for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference
func (c *EC2) CreateTransitGatewayPrefixListReference(input *CreateTransitGatewayPrefixListReferenceInput) (*CreateTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.CreateTransitGatewayPrefixListReferenceRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayPrefixListReferenceWithContext is the same as CreateTransitGatewayPrefixListReference with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayPrefixListReference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayPrefixListReferenceWithContext(ctx aws.Context, input *CreateTransitGatewayPrefixListReferenceInput, opts ...request.Option) (*CreateTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.CreateTransitGatewayPrefixListReferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayRoute = "CreateTransitGatewayRoute"

// CreateTransitGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayRoute for more information on using the CreateTransitGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayRouteRequest method.
//	req, resp := client.CreateTransitGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute
func (c *EC2) CreateTransitGatewayRouteRequest(input *CreateTransitGatewayRouteInput) (req *request.Request, output *CreateTransitGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayRouteInput{}
	}

	output = &CreateTransitGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a static route for the specified transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRoute
func (c *EC2) CreateTransitGatewayRoute(input *CreateTransitGatewayRouteInput) (*CreateTransitGatewayRouteOutput, error) {
	req, out := c.CreateTransitGatewayRouteRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayRouteWithContext is the same as CreateTransitGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayRouteWithContext(ctx aws.Context, input *CreateTransitGatewayRouteInput, opts ...request.Option) (*CreateTransitGatewayRouteOutput, error) {
	req, out := c.CreateTransitGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayRouteTable = "CreateTransitGatewayRouteTable"

// CreateTransitGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayRouteTable for more information on using the CreateTransitGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayRouteTableRequest method.
//	req, resp := client.CreateTransitGatewayRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable
func (c *EC2) CreateTransitGatewayRouteTableRequest(input *CreateTransitGatewayRouteTableInput) (req *request.Request, output *CreateTransitGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayRouteTableInput{}
	}

	output = &CreateTransitGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Creates a route table for the specified transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTable
func (c *EC2) CreateTransitGatewayRouteTable(input *CreateTransitGatewayRouteTableInput) (*CreateTransitGatewayRouteTableOutput, error) {
	req, out := c.CreateTransitGatewayRouteTableRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayRouteTableWithContext is the same as CreateTransitGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayRouteTableWithContext(ctx aws.Context, input *CreateTransitGatewayRouteTableInput, opts ...request.Option) (*CreateTransitGatewayRouteTableOutput, error) {
	req, out := c.CreateTransitGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayRouteTableAnnouncement = "CreateTransitGatewayRouteTableAnnouncement"

// CreateTransitGatewayRouteTableAnnouncementRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayRouteTableAnnouncement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayRouteTableAnnouncement for more information on using the CreateTransitGatewayRouteTableAnnouncement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayRouteTableAnnouncementRequest method.
//	req, resp := client.CreateTransitGatewayRouteTableAnnouncementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement
func (c *EC2) CreateTransitGatewayRouteTableAnnouncementRequest(input *CreateTransitGatewayRouteTableAnnouncementInput) (req *request.Request, output *CreateTransitGatewayRouteTableAnnouncementOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayRouteTableAnnouncement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayRouteTableAnnouncementInput{}
	}

	output = &CreateTransitGatewayRouteTableAnnouncementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayRouteTableAnnouncement API operation for Amazon Elastic Compute Cloud.
//
// Advertises a new transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayRouteTableAnnouncement for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableAnnouncement
func (c *EC2) CreateTransitGatewayRouteTableAnnouncement(input *CreateTransitGatewayRouteTableAnnouncementInput) (*CreateTransitGatewayRouteTableAnnouncementOutput, error) {
	req, out := c.CreateTransitGatewayRouteTableAnnouncementRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayRouteTableAnnouncementWithContext is the same as CreateTransitGatewayRouteTableAnnouncement with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayRouteTableAnnouncement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayRouteTableAnnouncementWithContext(ctx aws.Context, input *CreateTransitGatewayRouteTableAnnouncementInput, opts ...request.Option) (*CreateTransitGatewayRouteTableAnnouncementOutput, error) {
	req, out := c.CreateTransitGatewayRouteTableAnnouncementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTransitGatewayVpcAttachment = "CreateTransitGatewayVpcAttachment"

// CreateTransitGatewayVpcAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateTransitGatewayVpcAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTransitGatewayVpcAttachment for more information on using the CreateTransitGatewayVpcAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTransitGatewayVpcAttachmentRequest method.
//	req, resp := client.CreateTransitGatewayVpcAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment
func (c *EC2) CreateTransitGatewayVpcAttachmentRequest(input *CreateTransitGatewayVpcAttachmentInput) (req *request.Request, output *CreateTransitGatewayVpcAttachmentOutput) {
	op := &request.Operation{
		Name:       opCreateTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransitGatewayVpcAttachmentInput{}
	}

	output = &CreateTransitGatewayVpcAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTransitGatewayVpcAttachment API operation for Amazon Elastic Compute Cloud.
//
// Attaches the specified VPC to the specified transit gateway.
//
// If you attach a VPC with a CIDR range that overlaps the CIDR range of a VPC
// that is already attached, the new VPC CIDR range is not propagated to the
// default propagation route table.
//
// To send VPC traffic to an attached transit gateway, add a route to the VPC
// route table using CreateRoute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateTransitGatewayVpcAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachment
func (c *EC2) CreateTransitGatewayVpcAttachment(input *CreateTransitGatewayVpcAttachmentInput) (*CreateTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayVpcAttachmentRequest(input)
	return out, req.Send()
}

// CreateTransitGatewayVpcAttachmentWithContext is the same as CreateTransitGatewayVpcAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTransitGatewayVpcAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateTransitGatewayVpcAttachmentWithContext(ctx aws.Context, input *CreateTransitGatewayVpcAttachmentInput, opts ...request.Option) (*CreateTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.CreateTransitGatewayVpcAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVerifiedAccessEndpoint = "CreateVerifiedAccessEndpoint"

// CreateVerifiedAccessEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateVerifiedAccessEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVerifiedAccessEndpoint for more information on using the CreateVerifiedAccessEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVerifiedAccessEndpointRequest method.
//	req, resp := client.CreateVerifiedAccessEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint
func (c *EC2) CreateVerifiedAccessEndpointRequest(input *CreateVerifiedAccessEndpointInput) (req *request.Request, output *CreateVerifiedAccessEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateVerifiedAccessEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVerifiedAccessEndpointInput{}
	}

	output = &CreateVerifiedAccessEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVerifiedAccessEndpoint API operation for Amazon Elastic Compute Cloud.
//
// An Amazon Web Services Verified Access endpoint is where you define your
// application along with an optional endpoint-level access policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVerifiedAccessEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessEndpoint
func (c *EC2) CreateVerifiedAccessEndpoint(input *CreateVerifiedAccessEndpointInput) (*CreateVerifiedAccessEndpointOutput, error) {
	req, out := c.CreateVerifiedAccessEndpointRequest(input)
	return out, req.Send()
}

// CreateVerifiedAccessEndpointWithContext is the same as CreateVerifiedAccessEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVerifiedAccessEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVerifiedAccessEndpointWithContext(ctx aws.Context, input *CreateVerifiedAccessEndpointInput, opts ...request.Option) (*CreateVerifiedAccessEndpointOutput, error) {
	req, out := c.CreateVerifiedAccessEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVerifiedAccessGroup = "CreateVerifiedAccessGroup"

// CreateVerifiedAccessGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateVerifiedAccessGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVerifiedAccessGroup for more information on using the CreateVerifiedAccessGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVerifiedAccessGroupRequest method.
//	req, resp := client.CreateVerifiedAccessGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup
func (c *EC2) CreateVerifiedAccessGroupRequest(input *CreateVerifiedAccessGroupInput) (req *request.Request, output *CreateVerifiedAccessGroupOutput) {
	op := &request.Operation{
		Name:       opCreateVerifiedAccessGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVerifiedAccessGroupInput{}
	}

	output = &CreateVerifiedAccessGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVerifiedAccessGroup API operation for Amazon Elastic Compute Cloud.
//
// An Amazon Web Services Verified Access group is a collection of Amazon Web
// Services Verified Access endpoints who's associated applications have similar
// security requirements. Each instance within a Verified Access group shares
// an Verified Access policy. For example, you can group all Verified Access
// instances associated with "sales" applications together and use one common
// Verified Access policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVerifiedAccessGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessGroup
func (c *EC2) CreateVerifiedAccessGroup(input *CreateVerifiedAccessGroupInput) (*CreateVerifiedAccessGroupOutput, error) {
	req, out := c.CreateVerifiedAccessGroupRequest(input)
	return out, req.Send()
}

// CreateVerifiedAccessGroupWithContext is the same as CreateVerifiedAccessGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVerifiedAccessGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVerifiedAccessGroupWithContext(ctx aws.Context, input *CreateVerifiedAccessGroupInput, opts ...request.Option) (*CreateVerifiedAccessGroupOutput, error) {
	req, out := c.CreateVerifiedAccessGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVerifiedAccessInstance = "CreateVerifiedAccessInstance"

// CreateVerifiedAccessInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateVerifiedAccessInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVerifiedAccessInstance for more information on using the CreateVerifiedAccessInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVerifiedAccessInstanceRequest method.
//	req, resp := client.CreateVerifiedAccessInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance
func (c *EC2) CreateVerifiedAccessInstanceRequest(input *CreateVerifiedAccessInstanceInput) (req *request.Request, output *CreateVerifiedAccessInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateVerifiedAccessInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVerifiedAccessInstanceInput{}
	}

	output = &CreateVerifiedAccessInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVerifiedAccessInstance API operation for Amazon Elastic Compute Cloud.
//
// An Amazon Web Services Verified Access instance is a regional entity that
// evaluates application requests and grants access only when your security
// requirements are met.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVerifiedAccessInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessInstance
func (c *EC2) CreateVerifiedAccessInstance(input *CreateVerifiedAccessInstanceInput) (*CreateVerifiedAccessInstanceOutput, error) {
	req, out := c.CreateVerifiedAccessInstanceRequest(input)
	return out, req.Send()
}

// CreateVerifiedAccessInstanceWithContext is the same as CreateVerifiedAccessInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVerifiedAccessInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVerifiedAccessInstanceWithContext(ctx aws.Context, input *CreateVerifiedAccessInstanceInput, opts ...request.Option) (*CreateVerifiedAccessInstanceOutput, error) {
	req, out := c.CreateVerifiedAccessInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVerifiedAccessTrustProvider = "CreateVerifiedAccessTrustProvider"

// CreateVerifiedAccessTrustProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateVerifiedAccessTrustProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVerifiedAccessTrustProvider for more information on using the CreateVerifiedAccessTrustProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVerifiedAccessTrustProviderRequest method.
//	req, resp := client.CreateVerifiedAccessTrustProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider
func (c *EC2) CreateVerifiedAccessTrustProviderRequest(input *CreateVerifiedAccessTrustProviderInput) (req *request.Request, output *CreateVerifiedAccessTrustProviderOutput) {
	op := &request.Operation{
		Name:       opCreateVerifiedAccessTrustProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVerifiedAccessTrustProviderInput{}
	}

	output = &CreateVerifiedAccessTrustProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVerifiedAccessTrustProvider API operation for Amazon Elastic Compute Cloud.
//
// A trust provider is a third-party entity that creates, maintains, and manages
// identity information for users and devices. When an application request is
// made, the identity information sent by the trust provider is evaluated by
// Verified Access before allowing or denying the application request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVerifiedAccessTrustProvider for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVerifiedAccessTrustProvider
func (c *EC2) CreateVerifiedAccessTrustProvider(input *CreateVerifiedAccessTrustProviderInput) (*CreateVerifiedAccessTrustProviderOutput, error) {
	req, out := c.CreateVerifiedAccessTrustProviderRequest(input)
	return out, req.Send()
}

// CreateVerifiedAccessTrustProviderWithContext is the same as CreateVerifiedAccessTrustProvider with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVerifiedAccessTrustProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVerifiedAccessTrustProviderWithContext(ctx aws.Context, input *CreateVerifiedAccessTrustProviderInput, opts ...request.Option) (*CreateVerifiedAccessTrustProviderOutput, error) {
	req, out := c.CreateVerifiedAccessTrustProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVolume = "CreateVolume"

// CreateVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVolume for more information on using the CreateVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVolumeRequest method.
//	req, resp := client.CreateVolumeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume
func (c *EC2) CreateVolumeRequest(input *CreateVolumeInput) (req *request.Request, output *Volume) {
	op := &request.Operation{
		Name:       opCreateVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVolumeInput{}
	}

	output = &Volume{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVolume API operation for Amazon Elastic Compute Cloud.
//
// Creates an EBS volume that can be attached to an instance in the same Availability
// Zone.
//
// You can create a new empty volume or restore a volume from an EBS snapshot.
// Any Amazon Web Services Marketplace product codes from the snapshot are propagated
// to the volume.
//
// You can create encrypted volumes. Encrypted volumes must be attached to instances
// that support Amazon EBS encryption. Volumes that are created from encrypted
// snapshots are also automatically encrypted. For more information, see Amazon
// EBS encryption (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html)
// in the Amazon EBS User Guide.
//
// You can tag your volumes during creation. For more information, see Tag your
// Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For more information, see Create an Amazon EBS volume (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-creating-volume.html)
// in the Amazon EBS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVolume for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolume
func (c *EC2) CreateVolume(input *CreateVolumeInput) (*Volume, error) {
	req, out := c.CreateVolumeRequest(input)
	return out, req.Send()
}

// CreateVolumeWithContext is the same as CreateVolume with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVolumeWithContext(ctx aws.Context, input *CreateVolumeInput, opts ...request.Option) (*Volume, error) {
	req, out := c.CreateVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpc = "CreateVpc"

// CreateVpcRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpc for more information on using the CreateVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcRequest method.
//	req, resp := client.CreateVpcRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc
func (c *EC2) CreateVpcRequest(input *CreateVpcInput) (req *request.Request, output *CreateVpcOutput) {
	op := &request.Operation{
		Name:       opCreateVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcInput{}
	}

	output = &CreateVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpc API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC with the specified CIDR blocks. For more information, see IP
// addressing for your VPCs and subnets (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html)
// in the Amazon VPC User Guide.
//
// You can optionally request an IPv6 CIDR block for the VPC. You can request
// an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6 addresses or
// an IPv6 CIDR block from an IPv6 address pool that you provisioned through
// bring your own IP addresses (BYOIP (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)).
//
// By default, each instance that you launch in the VPC has the default DHCP
// options, which include only a default DNS server that we provide (AmazonProvidedDNS).
// For more information, see DHCP option sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon VPC User Guide.
//
// You can specify the instance tenancy value for the VPC when you create it.
// You can't change this value for the VPC after you create it. For more information,
// see Dedicated Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpc
func (c *EC2) CreateVpc(input *CreateVpcInput) (*CreateVpcOutput, error) {
	req, out := c.CreateVpcRequest(input)
	return out, req.Send()
}

// CreateVpcWithContext is the same as CreateVpc with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcWithContext(ctx aws.Context, input *CreateVpcInput, opts ...request.Option) (*CreateVpcOutput, error) {
	req, out := c.CreateVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpoint = "CreateVpcEndpoint"

// CreateVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpoint for more information on using the CreateVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcEndpointRequest method.
//	req, resp := client.CreateVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint
func (c *EC2) CreateVpcEndpointRequest(input *CreateVpcEndpointInput) (req *request.Request, output *CreateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointInput{}
	}

	output = &CreateVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC endpoint. A VPC endpoint provides a private connection between
// the specified VPC and the specified endpoint service. You can use an endpoint
// service provided by Amazon Web Services, an Amazon Web Services Marketplace
// Partner, or another Amazon Web Services account. For more information, see
// the Amazon Web Services PrivateLink User Guide (https://docs.aws.amazon.com/vpc/latest/privatelink/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpoint
func (c *EC2) CreateVpcEndpoint(input *CreateVpcEndpointInput) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointWithContext is the same as CreateVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcEndpointWithContext(ctx aws.Context, input *CreateVpcEndpointInput, opts ...request.Option) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpointConnectionNotification = "CreateVpcEndpointConnectionNotification"

// CreateVpcEndpointConnectionNotificationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpointConnectionNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpointConnectionNotification for more information on using the CreateVpcEndpointConnectionNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcEndpointConnectionNotificationRequest method.
//	req, resp := client.CreateVpcEndpointConnectionNotificationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification
func (c *EC2) CreateVpcEndpointConnectionNotificationRequest(input *CreateVpcEndpointConnectionNotificationInput) (req *request.Request, output *CreateVpcEndpointConnectionNotificationOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpointConnectionNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointConnectionNotificationInput{}
	}

	output = &CreateVpcEndpointConnectionNotificationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpointConnectionNotification API operation for Amazon Elastic Compute Cloud.
//
// Creates a connection notification for a specified VPC endpoint or VPC endpoint
// service. A connection notification notifies you of specific endpoint events.
// You must create an SNS topic to receive notifications. For more information,
// see Create a Topic (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html)
// in the Amazon Simple Notification Service Developer Guide.
//
// You can create a connection notification for interface endpoints only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcEndpointConnectionNotification for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotification
func (c *EC2) CreateVpcEndpointConnectionNotification(input *CreateVpcEndpointConnectionNotificationInput) (*CreateVpcEndpointConnectionNotificationOutput, error) {
	req, out := c.CreateVpcEndpointConnectionNotificationRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointConnectionNotificationWithContext is the same as CreateVpcEndpointConnectionNotification with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpointConnectionNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcEndpointConnectionNotificationWithContext(ctx aws.Context, input *CreateVpcEndpointConnectionNotificationInput, opts ...request.Option) (*CreateVpcEndpointConnectionNotificationOutput, error) {
	req, out := c.CreateVpcEndpointConnectionNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpointServiceConfiguration = "CreateVpcEndpointServiceConfiguration"

// CreateVpcEndpointServiceConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpointServiceConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpointServiceConfiguration for more information on using the CreateVpcEndpointServiceConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcEndpointServiceConfigurationRequest method.
//	req, resp := client.CreateVpcEndpointServiceConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration
func (c *EC2) CreateVpcEndpointServiceConfigurationRequest(input *CreateVpcEndpointServiceConfigurationInput) (req *request.Request, output *CreateVpcEndpointServiceConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpointServiceConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointServiceConfigurationInput{}
	}

	output = &CreateVpcEndpointServiceConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpointServiceConfiguration API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPC endpoint service to which service consumers (Amazon Web Services
// accounts, users, and IAM roles) can connect.
//
// Before you create an endpoint service, you must create one of the following
// for your service:
//
//   - A Network Load Balancer (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/).
//     Service consumers connect to your service using an interface endpoint.
//
//   - A Gateway Load Balancer (https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/).
//     Service consumers connect to your service using a Gateway Load Balancer
//     endpoint.
//
// If you set the private DNS name, you must prove that you own the private
// DNS domain name.
//
// For more information, see the Amazon Web Services PrivateLink Guide (https://docs.aws.amazon.com/vpc/latest/privatelink/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcEndpointServiceConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfiguration
func (c *EC2) CreateVpcEndpointServiceConfiguration(input *CreateVpcEndpointServiceConfigurationInput) (*CreateVpcEndpointServiceConfigurationOutput, error) {
	req, out := c.CreateVpcEndpointServiceConfigurationRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointServiceConfigurationWithContext is the same as CreateVpcEndpointServiceConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpointServiceConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcEndpointServiceConfigurationWithContext(ctx aws.Context, input *CreateVpcEndpointServiceConfigurationInput, opts ...request.Option) (*CreateVpcEndpointServiceConfigurationOutput, error) {
	req, out := c.CreateVpcEndpointServiceConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcPeeringConnection = "CreateVpcPeeringConnection"

// CreateVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcPeeringConnection for more information on using the CreateVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcPeeringConnectionRequest method.
//	req, resp := client.CreateVpcPeeringConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection
func (c *EC2) CreateVpcPeeringConnectionRequest(input *CreateVpcPeeringConnectionInput) (req *request.Request, output *CreateVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringConnectionInput{}
	}

	output = &CreateVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Requests a VPC peering connection between two VPCs: a requester VPC that
// you own and an accepter VPC with which to create the connection. The accepter
// VPC can belong to another Amazon Web Services account and can be in a different
// Region to the requester VPC. The requester VPC and accepter VPC cannot have
// overlapping CIDR blocks.
//
// Limitations and rules apply to a VPC peering connection. For more information,
// see the limitations (https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations)
// section in the VPC Peering Guide.
//
// The owner of the accepter VPC must accept the peering request to activate
// the peering connection. The VPC peering connection request expires after
// 7 days, after which it cannot be accepted or rejected.
//
// If you create a VPC peering connection request between VPCs with overlapping
// CIDR blocks, the VPC peering connection has a status of failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpcPeeringConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnection
func (c *EC2) CreateVpcPeeringConnection(input *CreateVpcPeeringConnectionInput) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// CreateVpcPeeringConnectionWithContext is the same as CreateVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpcPeeringConnectionWithContext(ctx aws.Context, input *CreateVpcPeeringConnectionInput, opts ...request.Option) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpnConnection = "CreateVpnConnection"

// CreateVpnConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpnConnection for more information on using the CreateVpnConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpnConnectionRequest method.
//	req, resp := client.CreateVpnConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection
func (c *EC2) CreateVpnConnectionRequest(input *CreateVpnConnectionInput) (req *request.Request, output *CreateVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionInput{}
	}

	output = &CreateVpnConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpnConnection API operation for Amazon Elastic Compute Cloud.
//
// Creates a VPN connection between an existing virtual private gateway or transit
// gateway and a customer gateway. The supported connection type is ipsec.1.
//
// The response includes information that you need to give to your network administrator
// to configure your customer gateway.
//
// We strongly recommend that you use HTTPS when calling this operation because
// the response contains sensitive cryptographic information for configuring
// your customer gateway device.
//
// If you decide to shut down your VPN connection for any reason and later create
// a new VPN connection, you must reconfigure your customer gateway with the
// new information returned from this call.
//
// This is an idempotent operation. If you perform the operation more than once,
// Amazon EC2 doesn't return an error.
//
// For more information, see Amazon Web Services Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the Amazon Web Services Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnection
func (c *EC2) CreateVpnConnection(input *CreateVpnConnectionInput) (*CreateVpnConnectionOutput, error) {
	req, out := c.CreateVpnConnectionRequest(input)
	return out, req.Send()
}

// CreateVpnConnectionWithContext is the same as CreateVpnConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpnConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpnConnectionWithContext(ctx aws.Context, input *CreateVpnConnectionInput, opts ...request.Option) (*CreateVpnConnectionOutput, error) {
	req, out := c.CreateVpnConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpnConnectionRoute = "CreateVpnConnectionRoute"

// CreateVpnConnectionRouteRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnConnectionRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpnConnectionRoute for more information on using the CreateVpnConnectionRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpnConnectionRouteRequest method.
//	req, resp := client.CreateVpnConnectionRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute
func (c *EC2) CreateVpnConnectionRouteRequest(input *CreateVpnConnectionRouteInput) (req *request.Request, output *CreateVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opCreateVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnConnectionRouteInput{}
	}

	output = &CreateVpnConnectionRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateVpnConnectionRoute API operation for Amazon Elastic Compute Cloud.
//
// Creates a static route associated with a VPN connection between an existing
// virtual private gateway and a VPN customer gateway. The static route allows
// traffic to be routed from the virtual private gateway to the VPN customer
// gateway.
//
// For more information, see Amazon Web Services Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the Amazon Web Services Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnConnectionRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRoute
func (c *EC2) CreateVpnConnectionRoute(input *CreateVpnConnectionRouteInput) (*CreateVpnConnectionRouteOutput, error) {
	req, out := c.CreateVpnConnectionRouteRequest(input)
	return out, req.Send()
}

// CreateVpnConnectionRouteWithContext is the same as CreateVpnConnectionRoute with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpnConnectionRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpnConnectionRouteWithContext(ctx aws.Context, input *CreateVpnConnectionRouteInput, opts ...request.Option) (*CreateVpnConnectionRouteOutput, error) {
	req, out := c.CreateVpnConnectionRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpnGateway = "CreateVpnGateway"

// CreateVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpnGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpnGateway for more information on using the CreateVpnGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpnGatewayRequest method.
//	req, resp := client.CreateVpnGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway
func (c *EC2) CreateVpnGatewayRequest(input *CreateVpnGatewayInput) (req *request.Request, output *CreateVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opCreateVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpnGatewayInput{}
	}

	output = &CreateVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Creates a virtual private gateway. A virtual private gateway is the endpoint
// on the VPC side of your VPN connection. You can create a virtual private
// gateway before creating the VPC itself.
//
// For more information, see Amazon Web Services Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the Amazon Web Services Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation CreateVpnGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGateway
func (c *EC2) CreateVpnGateway(input *CreateVpnGatewayInput) (*CreateVpnGatewayOutput, error) {
	req, out := c.CreateVpnGatewayRequest(input)
	return out, req.Send()
}

// CreateVpnGatewayWithContext is the same as CreateVpnGateway with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpnGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) CreateVpnGatewayWithContext(ctx aws.Context, input *CreateVpnGatewayInput, opts ...request.Option) (*CreateVpnGatewayOutput, error) {
	req, out := c.CreateVpnGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCarrierGateway = "DeleteCarrierGateway"

// DeleteCarrierGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCarrierGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCarrierGateway for more information on using the DeleteCarrierGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCarrierGatewayRequest method.
//	req, resp := client.DeleteCarrierGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway
func (c *EC2) DeleteCarrierGatewayRequest(input *DeleteCarrierGatewayInput) (req *request.Request, output *DeleteCarrierGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteCarrierGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCarrierGatewayInput{}
	}

	output = &DeleteCarrierGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCarrierGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes a carrier gateway.
//
// If you do not delete the route that contains the carrier gateway as the Target,
// the route is a blackhole route. For information about how to delete a route,
// see DeleteRoute (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteCarrierGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGateway
func (c *EC2) DeleteCarrierGateway(input *DeleteCarrierGatewayInput) (*DeleteCarrierGatewayOutput, error) {
	req, out := c.DeleteCarrierGatewayRequest(input)
	return out, req.Send()
}

// DeleteCarrierGatewayWithContext is the same as DeleteCarrierGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCarrierGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteCarrierGatewayWithContext(ctx aws.Context, input *DeleteCarrierGatewayInput, opts ...request.Option) (*DeleteCarrierGatewayOutput, error) {
	req, out := c.DeleteCarrierGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClientVpnEndpoint = "DeleteClientVpnEndpoint"

// DeleteClientVpnEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClientVpnEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClientVpnEndpoint for more information on using the DeleteClientVpnEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClientVpnEndpointRequest method.
//	req, resp := client.DeleteClientVpnEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint
func (c *EC2) DeleteClientVpnEndpointRequest(input *DeleteClientVpnEndpointInput) (req *request.Request, output *DeleteClientVpnEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteClientVpnEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClientVpnEndpointInput{}
	}

	output = &DeleteClientVpnEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClientVpnEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Client VPN endpoint. You must disassociate all target
// networks before you can delete a Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteClientVpnEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpoint
func (c *EC2) DeleteClientVpnEndpoint(input *DeleteClientVpnEndpointInput) (*DeleteClientVpnEndpointOutput, error) {
	req, out := c.DeleteClientVpnEndpointRequest(input)
	return out, req.Send()
}

// DeleteClientVpnEndpointWithContext is the same as DeleteClientVpnEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClientVpnEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteClientVpnEndpointWithContext(ctx aws.Context, input *DeleteClientVpnEndpointInput, opts ...request.Option) (*DeleteClientVpnEndpointOutput, error) {
	req, out := c.DeleteClientVpnEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClientVpnRoute = "DeleteClientVpnRoute"

// DeleteClientVpnRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClientVpnRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClientVpnRoute for more information on using the DeleteClientVpnRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClientVpnRouteRequest method.
//	req, resp := client.DeleteClientVpnRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute
func (c *EC2) DeleteClientVpnRouteRequest(input *DeleteClientVpnRouteInput) (req *request.Request, output *DeleteClientVpnRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteClientVpnRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClientVpnRouteInput{}
	}

	output = &DeleteClientVpnRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClientVpnRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes a route from a Client VPN endpoint. You can only delete routes that
// you manually added using the CreateClientVpnRoute action. You cannot delete
// routes that were automatically added when associating a subnet. To remove
// routes that have been automatically added, disassociate the target subnet
// from the Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteClientVpnRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRoute
func (c *EC2) DeleteClientVpnRoute(input *DeleteClientVpnRouteInput) (*DeleteClientVpnRouteOutput, error) {
	req, out := c.DeleteClientVpnRouteRequest(input)
	return out, req.Send()
}

// DeleteClientVpnRouteWithContext is the same as DeleteClientVpnRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClientVpnRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteClientVpnRouteWithContext(ctx aws.Context, input *DeleteClientVpnRouteInput, opts ...request.Option) (*DeleteClientVpnRouteOutput, error) {
	req, out := c.DeleteClientVpnRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCoipCidr = "DeleteCoipCidr"

// DeleteCoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCoipCidr for more information on using the DeleteCoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCoipCidrRequest method.
//	req, resp := client.DeleteCoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr
func (c *EC2) DeleteCoipCidrRequest(input *DeleteCoipCidrInput) (req *request.Request, output *DeleteCoipCidrOutput) {
	op := &request.Operation{
		Name:       opDeleteCoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCoipCidrInput{}
	}

	output = &DeleteCoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCoipCidr API operation for Amazon Elastic Compute Cloud.
//
// Deletes a range of customer-owned IP addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteCoipCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipCidr
func (c *EC2) DeleteCoipCidr(input *DeleteCoipCidrInput) (*DeleteCoipCidrOutput, error) {
	req, out := c.DeleteCoipCidrRequest(input)
	return out, req.Send()
}

// DeleteCoipCidrWithContext is the same as DeleteCoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteCoipCidrWithContext(ctx aws.Context, input *DeleteCoipCidrInput, opts ...request.Option) (*DeleteCoipCidrOutput, error) {
	req, out := c.DeleteCoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCoipPool = "DeleteCoipPool"

// DeleteCoipPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCoipPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCoipPool for more information on using the DeleteCoipPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCoipPoolRequest method.
//	req, resp := client.DeleteCoipPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool
func (c *EC2) DeleteCoipPoolRequest(input *DeleteCoipPoolInput) (req *request.Request, output *DeleteCoipPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteCoipPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCoipPoolInput{}
	}

	output = &DeleteCoipPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCoipPool API operation for Amazon Elastic Compute Cloud.
//
// Deletes a pool of customer-owned IP (CoIP) addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteCoipPool for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCoipPool
func (c *EC2) DeleteCoipPool(input *DeleteCoipPoolInput) (*DeleteCoipPoolOutput, error) {
	req, out := c.DeleteCoipPoolRequest(input)
	return out, req.Send()
}

// DeleteCoipPoolWithContext is the same as DeleteCoipPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCoipPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteCoipPoolWithContext(ctx aws.Context, input *DeleteCoipPoolInput, opts ...request.Option) (*DeleteCoipPoolOutput, error) {
	req, out := c.DeleteCoipPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomerGateway = "DeleteCustomerGateway"

// DeleteCustomerGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomerGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomerGateway for more information on using the DeleteCustomerGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomerGatewayRequest method.
//	req, resp := client.DeleteCustomerGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway
func (c *EC2) DeleteCustomerGatewayRequest(input *DeleteCustomerGatewayInput) (req *request.Request, output *DeleteCustomerGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomerGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomerGatewayInput{}
	}

	output = &DeleteCustomerGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomerGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified customer gateway. You must delete the VPN connection
// before you can delete the customer gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteCustomerGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGateway
func (c *EC2) DeleteCustomerGateway(input *DeleteCustomerGatewayInput) (*DeleteCustomerGatewayOutput, error) {
	req, out := c.DeleteCustomerGatewayRequest(input)
	return out, req.Send()
}

// DeleteCustomerGatewayWithContext is the same as DeleteCustomerGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomerGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteCustomerGatewayWithContext(ctx aws.Context, input *DeleteCustomerGatewayInput, opts ...request.Option) (*DeleteCustomerGatewayOutput, error) {
	req, out := c.DeleteCustomerGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDhcpOptions = "DeleteDhcpOptions"

// DeleteDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDhcpOptions for more information on using the DeleteDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDhcpOptionsRequest method.
//	req, resp := client.DeleteDhcpOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions
func (c *EC2) DeleteDhcpOptionsRequest(input *DeleteDhcpOptionsInput) (req *request.Request, output *DeleteDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDeleteDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDhcpOptionsInput{}
	}

	output = &DeleteDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified set of DHCP options. You must disassociate the set
// of DHCP options before you can delete it. You can disassociate the set of
// DHCP options by associating either a new set of options or the default set
// of options with the VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptions
func (c *EC2) DeleteDhcpOptions(input *DeleteDhcpOptionsInput) (*DeleteDhcpOptionsOutput, error) {
	req, out := c.DeleteDhcpOptionsRequest(input)
	return out, req.Send()
}

// DeleteDhcpOptionsWithContext is the same as DeleteDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteDhcpOptionsWithContext(ctx aws.Context, input *DeleteDhcpOptionsInput, opts ...request.Option) (*DeleteDhcpOptionsOutput, error) {
	req, out := c.DeleteDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEgressOnlyInternetGateway = "DeleteEgressOnlyInternetGateway"

// DeleteEgressOnlyInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEgressOnlyInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEgressOnlyInternetGateway for more information on using the DeleteEgressOnlyInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEgressOnlyInternetGatewayRequest method.
//	req, resp := client.DeleteEgressOnlyInternetGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway
func (c *EC2) DeleteEgressOnlyInternetGatewayRequest(input *DeleteEgressOnlyInternetGatewayInput) (req *request.Request, output *DeleteEgressOnlyInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteEgressOnlyInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEgressOnlyInternetGatewayInput{}
	}

	output = &DeleteEgressOnlyInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEgressOnlyInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes an egress-only internet gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteEgressOnlyInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGateway
func (c *EC2) DeleteEgressOnlyInternetGateway(input *DeleteEgressOnlyInternetGatewayInput) (*DeleteEgressOnlyInternetGatewayOutput, error) {
	req, out := c.DeleteEgressOnlyInternetGatewayRequest(input)
	return out, req.Send()
}

// DeleteEgressOnlyInternetGatewayWithContext is the same as DeleteEgressOnlyInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEgressOnlyInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteEgressOnlyInternetGatewayWithContext(ctx aws.Context, input *DeleteEgressOnlyInternetGatewayInput, opts ...request.Option) (*DeleteEgressOnlyInternetGatewayOutput, error) {
	req, out := c.DeleteEgressOnlyInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleets = "DeleteFleets"

// DeleteFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleets for more information on using the DeleteFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFleetsRequest method.
//	req, resp := client.DeleteFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets
func (c *EC2) DeleteFleetsRequest(input *DeleteFleetsInput) (req *request.Request, output *DeleteFleetsOutput) {
	op := &request.Operation{
		Name:       opDeleteFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetsInput{}
	}

	output = &DeleteFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFleets API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified EC2 Fleets.
//
// After you delete an EC2 Fleet, it launches no new instances.
//
// You must also specify whether a deleted EC2 Fleet should terminate its instances.
// If you choose to terminate the instances, the EC2 Fleet enters the deleted_terminating
// state. Otherwise, the EC2 Fleet enters the deleted_running state, and the
// instances continue to run until they are interrupted or you terminate them
// manually.
//
// For instant fleets, EC2 Fleet must terminate the instances when the fleet
// is deleted. Up to 1000 instances can be terminated in a single request to
// delete instant fleets. A deleted instant fleet with running instances is
// not supported.
//
// Restrictions
//
//   - You can delete up to 25 fleets of type instant in a single request.
//
//   - You can delete up to 100 fleets of type maintain or request in a single
//     request.
//
//   - You can delete up to 125 fleets in a single request, provided you do
//     not exceed the quota for each fleet type, as specified above.
//
//   - If you exceed the specified number of fleets to delete, no fleets are
//     deleted.
//
// For more information, see Delete an EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleets
func (c *EC2) DeleteFleets(input *DeleteFleetsInput) (*DeleteFleetsOutput, error) {
	req, out := c.DeleteFleetsRequest(input)
	return out, req.Send()
}

// DeleteFleetsWithContext is the same as DeleteFleets with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteFleetsWithContext(ctx aws.Context, input *DeleteFleetsInput, opts ...request.Option) (*DeleteFleetsOutput, error) {
	req, out := c.DeleteFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlowLogs = "DeleteFlowLogs"

// DeleteFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlowLogs for more information on using the DeleteFlowLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFlowLogsRequest method.
//	req, resp := client.DeleteFlowLogsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs
func (c *EC2) DeleteFlowLogsRequest(input *DeleteFlowLogsInput) (req *request.Request, output *DeleteFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowLogsInput{}
	}

	output = &DeleteFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more flow logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteFlowLogs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogs
func (c *EC2) DeleteFlowLogs(input *DeleteFlowLogsInput) (*DeleteFlowLogsOutput, error) {
	req, out := c.DeleteFlowLogsRequest(input)
	return out, req.Send()
}

// DeleteFlowLogsWithContext is the same as DeleteFlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteFlowLogsWithContext(ctx aws.Context, input *DeleteFlowLogsInput, opts ...request.Option) (*DeleteFlowLogsOutput, error) {
	req, out := c.DeleteFlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFpgaImage = "DeleteFpgaImage"

// DeleteFpgaImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFpgaImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFpgaImage for more information on using the DeleteFpgaImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFpgaImageRequest method.
//	req, resp := client.DeleteFpgaImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage
func (c *EC2) DeleteFpgaImageRequest(input *DeleteFpgaImageInput) (req *request.Request, output *DeleteFpgaImageOutput) {
	op := &request.Operation{
		Name:       opDeleteFpgaImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFpgaImageInput{}
	}

	output = &DeleteFpgaImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFpgaImage API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Amazon FPGA Image (AFI).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteFpgaImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImage
func (c *EC2) DeleteFpgaImage(input *DeleteFpgaImageInput) (*DeleteFpgaImageOutput, error) {
	req, out := c.DeleteFpgaImageRequest(input)
	return out, req.Send()
}

// DeleteFpgaImageWithContext is the same as DeleteFpgaImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFpgaImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteFpgaImageWithContext(ctx aws.Context, input *DeleteFpgaImageInput, opts ...request.Option) (*DeleteFpgaImageOutput, error) {
	req, out := c.DeleteFpgaImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceConnectEndpoint = "DeleteInstanceConnectEndpoint"

// DeleteInstanceConnectEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceConnectEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceConnectEndpoint for more information on using the DeleteInstanceConnectEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceConnectEndpointRequest method.
//	req, resp := client.DeleteInstanceConnectEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint
func (c *EC2) DeleteInstanceConnectEndpointRequest(input *DeleteInstanceConnectEndpointInput) (req *request.Request, output *DeleteInstanceConnectEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceConnectEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceConnectEndpointInput{}
	}

	output = &DeleteInstanceConnectEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstanceConnectEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified EC2 Instance Connect Endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteInstanceConnectEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceConnectEndpoint
func (c *EC2) DeleteInstanceConnectEndpoint(input *DeleteInstanceConnectEndpointInput) (*DeleteInstanceConnectEndpointOutput, error) {
	req, out := c.DeleteInstanceConnectEndpointRequest(input)
	return out, req.Send()
}

// DeleteInstanceConnectEndpointWithContext is the same as DeleteInstanceConnectEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceConnectEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteInstanceConnectEndpointWithContext(ctx aws.Context, input *DeleteInstanceConnectEndpointInput, opts ...request.Option) (*DeleteInstanceConnectEndpointOutput, error) {
	req, out := c.DeleteInstanceConnectEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceEventWindow = "DeleteInstanceEventWindow"

// DeleteInstanceEventWindowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceEventWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceEventWindow for more information on using the DeleteInstanceEventWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceEventWindowRequest method.
//	req, resp := client.DeleteInstanceEventWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow
func (c *EC2) DeleteInstanceEventWindowRequest(input *DeleteInstanceEventWindowInput) (req *request.Request, output *DeleteInstanceEventWindowOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceEventWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceEventWindowInput{}
	}

	output = &DeleteInstanceEventWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstanceEventWindow API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified event window.
//
// For more information, see Define event windows for scheduled events (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteInstanceEventWindow for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInstanceEventWindow
func (c *EC2) DeleteInstanceEventWindow(input *DeleteInstanceEventWindowInput) (*DeleteInstanceEventWindowOutput, error) {
	req, out := c.DeleteInstanceEventWindowRequest(input)
	return out, req.Send()
}

// DeleteInstanceEventWindowWithContext is the same as DeleteInstanceEventWindow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceEventWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteInstanceEventWindowWithContext(ctx aws.Context, input *DeleteInstanceEventWindowInput, opts ...request.Option) (*DeleteInstanceEventWindowOutput, error) {
	req, out := c.DeleteInstanceEventWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInternetGateway = "DeleteInternetGateway"

// DeleteInternetGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInternetGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInternetGateway for more information on using the DeleteInternetGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInternetGatewayRequest method.
//	req, resp := client.DeleteInternetGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway
func (c *EC2) DeleteInternetGatewayRequest(input *DeleteInternetGatewayInput) (req *request.Request, output *DeleteInternetGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteInternetGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInternetGatewayInput{}
	}

	output = &DeleteInternetGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInternetGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified internet gateway. You must detach the internet gateway
// from the VPC before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteInternetGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGateway
func (c *EC2) DeleteInternetGateway(input *DeleteInternetGatewayInput) (*DeleteInternetGatewayOutput, error) {
	req, out := c.DeleteInternetGatewayRequest(input)
	return out, req.Send()
}

// DeleteInternetGatewayWithContext is the same as DeleteInternetGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInternetGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteInternetGatewayWithContext(ctx aws.Context, input *DeleteInternetGatewayInput, opts ...request.Option) (*DeleteInternetGatewayOutput, error) {
	req, out := c.DeleteInternetGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpam = "DeleteIpam"

// DeleteIpamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpam operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpam for more information on using the DeleteIpam
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIpamRequest method.
//	req, resp := client.DeleteIpamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam
func (c *EC2) DeleteIpamRequest(input *DeleteIpamInput) (req *request.Request, output *DeleteIpamOutput) {
	op := &request.Operation{
		Name:       opDeleteIpam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpamInput{}
	}

	output = &DeleteIpamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIpam API operation for Amazon Elastic Compute Cloud.
//
// Delete an IPAM. Deleting an IPAM removes all monitored data associated with
// the IPAM including the historical data for CIDRs.
//
// For more information, see Delete an IPAM (https://docs.aws.amazon.com/vpc/latest/ipam/delete-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteIpam for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpam
func (c *EC2) DeleteIpam(input *DeleteIpamInput) (*DeleteIpamOutput, error) {
	req, out := c.DeleteIpamRequest(input)
	return out, req.Send()
}

// DeleteIpamWithContext is the same as DeleteIpam with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpam for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteIpamWithContext(ctx aws.Context, input *DeleteIpamInput, opts ...request.Option) (*DeleteIpamOutput, error) {
	req, out := c.DeleteIpamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpamPool = "DeleteIpamPool"

// DeleteIpamPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpamPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpamPool for more information on using the DeleteIpamPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIpamPoolRequest method.
//	req, resp := client.DeleteIpamPoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool
func (c *EC2) DeleteIpamPoolRequest(input *DeleteIpamPoolInput) (req *request.Request, output *DeleteIpamPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteIpamPool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpamPoolInput{}
	}

	output = &DeleteIpamPoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIpamPool API operation for Amazon Elastic Compute Cloud.
//
// Delete an IPAM pool.
//
// You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned
// to it. To release allocations, see ReleaseIpamPoolAllocation (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html).
// To deprovision pool CIDRs, see DeprovisionIpamPoolCidr (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html).
//
// For more information, see Delete a pool (https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteIpamPool for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamPool
func (c *EC2) DeleteIpamPool(input *DeleteIpamPoolInput) (*DeleteIpamPoolOutput, error) {
	req, out := c.DeleteIpamPoolRequest(input)
	return out, req.Send()
}

// DeleteIpamPoolWithContext is the same as DeleteIpamPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpamPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteIpamPoolWithContext(ctx aws.Context, input *DeleteIpamPoolInput, opts ...request.Option) (*DeleteIpamPoolOutput, error) {
	req, out := c.DeleteIpamPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpamResourceDiscovery = "DeleteIpamResourceDiscovery"

// DeleteIpamResourceDiscoveryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpamResourceDiscovery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpamResourceDiscovery for more information on using the DeleteIpamResourceDiscovery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIpamResourceDiscoveryRequest method.
//	req, resp := client.DeleteIpamResourceDiscoveryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery
func (c *EC2) DeleteIpamResourceDiscoveryRequest(input *DeleteIpamResourceDiscoveryInput) (req *request.Request, output *DeleteIpamResourceDiscoveryOutput) {
	op := &request.Operation{
		Name:       opDeleteIpamResourceDiscovery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpamResourceDiscoveryInput{}
	}

	output = &DeleteIpamResourceDiscoveryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIpamResourceDiscovery API operation for Amazon Elastic Compute Cloud.
//
// Deletes an IPAM resource discovery. A resource discovery is an IPAM component
// that enables IPAM to manage and monitor resources that belong to the owning
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteIpamResourceDiscovery for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamResourceDiscovery
func (c *EC2) DeleteIpamResourceDiscovery(input *DeleteIpamResourceDiscoveryInput) (*DeleteIpamResourceDiscoveryOutput, error) {
	req, out := c.DeleteIpamResourceDiscoveryRequest(input)
	return out, req.Send()
}

// DeleteIpamResourceDiscoveryWithContext is the same as DeleteIpamResourceDiscovery with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpamResourceDiscovery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteIpamResourceDiscoveryWithContext(ctx aws.Context, input *DeleteIpamResourceDiscoveryInput, opts ...request.Option) (*DeleteIpamResourceDiscoveryOutput, error) {
	req, out := c.DeleteIpamResourceDiscoveryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpamScope = "DeleteIpamScope"

// DeleteIpamScopeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpamScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpamScope for more information on using the DeleteIpamScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIpamScopeRequest method.
//	req, resp := client.DeleteIpamScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope
func (c *EC2) DeleteIpamScopeRequest(input *DeleteIpamScopeInput) (req *request.Request, output *DeleteIpamScopeOutput) {
	op := &request.Operation{
		Name:       opDeleteIpamScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpamScopeInput{}
	}

	output = &DeleteIpamScopeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIpamScope API operation for Amazon Elastic Compute Cloud.
//
// Delete the scope for an IPAM. You cannot delete the default scopes.
//
// For more information, see Delete a scope (https://docs.aws.amazon.com/vpc/latest/ipam/delete-scope-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteIpamScope for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteIpamScope
func (c *EC2) DeleteIpamScope(input *DeleteIpamScopeInput) (*DeleteIpamScopeOutput, error) {
	req, out := c.DeleteIpamScopeRequest(input)
	return out, req.Send()
}

// DeleteIpamScopeWithContext is the same as DeleteIpamScope with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpamScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteIpamScopeWithContext(ctx aws.Context, input *DeleteIpamScopeInput, opts ...request.Option) (*DeleteIpamScopeOutput, error) {
	req, out := c.DeleteIpamScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyPair for more information on using the DeleteKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKeyPairRequest method.
//	req, resp := client.DeleteKeyPairRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair
func (c *EC2) DeleteKeyPairRequest(input *DeleteKeyPairInput) (req *request.Request, output *DeleteKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	output = &DeleteKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKeyPair API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified key pair, by removing the public key from Amazon EC2.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteKeyPair for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPair
func (c *EC2) DeleteKeyPair(input *DeleteKeyPairInput) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	return out, req.Send()
}

// DeleteKeyPairWithContext is the same as DeleteKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteKeyPairWithContext(ctx aws.Context, input *DeleteKeyPairInput, opts ...request.Option) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchTemplate = "DeleteLaunchTemplate"

// DeleteLaunchTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchTemplate for more information on using the DeleteLaunchTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLaunchTemplateRequest method.
//	req, resp := client.DeleteLaunchTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate
func (c *EC2) DeleteLaunchTemplateRequest(input *DeleteLaunchTemplateInput) (req *request.Request, output *DeleteLaunchTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchTemplateInput{}
	}

	output = &DeleteLaunchTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLaunchTemplate API operation for Amazon Elastic Compute Cloud.
//
// Deletes a launch template. Deleting a launch template deletes all of its
// versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLaunchTemplate for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplate
func (c *EC2) DeleteLaunchTemplate(input *DeleteLaunchTemplateInput) (*DeleteLaunchTemplateOutput, error) {
	req, out := c.DeleteLaunchTemplateRequest(input)
	return out, req.Send()
}

// DeleteLaunchTemplateWithContext is the same as DeleteLaunchTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLaunchTemplateWithContext(ctx aws.Context, input *DeleteLaunchTemplateInput, opts ...request.Option) (*DeleteLaunchTemplateOutput, error) {
	req, out := c.DeleteLaunchTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLaunchTemplateVersions = "DeleteLaunchTemplateVersions"

// DeleteLaunchTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLaunchTemplateVersions for more information on using the DeleteLaunchTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLaunchTemplateVersionsRequest method.
//	req, resp := client.DeleteLaunchTemplateVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions
func (c *EC2) DeleteLaunchTemplateVersionsRequest(input *DeleteLaunchTemplateVersionsInput) (req *request.Request, output *DeleteLaunchTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchTemplateVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchTemplateVersionsInput{}
	}

	output = &DeleteLaunchTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLaunchTemplateVersions API operation for Amazon Elastic Compute Cloud.
//
// Deletes one or more versions of a launch template.
//
// You can't delete the default version of a launch template; you must first
// assign a different version as the default. If the default version is the
// only version for the launch template, you must delete the entire launch template
// using DeleteLaunchTemplate.
//
// You can delete up to 200 launch template versions in a single request. To
// delete more than 200 versions in a single request, use DeleteLaunchTemplate,
// which deletes the launch template and all of its versions.
//
// For more information, see Delete a launch template version (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html#delete-launch-template-version)
// in the EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLaunchTemplateVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersions
func (c *EC2) DeleteLaunchTemplateVersions(input *DeleteLaunchTemplateVersionsInput) (*DeleteLaunchTemplateVersionsOutput, error) {
	req, out := c.DeleteLaunchTemplateVersionsRequest(input)
	return out, req.Send()
}

// DeleteLaunchTemplateVersionsWithContext is the same as DeleteLaunchTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLaunchTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLaunchTemplateVersionsWithContext(ctx aws.Context, input *DeleteLaunchTemplateVersionsInput, opts ...request.Option) (*DeleteLaunchTemplateVersionsOutput, error) {
	req, out := c.DeleteLaunchTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocalGatewayRoute = "DeleteLocalGatewayRoute"

// DeleteLocalGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocalGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocalGatewayRoute for more information on using the DeleteLocalGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLocalGatewayRouteRequest method.
//	req, resp := client.DeleteLocalGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute
func (c *EC2) DeleteLocalGatewayRouteRequest(input *DeleteLocalGatewayRouteInput) (req *request.Request, output *DeleteLocalGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteLocalGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocalGatewayRouteInput{}
	}

	output = &DeleteLocalGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLocalGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLocalGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRoute
func (c *EC2) DeleteLocalGatewayRoute(input *DeleteLocalGatewayRouteInput) (*DeleteLocalGatewayRouteOutput, error) {
	req, out := c.DeleteLocalGatewayRouteRequest(input)
	return out, req.Send()
}

// DeleteLocalGatewayRouteWithContext is the same as DeleteLocalGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocalGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLocalGatewayRouteWithContext(ctx aws.Context, input *DeleteLocalGatewayRouteInput, opts ...request.Option) (*DeleteLocalGatewayRouteOutput, error) {
	req, out := c.DeleteLocalGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocalGatewayRouteTable = "DeleteLocalGatewayRouteTable"

// DeleteLocalGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocalGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocalGatewayRouteTable for more information on using the DeleteLocalGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLocalGatewayRouteTableRequest method.
//	req, resp := client.DeleteLocalGatewayRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable
func (c *EC2) DeleteLocalGatewayRouteTableRequest(input *DeleteLocalGatewayRouteTableInput) (req *request.Request, output *DeleteLocalGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteLocalGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocalGatewayRouteTableInput{}
	}

	output = &DeleteLocalGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLocalGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Deletes a local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLocalGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTable
func (c *EC2) DeleteLocalGatewayRouteTable(input *DeleteLocalGatewayRouteTableInput) (*DeleteLocalGatewayRouteTableOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableRequest(input)
	return out, req.Send()
}

// DeleteLocalGatewayRouteTableWithContext is the same as DeleteLocalGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocalGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLocalGatewayRouteTableWithContext(ctx aws.Context, input *DeleteLocalGatewayRouteTableInput, opts ...request.Option) (*DeleteLocalGatewayRouteTableOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation = "DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation"

// DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation for more information on using the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest method.
//	req, resp := client.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
func (c *EC2) DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input *DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput) (req *request.Request, output *DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput{}
	}

	output = &DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation API operation for Amazon Elastic Compute Cloud.
//
// Deletes a local gateway route table virtual interface group association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation
func (c *EC2) DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation(input *DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput) (*DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input)
	return out, req.Send()
}

// DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationWithContext is the same as DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationWithContext(ctx aws.Context, input *DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationInput, opts ...request.Option) (*DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocalGatewayRouteTableVpcAssociation = "DeleteLocalGatewayRouteTableVpcAssociation"

// DeleteLocalGatewayRouteTableVpcAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocalGatewayRouteTableVpcAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocalGatewayRouteTableVpcAssociation for more information on using the DeleteLocalGatewayRouteTableVpcAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLocalGatewayRouteTableVpcAssociationRequest method.
//	req, resp := client.DeleteLocalGatewayRouteTableVpcAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation
func (c *EC2) DeleteLocalGatewayRouteTableVpcAssociationRequest(input *DeleteLocalGatewayRouteTableVpcAssociationInput) (req *request.Request, output *DeleteLocalGatewayRouteTableVpcAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteLocalGatewayRouteTableVpcAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocalGatewayRouteTableVpcAssociationInput{}
	}

	output = &DeleteLocalGatewayRouteTableVpcAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLocalGatewayRouteTableVpcAssociation API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified association between a VPC and local gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteLocalGatewayRouteTableVpcAssociation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociation
func (c *EC2) DeleteLocalGatewayRouteTableVpcAssociation(input *DeleteLocalGatewayRouteTableVpcAssociationInput) (*DeleteLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableVpcAssociationRequest(input)
	return out, req.Send()
}

// DeleteLocalGatewayRouteTableVpcAssociationWithContext is the same as DeleteLocalGatewayRouteTableVpcAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocalGatewayRouteTableVpcAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteLocalGatewayRouteTableVpcAssociationWithContext(ctx aws.Context, input *DeleteLocalGatewayRouteTableVpcAssociationInput, opts ...request.Option) (*DeleteLocalGatewayRouteTableVpcAssociationOutput, error) {
	req, out := c.DeleteLocalGatewayRouteTableVpcAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteManagedPrefixList = "DeleteManagedPrefixList"

// DeleteManagedPrefixListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteManagedPrefixList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteManagedPrefixList for more information on using the DeleteManagedPrefixList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteManagedPrefixListRequest method.
//	req, resp := client.DeleteManagedPrefixListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList
func (c *EC2) DeleteManagedPrefixListRequest(input *DeleteManagedPrefixListInput) (req *request.Request, output *DeleteManagedPrefixListOutput) {
	op := &request.Operation{
		Name:       opDeleteManagedPrefixList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteManagedPrefixListInput{}
	}

	output = &DeleteManagedPrefixListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteManagedPrefixList API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified managed prefix list. You must first remove all references
// to the prefix list in your resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteManagedPrefixList for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixList
func (c *EC2) DeleteManagedPrefixList(input *DeleteManagedPrefixListInput) (*DeleteManagedPrefixListOutput, error) {
	req, out := c.DeleteManagedPrefixListRequest(input)
	return out, req.Send()
}

// DeleteManagedPrefixListWithContext is the same as DeleteManagedPrefixList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteManagedPrefixList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteManagedPrefixListWithContext(ctx aws.Context, input *DeleteManagedPrefixListInput, opts ...request.Option) (*DeleteManagedPrefixListOutput, error) {
	req, out := c.DeleteManagedPrefixListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNatGateway = "DeleteNatGateway"

// DeleteNatGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNatGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNatGateway for more information on using the DeleteNatGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNatGatewayRequest method.
//	req, resp := client.DeleteNatGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway
func (c *EC2) DeleteNatGatewayRequest(input *DeleteNatGatewayInput) (req *request.Request, output *DeleteNatGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteNatGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNatGatewayInput{}
	}

	output = &DeleteNatGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNatGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates
// its Elastic IP address, but does not release the address from your account.
// Deleting a NAT gateway does not delete any NAT gateway routes in your route
// tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNatGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGateway
func (c *EC2) DeleteNatGateway(input *DeleteNatGatewayInput) (*DeleteNatGatewayOutput, error) {
	req, out := c.DeleteNatGatewayRequest(input)
	return out, req.Send()
}

// DeleteNatGatewayWithContext is the same as DeleteNatGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNatGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNatGatewayWithContext(ctx aws.Context, input *DeleteNatGatewayInput, opts ...request.Option) (*DeleteNatGatewayOutput, error) {
	req, out := c.DeleteNatGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkAcl = "DeleteNetworkAcl"

// DeleteNetworkAclRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkAcl for more information on using the DeleteNetworkAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkAclRequest method.
//	req, resp := client.DeleteNetworkAclRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl
func (c *EC2) DeleteNetworkAclRequest(input *DeleteNetworkAclInput) (req *request.Request, output *DeleteNetworkAclOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAcl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclInput{}
	}

	output = &DeleteNetworkAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkAcl API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network ACL. You can't delete the ACL if it's associated
// with any subnets. You can't delete the default network ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAcl
func (c *EC2) DeleteNetworkAcl(input *DeleteNetworkAclInput) (*DeleteNetworkAclOutput, error) {
	req, out := c.DeleteNetworkAclRequest(input)
	return out, req.Send()
}

// DeleteNetworkAclWithContext is the same as DeleteNetworkAcl with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkAclWithContext(ctx aws.Context, input *DeleteNetworkAclInput, opts ...request.Option) (*DeleteNetworkAclOutput, error) {
	req, out := c.DeleteNetworkAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkAclEntry = "DeleteNetworkAclEntry"

// DeleteNetworkAclEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkAclEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkAclEntry for more information on using the DeleteNetworkAclEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkAclEntryRequest method.
//	req, resp := client.DeleteNetworkAclEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry
func (c *EC2) DeleteNetworkAclEntryRequest(input *DeleteNetworkAclEntryInput) (req *request.Request, output *DeleteNetworkAclEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkAclEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkAclEntryInput{}
	}

	output = &DeleteNetworkAclEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkAclEntry API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified ingress or egress entry (rule) from the specified network
// ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkAclEntry for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntry
func (c *EC2) DeleteNetworkAclEntry(input *DeleteNetworkAclEntryInput) (*DeleteNetworkAclEntryOutput, error) {
	req, out := c.DeleteNetworkAclEntryRequest(input)
	return out, req.Send()
}

// DeleteNetworkAclEntryWithContext is the same as DeleteNetworkAclEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkAclEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkAclEntryWithContext(ctx aws.Context, input *DeleteNetworkAclEntryInput, opts ...request.Option) (*DeleteNetworkAclEntryOutput, error) {
	req, out := c.DeleteNetworkAclEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInsightsAccessScope = "DeleteNetworkInsightsAccessScope"

// DeleteNetworkInsightsAccessScopeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInsightsAccessScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInsightsAccessScope for more information on using the DeleteNetworkInsightsAccessScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkInsightsAccessScopeRequest method.
//	req, resp := client.DeleteNetworkInsightsAccessScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope
func (c *EC2) DeleteNetworkInsightsAccessScopeRequest(input *DeleteNetworkInsightsAccessScopeInput) (req *request.Request, output *DeleteNetworkInsightsAccessScopeOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInsightsAccessScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInsightsAccessScopeInput{}
	}

	output = &DeleteNetworkInsightsAccessScopeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInsightsAccessScope API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Network Access Scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInsightsAccessScope for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScope
func (c *EC2) DeleteNetworkInsightsAccessScope(input *DeleteNetworkInsightsAccessScopeInput) (*DeleteNetworkInsightsAccessScopeOutput, error) {
	req, out := c.DeleteNetworkInsightsAccessScopeRequest(input)
	return out, req.Send()
}

// DeleteNetworkInsightsAccessScopeWithContext is the same as DeleteNetworkInsightsAccessScope with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInsightsAccessScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInsightsAccessScopeWithContext(ctx aws.Context, input *DeleteNetworkInsightsAccessScopeInput, opts ...request.Option) (*DeleteNetworkInsightsAccessScopeOutput, error) {
	req, out := c.DeleteNetworkInsightsAccessScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInsightsAccessScopeAnalysis = "DeleteNetworkInsightsAccessScopeAnalysis"

// DeleteNetworkInsightsAccessScopeAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInsightsAccessScopeAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInsightsAccessScopeAnalysis for more information on using the DeleteNetworkInsightsAccessScopeAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkInsightsAccessScopeAnalysisRequest method.
//	req, resp := client.DeleteNetworkInsightsAccessScopeAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis
func (c *EC2) DeleteNetworkInsightsAccessScopeAnalysisRequest(input *DeleteNetworkInsightsAccessScopeAnalysisInput) (req *request.Request, output *DeleteNetworkInsightsAccessScopeAnalysisOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInsightsAccessScopeAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInsightsAccessScopeAnalysisInput{}
	}

	output = &DeleteNetworkInsightsAccessScopeAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInsightsAccessScopeAnalysis API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Network Access Scope analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInsightsAccessScopeAnalysis for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAccessScopeAnalysis
func (c *EC2) DeleteNetworkInsightsAccessScopeAnalysis(input *DeleteNetworkInsightsAccessScopeAnalysisInput) (*DeleteNetworkInsightsAccessScopeAnalysisOutput, error) {
	req, out := c.DeleteNetworkInsightsAccessScopeAnalysisRequest(input)
	return out, req.Send()
}

// DeleteNetworkInsightsAccessScopeAnalysisWithContext is the same as DeleteNetworkInsightsAccessScopeAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInsightsAccessScopeAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInsightsAccessScopeAnalysisWithContext(ctx aws.Context, input *DeleteNetworkInsightsAccessScopeAnalysisInput, opts ...request.Option) (*DeleteNetworkInsightsAccessScopeAnalysisOutput, error) {
	req, out := c.DeleteNetworkInsightsAccessScopeAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInsightsAnalysis = "DeleteNetworkInsightsAnalysis"

// DeleteNetworkInsightsAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInsightsAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInsightsAnalysis for more information on using the DeleteNetworkInsightsAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkInsightsAnalysisRequest method.
//	req, resp := client.DeleteNetworkInsightsAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis
func (c *EC2) DeleteNetworkInsightsAnalysisRequest(input *DeleteNetworkInsightsAnalysisInput) (req *request.Request, output *DeleteNetworkInsightsAnalysisOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInsightsAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInsightsAnalysisInput{}
	}

	output = &DeleteNetworkInsightsAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInsightsAnalysis API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network insights analysis.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInsightsAnalysis for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysis
func (c *EC2) DeleteNetworkInsightsAnalysis(input *DeleteNetworkInsightsAnalysisInput) (*DeleteNetworkInsightsAnalysisOutput, error) {
	req, out := c.DeleteNetworkInsightsAnalysisRequest(input)
	return out, req.Send()
}

// DeleteNetworkInsightsAnalysisWithContext is the same as DeleteNetworkInsightsAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInsightsAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInsightsAnalysisWithContext(ctx aws.Context, input *DeleteNetworkInsightsAnalysisInput, opts ...request.Option) (*DeleteNetworkInsightsAnalysisOutput, error) {
	req, out := c.DeleteNetworkInsightsAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInsightsPath = "DeleteNetworkInsightsPath"

// DeleteNetworkInsightsPathRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInsightsPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInsightsPath for more information on using the DeleteNetworkInsightsPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkInsightsPathRequest method.
//	req, resp := client.DeleteNetworkInsightsPathRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath
func (c *EC2) DeleteNetworkInsightsPathRequest(input *DeleteNetworkInsightsPathInput) (req *request.Request, output *DeleteNetworkInsightsPathOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInsightsPath,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInsightsPathInput{}
	}

	output = &DeleteNetworkInsightsPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInsightsPath API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified path.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInsightsPath for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPath
func (c *EC2) DeleteNetworkInsightsPath(input *DeleteNetworkInsightsPathInput) (*DeleteNetworkInsightsPathOutput, error) {
	req, out := c.DeleteNetworkInsightsPathRequest(input)
	return out, req.Send()
}

// DeleteNetworkInsightsPathWithContext is the same as DeleteNetworkInsightsPath with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInsightsPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInsightsPathWithContext(ctx aws.Context, input *DeleteNetworkInsightsPathInput, opts ...request.Option) (*DeleteNetworkInsightsPathOutput, error) {
	req, out := c.DeleteNetworkInsightsPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInterface = "DeleteNetworkInterface"

// DeleteNetworkInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInterface for more information on using the DeleteNetworkInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkInterfaceRequest method.
//	req, resp := client.DeleteNetworkInterfaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface
func (c *EC2) DeleteNetworkInterfaceRequest(input *DeleteNetworkInterfaceInput) (req *request.Request, output *DeleteNetworkInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInterfaceInput{}
	}

	output = &DeleteNetworkInterfaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteNetworkInterface API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified network interface. You must detach the network interface
// before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInterface for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterface
func (c *EC2) DeleteNetworkInterface(input *DeleteNetworkInterfaceInput) (*DeleteNetworkInterfaceOutput, error) {
	req, out := c.DeleteNetworkInterfaceRequest(input)
	return out, req.Send()
}

// DeleteNetworkInterfaceWithContext is the same as DeleteNetworkInterface with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInterfaceWithContext(ctx aws.Context, input *DeleteNetworkInterfaceInput, opts ...request.Option) (*DeleteNetworkInterfaceOutput, error) {
	req, out := c.DeleteNetworkInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNetworkInterfacePermission = "DeleteNetworkInterfacePermission"

// DeleteNetworkInterfacePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNetworkInterfacePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNetworkInterfacePermission for more information on using the DeleteNetworkInterfacePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNetworkInterfacePermissionRequest method.
//	req, resp := client.DeleteNetworkInterfacePermissionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission
func (c *EC2) DeleteNetworkInterfacePermissionRequest(input *DeleteNetworkInterfacePermissionInput) (req *request.Request, output *DeleteNetworkInterfacePermissionOutput) {
	op := &request.Operation{
		Name:       opDeleteNetworkInterfacePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInterfacePermissionInput{}
	}

	output = &DeleteNetworkInterfacePermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNetworkInterfacePermission API operation for Amazon Elastic Compute Cloud.
//
// Deletes a permission for a network interface. By default, you cannot delete
// the permission if the account for which you're removing the permission has
// attached the network interface to an instance. However, you can force delete
// the permission, regardless of any attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteNetworkInterfacePermission for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission
func (c *EC2) DeleteNetworkInterfacePermission(input *DeleteNetworkInterfacePermissionInput) (*DeleteNetworkInterfacePermissionOutput, error) {
	req, out := c.DeleteNetworkInterfacePermissionRequest(input)
	return out, req.Send()
}

// DeleteNetworkInterfacePermissionWithContext is the same as DeleteNetworkInterfacePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNetworkInterfacePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteNetworkInterfacePermissionWithContext(ctx aws.Context, input *DeleteNetworkInterfacePermissionInput, opts ...request.Option) (*DeleteNetworkInterfacePermissionOutput, error) {
	req, out := c.DeleteNetworkInterfacePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlacementGroup = "DeletePlacementGroup"

// DeletePlacementGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlacementGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlacementGroup for more information on using the DeletePlacementGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePlacementGroupRequest method.
//	req, resp := client.DeletePlacementGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup
func (c *EC2) DeletePlacementGroupRequest(input *DeletePlacementGroupInput) (req *request.Request, output *DeletePlacementGroupOutput) {
	op := &request.Operation{
		Name:       opDeletePlacementGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlacementGroupInput{}
	}

	output = &DeletePlacementGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlacementGroup API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified placement group. You must terminate all instances in
// the placement group before you can delete the placement group. For more information,
// see Placement groups (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeletePlacementGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroup
func (c *EC2) DeletePlacementGroup(input *DeletePlacementGroupInput) (*DeletePlacementGroupOutput, error) {
	req, out := c.DeletePlacementGroupRequest(input)
	return out, req.Send()
}

// DeletePlacementGroupWithContext is the same as DeletePlacementGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlacementGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeletePlacementGroupWithContext(ctx aws.Context, input *DeletePlacementGroupInput, opts ...request.Option) (*DeletePlacementGroupOutput, error) {
	req, out := c.DeletePlacementGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicIpv4Pool = "DeletePublicIpv4Pool"

// DeletePublicIpv4PoolRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicIpv4Pool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicIpv4Pool for more information on using the DeletePublicIpv4Pool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePublicIpv4PoolRequest method.
//	req, resp := client.DeletePublicIpv4PoolRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool
func (c *EC2) DeletePublicIpv4PoolRequest(input *DeletePublicIpv4PoolInput) (req *request.Request, output *DeletePublicIpv4PoolOutput) {
	op := &request.Operation{
		Name:       opDeletePublicIpv4Pool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePublicIpv4PoolInput{}
	}

	output = &DeletePublicIpv4PoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePublicIpv4Pool API operation for Amazon Elastic Compute Cloud.
//
// Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required
// for the public IPv4 CIDRs that you own and bring to Amazon Web Services to
// manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however,
// use IPAM pools only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeletePublicIpv4Pool for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePublicIpv4Pool
func (c *EC2) DeletePublicIpv4Pool(input *DeletePublicIpv4PoolInput) (*DeletePublicIpv4PoolOutput, error) {
	req, out := c.DeletePublicIpv4PoolRequest(input)
	return out, req.Send()
}

// DeletePublicIpv4PoolWithContext is the same as DeletePublicIpv4Pool with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicIpv4Pool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeletePublicIpv4PoolWithContext(ctx aws.Context, input *DeletePublicIpv4PoolInput, opts ...request.Option) (*DeletePublicIpv4PoolOutput, error) {
	req, out := c.DeletePublicIpv4PoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQueuedReservedInstances = "DeleteQueuedReservedInstances"

// DeleteQueuedReservedInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQueuedReservedInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQueuedReservedInstances for more information on using the DeleteQueuedReservedInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteQueuedReservedInstancesRequest method.
//	req, resp := client.DeleteQueuedReservedInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances
func (c *EC2) DeleteQueuedReservedInstancesRequest(input *DeleteQueuedReservedInstancesInput) (req *request.Request, output *DeleteQueuedReservedInstancesOutput) {
	op := &request.Operation{
		Name:       opDeleteQueuedReservedInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteQueuedReservedInstancesInput{}
	}

	output = &DeleteQueuedReservedInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteQueuedReservedInstances API operation for Amazon Elastic Compute Cloud.
//
// Deletes the queued purchases for the specified Reserved Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteQueuedReservedInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstances
func (c *EC2) DeleteQueuedReservedInstances(input *DeleteQueuedReservedInstancesInput) (*DeleteQueuedReservedInstancesOutput, error) {
	req, out := c.DeleteQueuedReservedInstancesRequest(input)
	return out, req.Send()
}

// DeleteQueuedReservedInstancesWithContext is the same as DeleteQueuedReservedInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQueuedReservedInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteQueuedReservedInstancesWithContext(ctx aws.Context, input *DeleteQueuedReservedInstancesInput, opts ...request.Option) (*DeleteQueuedReservedInstancesOutput, error) {
	req, out := c.DeleteQueuedReservedInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoute = "DeleteRoute"

// DeleteRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoute for more information on using the DeleteRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRouteRequest method.
//	req, resp := client.DeleteRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute
func (c *EC2) DeleteRouteRequest(input *DeleteRouteInput) (req *request.Request, output *DeleteRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteInput{}
	}

	output = &DeleteRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRoute
func (c *EC2) DeleteRoute(input *DeleteRouteInput) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	return out, req.Send()
}

// DeleteRouteWithContext is the same as DeleteRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteRouteWithContext(ctx aws.Context, input *DeleteRouteInput, opts ...request.Option) (*DeleteRouteOutput, error) {
	req, out := c.DeleteRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRouteTable = "DeleteRouteTable"

// DeleteRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRouteTable for more information on using the DeleteRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRouteTableRequest method.
//	req, resp := client.DeleteRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable
func (c *EC2) DeleteRouteTableRequest(input *DeleteRouteTableInput) (req *request.Request, output *DeleteRouteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRouteTableInput{}
	}

	output = &DeleteRouteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route table. You must disassociate the route table
// from any subnets before you can delete it. You can't delete the main route
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTable
func (c *EC2) DeleteRouteTable(input *DeleteRouteTableInput) (*DeleteRouteTableOutput, error) {
	req, out := c.DeleteRouteTableRequest(input)
	return out, req.Send()
}

// DeleteRouteTableWithContext is the same as DeleteRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteRouteTableWithContext(ctx aws.Context, input *DeleteRouteTableInput, opts ...request.Option) (*DeleteRouteTableOutput, error) {
	req, out := c.DeleteRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityGroup = "DeleteSecurityGroup"

// DeleteSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityGroup for more information on using the DeleteSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSecurityGroupRequest method.
//	req, resp := client.DeleteSecurityGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup
func (c *EC2) DeleteSecurityGroupRequest(input *DeleteSecurityGroupInput) (req *request.Request, output *DeleteSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityGroupInput{}
	}

	output = &DeleteSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityGroup API operation for Amazon Elastic Compute Cloud.
//
// Deletes a security group.
//
// If you attempt to delete a security group that is associated with an instance
// or network interface or is referenced by another security group, the operation
// fails with DependencyViolation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSecurityGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroup
func (c *EC2) DeleteSecurityGroup(input *DeleteSecurityGroupInput) (*DeleteSecurityGroupOutput, error) {
	req, out := c.DeleteSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteSecurityGroupWithContext is the same as DeleteSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSecurityGroupWithContext(ctx aws.Context, input *DeleteSecurityGroupInput, opts ...request.Option) (*DeleteSecurityGroupOutput, error) {
	req, out := c.DeleteSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshot for more information on using the DeleteSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSnapshotRequest method.
//	req, resp := client.DeleteSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot
func (c *EC2) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	output = &DeleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSnapshot API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified snapshot.
//
// When you make periodic snapshots of a volume, the snapshots are incremental,
// and only the blocks on the device that have changed since your last snapshot
// are saved in the new snapshot. When you delete a snapshot, only the data
// not needed for any other snapshot is removed. So regardless of which prior
// snapshots have been deleted, all active snapshots will have access to all
// the information needed to restore the volume.
//
// You cannot delete a snapshot of the root device of an EBS volume used by
// a registered AMI. You must first de-register the AMI before you can delete
// the snapshot.
//
// For more information, see Delete an Amazon EBS snapshot (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-snapshot.html)
// in the Amazon EBS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSnapshot for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshot
func (c *EC2) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	return out, req.Send()
}

// DeleteSnapshotWithContext is the same as DeleteSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSnapshotWithContext(ctx aws.Context, input *DeleteSnapshotInput, opts ...request.Option) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSpotDatafeedSubscription = "DeleteSpotDatafeedSubscription"

// DeleteSpotDatafeedSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSpotDatafeedSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSpotDatafeedSubscription for more information on using the DeleteSpotDatafeedSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSpotDatafeedSubscriptionRequest method.
//	req, resp := client.DeleteSpotDatafeedSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription
func (c *EC2) DeleteSpotDatafeedSubscriptionRequest(input *DeleteSpotDatafeedSubscriptionInput) (req *request.Request, output *DeleteSpotDatafeedSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteSpotDatafeedSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSpotDatafeedSubscriptionInput{}
	}

	output = &DeleteSpotDatafeedSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSpotDatafeedSubscription API operation for Amazon Elastic Compute Cloud.
//
// Deletes the data feed for Spot Instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSpotDatafeedSubscription for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscription
func (c *EC2) DeleteSpotDatafeedSubscription(input *DeleteSpotDatafeedSubscriptionInput) (*DeleteSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DeleteSpotDatafeedSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteSpotDatafeedSubscriptionWithContext is the same as DeleteSpotDatafeedSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSpotDatafeedSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSpotDatafeedSubscriptionWithContext(ctx aws.Context, input *DeleteSpotDatafeedSubscriptionInput, opts ...request.Option) (*DeleteSpotDatafeedSubscriptionOutput, error) {
	req, out := c.DeleteSpotDatafeedSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubnet = "DeleteSubnet"

// DeleteSubnetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubnet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubnet for more information on using the DeleteSubnet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubnetRequest method.
//	req, resp := client.DeleteSubnetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet
func (c *EC2) DeleteSubnetRequest(input *DeleteSubnetInput) (req *request.Request, output *DeleteSubnetOutput) {
	op := &request.Operation{
		Name:       opDeleteSubnet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetInput{}
	}

	output = &DeleteSubnetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubnet API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified subnet. You must terminate all running instances in
// the subnet before you can delete the subnet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSubnet for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnet
func (c *EC2) DeleteSubnet(input *DeleteSubnetInput) (*DeleteSubnetOutput, error) {
	req, out := c.DeleteSubnetRequest(input)
	return out, req.Send()
}

// DeleteSubnetWithContext is the same as DeleteSubnet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubnet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSubnetWithContext(ctx aws.Context, input *DeleteSubnetInput, opts ...request.Option) (*DeleteSubnetOutput, error) {
	req, out := c.DeleteSubnetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubnetCidrReservation = "DeleteSubnetCidrReservation"

// DeleteSubnetCidrReservationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubnetCidrReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubnetCidrReservation for more information on using the DeleteSubnetCidrReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubnetCidrReservationRequest method.
//	req, resp := client.DeleteSubnetCidrReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation
func (c *EC2) DeleteSubnetCidrReservationRequest(input *DeleteSubnetCidrReservationInput) (req *request.Request, output *DeleteSubnetCidrReservationOutput) {
	op := &request.Operation{
		Name:       opDeleteSubnetCidrReservation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetCidrReservationInput{}
	}

	output = &DeleteSubnetCidrReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSubnetCidrReservation API operation for Amazon Elastic Compute Cloud.
//
// Deletes a subnet CIDR reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteSubnetCidrReservation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetCidrReservation
func (c *EC2) DeleteSubnetCidrReservation(input *DeleteSubnetCidrReservationInput) (*DeleteSubnetCidrReservationOutput, error) {
	req, out := c.DeleteSubnetCidrReservationRequest(input)
	return out, req.Send()
}

// DeleteSubnetCidrReservationWithContext is the same as DeleteSubnetCidrReservation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubnetCidrReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteSubnetCidrReservationWithContext(ctx aws.Context, input *DeleteSubnetCidrReservationInput, opts ...request.Option) (*DeleteSubnetCidrReservationOutput, error) {
	req, out := c.DeleteSubnetCidrReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTagsRequest method.
//	req, resp := client.DeleteTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags
func (c *EC2) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified set of tags from the specified set of resources.
//
// To list the current tags, use DescribeTags. For more information about tags,
// see Tag your Amazon EC2 resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTags for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTags
func (c *EC2) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorFilter = "DeleteTrafficMirrorFilter"

// DeleteTrafficMirrorFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorFilter for more information on using the DeleteTrafficMirrorFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrafficMirrorFilterRequest method.
//	req, resp := client.DeleteTrafficMirrorFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter
func (c *EC2) DeleteTrafficMirrorFilterRequest(input *DeleteTrafficMirrorFilterInput) (req *request.Request, output *DeleteTrafficMirrorFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorFilterInput{}
	}

	output = &DeleteTrafficMirrorFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorFilter API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror filter.
//
// You cannot delete a Traffic Mirror filter that is in use by a Traffic Mirror
// session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorFilter for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilter
func (c *EC2) DeleteTrafficMirrorFilter(input *DeleteTrafficMirrorFilterInput) (*DeleteTrafficMirrorFilterOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorFilterWithContext is the same as DeleteTrafficMirrorFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorFilterWithContext(ctx aws.Context, input *DeleteTrafficMirrorFilterInput, opts ...request.Option) (*DeleteTrafficMirrorFilterOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorFilterRule = "DeleteTrafficMirrorFilterRule"

// DeleteTrafficMirrorFilterRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorFilterRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorFilterRule for more information on using the DeleteTrafficMirrorFilterRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrafficMirrorFilterRuleRequest method.
//	req, resp := client.DeleteTrafficMirrorFilterRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule
func (c *EC2) DeleteTrafficMirrorFilterRuleRequest(input *DeleteTrafficMirrorFilterRuleInput) (req *request.Request, output *DeleteTrafficMirrorFilterRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorFilterRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorFilterRuleInput{}
	}

	output = &DeleteTrafficMirrorFilterRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorFilterRule API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorFilterRule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRule
func (c *EC2) DeleteTrafficMirrorFilterRule(input *DeleteTrafficMirrorFilterRuleInput) (*DeleteTrafficMirrorFilterRuleOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRuleRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorFilterRuleWithContext is the same as DeleteTrafficMirrorFilterRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorFilterRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorFilterRuleWithContext(ctx aws.Context, input *DeleteTrafficMirrorFilterRuleInput, opts ...request.Option) (*DeleteTrafficMirrorFilterRuleOutput, error) {
	req, out := c.DeleteTrafficMirrorFilterRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorSession = "DeleteTrafficMirrorSession"

// DeleteTrafficMirrorSessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorSession for more information on using the DeleteTrafficMirrorSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrafficMirrorSessionRequest method.
//	req, resp := client.DeleteTrafficMirrorSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession
func (c *EC2) DeleteTrafficMirrorSessionRequest(input *DeleteTrafficMirrorSessionInput) (req *request.Request, output *DeleteTrafficMirrorSessionOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorSessionInput{}
	}

	output = &DeleteTrafficMirrorSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorSession API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorSession for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSession
func (c *EC2) DeleteTrafficMirrorSession(input *DeleteTrafficMirrorSessionInput) (*DeleteTrafficMirrorSessionOutput, error) {
	req, out := c.DeleteTrafficMirrorSessionRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorSessionWithContext is the same as DeleteTrafficMirrorSession with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorSessionWithContext(ctx aws.Context, input *DeleteTrafficMirrorSessionInput, opts ...request.Option) (*DeleteTrafficMirrorSessionOutput, error) {
	req, out := c.DeleteTrafficMirrorSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficMirrorTarget = "DeleteTrafficMirrorTarget"

// DeleteTrafficMirrorTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficMirrorTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficMirrorTarget for more information on using the DeleteTrafficMirrorTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrafficMirrorTargetRequest method.
//	req, resp := client.DeleteTrafficMirrorTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget
func (c *EC2) DeleteTrafficMirrorTargetRequest(input *DeleteTrafficMirrorTargetInput) (req *request.Request, output *DeleteTrafficMirrorTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficMirrorTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrafficMirrorTargetInput{}
	}

	output = &DeleteTrafficMirrorTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrafficMirrorTarget API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Traffic Mirror target.
//
// You cannot delete a Traffic Mirror target that is in use by a Traffic Mirror
// session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTrafficMirrorTarget for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTarget
func (c *EC2) DeleteTrafficMirrorTarget(input *DeleteTrafficMirrorTargetInput) (*DeleteTrafficMirrorTargetOutput, error) {
	req, out := c.DeleteTrafficMirrorTargetRequest(input)
	return out, req.Send()
}

// DeleteTrafficMirrorTargetWithContext is the same as DeleteTrafficMirrorTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficMirrorTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTrafficMirrorTargetWithContext(ctx aws.Context, input *DeleteTrafficMirrorTargetInput, opts ...request.Option) (*DeleteTrafficMirrorTargetOutput, error) {
	req, out := c.DeleteTrafficMirrorTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGateway = "DeleteTransitGateway"

// DeleteTransitGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGateway for more information on using the DeleteTransitGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayRequest method.
//	req, resp := client.DeleteTransitGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway
func (c *EC2) DeleteTransitGatewayRequest(input *DeleteTransitGatewayInput) (req *request.Request, output *DeleteTransitGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayInput{}
	}

	output = &DeleteTransitGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified transit gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGateway
func (c *EC2) DeleteTransitGateway(input *DeleteTransitGatewayInput) (*DeleteTransitGatewayOutput, error) {
	req, out := c.DeleteTransitGatewayRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayWithContext is the same as DeleteTransitGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayWithContext(ctx aws.Context, input *DeleteTransitGatewayInput, opts ...request.Option) (*DeleteTransitGatewayOutput, error) {
	req, out := c.DeleteTransitGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayConnect = "DeleteTransitGatewayConnect"

// DeleteTransitGatewayConnectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayConnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayConnect for more information on using the DeleteTransitGatewayConnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayConnectRequest method.
//	req, resp := client.DeleteTransitGatewayConnectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect
func (c *EC2) DeleteTransitGatewayConnectRequest(input *DeleteTransitGatewayConnectInput) (req *request.Request, output *DeleteTransitGatewayConnectOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayConnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayConnectInput{}
	}

	output = &DeleteTransitGatewayConnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayConnect API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Connect attachment. You must first delete any Connect
// peers for the attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayConnect for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnect
func (c *EC2) DeleteTransitGatewayConnect(input *DeleteTransitGatewayConnectInput) (*DeleteTransitGatewayConnectOutput, error) {
	req, out := c.DeleteTransitGatewayConnectRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayConnectWithContext is the same as DeleteTransitGatewayConnect with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayConnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayConnectWithContext(ctx aws.Context, input *DeleteTransitGatewayConnectInput, opts ...request.Option) (*DeleteTransitGatewayConnectOutput, error) {
	req, out := c.DeleteTransitGatewayConnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayConnectPeer = "DeleteTransitGatewayConnectPeer"

// DeleteTransitGatewayConnectPeerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayConnectPeer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayConnectPeer for more information on using the DeleteTransitGatewayConnectPeer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayConnectPeerRequest method.
//	req, resp := client.DeleteTransitGatewayConnectPeerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer
func (c *EC2) DeleteTransitGatewayConnectPeerRequest(input *DeleteTransitGatewayConnectPeerInput) (req *request.Request, output *DeleteTransitGatewayConnectPeerOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayConnectPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayConnectPeerInput{}
	}

	output = &DeleteTransitGatewayConnectPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayConnectPeer API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified Connect peer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayConnectPeer for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeer
func (c *EC2) DeleteTransitGatewayConnectPeer(input *DeleteTransitGatewayConnectPeerInput) (*DeleteTransitGatewayConnectPeerOutput, error) {
	req, out := c.DeleteTransitGatewayConnectPeerRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayConnectPeerWithContext is the same as DeleteTransitGatewayConnectPeer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayConnectPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayConnectPeerWithContext(ctx aws.Context, input *DeleteTransitGatewayConnectPeerInput, opts ...request.Option) (*DeleteTransitGatewayConnectPeerOutput, error) {
	req, out := c.DeleteTransitGatewayConnectPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayMulticastDomain = "DeleteTransitGatewayMulticastDomain"

// DeleteTransitGatewayMulticastDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayMulticastDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayMulticastDomain for more information on using the DeleteTransitGatewayMulticastDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayMulticastDomainRequest method.
//	req, resp := client.DeleteTransitGatewayMulticastDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain
func (c *EC2) DeleteTransitGatewayMulticastDomainRequest(input *DeleteTransitGatewayMulticastDomainInput) (req *request.Request, output *DeleteTransitGatewayMulticastDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayMulticastDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayMulticastDomainInput{}
	}

	output = &DeleteTransitGatewayMulticastDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayMulticastDomain API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified transit gateway multicast domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayMulticastDomain for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomain
func (c *EC2) DeleteTransitGatewayMulticastDomain(input *DeleteTransitGatewayMulticastDomainInput) (*DeleteTransitGatewayMulticastDomainOutput, error) {
	req, out := c.DeleteTransitGatewayMulticastDomainRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayMulticastDomainWithContext is the same as DeleteTransitGatewayMulticastDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayMulticastDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayMulticastDomainWithContext(ctx aws.Context, input *DeleteTransitGatewayMulticastDomainInput, opts ...request.Option) (*DeleteTransitGatewayMulticastDomainOutput, error) {
	req, out := c.DeleteTransitGatewayMulticastDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayPeeringAttachment = "DeleteTransitGatewayPeeringAttachment"

// DeleteTransitGatewayPeeringAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayPeeringAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayPeeringAttachment for more information on using the DeleteTransitGatewayPeeringAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayPeeringAttachmentRequest method.
//	req, resp := client.DeleteTransitGatewayPeeringAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment
func (c *EC2) DeleteTransitGatewayPeeringAttachmentRequest(input *DeleteTransitGatewayPeeringAttachmentInput) (req *request.Request, output *DeleteTransitGatewayPeeringAttachmentOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayPeeringAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayPeeringAttachmentInput{}
	}

	output = &DeleteTransitGatewayPeeringAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayPeeringAttachment API operation for Amazon Elastic Compute Cloud.
//
// Deletes a transit gateway peering attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayPeeringAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachment
func (c *EC2) DeleteTransitGatewayPeeringAttachment(input *DeleteTransitGatewayPeeringAttachmentInput) (*DeleteTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayPeeringAttachmentRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayPeeringAttachmentWithContext is the same as DeleteTransitGatewayPeeringAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayPeeringAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayPeeringAttachmentWithContext(ctx aws.Context, input *DeleteTransitGatewayPeeringAttachmentInput, opts ...request.Option) (*DeleteTransitGatewayPeeringAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayPeeringAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayPolicyTable = "DeleteTransitGatewayPolicyTable"

// DeleteTransitGatewayPolicyTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayPolicyTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayPolicyTable for more information on using the DeleteTransitGatewayPolicyTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayPolicyTableRequest method.
//	req, resp := client.DeleteTransitGatewayPolicyTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable
func (c *EC2) DeleteTransitGatewayPolicyTableRequest(input *DeleteTransitGatewayPolicyTableInput) (req *request.Request, output *DeleteTransitGatewayPolicyTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayPolicyTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayPolicyTableInput{}
	}

	output = &DeleteTransitGatewayPolicyTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayPolicyTable API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified transit gateway policy table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayPolicyTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPolicyTable
func (c *EC2) DeleteTransitGatewayPolicyTable(input *DeleteTransitGatewayPolicyTableInput) (*DeleteTransitGatewayPolicyTableOutput, error) {
	req, out := c.DeleteTransitGatewayPolicyTableRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayPolicyTableWithContext is the same as DeleteTransitGatewayPolicyTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayPolicyTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayPolicyTableWithContext(ctx aws.Context, input *DeleteTransitGatewayPolicyTableInput, opts ...request.Option) (*DeleteTransitGatewayPolicyTableOutput, error) {
	req, out := c.DeleteTransitGatewayPolicyTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayPrefixListReference = "DeleteTransitGatewayPrefixListReference"

// DeleteTransitGatewayPrefixListReferenceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayPrefixListReference operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayPrefixListReference for more information on using the DeleteTransitGatewayPrefixListReference
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayPrefixListReferenceRequest method.
//	req, resp := client.DeleteTransitGatewayPrefixListReferenceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference
func (c *EC2) DeleteTransitGatewayPrefixListReferenceRequest(input *DeleteTransitGatewayPrefixListReferenceInput) (req *request.Request, output *DeleteTransitGatewayPrefixListReferenceOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayPrefixListReference,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayPrefixListReferenceInput{}
	}

	output = &DeleteTransitGatewayPrefixListReferenceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayPrefixListReference API operation for Amazon Elastic Compute Cloud.
//
// Deletes a reference (route) to a prefix list in a specified transit gateway
// route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayPrefixListReference for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReference
func (c *EC2) DeleteTransitGatewayPrefixListReference(input *DeleteTransitGatewayPrefixListReferenceInput) (*DeleteTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.DeleteTransitGatewayPrefixListReferenceRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayPrefixListReferenceWithContext is the same as DeleteTransitGatewayPrefixListReference with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayPrefixListReference for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayPrefixListReferenceWithContext(ctx aws.Context, input *DeleteTransitGatewayPrefixListReferenceInput, opts ...request.Option) (*DeleteTransitGatewayPrefixListReferenceOutput, error) {
	req, out := c.DeleteTransitGatewayPrefixListReferenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayRoute = "DeleteTransitGatewayRoute"

// DeleteTransitGatewayRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayRoute for more information on using the DeleteTransitGatewayRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayRouteRequest method.
//	req, resp := client.DeleteTransitGatewayRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute
func (c *EC2) DeleteTransitGatewayRouteRequest(input *DeleteTransitGatewayRouteInput) (req *request.Request, output *DeleteTransitGatewayRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayRouteInput{}
	}

	output = &DeleteTransitGatewayRouteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified route from the specified transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRoute
func (c *EC2) DeleteTransitGatewayRoute(input *DeleteTransitGatewayRouteInput) (*DeleteTransitGatewayRouteOutput, error) {
	req, out := c.DeleteTransitGatewayRouteRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayRouteWithContext is the same as DeleteTransitGatewayRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayRouteWithContext(ctx aws.Context, input *DeleteTransitGatewayRouteInput, opts ...request.Option) (*DeleteTransitGatewayRouteOutput, error) {
	req, out := c.DeleteTransitGatewayRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayRouteTable = "DeleteTransitGatewayRouteTable"

// DeleteTransitGatewayRouteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayRouteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayRouteTable for more information on using the DeleteTransitGatewayRouteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayRouteTableRequest method.
//	req, resp := client.DeleteTransitGatewayRouteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable
func (c *EC2) DeleteTransitGatewayRouteTableRequest(input *DeleteTransitGatewayRouteTableInput) (req *request.Request, output *DeleteTransitGatewayRouteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayRouteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayRouteTableInput{}
	}

	output = &DeleteTransitGatewayRouteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayRouteTable API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified transit gateway route table. If there are any route
// tables associated with the transit gateway route table, you must first run
// DisassociateRouteTable before you can delete the transit gateway route table.
// This removes any route tables associated with the transit gateway route table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayRouteTable for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTable
func (c *EC2) DeleteTransitGatewayRouteTable(input *DeleteTransitGatewayRouteTableInput) (*DeleteTransitGatewayRouteTableOutput, error) {
	req, out := c.DeleteTransitGatewayRouteTableRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayRouteTableWithContext is the same as DeleteTransitGatewayRouteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayRouteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayRouteTableWithContext(ctx aws.Context, input *DeleteTransitGatewayRouteTableInput, opts ...request.Option) (*DeleteTransitGatewayRouteTableOutput, error) {
	req, out := c.DeleteTransitGatewayRouteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayRouteTableAnnouncement = "DeleteTransitGatewayRouteTableAnnouncement"

// DeleteTransitGatewayRouteTableAnnouncementRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayRouteTableAnnouncement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayRouteTableAnnouncement for more information on using the DeleteTransitGatewayRouteTableAnnouncement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayRouteTableAnnouncementRequest method.
//	req, resp := client.DeleteTransitGatewayRouteTableAnnouncementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncement
func (c *EC2) DeleteTransitGatewayRouteTableAnnouncementRequest(input *DeleteTransitGatewayRouteTableAnnouncementInput) (req *request.Request, output *DeleteTransitGatewayRouteTableAnnouncementOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayRouteTableAnnouncement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayRouteTableAnnouncementInput{}
	}

	output = &DeleteTransitGatewayRouteTableAnnouncementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayRouteTableAnnouncement API operation for Amazon Elastic Compute Cloud.
//
// Advertises to the transit gateway that a transit gateway route table is deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayRouteTableAnnouncement for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableAnnouncement
func (c *EC2) DeleteTransitGatewayRouteTableAnnouncement(input *DeleteTransitGatewayRouteTableAnnouncementInput) (*DeleteTransitGatewayRouteTableAnnouncementOutput, error) {
	req, out := c.DeleteTransitGatewayRouteTableAnnouncementRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayRouteTableAnnouncementWithContext is the same as DeleteTransitGatewayRouteTableAnnouncement with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayRouteTableAnnouncement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayRouteTableAnnouncementWithContext(ctx aws.Context, input *DeleteTransitGatewayRouteTableAnnouncementInput, opts ...request.Option) (*DeleteTransitGatewayRouteTableAnnouncementOutput, error) {
	req, out := c.DeleteTransitGatewayRouteTableAnnouncementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTransitGatewayVpcAttachment = "DeleteTransitGatewayVpcAttachment"

// DeleteTransitGatewayVpcAttachmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTransitGatewayVpcAttachment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTransitGatewayVpcAttachment for more information on using the DeleteTransitGatewayVpcAttachment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTransitGatewayVpcAttachmentRequest method.
//	req, resp := client.DeleteTransitGatewayVpcAttachmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment
func (c *EC2) DeleteTransitGatewayVpcAttachmentRequest(input *DeleteTransitGatewayVpcAttachmentInput) (req *request.Request, output *DeleteTransitGatewayVpcAttachmentOutput) {
	op := &request.Operation{
		Name:       opDeleteTransitGatewayVpcAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTransitGatewayVpcAttachmentInput{}
	}

	output = &DeleteTransitGatewayVpcAttachmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTransitGatewayVpcAttachment API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC attachment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteTransitGatewayVpcAttachment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachment
func (c *EC2) DeleteTransitGatewayVpcAttachment(input *DeleteTransitGatewayVpcAttachmentInput) (*DeleteTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayVpcAttachmentRequest(input)
	return out, req.Send()
}

// DeleteTransitGatewayVpcAttachmentWithContext is the same as DeleteTransitGatewayVpcAttachment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTransitGatewayVpcAttachment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteTransitGatewayVpcAttachmentWithContext(ctx aws.Context, input *DeleteTransitGatewayVpcAttachmentInput, opts ...request.Option) (*DeleteTransitGatewayVpcAttachmentOutput, error) {
	req, out := c.DeleteTransitGatewayVpcAttachmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVerifiedAccessEndpoint = "DeleteVerifiedAccessEndpoint"

// DeleteVerifiedAccessEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVerifiedAccessEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVerifiedAccessEndpoint for more information on using the DeleteVerifiedAccessEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVerifiedAccessEndpointRequest method.
//	req, resp := client.DeleteVerifiedAccessEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpoint
func (c *EC2) DeleteVerifiedAccessEndpointRequest(input *DeleteVerifiedAccessEndpointInput) (req *request.Request, output *DeleteVerifiedAccessEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteVerifiedAccessEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedAccessEndpointInput{}
	}

	output = &DeleteVerifiedAccessEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVerifiedAccessEndpoint API operation for Amazon Elastic Compute Cloud.
//
// Delete an Amazon Web Services Verified Access endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVerifiedAccessEndpoint for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessEndpoint
func (c *EC2) DeleteVerifiedAccessEndpoint(input *DeleteVerifiedAccessEndpointInput) (*DeleteVerifiedAccessEndpointOutput, error) {
	req, out := c.DeleteVerifiedAccessEndpointRequest(input)
	return out, req.Send()
}

// DeleteVerifiedAccessEndpointWithContext is the same as DeleteVerifiedAccessEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVerifiedAccessEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVerifiedAccessEndpointWithContext(ctx aws.Context, input *DeleteVerifiedAccessEndpointInput, opts ...request.Option) (*DeleteVerifiedAccessEndpointOutput, error) {
	req, out := c.DeleteVerifiedAccessEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVerifiedAccessGroup = "DeleteVerifiedAccessGroup"

// DeleteVerifiedAccessGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVerifiedAccessGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVerifiedAccessGroup for more information on using the DeleteVerifiedAccessGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVerifiedAccessGroupRequest method.
//	req, resp := client.DeleteVerifiedAccessGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroup
func (c *EC2) DeleteVerifiedAccessGroupRequest(input *DeleteVerifiedAccessGroupInput) (req *request.Request, output *DeleteVerifiedAccessGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteVerifiedAccessGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedAccessGroupInput{}
	}

	output = &DeleteVerifiedAccessGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVerifiedAccessGroup API operation for Amazon Elastic Compute Cloud.
//
// Delete an Amazon Web Services Verified Access group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVerifiedAccessGroup for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessGroup
func (c *EC2) DeleteVerifiedAccessGroup(input *DeleteVerifiedAccessGroupInput) (*DeleteVerifiedAccessGroupOutput, error) {
	req, out := c.DeleteVerifiedAccessGroupRequest(input)
	return out, req.Send()
}

// DeleteVerifiedAccessGroupWithContext is the same as DeleteVerifiedAccessGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVerifiedAccessGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVerifiedAccessGroupWithContext(ctx aws.Context, input *DeleteVerifiedAccessGroupInput, opts ...request.Option) (*DeleteVerifiedAccessGroupOutput, error) {
	req, out := c.DeleteVerifiedAccessGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVerifiedAccessInstance = "DeleteVerifiedAccessInstance"

// DeleteVerifiedAccessInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVerifiedAccessInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVerifiedAccessInstance for more information on using the DeleteVerifiedAccessInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVerifiedAccessInstanceRequest method.
//	req, resp := client.DeleteVerifiedAccessInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstance
func (c *EC2) DeleteVerifiedAccessInstanceRequest(input *DeleteVerifiedAccessInstanceInput) (req *request.Request, output *DeleteVerifiedAccessInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteVerifiedAccessInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedAccessInstanceInput{}
	}

	output = &DeleteVerifiedAccessInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVerifiedAccessInstance API operation for Amazon Elastic Compute Cloud.
//
// Delete an Amazon Web Services Verified Access instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVerifiedAccessInstance for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessInstance
func (c *EC2) DeleteVerifiedAccessInstance(input *DeleteVerifiedAccessInstanceInput) (*DeleteVerifiedAccessInstanceOutput, error) {
	req, out := c.DeleteVerifiedAccessInstanceRequest(input)
	return out, req.Send()
}

// DeleteVerifiedAccessInstanceWithContext is the same as DeleteVerifiedAccessInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVerifiedAccessInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVerifiedAccessInstanceWithContext(ctx aws.Context, input *DeleteVerifiedAccessInstanceInput, opts ...request.Option) (*DeleteVerifiedAccessInstanceOutput, error) {
	req, out := c.DeleteVerifiedAccessInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVerifiedAccessTrustProvider = "DeleteVerifiedAccessTrustProvider"

// DeleteVerifiedAccessTrustProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVerifiedAccessTrustProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVerifiedAccessTrustProvider for more information on using the DeleteVerifiedAccessTrustProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVerifiedAccessTrustProviderRequest method.
//	req, resp := client.DeleteVerifiedAccessTrustProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProvider
func (c *EC2) DeleteVerifiedAccessTrustProviderRequest(input *DeleteVerifiedAccessTrustProviderInput) (req *request.Request, output *DeleteVerifiedAccessTrustProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteVerifiedAccessTrustProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedAccessTrustProviderInput{}
	}

	output = &DeleteVerifiedAccessTrustProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVerifiedAccessTrustProvider API operation for Amazon Elastic Compute Cloud.
//
// Delete an Amazon Web Services Verified Access trust provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVerifiedAccessTrustProvider for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVerifiedAccessTrustProvider
func (c *EC2) DeleteVerifiedAccessTrustProvider(input *DeleteVerifiedAccessTrustProviderInput) (*DeleteVerifiedAccessTrustProviderOutput, error) {
	req, out := c.DeleteVerifiedAccessTrustProviderRequest(input)
	return out, req.Send()
}

// DeleteVerifiedAccessTrustProviderWithContext is the same as DeleteVerifiedAccessTrustProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVerifiedAccessTrustProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVerifiedAccessTrustProviderWithContext(ctx aws.Context, input *DeleteVerifiedAccessTrustProviderInput, opts ...request.Option) (*DeleteVerifiedAccessTrustProviderOutput, error) {
	req, out := c.DeleteVerifiedAccessTrustProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVolume for more information on using the DeleteVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVolumeRequest method.
//	req, resp := client.DeleteVolumeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume
func (c *EC2) DeleteVolumeRequest(input *DeleteVolumeInput) (req *request.Request, output *DeleteVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	output = &DeleteVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVolume API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified EBS volume. The volume must be in the available state
// (not attached to an instance).
//
// The volume can remain in the deleting state for several minutes.
//
// For more information, see Delete an Amazon EBS volume (https://docs.aws.amazon.com/ebs/latest/userguide/ebs-deleting-volume.html)
// in the Amazon EBS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVolume for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolume
func (c *EC2) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	return out, req.Send()
}

// DeleteVolumeWithContext is the same as DeleteVolume with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVolumeWithContext(ctx aws.Context, input *DeleteVolumeInput, opts ...request.Option) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpc = "DeleteVpc"

// DeleteVpcRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpc for more information on using the DeleteVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcRequest method.
//	req, resp := client.DeleteVpcRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc
func (c *EC2) DeleteVpcRequest(input *DeleteVpcInput) (req *request.Request, output *DeleteVpcOutput) {
	op := &request.Operation{
		Name:       opDeleteVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcInput{}
	}

	output = &DeleteVpcOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpc API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC. You must detach or delete all gateways and resources
// that are associated with the VPC before you can delete it. For example, you
// must terminate all instances running in the VPC, delete all security groups
// associated with the VPC (except the default one), delete all route tables
// associated with the VPC (except the default one), and so on. When you delete
// the VPC, it deletes the VPC's default security group, network ACL, and route
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpc for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpc
func (c *EC2) DeleteVpc(input *DeleteVpcInput) (*DeleteVpcOutput, error) {
	req, out := c.DeleteVpcRequest(input)
	return out, req.Send()
}

// DeleteVpcWithContext is the same as DeleteVpc with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcWithContext(ctx aws.Context, input *DeleteVpcInput, opts ...request.Option) (*DeleteVpcOutput, error) {
	req, out := c.DeleteVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpointConnectionNotifications = "DeleteVpcEndpointConnectionNotifications"

// DeleteVpcEndpointConnectionNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpointConnectionNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpointConnectionNotifications for more information on using the DeleteVpcEndpointConnectionNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcEndpointConnectionNotificationsRequest method.
//	req, resp := client.DeleteVpcEndpointConnectionNotificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications
func (c *EC2) DeleteVpcEndpointConnectionNotificationsRequest(input *DeleteVpcEndpointConnectionNotificationsInput) (req *request.Request, output *DeleteVpcEndpointConnectionNotificationsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpointConnectionNotifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointConnectionNotificationsInput{}
	}

	output = &DeleteVpcEndpointConnectionNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpointConnectionNotifications API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC endpoint connection notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcEndpointConnectionNotifications for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotifications
func (c *EC2) DeleteVpcEndpointConnectionNotifications(input *DeleteVpcEndpointConnectionNotificationsInput) (*DeleteVpcEndpointConnectionNotificationsOutput, error) {
	req, out := c.DeleteVpcEndpointConnectionNotificationsRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointConnectionNotificationsWithContext is the same as DeleteVpcEndpointConnectionNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpointConnectionNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcEndpointConnectionNotificationsWithContext(ctx aws.Context, input *DeleteVpcEndpointConnectionNotificationsInput, opts ...request.Option) (*DeleteVpcEndpointConnectionNotificationsOutput, error) {
	req, out := c.DeleteVpcEndpointConnectionNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpointServiceConfigurations = "DeleteVpcEndpointServiceConfigurations"

// DeleteVpcEndpointServiceConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpointServiceConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpointServiceConfigurations for more information on using the DeleteVpcEndpointServiceConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcEndpointServiceConfigurationsRequest method.
//	req, resp := client.DeleteVpcEndpointServiceConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations
func (c *EC2) DeleteVpcEndpointServiceConfigurationsRequest(input *DeleteVpcEndpointServiceConfigurationsInput) (req *request.Request, output *DeleteVpcEndpointServiceConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpointServiceConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointServiceConfigurationsInput{}
	}

	output = &DeleteVpcEndpointServiceConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpointServiceConfigurations API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC endpoint service configurations. Before you can
// delete an endpoint service configuration, you must reject any Available or
// PendingAcceptance interface endpoint connections that are attached to the
// service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcEndpointServiceConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurations
func (c *EC2) DeleteVpcEndpointServiceConfigurations(input *DeleteVpcEndpointServiceConfigurationsInput) (*DeleteVpcEndpointServiceConfigurationsOutput, error) {
	req, out := c.DeleteVpcEndpointServiceConfigurationsRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointServiceConfigurationsWithContext is the same as DeleteVpcEndpointServiceConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpointServiceConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcEndpointServiceConfigurationsWithContext(ctx aws.Context, input *DeleteVpcEndpointServiceConfigurationsInput, opts ...request.Option) (*DeleteVpcEndpointServiceConfigurationsOutput, error) {
	req, out := c.DeleteVpcEndpointServiceConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpoints = "DeleteVpcEndpoints"

// DeleteVpcEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpoints for more information on using the DeleteVpcEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcEndpointsRequest method.
//	req, resp := client.DeleteVpcEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints
func (c *EC2) DeleteVpcEndpointsRequest(input *DeleteVpcEndpointsInput) (req *request.Request, output *DeleteVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointsInput{}
	}

	output = &DeleteVpcEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpoints API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPC endpoints.
//
// When you delete a gateway endpoint, we delete the endpoint routes in the
// route tables for the endpoint.
//
// When you delete a Gateway Load Balancer endpoint, we delete its endpoint
// network interfaces. You can only delete Gateway Load Balancer endpoints when
// the routes that are associated with the endpoint are deleted.
//
// When you delete an interface endpoint, we delete its endpoint network interfaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpoints
func (c *EC2) DeleteVpcEndpoints(input *DeleteVpcEndpointsInput) (*DeleteVpcEndpointsOutput, error) {
	req, out := c.DeleteVpcEndpointsRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointsWithContext is the same as DeleteVpcEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcEndpointsWithContext(ctx aws.Context, input *DeleteVpcEndpointsInput, opts ...request.Option) (*DeleteVpcEndpointsOutput, error) {
	req, out := c.DeleteVpcEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcPeeringConnection for more information on using the DeleteVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcPeeringConnectionRequest method.
//	req, resp := client.DeleteVpcPeeringConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection
func (c *EC2) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) (req *request.Request, output *DeleteVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	output = &DeleteVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcPeeringConnection API operation for Amazon Elastic Compute Cloud.
//
// Deletes a VPC peering connection. Either the owner of the requester VPC or
// the owner of the accepter VPC can delete the VPC peering connection if it's
// in the active state. The owner of the requester VPC can delete a VPC peering
// connection in the pending-acceptance state. You cannot delete a VPC peering
// connection that's in the failed or rejected state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpcPeeringConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection
func (c *EC2) DeleteVpcPeeringConnection(input *DeleteVpcPeeringConnectionInput) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// DeleteVpcPeeringConnectionWithContext is the same as DeleteVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpcPeeringConnectionWithContext(ctx aws.Context, input *DeleteVpcPeeringConnectionInput, opts ...request.Option) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpnConnection = "DeleteVpnConnection"

// DeleteVpnConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpnConnection for more information on using the DeleteVpnConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpnConnectionRequest method.
//	req, resp := client.DeleteVpnConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection
func (c *EC2) DeleteVpnConnectionRequest(input *DeleteVpnConnectionInput) (req *request.Request, output *DeleteVpnConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionInput{}
	}

	output = &DeleteVpnConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnConnection API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified VPN connection.
//
// If you're deleting the VPC and its associated components, we recommend that
// you detach the virtual private gateway from the VPC and delete the VPC before
// deleting the VPN connection. If you believe that the tunnel credentials for
// your VPN connection have been compromised, you can delete the VPN connection
// and create a new one that has new keys, without needing to delete the VPC
// or virtual private gateway. If you create a new VPN connection, you must
// reconfigure the customer gateway device using the new configuration information
// returned with the new VPN connection ID.
//
// For certificate-based authentication, delete all Certificate Manager (ACM)
// private certificates used for the Amazon Web Services-side tunnel endpoints
// for the VPN connection before deleting the VPN connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnConnection for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnection
func (c *EC2) DeleteVpnConnection(input *DeleteVpnConnectionInput) (*DeleteVpnConnectionOutput, error) {
	req, out := c.DeleteVpnConnectionRequest(input)
	return out, req.Send()
}

// DeleteVpnConnectionWithContext is the same as DeleteVpnConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpnConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpnConnectionWithContext(ctx aws.Context, input *DeleteVpnConnectionInput, opts ...request.Option) (*DeleteVpnConnectionOutput, error) {
	req, out := c.DeleteVpnConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpnConnectionRoute = "DeleteVpnConnectionRoute"

// DeleteVpnConnectionRouteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnConnectionRoute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpnConnectionRoute for more information on using the DeleteVpnConnectionRoute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpnConnectionRouteRequest method.
//	req, resp := client.DeleteVpnConnectionRouteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute
func (c *EC2) DeleteVpnConnectionRouteRequest(input *DeleteVpnConnectionRouteInput) (req *request.Request, output *DeleteVpnConnectionRouteOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnConnectionRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnConnectionRouteInput{}
	}

	output = &DeleteVpnConnectionRouteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnConnectionRoute API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified static route associated with a VPN connection between
// an existing virtual private gateway and a VPN customer gateway. The static
// route allows traffic to be routed from the virtual private gateway to the
// VPN customer gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnConnectionRoute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRoute
func (c *EC2) DeleteVpnConnectionRoute(input *DeleteVpnConnectionRouteInput) (*DeleteVpnConnectionRouteOutput, error) {
	req, out := c.DeleteVpnConnectionRouteRequest(input)
	return out, req.Send()
}

// DeleteVpnConnectionRouteWithContext is the same as DeleteVpnConnectionRoute with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpnConnectionRoute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpnConnectionRouteWithContext(ctx aws.Context, input *DeleteVpnConnectionRouteInput, opts ...request.Option) (*DeleteVpnConnectionRouteOutput, error) {
	req, out := c.DeleteVpnConnectionRouteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpnGateway = "DeleteVpnGateway"

// DeleteVpnGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpnGateway operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpnGateway for more information on using the DeleteVpnGateway
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpnGatewayRequest method.
//	req, resp := client.DeleteVpnGatewayRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway
func (c *EC2) DeleteVpnGatewayRequest(input *DeleteVpnGatewayInput) (req *request.Request, output *DeleteVpnGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteVpnGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpnGatewayInput{}
	}

	output = &DeleteVpnGatewayOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpnGateway API operation for Amazon Elastic Compute Cloud.
//
// Deletes the specified virtual private gateway. You must first detach the
// virtual private gateway from the VPC. Note that you don't need to delete
// the virtual private gateway if you plan to delete and recreate the VPN connection
// between your VPC and your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeleteVpnGateway for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGateway
func (c *EC2) DeleteVpnGateway(input *DeleteVpnGatewayInput) (*DeleteVpnGatewayOutput, error) {
	req, out := c.DeleteVpnGatewayRequest(input)
	return out, req.Send()
}

// DeleteVpnGatewayWithContext is the same as DeleteVpnGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpnGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeleteVpnGatewayWithContext(ctx aws.Context, input *DeleteVpnGatewayInput, opts ...request.Option) (*DeleteVpnGatewayOutput, error) {
	req, out := c.DeleteVpnGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprovisionByoipCidr = "DeprovisionByoipCidr"

// DeprovisionByoipCidrRequest generates a "aws/request.Request" representing the
// client's request for the DeprovisionByoipCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprovisionByoipCidr for more information on using the DeprovisionByoipCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeprovisionByoipCidrRequest method.
//	req, resp := client.DeprovisionByoipCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr
func (c *EC2) DeprovisionByoipCidrRequest(input *DeprovisionByoipCidrInput) (req *request.Request, output *DeprovisionByoipCidrOutput) {
	op := &request.Operation{
		Name:       opDeprovisionByoipCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprovisionByoipCidrInput{}
	}

	output = &DeprovisionByoipCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeprovisionByoipCidr API operation for Amazon Elastic Compute Cloud.
//
// Releases the specified address range that you provisioned for use with your
// Amazon Web Services resources through bring your own IP addresses (BYOIP)
// and deletes the corresponding address pool.
//
// Before you can release an address range, you must stop advertising it using
// WithdrawByoipCidr and you must not have any IP addresses allocated from its
// address range.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeprovisionByoipCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidr
func (c *EC2) DeprovisionByoipCidr(input *DeprovisionByoipCidrInput) (*DeprovisionByoipCidrOutput, error) {
	req, out := c.DeprovisionByoipCidrRequest(input)
	return out, req.Send()
}

// DeprovisionByoipCidrWithContext is the same as DeprovisionByoipCidr with the addition of
// the ability to pass a context and additional request options.
//
// See DeprovisionByoipCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeprovisionByoipCidrWithContext(ctx aws.Context, input *DeprovisionByoipCidrInput, opts ...request.Option) (*DeprovisionByoipCidrOutput, error) {
	req, out := c.DeprovisionByoipCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprovisionIpamByoasn = "DeprovisionIpamByoasn"

// DeprovisionIpamByoasnRequest generates a "aws/request.Request" representing the
// client's request for the DeprovisionIpamByoasn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprovisionIpamByoasn for more information on using the DeprovisionIpamByoasn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeprovisionIpamByoasnRequest method.
//	req, resp := client.DeprovisionIpamByoasnRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasn
func (c *EC2) DeprovisionIpamByoasnRequest(input *DeprovisionIpamByoasnInput) (req *request.Request, output *DeprovisionIpamByoasnOutput) {
	op := &request.Operation{
		Name:       opDeprovisionIpamByoasn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprovisionIpamByoasnInput{}
	}

	output = &DeprovisionIpamByoasnOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeprovisionIpamByoasn API operation for Amazon Elastic Compute Cloud.
//
// Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services
// account. This action can only be called after any BYOIP CIDR associations
// are removed from your Amazon Web Services account with DisassociateIpamByoasn
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIpamByoasn.html).
// For more information, see Tutorial: Bring your ASN to IPAM (https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html)
// in the Amazon VPC IPAM guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeprovisionIpamByoasn for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamByoasn
func (c *EC2) DeprovisionIpamByoasn(input *DeprovisionIpamByoasnInput) (*DeprovisionIpamByoasnOutput, error) {
	req, out := c.DeprovisionIpamByoasnRequest(input)
	return out, req.Send()
}

// DeprovisionIpamByoasnWithContext is the same as DeprovisionIpamByoasn with the addition of
// the ability to pass a context and additional request options.
//
// See DeprovisionIpamByoasn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeprovisionIpamByoasnWithContext(ctx aws.Context, input *DeprovisionIpamByoasnInput, opts ...request.Option) (*DeprovisionIpamByoasnOutput, error) {
	req, out := c.DeprovisionIpamByoasnRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprovisionIpamPoolCidr = "DeprovisionIpamPoolCidr"

// DeprovisionIpamPoolCidrRequest generates a "aws/request.Request" representing the
// client's request for the DeprovisionIpamPoolCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprovisionIpamPoolCidr for more information on using the DeprovisionIpamPoolCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeprovisionIpamPoolCidrRequest method.
//	req, resp := client.DeprovisionIpamPoolCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr
func (c *EC2) DeprovisionIpamPoolCidrRequest(input *DeprovisionIpamPoolCidrInput) (req *request.Request, output *DeprovisionIpamPoolCidrOutput) {
	op := &request.Operation{
		Name:       opDeprovisionIpamPoolCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprovisionIpamPoolCidrInput{}
	}

	output = &DeprovisionIpamPoolCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeprovisionIpamPoolCidr API operation for Amazon Elastic Compute Cloud.
//
// Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR
// from a pool that has a source pool, the CIDR is recycled back into the source
// pool. For more information, see Deprovision pool CIDRs (https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html)
// in the Amazon VPC IPAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeprovisionIpamPoolCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionIpamPoolCidr
func (c *EC2) DeprovisionIpamPoolCidr(input *DeprovisionIpamPoolCidrInput) (*DeprovisionIpamPoolCidrOutput, error) {
	req, out := c.DeprovisionIpamPoolCidrRequest(input)
	return out, req.Send()
}

// DeprovisionIpamPoolCidrWithContext is the same as DeprovisionIpamPoolCidr with the addition of
// the ability to pass a context and additional request options.
//
// See DeprovisionIpamPoolCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeprovisionIpamPoolCidrWithContext(ctx aws.Context, input *DeprovisionIpamPoolCidrInput, opts ...request.Option) (*DeprovisionIpamPoolCidrOutput, error) {
	req, out := c.DeprovisionIpamPoolCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprovisionPublicIpv4PoolCidr = "DeprovisionPublicIpv4PoolCidr"

// DeprovisionPublicIpv4PoolCidrRequest generates a "aws/request.Request" representing the
// client's request for the DeprovisionPublicIpv4PoolCidr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprovisionPublicIpv4PoolCidr for more information on using the DeprovisionPublicIpv4PoolCidr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeprovisionPublicIpv4PoolCidrRequest method.
//	req, resp := client.DeprovisionPublicIpv4PoolCidrRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr
func (c *EC2) DeprovisionPublicIpv4PoolCidrRequest(input *DeprovisionPublicIpv4PoolCidrInput) (req *request.Request, output *DeprovisionPublicIpv4PoolCidrOutput) {
	op := &request.Operation{
		Name:       opDeprovisionPublicIpv4PoolCidr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprovisionPublicIpv4PoolCidrInput{}
	}

	output = &DeprovisionPublicIpv4PoolCidrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeprovisionPublicIpv4PoolCidr API operation for Amazon Elastic Compute Cloud.
//
// Deprovision a CIDR from a public IPv4 pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeprovisionPublicIpv4PoolCidr for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionPublicIpv4PoolCidr
func (c *EC2) DeprovisionPublicIpv4PoolCidr(input *DeprovisionPublicIpv4PoolCidrInput) (*DeprovisionPublicIpv4PoolCidrOutput, error) {
	req, out := c.DeprovisionPublicIpv4PoolCidrRequest(input)
	return out, req.Send()
}

// DeprovisionPublicIpv4PoolCidrWithContext is the same as DeprovisionPublicIpv4PoolCidr with the addition of
// the ability to pass a context and additional request options.
//
// See DeprovisionPublicIpv4PoolCidr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeprovisionPublicIpv4PoolCidrWithContext(ctx aws.Context, input *DeprovisionPublicIpv4PoolCidrInput, opts ...request.Option) (*DeprovisionPublicIpv4PoolCidrOutput, error) {
	req, out := c.DeprovisionPublicIpv4PoolCidrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterImage = "DeregisterImage"

// DeregisterImageRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterImage for more information on using the DeregisterImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterImageRequest method.
//	req, resp := client.DeregisterImageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage
func (c *EC2) DeregisterImageRequest(input *DeregisterImageInput) (req *request.Request, output *DeregisterImageOutput) {
	op := &request.Operation{
		Name:       opDeregisterImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterImageInput{}
	}

	output = &DeregisterImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(ec2query.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterImage API operation for Amazon Elastic Compute Cloud.
//
// Deregisters the specified AMI. After you deregister an AMI, it can't be used
// to launch new instances.
//
// If you deregister an AMI that matches a Recycle Bin retention rule, the AMI
// is retained in the Recycle Bin for the specified retention period. For more
// information, see Recycle Bin (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin.html)
// in the Amazon EC2 User Guide.
//
// When you deregister an AMI, it doesn't affect any instances that you've already
// launched from the AMI. You'll continue to incur usage costs for those instances
// until you terminate them.
//
// When you deregister an Amazon EBS-backed AMI, it doesn't affect the snapshot
// that was created for the root volume of the instance during the AMI creation
// process. When you deregister an instance store-backed AMI, it doesn't affect
// the files that you uploaded to Amazon S3 when you created the AMI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterImage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImage
func (c *EC2) DeregisterImage(input *DeregisterImageInput) (*DeregisterImageOutput, error) {
	req, out := c.DeregisterImageRequest(input)
	return out, req.Send()
}

// DeregisterImageWithContext is the same as DeregisterImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterImageWithContext(ctx aws.Context, input *DeregisterImageInput, opts ...request.Option) (*DeregisterImageOutput, error) {
	req, out := c.DeregisterImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterInstanceEventNotificationAttributes = "DeregisterInstanceEventNotificationAttributes"

// DeregisterInstanceEventNotificationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterInstanceEventNotificationAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterInstanceEventNotificationAttributes for more information on using the DeregisterInstanceEventNotificationAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterInstanceEventNotificationAttributesRequest method.
//	req, resp := client.DeregisterInstanceEventNotificationAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes
func (c *EC2) DeregisterInstanceEventNotificationAttributesRequest(input *DeregisterInstanceEventNotificationAttributesInput) (req *request.Request, output *DeregisterInstanceEventNotificationAttributesOutput) {
	op := &request.Operation{
		Name:       opDeregisterInstanceEventNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstanceEventNotificationAttributesInput{}
	}

	output = &DeregisterInstanceEventNotificationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterInstanceEventNotificationAttributes API operation for Amazon Elastic Compute Cloud.
//
// Deregisters tag keys to prevent tags that have the specified tag keys from
// being included in scheduled event notifications for resources in the Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterInstanceEventNotificationAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributes
func (c *EC2) DeregisterInstanceEventNotificationAttributes(input *DeregisterInstanceEventNotificationAttributesInput) (*DeregisterInstanceEventNotificationAttributesOutput, error) {
	req, out := c.DeregisterInstanceEventNotificationAttributesRequest(input)
	return out, req.Send()
}

// DeregisterInstanceEventNotificationAttributesWithContext is the same as DeregisterInstanceEventNotificationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterInstanceEventNotificationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterInstanceEventNotificationAttributesWithContext(ctx aws.Context, input *DeregisterInstanceEventNotificationAttributesInput, opts ...request.Option) (*DeregisterInstanceEventNotificationAttributesOutput, error) {
	req, out := c.DeregisterInstanceEventNotificationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTransitGatewayMulticastGroupMembers = "DeregisterTransitGatewayMulticastGroupMembers"

// DeregisterTransitGatewayMulticastGroupMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTransitGatewayMulticastGroupMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTransitGatewayMulticastGroupMembers for more information on using the DeregisterTransitGatewayMulticastGroupMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterTransitGatewayMulticastGroupMembersRequest method.
//	req, resp := client.DeregisterTransitGatewayMulticastGroupMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers
func (c *EC2) DeregisterTransitGatewayMulticastGroupMembersRequest(input *DeregisterTransitGatewayMulticastGroupMembersInput) (req *request.Request, output *DeregisterTransitGatewayMulticastGroupMembersOutput) {
	op := &request.Operation{
		Name:       opDeregisterTransitGatewayMulticastGroupMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTransitGatewayMulticastGroupMembersInput{}
	}

	output = &DeregisterTransitGatewayMulticastGroupMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTransitGatewayMulticastGroupMembers API operation for Amazon Elastic Compute Cloud.
//
// Deregisters the specified members (network interfaces) from the transit gateway
// multicast group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterTransitGatewayMulticastGroupMembers for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembers
func (c *EC2) DeregisterTransitGatewayMulticastGroupMembers(input *DeregisterTransitGatewayMulticastGroupMembersInput) (*DeregisterTransitGatewayMulticastGroupMembersOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupMembersRequest(input)
	return out, req.Send()
}

// DeregisterTransitGatewayMulticastGroupMembersWithContext is the same as DeregisterTransitGatewayMulticastGroupMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTransitGatewayMulticastGroupMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterTransitGatewayMulticastGroupMembersWithContext(ctx aws.Context, input *DeregisterTransitGatewayMulticastGroupMembersInput, opts ...request.Option) (*DeregisterTransitGatewayMulticastGroupMembersOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTransitGatewayMulticastGroupSources = "DeregisterTransitGatewayMulticastGroupSources"

// DeregisterTransitGatewayMulticastGroupSourcesRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTransitGatewayMulticastGroupSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTransitGatewayMulticastGroupSources for more information on using the DeregisterTransitGatewayMulticastGroupSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterTransitGatewayMulticastGroupSourcesRequest method.
//	req, resp := client.DeregisterTransitGatewayMulticastGroupSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources
func (c *EC2) DeregisterTransitGatewayMulticastGroupSourcesRequest(input *DeregisterTransitGatewayMulticastGroupSourcesInput) (req *request.Request, output *DeregisterTransitGatewayMulticastGroupSourcesOutput) {
	op := &request.Operation{
		Name:       opDeregisterTransitGatewayMulticastGroupSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTransitGatewayMulticastGroupSourcesInput{}
	}

	output = &DeregisterTransitGatewayMulticastGroupSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTransitGatewayMulticastGroupSources API operation for Amazon Elastic Compute Cloud.
//
// Deregisters the specified sources (network interfaces) from the transit gateway
// multicast group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DeregisterTransitGatewayMulticastGroupSources for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources
func (c *EC2) DeregisterTransitGatewayMulticastGroupSources(input *DeregisterTransitGatewayMulticastGroupSourcesInput) (*DeregisterTransitGatewayMulticastGroupSourcesOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupSourcesRequest(input)
	return out, req.Send()
}

// DeregisterTransitGatewayMulticastGroupSourcesWithContext is the same as DeregisterTransitGatewayMulticastGroupSources with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTransitGatewayMulticastGroupSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DeregisterTransitGatewayMulticastGroupSourcesWithContext(ctx aws.Context, input *DeregisterTransitGatewayMulticastGroupSourcesInput, opts ...request.Option) (*DeregisterTransitGatewayMulticastGroupSourcesOutput, error) {
	req, out := c.DeregisterTransitGatewayMulticastGroupSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountAttributesRequest method.
//	req, resp := client.DescribeAccountAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes
func (c *EC2) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for Amazon Elastic Compute Cloud.
//
// Describes attributes of your Amazon Web Services account. The following are
// the supported account attributes:
//
//   - default-vpc: The ID of the default VPC for your account, or none.
//
//   - max-instances: This attribute is no longer supported. The returned value
//     does not reflect your actual vCPU limit for running On-Demand Instances.
//     For more information, see On-Demand Instance Limits (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits)
//     in the Amazon Elastic Compute Cloud User Guide.
//
//   - max-elastic-ips: The maximum number of Elastic IP addresses that you
//     can allocate.
//
//   - supported-platforms: This attribute is deprecated.
//
//   - vpc-max-elastic-ips: The maximum number of Elastic IP addresses that
//     you can allocate.
//
//   - vpc-max-security-groups-per-interface: The maximum number of security
//     groups that you can assign to a network interface.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear
// in a particular order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributes
func (c *EC2) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddressTransfers = "DescribeAddressTransfers"

// DescribeAddressTransfersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddressTransfers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddressTransfers for more information on using the DescribeAddressTransfers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddressTransfersRequest method.
//	req, resp := client.DescribeAddressTransfersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressTransfers
func (c *EC2) DescribeAddressTransfersRequest(input *DescribeAddressTransfersInput) (req *request.Request, output *DescribeAddressTransfersOutput) {
	op := &request.Operation{
		Name:       opDescribeAddressTransfers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddressTransfersInput{}
	}

	output = &DescribeAddressTransfersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddressTransfers API operation for Amazon Elastic Compute Cloud.
//
// Describes an Elastic IP address transfer. For more information, see Transfer
// Elastic IP addresses (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#transfer-EIPs-intro)
// in the Amazon Virtual Private Cloud User Guide.
//
// When you transfer an Elastic IP address, there is a two-step handshake between
// the source and transfer Amazon Web Services accounts. When the source account
// starts the transfer, the transfer account has seven days to accept the Elastic
// IP address transfer. During those seven days, the source account can view
// the pending transfer by using this action. After seven days, the transfer
// expires and ownership of the Elastic IP address returns to the source account.
// Accepted transfers are visible to the source account for three days after
// the transfers have been accepted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAddressTransfers for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressTransfers
func (c *EC2) DescribeAddressTransfers(input *DescribeAddressTransfersInput) (*DescribeAddressTransfersOutput, error) {
	req, out := c.DescribeAddressTransfersRequest(input)
	return out, req.Send()
}

// DescribeAddressTransfersWithContext is the same as DescribeAddressTransfers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddressTransfers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressTransfersWithContext(ctx aws.Context, input *DescribeAddressTransfersInput, opts ...request.Option) (*DescribeAddressTransfersOutput, error) {
	req, out := c.DescribeAddressTransfersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAddressTransfersPages iterates over the pages of a DescribeAddressTransfers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddressTransfers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAddressTransfers operation.
//	pageNum := 0
//	err := client.DescribeAddressTransfersPages(params,
//	    func(page *ec2.DescribeAddressTransfersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeAddressTransfersPages(input *DescribeAddressTransfersInput, fn func(*DescribeAddressTransfersOutput, bool) bool) error {
	return c.DescribeAddressTransfersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAddressTransfersPagesWithContext same as DescribeAddressTransfersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressTransfersPagesWithContext(ctx aws.Context, input *DescribeAddressTransfersInput, fn func(*DescribeAddressTransfersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAddressTransfersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAddressTransfersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAddressTransfersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddresses for more information on using the DescribeAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddressesRequest method.
//	req, resp := client.DescribeAddressesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses
func (c *EC2) DescribeAddressesRequest(input *DescribeAddressesInput) (req *request.Request, output *DescribeAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	output = &DescribeAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddresses API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified Elastic IP addresses or all of your Elastic IP addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAddresses for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddresses
func (c *EC2) DescribeAddresses(input *DescribeAddressesInput) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	return out, req.Send()
}

// DescribeAddressesWithContext is the same as DescribeAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressesWithContext(ctx aws.Context, input *DescribeAddressesInput, opts ...request.Option) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddressesAttribute = "DescribeAddressesAttribute"

// DescribeAddressesAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddressesAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddressesAttribute for more information on using the DescribeAddressesAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddressesAttributeRequest method.
//	req, resp := client.DescribeAddressesAttributeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute
func (c *EC2) DescribeAddressesAttributeRequest(input *DescribeAddressesAttributeInput) (req *request.Request, output *DescribeAddressesAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeAddressesAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddressesAttributeInput{}
	}

	output = &DescribeAddressesAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddressesAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the attributes of the specified Elastic IP addresses. For requirements,
// see Using reverse DNS for email applications (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAddressesAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttribute
func (c *EC2) DescribeAddressesAttribute(input *DescribeAddressesAttributeInput) (*DescribeAddressesAttributeOutput, error) {
	req, out := c.DescribeAddressesAttributeRequest(input)
	return out, req.Send()
}

// DescribeAddressesAttributeWithContext is the same as DescribeAddressesAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddressesAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressesAttributeWithContext(ctx aws.Context, input *DescribeAddressesAttributeInput, opts ...request.Option) (*DescribeAddressesAttributeOutput, error) {
	req, out := c.DescribeAddressesAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAddressesAttributePages iterates over the pages of a DescribeAddressesAttribute operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddressesAttribute method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAddressesAttribute operation.
//	pageNum := 0
//	err := client.DescribeAddressesAttributePages(params,
//	    func(page *ec2.DescribeAddressesAttributeOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeAddressesAttributePages(input *DescribeAddressesAttributeInput, fn func(*DescribeAddressesAttributeOutput, bool) bool) error {
	return c.DescribeAddressesAttributePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAddressesAttributePagesWithContext same as DescribeAddressesAttributePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAddressesAttributePagesWithContext(ctx aws.Context, input *DescribeAddressesAttributeInput, fn func(*DescribeAddressesAttributeOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAddressesAttributeInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAddressesAttributeRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAddressesAttributeOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAggregateIdFormat = "DescribeAggregateIdFormat"

// DescribeAggregateIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregateIdFormat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregateIdFormat for more information on using the DescribeAggregateIdFormat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAggregateIdFormatRequest method.
//	req, resp := client.DescribeAggregateIdFormatRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat
func (c *EC2) DescribeAggregateIdFormatRequest(input *DescribeAggregateIdFormatInput) (req *request.Request, output *DescribeAggregateIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregateIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregateIdFormatInput{}
	}

	output = &DescribeAggregateIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregateIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the longer ID format settings for all resource types in a specific
// Region. This request is useful for performing a quick audit to determine
// whether a specific Region is fully opted in for longer IDs (17-character
// IDs).
//
// This request only returns information about resource types that support longer
// IDs.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAggregateIdFormat for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormat
func (c *EC2) DescribeAggregateIdFormat(input *DescribeAggregateIdFormatInput) (*DescribeAggregateIdFormatOutput, error) {
	req, out := c.DescribeAggregateIdFormatRequest(input)
	return out, req.Send()
}

// DescribeAggregateIdFormatWithContext is the same as DescribeAggregateIdFormat with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregateIdFormat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAggregateIdFormatWithContext(ctx aws.Context, input *DescribeAggregateIdFormatInput, opts ...request.Option) (*DescribeAggregateIdFormatOutput, error) {
	req, out := c.DescribeAggregateIdFormatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAvailabilityZones = "DescribeAvailabilityZones"

// DescribeAvailabilityZonesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAvailabilityZones operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAvailabilityZones for more information on using the DescribeAvailabilityZones
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAvailabilityZonesRequest method.
//	req, resp := client.DescribeAvailabilityZonesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones
func (c *EC2) DescribeAvailabilityZonesRequest(input *DescribeAvailabilityZonesInput) (req *request.Request, output *DescribeAvailabilityZonesOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailabilityZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityZonesInput{}
	}

	output = &DescribeAvailabilityZonesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAvailabilityZones API operation for Amazon Elastic Compute Cloud.
//
// Describes the Availability Zones, Local Zones, and Wavelength Zones that
// are available to you. If there is an event impacting a zone, you can use
// this request to view the state and any provided messages for that zone.
//
// For more information about Availability Zones, Local Zones, and Wavelength
// Zones, see Regions and zones (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear
// in a particular order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAvailabilityZones for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZones
func (c *EC2) DescribeAvailabilityZones(input *DescribeAvailabilityZonesInput) (*DescribeAvailabilityZonesOutput, error) {
	req, out := c.DescribeAvailabilityZonesRequest(input)
	return out, req.Send()
}

// DescribeAvailabilityZonesWithContext is the same as DescribeAvailabilityZones with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAvailabilityZones for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAvailabilityZonesWithContext(ctx aws.Context, input *DescribeAvailabilityZonesInput, opts ...request.Option) (*DescribeAvailabilityZonesOutput, error) {
	req, out := c.DescribeAvailabilityZonesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAwsNetworkPerformanceMetricSubscriptions = "DescribeAwsNetworkPerformanceMetricSubscriptions"

// DescribeAwsNetworkPerformanceMetricSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAwsNetworkPerformanceMetricSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAwsNetworkPerformanceMetricSubscriptions for more information on using the DescribeAwsNetworkPerformanceMetricSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAwsNetworkPerformanceMetricSubscriptionsRequest method.
//	req, resp := client.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAwsNetworkPerformanceMetricSubscriptions
func (c *EC2) DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(input *DescribeAwsNetworkPerformanceMetricSubscriptionsInput) (req *request.Request, output *DescribeAwsNetworkPerformanceMetricSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAwsNetworkPerformanceMetricSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAwsNetworkPerformanceMetricSubscriptionsInput{}
	}

	output = &DescribeAwsNetworkPerformanceMetricSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAwsNetworkPerformanceMetricSubscriptions API operation for Amazon Elastic Compute Cloud.
//
// Describes the current Infrastructure Performance metric subscriptions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeAwsNetworkPerformanceMetricSubscriptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAwsNetworkPerformanceMetricSubscriptions
func (c *EC2) DescribeAwsNetworkPerformanceMetricSubscriptions(input *DescribeAwsNetworkPerformanceMetricSubscriptionsInput) (*DescribeAwsNetworkPerformanceMetricSubscriptionsOutput, error) {
	req, out := c.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeAwsNetworkPerformanceMetricSubscriptionsWithContext is the same as DescribeAwsNetworkPerformanceMetricSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAwsNetworkPerformanceMetricSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAwsNetworkPerformanceMetricSubscriptionsWithContext(ctx aws.Context, input *DescribeAwsNetworkPerformanceMetricSubscriptionsInput, opts ...request.Option) (*DescribeAwsNetworkPerformanceMetricSubscriptionsOutput, error) {
	req, out := c.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAwsNetworkPerformanceMetricSubscriptionsPages iterates over the pages of a DescribeAwsNetworkPerformanceMetricSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAwsNetworkPerformanceMetricSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAwsNetworkPerformanceMetricSubscriptions operation.
//	pageNum := 0
//	err := client.DescribeAwsNetworkPerformanceMetricSubscriptionsPages(params,
//	    func(page *ec2.DescribeAwsNetworkPerformanceMetricSubscriptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeAwsNetworkPerformanceMetricSubscriptionsPages(input *DescribeAwsNetworkPerformanceMetricSubscriptionsInput, fn func(*DescribeAwsNetworkPerformanceMetricSubscriptionsOutput, bool) bool) error {
	return c.DescribeAwsNetworkPerformanceMetricSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAwsNetworkPerformanceMetricSubscriptionsPagesWithContext same as DescribeAwsNetworkPerformanceMetricSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeAwsNetworkPerformanceMetricSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeAwsNetworkPerformanceMetricSubscriptionsInput, fn func(*DescribeAwsNetworkPerformanceMetricSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAwsNetworkPerformanceMetricSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAwsNetworkPerformanceMetricSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeBundleTasks = "DescribeBundleTasks"

// DescribeBundleTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBundleTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBundleTasks for more information on using the DescribeBundleTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBundleTasksRequest method.
//	req, resp := client.DescribeBundleTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks
func (c *EC2) DescribeBundleTasksRequest(input *DescribeBundleTasksInput) (req *request.Request, output *DescribeBundleTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeBundleTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBundleTasksInput{}
	}

	output = &DescribeBundleTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBundleTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified bundle tasks or all of your bundle tasks.
//
// Completed bundle tasks are listed for only a limited time. If your bundle
// task is no longer in the list, you can still register an AMI from it. Just
// use RegisterImage with the Amazon S3 bucket name and image manifest name
// you provided to the bundle task.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear
// in a particular order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeBundleTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasks
func (c *EC2) DescribeBundleTasks(input *DescribeBundleTasksInput) (*DescribeBundleTasksOutput, error) {
	req, out := c.DescribeBundleTasksRequest(input)
	return out, req.Send()
}

// DescribeBundleTasksWithContext is the same as DescribeBundleTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBundleTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeBundleTasksWithContext(ctx aws.Context, input *DescribeBundleTasksInput, opts ...request.Option) (*DescribeBundleTasksOutput, error) {
	req, out := c.DescribeBundleTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeByoipCidrs = "DescribeByoipCidrs"

// DescribeByoipCidrsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeByoipCidrs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeByoipCidrs for more information on using the DescribeByoipCidrs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeByoipCidrsRequest method.
//	req, resp := client.DescribeByoipCidrsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs
func (c *EC2) DescribeByoipCidrsRequest(input *DescribeByoipCidrsInput) (req *request.Request, output *DescribeByoipCidrsOutput) {
	op := &request.Operation{
		Name:       opDescribeByoipCidrs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeByoipCidrsInput{}
	}

	output = &DescribeByoipCidrsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeByoipCidrs API operation for Amazon Elastic Compute Cloud.
//
// Describes the IP address ranges that were specified in calls to ProvisionByoipCidr.
//
// To describe the address pools that were created when you provisioned the
// address ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeByoipCidrs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrs
func (c *EC2) DescribeByoipCidrs(input *DescribeByoipCidrsInput) (*DescribeByoipCidrsOutput, error) {
	req, out := c.DescribeByoipCidrsRequest(input)
	return out, req.Send()
}

// DescribeByoipCidrsWithContext is the same as DescribeByoipCidrs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeByoipCidrs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeByoipCidrsWithContext(ctx aws.Context, input *DescribeByoipCidrsInput, opts ...request.Option) (*DescribeByoipCidrsOutput, error) {
	req, out := c.DescribeByoipCidrsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeByoipCidrsPages iterates over the pages of a DescribeByoipCidrs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeByoipCidrs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeByoipCidrs operation.
//	pageNum := 0
//	err := client.DescribeByoipCidrsPages(params,
//	    func(page *ec2.DescribeByoipCidrsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeByoipCidrsPages(input *DescribeByoipCidrsInput, fn func(*DescribeByoipCidrsOutput, bool) bool) error {
	return c.DescribeByoipCidrsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeByoipCidrsPagesWithContext same as DescribeByoipCidrsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeByoipCidrsPagesWithContext(ctx aws.Context, input *DescribeByoipCidrsInput, fn func(*DescribeByoipCidrsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeByoipCidrsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeByoipCidrsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeByoipCidrsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCapacityBlockOfferings = "DescribeCapacityBlockOfferings"

// DescribeCapacityBlockOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCapacityBlockOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCapacityBlockOfferings for more information on using the DescribeCapacityBlockOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCapacityBlockOfferingsRequest method.
//	req, resp := client.DescribeCapacityBlockOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockOfferings
func (c *EC2) DescribeCapacityBlockOfferingsRequest(input *DescribeCapacityBlockOfferingsInput) (req *request.Request, output *DescribeCapacityBlockOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeCapacityBlockOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCapacityBlockOfferingsInput{}
	}

	output = &DescribeCapacityBlockOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCapacityBlockOfferings API operation for Amazon Elastic Compute Cloud.
//
// Describes Capacity Block offerings available for purchase in the Amazon Web
// Services Region that you're currently using. With Capacity Blocks, you purchase
// a specific instance type for a period of time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCapacityBlockOfferings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityBlockOfferings
func (c *EC2) DescribeCapacityBlockOfferings(input *DescribeCapacityBlockOfferingsInput) (*DescribeCapacityBlockOfferingsOutput, error) {
	req, out := c.DescribeCapacityBlockOfferingsRequest(input)
	return out, req.Send()
}

// DescribeCapacityBlockOfferingsWithContext is the same as DescribeCapacityBlockOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCapacityBlockOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityBlockOfferingsWithContext(ctx aws.Context, input *DescribeCapacityBlockOfferingsInput, opts ...request.Option) (*DescribeCapacityBlockOfferingsOutput, error) {
	req, out := c.DescribeCapacityBlockOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCapacityBlockOfferingsPages iterates over the pages of a DescribeCapacityBlockOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCapacityBlockOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeCapacityBlockOfferings operation.
//	pageNum := 0
//	err := client.DescribeCapacityBlockOfferingsPages(params,
//	    func(page *ec2.DescribeCapacityBlockOfferingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeCapacityBlockOfferingsPages(input *DescribeCapacityBlockOfferingsInput, fn func(*DescribeCapacityBlockOfferingsOutput, bool) bool) error {
	return c.DescribeCapacityBlockOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCapacityBlockOfferingsPagesWithContext same as DescribeCapacityBlockOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityBlockOfferingsPagesWithContext(ctx aws.Context, input *DescribeCapacityBlockOfferingsInput, fn func(*DescribeCapacityBlockOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCapacityBlockOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCapacityBlockOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCapacityBlockOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCapacityReservationFleets = "DescribeCapacityReservationFleets"

// DescribeCapacityReservationFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCapacityReservationFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCapacityReservationFleets for more information on using the DescribeCapacityReservationFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCapacityReservationFleetsRequest method.
//	req, resp := client.DescribeCapacityReservationFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets
func (c *EC2) DescribeCapacityReservationFleetsRequest(input *DescribeCapacityReservationFleetsInput) (req *request.Request, output *DescribeCapacityReservationFleetsOutput) {
	op := &request.Operation{
		Name:       opDescribeCapacityReservationFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCapacityReservationFleetsInput{}
	}

	output = &DescribeCapacityReservationFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCapacityReservationFleets API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more Capacity Reservation Fleets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCapacityReservationFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationFleets
func (c *EC2) DescribeCapacityReservationFleets(input *DescribeCapacityReservationFleetsInput) (*DescribeCapacityReservationFleetsOutput, error) {
	req, out := c.DescribeCapacityReservationFleetsRequest(input)
	return out, req.Send()
}

// DescribeCapacityReservationFleetsWithContext is the same as DescribeCapacityReservationFleets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCapacityReservationFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityReservationFleetsWithContext(ctx aws.Context, input *DescribeCapacityReservationFleetsInput, opts ...request.Option) (*DescribeCapacityReservationFleetsOutput, error) {
	req, out := c.DescribeCapacityReservationFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCapacityReservationFleetsPages iterates over the pages of a DescribeCapacityReservationFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCapacityReservationFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeCapacityReservationFleets operation.
//	pageNum := 0
//	err := client.DescribeCapacityReservationFleetsPages(params,
//	    func(page *ec2.DescribeCapacityReservationFleetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeCapacityReservationFleetsPages(input *DescribeCapacityReservationFleetsInput, fn func(*DescribeCapacityReservationFleetsOutput, bool) bool) error {
	return c.DescribeCapacityReservationFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCapacityReservationFleetsPagesWithContext same as DescribeCapacityReservationFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityReservationFleetsPagesWithContext(ctx aws.Context, input *DescribeCapacityReservationFleetsInput, fn func(*DescribeCapacityReservationFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCapacityReservationFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCapacityReservationFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCapacityReservationFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCapacityReservations = "DescribeCapacityReservations"

// DescribeCapacityReservationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCapacityReservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCapacityReservations for more information on using the DescribeCapacityReservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCapacityReservationsRequest method.
//	req, resp := client.DescribeCapacityReservationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations
func (c *EC2) DescribeCapacityReservationsRequest(input *DescribeCapacityReservationsInput) (req *request.Request, output *DescribeCapacityReservationsOutput) {
	op := &request.Operation{
		Name:       opDescribeCapacityReservations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCapacityReservationsInput{}
	}

	output = &DescribeCapacityReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCapacityReservations API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your Capacity Reservations. The results describe
// only the Capacity Reservations in the Amazon Web Services Region that you're
// currently using.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCapacityReservations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservations
func (c *EC2) DescribeCapacityReservations(input *DescribeCapacityReservationsInput) (*DescribeCapacityReservationsOutput, error) {
	req, out := c.DescribeCapacityReservationsRequest(input)
	return out, req.Send()
}

// DescribeCapacityReservationsWithContext is the same as DescribeCapacityReservations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCapacityReservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityReservationsWithContext(ctx aws.Context, input *DescribeCapacityReservationsInput, opts ...request.Option) (*DescribeCapacityReservationsOutput, error) {
	req, out := c.DescribeCapacityReservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCapacityReservationsPages iterates over the pages of a DescribeCapacityReservations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCapacityReservations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeCapacityReservations operation.
//	pageNum := 0
//	err := client.DescribeCapacityReservationsPages(params,
//	    func(page *ec2.DescribeCapacityReservationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeCapacityReservationsPages(input *DescribeCapacityReservationsInput, fn func(*DescribeCapacityReservationsOutput, bool) bool) error {
	return c.DescribeCapacityReservationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCapacityReservationsPagesWithContext same as DescribeCapacityReservationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCapacityReservationsPagesWithContext(ctx aws.Context, input *DescribeCapacityReservationsInput, fn func(*DescribeCapacityReservationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCapacityReservationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCapacityReservationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCapacityReservationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCarrierGateways = "DescribeCarrierGateways"

// DescribeCarrierGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCarrierGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCarrierGateways for more information on using the DescribeCarrierGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCarrierGatewaysRequest method.
//	req, resp := client.DescribeCarrierGatewaysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways
func (c *EC2) DescribeCarrierGatewaysRequest(input *DescribeCarrierGatewaysInput) (req *request.Request, output *DescribeCarrierGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeCarrierGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCarrierGatewaysInput{}
	}

	output = &DescribeCarrierGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCarrierGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your carrier gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCarrierGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGateways
func (c *EC2) DescribeCarrierGateways(input *DescribeCarrierGatewaysInput) (*DescribeCarrierGatewaysOutput, error) {
	req, out := c.DescribeCarrierGatewaysRequest(input)
	return out, req.Send()
}

// DescribeCarrierGatewaysWithContext is the same as DescribeCarrierGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCarrierGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCarrierGatewaysWithContext(ctx aws.Context, input *DescribeCarrierGatewaysInput, opts ...request.Option) (*DescribeCarrierGatewaysOutput, error) {
	req, out := c.DescribeCarrierGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCarrierGatewaysPages iterates over the pages of a DescribeCarrierGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCarrierGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeCarrierGateways operation.
//	pageNum := 0
//	err := client.DescribeCarrierGatewaysPages(params,
//	    func(page *ec2.DescribeCarrierGatewaysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeCarrierGatewaysPages(input *DescribeCarrierGatewaysInput, fn func(*DescribeCarrierGatewaysOutput, bool) bool) error {
	return c.DescribeCarrierGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCarrierGatewaysPagesWithContext same as DescribeCarrierGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCarrierGatewaysPagesWithContext(ctx aws.Context, input *DescribeCarrierGatewaysInput, fn func(*DescribeCarrierGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCarrierGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCarrierGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCarrierGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClassicLinkInstances = "DescribeClassicLinkInstances"

// DescribeClassicLinkInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClassicLinkInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClassicLinkInstances for more information on using the DescribeClassicLinkInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClassicLinkInstancesRequest method.
//	req, resp := client.DescribeClassicLinkInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances
func (c *EC2) DescribeClassicLinkInstancesRequest(input *DescribeClassicLinkInstancesInput) (req *request.Request, output *DescribeClassicLinkInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeClassicLinkInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClassicLinkInstancesInput{}
	}

	output = &DescribeClassicLinkInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClassicLinkInstances API operation for Amazon Elastic Compute Cloud.
//
// This action is deprecated.
//
// Describes one or more of your linked EC2-Classic instances. This request
// only returns information about EC2-Classic instances linked to a VPC through
// ClassicLink. You cannot use this request to return information about other
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClassicLinkInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstances
func (c *EC2) DescribeClassicLinkInstances(input *DescribeClassicLinkInstancesInput) (*DescribeClassicLinkInstancesOutput, error) {
	req, out := c.DescribeClassicLinkInstancesRequest(input)
	return out, req.Send()
}

// DescribeClassicLinkInstancesWithContext is the same as DescribeClassicLinkInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClassicLinkInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClassicLinkInstancesWithContext(ctx aws.Context, input *DescribeClassicLinkInstancesInput, opts ...request.Option) (*DescribeClassicLinkInstancesOutput, error) {
	req, out := c.DescribeClassicLinkInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClassicLinkInstancesPages iterates over the pages of a DescribeClassicLinkInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClassicLinkInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeClassicLinkInstances operation.
//	pageNum := 0
//	err := client.DescribeClassicLinkInstancesPages(params,
//	    func(page *ec2.DescribeClassicLinkInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeClassicLinkInstancesPages(input *DescribeClassicLinkInstancesInput, fn func(*DescribeClassicLinkInstancesOutput, bool) bool) error {
	return c.DescribeClassicLinkInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClassicLinkInstancesPagesWithContext same as DescribeClassicLinkInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClassicLinkInstancesPagesWithContext(ctx aws.Context, input *DescribeClassicLinkInstancesInput, fn func(*DescribeClassicLinkInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClassicLinkInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClassicLinkInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClassicLinkInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnAuthorizationRules = "DescribeClientVpnAuthorizationRules"

// DescribeClientVpnAuthorizationRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnAuthorizationRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnAuthorizationRules for more information on using the DescribeClientVpnAuthorizationRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClientVpnAuthorizationRulesRequest method.
//	req, resp := client.DescribeClientVpnAuthorizationRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules
func (c *EC2) DescribeClientVpnAuthorizationRulesRequest(input *DescribeClientVpnAuthorizationRulesInput) (req *request.Request, output *DescribeClientVpnAuthorizationRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnAuthorizationRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnAuthorizationRulesInput{}
	}

	output = &DescribeClientVpnAuthorizationRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnAuthorizationRules API operation for Amazon Elastic Compute Cloud.
//
// Describes the authorization rules for a specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnAuthorizationRules for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRules
func (c *EC2) DescribeClientVpnAuthorizationRules(input *DescribeClientVpnAuthorizationRulesInput) (*DescribeClientVpnAuthorizationRulesOutput, error) {
	req, out := c.DescribeClientVpnAuthorizationRulesRequest(input)
	return out, req.Send()
}

// DescribeClientVpnAuthorizationRulesWithContext is the same as DescribeClientVpnAuthorizationRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnAuthorizationRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnAuthorizationRulesWithContext(ctx aws.Context, input *DescribeClientVpnAuthorizationRulesInput, opts ...request.Option) (*DescribeClientVpnAuthorizationRulesOutput, error) {
	req, out := c.DescribeClientVpnAuthorizationRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnAuthorizationRulesPages iterates over the pages of a DescribeClientVpnAuthorizationRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnAuthorizationRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeClientVpnAuthorizationRules operation.
//	pageNum := 0
//	err := client.DescribeClientVpnAuthorizationRulesPages(params,
//	    func(page *ec2.DescribeClientVpnAuthorizationRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeClientVpnAuthorizationRulesPages(input *DescribeClientVpnAuthorizationRulesInput, fn func(*DescribeClientVpnAuthorizationRulesOutput, bool) bool) error {
	return c.DescribeClientVpnAuthorizationRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnAuthorizationRulesPagesWithContext same as DescribeClientVpnAuthorizationRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnAuthorizationRulesPagesWithContext(ctx aws.Context, input *DescribeClientVpnAuthorizationRulesInput, fn func(*DescribeClientVpnAuthorizationRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnAuthorizationRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnAuthorizationRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnAuthorizationRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnConnections = "DescribeClientVpnConnections"

// DescribeClientVpnConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnConnections for more information on using the DescribeClientVpnConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClientVpnConnectionsRequest method.
//	req, resp := client.DescribeClientVpnConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections
func (c *EC2) DescribeClientVpnConnectionsRequest(input *DescribeClientVpnConnectionsInput) (req *request.Request, output *DescribeClientVpnConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnConnectionsInput{}
	}

	output = &DescribeClientVpnConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnConnections API operation for Amazon Elastic Compute Cloud.
//
// Describes active client connections and connections that have been terminated
// within the last 60 minutes for the specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnConnections for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnections
func (c *EC2) DescribeClientVpnConnections(input *DescribeClientVpnConnectionsInput) (*DescribeClientVpnConnectionsOutput, error) {
	req, out := c.DescribeClientVpnConnectionsRequest(input)
	return out, req.Send()
}

// DescribeClientVpnConnectionsWithContext is the same as DescribeClientVpnConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnConnectionsWithContext(ctx aws.Context, input *DescribeClientVpnConnectionsInput, opts ...request.Option) (*DescribeClientVpnConnectionsOutput, error) {
	req, out := c.DescribeClientVpnConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnConnectionsPages iterates over the pages of a DescribeClientVpnConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeClientVpnConnections operation.
//	pageNum := 0
//	err := client.DescribeClientVpnConnectionsPages(params,
//	    func(page *ec2.DescribeClientVpnConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeClientVpnConnectionsPages(input *DescribeClientVpnConnectionsInput, fn func(*DescribeClientVpnConnectionsOutput, bool) bool) error {
	return c.DescribeClientVpnConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnConnectionsPagesWithContext same as DescribeClientVpnConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnConnectionsPagesWithContext(ctx aws.Context, input *DescribeClientVpnConnectionsInput, fn func(*DescribeClientVpnConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnEndpoints = "DescribeClientVpnEndpoints"

// DescribeClientVpnEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnEndpoints for more information on using the DescribeClientVpnEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClientVpnEndpointsRequest method.
//	req, resp := client.DescribeClientVpnEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints
func (c *EC2) DescribeClientVpnEndpointsRequest(input *DescribeClientVpnEndpointsInput) (req *request.Request, output *DescribeClientVpnEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnEndpointsInput{}
	}

	output = &DescribeClientVpnEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnEndpoints API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more Client VPN endpoints in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpoints
func (c *EC2) DescribeClientVpnEndpoints(input *DescribeClientVpnEndpointsInput) (*DescribeClientVpnEndpointsOutput, error) {
	req, out := c.DescribeClientVpnEndpointsRequest(input)
	return out, req.Send()
}

// DescribeClientVpnEndpointsWithContext is the same as DescribeClientVpnEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnEndpointsWithContext(ctx aws.Context, input *DescribeClientVpnEndpointsInput, opts ...request.Option) (*DescribeClientVpnEndpointsOutput, error) {
	req, out := c.DescribeClientVpnEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnEndpointsPages iterates over the pages of a DescribeClientVpnEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeClientVpnEndpoints operation.
//	pageNum := 0
//	err := client.DescribeClientVpnEndpointsPages(params,
//	    func(page *ec2.DescribeClientVpnEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeClientVpnEndpointsPages(input *DescribeClientVpnEndpointsInput, fn func(*DescribeClientVpnEndpointsOutput, bool) bool) error {
	return c.DescribeClientVpnEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnEndpointsPagesWithContext same as DescribeClientVpnEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnEndpointsPagesWithContext(ctx aws.Context, input *DescribeClientVpnEndpointsInput, fn func(*DescribeClientVpnEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnRoutes = "DescribeClientVpnRoutes"

// DescribeClientVpnRoutesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnRoutes for more information on using the DescribeClientVpnRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClientVpnRoutesRequest method.
//	req, resp := client.DescribeClientVpnRoutesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes
func (c *EC2) DescribeClientVpnRoutesRequest(input *DescribeClientVpnRoutesInput) (req *request.Request, output *DescribeClientVpnRoutesOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnRoutesInput{}
	}

	output = &DescribeClientVpnRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnRoutes API operation for Amazon Elastic Compute Cloud.
//
// Describes the routes for the specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnRoutes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutes
func (c *EC2) DescribeClientVpnRoutes(input *DescribeClientVpnRoutesInput) (*DescribeClientVpnRoutesOutput, error) {
	req, out := c.DescribeClientVpnRoutesRequest(input)
	return out, req.Send()
}

// DescribeClientVpnRoutesWithContext is the same as DescribeClientVpnRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnRoutesWithContext(ctx aws.Context, input *DescribeClientVpnRoutesInput, opts ...request.Option) (*DescribeClientVpnRoutesOutput, error) {
	req, out := c.DescribeClientVpnRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnRoutesPages iterates over the pages of a DescribeClientVpnRoutes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnRoutes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeClientVpnRoutes operation.
//	pageNum := 0
//	err := client.DescribeClientVpnRoutesPages(params,
//	    func(page *ec2.DescribeClientVpnRoutesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeClientVpnRoutesPages(input *DescribeClientVpnRoutesInput, fn func(*DescribeClientVpnRoutesOutput, bool) bool) error {
	return c.DescribeClientVpnRoutesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnRoutesPagesWithContext same as DescribeClientVpnRoutesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnRoutesPagesWithContext(ctx aws.Context, input *DescribeClientVpnRoutesInput, fn func(*DescribeClientVpnRoutesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnRoutesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnRoutesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnRoutesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeClientVpnTargetNetworks = "DescribeClientVpnTargetNetworks"

// DescribeClientVpnTargetNetworksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientVpnTargetNetworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientVpnTargetNetworks for more information on using the DescribeClientVpnTargetNetworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClientVpnTargetNetworksRequest method.
//	req, resp := client.DescribeClientVpnTargetNetworksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks
func (c *EC2) DescribeClientVpnTargetNetworksRequest(input *DescribeClientVpnTargetNetworksInput) (req *request.Request, output *DescribeClientVpnTargetNetworksOutput) {
	op := &request.Operation{
		Name:       opDescribeClientVpnTargetNetworks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeClientVpnTargetNetworksInput{}
	}

	output = &DescribeClientVpnTargetNetworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientVpnTargetNetworks API operation for Amazon Elastic Compute Cloud.
//
// Describes the target networks associated with the specified Client VPN endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeClientVpnTargetNetworks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworks
func (c *EC2) DescribeClientVpnTargetNetworks(input *DescribeClientVpnTargetNetworksInput) (*DescribeClientVpnTargetNetworksOutput, error) {
	req, out := c.DescribeClientVpnTargetNetworksRequest(input)
	return out, req.Send()
}

// DescribeClientVpnTargetNetworksWithContext is the same as DescribeClientVpnTargetNetworks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientVpnTargetNetworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnTargetNetworksWithContext(ctx aws.Context, input *DescribeClientVpnTargetNetworksInput, opts ...request.Option) (*DescribeClientVpnTargetNetworksOutput, error) {
	req, out := c.DescribeClientVpnTargetNetworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeClientVpnTargetNetworksPages iterates over the pages of a DescribeClientVpnTargetNetworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeClientVpnTargetNetworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeClientVpnTargetNetworks operation.
//	pageNum := 0
//	err := client.DescribeClientVpnTargetNetworksPages(params,
//	    func(page *ec2.DescribeClientVpnTargetNetworksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeClientVpnTargetNetworksPages(input *DescribeClientVpnTargetNetworksInput, fn func(*DescribeClientVpnTargetNetworksOutput, bool) bool) error {
	return c.DescribeClientVpnTargetNetworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeClientVpnTargetNetworksPagesWithContext same as DescribeClientVpnTargetNetworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeClientVpnTargetNetworksPagesWithContext(ctx aws.Context, input *DescribeClientVpnTargetNetworksInput, fn func(*DescribeClientVpnTargetNetworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeClientVpnTargetNetworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeClientVpnTargetNetworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeClientVpnTargetNetworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCoipPools = "DescribeCoipPools"

// DescribeCoipPoolsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCoipPools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCoipPools for more information on using the DescribeCoipPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCoipPoolsRequest method.
//	req, resp := client.DescribeCoipPoolsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools
func (c *EC2) DescribeCoipPoolsRequest(input *DescribeCoipPoolsInput) (req *request.Request, output *DescribeCoipPoolsOutput) {
	op := &request.Operation{
		Name:       opDescribeCoipPools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCoipPoolsInput{}
	}

	output = &DescribeCoipPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCoipPools API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified customer-owned address pools or all of your customer-owned
// address pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCoipPools for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPools
func (c *EC2) DescribeCoipPools(input *DescribeCoipPoolsInput) (*DescribeCoipPoolsOutput, error) {
	req, out := c.DescribeCoipPoolsRequest(input)
	return out, req.Send()
}

// DescribeCoipPoolsWithContext is the same as DescribeCoipPools with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCoipPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCoipPoolsWithContext(ctx aws.Context, input *DescribeCoipPoolsInput, opts ...request.Option) (*DescribeCoipPoolsOutput, error) {
	req, out := c.DescribeCoipPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCoipPoolsPages iterates over the pages of a DescribeCoipPools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCoipPools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeCoipPools operation.
//	pageNum := 0
//	err := client.DescribeCoipPoolsPages(params,
//	    func(page *ec2.DescribeCoipPoolsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeCoipPoolsPages(input *DescribeCoipPoolsInput, fn func(*DescribeCoipPoolsOutput, bool) bool) error {
	return c.DescribeCoipPoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCoipPoolsPagesWithContext same as DescribeCoipPoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCoipPoolsPagesWithContext(ctx aws.Context, input *DescribeCoipPoolsInput, fn func(*DescribeCoipPoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCoipPoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCoipPoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCoipPoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConversionTasks = "DescribeConversionTasks"

// DescribeConversionTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConversionTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConversionTasks for more information on using the DescribeConversionTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeConversionTasksRequest method.
//	req, resp := client.DescribeConversionTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks
func (c *EC2) DescribeConversionTasksRequest(input *DescribeConversionTasksInput) (req *request.Request, output *DescribeConversionTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeConversionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConversionTasksInput{}
	}

	output = &DescribeConversionTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConversionTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified conversion tasks or all your conversion tasks. For
// more information, see the VM Import/Export User Guide (https://docs.aws.amazon.com/vm-import/latest/userguide/).
//
// For information about the import manifest referenced by this API action,
// see VM Import Manifest (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeConversionTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasks
func (c *EC2) DescribeConversionTasks(input *DescribeConversionTasksInput) (*DescribeConversionTasksOutput, error) {
	req, out := c.DescribeConversionTasksRequest(input)
	return out, req.Send()
}

// DescribeConversionTasksWithContext is the same as DescribeConversionTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConversionTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeConversionTasksWithContext(ctx aws.Context, input *DescribeConversionTasksInput, opts ...request.Option) (*DescribeConversionTasksOutput, error) {
	req, out := c.DescribeConversionTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomerGateways = "DescribeCustomerGateways"

// DescribeCustomerGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCustomerGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCustomerGateways for more information on using the DescribeCustomerGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCustomerGatewaysRequest method.
//	req, resp := client.DescribeCustomerGatewaysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways
func (c *EC2) DescribeCustomerGatewaysRequest(input *DescribeCustomerGatewaysInput) (req *request.Request, output *DescribeCustomerGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomerGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomerGatewaysInput{}
	}

	output = &DescribeCustomerGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCustomerGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your VPN customer gateways.
//
// For more information, see Amazon Web Services Site-to-Site VPN (https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html)
// in the Amazon Web Services Site-to-Site VPN User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeCustomerGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGateways
func (c *EC2) DescribeCustomerGateways(input *DescribeCustomerGatewaysInput) (*DescribeCustomerGatewaysOutput, error) {
	req, out := c.DescribeCustomerGatewaysRequest(input)
	return out, req.Send()
}

// DescribeCustomerGatewaysWithContext is the same as DescribeCustomerGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomerGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeCustomerGatewaysWithContext(ctx aws.Context, input *DescribeCustomerGatewaysInput, opts ...request.Option) (*DescribeCustomerGatewaysOutput, error) {
	req, out := c.DescribeCustomerGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDhcpOptions = "DescribeDhcpOptions"

// DescribeDhcpOptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDhcpOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDhcpOptions for more information on using the DescribeDhcpOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDhcpOptionsRequest method.
//	req, resp := client.DescribeDhcpOptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions
func (c *EC2) DescribeDhcpOptionsRequest(input *DescribeDhcpOptionsInput) (req *request.Request, output *DescribeDhcpOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeDhcpOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDhcpOptionsInput{}
	}

	output = &DescribeDhcpOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDhcpOptions API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your DHCP options sets.
//
// For more information, see DHCP options sets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
// in the Amazon VPC User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeDhcpOptions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptions
func (c *EC2) DescribeDhcpOptions(input *DescribeDhcpOptionsInput) (*DescribeDhcpOptionsOutput, error) {
	req, out := c.DescribeDhcpOptionsRequest(input)
	return out, req.Send()
}

// DescribeDhcpOptionsWithContext is the same as DescribeDhcpOptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDhcpOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeDhcpOptionsWithContext(ctx aws.Context, input *DescribeDhcpOptionsInput, opts ...request.Option) (*DescribeDhcpOptionsOutput, error) {
	req, out := c.DescribeDhcpOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDhcpOptionsPages iterates over the pages of a DescribeDhcpOptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDhcpOptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeDhcpOptions operation.
//	pageNum := 0
//	err := client.DescribeDhcpOptionsPages(params,
//	    func(page *ec2.DescribeDhcpOptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeDhcpOptionsPages(input *DescribeDhcpOptionsInput, fn func(*DescribeDhcpOptionsOutput, bool) bool) error {
	return c.DescribeDhcpOptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDhcpOptionsPagesWithContext same as DescribeDhcpOptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeDhcpOptionsPagesWithContext(ctx aws.Context, input *DescribeDhcpOptionsInput, fn func(*DescribeDhcpOptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDhcpOptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDhcpOptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDhcpOptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEgressOnlyInternetGateways = "DescribeEgressOnlyInternetGateways"

// DescribeEgressOnlyInternetGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEgressOnlyInternetGateways operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEgressOnlyInternetGateways for more information on using the DescribeEgressOnlyInternetGateways
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEgressOnlyInternetGatewaysRequest method.
//	req, resp := client.DescribeEgressOnlyInternetGatewaysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways
func (c *EC2) DescribeEgressOnlyInternetGatewaysRequest(input *DescribeEgressOnlyInternetGatewaysInput) (req *request.Request, output *DescribeEgressOnlyInternetGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeEgressOnlyInternetGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEgressOnlyInternetGatewaysInput{}
	}

	output = &DescribeEgressOnlyInternetGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEgressOnlyInternetGateways API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more of your egress-only internet gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeEgressOnlyInternetGateways for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGateways
func (c *EC2) DescribeEgressOnlyInternetGateways(input *DescribeEgressOnlyInternetGatewaysInput) (*DescribeEgressOnlyInternetGatewaysOutput, error) {
	req, out := c.DescribeEgressOnlyInternetGatewaysRequest(input)
	return out, req.Send()
}

// DescribeEgressOnlyInternetGatewaysWithContext is the same as DescribeEgressOnlyInternetGateways with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEgressOnlyInternetGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeEgressOnlyInternetGatewaysWithContext(ctx aws.Context, input *DescribeEgressOnlyInternetGatewaysInput, opts ...request.Option) (*DescribeEgressOnlyInternetGatewaysOutput, error) {
	req, out := c.DescribeEgressOnlyInternetGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEgressOnlyInternetGatewaysPages iterates over the pages of a DescribeEgressOnlyInternetGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEgressOnlyInternetGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeEgressOnlyInternetGateways operation.
//	pageNum := 0
//	err := client.DescribeEgressOnlyInternetGatewaysPages(params,
//	    func(page *ec2.DescribeEgressOnlyInternetGatewaysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeEgressOnlyInternetGatewaysPages(input *DescribeEgressOnlyInternetGatewaysInput, fn func(*DescribeEgressOnlyInternetGatewaysOutput, bool) bool) error {
	return c.DescribeEgressOnlyInternetGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEgressOnlyInternetGatewaysPagesWithContext same as DescribeEgressOnlyInternetGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeEgressOnlyInternetGatewaysPagesWithContext(ctx aws.Context, input *DescribeEgressOnlyInternetGatewaysInput, fn func(*DescribeEgressOnlyInternetGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEgressOnlyInternetGatewaysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEgressOnlyInternetGatewaysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEgressOnlyInternetGatewaysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeElasticGpus = "DescribeElasticGpus"

// DescribeElasticGpusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticGpus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticGpus for more information on using the DescribeElasticGpus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeElasticGpusRequest method.
//	req, resp := client.DescribeElasticGpusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus
func (c *EC2) DescribeElasticGpusRequest(input *DescribeElasticGpusInput) (req *request.Request, output *DescribeElasticGpusOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticGpus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeElasticGpusInput{}
	}

	output = &DescribeElasticGpusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticGpus API operation for Amazon Elastic Compute Cloud.
//
// Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads
// that require graphics acceleration, we recommend that you use Amazon EC2
// G4ad, G4dn, or G5 instances.
//
// Describes the Elastic Graphics accelerator associated with your instances.
// For more information about Elastic Graphics, see Amazon Elastic Graphics
// (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeElasticGpus for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpus
func (c *EC2) DescribeElasticGpus(input *DescribeElasticGpusInput) (*DescribeElasticGpusOutput, error) {
	req, out := c.DescribeElasticGpusRequest(input)
	return out, req.Send()
}

// DescribeElasticGpusWithContext is the same as DescribeElasticGpus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticGpus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeElasticGpusWithContext(ctx aws.Context, input *DescribeElasticGpusInput, opts ...request.Option) (*DescribeElasticGpusOutput, error) {
	req, out := c.DescribeElasticGpusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeExportImageTasks = "DescribeExportImageTasks"

// DescribeExportImageTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportImageTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportImageTasks for more information on using the DescribeExportImageTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeExportImageTasksRequest method.
//	req, resp := client.DescribeExportImageTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks
func (c *EC2) DescribeExportImageTasksRequest(input *DescribeExportImageTasksInput) (req *request.Request, output *DescribeExportImageTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeExportImageTasksInput{}
	}

	output = &DescribeExportImageTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportImageTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified export image tasks or all of your export image tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeExportImageTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasks
func (c *EC2) DescribeExportImageTasks(input *DescribeExportImageTasksInput) (*DescribeExportImageTasksOutput, error) {
	req, out := c.DescribeExportImageTasksRequest(input)
	return out, req.Send()
}

// DescribeExportImageTasksWithContext is the same as DescribeExportImageTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportImageTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeExportImageTasksWithContext(ctx aws.Context, input *DescribeExportImageTasksInput, opts ...request.Option) (*DescribeExportImageTasksOutput, error) {
	req, out := c.DescribeExportImageTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeExportImageTasksPages iterates over the pages of a DescribeExportImageTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeExportImageTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeExportImageTasks operation.
//	pageNum := 0
//	err := client.DescribeExportImageTasksPages(params,
//	    func(page *ec2.DescribeExportImageTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeExportImageTasksPages(input *DescribeExportImageTasksInput, fn func(*DescribeExportImageTasksOutput, bool) bool) error {
	return c.DescribeExportImageTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeExportImageTasksPagesWithContext same as DescribeExportImageTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeExportImageTasksPagesWithContext(ctx aws.Context, input *DescribeExportImageTasksInput, fn func(*DescribeExportImageTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeExportImageTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeExportImageTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeExportImageTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeExportTasks = "DescribeExportTasks"

// DescribeExportTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeExportTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeExportTasks for more information on using the DescribeExportTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeExportTasksRequest method.
//	req, resp := client.DescribeExportTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks
func (c *EC2) DescribeExportTasksRequest(input *DescribeExportTasksInput) (req *request.Request, output *DescribeExportTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeExportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExportTasksInput{}
	}

	output = &DescribeExportTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeExportTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified export instance tasks or all of your export instance
// tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeExportTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasks
func (c *EC2) DescribeExportTasks(input *DescribeExportTasksInput) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	return out, req.Send()
}

// DescribeExportTasksWithContext is the same as DescribeExportTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeExportTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeExportTasksWithContext(ctx aws.Context, input *DescribeExportTasksInput, opts ...request.Option) (*DescribeExportTasksOutput, error) {
	req, out := c.DescribeExportTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFastLaunchImages = "DescribeFastLaunchImages"

// DescribeFastLaunchImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFastLaunchImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFastLaunchImages for more information on using the DescribeFastLaunchImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFastLaunchImagesRequest method.
//	req, resp := client.DescribeFastLaunchImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastLaunchImages
func (c *EC2) DescribeFastLaunchImagesRequest(input *DescribeFastLaunchImagesInput) (req *request.Request, output *DescribeFastLaunchImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeFastLaunchImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFastLaunchImagesInput{}
	}

	output = &DescribeFastLaunchImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFastLaunchImages API operation for Amazon Elastic Compute Cloud.
//
// Describe details for Windows AMIs that are configured for Windows fast launch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFastLaunchImages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastLaunchImages
func (c *EC2) DescribeFastLaunchImages(input *DescribeFastLaunchImagesInput) (*DescribeFastLaunchImagesOutput, error) {
	req, out := c.DescribeFastLaunchImagesRequest(input)
	return out, req.Send()
}

// DescribeFastLaunchImagesWithContext is the same as DescribeFastLaunchImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFastLaunchImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFastLaunchImagesWithContext(ctx aws.Context, input *DescribeFastLaunchImagesInput, opts ...request.Option) (*DescribeFastLaunchImagesOutput, error) {
	req, out := c.DescribeFastLaunchImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFastLaunchImagesPages iterates over the pages of a DescribeFastLaunchImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFastLaunchImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFastLaunchImages operation.
//	pageNum := 0
//	err := client.DescribeFastLaunchImagesPages(params,
//	    func(page *ec2.DescribeFastLaunchImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeFastLaunchImagesPages(input *DescribeFastLaunchImagesInput, fn func(*DescribeFastLaunchImagesOutput, bool) bool) error {
	return c.DescribeFastLaunchImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFastLaunchImagesPagesWithContext same as DescribeFastLaunchImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFastLaunchImagesPagesWithContext(ctx aws.Context, input *DescribeFastLaunchImagesInput, fn func(*DescribeFastLaunchImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFastLaunchImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFastLaunchImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFastLaunchImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFastSnapshotRestores = "DescribeFastSnapshotRestores"

// DescribeFastSnapshotRestoresRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFastSnapshotRestores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFastSnapshotRestores for more information on using the DescribeFastSnapshotRestores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFastSnapshotRestoresRequest method.
//	req, resp := client.DescribeFastSnapshotRestoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores
func (c *EC2) DescribeFastSnapshotRestoresRequest(input *DescribeFastSnapshotRestoresInput) (req *request.Request, output *DescribeFastSnapshotRestoresOutput) {
	op := &request.Operation{
		Name:       opDescribeFastSnapshotRestores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFastSnapshotRestoresInput{}
	}

	output = &DescribeFastSnapshotRestoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFastSnapshotRestores API operation for Amazon Elastic Compute Cloud.
//
// Describes the state of fast snapshot restores for your snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFastSnapshotRestores for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestores
func (c *EC2) DescribeFastSnapshotRestores(input *DescribeFastSnapshotRestoresInput) (*DescribeFastSnapshotRestoresOutput, error) {
	req, out := c.DescribeFastSnapshotRestoresRequest(input)
	return out, req.Send()
}

// DescribeFastSnapshotRestoresWithContext is the same as DescribeFastSnapshotRestores with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFastSnapshotRestores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFastSnapshotRestoresWithContext(ctx aws.Context, input *DescribeFastSnapshotRestoresInput, opts ...request.Option) (*DescribeFastSnapshotRestoresOutput, error) {
	req, out := c.DescribeFastSnapshotRestoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFastSnapshotRestoresPages iterates over the pages of a DescribeFastSnapshotRestores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFastSnapshotRestores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFastSnapshotRestores operation.
//	pageNum := 0
//	err := client.DescribeFastSnapshotRestoresPages(params,
//	    func(page *ec2.DescribeFastSnapshotRestoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeFastSnapshotRestoresPages(input *DescribeFastSnapshotRestoresInput, fn func(*DescribeFastSnapshotRestoresOutput, bool) bool) error {
	return c.DescribeFastSnapshotRestoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFastSnapshotRestoresPagesWithContext same as DescribeFastSnapshotRestoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFastSnapshotRestoresPagesWithContext(ctx aws.Context, input *DescribeFastSnapshotRestoresInput, fn func(*DescribeFastSnapshotRestoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFastSnapshotRestoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFastSnapshotRestoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFastSnapshotRestoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetHistory = "DescribeFleetHistory"

// DescribeFleetHistoryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetHistory for more information on using the DescribeFleetHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetHistoryRequest method.
//	req, resp := client.DescribeFleetHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory
func (c *EC2) DescribeFleetHistoryRequest(input *DescribeFleetHistoryInput) (req *request.Request, output *DescribeFleetHistoryOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetHistoryInput{}
	}

	output = &DescribeFleetHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetHistory API operation for Amazon Elastic Compute Cloud.
//
// Describes the events for the specified EC2 Fleet during the specified time.
//
// EC2 Fleet events are delayed by up to 30 seconds before they can be described.
// This ensures that you can query by the last evaluated time and not miss a
// recorded event. EC2 Fleet events are available for 48 hours.
//
// For more information, see Monitor fleet events using Amazon EventBridge (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFleetHistory for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistory
func (c *EC2) DescribeFleetHistory(input *DescribeFleetHistoryInput) (*DescribeFleetHistoryOutput, error) {
	req, out := c.DescribeFleetHistoryRequest(input)
	return out, req.Send()
}

// DescribeFleetHistoryWithContext is the same as DescribeFleetHistory with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetHistoryWithContext(ctx aws.Context, input *DescribeFleetHistoryInput, opts ...request.Option) (*DescribeFleetHistoryOutput, error) {
	req, out := c.DescribeFleetHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetInstances = "DescribeFleetInstances"

// DescribeFleetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetInstances for more information on using the DescribeFleetInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetInstancesRequest method.
//	req, resp := client.DescribeFleetInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances
func (c *EC2) DescribeFleetInstancesRequest(input *DescribeFleetInstancesInput) (req *request.Request, output *DescribeFleetInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetInstancesInput{}
	}

	output = &DescribeFleetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetInstances API operation for Amazon Elastic Compute Cloud.
//
// Describes the running instances for the specified EC2 Fleet.
//
// Currently, DescribeFleetInstances does not support fleets of type instant.
// Instead, use DescribeFleets, specifying the instant fleet ID in the request.
//
// For more information, see Describe your EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFleetInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstances
func (c *EC2) DescribeFleetInstances(input *DescribeFleetInstancesInput) (*DescribeFleetInstancesOutput, error) {
	req, out := c.DescribeFleetInstancesRequest(input)
	return out, req.Send()
}

// DescribeFleetInstancesWithContext is the same as DescribeFleetInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetInstancesWithContext(ctx aws.Context, input *DescribeFleetInstancesInput, opts ...request.Option) (*DescribeFleetInstancesOutput, error) {
	req, out := c.DescribeFleetInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleets = "DescribeFleets"

// DescribeFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleets for more information on using the DescribeFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetsRequest method.
//	req, resp := client.DescribeFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets
func (c *EC2) DescribeFleetsRequest(input *DescribeFleetsInput) (req *request.Request, output *DescribeFleetsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetsInput{}
	}

	output = &DescribeFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleets API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified EC2 Fleet or all of your EC2 Fleets.
//
// If a fleet is of type instant, you must specify the fleet ID in the request,
// otherwise the fleet does not appear in the response.
//
// For more information, see Describe your EC2 Fleet (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#monitor-ec2-fleet)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleets
func (c *EC2) DescribeFleets(input *DescribeFleetsInput) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	return out, req.Send()
}

// DescribeFleetsWithContext is the same as DescribeFleets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetsWithContext(ctx aws.Context, input *DescribeFleetsInput, opts ...request.Option) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetsPages iterates over the pages of a DescribeFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleets operation.
//	pageNum := 0
//	err := client.DescribeFleetsPages(params,
//	    func(page *ec2.DescribeFleetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeFleetsPages(input *DescribeFleetsInput, fn func(*DescribeFleetsOutput, bool) bool) error {
	return c.DescribeFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetsPagesWithContext same as DescribeFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFleetsPagesWithContext(ctx aws.Context, input *DescribeFleetsInput, fn func(*DescribeFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFlowLogs = "DescribeFlowLogs"

// DescribeFlowLogsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlowLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlowLogs for more information on using the DescribeFlowLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFlowLogsRequest method.
//	req, resp := client.DescribeFlowLogsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs
func (c *EC2) DescribeFlowLogsRequest(input *DescribeFlowLogsInput) (req *request.Request, output *DescribeFlowLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeFlowLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFlowLogsInput{}
	}

	output = &DescribeFlowLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlowLogs API operation for Amazon Elastic Compute Cloud.
//
// Describes one or more flow logs.
//
// To view the published flow log records, you must view the log destination.
// For example, the CloudWatch Logs log group, the Amazon S3 bucket, or the
// Kinesis Data Firehose delivery stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFlowLogs for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogs
func (c *EC2) DescribeFlowLogs(input *DescribeFlowLogsInput) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	return out, req.Send()
}

// DescribeFlowLogsWithContext is the same as DescribeFlowLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlowLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFlowLogsWithContext(ctx aws.Context, input *DescribeFlowLogsInput, opts ...request.Option) (*DescribeFlowLogsOutput, error) {
	req, out := c.DescribeFlowLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFlowLogsPages iterates over the pages of a DescribeFlowLogs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFlowLogs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFlowLogs operation.
//	pageNum := 0
//	err := client.DescribeFlowLogsPages(params,
//	    func(page *ec2.DescribeFlowLogsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeFlowLogsPages(input *DescribeFlowLogsInput, fn func(*DescribeFlowLogsOutput, bool) bool) error {
	return c.DescribeFlowLogsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFlowLogsPagesWithContext same as DescribeFlowLogsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFlowLogsPagesWithContext(ctx aws.Context, input *DescribeFlowLogsInput, fn func(*DescribeFlowLogsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFlowLogsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFlowLogsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFlowLogsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFpgaImageAttribute = "DescribeFpgaImageAttribute"

// DescribeFpgaImageAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFpgaImageAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFpgaImageAttribute for more information on using the DescribeFpgaImageAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFpgaImageAttributeRequest method.
//	req, resp := client.DescribeFpgaImageAttributeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute
func (c *EC2) DescribeFpgaImageAttributeRequest(input *DescribeFpgaImageAttributeInput) (req *request.Request, output *DescribeFpgaImageAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeFpgaImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFpgaImageAttributeInput{}
	}

	output = &DescribeFpgaImageAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFpgaImageAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified Amazon FPGA Image (AFI).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFpgaImageAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttribute
func (c *EC2) DescribeFpgaImageAttribute(input *DescribeFpgaImageAttributeInput) (*DescribeFpgaImageAttributeOutput, error) {
	req, out := c.DescribeFpgaImageAttributeRequest(input)
	return out, req.Send()
}

// DescribeFpgaImageAttributeWithContext is the same as DescribeFpgaImageAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFpgaImageAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFpgaImageAttributeWithContext(ctx aws.Context, input *DescribeFpgaImageAttributeInput, opts ...request.Option) (*DescribeFpgaImageAttributeOutput, error) {
	req, out := c.DescribeFpgaImageAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFpgaImages = "DescribeFpgaImages"

// DescribeFpgaImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFpgaImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFpgaImages for more information on using the DescribeFpgaImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFpgaImagesRequest method.
//	req, resp := client.DescribeFpgaImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages
func (c *EC2) DescribeFpgaImagesRequest(input *DescribeFpgaImagesInput) (req *request.Request, output *DescribeFpgaImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeFpgaImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFpgaImagesInput{}
	}

	output = &DescribeFpgaImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFpgaImages API operation for Amazon Elastic Compute Cloud.
//
// Describes the Amazon FPGA Images (AFIs) available to you. These include public
// AFIs, private AFIs that you own, and AFIs owned by other Amazon Web Services
// accounts for which you have load permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeFpgaImages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImages
func (c *EC2) DescribeFpgaImages(input *DescribeFpgaImagesInput) (*DescribeFpgaImagesOutput, error) {
	req, out := c.DescribeFpgaImagesRequest(input)
	return out, req.Send()
}

// DescribeFpgaImagesWithContext is the same as DescribeFpgaImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFpgaImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFpgaImagesWithContext(ctx aws.Context, input *DescribeFpgaImagesInput, opts ...request.Option) (*DescribeFpgaImagesOutput, error) {
	req, out := c.DescribeFpgaImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFpgaImagesPages iterates over the pages of a DescribeFpgaImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFpgaImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFpgaImages operation.
//	pageNum := 0
//	err := client.DescribeFpgaImagesPages(params,
//	    func(page *ec2.DescribeFpgaImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeFpgaImagesPages(input *DescribeFpgaImagesInput, fn func(*DescribeFpgaImagesOutput, bool) bool) error {
	return c.DescribeFpgaImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFpgaImagesPagesWithContext same as DescribeFpgaImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeFpgaImagesPagesWithContext(ctx aws.Context, input *DescribeFpgaImagesInput, fn func(*DescribeFpgaImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFpgaImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFpgaImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFpgaImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHostReservationOfferings = "DescribeHostReservationOfferings"

// DescribeHostReservationOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostReservationOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHostReservationOfferings for more information on using the DescribeHostReservationOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeHostReservationOfferingsRequest method.
//	req, resp := client.DescribeHostReservationOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings
func (c *EC2) DescribeHostReservationOfferingsRequest(input *DescribeHostReservationOfferingsInput) (req *request.Request, output *DescribeHostReservationOfferingsOutput) {
	op := &request.Operation{
		Name:       opDescribeHostReservationOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHostReservationOfferingsInput{}
	}

	output = &DescribeHostReservationOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostReservationOfferings API operation for Amazon Elastic Compute Cloud.
//
// Describes the Dedicated Host reservations that are available to purchase.
//
// The results describe all of the Dedicated Host reservation offerings, including
// offerings that might not match the instance family and Region of your Dedicated
// Hosts. When purchasing an offering, ensure that the instance family and Region
// of the offering matches that of the Dedicated Hosts with which it is to be
// associated. For more information about supported instance types, see Dedicated
// Hosts (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHostReservationOfferings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferings
func (c *EC2) DescribeHostReservationOfferings(input *DescribeHostReservationOfferingsInput) (*DescribeHostReservationOfferingsOutput, error) {
	req, out := c.DescribeHostReservationOfferingsRequest(input)
	return out, req.Send()
}

// DescribeHostReservationOfferingsWithContext is the same as DescribeHostReservationOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHostReservationOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationOfferingsWithContext(ctx aws.Context, input *DescribeHostReservationOfferingsInput, opts ...request.Option) (*DescribeHostReservationOfferingsOutput, error) {
	req, out := c.DescribeHostReservationOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHostReservationOfferingsPages iterates over the pages of a DescribeHostReservationOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHostReservationOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeHostReservationOfferings operation.
//	pageNum := 0
//	err := client.DescribeHostReservationOfferingsPages(params,
//	    func(page *ec2.DescribeHostReservationOfferingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeHostReservationOfferingsPages(input *DescribeHostReservationOfferingsInput, fn func(*DescribeHostReservationOfferingsOutput, bool) bool) error {
	return c.DescribeHostReservationOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHostReservationOfferingsPagesWithContext same as DescribeHostReservationOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationOfferingsPagesWithContext(ctx aws.Context, input *DescribeHostReservationOfferingsInput, fn func(*DescribeHostReservationOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHostReservationOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHostReservationOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHostReservationOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHostReservations = "DescribeHostReservations"

// DescribeHostReservationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHostReservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHostReservations for more information on using the DescribeHostReservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeHostReservationsRequest method.
//	req, resp := client.DescribeHostReservationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations
func (c *EC2) DescribeHostReservationsRequest(input *DescribeHostReservationsInput) (req *request.Request, output *DescribeHostReservationsOutput) {
	op := &request.Operation{
		Name:       opDescribeHostReservations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHostReservationsInput{}
	}

	output = &DescribeHostReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHostReservations API operation for Amazon Elastic Compute Cloud.
//
// Describes reservations that are associated with Dedicated Hosts in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHostReservations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservations
func (c *EC2) DescribeHostReservations(input *DescribeHostReservationsInput) (*DescribeHostReservationsOutput, error) {
	req, out := c.DescribeHostReservationsRequest(input)
	return out, req.Send()
}

// DescribeHostReservationsWithContext is the same as DescribeHostReservations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHostReservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationsWithContext(ctx aws.Context, input *DescribeHostReservationsInput, opts ...request.Option) (*DescribeHostReservationsOutput, error) {
	req, out := c.DescribeHostReservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHostReservationsPages iterates over the pages of a DescribeHostReservations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHostReservations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeHostReservations operation.
//	pageNum := 0
//	err := client.DescribeHostReservationsPages(params,
//	    func(page *ec2.DescribeHostReservationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeHostReservationsPages(input *DescribeHostReservationsInput, fn func(*DescribeHostReservationsOutput, bool) bool) error {
	return c.DescribeHostReservationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHostReservationsPagesWithContext same as DescribeHostReservationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostReservationsPagesWithContext(ctx aws.Context, input *DescribeHostReservationsInput, fn func(*DescribeHostReservationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHostReservationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHostReservationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHostReservationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeHosts = "DescribeHosts"

// DescribeHostsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHosts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHosts for more information on using the DescribeHosts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeHostsRequest method.
//	req, resp := client.DescribeHostsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts
func (c *EC2) DescribeHostsRequest(input *DescribeHostsInput) (req *request.Request, output *DescribeHostsOutput) {
	op := &request.Operation{
		Name:       opDescribeHosts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeHostsInput{}
	}

	output = &DescribeHostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHosts API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified Dedicated Hosts or all your Dedicated Hosts.
//
// The results describe only the Dedicated Hosts in the Region you're currently
// using. All listed instances consume capacity on your Dedicated Host. Dedicated
// Hosts that have recently been released are listed with the state released.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeHosts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHosts
func (c *EC2) DescribeHosts(input *DescribeHostsInput) (*DescribeHostsOutput, error) {
	req, out := c.DescribeHostsRequest(input)
	return out, req.Send()
}

// DescribeHostsWithContext is the same as DescribeHosts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHosts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostsWithContext(ctx aws.Context, input *DescribeHostsInput, opts ...request.Option) (*DescribeHostsOutput, error) {
	req, out := c.DescribeHostsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeHostsPages iterates over the pages of a DescribeHosts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeHosts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeHosts operation.
//	pageNum := 0
//	err := client.DescribeHostsPages(params,
//	    func(page *ec2.DescribeHostsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeHostsPages(input *DescribeHostsInput, fn func(*DescribeHostsOutput, bool) bool) error {
	return c.DescribeHostsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeHostsPagesWithContext same as DescribeHostsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeHostsPagesWithContext(ctx aws.Context, input *DescribeHostsInput, fn func(*DescribeHostsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeHostsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeHostsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeHostsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeIamInstanceProfileAssociations = "DescribeIamInstanceProfileAssociations"

// DescribeIamInstanceProfileAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIamInstanceProfileAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIamInstanceProfileAssociations for more information on using the DescribeIamInstanceProfileAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIamInstanceProfileAssociationsRequest method.
//	req, resp := client.DescribeIamInstanceProfileAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations
func (c *EC2) DescribeIamInstanceProfileAssociationsRequest(input *DescribeIamInstanceProfileAssociationsInput) (req *request.Request, output *DescribeIamInstanceProfileAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeIamInstanceProfileAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeIamInstanceProfileAssociationsInput{}
	}

	output = &DescribeIamInstanceProfileAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIamInstanceProfileAssociations API operation for Amazon Elastic Compute Cloud.
//
// Describes your IAM instance profile associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIamInstanceProfileAssociations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociations
func (c *EC2) DescribeIamInstanceProfileAssociations(input *DescribeIamInstanceProfileAssociationsInput) (*DescribeIamInstanceProfileAssociationsOutput, error) {
	req, out := c.DescribeIamInstanceProfileAssociationsRequest(input)
	return out, req.Send()
}

// DescribeIamInstanceProfileAssociationsWithContext is the same as DescribeIamInstanceProfileAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIamInstanceProfileAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIamInstanceProfileAssociationsWithContext(ctx aws.Context, input *DescribeIamInstanceProfileAssociationsInput, opts ...request.Option) (*DescribeIamInstanceProfileAssociationsOutput, error) {
	req, out := c.DescribeIamInstanceProfileAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeIamInstanceProfileAssociationsPages iterates over the pages of a DescribeIamInstanceProfileAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeIamInstanceProfileAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeIamInstanceProfileAssociations operation.
//	pageNum := 0
//	err := client.DescribeIamInstanceProfileAssociationsPages(params,
//	    func(page *ec2.DescribeIamInstanceProfileAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeIamInstanceProfileAssociationsPages(input *DescribeIamInstanceProfileAssociationsInput, fn func(*DescribeIamInstanceProfileAssociationsOutput, bool) bool) error {
	return c.DescribeIamInstanceProfileAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeIamInstanceProfileAssociationsPagesWithContext same as DescribeIamInstanceProfileAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIamInstanceProfileAssociationsPagesWithContext(ctx aws.Context, input *DescribeIamInstanceProfileAssociationsInput, fn func(*DescribeIamInstanceProfileAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeIamInstanceProfileAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeIamInstanceProfileAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeIamInstanceProfileAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeIdFormat = "DescribeIdFormat"

// DescribeIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdFormat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdFormat for more information on using the DescribeIdFormat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIdFormatRequest method.
//	req, resp := client.DescribeIdFormatRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat
func (c *EC2) DescribeIdFormatRequest(input *DescribeIdFormatInput) (req *request.Request, output *DescribeIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdFormatInput{}
	}

	output = &DescribeIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for your resources on a per-Region basis,
// for example, to view which resource types are enabled for longer IDs. This
// request only returns information about resource types whose ID formats can
// be modified; it does not return information about other resource types.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// These settings apply to the IAM user who makes the request; they do not apply
// to the entire Amazon Web Services account. By default, an IAM user defaults
// to the same settings as the root user, unless they explicitly override the
// settings by running the ModifyIdFormat command. Resources created with longer
// IDs are visible to all IAM users, regardless of these settings and provided
// that they have permission to use the relevant Describe command for the resource
// type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIdFormat for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormat
func (c *EC2) DescribeIdFormat(input *DescribeIdFormatInput) (*DescribeIdFormatOutput, error) {
	req, out := c.DescribeIdFormatRequest(input)
	return out, req.Send()
}

// DescribeIdFormatWithContext is the same as DescribeIdFormat with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdFormat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIdFormatWithContext(ctx aws.Context, input *DescribeIdFormatInput, opts ...request.Option) (*DescribeIdFormatOutput, error) {
	req, out := c.DescribeIdFormatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityIdFormat = "DescribeIdentityIdFormat"

// DescribeIdentityIdFormatRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityIdFormat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityIdFormat for more information on using the DescribeIdentityIdFormat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIdentityIdFormatRequest method.
//	req, resp := client.DescribeIdentityIdFormatRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat
func (c *EC2) DescribeIdentityIdFormatRequest(input *DescribeIdentityIdFormatInput) (req *request.Request, output *DescribeIdentityIdFormatOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityIdFormatInput{}
	}

	output = &DescribeIdentityIdFormatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityIdFormat API operation for Amazon Elastic Compute Cloud.
//
// Describes the ID format settings for resources for the specified IAM user,
// IAM role, or root user. For example, you can view the resource types that
// are enabled for longer IDs. This request only returns information about resource
// types whose ID formats can be modified; it does not return information about
// other resource types. For more information, see Resource IDs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// The following resource types support longer IDs: bundle | conversion-task
// | customer-gateway | dhcp-options | elastic-ip-allocation | elastic-ip-association
// | export-task | flow-log | image | import-task | instance | internet-gateway
// | network-acl | network-acl-association | network-interface | network-interface-attachment
// | prefix-list | reservation | route-table | route-table-association | security-group
// | snapshot | subnet | subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// These settings apply to the principal specified in the request. They do not
// apply to the principal that makes the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeIdentityIdFormat for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormat
func (c *EC2) DescribeIdentityIdFormat(input *DescribeIdentityIdFormatInput) (*DescribeIdentityIdFormatOutput, error) {
	req, out := c.DescribeIdentityIdFormatRequest(input)
	return out, req.Send()
}

// DescribeIdentityIdFormatWithContext is the same as DescribeIdentityIdFormat with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityIdFormat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeIdentityIdFormatWithContext(ctx aws.Context, input *DescribeIdentityIdFormatInput, opts ...request.Option) (*DescribeIdentityIdFormatOutput, error) {
	req, out := c.DescribeIdentityIdFormatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImageAttribute = "DescribeImageAttribute"

// DescribeImageAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImageAttribute for more information on using the DescribeImageAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImageAttributeRequest method.
//	req, resp := client.DescribeImageAttributeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute
func (c *EC2) DescribeImageAttributeRequest(input *DescribeImageAttributeInput) (req *request.Request, output *DescribeImageAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeImageAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageAttributeInput{}
	}

	output = &DescribeImageAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified AMI. You can specify only
// one attribute at a time.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear
// in a particular order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImageAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttribute
func (c *EC2) DescribeImageAttribute(input *DescribeImageAttributeInput) (*DescribeImageAttributeOutput, error) {
	req, out := c.DescribeImageAttributeRequest(input)
	return out, req.Send()
}

// DescribeImageAttributeWithContext is the same as DescribeImageAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImageAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImageAttributeWithContext(ctx aws.Context, input *DescribeImageAttributeInput, opts ...request.Option) (*DescribeImageAttributeOutput, error) {
	req, out := c.DescribeImageAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImages for more information on using the DescribeImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImagesRequest method.
//	req, resp := client.DescribeImagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages
func (c *EC2) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified images (AMIs, AKIs, and ARIs) available to you or
// all of the images available to you.
//
// The images available to you include public images, private images that you
// own, and private images owned by other Amazon Web Services accounts for which
// you have explicit launch permissions.
//
// Recently deregistered images appear in the returned results for a short interval
// and then return empty results. After all instances that reference a deregistered
// AMI are terminated, specifying the ID of the image will eventually return
// an error indicating that the AMI ID cannot be found.
//
// We strongly recommend using only paginated requests. Unpaginated requests
// are susceptible to throttling and timeouts.
//
// The order of the elements in the response, including those within nested
// structures, might vary. Applications should not assume the elements appear
// in a particular order.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImages for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImages
func (c *EC2) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	return out, req.Send()
}

// DescribeImagesWithContext is the same as DescribeImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImagesWithContext(ctx aws.Context, input *DescribeImagesInput, opts ...request.Option) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImagesPages iterates over the pages of a DescribeImages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeImages operation.
//	pageNum := 0
//	err := client.DescribeImagesPages(params,
//	    func(page *ec2.DescribeImagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeImagesPages(input *DescribeImagesInput, fn func(*DescribeImagesOutput, bool) bool) error {
	return c.DescribeImagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImagesPagesWithContext same as DescribeImagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImagesPagesWithContext(ctx aws.Context, input *DescribeImagesInput, fn func(*DescribeImagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeImportImageTasks = "DescribeImportImageTasks"

// DescribeImportImageTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImportImageTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImportImageTasks for more information on using the DescribeImportImageTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImportImageTasksRequest method.
//	req, resp := client.DescribeImportImageTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks
func (c *EC2) DescribeImportImageTasksRequest(input *DescribeImportImageTasksInput) (req *request.Request, output *DescribeImportImageTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportImageTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImportImageTasksInput{}
	}

	output = &DescribeImportImageTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImportImageTasks API operation for Amazon Elastic Compute Cloud.
//
// Displays details about an import virtual machine or import snapshot tasks
// that are already created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImportImageTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasks
func (c *EC2) DescribeImportImageTasks(input *DescribeImportImageTasksInput) (*DescribeImportImageTasksOutput, error) {
	req, out := c.DescribeImportImageTasksRequest(input)
	return out, req.Send()
}

// DescribeImportImageTasksWithContext is the same as DescribeImportImageTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImportImageTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportImageTasksWithContext(ctx aws.Context, input *DescribeImportImageTasksInput, opts ...request.Option) (*DescribeImportImageTasksOutput, error) {
	req, out := c.DescribeImportImageTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImportImageTasksPages iterates over the pages of a DescribeImportImageTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImportImageTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeImportImageTasks operation.
//	pageNum := 0
//	err := client.DescribeImportImageTasksPages(params,
//	    func(page *ec2.DescribeImportImageTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeImportImageTasksPages(input *DescribeImportImageTasksInput, fn func(*DescribeImportImageTasksOutput, bool) bool) error {
	return c.DescribeImportImageTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImportImageTasksPagesWithContext same as DescribeImportImageTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportImageTasksPagesWithContext(ctx aws.Context, input *DescribeImportImageTasksInput, fn func(*DescribeImportImageTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImportImageTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImportImageTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImportImageTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeImportSnapshotTasks = "DescribeImportSnapshotTasks"

// DescribeImportSnapshotTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImportSnapshotTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImportSnapshotTasks for more information on using the DescribeImportSnapshotTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeImportSnapshotTasksRequest method.
//	req, resp := client.DescribeImportSnapshotTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks
func (c *EC2) DescribeImportSnapshotTasksRequest(input *DescribeImportSnapshotTasksInput) (req *request.Request, output *DescribeImportSnapshotTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeImportSnapshotTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImportSnapshotTasksInput{}
	}

	output = &DescribeImportSnapshotTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImportSnapshotTasks API operation for Amazon Elastic Compute Cloud.
//
// Describes your import snapshot tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeImportSnapshotTasks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasks
func (c *EC2) DescribeImportSnapshotTasks(input *DescribeImportSnapshotTasksInput) (*DescribeImportSnapshotTasksOutput, error) {
	req, out := c.DescribeImportSnapshotTasksRequest(input)
	return out, req.Send()
}

// DescribeImportSnapshotTasksWithContext is the same as DescribeImportSnapshotTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImportSnapshotTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportSnapshotTasksWithContext(ctx aws.Context, input *DescribeImportSnapshotTasksInput, opts ...request.Option) (*DescribeImportSnapshotTasksOutput, error) {
	req, out := c.DescribeImportSnapshotTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeImportSnapshotTasksPages iterates over the pages of a DescribeImportSnapshotTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeImportSnapshotTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeImportSnapshotTasks operation.
//	pageNum := 0
//	err := client.DescribeImportSnapshotTasksPages(params,
//	    func(page *ec2.DescribeImportSnapshotTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeImportSnapshotTasksPages(input *DescribeImportSnapshotTasksInput, fn func(*DescribeImportSnapshotTasksOutput, bool) bool) error {
	return c.DescribeImportSnapshotTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeImportSnapshotTasksPagesWithContext same as DescribeImportSnapshotTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeImportSnapshotTasksPagesWithContext(ctx aws.Context, input *DescribeImportSnapshotTasksInput, fn func(*DescribeImportSnapshotTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeImportSnapshotTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeImportSnapshotTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeImportSnapshotTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceAttribute = "DescribeInstanceAttribute"

// DescribeInstanceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceAttribute for more information on using the DescribeInstanceAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceAttributeRequest method.
//	req, resp := client.DescribeInstanceAttributeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute
func (c *EC2) DescribeInstanceAttributeRequest(input *DescribeInstanceAttributeInput) (req *request.Request, output *DescribeInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceAttributeInput{}
	}

	output = &DescribeInstanceAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAttribute API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified attribute of the specified instance. You can specify
// only one attribute at a time. Valid attribute values are: instanceType |
// kernel | ramdisk | userData | disableApiTermination | instanceInitiatedShutdownBehavior
// | rootDeviceName | blockDeviceMapping | productCodes | sourceDestCheck |
// groupSet | ebsOptimized | sriovNetSupport
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceAttribute for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttribute
func (c *EC2) DescribeInstanceAttribute(input *DescribeInstanceAttributeInput) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	return out, req.Send()
}

// DescribeInstanceAttributeWithContext is the same as DescribeInstanceAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceAttributeWithContext(ctx aws.Context, input *DescribeInstanceAttributeInput, opts ...request.Option) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceConnectEndpoints = "DescribeInstanceConnectEndpoints"

// DescribeInstanceConnectEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceConnectEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceConnectEndpoints for more information on using the DescribeInstanceConnectEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceConnectEndpointsRequest method.
//	req, resp := client.DescribeInstanceConnectEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceConnectEndpoints
func (c *EC2) DescribeInstanceConnectEndpointsRequest(input *DescribeInstanceConnectEndpointsInput) (req *request.Request, output *DescribeInstanceConnectEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceConnectEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceConnectEndpointsInput{}
	}

	output = &DescribeInstanceConnectEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceConnectEndpoints API operation for Amazon Elastic Compute Cloud.
//
// Describes the specified EC2 Instance Connect Endpoints or all EC2 Instance
// Connect Endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Compute Cloud's
// API operation DescribeInstanceConnectEndpoints for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceConnectEndpoints
func (c *EC2) DescribeInstanceConnectEndpoints(input *DescribeInstanceConnectEndpointsInput) (*DescribeInstanceConnectEndpointsOutput, error) {
	req, out := c.DescribeInstanceConnectEndpointsRequest(input)
	return out, req.Send()
}

// DescribeInstanceConnectEndpointsWithContext is the same as DescribeInstanceConnectEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceConnectEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceConnectEndpointsWithContext(ctx aws.Context, input *DescribeInstanceConnectEndpointsInput, opts ...request.Option) (*DescribeInstanceConnectEndpointsOutput, error) {
	req, out := c.DescribeInstanceConnectEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceConnectEndpointsPages iterates over the pages of a DescribeInstanceConnectEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceConnectEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstanceConnectEndpoints operation.
//	pageNum := 0
//	err := client.DescribeInstanceConnectEndpointsPages(params,
//	    func(page *ec2.DescribeInstanceConnectEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EC2) DescribeInstanceConnectEndpointsPages(input *DescribeInstanceConnectEndpointsInput, fn func(*DescribeInstanceConnectEndpointsOutput, bool) bool) error {
	return c.DescribeInstanceConnectEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceConnectEndpointsPagesWithContext same as DescribeInstanceConnectEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EC2) DescribeInstanceConnectEndpointsPagesWithContext(ctx aws.Context, input *DescribeInstanceConnectEndpointsInput, fn func(*DescribeInstanceConnectEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceConnectEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceConnectEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstanceConnectEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstanceCreditSpecifications = "DescribeInstanceCreditSpecifications"

// DescribeInstanceCreditSpecificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceCreditSpecifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceCreditSpecifications for more information on using the