/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators;

import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.reportgenerators.AbstractChartGen;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class PutGetChartGenerator
extends AbstractChartGen {
    private DefaultCategoryDataset putData;
    private DefaultCategoryDataset getData;
    private String chartExtension = ".png";
    private String putChartName = "PutChart";
    private String getChartName = "GetChart";
    private Log log = LogFactory.getLog(PutGetChartGenerator.class);
    private int nPuts = 0;
    private int nGets = 0;
    private int numFilesScanned = 0;

    public void generateChart() throws IOException {
        this.readData();
        String putChartNameToUse = this.filenamePrefix == null ? this.putChartName : this.filenamePrefix + "-" + this.putChartName;
        File chartFile = new File(putChartNameToUse + this.chartExtension);
        if (chartFile.exists()) {
            chartFile.renameTo(new File(putChartNameToUse + "." + System.currentTimeMillis() + this.chartExtension));
            chartFile = new File(putChartNameToUse + this.chartExtension);
        }
        ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)this.createChart("Report: Comparing Cache PUT (WRITE) performance", this.putData, this.nPuts / this.numFilesScanned), (int)800, (int)800);
        String getChartNameToUse = this.filenamePrefix == null ? this.getChartName : this.filenamePrefix + "-" + this.getChartName;
        chartFile = new File(getChartNameToUse + this.chartExtension);
        if (chartFile.exists()) {
            chartFile.renameTo(new File(getChartNameToUse + "." + System.currentTimeMillis() + this.chartExtension));
            chartFile = new File(getChartNameToUse + this.chartExtension);
        }
        ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)this.createChart("Report: Comparing Cache GET (READ) performance", this.getData, this.nGets / this.numFilesScanned), (int)800, (int)800);
        System.out.println("Charts saved as " + putChartNameToUse + " and " + getChartNameToUse);
    }

    private JFreeChart createChart(String title, DefaultCategoryDataset data, int numOperations) {
        JFreeChart chart = ChartFactory.createBarChart3D((String)title, (String)("Cache operations performed (approx): " + NumberFormat.getIntegerInstance().format(numOperations)), (String)"Average time (\u00b5-seconds)", (CategoryDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        BarRenderer3D renderer = (BarRenderer3D)chart.getCategoryPlot().getRenderer();
        renderer.setBaseItemLabelsVisible(true);
        final NumberFormat fmt = NumberFormat.getNumberInstance();
        fmt.setMaximumFractionDigits(2);
        fmt.setMinimumFractionDigits(2);
        renderer.setBaseItemLabelGenerator(new CategoryItemLabelGenerator(){

            public String generateRowLabel(CategoryDataset categoryDataset, int i) {
                return null;
            }

            public String generateColumnLabel(CategoryDataset categoryDataset, int i) {
                return null;
            }

            public String generateLabel(CategoryDataset categoryDataset, int product, int operation) {
                String retval;
                try {
                    retval = fmt.format(categoryDataset.getValue(product, operation)) + " " + "\u00b5" + "s";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    retval = e.toString();
                }
                return retval;
            }
        });
        chart.addSubtitle((Title)this.getSubtitle());
        chart.setBorderVisible(true);
        chart.setAntiAlias(true);
        chart.setTextAntiAlias(true);
        chart.setBackgroundPaint((Paint)new Color(97, 158, 161));
        return chart;
    }

    private void readData() throws IOException {
        File file = new File(this.reportDirectory);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Report directory " + this.reportDirectory + " does not exist or is not a directory!");
        }
        File[] files = file.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".CSV");
            }
        });
        this.putData = new DefaultCategoryDataset();
        this.getData = new DefaultCategoryDataset();
        for (File f : files) {
            this.readData(f);
        }
    }

    private void readData(File f) throws IOException {
        this.log.debug((Object)("Processing file " + f));
        String productName = f.getName();
        if (productName.startsWith("data_")) {
            productName = productName.substring(5);
        }
        if (productName.indexOf(".xml") > 0) {
            productName = productName.substring(0, productName.indexOf(".xml"));
        }
        String line = null;
        BufferedReader br = new BufferedReader(new FileReader(f));
        double avgPut = -1.0;
        double avgGet = -1.0;
        Stats s = null;
        while ((line = br.readLine()) != null && s == null) {
            s = this.getAveragePutAndGet(line);
            this.log.debug((Object)("Read stats " + s));
            if (s == null) continue;
            avgPut = s.avgPut;
            avgGet = s.avgGet;
            this.nGets += s.numGets;
            this.nPuts += s.numPuts;
        }
        br.close();
        this.putData.addValue(avgPut, (Comparable)((Object)productName), (Comparable)((Object)"PUT"));
        this.getData.addValue(avgGet, (Comparable)((Object)productName), (Comparable)((Object)"GET"));
        ++this.numFilesScanned;
    }

    private Stats getAveragePutAndGet(String line) {
        StringTokenizer strTokenizer = new StringTokenizer(line, ",");
        if (strTokenizer.countTokens() < 7) {
            return null;
        }
        for (int i = 0; i < 7; ++i) {
            strTokenizer.nextToken();
        }
        String putStr = strTokenizer.nextToken();
        String getStr = strTokenizer.nextToken();
        for (int i = 0; i < 10; ++i) {
            strTokenizer.nextToken();
        }
        String nPutStr = strTokenizer.nextToken();
        String nGetStr = strTokenizer.nextToken();
        Stats s = new Stats();
        try {
            s.avgPut = Double.parseDouble(putStr) / 1000.0;
            s.avgGet = Double.parseDouble(getStr) / 1000.0;
            s.numPuts = Integer.parseInt(nPutStr);
            s.numGets = Integer.parseInt(nGetStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return s;
    }

    private static class Stats {
        double avgPut;
        double avgGet;
        int numPuts;
        int numGets;

        private Stats() {
        }

        public String toString() {
            return "Stats{avgPut=" + this.avgPut + ", avgGet=" + this.avgGet + ", numPuts=" + this.numPuts + ", numGets=" + this.numGets + '}';
        }
    }
}

