/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.config;

import java.util.ArrayList;
import java.util.List;
import org.cachebench.config.ClusterConfig;
import org.cachebench.config.Report;
import org.cachebench.config.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private int maxTreeDepth;
    private int sampleSize;
    private int sleepBetweenTests;
    private boolean gcBetweenTestsEnabled;
    private boolean emptyCacheBetweenTests;
    private boolean localOnly;
    private boolean useTransactions;
    private ClusterConfig clusterConfig;
    private List<TestCase> testCases = new ArrayList<TestCase>();
    private List<Report> reports = new ArrayList<Report>();
    private int numThreads;

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public boolean isGcBetweenTestsEnabled() {
        return this.gcBetweenTestsEnabled;
    }

    public void setGcBetweenTestsEnabled(boolean gcBetweenTestsEnabled) {
        this.gcBetweenTestsEnabled = gcBetweenTestsEnabled;
    }

    public int getSleepBetweenTests() {
        return this.sleepBetweenTests;
    }

    public void setSleepBetweenTests(int sleepBetweenTests) {
        this.sleepBetweenTests = sleepBetweenTests;
    }

    public boolean isEmptyCacheBetweenTests() {
        return this.emptyCacheBetweenTests;
    }

    public void setEmptyCacheBetweenTests(boolean emptyCacheBetweenTests) {
        this.emptyCacheBetweenTests = emptyCacheBetweenTests;
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public void addTestCase(TestCase testCase) {
        this.testCases.add(testCase);
    }

    public void addReport(Report report) {
        this.reports.add(report);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    public int getMaxTreeDepth() {
        return this.maxTreeDepth;
    }

    public void setMaxTreeDepth(int maxTreeDepth) {
        this.maxTreeDepth = maxTreeDepth;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public void setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
    }

    public TestCase getTestCase(String testCaseName) {
        for (TestCase testCase : this.getTestCases()) {
            if (!testCaseName.equalsIgnoreCase(testCase.getName())) continue;
            return testCase;
        }
        return null;
    }
}

