/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.config.ClusterConfig;
import org.cachebench.config.ConfigBuilder;

public class ClusterConfigurationCheck {
    private static Log log = LogFactory.getLog((String)"ClusterConfigurationCheck");

    public static void main(String[] args) throws Exception {
        URL configUrl;
        String configFile = "cachebench.xml";
        if (args.length >= 1) {
            configFile = args[0];
        }
        if ((configUrl = ConfigBuilder.findConfigFile(configFile)) == null) {
            log.info((Object)"Could not find the config file, exiting with code 1");
            System.exit(1);
        }
        ClusterConfig config = ConfigBuilder.parseConfiguration(configUrl).getClusterConfig();
        boolean areSuspects = false;
        for (InetSocketAddress address : config.getMemberAddresses()) {
            try {
                Socket sock = new Socket(address.getHostName(), address.getPort());
                areSuspects = true;
                log.info((Object)("Managed to connect to " + address));
            }
            catch (IOException e) {
                log.trace((Object)("Connection to : " + address + " failed; expected behavior"));
            }
        }
        if (!areSuspects) {
            log.info((Object)"Success (could not establish any connection)");
        }
        System.exit(areSuspects ? 2 : 0);
    }
}

