/*
 * Decompiled with CFR 0.152.
 */
package io.spring.githubchangeloggenerator;

import io.spring.githubchangeloggenerator.ApplicationProperties;
import io.spring.githubchangeloggenerator.ChangelogGenerator;
import io.spring.githubchangeloggenerator.ChangelogSection;
import io.spring.githubchangeloggenerator.ChangelogSections;
import io.spring.githubchangeloggenerator.MilestoneReference;
import io.spring.githubchangeloggenerator.github.payload.Issue;
import io.spring.githubchangeloggenerator.github.payload.Label;
import io.spring.githubchangeloggenerator.github.payload.User;
import io.spring.githubchangeloggenerator.github.service.GitHubService;
import io.spring.githubchangeloggenerator.github.service.Repository;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

@Component
public class ChangelogGenerator {
    private static final Comparator<Issue> TITLE_COMPARATOR = Comparator.comparing(Issue::getTitle, String.CASE_INSENSITIVE_ORDER);
    private static final Pattern ghUserMentionPattern = Pattern.compile("(^|[^\\w`])(@[\\w-]+)");
    private final GitHubService service;
    private final Repository repository;
    private final MilestoneReference milestoneReference;
    private final String defaultTitlePrefix;
    private final String bulletStyle;
    private final boolean wrapIssueLinkInBrackets;
    private final boolean includeIssueOrPrPrefix;
    private final boolean includePrAuthor;
    private final boolean excludeIssues;
    private final boolean excludePullRequests;
    private final ApplicationProperties.IssueSort sort;
    private final Set<String> excludeLabels;
    private final Set<ApplicationProperties.PortedIssue> portedIssues;
    private final Set<String> excludeContributors;
    private final String contributorsTitle;
    private final String contributorThankYouMessage;
    private final boolean includeWildcardSection;
    private final ChangelogSections sections;
    private final List<ApplicationProperties.ExternalLink> externalLinks;

    public ChangelogGenerator(GitHubService service, ApplicationProperties properties) {
        this.service = service;
        this.repository = properties.getRepository();
        this.milestoneReference = properties.getMilestoneReference();
        this.defaultTitlePrefix = properties.getDefaultTitlePrefix();
        this.bulletStyle = properties.getBulletStyle();
        this.wrapIssueLinkInBrackets = properties.getWrapIssueLinkInBrackets();
        this.includeIssueOrPrPrefix = properties.getIncludeIssueOrPrPrefix();
        this.includePrAuthor = properties.getIncludePrAuthor();
        this.excludeIssues = properties.getExcludeIssues();
        this.excludePullRequests = properties.getExcludePullRequests();
        this.sort = properties.getIssues().getSort();
        this.excludeLabels = properties.getIssues().getExcludes().getLabels();
        this.excludeContributors = properties.getContributors().getExclude().getNames();
        this.contributorsTitle = properties.getContributors().getTitle();
        this.contributorThankYouMessage = properties.getContributors().getThankYouMessage();
        this.includeWildcardSection = properties.getIncludeWildcardSection();
        this.sections = new ChangelogSections(properties);
        this.portedIssues = properties.getIssues().getPorts();
        this.externalLinks = properties.getExternalLinks();
    }

    public String generate(String milestone) {
        int milestoneNumber = this.resolveMilestoneReference(milestone);
        List issues = this.getIssues(milestoneNumber);
        return this.generateContent(issues);
    }

    public void generate(String milestone, String path) throws IOException {
        String content = this.generate(milestone);
        this.writeContentToFile(content, path);
    }

    private List<Issue> getIssues(int milestoneNumber) {
        ArrayList<Issue> issues = new ArrayList<Issue>(this.service.getIssuesForMilestone(milestoneNumber, this.repository));
        issues.removeIf(arg_0 -> this.isExcluded(arg_0));
        return issues;
    }

    private boolean isExcluded(Issue issue) {
        if (issue.isIssue() && this.excludeIssues) {
            return true;
        }
        if (issue.isPullRequest() && this.excludePullRequests) {
            return true;
        }
        return issue.getLabels().stream().anyMatch(arg_0 -> this.isExcluded(arg_0));
    }

    private boolean isExcluded(Label label) {
        return this.excludeLabels.contains(label.getName());
    }

    private int resolveMilestoneReference(String milestone) {
        switch (1.$SwitchMap$io$spring$githubchangeloggenerator$MilestoneReference[this.milestoneReference.ordinal()]) {
            case 1: {
                return this.service.getMilestoneNumber(milestone, this.repository);
            }
            case 2: {
                return Integer.parseInt(milestone);
            }
        }
        throw new IllegalStateException("Unsupported milestone reference value " + this.milestoneReference);
    }

    private String generateContent(List<Issue> issues) {
        StringBuilder content = new StringBuilder();
        this.addSectionContent(content, this.sections.collate(issues, this.includeWildcardSection));
        Set contributors = this.getContributors(issues);
        if (!contributors.isEmpty()) {
            this.addContributorsContent(content, contributors);
        }
        if (!this.externalLinks.isEmpty()) {
            this.addExternalLinksContent(content, this.externalLinks);
        }
        return content.toString();
    }

    private void addSectionContent(StringBuilder content, Map<ChangelogSection, List<Issue>> sectionIssues) {
        sectionIssues.forEach((section, issues) -> {
            this.sort(section.getSort(), issues);
            content.append(content.length() != 0 ? String.format("%n", new Object[0]) : "");
            content.append(this.defaultTitlePrefix).append(section).append(String.format("%n%n", new Object[0]));
            issues.stream().map(arg_0 -> this.getFormattedIssue(arg_0)).forEach(content::append);
        });
    }

    private void sort(ApplicationProperties.IssueSort sort, List<Issue> issues) {
        ApplicationProperties.IssueSort issueSort = sort = sort != null ? sort : this.sort;
        if (sort == ApplicationProperties.IssueSort.TITLE) {
            issues.sort(TITLE_COMPARATOR);
        }
    }

    private String getFormattedIssue(Issue issue) {
        String title = issue.getTitle();
        title = ghUserMentionPattern.matcher(title).replaceAll("$1`$2`");
        String x = "";
        if (this.wrapIssueLinkInBrackets) {
            x = x + "(";
        }
        if (this.includeIssueOrPrPrefix && issue.isIssue()) {
            x = x + "Issue ";
        }
        if (this.includeIssueOrPrPrefix && issue.isPullRequest()) {
            x = x + "PR ";
        }
        x = x + this.getLinkToIssue(issue);
        if (this.includePrAuthor && issue.isPullRequest() & issue.getUser() != null) {
            x = x + " by ";
            x = x + this.getLinkToUser(issue.getUser());
        }
        if (this.wrapIssueLinkInBrackets) {
            x = x + ")";
        }
        return String.format("%s%s %s%n", this.bulletStyle, title, x);
    }

    private String getLinkToIssue(Issue issue) {
        return "[#" + issue.getNumber() + "](" + issue.getUrl() + ")";
    }

    private String getLinkToUser(User user) {
        return "[@" + user.getName() + "](" + user.getUrl() + ")";
    }

    private Set<User> getContributors(List<Issue> issues) {
        if (this.excludeContributors.contains("*")) {
            return Collections.emptySet();
        }
        return issues.stream().map(arg_0 -> this.getPortedReferenceIssue(arg_0)).filter(Issue::isPullRequest).map(Issue::getUser).filter(arg_0 -> this.isIncludedContributor(arg_0)).collect(Collectors.toSet());
    }

    private Issue getPortedReferenceIssue(Issue issue) {
        for (ApplicationProperties.PortedIssue portedIssue : this.portedIssues) {
            String issueNumber;
            Issue referencedIssue;
            Pattern pattern;
            Matcher matcher;
            List labelNames = issue.getLabels().stream().map(Label::getName).collect(Collectors.toList());
            if (!labelNames.contains(portedIssue.getLabel()) || !(matcher = (pattern = portedIssue.getBodyExpression()).matcher(issue.getBody())).matches() || (referencedIssue = this.service.getIssue(issueNumber = matcher.group(1), this.repository)) == null) continue;
            return this.getPortedReferenceIssue(referencedIssue);
        }
        return issue;
    }

    private boolean isIncludedContributor(User user) {
        return !this.excludeContributors.contains(user.getName());
    }

    private void addContributorsContent(StringBuilder content, Set<User> contributors) {
        content.append(String.format("%n%s", this.defaultTitlePrefix));
        content.append(this.contributorsTitle != null ? this.contributorsTitle : ":heart: Contributors");
        content.append(String.format("%n%n%s%n%n", this.contributorThankYouMessage));
        contributors.stream().map(arg_0 -> this.formatContributors(arg_0)).forEach(content::append);
    }

    private String formatContributors(User c) {
        return String.format("%s[@%s](%s)%n", this.bulletStyle, c.getName(), c.getUrl());
    }

    private void addExternalLinksContent(StringBuilder content, List<ApplicationProperties.ExternalLink> externalLinks) {
        content.append(String.format("%n%s", this.defaultTitlePrefix));
        content.append(String.format("External Links%n%n", new Object[0]));
        externalLinks.stream().map(arg_0 -> this.formatExternalLinks(arg_0)).forEach(content::append);
    }

    private String formatExternalLinks(ApplicationProperties.ExternalLink externalLink) {
        return String.format("%s[%s](%s)%n", this.bulletStyle, externalLink.getName(), externalLink.getLocation());
    }

    private void writeContentToFile(String content, String path) throws IOException {
        FileCopyUtils.copy((String)content, (Writer)new FileWriter(new File(path)));
    }
}

