/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.utils.Utils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public abstract class TypeDeclaration<T>
extends BodyDeclaration<T>
implements NodeWithName<T>,
NodeWithJavaDoc<T>,
NodeWithModifiers<T>,
NodeWithMembers<T> {
    private NameExpr name;
    private EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
    private List<BodyDeclaration<?>> members;

    public TypeDeclaration() {
    }

    public TypeDeclaration(EnumSet<Modifier> modifiers, String name) {
        this.setName(name);
        this.setModifiers(modifiers);
    }

    public TypeDeclaration(List<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, String name, List<BodyDeclaration<?>> members) {
        super(annotations);
        this.setName(name);
        this.setModifiers(modifiers);
        this.setMembers(members);
    }

    public TypeDeclaration(Range range, List<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, String name, List<BodyDeclaration<?>> members) {
        super(range, annotations);
        this.setName(name);
        this.setModifiers(modifiers);
        this.setMembers(members);
    }

    public TypeDeclaration<T> addMember(BodyDeclaration<?> decl) {
        List<BodyDeclaration<?>> members = this.getMembers();
        if (Utils.isNullOrEmpty(members)) {
            members = new ArrayList();
            this.setMembers(members);
        }
        members.add(decl);
        decl.setParentNode(this);
        return this;
    }

    @Override
    public List<BodyDeclaration<?>> getMembers() {
        this.members = Utils.ensureNotNull(this.members);
        return this.members;
    }

    @Override
    public final EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public final String getName() {
        return this.name.getName();
    }

    @Override
    public T setMembers(List<BodyDeclaration<?>> members) {
        this.members = members;
        this.setAsParentNodeOf(this.members);
        return (T)this;
    }

    @Override
    public T setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers;
        return (T)this;
    }

    @Override
    public T setName(String name) {
        this.setNameExpr(new NameExpr(name));
        return (T)this;
    }

    public T setNameExpr(NameExpr nameExpr) {
        this.name = nameExpr;
        this.setAsParentNodeOf(this.name);
        return (T)this;
    }

    public final NameExpr getNameExpr() {
        return this.name;
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }
}

