
[//000000001]: # (doctools::cvs \- Documentation tools)
[//000000002]: # (Generated from file 'cvs\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2003\-2008 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>)
[//000000004]: # (doctools::cvs\(n\) 1\.1 tcllib "Documentation tools")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

doctools::cvs \- Processing text in 'cvs log' format

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [See Also](#seealso)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require textutil  
package require doctools::cvs ?1\.1?  

[__::doctools::cvs::scanLog__ *text* *evar* *cvar* *fvar*](#1)  
[__::doctools::cvs::toChangeLog__ *evar* *cvar* *fvar*](#2)  

# <a name='description'></a>DESCRIPTION

This package provides Tcl commands for the processing and reformatting text in
the format generated by the __[cvs log](\.\./\.\./\.\./\.\./index\.md\#cvs\_log)__
command\.

The commands __::doctools::cvs::scanLog__ and
__::doctools::cvs::toChangeLog__ are derived from code found on the
[Tcl'ers Wiki](http://wiki\.tcl\.tk)\. See the references at the end of the
page\.

# <a name='section2'></a>API

  - <a name='1'></a>__::doctools::cvs::scanLog__ *text* *evar* *cvar* *fvar*

    The command takes the *text* and parses it under the assumption that it
    contains a CVS log as generated by __[cvs
    log](\.\./\.\./\.\./\.\./index\.md\#cvs\_log)__\. The resulting information is
    stored in the variables whose names were specified via *evar*, *cvar*,
    and *fvar*\.

    Already existing information in the referenced variables is preserved,
    allowing the caller to merge data from multiple logs into one database\.

      * varname *evar* \(in\)

        Has to refer to a scalar variable\. After the call this variable will
        contain a list of all the entries found in the log file\. An entry is
        identified through the combination of date and author, and can be split
        over multiple physical entries, one per touched file\.

        It should be noted that the entries are listed in the same order as they
        were found in the *text*\. This is not necessarily sorted by date or
        author\.

        Each item in the list is a list containing two elements, the date of the
        entry, and its author, in this order\. The date is formatted as
        __year__/__month__/__day__\.

      * varname *cvar* \(in\)

        Has to refer to an array variable\. Keys are strings containing the date
        and author of log entries, in this order, separated by a comma\.

        The values are lists of comments made for the entry\.

      * varname *fvar* \(in\)

        Has to refer to an array variable\. Keys are strings containing date,
        author of a log entry, and a comment for that entry, in this order,
        separated by commas\.

        The values are lists of the files the entry is touching\.

  - <a name='2'></a>__::doctools::cvs::toChangeLog__ *evar* *cvar* *fvar*

    The three arguments for this command are the same as the last three
    arguments of the command __::doctools::cvs::scanLog__\. This command
    however expects them to be filled with information about one or more logs\.
    It takes this information and converts it into a text in the format of a
    ChangeLog as accepted and generated by
    __[emacs](\.\./\.\./\.\./\.\./index\.md\#emacs)__\. The constructed text is
    returned as the result of the command\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *doctools* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='seealso'></a>SEE ALSO

http://wiki\.tcl\.tk/log2changelog, [uri](\.\./uri/uri\.md)

# <a name='keywords'></a>KEYWORDS

[changelog](\.\./\.\./\.\./\.\./index\.md\#changelog),
[cvs](\.\./\.\./\.\./\.\./index\.md\#cvs), [cvs
log](\.\./\.\./\.\./\.\./index\.md\#cvs\_log), [emacs](\.\./\.\./\.\./\.\./index\.md\#emacs),
[log](\.\./\.\./\.\./\.\./index\.md\#log)

# <a name='category'></a>CATEGORY

Documentation tools

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2003\-2008 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>
