---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, styles,
              tableau en mode hors-texte, tableaux en mode mathématique
---

# Comment forcer le style d'un tableau à `\displaystyle` ?

Le [style](/4_domaines_specialises/mathematiques/styles/les_huit_styles_mathematiques) 
par défaut dans un `array` est `\textstyle` : les mathématiques sont affichées
comme si elles figuraient dans un texte. Ce choix peut être gênant 
lorsque certaines formules demandent à être mieux mises en évidence.

Pour éviter d'avoir à écrire `\displaystyle` dans chaque cellule du tableau 
(comme vous pourriez l'imaginer après la lecture de la question 
"[](/4_domaines_specialises/mathematiques/styles/a_quoi_sert_displaystyle)"), 
vous pouvez déclarer un tableau entièrement en `\displaystyle`
grâce à cet environnement :

```{noedit}
\newenvironment{disarray}{%
  \everymath{\displaystyle\everymath{}}\array%
  }{%
  \endarray%
  }
```

Voici un exemple illustrant le cas sans et avec cet environnement :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newenvironment{disarray}{%
    \everymath{\displaystyle\everymath{}}\array%
    }{%
    \endarray%
    }

\begin{document}
À vous de choisir :
\[
  \begin{array}{|l|}
    y = \sum_{i=0}^{n} i^2 \\
    y = \sum_{i=0}^{n} (i+1)^2 \\
    y = \sum_{i=0}^{n} \bigl(i^2+i+1\bigr)^2 \\
  \end{array}
  \quad \mathrm{ou} \quad
  \begin{disarray}{|l|}
    y = \sum_{i=0}^{n} i^2 \\
    y = \sum_{i=0}^{n} (i+1)^2 \\
    y = \sum_{i=0}^{n} \bigl(i^2+i+1\bigr)^2 \\
  \end{disarray}
\]
\end{document}
```
