---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie
---

# Comment trier les références de la bibliographie ?

## Avec BibTeX

BibTeX dispose d'une fonction de tri et la plupart des styles BibTeX trient
la liste de références. Cela répond au besoin de la plupart des utilisateurs.
La question 
"[](/3_composition/annexes/bibliographie/construire_une_bibliographie)" 
détaille la méthode à retenir.

Dans ce cadre, il existe aussi de nombreux fichiers de style bibliographique
où aucun tri n'est fait, tel `unsrt.bst`. Dans ce cas, les entrées 
sont affichées dans l'ordre où elles sont citées dans le document. 
Pour forcer un certain ordre, une solution peut consister à utiliser 
un tel style et, au début du document, citer les entrées 
avec la commande `\nocite` dans l'ordre voulu.


## Avec le programme <ctanpkg:bibtool>

Dans le même ordre d'idée, utiliser `\nocite{*}` permet de citer 
dans l'ordre où les entrées sont placées dans le fichier `.bib`. Ici, 
l'outil <ctanpkg:bibtool> permet de trier un fichier `.bib` 
suivant différents critères. Par exemple, pour lister le contenu 
d'une bibliographie, classé par année de parution, il faudrait exécuter 
une ligne de commande similaire à celle-ci :

```bash
bibtool -s -- 'sort.format={%d(year)}' biblio.bib -o bibliotriee.bib
```

Il suffit ensuite de compiler le fichier suivant :

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\nocite{*}
\bibliographystyle{unsrt}
\bibliography{bibliotriee}
\end{document}
```


## Avec des commandes de base

Il est également possible d'écrire un environnement `thebibliography` 
qui *semble* provenir de BibTeX, solution parfois utile pour gagner du temps
à court terme. Ici encore, la question 
"[](/3_composition/annexes/bibliographie/construire_une_bibliographie)"
présente cette solution.

Le problème se pose lorsque le rédacteur décide que ses références doivent
être triées. Là, un malentendu courant consiste à insérer la commande 
`\bibliographystyle{alpha}` (ou similaire) et à s'attendre 
à ce que la sortie composée soit triée. Mais cela ne marche pas car il y a
ici confusion :

- entre l'environnement `thebibliography` "fait main" dont vous devez trier
  vous-même le contenu : vous n'obtiendrez jamais rien d'autre 
  que ce que vous avez saisi dans l'environnement ;
- et l'environnement `thebibliography` que construit automatiquement BibTeX
  lorsqu'il est utilisé. En effet, BibTeX se base sur la commande 
  `\bibliographystyle` pour connaître le style de la bibliographie à appliquer.
  Avec cette information (et les autres commandes et options qu'il récupère),
  il compose un environnement `thebibliography` (placé dans un fichier 
  d'extension `.bbl` que LaTeX va incorporer à votre document), 
  cet environnement pouvant être trié si le style choisi le demande.


:::{sources}
[Sorting lists of citations](faquk:FAQ-sortbib)
:::