---
myst:
  html_meta:
    keywords: LaTeX,documentation,classe,extension,écrire une classe,écrire une extension,créer une classe,créer une extension
---
# Comment créer une extension ?

Il n'y a rien de particulièrement extraordinaire dans les commandes que vous utilisez lors de l'écriture d'une extension :

- vous regroupez simplement un ensemble de commandes `\(re)newcommand` et `\(re)newenvironment`. La lecture de la question « [](/2_programmation/macros/makeatletter_et_makeatother) » pourra d'ailleurs vous éviter une erreur sur la gestion du caractère « @ » ;
- vous les enregistrez en un fichier `⟨mon-extension⟩.sty` ;
- et c'est fait !

Cependant, vos extensions pourront demander un peu plus de sophistication :

- des informations sur les commandes LaTeX utilisées pour cette tâche se trouvent dans le document « [Class and package programming guide](ctanpkg:clsguide) » (en PDF [ici](texdoc:clsguide)) ;
- une bonne connaissance de TeX lui-même est importante et des livres comme le [TeXbook](/1_generalites/documentation/livres/documents_sur_tex) ou [TeX by topic](/1_generalites/documentation/livres/documents_sur_tex) sont ici précieux. Dès lors, il vous sera possible d'utiliser la source documentée de LaTeX comme matériel de référence. Cette source peut être obtenue en compilant le fichier « [source2e.tex](ctanpkg:source2e) » ou en consultant directement sa [version PDF](texdoc:source2e) ;
- les [sources documentées](/1_generalites/documentation/documents/documents_extensions/fichiers_sources_dtx) (fichiers « dtx ») des extensions sont également une bonne aide.

:::{sources}
[Learning to write LaTeX classes and packages](faquk:FAQ-writecls)
:::
