/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class SQLServerExternalTable
extends SQLServerTableBase {
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public SQLServerExternalTable(@NotNull SQLServerSchema catalog, @NotNull ResultSet dbResult, @NotNull String name) {
        super(catalog, dbResult, name);
    }

    public SQLServerExternalTable(@NotNull SQLServerSchema schema) {
        super(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT et.location,eds.name AS data_source_name, eff.name AS file_format_name\nFROM " + SQLServerUtils.getSystemTableName(this.getDatabase(), "external_tables") + " et\nLEFT JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "external_data_sources") + " eds ON eds.data_source_id=et.data_source_id\nLEFT JOIN " + SQLServerUtils.getSystemTableName(this.getDatabase(), "external_file_formats") + " eff ON eff.file_format_id=et.file_format_id\nWHERE et.object_id=?");){
                    dbStat.setLong(1, this.getObjectId());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.additionalInfo.externalDataSource = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"data_source_name");
                            this.additionalInfo.externalFileFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"file_format_name");
                            this.additionalInfo.externalLocation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"location");
                        }
                        this.additionalInfo.loaded = true;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    @Override
    boolean supportsTriggers() {
        return false;
    }

    public boolean isView() {
        return false;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public boolean supportsObjectDefinitionOption(@NotNull String option) {
        return false;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)this, options, (boolean)false);
    }

    public void setObjectDefinitionText(String source) {
    }

    public static class AdditionalInfo {
        private boolean loaded;
        private String externalDataSource;
        private String externalFileFormat;
        private String externalLocation;

        @Property(viewable=true, order=7)
        @NotNull
        public String getExternalDataSource() {
            return this.externalDataSource;
        }

        @Property(viewable=true, order=8)
        @Nullable
        public String getExternalFileFormat() {
            return this.externalFileFormat;
        }

        @Property(viewable=true, order=9)
        @NotNull
        public String getExternalLocation() {
            return this.externalLocation;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<SQLServerExternalTable> {
        public boolean isPropertyCached(SQLServerExternalTable object, Object propertyId) {
            return object.additionalInfo.loaded;
        }
    }
}

