/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.dbeaver.model.ai.engine.TooManyRequestsException;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIRequestFilter;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIMessage;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIModel;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIModelList;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesChunk;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesRequest;
import org.jkiss.dbeaver.model.ai.engine.openai.dto.OAIResponsesResponse;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.ai.utils.MonitoredHttpClient;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class OpenAIClient
implements Closeable {
    private static final Log log = Log.getLog(OpenAIClient.class);
    public static final String OPENAI_ENDPOINT = "https://api.openai.com/v1/";
    private static final String DATA_EVENT = "data: ";
    private static final String EVENT_EVENT = "event: ";
    protected static final Duration TIMEOUT = Duration.ofSeconds(30L);
    protected static final Gson GSON = JSONUtils.GSON;
    public static final String EVENT_TYPE_RESPONSE_COMPLETED = "response.completed";
    public static final String EVENT_TYPE_ITEM_DONE = "response.output_item.done";
    public static final String EVENT_TYPE_ARGUMENTS_DELTA = "response.function_call_arguments.delta";
    public static final String EVENT_TYPE_TEXT_DELTA = "response.output_text.delta";
    protected final String baseUrl;
    protected final List<HttpRequestFilter> requestFilters;
    protected final MonitoredHttpClient client = new MonitoredHttpClient(HttpClient.newBuilder().build());

    public OpenAIClient(@NotNull String baseUrl, @NotNull List<HttpRequestFilter> requestFilters) {
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        this.baseUrl = baseUrl;
        this.requestFilters = requestFilters;
    }

    @NotNull
    static AIFunctionCall createFunctionCall(OAIMessage message) throws DBException {
        Map arguments;
        String argumentsStr = message.arguments;
        try {
            arguments = (Map)JSONUtils.GSON.fromJson(argumentsStr, JSONUtils.MAP_TYPE_TOKEN);
        }
        catch (JsonSyntaxException e) {
            throw new DBException("Error parsing function call arguments", (Throwable)e);
        }
        AIFunctionCall fc = new AIFunctionCall(message.name, arguments);
        return fc;
    }

    @NotNull
    public HttpClient getHttpClient() {
        return this.client.getHttpClient();
    }

    public static OpenAIClient createClient(String baseUrl, String token) {
        return new OpenAIClient(baseUrl, List.of(new OpenAIRequestFilter(token)));
    }

    @NotNull
    public List<OAIModel> getModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, "models")).GET().timeout(TIMEOUT).build();
        HttpRequest modifiedRequest = this.applyFilters(request);
        HttpResponse<String> response = this.client.send(monitor, modifiedRequest);
        if (response.statusCode() == 200) {
            return ((OAIModelList)GSON.fromJson(response.body(), OAIModelList.class)).data();
        }
        throw new DBException("Models read failed: " + response.statusCode() + ", body=" + response.body());
    }

    private HttpRequest createCompletionRequest(@NotNull OAIResponsesRequest completionRequest) throws DBException {
        return HttpRequest.newBuilder().uri(AIHttpUtils.resolve(this.baseUrl, this.getResponsesEndpoint())).header("User-Agent", GeneralUtils.getProductTitle()).POST(HttpRequest.BodyPublishers.ofString(OpenAIClient.serializeValue(completionRequest))).timeout(TIMEOUT).build();
    }

    @NotNull
    protected String getResponsesEndpoint() {
        return "responses";
    }

    @NotNull
    public OAIResponsesResponse createChatCompletion(@NotNull DBRProgressMonitor monitor, @NotNull OAIResponsesRequest completionRequest) throws DBException {
        HttpRequest request = this.createCompletionRequest(completionRequest);
        HttpRequest modifiedRequest = this.applyFilters(request);
        HttpResponse<String> response = this.client.send(monitor, modifiedRequest);
        String body = response.body();
        if (response.statusCode() == 200) {
            return (OAIResponsesResponse)GSON.fromJson(body, OAIResponsesResponse.class);
        }
        if (response.statusCode() == 429) {
            throw new TooManyRequestsException("Too many requests: " + body);
        }
        throw new DBException("OpenAI request failed: " + response.statusCode() + ", body=" + body);
    }

    public void createChatCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull OAIResponsesRequest completionRequest, @NotNull AIEngineResponseConsumer listener) throws DBException {
        HttpRequest request = this.createCompletionRequest(completionRequest);
        HttpRequest modifiedRequest = this.applyFilters(request);
        StreamConsumer stringConsumer = new StreamConsumer(listener);
        this.client.sendAsync(modifiedRequest, stringConsumer, listener::error, listener::close);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public HttpRequest applyFilters(@NotNull HttpRequest request) throws DBException {
        return this.applyFilters(request, true);
    }

    public HttpRequest applyFilters(@NotNull HttpRequest request, boolean setContentType) throws DBException {
        for (HttpRequestFilter filter : this.requestFilters) {
            request = filter.filter(request, setContentType);
        }
        return request;
    }

    @NotNull
    protected static String serializeValue(@Nullable Object value) throws DBException {
        try {
            return GSON.toJson(value);
        }
        catch (Exception e) {
            throw new DBException("Error serializing value", (Throwable)e);
        }
    }

    public static interface HttpRequestFilter {
        @NotNull
        public HttpRequest filter(@NotNull HttpRequest var1, boolean var2) throws DBException;
    }

    private static class StreamConsumer
    implements Consumer<String> {
        private final AIEngineResponseConsumer listener;
        private boolean functionCall;

        public StreamConsumer(AIEngineResponseConsumer listener) {
            this.listener = listener;
        }

        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void accept(String event) {
            if (CommonUtils.isEmpty((String)event)) {
                return;
            }
            if (!event.startsWith("data: ")) ** GOTO lbl36
            data = event.substring("data: ".length()).trim();
            try {
                block22: {
                    chunk = (OAIResponsesChunk)OpenAIClient.GSON.fromJson(data, OAIResponsesChunk.class);
                    if ("response.completed".equals(chunk.type)) {
                        this.listener.close();
                        return;
                    }
                    if (chunk.item != null && "function_call".equals(chunk.item.type)) {
                        if (!"response.output_item.done".equals(chunk.type)) {
                            this.functionCall = true;
                            return;
                        }
                        if (chunk.item != null) {
                            this.listener.nextChunk(new AIEngineResponseChunk(OpenAIClient.createFunctionCall(chunk.item)));
                        }
                        this.functionCall = false;
                        return;
                    }
                    if (this.functionCall != false) return;
                    choices = new ArrayList<String>();
                    if (!"response.output_text.delta".equals(chunk.type)) break block22;
                    choices.add(chunk.delta);
                    ** GOTO lbl32
                }
                if (chunk.response == null) ** GOTO lbl32
                var6_8 = chunk.response.output.iterator();
lbl27:
                // 2 sources

                while (true) {
                    block23: {
                        if (!var6_8.hasNext()) break block23;
                        msg = var6_8.next();
                        var8_11 = msg.content.iterator();
                        if (true) ** GOTO lbl88
                    }
                    if (choices.isEmpty() != false) return;
                    this.listener.nextChunk(new AIEngineResponseChunk(choices));
                    return;
                }
lbl36:
                // 1 sources

                if (!event.startsWith("event: ")) ** GOTO lbl74
                eventType = event.substring("event: ".length()).trim();
                if (CommonUtils.isEmpty((String)eventType) != false) return;
                var3_6 = eventType;
                tmp = -1;
                switch (var3_6.hashCode()) {
                    case -1737091636: {
                        if (!var3_6.equals("response.output_item.done")) break;
                        tmp = 1;
                        ** break;
                    }
                    case -633500686: {
                        if (!var3_6.equals("response.output_text.done")) break;
                        tmp = 1;
                        ** break;
                    }
                    case -215634966: {
                        if (!var3_6.equals("response.content_part.done")) break;
                        tmp = 1;
                        ** break;
                    }
                    case 301945306: {
                        if (!var3_6.equals("response.in_progress")) break;
                        tmp = 1;
                        ** break;
                    }
                    case 713544251: {
                        if (!var3_6.equals("response.created")) break;
                        tmp = 1;
                        ** break;
                    }
                    case 814923998: {
                        if (!var3_6.equals("response.completed")) break;
                        tmp = 1;
                        ** break;
                    }
                    case 1836015944: {
                        if (!var3_6.equals("response.output_text.delta")) break;
                        tmp = 1;
                        ** break;
                    }
                    case 1981626358: {
                        if (!var3_6.equals("response.output_item.added")) ** break;
                        tmp = 1;
                        ** break;
                    }
lbl74:
                    // 1 sources

                    OpenAIClient.log.debug((Object)("Unknown OpenAI event: " + event));
                    return;
lbl76:
                    // 10 sources

                }
                switch (tmp) {
                    default: {
                        return;
                    }
                    case 1: 
                }
                return;
                do {
                    content = var8_11.next();
                    if (CommonUtils.isEmpty((String)content.text)) continue;
                    choices.add(content.text);
lbl88:
                    // 3 sources

                } while (var8_11.hasNext());
                ** continue;
            }
            catch (Exception e) {
                this.listener.error(e);
                return;
            }
        }
    }
}

