/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.format;

import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AIQueryConfirmationRule;
import org.jkiss.dbeaver.model.ai.AISchemaGenerator;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class DefaultFormattingConfigurator
implements IObjectPropertyConfigurator<AISchemaGenerator, AISettings> {
    private Button includeSourceTextInCommentCheck;
    private Button executeQueryImmediatelyCheck;
    private Button sendTypeInfoCheck;
    private Button sendDescriptionCheck;
    protected Composite settingsPanel;
    private Combo languageText;
    private Combo confirmSQLCombo;
    private Combo confirmDDLCombo;
    private Combo confirmDMLCombo;

    public void createControl(@NotNull Composite parent, AISchemaGenerator object, @NotNull Runnable propertyChangeListener) {
        this.settingsPanel = UIUtils.createComposite((Composite)parent, (int)2);
        this.settingsPanel.setLayoutData((Object)new GridData(768));
        Composite leftPanel = UIUtils.createComposite((Composite)this.settingsPanel, (int)1);
        leftPanel.setLayoutData((Object)new GridData(768));
        this.createLeftPanel(leftPanel, propertyChangeListener);
        Composite rightPanel = UIUtils.createComposite((Composite)this.settingsPanel, (int)1);
        rightPanel.setLayoutData((Object)new GridData(1040));
        this.createRightPanel(rightPanel);
    }

    protected void createLeftPanel(@NotNull Composite leftPanel, @NotNull Runnable propertyChangeListener) {
        Group generalComposite = UIUtils.createControlGroup((Composite)leftPanel, (String)UIMessages.ui_properties_tree_viewer_category_general, (int)2, (int)770, (int)-1);
        this.languageText = UIUtils.createLabelCombo((Composite)generalComposite, (String)UIMessages.controls_locale_selector_label_language, (int)4);
        ((GridData)this.languageText.getLayoutData()).widthHint = 100;
        this.languageText.setToolTipText("Language AI engine should use in chat by default.\nYou can enter any natural language name.\nIf not specified then AI will reply in the same language you use for prompts.");
        TreeSet<String> languages = new TreeSet<String>();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            languages.add(locale.getDisplayLanguage());
            ++n2;
        }
        this.languageText.setItems(languages.toArray(new String[0]));
        Group completionGroup = UIUtils.createControlGroup((Composite)leftPanel, (String)"SQL Completion", (int)1, (int)770, (int)-1);
        Composite appearanceSettings = UIUtils.createComposite((Composite)completionGroup, (int)2);
        appearanceSettings.setLayoutData((Object)new GridData(770));
        this.createAppearanceSettings(appearanceSettings, propertyChangeListener);
        Composite completionComposite = UIUtils.createComposite((Composite)completionGroup, (int)2);
        completionComposite.setLayoutData((Object)new GridData(768));
        this.createCompletionSettings(completionComposite, propertyChangeListener);
        Group queryExecutionSettingsGroup = UIUtils.createControlGroup((Composite)leftPanel, (String)AIUIMessages.gpt_preference_page_ai_query_confirm_group, (int)2, (int)770, (int)-1);
        this.createQueryExecutionSettings((Composite)queryExecutionSettingsGroup);
    }

    protected void createQueryExecutionSettings(@NotNull Composite chatSettingsGroup) {
        this.confirmSQLCombo = this.createConfirmQueryCombo(chatSettingsGroup, "Select", "Confirm regular SQL select queries");
        this.confirmSQLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_execute);
        this.confirmSQLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_confirm);
        this.confirmSQLCombo.select(0);
        this.confirmDMLCombo = this.createConfirmQueryCombo(chatSettingsGroup, "Modify", "Confirm INSERT/DELETE/UPDATE queries");
        this.confirmDMLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_execute);
        this.confirmDMLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_confirm);
        this.confirmDMLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_disable_autocommit);
        this.confirmDMLCombo.select(1);
        this.confirmDDLCombo = this.createConfirmQueryCombo(chatSettingsGroup, "Schema", "Confirm schema modification queries (CREATE, DROP, ALTER, etc)");
        this.confirmDDLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_execute);
        this.confirmDDLCombo.add(AIUIMessages.gpt_preference_page_ai_query_confirm_rule_confirm);
        this.confirmDDLCombo.select(1);
    }

    @NotNull
    private Combo createConfirmQueryCombo(@NotNull Composite group, @NotNull String queryType, String hint) {
        Combo combo = UIUtils.createLabelCombo((Composite)group, (String)queryType, (String)hint, (int)12);
        combo.setLayoutData((Object)new GridData(32));
        return combo;
    }

    protected void createRightPanel(Composite rightPanel) {
        Group schemaGroup = UIUtils.createControlGroup((Composite)rightPanel, (String)AIUIMessages.gpt_preference_page_schema_group, (int)2, (int)0, (int)5);
        this.createSchemaSettings((Composite)schemaGroup);
    }

    protected void createCompletionSettings(Composite completionGroup, Runnable propertyChangeListener) {
        completionGroup.setLayoutData((Object)new GridData(1808));
        this.executeQueryImmediatelyCheck = UIUtils.createCheckbox((Composite)completionGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_label, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_tip, (boolean)false, (int)2);
    }

    protected void createSchemaSettings(Composite schemaGroup) {
        schemaGroup.setLayoutData((Object)new GridData(770));
        this.sendTypeInfoCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_send_type_label, (String)AIUIMessages.gpt_preference_page_completion_send_type_tip, (boolean)false, (int)2);
        this.sendDescriptionCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_description_label, (String)AIUIMessages.gpt_preference_page_completion_execute_description_tip, (boolean)false, (int)2);
    }

    protected void createAppearanceSettings(Composite appearanceGroup, Runnable propertyChangeListener) {
        this.includeSourceTextInCommentCheck = UIUtils.createCheckbox((Composite)appearanceGroup, (String)AIUIMessages.gpt_preference_page_completion_include_source_label, (String)AIUIMessages.gpt_preference_page_completion_include_source_tip, (boolean)false, (int)2);
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.languageText.setText(CommonUtils.notEmpty((String)store.getString("ai.language")));
        this.includeSourceTextInCommentCheck.setSelection(store.getBoolean("ai.completion.includeSourceTextInQuery"));
        this.executeQueryImmediatelyCheck.setSelection(store.getBoolean("ai.completion.executeImmediately"));
        this.sendTypeInfoCheck.setSelection(store.getBoolean("ai.completion.sendType"));
        this.sendDescriptionCheck.setSelection(store.getBoolean("ai.completion.description"));
        AIQueryConfirmationRule confirmSqlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)store.getString("ai.confirmation.sql"), (Enum)AIQueryConfirmationRule.EXECUTE);
        this.confirmSQLCombo.select(confirmSqlRule.ordinal());
        AIQueryConfirmationRule confirmDmlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)store.getString("ai.confirmation.dml"), (Enum)AIQueryConfirmationRule.CONFIRM);
        this.confirmDMLCombo.select(confirmDmlRule.ordinal());
        AIQueryConfirmationRule confirmDdlRule = (AIQueryConfirmationRule)CommonUtils.valueOf(AIQueryConfirmationRule.class, (String)store.getString("ai.confirmation.ddl"), (Enum)AIQueryConfirmationRule.CONFIRM);
        this.confirmDDLCombo.select(confirmDdlRule.ordinal());
    }

    public void saveSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.language", this.languageText.getText());
        store.setValue("ai.completion.includeSourceTextInQuery", this.includeSourceTextInCommentCheck.getSelection());
        store.setValue("ai.completion.executeImmediately", this.executeQueryImmediatelyCheck.getSelection());
        store.setValue("ai.completion.sendType", this.sendTypeInfoCheck.getSelection());
        store.setValue("ai.completion.description", this.sendDescriptionCheck.getSelection());
        store.setValue("ai.confirmation.sql", ((AIQueryConfirmationRule)CommonUtils.fromOrdinal(AIQueryConfirmationRule.class, (int)this.confirmSQLCombo.getSelectionIndex())).name());
        store.setValue("ai.confirmation.dml", ((AIQueryConfirmationRule)CommonUtils.fromOrdinal(AIQueryConfirmationRule.class, (int)this.confirmDMLCombo.getSelectionIndex())).name());
        store.setValue("ai.confirmation.ddl", ((AIQueryConfirmationRule)CommonUtils.fromOrdinal(AIQueryConfirmationRule.class, (int)this.confirmDDLCombo.getSelectionIndex())).name());
    }

    public void resetSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setToDefault("ai.confirmation.sql");
        store.setToDefault("ai.confirmation.dml");
        store.setToDefault("ai.confirmation.ddl");
    }

    public boolean isComplete() {
        return true;
    }
}

