/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.controls;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AITextUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.controls.ScopeSelectorDialog;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ScopeSelectorControl
extends Composite {
    private static final Log log = Log.getLog(ScopeSelectorControl.class);
    private DBSLogicalDataSource dataSource;
    private DBCExecutionContext executionContext;
    private final Combo scopeCombo;
    private final Text scopeText;
    private final ToolItem scopeConfigItem;
    private final ToolBar toolBar;
    private final Set<String> checkedObjectIds;
    private AIDatabaseScope currentScope;

    public ScopeSelectorControl(@NotNull Composite parent, @NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext, @NotNull AICompletionSettings settings) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(5).create());
        this.dataSource = dataSource;
        this.executionContext = executionContext;
        this.currentScope = settings.getScope();
        this.checkedObjectIds = new LinkedHashSet<String>();
        if (!ArrayUtils.isEmpty((Object[])settings.getCustomObjectIds())) {
            this.checkedObjectIds.addAll(Arrays.asList(settings.getCustomObjectIds()));
        }
        this.scopeCombo = new Combo((Composite)this, 12);
        AIDatabaseScope[] aIDatabaseScopeArray = AIDatabaseScope.values();
        int n = aIDatabaseScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AIDatabaseScope scope = aIDatabaseScopeArray[n2];
            this.scopeCombo.add(scope.getTitle());
            if (this.currentScope == scope) {
                this.scopeCombo.select(this.scopeCombo.getItemCount() - 1);
            }
            ++n2;
        }
        this.scopeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopeSelectorControl.this.changeScope((AIDatabaseScope)CommonUtils.fromOrdinal(AIDatabaseScope.class, (int)ScopeSelectorControl.this.scopeCombo.getSelectionIndex()));
            }
        });
        this.scopeText = new Text((Composite)this, 2056);
        this.scopeText.setEditable(false);
        this.scopeText.setLayoutData((Object)new GridData(768));
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.toolBar.setLayoutData((Object)new GridData(128));
        this.scopeConfigItem = UIUtils.createToolItem((ToolBar)this.toolBar, (String)"Customize", (DBPImage)UIIcon.RS_DETAILS, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.changeScope(AIDatabaseScope.CUSTOM)));
        this.showScopeSettings(this.currentScope);
    }

    public void setInput(@NotNull DBSLogicalDataSource dataSource, @NotNull DBCExecutionContext executionContext) {
        this.dataSource = dataSource;
        this.executionContext = executionContext;
        this.showScopeSettings(this.currentScope);
    }

    @NotNull
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @NotNull
    public Combo getScopeCombo() {
        return this.scopeCombo;
    }

    @NotNull
    public Text getScopeText() {
        return this.scopeText;
    }

    @NotNull
    public Set<String> getCheckedObjectIds() {
        return this.checkedObjectIds;
    }

    @NotNull
    public AIDatabaseScope getScope() {
        return this.currentScope;
    }

    @NotNull
    public List<DBSObject> getCustomEntities(@NotNull DBRProgressMonitor monitor) {
        return AITextUtils.loadCustomEntities((DBRProgressMonitor)monitor, (DBPDataSource)this.executionContext.getDataSource(), this.checkedObjectIds);
    }

    @NotNull
    public DBSLogicalDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    private void showScopeSettings(@NotNull AIDatabaseScope scope) {
        Object text = switch (scope) {
            case AIDatabaseScope.CURRENT_SCHEMA -> {
                if (CommonUtils.isNotEmpty((String)this.dataSource.getCurrentSchema())) {
                    yield this.dataSource.getCurrentSchema();
                }
                if (CommonUtils.isNotEmpty((String)this.dataSource.getCurrentCatalog())) {
                    yield this.dataSource.getCurrentCatalog();
                }
                yield this.dataSource.getDataSourceContainer().getName();
            }
            case AIDatabaseScope.CURRENT_DATABASE -> {
                if (CommonUtils.isNotEmpty((String)this.dataSource.getCurrentCatalog())) {
                    yield this.dataSource.getCurrentCatalog();
                }
                yield this.dataSource.getDataSourceContainer().getName();
            }
            case AIDatabaseScope.CURRENT_DATASOURCE -> this.dataSource.getDataSourceContainer().getName();
            default -> this.checkedObjectIds.size() + " object(s)";
        };
        this.scopeConfigItem.setEnabled(scope == AIDatabaseScope.CUSTOM);
        this.scopeText.setText(CommonUtils.toString((Object)text, (String)"N/A"));
        this.requestLayout();
        this.layout(true, true);
    }

    @Nullable
    public static List<String> chooseCustomEntities(@NotNull Shell shell, @NotNull DBRRunnableContext context, @NotNull DBCExecutionContext executionContext, @NotNull Set<String> ids) {
        DBPDataSource dataSource = executionContext.getDataSource();
        DBNModel navigator = Objects.requireNonNull(dataSource.getContainer().getProject().getNavigatorModel());
        ArrayList nodes = new ArrayList();
        try {
            context.run(true, true, monitor -> {
                for (DBSObject entity : AITextUtils.loadCustomEntities((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (Set)ids)) {
                    DBNDatabaseNode node = navigator.getNodeByObject(monitor, entity, true);
                    if (node == null) continue;
                    nodes.add(node);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.warn((Object)"Error loading custom entities", (Throwable)e);
        }
        ScopeSelectorDialog dialog = new ScopeSelectorDialog(shell, context, dataSource.getContainer(), executionContext, nodes);
        if (dialog.open() != 0) {
            return null;
        }
        List<? extends DBNNode> selected = dialog.getSelectedNodes();
        if (selected == null) {
            return null;
        }
        return selected.stream().map(DBNDatabaseNode.class::cast).map(DBNDatabaseNode::getValueObject).map(DBSObject.class::cast).map(DBUtils::getObjectFullId).collect(Collectors.toList());
    }

    public void changeScope(@NotNull AIDatabaseScope scope) {
        this.checkedObjectIds.clear();
        if (scope == AIDatabaseScope.CUSTOM) {
            List<String> ids = ScopeSelectorControl.chooseCustomEntities(this.getShell(), UIUtils.getDefaultRunnableContext(), this.executionContext, this.checkedObjectIds);
            if (ids == null) {
                return;
            }
            this.checkedObjectIds.addAll(ids);
        }
        this.currentScope = scope;
        this.showScopeSettings(scope);
    }
}

