/*
 * Copyright (c) 2020 Raspberry Pi (Trading) Ltd.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

// -----------------------------------------------------
// NOTE: THIS HEADER IS ALSO INCLUDED BY ASSEMBLER SO
//       SHOULD ONLY CONSIST OF PREPROCESSOR DIRECTIVES
// -----------------------------------------------------

// pico_cmake_set PICO_PLATFORM=rp2040

#ifndef _BOARDS_CYTRON_MAKER_PI_RP2040_H
#define _BOARDS_CYTRON_MAKER_PI_RP2040_H

// For board detection
#define CYTRON_MAKER_PI_RP2040

// --- BOARD SPECIFIC ---

// Motor driver
#ifndef MAKER_PI_RP2040_M1A_PIN
#define MAKER_PI_RP2040_M1A_PIN 8
#endif

#ifndef MAKER_PI_RP2040_M1B_PIN
#define MAKER_PI_RP2040_M1B_PIN 9
#endif

#ifndef MAKER_PI_RP2040_M2A_PIN
#define MAKER_PI_RP2040_M2A_PIN 10
#endif

#ifndef MAKER_PI_RP2040_M2B_PIN
#define MAKER_PI_RP2040_M2B_PIN 11
#endif

// Grove ports
#ifndef MAKER_PI_RP2040_GROVE1A_PIN
#define MAKER_PI_RP2040_GROVE1A_PIN 0
#endif

#ifndef MAKER_PI_RP2040_GROVE1B_PIN
#define MAKER_PI_RP2040_GROVE1B_PIN 1
#endif

#ifndef MAKER_PI_RP2040_GROVE2A_PIN
#define MAKER_PI_RP2040_GROVE2A_PIN 2
#endif

#ifndef MAKER_PI_RP2040_GROVE2B_PIN
#define MAKER_PI_RP2040_GROVE2B_PIN 3
#endif

#ifndef MAKER_PI_RP2040_GROVE3A_PIN
#define MAKER_PI_RP2040_GROVE3A_PIN 4
#endif

#ifndef MAKER_PI_RP2040_GROVE3B_PIN
#define MAKER_PI_RP2040_GROVE3B_PIN 5
#endif

#ifndef MAKER_PI_RP2040_GROVE4A_PIN
#define MAKER_PI_RP2040_GROVE4A_PIN 16
#endif

#ifndef MAKER_PI_RP2040_GROVE4B_PIN
#define MAKER_PI_RP2040_GROVE4B_PIN 17
#endif

#ifndef MAKER_PI_RP2040_GROVE5A_PIN
#define MAKER_PI_RP2040_GROVE5A_PIN 6
#endif

#ifndef MAKER_PI_RP2040_GROVE5B_PIN
#define MAKER_PI_RP2040_GROVE5B_PIN 26
#endif

#ifndef MAKER_PI_RP2040_GROVE6A_PIN
#define MAKER_PI_RP2040_GROVE6A_PIN 26
#endif

#ifndef MAKER_PI_RP2040_GROVE6B_PIN
#define MAKER_PI_RP2040_GROVE6B_PIN 27
#endif

#ifndef MAKER_PI_RP2040_GROVE7A_PIN
#define MAKER_PI_RP2040_GROVE7A_PIN 7
#endif

#ifndef MAKER_PI_RP2040_GROVE7B_PIN
#define MAKER_PI_RP2040_GROVE7B_PIN 28
#endif

// Buttons
#ifndef MAKER_PI_RP2040_BUTTON1_PIN
#define MAKER_PI_RP2040_BUTTON1_PIN 20
#endif

#ifndef MAKER_PI_RP2040_BUTTON2_PIN
#define MAKER_PI_RP2040_BUTTON2_PIN 21
#endif

// Servo headers
#ifndef MAKER_PI_RP2040_SERVO1_PIN
#define MAKER_PI_RP2040_SERVO1_PIN 12
#endif

#ifndef MAKER_PI_RP2040_SERVO2_PIN
#define MAKER_PI_RP2040_SERVO2_PIN 13
#endif

#ifndef MAKER_PI_RP2040_SERVO3_PIN
#define MAKER_PI_RP2040_SERVO3_PIN 14
#endif

#ifndef MAKER_PI_RP2040_SERVO4_PIN
#define MAKER_PI_RP2040_SERVO4_PIN 15
#endif

// --- UART ---
#ifndef PICO_DEFAULT_UART
#define PICO_DEFAULT_UART 0
#endif

#ifndef PICO_DEFAULT_UART_TX_PIN
#define PICO_DEFAULT_UART_TX_PIN 0
#endif

#ifndef PICO_DEFAULT_UART_RX_PIN
#define PICO_DEFAULT_UART_RX_PIN 1
#endif

// --- LED ---
#ifndef PICO_DEFAULT_WS2812_PIN
#define PICO_DEFAULT_WS2812_PIN 18
#endif

// This board has two WS2812 leds in series
#ifndef PICO_DEFAULT_WS2812_NUM_PIXELS
#define PICO_DEFAULT_WS2812_NUM_PIXELS 2
#endif

// --- I2C ---
#ifndef PICO_DEFAULT_I2C
#define PICO_DEFAULT_I2C 1
#endif

#ifndef PICO_DEFAULT_I2C_SDA_PIN
#define PICO_DEFAULT_I2C_SDA_PIN 6
#endif

#ifndef PICO_DEFAULT_I2C_SCL_PIN
#define PICO_DEFAULT_I2C_SCL_PIN 7
#endif

// --- SPI ---
#ifndef PICO_DEFAULT_SPI
#define PICO_DEFAULT_SPI 0
#endif

#ifndef PICO_DEFAULT_SPI_TX_PIN
#define PICO_DEFAULT_SPI_TX_PIN 3
#endif

#ifndef PICO_DEFAULT_SPI_RX_PIN
#define PICO_DEFAULT_SPI_RX_PIN 4
#endif

#ifndef PICO_DEFAULT_SPI_SCK_PIN
#define PICO_DEFAULT_SPI_SCK_PIN 2
#endif

// --- FLASH ---
#define PICO_BOOT_STAGE2_CHOOSE_W25Q080 1

#ifndef PICO_FLASH_SPI_CLKDIV
#define PICO_FLASH_SPI_CLKDIV 2
#endif

// pico_cmake_set_default PICO_FLASH_SIZE_BYTES = (2 * 1024 * 1024)
#ifndef PICO_FLASH_SIZE_BYTES
#define PICO_FLASH_SIZE_BYTES (2 * 1024 * 1024)
#endif
// All boards have B1 RP2040
#ifndef PICO_RP2040_B0_SUPPORTED
#define PICO_RP2040_B0_SUPPORTED 0
#endif

#endif
