/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.Formatter;

public final class PrettyPrinter {
    public static final int ARRAY_ELLIPSIS = 10;
    public static final int CHAR_ARRAY_ELLIPSIS = 20;
    public static final int CHAR_SEQUENCE_ELLIPSIS = 100;
    public static final int TOTAL_LENGTH_ELLIPSIS = 1024;

    private PrettyPrinter() {
    }

    @Nullable
    public static String toString(@Nullable Object o) {
        return o == null ? "null" : PrettyPrinter.appendObject(o, new StringBuilder()).toString();
    }

    public static String toJavaStringLiteral(@Nullable CharSequence cs) {
        return cs == null ? "null" : PrettyPrinter.appendCharSequence(cs, new StringBuilder()).toString();
    }

    public static String toJavaCharLiteral(char c) {
        return PrettyPrinter.appendCharLiteral(c, new StringBuilder()).toString();
    }

    public static String toJavaArrayInitializer(@Nullable Object array) {
        return array == null ? "null" : PrettyPrinter.appendArray(array, null, new StringBuilder()).toString();
    }

    @Nullable
    public static String codePointToJavaLiteral(int codePoint) {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            return new Formatter().format("0x%x", codePoint).toString();
        }
        return PrettyPrinter.appendCharLiteral((char)codePoint, new StringBuilder()).toString();
    }

    @Deprecated
    @Nullable
    public static String codePointToString(int cp) {
        return PrettyPrinter.codePointToJavaLiteral(cp);
    }

    private static StringBuilder appendObject(@Nullable Object o, StringBuilder sb) {
        if (o == null) {
            return sb.append("null");
        }
        Class<?> clasS = o.getClass();
        if (clasS.isArray()) {
            return PrettyPrinter.appendArray(o, null, sb);
        }
        if (o instanceof CharSequence) {
            return PrettyPrinter.appendCharSequence((CharSequence)o, sb);
        }
        if (clasS == Character.class) {
            return PrettyPrinter.appendCharLiteral(((Character)o).charValue(), sb);
        }
        if (clasS == Byte.class) {
            return sb.append(((Byte)o).toString()).append('B');
        }
        if (clasS == Short.class) {
            return sb.append(((Short)o).toString()).append('S');
        }
        if (clasS == Long.class) {
            return sb.append(((Long)o).toString()).append('L');
        }
        if (clasS == Float.class) {
            return sb.append(new DecimalFormat().format(((Float)o).floatValue())).append('F');
        }
        if (clasS == Double.class) {
            return sb.append(new DecimalFormat().format((Double)o)).append('D');
        }
        return sb.append(o);
    }

    private static StringBuilder appendArray(Object o, @Nullable Object[][] dejaVu, StringBuilder sb) {
        int length = Array.getLength(o);
        String canonicalName = PrettyPrinter.getPrettyClassName(o);
        int idx = canonicalName.indexOf(93);
        if (idx == -1) {
            throw new IllegalArgumentException(canonicalName);
        }
        sb.append(canonicalName.substring(0, idx)).append(length).append(canonicalName.substring(idx));
        if (length == 0) {
            return sb;
        }
        if (o.getClass().getComponentType() == Character.TYPE) {
            sb.append(" '");
            char[] ca = (char[])o;
            for (int i = 0; i < length; ++i) {
                if (i >= 20 || sb.length() >= 1024) {
                    return sb.append("'...");
                }
                PrettyPrinter.appendChar(ca[i], sb);
            }
            return sb.append('\'');
        }
        sb.append(" { ");
        int i = 0;
        while (true) {
            block14: {
                Object element;
                if ((element = Array.get(o, i)) instanceof Object[]) {
                    if (element == o) {
                        sb.append("[self]");
                    } else if (dejaVu == null) {
                        PrettyPrinter.appendArray(element, new Object[][]{(Object[])o}, sb);
                    } else {
                        for (Object[] other : dejaVu) {
                            if (element != other) continue;
                            sb.append("[parent]");
                            break block14;
                        }
                        Object[][] tmp = new Object[dejaVu.length + 1][];
                        System.arraycopy(dejaVu, 0, tmp, 0, dejaVu.length);
                        tmp[dejaVu.length] = (Object[])o;
                        PrettyPrinter.appendArray(element, tmp, sb);
                    }
                } else {
                    PrettyPrinter.appendObject(element, sb);
                }
            }
            if (++i == length) break;
            if (i >= 10 || sb.length() >= 1024) {
                return sb.append(", ... }");
            }
            sb.append(", ");
        }
        return sb.append(" }");
    }

    private static String getPrettyClassName(Object o) {
        String result = o.getClass().getCanonicalName();
        if (result.startsWith("java.")) {
            result = result.substring(result.lastIndexOf(46) + 1);
        }
        return result;
    }

    private static StringBuilder appendCharSequence(CharSequence cs, StringBuilder sb) {
        if (cs instanceof String) {
            sb.append('\"');
        } else {
            sb.append(PrettyPrinter.getPrettyClassName(cs)).append(" \"");
        }
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            if (i >= 100 || sb.length() >= 1024) {
                return sb.append("\"... (").append(length).append(" chars)");
            }
            PrettyPrinter.appendChar(cs.charAt(i), sb);
        }
        return sb.append('\"');
    }

    private static StringBuilder appendCharLiteral(char c, StringBuilder sb) {
        return PrettyPrinter.appendChar(c, sb.append('\'')).append('\'');
    }

    private static StringBuilder appendChar(char c, StringBuilder sb) {
        int idx = "\b\t\n\f\r\"'\\".indexOf(c);
        if (idx != -1) {
            return sb.append('\\').append("btnfr\"'\\".charAt(idx));
        }
        if (c < ' ') {
            return sb.append('\\').append(Integer.toOctalString(c));
        }
        if (c <= '\u00ff') {
            return sb.append(c);
        }
        new Formatter(sb).format("\\u%04x", c);
        return sb;
    }
}

