/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.regex.Pattern;

public final class ObjectUtil {
    private static final Pattern WORD_SEPARATOR = Pattern.compile("[\\s,]+");

    private ObjectUtil() {
    }

    public static <T> boolean equals(@Nullable T o1, @Nullable T o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence) {
            return StringUtil.equals((CharSequence)o1, (CharSequence)o2);
        }
        return o1.equals(o2);
    }

    public static int hashCode(@Nullable Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static <T> String toString(@Nullable T value, String defaultValue) {
        return value != null ? value.toString() : defaultValue;
    }

    public static <T> T or(@Nullable T lhs, T rhs) {
        return lhs == null ? rhs : lhs;
    }

    public static <T> T fromString(String text, Class<T> targetType) {
        if (targetType.isArray()) {
            Class<?> componentType = targetType.getComponentType();
            String[] words = WORD_SEPARATOR.split(text);
            Object array = Array.newInstance(componentType, words.length);
            for (int i = 0; i < words.length; ++i) {
                Array.set(array, i, ObjectUtil.fromString(words[i], componentType));
            }
            return (T)array;
        }
        if (targetType == String.class) {
            return (T)text;
        }
        try {
            if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                return (T)Boolean.valueOf(text);
            }
            if (targetType == Byte.TYPE || targetType == Byte.class) {
                return (T)Byte.valueOf(text);
            }
            if (targetType == Short.TYPE || targetType == Short.class) {
                return (T)Short.valueOf(text);
            }
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (T)Integer.valueOf(text);
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return (T)Long.valueOf(text);
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return (T)Float.valueOf(text);
            }
            if (targetType == Double.TYPE || targetType == Double.class) {
                return (T)Double.valueOf(text);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Cannot convert \"" + text + "\" to " + targetType.getSimpleName().toLowerCase());
        }
        if (targetType == Character.TYPE || targetType == Character.class) {
            if (text.length() == 0) {
                throw new IllegalArgumentException("Empty string");
            }
            if (text.length() > 1) {
                throw new IllegalArgumentException("String too long");
            }
            return (T)Character.valueOf(text.charAt(0));
        }
        if (targetType == char[].class) {
            return (T)text.toCharArray();
        }
        if (targetType == Charset.class) {
            return (T)Charset.forName(text);
        }
        if (targetType == Class.class) {
            try {
                return (T)Class.forName(text);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException(cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new IllegalArgumentException(ncdfe);
            }
        }
        if (targetType == Pattern.class) {
            return (T)Pattern.compile(text);
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            try {
                T constant = Enum.valueOf(targetType, text);
                return constant;
            }
            catch (IllegalArgumentException iae) {
                EnumSet<T> allConstants = EnumSet.allOf(targetType);
                throw new IllegalArgumentException("Invalid constant \"" + text + "\"; valid values are " + allConstants);
            }
        }
        try {
            return targetType.getConstructor(String.class).newInstance(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Instantiating " + targetType.getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    public static <T> T almostNull() {
        return null;
    }
}

