/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.type;

import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.StringResource;

public class ResourceCollectionDelta
implements ResourceCollection,
Iterable<Resource> {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private File stateFile = new File(System.getProperty("user.home"), ".resource-collection.delta.properties");
    @Nullable
    private String stateKey;
    private boolean added;
    private boolean deleted;
    private boolean modified;
    @Nullable
    private ResourceCollection delegate;
    @Nullable
    private Properties state;

    public void setStateFile(File file) {
        this.stateFile = file;
    }

    public void setStateKey(String key) {
        this.stateKey = key;
    }

    public void setAdded(boolean includeAddedResources) {
        this.added = includeAddedResources;
    }

    public void setDeleted(boolean includeDeletedResources) {
        this.deleted = includeDeletedResources;
    }

    public void setModified(boolean includeModifiedResources) {
        this.modified = includeModifiedResources;
    }

    public void addConfigured(ResourceCollection value) {
        if (this.delegate != null) {
            throw new BuildException("No more than one resource collection subelement allowed");
        }
        this.delegate = value;
    }

    public boolean isFilesystemOnly() {
        ResourceCollection delegate = this.delegate;
        assert (delegate != null);
        return delegate.isFilesystemOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Resource> iterator() {
        String oldValue;
        String key;
        Properties state;
        String stateKey;
        ResourceCollection delegate;
        block19: {
            delegate = this.delegate;
            if (delegate == null) {
                throw new BuildException("Resource collection subelement missing");
            }
            stateKey = this.stateKey;
            if (stateKey == null) {
                throw new BuildException("'stateKey=...' attribute missing");
            }
            try {
                state = this.state;
                if (state != null) break block19;
                state = new Properties();
                try {
                    FileInputStream is = new FileInputStream(this.stateFile);
                    try {
                        state.load(is);
                        is.close();
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (FileNotFoundException is) {}
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe);
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        df.setTimeZone(GMT);
        final Properties newState = new Properties();
        Resources result = new Resources();
        for (Resource subject : delegate) {
            key = stateKey + '@' + subject.getName();
            oldValue = state.getProperty(key);
            String newValue = df.format(subject.getLastModified());
            if (oldValue == null) {
                if (!this.added) continue;
                newState.setProperty(key, newValue);
                result.add((ResourceCollection)new StringResource(subject.getName()));
                continue;
            }
            if (newValue.equals(oldValue)) {
                newState.setProperty(key, newValue);
                continue;
            }
            if (this.modified) {
                newState.setProperty(key, newValue);
                result.add((ResourceCollection)new StringResource(subject.getName()));
                continue;
            }
            newState.setProperty(key, oldValue);
        }
        for (Map.Entry<Object, Object> entry : state.entrySet()) {
            key = (String)entry.getKey();
            oldValue = (String)entry.getValue();
            if (newState.containsKey(key)) continue;
            if (key.startsWith(stateKey + '@') && this.deleted) {
                result.add((ResourceCollection)new StringResource(key.substring(stateKey.length() + 1)));
                continue;
            }
            newState.setProperty(key, oldValue);
        }
        final Iterator tmp = result.iterator();
        return new Iterator<Resource>(){

            @Override
            public boolean hasNext() {
                FileOutputStream os;
                if (tmp.hasNext()) {
                    return true;
                }
                File stateFile = ResourceCollectionDelta.this.stateFile;
                File oldStateFile = new File(stateFile.getParent(), stateFile.getName() + ",old");
                File newStateFile = new File(stateFile.getParent(), stateFile.getName() + ",new");
                try {
                    os = new FileOutputStream(newStateFile);
                }
                catch (FileNotFoundException fnfe) {
                    throw new BuildException(fnfe.getMessage(), (Throwable)fnfe);
                }
                try {
                    newState.store(os, null);
                    ((OutputStream)os).close();
                }
                catch (IOException ioe) {
                    throw new BuildException(ioe.getMessage(), (Throwable)ioe);
                }
                finally {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Exception exception) {}
                }
                if (stateFile.exists()) {
                    oldStateFile.delete();
                    ResourceCollectionDelta.rename(stateFile, oldStateFile);
                    ResourceCollectionDelta.rename(newStateFile, stateFile);
                    ResourceCollectionDelta.delete(oldStateFile);
                } else {
                    ResourceCollectionDelta.rename(newStateFile, stateFile);
                }
                ResourceCollectionDelta.this.state = newState;
                return false;
            }

            @Override
            public Resource next() {
                return (Resource)tmp.next();
            }

            @Override
            public void remove() {
                tmp.remove();
            }
        };
    }

    public int size() {
        int result = 0;
        for (Resource unused : this) {
            ++result;
        }
        return result;
    }

    private static void delete(File file) {
        if (!file.delete()) {
            throw new BuildException("Could not delete '" + file);
        }
    }

    private static void rename(File source, File destination) {
        if (!source.renameTo(destination)) {
            throw new BuildException("Could not rename '" + source + "' to '" + destination);
        }
    }
}

