# Stefan Achatz 2012
#
# Tries to find libglib-2.0 and sets following variables according to found capabilities:
#
# GLIB2_FOUND
# GLIB2_INCLUDE_DIRS
# GLIB2_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_GLIB2 glib-2.0)

FIND_PATH(GLIB2_GLIB2_INCLUDE_DIRS glib.h
  HINTS
    ${PKG_GLIB2_INCLUDE_DIRS}
    ${PKG_GLIB2_INCLUDEDIR}
  PATH_SUFFIXES glib-2.0
)

FIND_PATH(GLIB2_GLIB2CONFIG_INCLUDE_DIRS glibconfig.h
  HINTS
    ${PKG_GLIB2_INCLUDE_DIRS}
    ${PKG_GLIB2_INCLUDEDIR}
  PATH_SUFFIXES glib-2.0
)

FIND_LIBRARY(GLIB2_GLIB2_LIBRARIES glib-2.0
  PATHS ${PKG_GLIB2_LIBRARY_DIRS}
)

FIND_PACKAGE(GOBJECT2)

IF(GLIB2_GLIB2_LIBRARIES AND GLIB2_GLIB2_INCLUDE_DIRS AND GLIB2_GLIB2CONFIG_INCLUDE_DIRS AND GOBJECT2_FOUND)
  SET(GLIB2_INCLUDE_DIRS ${GLIB2_GLIB2_INCLUDE_DIRS} ${GLIB2_GLIB2CONFIG_INCLUDE_DIRS} ${GOBJECT2_INCLUDE_DIRS})
  SET(GLIB2_LIBRARIES ${GLIB2_GLIB2_LIBRARIES} ${GOBJECT2_LIBRARIES})
  SET(GLIB2_FOUND true)
ENDIF()

IF(GLIB2_FIND_REQUIRED AND NOT GLIB2_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GLIB2")
ENDIF()
