/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.Serializable;
import jrm.profile.data.Anyware;
import jrm.profile.data.EntityBase;
import jrm.profile.data.EntityStatus;
import jrm.profile.scan.options.HashCollisionOptions;

public abstract class Entity
extends EntityBase
implements Serializable {
    public long size = 0L;
    public String crc = null;
    public String sha1 = null;
    public String md5 = null;
    public String merge = null;
    public Status status = Status.good;
    private transient boolean collision = false;

    protected Entity(Anyware parent) {
        super(parent);
    }

    public void setCollisionMode() {
        if (Anyware.hash_collision_mode == HashCollisionOptions.SINGLECLONE) {
            this.getParent().setCollisionMode(false);
        } else if (Anyware.hash_collision_mode == HashCollisionOptions.ALLCLONES) {
            this.getParent().setCollisionMode(true);
        }
        this.collision = true;
    }

    public boolean isCollisionMode(boolean dumber) {
        if (Anyware.hash_collision_mode == HashCollisionOptions.SINGLECLONE) {
            return this.getParent().isCollisionMode();
        }
        if (Anyware.hash_collision_mode == HashCollisionOptions.ALLCLONES) {
            return this.getParent().isCollisionMode();
        }
        if (dumber) {
            if (Anyware.hash_collision_mode == HashCollisionOptions.DUMBER) {
                return true;
            }
        } else {
            if (Anyware.hash_collision_mode == HashCollisionOptions.HALFDUMB) {
                return true;
            }
            if (Anyware.hash_collision_mode == HashCollisionOptions.DUMB) {
                return true;
            }
            if (Anyware.hash_collision_mode == HashCollisionOptions.DUMBER) {
                return true;
            }
        }
        return this.collision;
    }

    void resetCollisionMode() {
        this.collision = false;
        this.own_status = EntityStatus.UNKNOWN;
    }

    @Override
    public Anyware getParent() {
        return this.getParent(Anyware.class);
    }

    public String getCRC() {
        return this.crc;
    }

    public String getMD5() {
        return this.md5;
    }

    public String getSHA1() {
        return this.sha1;
    }

    public long getSize() {
        return this.size;
    }

    public static enum Status implements Serializable
    {
        baddump,
        nodump,
        good,
        verified;


        public Status getXML(boolean is_mame) {
            return good == this || is_mame && verified == this ? null : this;
        }
    }
}

