/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.router;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sf.clipsrules.jni.CLIPSLoadException;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.RouterTextArea;

class RouterDemo
implements ActionListener {
    JFrame routerDemoFrame;
    RouterTextArea autoTextArea;
    RouterTextArea animalTextArea;
    Environment autoEnv;
    Environment animalEnv;
    JButton restartAutoButton;
    JButton restartAnimalButton;
    ResourceBundle routerResources;

    RouterDemo() {
        try {
            this.routerResources = ResourceBundle.getBundle("net.sf.clipsrules.jni.examples.router.resources.RouterResources", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return;
        }
        this.autoEnv = new Environment();
        this.animalEnv = new Environment();
        this.routerDemoFrame = new JFrame(this.routerResources.getString("RouterDemo"));
        this.routerDemoFrame.getContentPane().setLayout(new BoxLayout(this.routerDemoFrame.getContentPane(), 1));
        this.routerDemoFrame.setSize(800, 550);
        this.routerDemoFrame.setMinimumSize(new Dimension(400, 250));
        this.routerDemoFrame.setDefaultCloseOperation(3);
        try {
            this.autoTextArea = new RouterTextArea(this.autoEnv);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            this.animalTextArea = new RouterTextArea(this.animalEnv);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        JScrollPane jScrollPane = new JScrollPane(this.autoTextArea);
        jScrollPane.setPreferredSize(new Dimension(800, 250));
        JScrollPane jScrollPane2 = new JScrollPane(this.animalTextArea);
        jScrollPane2.setPreferredSize(new Dimension(800, 250));
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(800, 50));
        this.restartAutoButton = new JButton(this.routerResources.getString("RestartAuto"));
        this.restartAutoButton.setEnabled(false);
        this.restartAutoButton.setActionCommand("RestartAuto");
        this.restartAutoButton.addActionListener(this);
        this.restartAnimalButton = new JButton(this.routerResources.getString("RestartAnimal"));
        this.restartAnimalButton.setEnabled(false);
        this.restartAnimalButton.setActionCommand("RestartAnimal");
        this.restartAnimalButton.addActionListener(this);
        jPanel.add(this.restartAutoButton);
        jPanel.add(this.restartAnimalButton);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.restartAutoButton).addComponent(this.restartAnimalButton));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.restartAutoButton).addComponent(this.restartAnimalButton));
        this.routerDemoFrame.getContentPane().add(jPanel);
        this.routerDemoFrame.getContentPane().add(jScrollPane);
        this.routerDemoFrame.getContentPane().add(jScrollPane2);
        this.routerDemoFrame.pack();
        this.routerDemoFrame.setVisible(true);
        this.runAuto();
        this.runAnimal();
    }

    public void runAuto() {
        String[] stringArray = new String[]{"auto.clp", "auto_" + Locale.getDefault().getLanguage() + ".clp"};
        new CLIPSProgramRunner(this.autoEnv, stringArray, this.restartAutoButton).execute();
    }

    public void runAnimal() {
        String[] stringArray = new String[]{"bcengine.clp", "animal.clp", "animal_" + Locale.getDefault().getLanguage() + ".clp"};
        new CLIPSProgramRunner(this.animalEnv, stringArray, this.restartAnimalButton).execute();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RouterDemo();
            }
        });
    }

    private void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getActionCommand().equals("RestartAuto")) {
            this.autoTextArea.setText("");
            this.restartAutoButton.setEnabled(false);
            this.autoTextArea.grabFocus();
            this.runAuto();
        } else if (actionEvent.getActionCommand().equals("RestartAnimal")) {
            this.animalTextArea.setText("");
            this.restartAnimalButton.setEnabled(false);
            this.animalTextArea.grabFocus();
            this.runAnimal();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class CLIPSProgramRunner
    extends SwingWorker<Integer, Integer> {
        Environment workEnv;
        String[] loadFiles;
        JButton restartButton;
        static final String resourcePath = "/net/sf/clipsrules/jni/examples/router/resources/";

        public CLIPSProgramRunner(Environment environment, String[] stringArray, JButton jButton) {
            this.workEnv = environment;
            this.loadFiles = stringArray;
            this.restartButton = jButton;
        }

        @Override
        protected Integer doInBackground() throws Exception {
            this.workEnv.clear();
            if (this.loadFiles != null) {
                try {
                    for (String string : this.loadFiles) {
                        this.workEnv.loadFromResource(resourcePath + string);
                    }
                }
                catch (CLIPSLoadException cLIPSLoadException) {
                    cLIPSLoadException.printStackTrace();
                    return 0;
                }
            }
            this.workEnv.reset();
            this.workEnv.run();
            return 1;
        }

        @Override
        protected void done() {
            try {
                this.restartButton.setEnabled(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

