/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.clipsrules.jni.examples.ide.FontDialog;

public class FontProperties
extends JPanel {
    protected JList<String> nameList;
    protected JList<String> styleList;
    protected JList<Integer> sizeList;
    protected FontDialog frame;
    public static final Integer[] fontSizes = new Integer[]{9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 28, 32, 36, 48, 64};
    public static final String[] fontStyles = new String[]{"Regular", "Italic", "Bold", "Bold Italic"};

    public FontProperties(FontDialog fontDialog) {
        this.frame = fontDialog;
        this.createComponents();
        this.buildLayout();
    }

    protected void buildLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JLabel jLabel = new JLabel("Font:");
        jLabel.setLabelFor(this.nameList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalGlue());
        this.nameList.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.nameList);
        jScrollPane.setPreferredSize(new Dimension(240, 160));
        jScrollPane.setMinimumSize(new Dimension(240, 65));
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.55;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.add(jScrollPane);
        this.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        JLabel jLabel2 = new JLabel("Style:");
        jLabel.setLabelFor(this.styleList);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.add(jLabel2);
        jPanel4.add(Box.createHorizontalGlue());
        this.styleList.setVisibleRowCount(4);
        jScrollPane = new JScrollPane(this.styleList);
        jScrollPane.setPreferredSize(new Dimension(90, 95));
        jScrollPane.setMinimumSize(new Dimension(90, 65));
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel3.add(jPanel4);
        jPanel3.add(jScrollPane);
        this.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 3));
        JLabel jLabel3 = new JLabel("Size:");
        jLabel3.setLabelFor(this.sizeList);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 2));
        jPanel6.add(jLabel3);
        jPanel6.add(Box.createHorizontalGlue());
        this.sizeList.setVisibleRowCount(5);
        jScrollPane = new JScrollPane(this.sizeList);
        jScrollPane.setPreferredSize(new Dimension(90, 95));
        jScrollPane.setMinimumSize(new Dimension(90, 65));
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.15;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel5.add(jPanel6);
        jPanel5.add(jScrollPane);
        this.add(jPanel5);
    }

    protected void createComponents() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.nameList = new JList<String>(stringArray);
        this.nameList.setSelectedIndex(0);
        this.nameList.setSelectionMode(0);
        this.nameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    FontProperties.this.handleFontPropertyChange();
                }
            }
        });
        this.styleList = new JList<String>(fontStyles);
        this.styleList.setSelectedIndex(0);
        this.styleList.setSelectionMode(0);
        this.styleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    FontProperties.this.handleFontPropertyChange();
                }
            }
        });
        this.sizeList = new JList<Integer>(fontSizes);
        this.sizeList.setSelectedIndex(0);
        this.sizeList.setSelectionMode(0);
        this.sizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    FontProperties.this.handleFontPropertyChange();
                }
            }
        });
    }

    public void setFont(String string, String string2, Integer n) {
        this.nameList.setSelectedValue(string, true);
        this.styleList.setSelectedValue(string2, true);
        this.sizeList.setSelectedValue(n, true);
    }

    protected void handleFontPropertyChange() {
        this.frame.refreshDisplayFont();
    }

    public String getSelectedFontName() {
        return this.nameList.getSelectedValue();
    }

    public int getSelectedFontSize() {
        Integer n = this.sizeList.getSelectedValue();
        return n;
    }

    public boolean isBoldSelected() {
        String string = this.styleList.getSelectedValue();
        return string.contains("Bold");
    }

    public boolean isItalicSelected() {
        String string = this.styleList.getSelectedValue();
        return string.contains("Italic");
    }
}

