/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.animal;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import net.sf.clipsrules.jni.CLIPSException;
import net.sf.clipsrules.jni.Environment;
import net.sf.clipsrules.jni.FactAddressValue;
import net.sf.clipsrules.jni.LexemeValue;
import net.sf.clipsrules.jni.MultifieldValue;
import net.sf.clipsrules.jni.StringValue;

class AnimalDemo
implements ActionListener {
    JLabel displayLabel;
    JButton nextButton;
    JButton prevButton;
    JPanel choicesPanel;
    ButtonGroup choicesButtons;
    ResourceBundle animalResources;
    Environment clips;
    boolean isExecuting = false;
    Thread executionThread;
    String lastAnswer;
    String relationAsserted;
    ArrayList<String> variableAsserts;
    ArrayList<String> priorAnswers;
    InterviewState interviewState;

    AnimalDemo() {
        try {
            this.animalResources = ResourceBundle.getBundle("net.sf.clipsrules.jni.examples.animal.resources.AnimalResources", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            return;
        }
        JFrame jFrame = new JFrame(this.animalResources.getString("AnimalDemo"));
        jFrame.getContentPane().setLayout(new GridLayout(3, 1));
        jFrame.setSize(350, 200);
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        this.displayLabel = new JLabel();
        jPanel.add(this.displayLabel);
        this.choicesPanel = new JPanel();
        this.choicesButtons = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        this.prevButton = new JButton(this.animalResources.getString("Prev"));
        this.prevButton.setActionCommand("Prev");
        jPanel2.add(this.prevButton);
        this.prevButton.addActionListener(this);
        this.nextButton = new JButton(this.animalResources.getString("Next"));
        this.nextButton.setActionCommand("Next");
        jPanel2.add(this.nextButton);
        this.nextButton.addActionListener(this);
        jFrame.getContentPane().add(jPanel);
        jFrame.getContentPane().add(this.choicesPanel);
        jFrame.getContentPane().add(jPanel2);
        this.variableAsserts = new ArrayList();
        this.priorAnswers = new ArrayList();
        this.clips = new Environment();
        try {
            this.clips.loadFromResource("/net/sf/clipsrules/jni/examples/animal/resources/bcengine.clp");
            this.clips.loadFromResource("/net/sf/clipsrules/jni/examples/animal/resources/animal.clp");
            try {
                this.clips.loadFromResource("/net/sf/clipsrules/jni/examples/animal/resources/animal_" + Locale.getDefault().getLanguage() + ".clp");
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Locale.getDefault().getLanguage().equals("en")) {
                    throw fileNotFoundException;
                }
                this.clips.loadFromResource("/net/sf/clipsrules/jni/examples/animal/resources/animal_en.clp");
            }
            this.processRules();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        jFrame.setVisible(true);
    }

    private void handleResponse() throws Exception {
        FactAddressValue factAddressValue = this.clips.findFact("UI-state");
        if (factAddressValue.getSlotValue("state").toString().equals("conclusion")) {
            this.interviewState = InterviewState.CONCLUSION;
            this.nextButton.setActionCommand("Restart");
            this.nextButton.setText(this.animalResources.getString("Restart"));
            this.prevButton.setVisible(true);
            this.choicesPanel.setVisible(false);
        } else if (factAddressValue.getSlotValue("state").toString().equals("greeting")) {
            this.interviewState = InterviewState.GREETING;
            this.nextButton.setActionCommand("Next");
            this.nextButton.setText(this.animalResources.getString("Next"));
            this.prevButton.setVisible(false);
            this.choicesPanel.setVisible(false);
        } else {
            this.interviewState = InterviewState.INTERVIEW;
            this.nextButton.setActionCommand("Next");
            this.nextButton.setText(this.animalResources.getString("Next"));
            this.prevButton.setVisible(true);
            this.choicesPanel.setVisible(true);
        }
        this.choicesPanel.removeAll();
        this.choicesButtons = new ButtonGroup();
        MultifieldValue multifieldValue = (MultifieldValue)factAddressValue.getSlotValue("display-answers");
        MultifieldValue multifieldValue2 = (MultifieldValue)factAddressValue.getSlotValue("valid-answers");
        String string = factAddressValue.getSlotValue("response").toString();
        AbstractButton abstractButton = null;
        for (int i = 0; i < multifieldValue.size(); ++i) {
            LexemeValue lexemeValue = (LexemeValue)multifieldValue.get(i);
            LexemeValue lexemeValue2 = (LexemeValue)multifieldValue2.get(i);
            String string2 = lexemeValue.getValue();
            String string3 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            String string4 = lexemeValue2.getValue();
            JRadioButton jRadioButton = this.lastAnswer != null && string4.equals(this.lastAnswer) || this.lastAnswer == null && string4.equals(string) ? new JRadioButton(string3, true) : new JRadioButton(string3, false);
            jRadioButton.setActionCommand(string4);
            this.choicesPanel.add(jRadioButton);
            this.choicesButtons.add(jRadioButton);
            if (abstractButton != null) continue;
            abstractButton = jRadioButton;
        }
        if (this.choicesButtons.getSelection() == null && abstractButton != null) {
            this.choicesButtons.setSelected(abstractButton.getModel(), true);
        }
        this.choicesPanel.repaint();
        this.relationAsserted = ((LexemeValue)factAddressValue.getSlotValue("relation-asserted")).getValue();
        String string5 = ((StringValue)factAddressValue.getSlotValue("display")).getValue();
        this.wrapLabelText(this.displayLabel, string5);
        this.executionThread = null;
        this.isExecuting = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void runAnimal() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    AnimalDemo.this.clips.run();
                }
                catch (CLIPSException cLIPSException) {
                    cLIPSException.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AnimalDemo.this.handleResponse();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        };
        this.isExecuting = true;
        this.executionThread = new Thread(runnable);
        this.executionThread.start();
    }

    private void processRules() throws CLIPSException {
        this.clips.reset();
        for (String string : this.variableAsserts) {
            String string2 = "(assert " + string + ")";
            this.clips.eval(string2);
        }
        this.runAnimal();
    }

    private void nextButtonAction() throws CLIPSException {
        this.lastAnswer = null;
        switch (this.interviewState) {
            case GREETING: 
            case INTERVIEW: {
                String string = this.choicesButtons.getSelection().getActionCommand();
                String string2 = "(variable (name " + this.relationAsserted + ") (value " + string + "))";
                this.variableAsserts.add(string2);
                this.priorAnswers.add(string);
                break;
            }
            case CONCLUSION: {
                this.variableAsserts.clear();
                this.priorAnswers.clear();
            }
        }
        this.processRules();
    }

    private void prevButtonAction() throws CLIPSException {
        this.lastAnswer = this.priorAnswers.get(this.priorAnswers.size() - 1);
        this.variableAsserts.remove(this.variableAsserts.size() - 1);
        this.priorAnswers.remove(this.priorAnswers.size() - 1);
        this.processRules();
    }

    private void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (this.isExecuting) {
            return;
        }
        if (actionEvent.getActionCommand().equals("Next")) {
            this.nextButtonAction();
        } else if (actionEvent.getActionCommand().equals("Restart")) {
            this.nextButtonAction();
        } else if (actionEvent.getActionCommand().equals("Prev")) {
            this.prevButtonAction();
        }
    }

    private void wrapLabelText(JLabel jLabel, String string) {
        int n;
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        Container container = jLabel.getParent();
        int n2 = container.getWidth();
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
        if (n3 <= n2) {
            n = n2;
        } else {
            int n4 = (n3 + n2) / n2;
            n = n3 / n4;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer("<html><center>");
        int n5 = breakIterator.first();
        int n6 = breakIterator.next();
        while (n6 != -1) {
            String string2 = string.substring(n5, n6);
            stringBuffer.append(string2);
            int n7 = SwingUtilities.computeStringWidth(fontMetrics, stringBuffer.toString());
            if (n7 > n2) {
                stringBuffer = new StringBuffer(string2);
                stringBuffer2.append("<br>");
                stringBuffer2.append(string2);
            } else if (n7 > n) {
                stringBuffer = new StringBuffer("");
                stringBuffer2.append(string2);
                stringBuffer2.append("<br>");
            } else {
                stringBuffer2.append(string2);
            }
            n5 = n6;
            n6 = breakIterator.next();
        }
        stringBuffer2.append("</html>");
        jLabel.setText(stringBuffer2.toString());
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AnimalDemo();
            }
        });
    }

    private static enum InterviewState {
        GREETING,
        INTERVIEW,
        CONCLUSION;

    }
}

