/*
 * gvfs.h
 * Copyright (C) 2002 Florin Malita <mali@go.ro>
 *
 * This file is part of LUFS, a free userspace filesystem implementation.
 * See http://lufs.sourceforge.net/ for updates.
 *
 * LUFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LUFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GVFS_H_
#define _GVFS_H_

using namespace std;

struct directory;
struct dir_cache;

class GVFS{
  private:
    struct credentials *cred;
    struct dir_cache *cache;
    struct list_head *cfg;

  public:
    GVFS(struct list_head*, struct dir_cache*, struct credentials*);
    ~GVFS();

    int do_mount();
    int do_readdir(char*, struct directory*);
    int do_stat(char*, struct lufs_fattr*);
    int do_mkdir(char*, int);
    int do_rmdir(char*);
    int do_create(char*, int);
    int do_unlink(char*);
    int do_rename(char*, char*);
    int do_open(char*, unsigned);
    int do_release(char*);
    int do_read(char*, long long, unsigned long, char*);
    int do_write(char*, long long, unsigned long, char*);
    int do_readlink(char*, char*, int);
    int do_link(char*, char*);
    int do_symlink(char*, char*);
    int do_setattr(char*, struct lufs_fattr*);
};

#endif
