// SPDX-License-Identifier: MIT
// Copyright (C) 2018-present iced project and contributors

use core::fmt;

// GENERATOR-BEGIN: CtorKind
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum CtorKind {
	Previous,
	Normal_1,
	Normal_2,
	AamAad,
	asz,
	String,
	STIG2_2b,
	bcst,
	bnd,
	SignExt_4,
	DeclareData,
	XLAT,
	er_2,
	er_3,
	far,
	far_mem,
	invlpga,
	maskmovq,
	SignExt_3,
	STIG1,
	STIG2_2a,
	movabs,
	sae,
	nop,
	OpSize,
	OpSize2_bnd,
	OpSize3,
	os_2,
	os_3,
	os_call,
	push_imm,
	CC_1,
	CC_2,
	CC_3,
	os_jcc_a_1,
	os_jcc_a_2,
	os_jcc_a_3,
	os_jcc_b_1,
	os_jcc_b_2,
	os_jcc_b_3,
	os_loopcc,
	os_loop,
	os_mem,
	os_mem_reg16,
	os_mem2,
	pblendvb,
	push_imm8,
	pclmulqdq,
	pops,
	imul,
	Reg16,
	Reg32,
	reverse,
}
#[rustfmt::skip]
static GEN_DEBUG_CTOR_KIND: [&str; 53] = [
	"Previous",
	"Normal_1",
	"Normal_2",
	"AamAad",
	"asz",
	"String",
	"STIG2_2b",
	"bcst",
	"bnd",
	"SignExt_4",
	"DeclareData",
	"XLAT",
	"er_2",
	"er_3",
	"far",
	"far_mem",
	"invlpga",
	"maskmovq",
	"SignExt_3",
	"STIG1",
	"STIG2_2a",
	"movabs",
	"sae",
	"nop",
	"OpSize",
	"OpSize2_bnd",
	"OpSize3",
	"os_2",
	"os_3",
	"os_call",
	"push_imm",
	"CC_1",
	"CC_2",
	"CC_3",
	"os_jcc_a_1",
	"os_jcc_a_2",
	"os_jcc_a_3",
	"os_jcc_b_1",
	"os_jcc_b_2",
	"os_jcc_b_3",
	"os_loopcc",
	"os_loop",
	"os_mem",
	"os_mem_reg16",
	"os_mem2",
	"pblendvb",
	"push_imm8",
	"pclmulqdq",
	"pops",
	"imul",
	"Reg16",
	"Reg32",
	"reverse",
];
impl fmt::Debug for CtorKind {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_CTOR_KIND[*self as usize])
	}
}
impl Default for CtorKind {
	#[must_use]
	#[inline]
	fn default() -> Self {
		CtorKind::Previous
	}
}
// GENERATOR-END: CtorKind

// GENERATOR-BEGIN: SignExtendInfo
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum SignExtendInfo {
	None,
	Sex1to2,
	Sex1to4,
	Sex1to8,
	Sex4to8,
	Sex2,
	Sex4,
}
#[rustfmt::skip]
static GEN_DEBUG_SIGN_EXTEND_INFO: [&str; 7] = [
	"None",
	"Sex1to2",
	"Sex1to4",
	"Sex1to8",
	"Sex4to8",
	"Sex2",
	"Sex4",
];
impl fmt::Debug for SignExtendInfo {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_SIGN_EXTEND_INFO[*self as usize])
	}
}
impl Default for SignExtendInfo {
	#[must_use]
	#[inline]
	fn default() -> Self {
		SignExtendInfo::None
	}
}
// GENERATOR-END: SignExtendInfo

// GENERATOR-BEGIN: SizeOverride
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum SizeOverride {
	None,
	Size16,
	Size32,
	Size64,
}
#[rustfmt::skip]
static GEN_DEBUG_SIZE_OVERRIDE: [&str; 4] = [
	"None",
	"Size16",
	"Size32",
	"Size64",
];
impl fmt::Debug for SizeOverride {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_SIZE_OVERRIDE[*self as usize])
	}
}
impl Default for SizeOverride {
	#[must_use]
	#[inline]
	fn default() -> Self {
		SizeOverride::None
	}
}
// GENERATOR-END: SizeOverride

// GENERATOR-BEGIN: BranchSizeInfo
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum BranchSizeInfo {
	None,
	Near,
	NearWord,
	NearDword,
	Word,
	Dword,
	Short,
}
#[rustfmt::skip]
static GEN_DEBUG_BRANCH_SIZE_INFO: [&str; 7] = [
	"None",
	"Near",
	"NearWord",
	"NearDword",
	"Word",
	"Dword",
	"Short",
];
impl fmt::Debug for BranchSizeInfo {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_BRANCH_SIZE_INFO[*self as usize])
	}
}
impl Default for BranchSizeInfo {
	#[must_use]
	#[inline]
	fn default() -> Self {
		BranchSizeInfo::None
	}
}
// GENERATOR-END: BranchSizeInfo

// GENERATOR-BEGIN: InstrOpInfoFlags
// ⚠️This was generated by GENERATOR!🦹‍♂️
pub(crate) struct InstrOpInfoFlags;
#[allow(dead_code)]
impl InstrOpInfoFlags {
	pub(crate) const NONE: u32 = 0x0000_0000;
	pub(crate) const MEM_SIZE_NOTHING: u32 = 0x0000_0001;
	pub(crate) const SHOW_NO_MEM_SIZE_FORCE_SIZE: u32 = 0x0000_0002;
	pub(crate) const SHOW_MIN_MEM_SIZE_FORCE_SIZE: u32 = 0x0000_0004;
	pub(crate) const SIZE_OVERRIDE_MASK: u32 = 0x0000_0003;
	pub(crate) const OP_SIZE_SHIFT: u32 = 0x0000_0003;
	pub(crate) const OP_SIZE16: u32 = 0x0000_0008;
	pub(crate) const OP_SIZE32: u32 = 0x0000_0010;
	pub(crate) const OP_SIZE64: u32 = 0x0000_0018;
	pub(crate) const ADDR_SIZE_SHIFT: u32 = 0x0000_0005;
	pub(crate) const ADDR_SIZE16: u32 = 0x0000_0020;
	pub(crate) const ADDR_SIZE32: u32 = 0x0000_0040;
	pub(crate) const ADDR_SIZE64: u32 = 0x0000_0060;
	pub(crate) const BRANCH_SIZE_INFO_SHIFT: u32 = 0x0000_0007;
	pub(crate) const BRANCH_SIZE_INFO_MASK: u32 = 0x0000_0007;
	pub(crate) const BRANCH_SIZE_INFO_SHORT: u32 = 0x0000_0300;
	pub(crate) const SIGN_EXTEND_INFO_SHIFT: u32 = 0x0000_000A;
	pub(crate) const SIGN_EXTEND_INFO_MASK: u32 = 0x0000_0007;
	pub(crate) const MEMORY_SIZE_INFO_SHIFT: u32 = 0x0000_000D;
	pub(crate) const MEMORY_SIZE_INFO_MASK: u32 = 0x0000_0003;
	pub(crate) const FAR_MEMORY_SIZE_INFO_SHIFT: u32 = 0x0000_000F;
	pub(crate) const FAR_MEMORY_SIZE_INFO_MASK: u32 = 0x0000_0003;
	pub(crate) const REGISTER_TO: u32 = 0x0002_0000;
	pub(crate) const BND_PREFIX: u32 = 0x0004_0000;
	pub(crate) const MNEMONIC_IS_DIRECTIVE: u32 = 0x0008_0000;
	pub(crate) const JCC_NOT_TAKEN: u32 = 0x0010_0000;
	pub(crate) const JCC_TAKEN: u32 = 0x0020_0000;
	pub(crate) const MEMORY_SIZE_BITS: u32 = 0x0000_0008;
	pub(crate) const MEMORY_SIZE_SHIFT: u32 = 0x0000_0016;
	pub(crate) const MEMORY_SIZE_MASK: u32 = 0x0000_00FF;
}
// GENERATOR-END: InstrOpInfoFlags

// GENERATOR-BEGIN: InstrOpKind
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum InstrOpKind {
	Register,
	NearBranch16,
	NearBranch32,
	NearBranch64,
	FarBranch16,
	FarBranch32,
	Immediate8,
	Immediate8_2nd,
	Immediate16,
	Immediate32,
	Immediate64,
	Immediate8to16,
	Immediate8to32,
	Immediate8to64,
	Immediate32to64,
	MemorySegSI,
	MemorySegESI,
	MemorySegRSI,
	MemorySegDI,
	MemorySegEDI,
	MemorySegRDI,
	MemoryESDI,
	MemoryESEDI,
	MemoryESRDI,
	Memory,
	Sae,
	RnSae,
	RdSae,
	RuSae,
	RzSae,
	Rn,
	Rd,
	Ru,
	Rz,
	DeclareByte,
	DeclareWord,
	DeclareDword,
	DeclareQword,
}
#[rustfmt::skip]
static GEN_DEBUG_INSTR_OP_KIND: [&str; 38] = [
	"Register",
	"NearBranch16",
	"NearBranch32",
	"NearBranch64",
	"FarBranch16",
	"FarBranch32",
	"Immediate8",
	"Immediate8_2nd",
	"Immediate16",
	"Immediate32",
	"Immediate64",
	"Immediate8to16",
	"Immediate8to32",
	"Immediate8to64",
	"Immediate32to64",
	"MemorySegSI",
	"MemorySegESI",
	"MemorySegRSI",
	"MemorySegDI",
	"MemorySegEDI",
	"MemorySegRDI",
	"MemoryESDI",
	"MemoryESEDI",
	"MemoryESRDI",
	"Memory",
	"Sae",
	"RnSae",
	"RdSae",
	"RuSae",
	"RzSae",
	"Rn",
	"Rd",
	"Ru",
	"Rz",
	"DeclareByte",
	"DeclareWord",
	"DeclareDword",
	"DeclareQword",
];
impl fmt::Debug for InstrOpKind {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_INSTR_OP_KIND[*self as usize])
	}
}
impl Default for InstrOpKind {
	#[must_use]
	#[inline]
	fn default() -> Self {
		InstrOpKind::Register
	}
}
// GENERATOR-END: InstrOpKind

// GENERATOR-BEGIN: MemorySizeInfo
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum MemorySizeInfo {
	None,
	Word,
	Dword,
	Qword,
}
#[rustfmt::skip]
static GEN_DEBUG_MEMORY_SIZE_INFO: [&str; 4] = [
	"None",
	"Word",
	"Dword",
	"Qword",
];
impl fmt::Debug for MemorySizeInfo {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_MEMORY_SIZE_INFO[*self as usize])
	}
}
impl Default for MemorySizeInfo {
	#[must_use]
	#[inline]
	fn default() -> Self {
		MemorySizeInfo::None
	}
}
// GENERATOR-END: MemorySizeInfo

// GENERATOR-BEGIN: FarMemorySizeInfo
// ⚠️This was generated by GENERATOR!🦹‍♂️
#[derive(Copy, Clone, Eq, PartialEq)]
#[allow(non_camel_case_types)]
#[allow(dead_code)]
pub(crate) enum FarMemorySizeInfo {
	None,
	Word,
	Dword,
}
#[rustfmt::skip]
static GEN_DEBUG_FAR_MEMORY_SIZE_INFO: [&str; 3] = [
	"None",
	"Word",
	"Dword",
];
impl fmt::Debug for FarMemorySizeInfo {
	#[inline]
	fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
		write!(f, "{}", GEN_DEBUG_FAR_MEMORY_SIZE_INFO[*self as usize])
	}
}
impl Default for FarMemorySizeInfo {
	#[must_use]
	#[inline]
	fn default() -> Self {
		FarMemorySizeInfo::None
	}
}
// GENERATOR-END: FarMemorySizeInfo
