#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "common.h"

void diep(const char *msg)
{
	perror(msg);
	exit(-1);
}
uint16_t cksum16(char *addr, uint32_t length)
{
	uint32_t sum = 0;

	/*Sum all 16 bit words*/
	while (length > 1)
	{
		sum = sum + *((uint16_t*) addr);
		length = length - 2;
		addr += sizeof(uint16_t);
	}
	/*Add left over byte if any*/
	if (length > 0)
		sum = sum + *((uint8_t*) addr);
	/*Fold 32bit sum to 16bits*/
	while (sum >> 16)
		sum = (sum & 0xFFFF) + (sum >> 16);

	return (uint16_t)(~sum);
}
