#!/usr/bin/env python3
from setuptools import setup, Extension

def main():
    setup(name='tipc',
          version='1.0.0',
          description='Python API for the tipc library function',
          author='Hoang Le',
          author_email='hoang.h.le@dektech.com.au',
          py_modules=['tipc'],
          url='http://www.tipc.io/',
          ext_modules=[
              Extension(
                  '_pylibtipc',
                  ['pylibtipc.c'],
                  include_dirs=['../include/'],
                  extra_link_args=['../libtipc/libtipc.a'])
              ],
)

if __name__ == '__main__':
    main()

