package main

import (
	"fmt"
	"../../../golang"
	"syscall"
)

// Application test
const (
	SERVER_TYPE  = 18888
	SERVER_INST  = 17
	BUF_SIZE     = 40
)

func main() {
	var inbuf []byte = make([]byte, BUF_SIZE)
	var outbuf []byte = []byte("Uh ?")
	var result int
	var client_addr tipc.TipcAddr = tipc.TipcAddr{0,0,0}

	///* Example OOP */
	fmt.Printf("****** TIPC server (GOLang API) hello world program started ******\n\n")

	var conn,err = tipc.NewConn(syscall.SOCK_RDM)
	if err != nil {
		fmt.Printf("Create socket failed: %s!\n", err)
		return
	}
	defer conn.Close()
	///* End */

	if ret := conn.Bind(SERVER_TYPE, SERVER_INST, SERVER_INST, 0); ret != 0 {
		fmt.Printf("Server: failed to bind port name\n")
		return
	}

	if ret := conn.Recvfrom(inbuf, &client_addr, nil, &result); ret <= 0 {
		fmt.Printf("Server: unexpected message\n")
		return
	}

	fmt.Printf("Server: Message received: %s !\n", inbuf)
	if ret := conn.Sendto(outbuf, &client_addr); ret < 0 {
		fmt.Printf("Server: failed to send\n")
		return
	}

	fmt.Printf("\n****** TIPC server (GOLang API) hello program finished ******\n")
}

