# pinmap

## Overview

This program reads a CSV (comma separated values) file and generates
Zephyr Device Tree entries for GPIOs and other configuration.

A basic Device Tree configuration is generated for I2C buses, ADC pins, GPIO pins
and PWM pins, with labels and nodes generated for each of the signals in the
spreadsheet.

A separate overlay Device Tree file can be used to modify the generated DTS
to allow specific properties and parameters to be set e.g bus speeds for I2C, conversion parameters
for ADCs, frequencies for PWM etc.

## Building

An ebuild file will eventually be created to integrate the building of the
utility to the standard host binary path.

In the meantime, the utility can be built directly via:

```

cd pinmap/pinmap
go build

```

This builds the `pinmap` binary in the `pinmap/pinmap` directory.
This binary can be run directly or moved to an appropriate binary directory.

## Executing

Running `pinmap --help` prints a usage page.

The `--reader` flag allows selecting different forms of input.
The default is `csv`, which is expected to be the downloaded CSV from a spreadsheet.

The `--chip` flag selects the EC part to be used.

## Spreadsheet format

An [example spreadsheet](http://go/cros-nissa-ec-pinmap) shows the format expected.

The first row should contain column titles that the CSV reader can match against to retrieve the
appropriate data. Currently the column names are fixed, but a TODO is to provide an external
map that allows the reader to be informed which columns are to be used.

Multiple EC chips may be supported in the same spreadsheet. The EC part name is set
as one of the column headers, and this column can be selected using the `--chip` flag.

An example of a working CSV file can also be viewed in the [file](readers/csv/testdata/data.csv)
used for the unit tests.

The key columns that are expected (and must match exactly) by the reader are:

| Column Title | Description |
| ----------- | ----------- |
| Signal Name | The net name as used in the circuit |
| Type | A drop down menu that indicates the type of pin (see the table below) |
| Enum | If set, this string will be added to the DTS node as the `enum-name` property |
| *chip* | This column contains the pin reference for this signal for this particular EC part number |

The **Type** column indicates exactly what the type of signal is, and is used to
generate the GPIO or other configuration flags in the DTS.

| Type Name | Description |
| ----------- | ----------- |
| `ADC` | An analogue to digital converter signal |
| `PWM` | A pulse width modulator signal |
| `PWM_INVERT` | A pulse width modulator signal with inverted output |
| `I2C_CLOCK` | The clock signal for an I2C bus |
| `I2C_DATA` | The data signal for an I2C bus (ignored) |
| `INPUT` | A GPIO input signal |
| `INPUT_PU` | A GPIO input signal with internal pull-up |
| `INPUT_PD` | A GPIO input signal with internal pull-down |
| `OUTPUT` | A GPIO output signal |
| `OUTPUT_ODR` | A GPIO output open drain signal |
| `OUTPUT_ODL` | A GPIO output open drain signal (default low) |
| `OTHER` | This signal is ignored, and no DTS configuration is generated for this pin |

For the I2C signals, only the `I2C_CLOCK` signal is used to determine which I2C
bus is referenced - the `I2C_DATA` signal is effectively ignored.

## Example use

Assume that the spreadsheet is downloaded as CSV format to the file `signals.csv`, and
a NPCX993 EC chip is selected, the following command can be run:

```
pinmap --chip=NPCX993 --output=generated.dts signals.csv
```

The file `generated.dts` contains the DTS configuration as processed and generated by the utility.

## TODO

- Read signals from arbitrage (requires more data in arbitrage)
- Build chip map from vendor data
