/* automatically generated by rust-bindgen */
#![allow(dead_code)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(improper_ctypes)]
#![allow(clippy::useless_transmute)]
#![allow(clippy::default_trait_access)]
#![allow(clippy::cast_lossless)]
#![allow(clippy::trivially_copy_pass_by_ref)]

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub unsafe fn as_ptr(&self) -> *const T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_mut_ptr(&mut self) -> *mut T {
        ::std::mem::transmute(self)
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
impl<T> ::std::clone::Clone for __IncompleteArrayField<T> {
    #[inline]
    fn clone(&self) -> Self {
        Self::new()
    }
}
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __register_t = __int64_t;
pub type __segsz_t = __int64_t;
pub type __size_t = __uint64_t;
pub type __time_t = __int64_t;
pub type __uintptr_t = __uint64_t;
pub type __vm_offset_t = __uint64_t;
pub type __vm_size_t = __uint64_t;
pub type __gid_t = __uint32_t;
pub type __lwpid_t = __int32_t;
pub type __off_t = __int64_t;
pub type __pid_t = __int32_t;
pub type __rlim_t = __int64_t;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __uid_t = __uint32_t;
pub type __fixpt_t = __uint32_t;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type u_int64_t = __uint64_t;
pub type caddr_t = *mut ::std::os::raw::c_char;
pub type fixpt_t = __fixpt_t;
pub type gid_t = __gid_t;
pub type lwpid_t = __lwpid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type register_t = __register_t;
pub type rlim_t = __rlim_t;
pub type sbintime_t = __int64_t;
pub type segsz_t = __segsz_t;
pub type suseconds_t = __suseconds_t;
pub type time_t = __time_t;
pub type uid_t = __uid_t;
pub type cap_rights_t = cap_rights;
pub type vm_offset_t = __vm_offset_t;
pub type vm_ooffset_t = __int64_t;
pub type vm_size_t = __vm_size_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset {
    pub __bits: [__uint32_t; 4usize],
}
pub type __sigset_t = __sigset;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: time_t,
    pub tv_usec: suseconds_t,
}
pub type sigset_t = __sigset_t;
pub type __sighandler_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
    pub sigval_int: ::std::os::raw::c_int,
    pub sigval_ptr: *mut ::std::os::raw::c_void,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub _reason: __siginfo__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __siginfo__bindgen_ty_1 {
    pub _fault: __siginfo__bindgen_ty_1__bindgen_ty_1,
    pub _timer: __siginfo__bindgen_ty_1__bindgen_ty_2,
    pub _mesgq: __siginfo__bindgen_ty_1__bindgen_ty_3,
    pub _poll: __siginfo__bindgen_ty_1__bindgen_ty_4,
    pub __spare__: __siginfo__bindgen_ty_1__bindgen_ty_5,
    _bindgen_union_align: [u64; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __siginfo__bindgen_ty_1__bindgen_ty_1 {
    pub _trapno: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __siginfo__bindgen_ty_1__bindgen_ty_2 {
    pub _timerid: ::std::os::raw::c_int,
    pub _overrun: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __siginfo__bindgen_ty_1__bindgen_ty_3 {
    pub _mqd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __siginfo__bindgen_ty_1__bindgen_ty_4 {
    pub _band: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __siginfo__bindgen_ty_1__bindgen_ty_5 {
    pub __spare1__: ::std::os::raw::c_long,
    pub __spare2__: [::std::os::raw::c_int; 7usize],
}
pub type siginfo_t = __siginfo;
pub type sig_t = __sighandler_t;
pub type stack_t = sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fpacc87 {
    pub fp_bytes: [u8; 10usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct xmmacc {
    pub xmm_bytes: [u8; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct envxmm {
    pub en_cw: u16,
    pub en_sw: u16,
    pub en_tw: u8,
    pub en_zero: u8,
    pub en_opcode: u16,
    pub en_rip: u64,
    pub en_rdp: u64,
    pub en_mxcsr: u32,
    pub en_mxcsr_mask: u32,
}
#[repr(C)]
#[repr(align(16))]
#[derive(Copy, Clone)]
pub struct savefpu {
    pub sv_env: envxmm,
    pub sv_fp: [savefpu__bindgen_ty_1; 8usize],
    pub sv_xmm: [xmmacc; 16usize],
    pub sv_pad: [u8; 96usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct savefpu__bindgen_ty_1 {
    pub fp_acc: fpacc87,
    pub fp_pad: [u8; 6usize],
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct system_segment_descriptor {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 24usize], u64>,
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct region_descriptor {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 16usize], u64>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pcb {
    pub pcb_r15: register_t,
    pub pcb_r14: register_t,
    pub pcb_r13: register_t,
    pub pcb_r12: register_t,
    pub pcb_rbp: register_t,
    pub pcb_rsp: register_t,
    pub pcb_rbx: register_t,
    pub pcb_rip: register_t,
    pub pcb_fsbase: register_t,
    pub pcb_gsbase: register_t,
    pub pcb_kgsbase: register_t,
    pub pcb_cr0: register_t,
    pub pcb_cr2: register_t,
    pub pcb_cr3: register_t,
    pub pcb_cr4: register_t,
    pub pcb_dr0: register_t,
    pub pcb_dr1: register_t,
    pub pcb_dr2: register_t,
    pub pcb_dr3: register_t,
    pub pcb_dr6: register_t,
    pub pcb_dr7: register_t,
    pub pcb_gdt: region_descriptor,
    pub pcb_idt: region_descriptor,
    pub pcb_ldt: region_descriptor,
    pub pcb_tr: u16,
    pub pcb_flags: u_int,
    pub pcb_initial_fpucw: u16,
    pub pcb_onfault: caddr_t,
    pub pcb_saved_ucr3: u64,
    pub pcb_tssp: *mut amd64tss,
    pub pcb_efer: register_t,
    pub pcb_star: register_t,
    pub pcb_lstar: register_t,
    pub pcb_cstar: register_t,
    pub pcb_sfmask: register_t,
    pub pcb_save: *mut savefpu,
    pub pcb_pad: [u64; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimerval {
    pub it_interval: timeval,
    pub it_value: timeval,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lock_object {
    pub lo_name: *const ::std::os::raw::c_char,
    pub lo_flags: u_int,
    pub lo_data: u_int,
    pub lo_witness: *mut witness,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mtx {
    pub lock_object: lock_object,
    pub mtx_lock: usize,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct callout {
    pub c_links: callout__bindgen_ty_1,
    pub c_time: sbintime_t,
    pub c_precision: sbintime_t,
    pub c_arg: *mut ::std::os::raw::c_void,
    pub c_func: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub c_lock: *mut lock_object,
    pub c_flags: ::std::os::raw::c_short,
    pub c_iflags: ::std::os::raw::c_short,
    pub c_cpu: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union callout__bindgen_ty_1 {
    pub le: callout__bindgen_ty_1__bindgen_ty_1,
    pub sle: callout__bindgen_ty_1__bindgen_ty_2,
    pub tqe: callout__bindgen_ty_1__bindgen_ty_3,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct callout__bindgen_ty_1__bindgen_ty_1 {
    pub le_next: *mut callout,
    pub le_prev: *mut *mut callout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct callout__bindgen_ty_1__bindgen_ty_2 {
    pub sle_next: *mut callout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct callout__bindgen_ty_1__bindgen_ty_3 {
    pub tqe_next: *mut callout,
    pub tqe_prev: *mut *mut callout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct knote {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct klist {
    pub slh_first: *mut knote,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kqueue {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kqlist {
    pub tqh_first: *mut kqueue,
    pub tqh_last: *mut *mut kqueue,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct knlist {
    pub kl_list: klist,
    pub kl_lock: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub kl_unlock: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub kl_assert_locked:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub kl_assert_unlocked:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub kl_lockarg: *mut ::std::os::raw::c_void,
    pub kl_autodestroy: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cv {
    pub cv_description: *const ::std::os::raw::c_char,
    pub cv_waiters: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cap_rights {
    pub cr_rights: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lock_list_entry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct priority {
    pub pri_class: u_char,
    pub pri_level: u_char,
    pub pri_native: u_char,
    pub pri_user: u_char,
}
pub type seq_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sx {
    pub lock_object: lock_object,
    pub sx_lock: usize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct filecaps {
    pub fc_rights: cap_rights_t,
    pub fc_ioctls: *mut u_long,
    pub fc_nioctls: i16,
    pub fc_fcntls: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct filedescent {
    pub fde_file: *mut file,
    pub fde_caps: filecaps,
    pub fde_flags: u8,
    pub fde_seq: seq_t,
}
#[repr(C)]
#[derive(Debug)]
pub struct fdescenttbl {
    pub fdt_nfiles: ::std::os::raw::c_int,
    pub fdt_ofiles: __IncompleteArrayField<filedescent>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct filedesc {
    pub fd_files: *mut fdescenttbl,
    pub fd_cdir: *mut vnode,
    pub fd_rdir: *mut vnode,
    pub fd_jdir: *mut vnode,
    pub fd_map: *mut u_long,
    pub fd_lastfile: ::std::os::raw::c_int,
    pub fd_freefile: ::std::os::raw::c_int,
    pub fd_cmask: u_short,
    pub fd_refcnt: ::std::os::raw::c_int,
    pub fd_holdcnt: ::std::os::raw::c_int,
    pub fd_sx: sx,
    pub fd_kqlist: kqlist,
    pub fd_holdleaderscount: ::std::os::raw::c_int,
    pub fd_holdleaderswakeup: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct filedesc_to_leader {
    pub fdl_refcount: ::std::os::raw::c_int,
    pub fdl_holdcount: ::std::os::raw::c_int,
    pub fdl_wakeup: ::std::os::raw::c_int,
    pub fdl_leader: *mut proc_,
    pub fdl_prev: *mut filedesc_to_leader,
    pub fdl_next: *mut filedesc_to_leader,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lock_profile_object {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lpohead {
    pub lh_first: *mut lock_profile_object,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct osd {
    pub osd_nslots: u_int,
    pub osd_slots: *mut *mut ::std::os::raw::c_void,
    pub osd_next: osd__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct osd__bindgen_ty_1 {
    pub le_next: *mut osd,
    pub le_prev: *mut *mut osd,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigio {
    pub sio_u: sigio__bindgen_ty_1,
    pub sio_pgsigio: sigio__bindgen_ty_2,
    pub sio_myref: *mut *mut sigio,
    pub sio_ucred: *mut ucred,
    pub sio_pgid: pid_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigio__bindgen_ty_1 {
    pub siu_proc: *mut proc_,
    pub siu_pgrp: *mut pgrp,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigio__bindgen_ty_2 {
    pub sle_next: *mut sigio,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigiolst {
    pub slh_first: *mut sigio,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigacts {
    pub ps_sigact: [sig_t; 128usize],
    pub ps_catchmask: [sigset_t; 128usize],
    pub ps_sigonstack: sigset_t,
    pub ps_sigintr: sigset_t,
    pub ps_sigreset: sigset_t,
    pub ps_signodefer: sigset_t,
    pub ps_siginfo: sigset_t,
    pub ps_sigignore: sigset_t,
    pub ps_sigcatch: sigset_t,
    pub ps_freebsd4: sigset_t,
    pub ps_osigset: sigset_t,
    pub ps_usertramp: sigset_t,
    pub ps_flag: ::std::os::raw::c_int,
    pub ps_refcnt: u_int,
    pub ps_mtx: mtx,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ksiginfo {
    pub ksi_link: ksiginfo__bindgen_ty_1,
    pub ksi_info: siginfo_t,
    pub ksi_flags: ::std::os::raw::c_int,
    pub ksi_sigq: *mut sigqueue,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ksiginfo__bindgen_ty_1 {
    pub tqe_next: *mut ksiginfo,
    pub tqe_prev: *mut *mut ksiginfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigqueue {
    pub sq_signals: sigset_t,
    pub sq_kill: sigset_t,
    pub sq_ptrace: sigset_t,
    pub sq_list: sigqueue__bindgen_ty_1,
    pub sq_proc: *mut proc_,
    pub sq_flags: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigqueue__bindgen_ty_1 {
    pub tqh_first: *mut ksiginfo,
    pub tqh_last: *mut *mut ksiginfo,
}
pub type sigqueue_t = sigqueue;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct domainset {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct domainset_ref {
    pub dr_policy: *mut domainset,
    pub dr_iter: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc_ldt {
    pub ldt_base: caddr_t,
    pub ldt_refcnt: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pmap_invl_gen {
    pub gen: u_long,
    pub link: pmap_invl_gen__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pmap_invl_gen__bindgen_ty_1 {
    pub le_next: *mut pmap_invl_gen,
    pub le_prev: *mut *mut pmap_invl_gen,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mdthread {
    pub md_spinlock_count: ::std::os::raw::c_int,
    pub md_saved_flags: register_t,
    pub md_spurflt_addr: register_t,
    pub md_invl_gen: pmap_invl_gen,
    pub md_efirt_tmp: register_t,
    pub md_efirt_dis_pf: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mdproc {
    pub md_ldt: *mut proc_ldt,
    pub md_ldt_sd: system_segment_descriptor,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct syscall_args {
    pub code: u_int,
    pub callp: *mut sysent,
    pub args: [register_t; 8usize],
    pub narg: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct session {
    pub s_count: u_int,
    pub s_leader: *mut proc_,
    pub s_ttyvp: *mut vnode,
    pub s_ttydp: *mut cdev_priv,
    pub s_ttyp: *mut tty,
    pub s_sid: pid_t,
    pub s_login: [::std::os::raw::c_char; 40usize],
    pub s_mtx: mtx,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pgrp {
    pub pg_hash: pgrp__bindgen_ty_1,
    pub pg_members: pgrp__bindgen_ty_2,
    pub pg_session: *mut session,
    pub pg_sigiolst: sigiolst,
    pub pg_id: pid_t,
    pub pg_jobc: ::std::os::raw::c_int,
    pub pg_mtx: mtx,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pgrp__bindgen_ty_1 {
    pub le_next: *mut pgrp,
    pub le_prev: *mut *mut pgrp,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pgrp__bindgen_ty_2 {
    pub lh_first: *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pargs {
    pub ar_ref: u_int,
    pub ar_length: u_int,
    pub ar_args: [u_char; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cpuset {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct filemon {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kaioinfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kaudit_record {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kdtrace_proc {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kdtrace_thread {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mqueue_notifier {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nlminfo {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct procdesc {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct racct {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sleepqueue {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct trapframe {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct turnstile {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rusage_ext {
    pub rux_runtime: u64,
    pub rux_uticks: u64,
    pub rux_sticks: u64,
    pub rux_iticks: u64,
    pub rux_uu: u64,
    pub rux_su: u64,
    pub rux_tu: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct thread {
    pub td_lock: *mut mtx,
    pub td_proc: *mut proc_,
    pub td_plist: thread__bindgen_ty_1,
    pub td_runq: thread__bindgen_ty_2,
    pub td_slpq: thread__bindgen_ty_3,
    pub td_lockq: thread__bindgen_ty_4,
    pub td_hash: thread__bindgen_ty_5,
    pub td_cpuset: *mut cpuset,
    pub td_domain: domainset_ref,
    pub td_sel: *mut seltd,
    pub td_sleepqueue: *mut sleepqueue,
    pub td_turnstile: *mut turnstile,
    pub td_rlqe: *mut rl_q_entry,
    pub td_umtxq: *mut umtx_q,
    pub td_tid: lwpid_t,
    pub td_sigqueue: sigqueue_t,
    pub td_lend_user_pri: u_char,
    pub td_epochnest: u_char,
    pub td_flags: ::std::os::raw::c_int,
    pub td_inhibitors: ::std::os::raw::c_int,
    pub td_pflags: ::std::os::raw::c_int,
    pub td_dupfd: ::std::os::raw::c_int,
    pub td_sqqueue: ::std::os::raw::c_int,
    pub td_wchan: *mut ::std::os::raw::c_void,
    pub td_wmesg: *const ::std::os::raw::c_char,
    pub td_owepreempt: u_char,
    pub td_tsqueue: u_char,
    pub td_locks: ::std::os::raw::c_short,
    pub td_rw_rlocks: ::std::os::raw::c_short,
    pub td_sx_slocks: ::std::os::raw::c_short,
    pub td_lk_slocks: ::std::os::raw::c_short,
    pub td_stopsched: ::std::os::raw::c_short,
    pub td_blocked: *mut turnstile,
    pub td_lockname: *const ::std::os::raw::c_char,
    pub td_contested: thread__bindgen_ty_6,
    pub td_sleeplocks: *mut lock_list_entry,
    pub td_intr_nesting_level: ::std::os::raw::c_int,
    pub td_pinned: ::std::os::raw::c_int,
    pub td_ucred: *mut ucred,
    pub td_limit: *mut plimit,
    pub td_slptick: ::std::os::raw::c_int,
    pub td_blktick: ::std::os::raw::c_int,
    pub td_swvoltick: ::std::os::raw::c_int,
    pub td_swinvoltick: ::std::os::raw::c_int,
    pub td_cow: u_int,
    pub td_ru: rusage,
    pub td_rux: rusage_ext,
    pub td_incruntime: u64,
    pub td_runtime: u64,
    pub td_pticks: u_int,
    pub td_sticks: u_int,
    pub td_iticks: u_int,
    pub td_uticks: u_int,
    pub td_intrval: ::std::os::raw::c_int,
    pub td_oldsigmask: sigset_t,
    pub td_generation: u_int,
    pub td_sigstk: stack_t,
    pub td_xsig: ::std::os::raw::c_int,
    pub td_profil_addr: u_long,
    pub td_profil_ticks: u_int,
    pub td_name: [::std::os::raw::c_char; 20usize],
    pub td_fpop: *mut file,
    pub td_dbgflags: ::std::os::raw::c_int,
    pub td_si: siginfo_t,
    pub td_ng_outbound: ::std::os::raw::c_int,
    pub td_osd: osd,
    pub td_map_def_user: *mut vm_map_entry,
    pub td_dbg_forked: pid_t,
    pub td_vp_reserv: u_int,
    pub td_no_sleeping: ::std::os::raw::c_int,
    pub td_su: *mut ::std::os::raw::c_void,
    pub td_sleeptimo: sbintime_t,
    pub td_rtcgen: ::std::os::raw::c_int,
    pub td_vslock_sz: usize,
    pub td_sigmask: sigset_t,
    pub td_rqindex: u_char,
    pub td_base_pri: u_char,
    pub td_priority: u_char,
    pub td_pri_class: u_char,
    pub td_user_pri: u_char,
    pub td_base_user_pri: u_char,
    pub td_pre_epoch_prio: u_char,
    pub td_rb_list: usize,
    pub td_rbp_list: usize,
    pub td_rb_inact: usize,
    pub td_sa: syscall_args,
    pub td_pcb: *mut pcb,
    pub td_state: thread__bindgen_ty_7,
    pub td_uretoff: thread__bindgen_ty_8,
    pub td_cowgen: u_int,
    pub td_slpcallout: callout,
    pub td_frame: *mut trapframe,
    pub td_kstack_obj: *mut vm_object,
    pub td_kstack: vm_offset_t,
    pub td_kstack_pages: ::std::os::raw::c_int,
    pub td_critnest: u_int,
    pub td_md: mdthread,
    pub td_ar: *mut kaudit_record,
    pub td_lprof: [lpohead; 2usize],
    pub td_dtrace: *mut kdtrace_thread,
    pub td_errno: ::std::os::raw::c_int,
    pub td_vnet: *mut vnet,
    pub td_vnet_lpush: *const ::std::os::raw::c_char,
    pub td_intr_frame: *mut trapframe,
    pub td_rfppwait_p: *mut proc_,
    pub td_ma: *mut *mut vm_page,
    pub td_ma_cnt: ::std::os::raw::c_int,
    pub td_emuldata: *mut ::std::os::raw::c_void,
    pub td_lastcpu: ::std::os::raw::c_int,
    pub td_oncpu: ::std::os::raw::c_int,
    pub td_lkpi_task: *mut ::std::os::raw::c_void,
    pub td_pmcpend: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread__bindgen_ty_1 {
    pub tqe_next: *mut thread,
    pub tqe_prev: *mut *mut thread,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread__bindgen_ty_2 {
    pub tqe_next: *mut thread,
    pub tqe_prev: *mut *mut thread,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread__bindgen_ty_3 {
    pub tqe_next: *mut thread,
    pub tqe_prev: *mut *mut thread,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread__bindgen_ty_4 {
    pub tqe_next: *mut thread,
    pub tqe_prev: *mut *mut thread,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread__bindgen_ty_5 {
    pub le_next: *mut thread,
    pub le_prev: *mut *mut thread,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct thread__bindgen_ty_6 {
    pub lh_first: *mut turnstile,
}
pub const thread_TDS_INACTIVE: thread__bindgen_ty_7 = 0;
pub const thread_TDS_INHIBITED: thread__bindgen_ty_7 = 1;
pub const thread_TDS_CAN_RUN: thread__bindgen_ty_7 = 2;
pub const thread_TDS_RUNQ: thread__bindgen_ty_7 = 3;
pub const thread_TDS_RUNNING: thread__bindgen_ty_7 = 4;
pub type thread__bindgen_ty_7 = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union thread__bindgen_ty_8 {
    pub tdu_retval: [register_t; 2usize],
    pub tdu_off: off_t,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct proc_ {
    pub p_list: proc__bindgen_ty_1,
    pub p_threads: proc__bindgen_ty_2,
    pub p_slock: mtx,
    pub p_ucred: *mut ucred,
    pub p_fd: *mut filedesc,
    pub p_fdtol: *mut filedesc_to_leader,
    pub p_stats: *mut pstats,
    pub p_limit: *mut plimit,
    pub p_limco: callout,
    pub p_sigacts: *mut sigacts,
    pub p_flag: ::std::os::raw::c_int,
    pub p_flag2: ::std::os::raw::c_int,
    pub p_state: proc__bindgen_ty_3,
    pub p_pid: pid_t,
    pub p_hash: proc__bindgen_ty_4,
    pub p_pglist: proc__bindgen_ty_5,
    pub p_pptr: *mut proc_,
    pub p_sibling: proc__bindgen_ty_6,
    pub p_children: proc__bindgen_ty_7,
    pub p_reaper: *mut proc_,
    pub p_reaplist: proc__bindgen_ty_8,
    pub p_reapsibling: proc__bindgen_ty_9,
    pub p_mtx: mtx,
    pub p_statmtx: mtx,
    pub p_itimmtx: mtx,
    pub p_profmtx: mtx,
    pub p_ksi: *mut ksiginfo,
    pub p_sigqueue: sigqueue_t,
    pub p_oppid: pid_t,
    pub p_vmspace: *mut vmspace,
    pub p_swtick: u_int,
    pub p_cowgen: u_int,
    pub p_realtimer: itimerval,
    pub p_ru: rusage,
    pub p_rux: rusage_ext,
    pub p_crux: rusage_ext,
    pub p_profthreads: ::std::os::raw::c_int,
    pub p_exitthreads: ::std::os::raw::c_int,
    pub p_traceflag: ::std::os::raw::c_int,
    pub p_tracevp: *mut vnode,
    pub p_tracecred: *mut ucred,
    pub p_textvp: *mut vnode,
    pub p_lock: u_int,
    pub p_sigiolst: sigiolst,
    pub p_sigparent: ::std::os::raw::c_int,
    pub p_sig: ::std::os::raw::c_int,
    pub p_code: u_long,
    pub p_stops: u_int,
    pub p_stype: u_int,
    pub p_step: ::std::os::raw::c_char,
    pub p_pfsflags: u_char,
    pub p_ptevents: u_int,
    pub p_nlminfo: *mut nlminfo,
    pub p_aioinfo: *mut kaioinfo,
    pub p_singlethread: *mut thread,
    pub p_suspcount: ::std::os::raw::c_int,
    pub p_xthread: *mut thread,
    pub p_boundary_count: ::std::os::raw::c_int,
    pub p_pendingcnt: ::std::os::raw::c_int,
    pub p_itimers: *mut itimers,
    pub p_procdesc: *mut procdesc,
    pub p_treeflag: u_int,
    pub p_pendingexits: ::std::os::raw::c_int,
    pub p_filemon: *mut filemon,
    pub p_pdeathsig: ::std::os::raw::c_int,
    pub p_magic: u_int,
    pub p_osrel: ::std::os::raw::c_int,
    pub p_comm: [::std::os::raw::c_char; 20usize],
    pub p_sysent: *mut sysentvec,
    pub p_args: *mut pargs,
    pub p_cpulimit: rlim_t,
    pub p_nice: ::std::os::raw::c_schar,
    pub p_fibnum: ::std::os::raw::c_int,
    pub p_reapsubtree: pid_t,
    pub p_elf_machine: u16,
    pub p_elf_flags: u64,
    pub p_xexit: u_int,
    pub p_xsig: u_int,
    pub p_pgrp: *mut pgrp,
    pub p_klist: *mut knlist,
    pub p_numthreads: ::std::os::raw::c_int,
    pub p_md: mdproc,
    pub p_itcallout: callout,
    pub p_acflag: u_short,
    pub p_peers: *mut proc_,
    pub p_leader: *mut proc_,
    pub p_emuldata: *mut ::std::os::raw::c_void,
    pub p_label: *mut label,
    pub p_ktr: proc__bindgen_ty_10,
    pub p_mqnotifier: proc__bindgen_ty_11,
    pub p_dtrace: *mut kdtrace_proc,
    pub p_pwait: cv,
    pub p_prev_runtime: u64,
    pub p_racct: *mut racct,
    pub p_throttled: ::std::os::raw::c_int,
    pub p_orphan: proc__bindgen_ty_12,
    pub p_orphans: proc__bindgen_ty_13,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_1 {
    pub le_next: *mut proc_,
    pub le_prev: *mut *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_2 {
    pub tqh_first: *mut thread,
    pub tqh_last: *mut *mut thread,
}
pub const proc__PRS_NEW: proc__bindgen_ty_3 = 0;
pub const proc__PRS_NORMAL: proc__bindgen_ty_3 = 1;
pub const proc__PRS_ZOMBIE: proc__bindgen_ty_3 = 2;
pub type proc__bindgen_ty_3 = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_4 {
    pub le_next: *mut proc_,
    pub le_prev: *mut *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_5 {
    pub le_next: *mut proc_,
    pub le_prev: *mut *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_6 {
    pub le_next: *mut proc_,
    pub le_prev: *mut *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_7 {
    pub lh_first: *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_8 {
    pub lh_first: *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_9 {
    pub le_next: *mut proc_,
    pub le_prev: *mut *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_10 {
    pub stqh_first: *mut ktr_request,
    pub stqh_last: *mut *mut ktr_request,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_11 {
    pub lh_first: *mut mqueue_notifier,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_12 {
    pub le_next: *mut proc_,
    pub le_prev: *mut *mut proc_,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct proc__bindgen_ty_13 {
    pub lh_first: *mut proc_,
}
pub type vm_inherit_t = ::std::os::raw::c_char;
pub type vm_prot_t = u_char;
pub type vm_map_entry_t = *mut vm_map_entry;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_object {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_page {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucred {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pmap_statistics {
    pub resident_count: ::std::os::raw::c_long,
    pub wired_count: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _cpuset {
    pub __bits: [::std::os::raw::c_long; 4usize],
}
pub type cpuset_t = _cpuset;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vm_radix {
    pub rt_root: usize,
}
pub type pml4_entry_t = u_int64_t;
pub const pmap_type_PT_X86: pmap_type = 0;
pub const pmap_type_PT_EPT: pmap_type = 1;
pub const pmap_type_PT_RVI: pmap_type = 2;
pub type pmap_type = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pmap_pcids {
    pub pm_pcid: u32,
    pub pm_gen: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pmap {
    pub pm_mtx: mtx,
    pub pm_pml4: *mut pml4_entry_t,
    pub pm_pml4u: *mut pml4_entry_t,
    pub pm_cr3: u64,
    pub pm_ucr3: u64,
    pub pm_pvchunk: pmap__bindgen_ty_1,
    pub pm_active: cpuset_t,
    pub pm_type: pmap_type,
    pub pm_stats: pmap_statistics,
    pub pm_root: vm_radix,
    pub pm_eptgen: ::std::os::raw::c_long,
    pub pm_flags: ::std::os::raw::c_int,
    pub pm_pcids: [pmap_pcids; 1usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pmap__bindgen_ty_1 {
    pub tqh_first: *mut pv_chunk,
    pub tqh_last: *mut *mut pv_chunk,
}
pub type pmap_t = *mut pmap;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pv_entry {
    pub pv_va: vm_offset_t,
    pub pv_next: pv_entry__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pv_entry__bindgen_ty_1 {
    pub tqe_next: *mut pv_entry,
    pub tqe_prev: *mut *mut pv_entry,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pv_chunk {
    pub pc_pmap: pmap_t,
    pub pc_list: pv_chunk__bindgen_ty_1,
    pub pc_map: [u64; 3usize],
    pub pc_lru: pv_chunk__bindgen_ty_2,
    pub pc_pventry: [pv_entry; 168usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pv_chunk__bindgen_ty_1 {
    pub tqe_next: *mut pv_chunk,
    pub tqe_prev: *mut *mut pv_chunk,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pv_chunk__bindgen_ty_2 {
    pub tqe_next: *mut pv_chunk,
    pub tqe_prev: *mut *mut pv_chunk,
}
pub type vm_flags_t = u_char;
pub type vm_eflags_t = u_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union vm_map_object {
    pub vm_object: *mut vm_object,
    pub sub_map: *mut vm_map,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vm_map_entry {
    pub prev: *mut vm_map_entry,
    pub next: *mut vm_map_entry,
    pub left: *mut vm_map_entry,
    pub right: *mut vm_map_entry,
    pub start: vm_offset_t,
    pub end: vm_offset_t,
    pub next_read: vm_offset_t,
    pub adj_free: vm_size_t,
    pub max_free: vm_size_t,
    pub object: vm_map_object,
    pub offset: vm_ooffset_t,
    pub eflags: vm_eflags_t,
    pub protection: vm_prot_t,
    pub max_protection: vm_prot_t,
    pub inheritance: vm_inherit_t,
    pub read_ahead: u8,
    pub wired_count: ::std::os::raw::c_int,
    pub cred: *mut ucred,
    pub wiring_thread: *mut thread,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vm_map {
    pub header: vm_map_entry,
    pub lock: sx,
    pub system_mtx: mtx,
    pub nentries: ::std::os::raw::c_int,
    pub size: vm_size_t,
    pub timestamp: u_int,
    pub needs_wakeup: u_char,
    pub system_map: u_char,
    pub flags: vm_flags_t,
    pub root: vm_map_entry_t,
    pub pmap: pmap_t,
    pub busy: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct vmspace {
    pub vm_map: vm_map,
    pub vm_shm: *mut shmmap_state,
    pub vm_swrss: segsz_t,
    pub vm_tsize: segsz_t,
    pub vm_dsize: segsz_t,
    pub vm_ssize: segsz_t,
    pub vm_taddr: caddr_t,
    pub vm_daddr: caddr_t,
    pub vm_maxsaddr: caddr_t,
    pub vm_refcnt: ::std::os::raw::c_int,
    pub vm_pmap: pmap,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pstats {
    pub p_cru: rusage,
    pub p_timer: [itimerval; 3usize],
    pub p_prof: pstats_uprof,
    pub p_start: timeval,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pstats_uprof {
    pub pr_base: caddr_t,
    pub pr_size: u_long,
    pub pr_off: u_long,
    pub pr_scale: u_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct kinfo_proc {
    pub ki_structsize: ::std::os::raw::c_int,
    pub ki_layout: ::std::os::raw::c_int,
    pub ki_args: *mut pargs,
    pub ki_paddr: *mut proc_,
    pub ki_addr: *mut user,
    pub ki_tracep: *mut vnode,
    pub ki_textvp: *mut vnode,
    pub ki_fd: *mut filedesc,
    pub ki_vmspace: *mut vmspace,
    pub ki_wchan: *mut ::std::os::raw::c_void,
    pub ki_pid: pid_t,
    pub ki_ppid: pid_t,
    pub ki_pgid: pid_t,
    pub ki_tpgid: pid_t,
    pub ki_sid: pid_t,
    pub ki_tsid: pid_t,
    pub ki_jobc: ::std::os::raw::c_short,
    pub ki_spare_short1: ::std::os::raw::c_short,
    pub ki_tdev_freebsd11: u32,
    pub ki_siglist: sigset_t,
    pub ki_sigmask: sigset_t,
    pub ki_sigignore: sigset_t,
    pub ki_sigcatch: sigset_t,
    pub ki_uid: uid_t,
    pub ki_ruid: uid_t,
    pub ki_svuid: uid_t,
    pub ki_rgid: gid_t,
    pub ki_svgid: gid_t,
    pub ki_ngroups: ::std::os::raw::c_short,
    pub ki_spare_short2: ::std::os::raw::c_short,
    pub ki_groups: [gid_t; 16usize],
    pub ki_size: vm_size_t,
    pub ki_rssize: segsz_t,
    pub ki_swrss: segsz_t,
    pub ki_tsize: segsz_t,
    pub ki_dsize: segsz_t,
    pub ki_ssize: segsz_t,
    pub ki_xstat: u_short,
    pub ki_acflag: u_short,
    pub ki_pctcpu: fixpt_t,
    pub ki_estcpu: u_int,
    pub ki_slptime: u_int,
    pub ki_swtime: u_int,
    pub ki_cow: u_int,
    pub ki_runtime: u_int64_t,
    pub ki_start: timeval,
    pub ki_childtime: timeval,
    pub ki_flag: ::std::os::raw::c_long,
    pub ki_kiflag: ::std::os::raw::c_long,
    pub ki_traceflag: ::std::os::raw::c_int,
    pub ki_stat: ::std::os::raw::c_char,
    pub ki_nice: ::std::os::raw::c_schar,
    pub ki_lock: ::std::os::raw::c_char,
    pub ki_rqindex: ::std::os::raw::c_char,
    pub ki_oncpu_old: u_char,
    pub ki_lastcpu_old: u_char,
    pub ki_tdname: [::std::os::raw::c_char; 17usize],
    pub ki_wmesg: [::std::os::raw::c_char; 9usize],
    pub ki_login: [::std::os::raw::c_char; 18usize],
    pub ki_lockname: [::std::os::raw::c_char; 9usize],
    pub ki_comm: [::std::os::raw::c_char; 20usize],
    pub ki_emul: [::std::os::raw::c_char; 17usize],
    pub ki_loginclass: [::std::os::raw::c_char; 18usize],
    pub ki_moretdname: [::std::os::raw::c_char; 4usize],
    pub ki_sparestrings: [::std::os::raw::c_char; 46usize],
    pub ki_spareints: [::std::os::raw::c_int; 2usize],
    pub ki_tdev: u64,
    pub ki_oncpu: ::std::os::raw::c_int,
    pub ki_lastcpu: ::std::os::raw::c_int,
    pub ki_tracer: ::std::os::raw::c_int,
    pub ki_flag2: ::std::os::raw::c_int,
    pub ki_fibnum: ::std::os::raw::c_int,
    pub ki_cr_flags: u_int,
    pub ki_jid: ::std::os::raw::c_int,
    pub ki_numthreads: ::std::os::raw::c_int,
    pub ki_tid: lwpid_t,
    pub ki_pri: priority,
    pub ki_rusage: rusage,
    pub ki_rusage_ch: rusage,
    pub ki_pcb: *mut pcb,
    pub ki_kstack: *mut ::std::os::raw::c_void,
    pub ki_udata: *mut ::std::os::raw::c_void,
    pub ki_tdaddr: *mut thread,
    pub ki_spareptrs: [*mut ::std::os::raw::c_void; 6usize],
    pub ki_sparelongs: [::std::os::raw::c_long; 12usize],
    pub ki_sflag: ::std::os::raw::c_long,
    pub ki_tdflags: ::std::os::raw::c_long,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct user {
    pub u_stats: pstats,
    pub u_kproc: kinfo_proc,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct amd64tss {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct witness {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct file {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vnode {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysent {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cdev_priv {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tty {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct seltd {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rl_q_entry {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct umtx_q {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct plimit {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct vnet {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct itimers {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sysentvec {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct label {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ktr_request {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct shmmap_state {
    pub _address: u8,
}
